(defvar minion-mode-hook nil)

(defvar minion-mode-map
  (let ((minion-mode-map (make-keymap)))
    (define-key minion-mode-map "\C-j" 'newline-and-indent)
    (define-key minion-mode-map "\C-c \C-c" 'comment-region)
    minion-mode-map)
  "Keymap for MINION major mode")

(add-to-list 'auto-mode-alist '("\\.minion\\'" . minion-mode))

(defface symbol-face '((t (:foreground "blue"))) "foo face")
(defvar symbol-face 'symbol-face)
(set-face-bold-p symbol-face t)

(defface paren-face '((t (:foreground "darkgreen"))) "paren face")
(defvar paren-face 'paren-face)
(set-face-bold-p paren-face t)

(defvar minion-font-lock-keywords
   '(("MINION" . font-lock-keyword-face)
     ("VARIABLES" . symbol-face)
     ("SEARCH" . symbol-face)
     ("EOF" . symbol-face)
     ("PRINT" . font-lock-keyword-face)
     ("VARORDER" . font-lock-keyword-face)
     ("VALORDER" . font-lock-keyword-face)
     ("CONSTRAINTS" . symbol-face)
     ("ALIAS" . font-lock-keyword-face)
     ("sumleq" . font-lock-type-face)
     ("sumgeq" . font-lock-type-face)
     ("DISCRETE" . font-lock-type-face)
     ("BOOL" . font-lock-type-face)
     ("BOUNDS" . font-lock-type-face)
     ("SPARSE" . font-lock-type-face)
     ("alldiff" . font-lock-type-face)
     ("gacalldiff" . font-lock-type-face)
     ("abs" . font-lock-type-face)
     ("difference" . font-lock-type-face)
     ("div" . font-lock-type-face)
     ("modulo" . font-lock-type-face)
     ("minuseq" . font-lock-type-face)
     ("occurrenceleq" . font-lock-type-face)
     ("occurrencegeq" . font-lock-type-face)
     ("power" . font-lock-type-face)
     ("table" . font-lock-type-face)
     ("watchelement" . font-lock-type-face)
     ("element" . font-lock-type-face)
     ("ineq" . font-lock-type-face)
     ("eq" . font-lock-type-face)
     ("min" . font-lock-type-face)
     ("max" . font-lock-type-face)
     ("product" . font-lock-type-face)
     ("diseq" . font-lock-type-face)
     ("gcc" . font-lock-type-face)
     ("reify" . font-lock-keyword-face)
     ("weighted" . font-lock-type-face)
     ("lexleq" . font-lock-type-face)
     ("lexless" . font-lock-type-face)
     ("watch" . font-lock-type-face)
     ("\\\:" . symbol-face)
     ("\\\]" . paren-face)
     ("\\\[" . paren-face)
     ("\\\}" . paren-face)
     ("\\\{" . paren-face)
     ("\)" . paren-face)
     ("\(" . paren-face)
     ("\\\." . symbol-face)
     ("\\\," . symbol-face)
     ("\\\+" . symbol-face)
     ("!=" . symbol-face)
     ("\=" . symbol-face)
     ("\\\*" . symbol-face)
     ("\>" . symbol-face)
     ("\\\\" . symbol-face)
     ("\\\/" . symbol-face)
     )
   "Font-lock keywords for `my-new-mode'.
         See `font-lock-keywords' for a description of the format.")





;; (defconst minion-font-lock-keywords-1
;;   (list
;;    '((concat "<" (regexp-opt '("forall" "matrix") t) ">") 
;;      . font-lock-keyword-face)
;;    '("\\('\\w*'\\)" . font-lock-builtin-face))
;; ;   '("\\<\\(matrix\\)>" . font-lock-builtin-face))
;;   "Minimal highlighting expressions for MINION mode")

;; (defvar minion-font-lock-keywords minion-font-lock-keywords-1
;;   "Default highlighting expressions for MINION mode")



(defun minion-indent-line ()
  "Indent current line as WPDL code"
  (interactive)
  (beginning-of-line)

  (indent-line-to 3))




(defvar minion-mode-syntax-table
  (let ((minion-mode-syntax-table (make-syntax-table)))

;    (modify-syntax-entry ?_ "w" minion-mode-syntax-table)
    (modify-syntax-entry ?# "<" minion-mode-syntax-table)
    (modify-syntax-entry ?\n ">" minion-mode-syntax-table)


    minion-mode-syntax-table)
  "Syntax table for minion-mode")






(define-derived-mode minion-mode fundamental-mode "Minion"
  "Major mode for editing Minion files."
  (set (make-local-variable 'font-lock-defaults) '(minion-font-lock-keywords))
  (set (make-local-variable 'indent-line-function) 'minion-indent-line))

(provide 'minion-mode)


