/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser.components;

import translator.xcsp2ep.parser.PredicateTokens;
import translator.xcsp2ep.parser.components.PGlobalConstraint;
import translator.xcsp2ep.parser.components.PVariable;

public class PWeightedSum
extends PGlobalConstraint {
    private int[] coeffs;
    private PredicateTokens.RelationalOperator operator;
    private int limit;

    public int[] getCoeffs() {
        return this.coeffs;
    }

    public PredicateTokens.RelationalOperator getOperator() {
        return this.operator;
    }

    public PWeightedSum(String string, PVariable[] pVariableArray, int[] nArray, PredicateTokens.RelationalOperator relationalOperator, int n) {
        super(string, pVariableArray);
        this.coeffs = nArray;
        this.operator = relationalOperator;
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        String string = super.toString() + " : weightedSum\n\t";
        for (int i = 0; i < this.coeffs.length; ++i) {
            string = string + this.coeffs[i] + "*" + this.scope[i].getName() + " ";
        }
        string = string + PredicateTokens.RelationalOperator.getStringFor(this.operator) + " " + this.limit;
        return string;
    }

    public boolean isGuaranteedToBeOverflowFree() {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < this.scope.length; ++i) {
            int[] nArray = this.scope[i].getDomain().getValues();
            int n2 = Math.max(Math.abs(nArray[0]), Math.abs(nArray[nArray.length - 1]));
            n += Math.abs(this.coeffs[i]) * n2;
            d += (double)(Math.abs(this.coeffs[i]) * n2);
        }
        return (double)n == d && !Double.isInfinite(d);
    }
}

