/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser.components;

public class PRelation {
    private String name;
    private int arity;
    private int nbTuples;
    private String semantics;
    private int[][] tuples;
    private int[] weights;
    private int defaultCost;
    private int maximalCost;

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public String getSemantics() {
        return this.semantics;
    }

    public int[][] getTuples() {
        return this.tuples;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public int getDefaultCost() {
        return this.defaultCost;
    }

    public int getMaximalCost() {
        return this.maximalCost;
    }

    public PRelation(String string, int n, int n2, String string2, int[][] nArray, int[] nArray2, int n3) {
        this.name = string;
        this.arity = n;
        this.nbTuples = n2;
        this.semantics = string2;
        this.tuples = nArray;
        this.weights = nArray2;
        this.defaultCost = n3;
        if (nArray2 == null) {
            this.maximalCost = 1;
        } else {
            this.maximalCost = n3;
            for (int n4 : nArray2) {
                if (n4 <= this.maximalCost) continue;
                this.maximalCost = n4;
            }
        }
    }

    public PRelation(String string, int n, int n2, String string2, int[][] nArray) {
        this(string, n, n2, string2, nArray, null, string2.equals("supports") ? 1 : 0);
    }

    public String toString() {
        int n = 5;
        String string = "  relation " + this.name + " with arity=" + this.arity + ", semantics=" + this.semantics + ", nbTuples=" + this.nbTuples + ", defaultCost=" + this.defaultCost + " : ";
        for (int i = 0; i < Math.min(this.nbTuples, n); ++i) {
            string = string + "(";
            for (int j = 0; j < this.arity; ++j) {
                string = string + this.tuples[i][j] + (j < this.arity - 1 ? "," : "");
            }
            string = string + ") ";
            if (this.weights == null) continue;
            string = string + " with cost=" + this.weights[i] + ", ";
        }
        return string + (this.nbTuples > n ? "..." : "");
    }

    public boolean isSimilarTo(int n, int n2, String string, int[][] nArray) {
        if (string.equals("soft")) {
            throw new IllegalArgumentException();
        }
        if (this.arity != n || this.nbTuples != n2) {
            return false;
        }
        if (!this.semantics.equals(string)) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (this.tuples[i][j] == nArray[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String getStringListOfTuples() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tuples.length; ++i) {
            for (int j = 0; j < this.tuples[i].length; ++j) {
                stringBuffer.append(this.tuples[i][j]);
                if (j == this.tuples[i].length - 1) continue;
                stringBuffer.append(' ');
            }
            if (i == this.tuples.length - 1) continue;
            stringBuffer.append('|');
        }
        return stringBuffer.toString();
    }
}

