/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser.components;

import java.util.Arrays;

public class PDomain {
    private String name;
    private int[] values;

    public String getName() {
        return this.name;
    }

    public int[] getValues() {
        return this.values;
    }

    public int getMaxAbsoluteValue() {
        return Math.max(Math.abs(this.values[0]), Math.abs(this.values[this.values.length - 1]));
    }

    public PDomain(String string, int[] nArray) {
        this.name = string;
        this.values = nArray;
    }

    public boolean contains(int n) {
        return Arrays.binarySearch(this.values, n) >= 0;
    }

    public String toString() {
        int n = 5;
        String string = "  domain " + this.name + " with " + this.values.length + " values : ";
        for (int i = 0; i < Math.min(this.values.length, n); ++i) {
            string = string + this.values[i] + " ";
        }
        return string + (this.values.length > n ? "..." : "");
    }

    public String getStringListOfValues() {
        int n = this.values[0];
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.values.length; ++i) {
            int n2 = this.values[i];
            if (n2 != n + 1) {
                if (bl) {
                    stringBuffer.append(n + "");
                    bl = false;
                } else {
                    stringBuffer.append(n);
                }
                stringBuffer.append(" ");
            } else if (!bl) {
                stringBuffer.append("" + n + "..");
                bl = true;
            }
            n = n2;
        }
        if (bl) {
            stringBuffer.append(n + "");
        } else {
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }
}

