/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser.components;

import translator.xcsp2ep.parser.components.PGlobalConstraint;
import translator.xcsp2ep.parser.components.PVariable;

public class PCumulative
extends PGlobalConstraint {
    private int nbTasks;
    private Absent absent;
    private int limit;

    public PCumulative(String string, PVariable[] pVariableArray, Absent absent, int n) {
        super(string, pVariableArray);
        this.nbTasks = pVariableArray.length / (absent == Absent.NO_ONE ? 4 : 3);
        this.absent = absent;
        this.limit = n;
    }

    public PCumulative(String string, PVariable[] pVariableArray, int n, int n2) {
        this(string, pVariableArray, Absent.getAbsentFor(n), n2);
    }

    public String toString() {
        String string = super.toString() + " : cumulative\n\t";
        string = string + "nbTasks=" + this.nbTasks + "  absent=" + Absent.getStringFor(this.absent) + " limit=" + this.limit;
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Absent {
        NO_ONE,
        ORIGIN,
        DURATION,
        END;


        public static Absent getAbsentFor(int n) {
            if (n == -1) {
                return NO_ONE;
            }
            if (n == 0) {
                return ORIGIN;
            }
            if (n == 1) {
                return DURATION;
            }
            return END;
        }

        public static String getStringFor(Absent absent) {
            if (absent == NO_ONE) {
                return "no";
            }
            if (absent == ORIGIN) {
                return "origin";
            }
            if (absent == DURATION) {
                return "duration";
            }
            return "end";
        }
    }
}

