/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLManager {
    private static boolean useStyleSheet = true;

    private static void dealWithException(Exception exception) {
        if (exception instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)exception;
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception2 = sAXParseException.getException() == null ? sAXParseException : sAXParseException.getException();
            exception2.printStackTrace();
        } else if (exception instanceof SAXException) {
            SAXException sAXException = (SAXException)exception;
            Exception exception3 = sAXException.getException() == null ? sAXException : sAXException.getException();
            exception3.printStackTrace();
        } else if (exception instanceof TransformerConfigurationException) {
            TransformerConfigurationException transformerConfigurationException = (TransformerConfigurationException)exception;
            System.out.println("\n** Transformer Factory error\n" + exception.getMessage());
            Throwable throwable = transformerConfigurationException.getException() == null ? transformerConfigurationException : transformerConfigurationException.getException();
            throwable.printStackTrace();
        } else if (exception instanceof TransformerException) {
            TransformerException transformerException = (TransformerException)exception;
            System.out.println("\n** Transformation error" + exception.getMessage());
            Throwable throwable = transformerException.getException() == null ? transformerException : transformerException.getException();
            throwable.printStackTrace();
        } else {
            System.out.println(exception);
            exception.printStackTrace();
        }
        System.exit(1);
    }

    public static Document createNewDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            XMLManager.dealWithException(parserConfigurationException);
            return null;
        }
    }

    public static Document load(InputStream inputStream, URL uRL) {
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            if (uRL != null) {
                object2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                object = ((SchemaFactory)object2).newSchema(uRL);
                documentBuilderFactory.setSchema((Schema)object);
            }
            object2 = documentBuilderFactory.newDocumentBuilder();
            ((DocumentBuilder)object2).setErrorHandler(new ErrorHandler());
            object = ((DocumentBuilder)object2).parse(inputStream);
            return object;
        }
        catch (Exception exception) {
            XMLManager.dealWithException(exception);
            return null;
        }
    }

    public static Document load(File file, URL uRL) {
        try {
            return XMLManager.load(new FileInputStream(file), uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + file.getName() + " does not exist");
            System.exit(1);
            return null;
        }
    }

    public static Document load(InputStream inputStream) {
        return XMLManager.load(inputStream, null);
    }

    public static Document load(File file) {
        return XMLManager.load(file, null);
    }

    public static Document load(String string) {
        if (string.endsWith("xml.bz2")) {
            try {
                Process process = Runtime.getRuntime().exec("bunzip2 -c " + string);
                Document document = XMLManager.load(process.getInputStream());
                process.waitFor();
                process.exitValue();
                process.destroy();
                return document;
            }
            catch (Exception exception) {
                System.out.println("Problem with " + string);
                System.exit(1);
                return null;
            }
        }
        return XMLManager.load(new File(string), null);
    }

    private static Transformer buildTransformer(InputStream inputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (inputStream == null || !useStyleSheet) {
                return transformerFactory.newTransformer();
            }
            Document document = XMLManager.load(inputStream, null);
            DOMSource dOMSource = new DOMSource(document);
            return transformerFactory.newTransformer(dOMSource);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            XMLManager.dealWithException(transformerConfigurationException);
            return null;
        }
    }

    public static void save(Document document, PrintWriter printWriter, InputStream inputStream) {
        try {
            Transformer transformer = XMLManager.buildTransformer(inputStream);
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(printWriter);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            XMLManager.dealWithException(transformerException);
        }
    }

    public static void save(Document document, String string, InputStream inputStream) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            XMLManager.save(document, printWriter, inputStream);
            printWriter.close();
        }
        catch (IOException iOException) {
            XMLManager.dealWithException(iOException);
        }
    }

    public static void save(Document document, String string) {
        XMLManager.save(document, string, null);
    }

    public static void saveInstance(Document document, String string) {
        XMLManager.save(document, string);
    }

    public static Element getElementByTagNameFrom(Element element, String string, int n) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() <= n) {
            return null;
        }
        return (Element)nodeList.item(n);
    }

    public static Element getFirstElementByTagNameFromRoot(Document document, String string) {
        return XMLManager.getElementByTagNameFrom(document.getDocumentElement(), string, 0);
    }

    public static void deleteElementByTagNameFrom(Element element, String string, int n) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() <= n) {
            throw new IllegalArgumentException();
        }
        element.removeChild(nodeList.item(n));
    }

    public static Node getChildElement(Document document, String string, int n) {
        NodeList nodeList = document.getElementsByTagName(string);
        return nodeList.item(n);
    }

    public static void deleteChildElement(Document document, String string, int n) {
        Element element = (Element)document.getElementsByTagName(string).item(0);
        element.removeChild(XMLManager.getChildElement(document, string, n));
    }

    public static String[] displayAttributes(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        String[] stringArray = new String[namedNodeMap.getLength()];
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            stringArray[i] = attr.getValue();
            System.out.println(attr.getName() + " = " + stringArray[i]);
        }
        return stringArray;
    }

    public static void displayElement(Document document, String string) {
        Node node = document.getElementsByTagName(string).item(0);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            XMLManager.displayAttributes(element);
        }
    }

    static class ErrorHandler
    extends DefaultHandler {
        private MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");

        ErrorHandler() {
        }

        private void print(SAXParseException sAXParseException) {
            String string = this.message.format(new Object[]{sAXParseException.getSystemId(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getMessage()});
            System.out.println(string);
        }

        public void warning(SAXParseException sAXParseException) {
            this.print(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) {
            this.print(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            this.print(sAXParseException);
            throw sAXParseException;
        }
    }
}

