/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser;

import java.util.Map;
import org.w3c.dom.Document;
import translator.xcsp2ep.parser.components.PConstraint;
import translator.xcsp2ep.parser.components.PDomain;
import translator.xcsp2ep.parser.components.PPredicate;
import translator.xcsp2ep.parser.components.PRelation;
import translator.xcsp2ep.parser.components.PVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCSPInstance {
    private Document document;
    private String type;
    private String format = "XCSP 2.0";
    private int maxConstraintArity;
    private Map<String, PDomain> mapOfDomains;
    private Map<String, PVariable> mapOfVariables;
    private Map<String, PRelation> mapOfRelations;
    private Map<String, PPredicate> mapOfPredicates;
    private Map<String, PConstraint> mapOfConstraints;
    private PVariable[] variables;
    private int nbExtensionConstraints;
    private int nbIntensionConstraints;
    private int nbGlobalConstraints;
    private String satisfiable;
    private String minViolatedConstraints;

    public XCSPInstance(Document document, String string, String string2, int n, Map<String, PDomain> map, Map<String, PVariable> map2, Map<String, PRelation> map3, Map<String, PPredicate> map4, Map<String, PConstraint> map5, PVariable[] pVariableArray, int n2, int n3, int n4, String string3) {
        this.document = document;
        this.type = string;
        this.maxConstraintArity = n;
        this.mapOfDomains = map;
        this.mapOfVariables = map2;
        this.mapOfRelations = map3;
        this.mapOfPredicates = map4;
        this.mapOfConstraints = map5;
        this.variables = pVariableArray;
        this.nbExtensionConstraints = n2;
        this.nbIntensionConstraints = n3;
        this.nbGlobalConstraints = n4;
        this.satisfiable = string3;
    }

    public PVariable[] getVariables() {
        return this.variables;
    }

    public int getMaxConstraintArity() {
        return this.maxConstraintArity;
    }

    public Map<String, PConstraint> getMapOfConstraints() {
        return this.mapOfConstraints;
    }

    public Map<String, PDomain> getMapOfDomains() {
        return this.mapOfDomains;
    }

    public Map<String, PVariable> getMapOfVariables() {
        return this.mapOfVariables;
    }

    public Map<String, PRelation> getMapOfRelations() {
        return this.mapOfRelations;
    }

    public Map<String, PPredicate> getMapOfPredicates() {
        return this.mapOfPredicates;
    }

    public int getNbExtensionConstraints() {
        return this.nbExtensionConstraints;
    }

    public int getNbIntensionConstraints() {
        return this.nbIntensionConstraints;
    }

    public int getNbGlobalConstraints() {
        return this.nbGlobalConstraints;
    }

    public String getConstraintsCategory() {
        return (this.nbExtensionConstraints > 0 ? "E" : "") + (this.nbIntensionConstraints > 0 ? "I" : "") + (this.nbGlobalConstraints > 0 ? "G" : "");
    }

    public String getSatisfiable() {
        return this.satisfiable;
    }

    public String getMinViolatedConstraints() {
        return this.minViolatedConstraints;
    }

    public String getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public Document getDocument() {
        return this.document;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("XCSP format:" + this.format + " with type " + this.type);
        stringBuffer.append("Variables:\n" + this.mapOfVariables + "\n");
        stringBuffer.append("Domains:\n" + this.mapOfDomains + "\n");
        stringBuffer.append("Predicates:\n" + this.mapOfPredicates + "\n");
        stringBuffer.append("Constraints:\n" + this.mapOfVariables + "\n");
        stringBuffer.append("Relations:\n" + this.mapOfVariables + "\n");
        return stringBuffer.toString();
    }
}

