/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolkit {
    public static final Comparator<int[]> lexicographicComparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < nArray2[i]) {
                    return -1;
                }
                if (nArray[i] <= nArray2[i]) continue;
                return 1;
            }
            return 0;
        }
    };

    public static int executeCommand(String string, PrintWriter printWriter) {
        try {
            Process process = Runtime.getRuntime().exec(string);
            if (printWriter != null) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string3 = string2 = bufferedReader.readLine();
                while (string3 != null) {
                    printWriter.println(string3);
                    string3 = bufferedReader.readLine();
                }
                bufferedReader.close();
                printWriter.flush();
            }
            process.waitFor();
            int n = process.exitValue();
            process.destroy();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return -1;
        }
    }

    public static String getMemoryInformation() {
        Runtime runtime = Runtime.getRuntime();
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###");
        return "used = " + decimalFormat.format(runtime.totalMemory() - runtime.freeMemory()) + " free = " + runtime.freeMemory() + " total = " + runtime.totalMemory() + " max = " + runtime.maxMemory();
    }

    public static int[] buildArrayWithIncrementalValues(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public static void copy(String string, String string2) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[1024];
            int n = bufferedInputStream.read(byArray, 0, byArray.length);
            while (n > 0) {
                bufferedOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray, 0, byArray.length);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static boolean selectInDirectory(List<String> list, File file, int n, FileFilter fileFilter) {
        File file2;
        int n2;
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            file2 = new File(file, (String)objectArray[n2]);
            if (!file2.isFile() || !fileFilter.accept(file2)) continue;
            list.add(file2.getAbsolutePath());
            if (list.size() < n) continue;
            return true;
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            file2 = new File(file, (String)objectArray[n2]);
            if (!file2.isDirectory() || !Toolkit.selectInDirectory(list, file2, n, fileFilter)) continue;
            return true;
        }
        return false;
    }

    public static String getRawInstanceName(String string) {
        int n = string.lastIndexOf(File.separator) != -1 ? string.lastIndexOf(File.separator) + 1 : 0;
        int n2 = string.lastIndexOf(".") != -1 ? string.lastIndexOf(".") : string.length();
        return n > n2 ? string.substring(n) : string.substring(n, n2);
    }

    public static String getRelativeParentPackageNameOf(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        return string2.substring(string2.lastIndexOf(".") + 1);
    }

    public static String getRelativeClassNameOf(Class clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static String getRelativeClassNameOf(Object object) {
        String string = object.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static String getSeparator(int n) {
        return n == 0 ? "," : "\n";
    }

    public static String getXMLBaseNameOf(String string) {
        int n = string.lastIndexOf(File.separator);
        n = n == -1 ? 0 : n + 1;
        int n2 = string.toLowerCase().lastIndexOf(".xml");
        n2 = n2 == -1 ? string.length() : n2;
        return string.substring(n, n2);
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static Integer parseInteger(String string) {
        try {
            int n = Integer.parseInt(string);
            return new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long parseLong(String string) {
        try {
            long l = Long.parseLong(string);
            return new Long(l);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String getFormattedCurrentDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return n + "_" + decimalFormat.format(n2) + "_" + decimalFormat.format(n3) + "_" + decimalFormat.format(n4) + "_" + decimalFormat.format(n5);
    }

    public static String getFormattedMemorySize(long l) {
        long l2 = l / 1000000L;
        long l3 = l / 1000L;
        return l2 + "M" + (l3 -= l2 * 1000L);
    }

    public static long getFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
    }

    public static long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static String getFormattedUsedMemorySize() {
        return Toolkit.getFormattedMemorySize(Toolkit.getUsedMemory());
    }

    public static String getAllocatedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return Toolkit.getFormattedMemorySize(runtime.totalMemory());
    }

    public static boolean areIdentical(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void copy(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    public static int searchIn(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static String buildStringFromTokens(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String[] buildTokensFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String insertWhitespaceAround(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = 0; !bl && j < string2.length(); ++j) {
                if (string2.charAt(j) != c) continue;
                bl = true;
            }
            if (bl) {
                stringBuffer.append(" ");
                stringBuffer.append(c);
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

