/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import translator.xcsp2ep.parser.InstanceTokens;
import translator.xcsp2ep.parser.PredicateTokens;
import translator.xcsp2ep.parser.Toolkit;
import translator.xcsp2ep.parser.XCSPInstance;
import translator.xcsp2ep.parser.XMLManager;
import translator.xcsp2ep.parser.components.PAllDifferent;
import translator.xcsp2ep.parser.components.PConstraint;
import translator.xcsp2ep.parser.components.PCumulative;
import translator.xcsp2ep.parser.components.PDomain;
import translator.xcsp2ep.parser.components.PElement;
import translator.xcsp2ep.parser.components.PExtensionConstraint;
import translator.xcsp2ep.parser.components.PIntensionConstraint;
import translator.xcsp2ep.parser.components.PPredicate;
import translator.xcsp2ep.parser.components.PRelation;
import translator.xcsp2ep.parser.components.PVariable;
import translator.xcsp2ep.parser.components.PWeightedSum;

public class InstanceParser {
    public static final String VERSION = "version 2.1.1 (January 18, 2008)";
    private Document document;
    private String type;
    private String format;
    private int maxConstraintArity;
    private Map<String, PDomain> mapOfDomains;
    private Map<String, PVariable> mapOfVariables;
    private Map<String, PRelation> mapOfRelations;
    private Map<String, PPredicate> mapOfPredicates;
    private Map<String, PConstraint> mapOfConstraints;
    private PVariable[] variables;
    private int nbExtensionConstraints;
    private int nbIntensionConstraints;
    private int nbGlobalConstraints;
    private String satisfiable;
    private String minViolatedConstraints;
    private boolean displayInstance = true;
    private int[] weights;

    public String getType() {
        return this.type;
    }

    public void loadInstance(String string) {
        this.document = XMLManager.load(string);
    }

    private void parsePresentation(Element element) {
        String string = element.getAttribute("maxConstraintArity".trim());
        this.maxConstraintArity = string.length() == 0 || string.equals("?") ? -1 : Integer.parseInt(string);
        this.type = element.getAttribute("type".trim());
        this.type = this.type.length() == 0 || this.type.equals("?") ? "CSP" : this.type;
        this.format = element.getAttribute("format".trim());
        if (this.displayInstance) {
            System.out.println("Instance with maxConstraintArity=" + this.maxConstraintArity + " type=" + this.type + " format=" + this.format);
        }
        this.satisfiable = (string = element.getAttribute("nbSolutions").trim()).length() == 0 || string.equals("?") ? "unknown" : (string.equals("0") ? "false" : "true");
        string = element.getAttribute("minViolatedConstraints").trim();
        this.minViolatedConstraints = this.satisfiable.equals("true") ? "0" : (string.length() == 0 || string.equals("?") ? "unknown" : string);
    }

    private int[] parseDomainValues(int n, String string) {
        int n2 = 0;
        int[] nArray = new int[n];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.indexOf("..");
            if (n3 == -1) {
                nArray[n2++] = Integer.parseInt(string2);
                continue;
            }
            int n4 = Integer.parseInt(string2.substring(0, n3));
            int n5 = Integer.parseInt(string2.substring(n3 + "..".length()));
            int n6 = n4;
            while (n6 <= n5) {
                nArray[n2++] = n6++;
            }
        }
        return nArray;
    }

    private PDomain parseDomain(Element element) {
        int[] nArray;
        String string = element.getAttribute("name");
        int n = Integer.parseInt(element.getAttribute("nbValues"));
        if (n != (nArray = this.parseDomainValues(n, element.getTextContent())).length) {
            throw new RuntimeException();
        }
        return new PDomain(string, nArray);
    }

    private void parseDomains(Element element) {
        this.mapOfDomains = new HashMap<String, PDomain>();
        int n = Integer.parseInt(element.getAttribute("nbDomains"));
        if (this.displayInstance) {
            System.out.println("=> " + n + " domains");
        }
        NodeList nodeList = element.getElementsByTagName("domain");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PDomain pDomain = this.parseDomain((Element)nodeList.item(i));
            this.mapOfDomains.put(pDomain.getName(), pDomain);
            if (!this.displayInstance) continue;
            System.out.println(pDomain);
        }
    }

    private PVariable parseVariable(Element element) {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("domain");
        return new PVariable(string, this.mapOfDomains.get(string2));
    }

    private void parseVariables(Element element) {
        this.mapOfVariables = new HashMap<String, PVariable>();
        int n = Integer.parseInt(element.getAttribute("nbVariables"));
        if (this.displayInstance) {
            System.out.println("=> " + n + " variables");
        }
        this.variables = new PVariable[n];
        NodeList nodeList = element.getElementsByTagName("variable");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PVariable pVariable = this.parseVariable((Element)nodeList.item(i));
            this.mapOfVariables.put(pVariable.getName(), pVariable);
            this.variables[i] = pVariable;
            if (!this.displayInstance) continue;
            System.out.println(pVariable);
        }
    }

    private int[][] parseRelationTuples(int n, int n2, String string) {
        int[][] nArray = new int[n][n2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f|");
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[i][j] = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        return nArray;
    }

    private int[][] parseSoftRelationTuples(int n, int n2, String string) {
        int[][] nArray = new int[n][n2];
        this.weights = new int[n];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f|");
        int n3 = -2;
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            int n4 = string2.lastIndexOf(":");
            if (n4 != -1) {
                n3 = Integer.parseInt(string2.substring(0, n4));
                string2 = string2.substring(n4 + 1);
            }
            this.weights[i] = n3;
            nArray[i][0] = Integer.parseInt(string2);
            for (int j = 1; j < n2; ++j) {
                nArray[i][j] = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        return nArray;
    }

    private PRelation parseRelation(Element element) {
        String string = element.getAttribute("name");
        int n = Integer.parseInt(element.getAttribute("arity"));
        int n2 = Integer.parseInt(element.getAttribute("nbTuples"));
        String string2 = element.getAttribute("semantics");
        if (string2.equals("soft")) {
            int[][] nArray = this.parseSoftRelationTuples(n2, n, element.getTextContent());
            String string3 = element.getAttribute("defaultCost");
            int n3 = string3.equals("infinity") ? Integer.MAX_VALUE : Integer.parseInt(string3);
            return new PRelation(string, n, n2, string2, nArray, this.weights, n3);
        }
        int[][] nArray = this.parseRelationTuples(n2, n, element.getTextContent());
        return new PRelation(string, n, n2, string2, nArray);
    }

    private void parseRelations(Element element) {
        this.mapOfRelations = new HashMap<String, PRelation>();
        if (element == null) {
            return;
        }
        int n = Integer.parseInt(element.getAttribute("nbRelations"));
        if (this.displayInstance) {
            System.out.println("=> " + n + " relations");
        }
        NodeList nodeList = element.getElementsByTagName("relation");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PRelation pRelation = this.parseRelation((Element)nodeList.item(i));
            this.mapOfRelations.put(pRelation.getName(), pRelation);
            if (!this.displayInstance) continue;
            System.out.println(pRelation);
        }
    }

    private PPredicate parsePredicate(Element element) {
        String string = element.getAttribute("name");
        Element element2 = (Element)element.getElementsByTagName("parameters").item(0);
        Element element3 = (Element)element.getElementsByTagName("expression").item(0);
        Element element4 = (Element)element3.getElementsByTagName("functional").item(0);
        return new PPredicate(string, element2.getTextContent(), element4.getTextContent());
    }

    private void parsePredicates(Element element) {
        this.mapOfPredicates = new HashMap<String, PPredicate>();
        if (element == null) {
            return;
        }
        int n = Integer.parseInt(element.getAttribute("nbPredicates"));
        if (this.displayInstance) {
            System.out.println("=> " + n + " predicates");
        }
        NodeList nodeList = element.getElementsByTagName("predicate");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PPredicate pPredicate = this.parsePredicate((Element)nodeList.item(i));
            this.mapOfPredicates.put(pPredicate.getName(), pPredicate);
            if (!this.displayInstance) continue;
            System.out.println(pPredicate);
        }
    }

    private PVariable[] parseScope(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        PVariable[] pVariableArray = new PVariable[stringTokenizer.countTokens()];
        for (int i = 0; i < pVariableArray.length; ++i) {
            pVariableArray[i] = this.mapOfVariables.get(stringTokenizer.nextToken());
        }
        return pVariableArray;
    }

    private int searchIn(String string, PVariable[] pVariableArray) {
        for (int i = 0; i < pVariableArray.length; ++i) {
            if (!pVariableArray[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private PConstraint parseElementConstraint(String string, Element element) {
        Object object;
        String string2 = Toolkit.insertWhitespaceAround(element.getTextContent(), "[]{}");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f");
        ArrayList<PVariable> arrayList = new ArrayList<PVariable>();
        PVariable pVariable = this.mapOfVariables.get(stringTokenizer.nextToken());
        arrayList.add(pVariable);
        stringTokenizer.nextToken();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string3 = stringTokenizer.nextToken();
        while (!string3.equals("]")) {
            object = this.mapOfVariables.get(string3);
            if (object == null) {
                object = Integer.parseInt(string3);
            } else {
                arrayList.add((PVariable)object);
            }
            arrayList2.add(object);
            string3 = stringTokenizer.nextToken();
        }
        string3 = stringTokenizer.nextToken();
        object = this.mapOfVariables.get(string3);
        if (object == null) {
            object = Integer.parseInt(string3);
        } else {
            arrayList.add((PVariable)object);
        }
        return new PElement(string, arrayList.toArray(new PVariable[arrayList.size()]), pVariable, arrayList2.toArray(new Object[arrayList2.size()]), object);
    }

    private PConstraint parseWeightedSumConstraint(String string, PVariable[] pVariableArray, Element element) {
        int n;
        NodeList nodeList = element.getChildNodes();
        StringTokenizer stringTokenizer = new StringTokenizer(nodeList.item(0).getTextContent(), " \t\n\r\f[{}]");
        int[] nArray = new int[pVariableArray.length];
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = n = this.searchIn(stringTokenizer.nextToken(), pVariableArray);
            nArray[n3] = nArray[n3] + n2;
        }
        PredicateTokens.RelationalOperator relationalOperator = PredicateTokens.RelationalOperator.getRelationalOperatorFor(nodeList.item(1).getNodeName());
        n = Integer.parseInt(nodeList.item(2).getTextContent().trim());
        return new PWeightedSum(string, pVariableArray, nArray, relationalOperator, n);
    }

    private PConstraint parseCumulativeConstraint(String string, PVariable[] pVariableArray, Element element) {
        int n;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength() == 1 ? -1 : new StringTokenizer(nodeList.item(0).getTextContent(), " \t\n\r\f[]{}").countTokens();
        StringTokenizer stringTokenizer = new StringTokenizer(element.getTextContent(), " \t\n\r\f[]{}");
        for (n = 0; n < pVariableArray.length; ++n) {
            pVariableArray[n] = this.mapOfVariables.get(stringTokenizer.nextToken());
        }
        n = Integer.parseInt(stringTokenizer.nextToken());
        return new PCumulative(string, pVariableArray, n2, n);
    }

    private PConstraint parseConstraint(Element element) {
        String string = element.getAttribute("name");
        int n = Integer.parseInt(element.getAttribute("arity"));
        if (n > this.maxConstraintArity) {
            this.maxConstraintArity = n;
        }
        PVariable[] pVariableArray = this.parseScope(element.getAttribute("scope"));
        String string2 = element.getAttribute("reference");
        if (this.mapOfRelations.containsKey(string2)) {
            ++this.nbExtensionConstraints;
            return new PExtensionConstraint(string, pVariableArray, this.mapOfRelations.get(string2));
        }
        if (this.mapOfPredicates.containsKey(string2)) {
            Element element2 = (Element)element.getElementsByTagName("parameters").item(0);
            ++this.nbIntensionConstraints;
            return new PIntensionConstraint(string, pVariableArray, this.mapOfPredicates.get(string2), element2.getTextContent());
        }
        ++this.nbGlobalConstraints;
        String string3 = string2.toLowerCase();
        Element element3 = (Element)element.getElementsByTagName("parameters").item(0);
        if (string3.equals(InstanceTokens.getLowerCaseGlobalNameOf("allDifferent"))) {
            return new PAllDifferent(string, pVariableArray);
        }
        if (string3.equals(InstanceTokens.getLowerCaseGlobalNameOf("element"))) {
            return this.parseElementConstraint(string, element3);
        }
        if (string3.equals(InstanceTokens.getLowerCaseGlobalNameOf("weightedSum"))) {
            return this.parseWeightedSumConstraint(string, pVariableArray, element3);
        }
        if (string3.equals(InstanceTokens.getLowerCaseGlobalNameOf("cumulative"))) {
            return this.parseCumulativeConstraint(string, pVariableArray, element3);
        }
        System.out.println("Problem with the reference " + string2);
        return null;
    }

    private void parseConstraints(Element element) {
        this.mapOfConstraints = new HashMap<String, PConstraint>();
        int n = Integer.parseInt(element.getAttribute("nbConstraints"));
        if (this.displayInstance) {
            System.out.print("=> " + n + " constraints");
            if (this.type.equals("WCSP")) {
                int n2 = Integer.parseInt(element.getAttribute("maximalCost"));
                String string = element.getAttribute("initialCost");
                int n3 = string.equals("") ? 0 : Integer.parseInt(string);
                System.out.print(" maximalCost=" + n2 + " initialCost=" + n3);
            }
            System.out.println();
        }
        NodeList nodeList = element.getElementsByTagName("constraint");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PConstraint pConstraint = this.parseConstraint((Element)nodeList.item(i));
            this.mapOfConstraints.put(pConstraint.getName(), pConstraint);
            if (!this.displayInstance) continue;
            System.out.println(pConstraint);
        }
    }

    public void parseOld(boolean bl) {
        this.displayInstance = bl;
        this.parsePresentation((Element)this.document.getDocumentElement().getElementsByTagName("presentation").item(0));
        this.parseDomains((Element)this.document.getDocumentElement().getElementsByTagName("domains").item(0));
        this.parseVariables((Element)this.document.getDocumentElement().getElementsByTagName("variables").item(0));
        this.parseRelations((Element)this.document.getDocumentElement().getElementsByTagName("relations").item(0));
        this.parsePredicates((Element)this.document.getDocumentElement().getElementsByTagName("predicates").item(0));
        this.parseConstraints((Element)this.document.getDocumentElement().getElementsByTagName("constraints").item(0));
    }

    public XCSPInstance parse(boolean bl) {
        this.displayInstance = bl;
        this.parsePresentation((Element)this.document.getDocumentElement().getElementsByTagName("presentation").item(0));
        this.parseDomains((Element)this.document.getDocumentElement().getElementsByTagName("domains").item(0));
        this.parseVariables((Element)this.document.getDocumentElement().getElementsByTagName("variables").item(0));
        this.parseRelations((Element)this.document.getDocumentElement().getElementsByTagName("relations").item(0));
        this.parsePredicates((Element)this.document.getDocumentElement().getElementsByTagName("predicates").item(0));
        this.parseConstraints((Element)this.document.getDocumentElement().getElementsByTagName("constraints").item(0));
        return new XCSPInstance(this.document, this.type, this.format, this.maxConstraintArity, this.mapOfDomains, this.mapOfVariables, this.mapOfRelations, this.mapOfPredicates, this.mapOfConstraints, this.variables, this.nbExtensionConstraints, this.nbIntensionConstraints, this.nbGlobalConstraints, this.satisfiable);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("InstanceParser version 2.1.1 (January 18, 2008)");
            System.out.println("Usage : java ... InstanceParser <instanceName>");
            System.exit(1);
        }
        InstanceParser instanceParser = new InstanceParser();
        instanceParser.loadInstance(stringArray[0]);
        instanceParser.parse(true);
    }
}

