/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep.mapper;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import translator.expression.AllDifferent;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.BoolDomain;
import translator.expression.BoundedIntRange;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.ConstantTuple;
import translator.expression.Domain;
import translator.expression.ElementConstraint;
import translator.expression.Expression;
import translator.expression.Multiplication;
import translator.expression.NonCommutativeRelationalBinaryExpression;
import translator.expression.Objective;
import translator.expression.RelationalAtomExpression;
import translator.expression.RelationalExpression;
import translator.expression.SimpleVariable;
import translator.expression.SingleVariable;
import translator.expression.SparseIntRange;
import translator.expression.Sum;
import translator.expression.TableConstraint;
import translator.expression.Variable;
import translator.expression.VariableArray;
import translator.xcsp2ep.mapper.EssencePModel;
import translator.xcsp2ep.mapper.MapperException;
import translator.xcsp2ep.mapper.functionalsParser.FunctionalsLexer;
import translator.xcsp2ep.mapper.functionalsParser.FunctionalsParser;
import translator.xcsp2ep.parser.PredicateTokens;
import translator.xcsp2ep.parser.XCSPInstance;
import translator.xcsp2ep.parser.components.PAllDifferent;
import translator.xcsp2ep.parser.components.PConstraint;
import translator.xcsp2ep.parser.components.PDomain;
import translator.xcsp2ep.parser.components.PElement;
import translator.xcsp2ep.parser.components.PExtensionConstraint;
import translator.xcsp2ep.parser.components.PGlobalConstraint;
import translator.xcsp2ep.parser.components.PIntensionConstraint;
import translator.xcsp2ep.parser.components.PPredicate;
import translator.xcsp2ep.parser.components.PRelation;
import translator.xcsp2ep.parser.components.PVariable;
import translator.xcsp2ep.parser.components.PWeightedSum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper {
    ArrayList<String> variableNames = new ArrayList();
    HashMap<String, Domain> variablesMap = new HashMap();

    public EssencePModel mapToEssencePrime(XCSPInstance xCSPInstance) throws MapperException, Exception {
        this.mapVariableList(xCSPInstance.getVariables());
        ArrayList<Expression> arrayList = this.mapConstraints(xCSPInstance);
        for (int i = 0; i < arrayList.size(); ++i) {
            Expression expression = arrayList.remove(i);
            for (int j = 0; j < this.variableNames.size(); ++j) {
                String string = this.variableNames.get(j);
                if (!(this.variablesMap.get(this.variableNames.get(j)) instanceof BoolDomain)) continue;
                expression = expression.replaceVariableWithExpression(string, new RelationalAtomExpression(new SingleVariable(string, new BoolDomain())));
            }
            expression.orderExpression();
            Expression expression2 = expression.copy();
            expression = expression.evaluate();
            expression = expression.reduceExpressionTree();
            expression.orderExpression();
            if (expression.getType() == 0) {
                if (((RelationalAtomExpression)expression).getBool()) continue;
                System.out.println("WARNING: instances is not satisfiable - evaluated " + expression2 + " to false.");
                arrayList.add(expression);
                continue;
            }
            arrayList.add(i, expression);
        }
        return new EssencePModel(this.variablesMap, this.variableNames, arrayList, new Objective());
    }

    protected ArrayList<Expression> mapConstraints(XCSPInstance xCSPInstance) throws MapperException, Exception {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = xCSPInstance.getNbGlobalConstraints() + xCSPInstance.getNbExtensionConstraints() + xCSPInstance.getNbIntensionConstraints();
        Map<String, PConstraint> map = xCSPInstance.getMapOfConstraints();
        for (int i = 0; i < n; ++i) {
            PConstraint pConstraint = map.get("C" + i);
            if (pConstraint == null) continue;
            arrayList.add(this.mapConstraint(pConstraint));
        }
        return arrayList;
    }

    protected Expression mapConstraint(PConstraint pConstraint) throws MapperException, Exception {
        if (pConstraint instanceof PIntensionConstraint) {
            return this.mapIntensionalConstraint((PIntensionConstraint)pConstraint);
        }
        if (pConstraint instanceof PGlobalConstraint) {
            return this.mapGlobalConstraint((PGlobalConstraint)pConstraint);
        }
        if (pConstraint instanceof PExtensionConstraint) {
            return this.mapExtensionalConstraint((PExtensionConstraint)pConstraint);
        }
        throw new MapperException("Unknown or unsupported constraint type:" + pConstraint);
    }

    private Expression mapExtensionalConstraint(PExtensionConstraint pExtensionConstraint) throws MapperException {
        PRelation pRelation = pExtensionConstraint.getRelation();
        String string = pRelation.getSemantics();
        if (string.equals("supports") || string.equals("conflicts")) {
            int[][] nArray = pRelation.getTuples();
            if (nArray.length == 0) {
                return new RelationalAtomExpression(string.equals("conflicts"));
            }
            ConstantTuple[] constantTupleArray = new ConstantTuple[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                constantTupleArray[i] = new ConstantTuple(nArray[i]);
            }
            PVariable[] pVariableArray = pExtensionConstraint.getScope();
            if (nArray[0].length != pVariableArray.length) {
                throw new MapperException("Infeasible extensional constraint: tuple-length '" + nArray[0].length + "' does not match scope of variables:" + pVariableArray.length);
            }
            Variable[] variableArray = new Variable[pVariableArray.length];
            for (int i = 0; i < variableArray.length; ++i) {
                variableArray[i] = this.mapVariable(pVariableArray[i]);
            }
            TableConstraint tableConstraint = new TableConstraint(variableArray, constantTupleArray);
            if (string.equals("conflicts")) {
                tableConstraint.setToConflictingTableConstraint(true);
            }
            return tableConstraint;
        }
        throw new MapperException("Cannot map semantics '" + string + "' for extensional constraint (table constraint) yet.");
    }

    private Expression mapGlobalConstraint(PGlobalConstraint pGlobalConstraint) throws MapperException {
        if (pGlobalConstraint instanceof PAllDifferent) {
            PAllDifferent pAllDifferent = (PAllDifferent)pGlobalConstraint;
            AtomExpression[] atomExpressionArray = new ArithmeticAtomExpression[pAllDifferent.getScope().length];
            for (int i = 0; i < atomExpressionArray.length; ++i) {
                atomExpressionArray[i] = new ArithmeticAtomExpression(this.mapVariable(pAllDifferent.getScope()[i]));
            }
            VariableArray variableArray = new VariableArray(atomExpressionArray);
            return new AllDifferent(variableArray);
        }
        if (pGlobalConstraint instanceof PElement) {
            return this.mapElementConstraint((PElement)pGlobalConstraint);
        }
        if (pGlobalConstraint instanceof PWeightedSum) {
            return this.mapWeightedSum((PWeightedSum)pGlobalConstraint);
        }
        throw new MapperException("s UNKNOWN\nc Unknown or unsupported global constraint type:" + pGlobalConstraint);
    }

    private Expression mapIntensionalConstraint(PIntensionConstraint pIntensionConstraint) throws MapperException, Exception {
        String string;
        ArrayList<AtomExpression> arrayList;
        PPredicate pPredicate = pIntensionConstraint.getPredicate();
        Expression expression = this.mapFunctional(pPredicate.getFunctionalExpression());
        Object[] objectArray = pPredicate.getFormalParameters();
        if (objectArray.length != (arrayList = this.mapParameterString(string = pIntensionConstraint.getParameters())).size()) {
            throw new MapperException("Scope of predicate and scope of constraint do not match.\nPredicate scope: " + this.printArrayObjects(objectArray) + "\nConstraint scope: " + arrayList);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i).getType() == 3) {
                expression = expression.insertValueForVariable(((ArithmeticAtomExpression)arrayList.get(i)).getConstant(), (String)objectArray[i]);
                continue;
            }
            if (arrayList.get(i) instanceof ArithmeticAtomExpression) {
                expression = expression.replaceVariableWith(new SimpleVariable((String)objectArray[i]), ((ArithmeticAtomExpression)arrayList.get(i)).getVariable());
                continue;
            }
            if (arrayList.get(i) instanceof RelationalAtomExpression) {
                expression = expression.replaceVariableWith(new SimpleVariable((String)objectArray[i]), ((RelationalAtomExpression)arrayList.get(i)).getVariable());
                continue;
            }
            throw new MapperException("Unknown or unsupported Parameter for Functional:" + arrayList.get(i));
        }
        return expression;
    }

    private Variable mapVariable(PVariable pVariable) throws MapperException {
        return new SingleVariable(pVariable.getName(), this.variablesMap.get(pVariable.getName()));
    }

    private void mapVariableList(PVariable[] pVariableArray) throws MapperException {
        for (int i = 0; i < pVariableArray.length; ++i) {
            PVariable pVariable = pVariableArray[i];
            this.variableNames.add(pVariable.getName());
            int[] nArray = pVariable.getDomain().getValues();
            if (nArray.length == 2 && nArray[0] == 0 && nArray[1] == 1) {
                this.variablesMap.put(pVariable.getName(), new BoolDomain());
                continue;
            }
            this.variablesMap.put(pVariable.getName(), this.mapDomain(pVariable.getDomain()));
        }
    }

    private Domain mapDomain(PDomain pDomain) throws MapperException {
        int[] nArray = pDomain.getValues();
        if (this.isSparseDomain(nArray)) {
            return new SparseIntRange(nArray);
        }
        if (nArray[0] == 0 && nArray[nArray.length - 1] == 1) {
            return new BoolDomain();
        }
        return new BoundedIntRange(nArray[0], nArray[nArray.length - 1]);
    }

    private RelationalExpression mapFunctional(String string) throws Exception {
        FunctionalsParser functionalsParser = new FunctionalsParser(new FunctionalsLexer(new StringReader(string)));
        return (RelationalExpression)functionalsParser.parse().value;
    }

    private ArrayList<AtomExpression> mapParameterString(String string) throws MapperException {
        ArrayList<AtomExpression> arrayList = new ArrayList<AtomExpression>();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        while (string.charAt(n) == '\n' || string.charAt(n) == ' ') {
            string = string.substring(1);
        }
        n = string.length() - 1;
        while (string.charAt(n) == '\n' || string.charAt(n) == ' ') {
            string = string.substring(0, n);
            n = string.length() - 1;
        }
        n = 0;
        while (n < string.length() && string.charAt(n) != '\n') {
            while (n < string.length() && string.charAt(n) != ' ' && string.charAt(n) != '\n') {
                stringBuffer.append(string.charAt(n));
                ++n;
            }
            if (stringBuffer.charAt(0) == 'V') {
                Domain domain = this.variablesMap.get(stringBuffer.toString());
                if (domain == null) {
                    throw new MapperException("Unknown variable '" + stringBuffer.toString() + "'. Has no domain associated with it.");
                }
                if (domain instanceof BoolDomain) {
                    arrayList.add(new RelationalAtomExpression(new SingleVariable(stringBuffer.toString(), domain)));
                } else {
                    arrayList.add(new ArithmeticAtomExpression(new SingleVariable(stringBuffer.toString(), domain)));
                }
            } else {
                arrayList.add(new ArithmeticAtomExpression(new Integer(stringBuffer.toString())));
            }
            stringBuffer = new StringBuffer("");
            if (string.length() <= n) break;
            string = string.substring(n + 1);
            n = 0;
        }
        return arrayList;
    }

    private Expression mapWeightedSum(PWeightedSum pWeightedSum) throws MapperException {
        PVariable[] pVariableArray = pWeightedSum.getScope();
        int[] nArray = pWeightedSum.getCoeffs();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        Variable[] variableArray = new Variable[pVariableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            Multiplication multiplication;
            variableArray[i] = this.mapVariable(pVariableArray[i]);
            if (nArray[i] == 1) {
                if (this.variablesMap.get(variableArray[i].toString()) instanceof BoolDomain) {
                    arrayList.add(new RelationalAtomExpression(variableArray[i]));
                } else {
                    arrayList.add(new ArithmeticAtomExpression(variableArray[i]));
                }
            } else if (nArray[i] == -1) {
                if (this.variablesMap.get(variableArray[i].toString()) instanceof BoolDomain) {
                    arrayList2.add(new RelationalAtomExpression(variableArray[i]));
                } else {
                    arrayList2.add(new ArithmeticAtomExpression(variableArray[i]));
                }
            }
            if (nArray[i] > 1) {
                multiplication = this.variablesMap.get(variableArray[i].toString()) instanceof BoolDomain ? new Multiplication(new Expression[]{new ArithmeticAtomExpression(nArray[i]), new RelationalAtomExpression(variableArray[i])}) : new Multiplication(new Expression[]{new ArithmeticAtomExpression(nArray[i]), new ArithmeticAtomExpression(variableArray[i])});
                arrayList.add(multiplication);
                continue;
            }
            if (nArray[i] >= -1) continue;
            multiplication = this.variablesMap.get(variableArray[i].toString()) instanceof BoolDomain ? new Multiplication(new Expression[]{new ArithmeticAtomExpression(-nArray[i]), new RelationalAtomExpression(variableArray[i])}) : new Multiplication(new Expression[]{new ArithmeticAtomExpression(-nArray[i]), new ArithmeticAtomExpression(variableArray[i])});
            arrayList2.add(multiplication);
        }
        Sum sum = new Sum(arrayList, arrayList2);
        int n = pWeightedSum.getLimit();
        int n2 = this.mapOperator(pWeightedSum.getOperator());
        if (this.isCommutativeOperator(pWeightedSum.getOperator().toString())) {
            return new CommutativeBinaryRelationalExpression(sum, n2, new ArithmeticAtomExpression(n));
        }
        return new NonCommutativeRelationalBinaryExpression(sum, n2, new ArithmeticAtomExpression(n));
    }

    private ElementConstraint mapElementConstraint(PElement pElement) throws MapperException {
        ArithmeticAtomExpression arithmeticAtomExpression;
        ArithmeticAtomExpression arithmeticAtomExpression2 = new ArithmeticAtomExpression(this.mapVariable(pElement.getIndexVariable()));
        Object object = pElement.getValue();
        if (object instanceof PVariable) {
            arithmeticAtomExpression = new ArithmeticAtomExpression(this.mapVariable((PVariable)object));
        } else if (object instanceof Integer) {
            arithmeticAtomExpression = new ArithmeticAtomExpression((Integer)object);
        } else {
            throw new MapperException("Unknown Object '" + object + "' as 'value' for element constraint: " + pElement);
        }
        Object[] objectArray = pElement.getTable();
        AtomExpression[] atomExpressionArray = new AtomExpression[objectArray.length];
        for (int i = 0; i < atomExpressionArray.length; ++i) {
            if (objectArray[i] instanceof PVariable) {
                atomExpressionArray[i] = new ArithmeticAtomExpression(this.mapVariable((PVariable)objectArray[i]));
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                atomExpressionArray[i] = new ArithmeticAtomExpression((Integer)objectArray[i]);
                continue;
            }
            throw new MapperException("Unknown Object '" + objectArray[i] + "' in 'table' for element constraint: " + pElement);
        }
        return new ElementConstraint(new VariableArray(atomExpressionArray), arithmeticAtomExpression2, arithmeticAtomExpression);
    }

    private boolean isCommutativeOperator(String string) throws MapperException {
        return string.equals("add") || string.equals("mul") || string.equals("eq") || string.equals("ne") || string.equals("iff") || string.equals("or") || string.equals("and");
    }

    private int mapOperator(PredicateTokens.RelationalOperator relationalOperator) throws MapperException {
        String string = relationalOperator.toString();
        if (string.equalsIgnoreCase("abs")) {
            return 42;
        }
        if (string.equalsIgnoreCase("add")) {
            return 110;
        }
        if (string.equalsIgnoreCase("and")) {
            return 118;
        }
        if (string.equalsIgnoreCase("div")) {
            return 112;
        }
        if (string.equalsIgnoreCase("eq")) {
            return 101;
        }
        if (string.equalsIgnoreCase("ge")) {
            return 108;
        }
        if (string.equalsIgnoreCase("gt")) {
            return 106;
        }
        if (string.equalsIgnoreCase("if")) {
            return 116;
        }
        if (string.equalsIgnoreCase("iff")) {
            return 115;
        }
        if (string.equalsIgnoreCase("le")) {
            return 104;
        }
        if (string.equalsIgnoreCase("lt")) {
            return 102;
        }
        if (string.equalsIgnoreCase("max")) {
            return 121;
        }
        if (string.equalsIgnoreCase("min")) {
            return 120;
        }
        if (string.equalsIgnoreCase("mod")) {
            return 122;
        }
        if (string.equalsIgnoreCase("mul")) {
            return 113;
        }
        if (string.equalsIgnoreCase("ne")) {
            return 100;
        }
        if (string.equalsIgnoreCase("neg")) {
            return 41;
        }
        if (string.equalsIgnoreCase("not")) {
            return 41;
        }
        if (string.equalsIgnoreCase("or")) {
            return 117;
        }
        if (string.equalsIgnoreCase("pow")) {
            return 114;
        }
        if (string.equalsIgnoreCase("sub")) {
            return 111;
        }
        if (string.equalsIgnoreCase("xor")) {
            return 119;
        }
        throw new MapperException("Unknown or unsupported operator: " + string);
    }

    private boolean isSparseDomain(int[] nArray) throws MapperException {
        boolean bl = true;
        if (nArray.length == 0) {
            throw new MapperException("Empty domain.");
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (n != nArray[i] - 1) {
                bl = false;
            }
            n = nArray[i];
        }
        return !bl;
    }

    public String printArrayObjects(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < objectArray.length - 1; ++i) {
            stringBuffer.append(objectArray[i].toString() + ", ");
        }
        if (objectArray.length > 0) {
            stringBuffer.append(objectArray[objectArray.length - 1].toString());
        }
        return stringBuffer.toString();
    }
}

