/*
 * Decompiled with CFR 0.152.
 */
package translator.xcsp2ep;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import translator.TranslationSettings;
import translator.normaliser.NormalisedModel;
import translator.xcsp2ep.mapper.EssencePModel;
import translator.xcsp2ep.mapper.Mapper;
import translator.xcsp2ep.mapper.MapperException;
import translator.xcsp2ep.parser.InstanceParser;
import translator.xcsp2ep.parser.XCSPInstance;

public class Xcsp2Ep {
    private static String OUTPUT_FILE_NAME;
    private static boolean WRITE_TIME_STATS;
    private static boolean PRINT_INFO;
    TranslationSettings settings;

    public Xcsp2Ep(TranslationSettings translationSettings) {
        WRITE_TIME_STATS = translationSettings.giveTranslationTimeInfo();
        PRINT_INFO = translationSettings.giveTranslationInfo();
        OUTPUT_FILE_NAME = translationSettings.getEssencePrimeOutputFileName();
        this.settings = translationSettings;
    }

    public Xcsp2Ep() {
        this.settings = new TranslationSettings();
        WRITE_TIME_STATS = true;
        PRINT_INFO = true;
        OUTPUT_FILE_NAME = this.settings.getEssencePrimeOutputFileName();
    }

    public static void translateXCSP(String string, String string2) throws MapperException, Exception {
        Xcsp2Ep.writeStartMessage(string);
        long l = System.currentTimeMillis();
        boolean bl = false;
        InstanceParser instanceParser = new InstanceParser();
        instanceParser.loadInstance(string);
        XCSPInstance xCSPInstance = instanceParser.parse(bl);
        Mapper mapper = new Mapper();
        EssencePModel essencePModel = mapper.mapToEssencePrime(xCSPInstance);
        Xcsp2Ep.writeStringIntoFile(string2, essencePModel.toString());
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        Xcsp2Ep.writeEndMessage(string2, d);
    }

    public static String translateXCSP(String string) throws MapperException, Exception {
        Xcsp2Ep.writeStartMessage(string);
        long l = System.currentTimeMillis();
        boolean bl = false;
        InstanceParser instanceParser = new InstanceParser();
        instanceParser.loadInstance(string);
        XCSPInstance xCSPInstance = instanceParser.parse(bl);
        Mapper mapper = new Mapper();
        EssencePModel essencePModel = mapper.mapToEssencePrime(xCSPInstance);
        Xcsp2Ep.writeStringIntoFile(OUTPUT_FILE_NAME, essencePModel.toString());
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        Xcsp2Ep.writeEndMessage(OUTPUT_FILE_NAME, d);
        return essencePModel.toString();
    }

    public NormalisedModel translateToNormalisedModel(String string) throws MapperException, Exception {
        boolean bl = false;
        long l = System.currentTimeMillis();
        InstanceParser instanceParser = new InstanceParser();
        instanceParser.loadInstance(string);
        XCSPInstance xCSPInstance = instanceParser.parse(bl);
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        Xcsp2Ep.writeTimeInfo("XCSP parsing time: " + d + "sec");
        Mapper mapper = new Mapper();
        EssencePModel essencePModel = mapper.mapToEssencePrime(xCSPInstance);
        l = l2;
        l2 = System.currentTimeMillis();
        d = (double)(l2 - l) / 1000.0;
        Xcsp2Ep.writeTimeInfo("Time for Mapping XCSP to Essence': " + d + "sec");
        NormalisedModel normalisedModel = essencePModel.mapToNormalisedModel();
        if (this.settings.getWriteEssencePrimeModelIntoFile()) {
            this.writeStringIntoFileNonStatic(string + ".eprime", essencePModel.toString());
            l = l2;
            l2 = System.currentTimeMillis();
            d = (double)(l2 - l) / 1000.0;
            Xcsp2Ep.writeInfo("Written Essence' model into file: " + string + ".eprime");
            Xcsp2Ep.writeTimeInfo("Writing time:" + d + "sec");
        }
        return normalisedModel;
    }

    private static void writeStringIntoFile(String string, String string2) throws IOException {
        File file = new File(string);
        file.createNewFile();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string2);
        fileWriter.flush();
        fileWriter.close();
    }

    private void writeStringIntoFileNonStatic(String string, String string2) throws IOException {
        File file = new File(string);
        file.createNewFile();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string2);
        fileWriter.flush();
        fileWriter.close();
    }

    public static void writeStartMessage(String string) {
        System.out.println("# Welcome to xcsp2ep v0.1\n# A converter from Format XCSP 2.1 to Essence' 1.b.a\n# Bug reports: andrea@cs.st-and.ac.uk\n\nConverting XCSP file '" + string + "' to Essence' ...");
    }

    public static void writeEndMessage(String string, double d) {
        System.out.println("Conversion successfull.\nWritten Essence' instance into file '" + string + "'.\n" + "Translation time: " + d + " sec\n");
    }

    public static void writeHelpMessage() {
        System.out.println("Usage: xcsp2ep inputFile [outputFile] \n\ninputfile:\tfile that contains XCSP instance\noutputfile:\tfile where Essence' instance should be written into (optional)\n\t\tdefault output file:" + OUTPUT_FILE_NAME + "\nbug reports: andrea@cs.st-and.ac.uk\n");
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                Xcsp2Ep.translateXCSP(stringArray[0]);
            } else if (stringArray.length == 2) {
                Xcsp2Ep.translateXCSP(stringArray[0], stringArray[1]);
            } else {
                Xcsp2Ep.writeHelpMessage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.println("Cannot convert XCSP instance to Essence' instance.\n");
            Xcsp2Ep.writeHelpMessage();
            System.exit(1);
        }
    }

    public static void writeTimeInfo(String string) {
        if (WRITE_TIME_STATS) {
            System.out.println(string);
        }
    }

    private static void writeInfo(String string) {
        if (PRINT_INFO) {
            System.out.println(string);
        }
    }
}

