/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.minion;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.AbsoluteConstraint;
import translator.expression.AbsoluteValue;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Array;
import translator.expression.ArrayDomain;
import translator.expression.ArrayVariable;
import translator.expression.Atmost;
import translator.expression.AtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BinaryNonLinearConstraint;
import translator.expression.BoolDomain;
import translator.expression.BoundedIntRange;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Conjunction;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.ConstantVector;
import translator.expression.Disjunction;
import translator.expression.Domain;
import translator.expression.ElementConstraint;
import translator.expression.Expression;
import translator.expression.GlobalCardinality;
import translator.expression.IndexedArray;
import translator.expression.LexConstraint;
import translator.expression.MinimumConstraint;
import translator.expression.Multiplication;
import translator.expression.Negation;
import translator.expression.NonCommutativeRelationalBinaryExpression;
import translator.expression.Reification;
import translator.expression.RelationalAtomExpression;
import translator.expression.SimpleArray;
import translator.expression.SingleIntRange;
import translator.expression.SingleVariable;
import translator.expression.Sum;
import translator.expression.SumConstraint;
import translator.expression.TableConstraint;
import translator.expression.TableConstraintNew;
import translator.expression.UnaryMinus;
import translator.expression.Variable;
import translator.expression.VariableArray;
import translator.normaliser.NormalisedModel;
import translator.solver.Minion;
import translator.solver.TargetSolver;
import translator.tailor.minion.AllDifferent;
import translator.tailor.minion.DiseqConstraint;
import translator.tailor.minion.Division;
import translator.tailor.minion.Element;
import translator.tailor.minion.EqConstraint;
import translator.tailor.minion.False;
import translator.tailor.minion.IneqConstraint;
import translator.tailor.minion.LexlessConstraint;
import translator.tailor.minion.Minimum;
import translator.tailor.minion.MinionAbsoluteValue;
import translator.tailor.minion.MinionArray;
import translator.tailor.minion.MinionArrayElement;
import translator.tailor.minion.MinionAtom;
import translator.tailor.minion.MinionConstant;
import translator.tailor.minion.MinionConstraint;
import translator.tailor.minion.MinionException;
import translator.tailor.minion.MinionGCC;
import translator.tailor.minion.MinionIndexedArray;
import translator.tailor.minion.MinionModel;
import translator.tailor.minion.MinionSimpleArray;
import translator.tailor.minion.MinionSingleVariable;
import translator.tailor.minion.MinionVariableArray;
import translator.tailor.minion.MinusEq;
import translator.tailor.minion.Modulo;
import translator.tailor.minion.OccurrenceLeq;
import translator.tailor.minion.Power;
import translator.tailor.minion.ProductConstraint;
import translator.tailor.minion.Reify;
import translator.tailor.minion.SumGeqConstraint;
import translator.tailor.minion.SumLeqConstraint;
import translator.tailor.minion.Table;
import translator.tailor.minion.WeightedSumGeqConstraint;
import translator.tailor.minion.WeightedSumLeqConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinionTailor {
    public final String MINION_AUXVAR_NAME = "aux";
    public final String FLATTENED_TO_VECTOR_SUFFIX = "_flattened2Vector";
    int noMinionAuxVars;
    int usedCommonSubExpressions;
    boolean useCommonSubexpressions;
    MinionModel minionModel;
    HashMap<String, int[]> offsetsFromZero;
    NormalisedModel normalisedModel;
    Minion solverSettings;
    HashMap<String, MinionAtom> minionSubExpressions;
    HashMap<String, Integer> subexpressionCount;
    ArrayList<String> subexpressionList;
    HashMap<String, ArithmeticAtomExpression> essenceSubExpressions;
    HashMap<String, Boolean> variableIsDiscrete = new HashMap();
    TranslationSettings settings;
    ArithmeticAtomExpression reifiedSumAuxVar;

    public MinionModel tailorToMinion(NormalisedModel normalisedModel, TranslationSettings translationSettings) throws MinionException {
        this.initialiseMinionTailor(normalisedModel, translationSettings);
        long l = System.currentTimeMillis();
        this.subexpressionCount = this.normalisedModel.getSubexpressionCount();
        this.subexpressionList = this.normalisedModel.getSubexpressionList();
        this.minionModel = new MinionModel(new ArrayList<MinionConstraint>(), this.mapDecisionVariables(), this.normalisedModel.getDecisionVariablesNames(), this.normalisedModel.getAuxVariables(), this.solverSettings, translationSettings, this.essenceSubExpressions, this.minionSubExpressions, this.subexpressionCount);
        this.tailorObjective();
        if (this.settings.giveTranslationTimeInfo()) {
            long l2 = System.currentTimeMillis();
            this.writeTimeInfo("Variable Tailoring Time: " + (double)(l2 - l) / 1000.0 + "sec");
        }
        l = System.currentTimeMillis();
        for (int i = this.normalisedModel.getConstraints().size() - 1; i >= 0; --i) {
            Expression expression = this.normalisedModel.getConstraints().remove(i);
            if (expression.getType() == 0) {
                if (((RelationalAtomExpression)expression).getBool()) continue;
                this.minionModel.addConstraint(new False());
                System.out.println("WARNING: Instance is not satisfiable.");
                continue;
            }
            this.minionModel.addConstraint(this.toMinion(expression));
        }
        this.minionModel.setAmountOfUsedCommonSubExpressions(this.usedCommonSubExpressions);
        this.minionModel.setAmountOfUsedEqualSubExpressions(this.normalisedModel.getAmountOfEqualSubExpressionsUsed());
        this.minionModel.setNoNegatedCSEs(this.normalisedModel.getNoNegatedCSEs());
        this.minionModel.setNoSimpleConjunctionCSEs(this.normalisedModel.getNoSimpleConjunctionCSEs());
        this.minionModel.setNoSimpleDisjunctionCSEs(this.normalisedModel.getNoSimpleDisjunctionCSEs());
        if (this.settings.giveTranslationTimeInfo()) {
            long l3 = System.currentTimeMillis();
            this.writeTimeInfo("Constraint Tailoring Time: " + (double)(l3 - l) / 1000.0 + "sec");
        }
        if (this.settings.applyDirectVariableReusage()) {
            this.minionModel.setEqualAtoms(this.tailorEqualAtoms());
            this.minionModel.applyEqualAtoms();
        }
        if (this.settings.getAuxVarDetails() || this.settings.useCSEVarOrdering()) {
            this.minionModel.setAuxVarDetails(this.normalisedModel.getAuxVarDetailsHashMap());
        }
        return this.minionModel;
    }

    private void initialiseMinionTailor(NormalisedModel normalisedModel, TranslationSettings translationSettings) {
        this.settings = translationSettings;
        this.offsetsFromZero = new HashMap();
        this.normalisedModel = normalisedModel;
        TargetSolver targetSolver = translationSettings.getTargetSolver();
        this.solverSettings = targetSolver instanceof Minion ? (Minion)targetSolver : new Minion(this.settings);
        this.noMinionAuxVars = this.normalisedModel.getAuxVariables().size();
        this.usedCommonSubExpressions = this.normalisedModel.getAmountOfCommonSubExpressionsUsed();
        this.minionSubExpressions = new HashMap();
        this.useCommonSubexpressions = this.settings.useCommonSubExpressions();
        this.essenceSubExpressions = this.normalisedModel.getSubExpressions();
    }

    private HashMap<String, MinionAtom> tailorEqualAtoms() throws MinionException {
        HashMap<String, MinionAtom> hashMap = new HashMap<String, MinionAtom>();
        ArrayList<ArithmeticAtomExpression> arrayList = this.normalisedModel.getReplaceableVariables();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArithmeticAtomExpression arithmeticAtomExpression = arrayList.get(i);
            MinionAtom minionAtom = this.toMinion(this.normalisedModel.getReplacementFor(arithmeticAtomExpression.toString()));
            hashMap.put(((Object)this.toMinion(arithmeticAtomExpression)).toString(), minionAtom);
        }
        return hashMap;
    }

    private void tailorObjective() throws MinionException {
        Expression expression = this.normalisedModel.getObjectiveExpression();
        if (expression instanceof RelationalAtomExpression || expression instanceof ArithmeticAtomExpression) {
            this.minionModel.setObjective((MinionAtom)this.toMinion(expression), this.normalisedModel.isObjectiveMaximising());
        }
    }

    public MinionModel tailorToMinion(NormalisedModel normalisedModel) throws MinionException {
        this.normalisedModel = normalisedModel;
        this.subexpressionCount = this.normalisedModel.getSubexpressionCount();
        this.subexpressionList = this.normalisedModel.getSubexpressionList();
        MinionModel minionModel = new MinionModel(new ArrayList<MinionConstraint>(), this.mapDecisionVariables(), this.normalisedModel.getDecisionVariablesNames(), this.normalisedModel.getAuxVariables(), this.solverSettings, this.settings, this.essenceSubExpressions, this.minionSubExpressions, this.subexpressionCount);
        for (int i = this.normalisedModel.getConstraints().size() - 1; i >= 0; --i) {
            minionModel.addConstraint(this.toMinion(this.normalisedModel.getConstraints().remove(i)));
        }
        return minionModel;
    }

    public String getEssenceSolution(String string) {
        return this.minionModel.getEssenceSolution(string);
    }

    protected HashMap<String, ConstantDomain> mapDecisionVariables() throws MinionException {
        HashMap<String, ConstantDomain> hashMap = new HashMap<String, ConstantDomain>();
        ArrayList<String> arrayList = this.normalisedModel.getDecisionVariablesNames();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            Domain domain = this.normalisedModel.getDomainOfVariable(string);
            if ((domain = domain.evaluate()) instanceof ConstantDomain) {
                ConstantDomain constantDomain = (ConstantDomain)domain;
                hashMap.put(string, constantDomain);
                if (!(constantDomain instanceof ConstantArrayDomain)) continue;
                ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)constantDomain).getIndexDomains();
                int[] nArray = new int[constantDomainArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    if (constantDomainArray[j] instanceof BoolDomain) {
                        nArray[j] = 0;
                        continue;
                    }
                    if (constantDomainArray[j] instanceof BoundedIntRange) {
                        nArray[j] = ((BoundedIntRange)constantDomainArray[j]).getRange()[0];
                        continue;
                    }
                    if (constantDomainArray[j] instanceof SingleIntRange) {
                        nArray[j] = ((SingleIntRange)constantDomainArray[j]).getRange()[0];
                        continue;
                    }
                    throw new MinionException("Cannot translate sparse domains as array-indices yet: variable '" + string + "', domain: " + domain);
                }
                this.offsetsFromZero.put(string, nArray);
                continue;
            }
            throw new MinionException("Found non-constant domain:" + domain + ". Please define all parameters.");
        }
        return hashMap;
    }

    protected MinionConstraint toMinion(Expression expression) throws MinionException {
        if (expression instanceof ArithmeticAtomExpression) {
            return this.toMinion((ArithmeticAtomExpression)expression);
        }
        if (expression instanceof AbsoluteConstraint) {
            return this.toMinion((AbsoluteConstraint)expression);
        }
        if (expression instanceof CommutativeBinaryRelationalExpression) {
            return this.toMinion((CommutativeBinaryRelationalExpression)expression);
        }
        if (expression instanceof NonCommutativeRelationalBinaryExpression) {
            return this.toMinion((NonCommutativeRelationalBinaryExpression)expression);
        }
        if (expression instanceof SumConstraint) {
            return this.toMinion((SumConstraint)expression);
        }
        if (expression instanceof Reification) {
            return this.toMinion((Reification)expression);
        }
        if (expression instanceof Disjunction) {
            return this.toMinion((Disjunction)expression);
        }
        if (expression instanceof Conjunction) {
            return this.toMinion((Conjunction)expression);
        }
        if (expression instanceof translator.expression.ProductConstraint) {
            return this.toMinion((translator.expression.ProductConstraint)expression);
        }
        if (expression instanceof Multiplication) {
            return this.toMinion((Multiplication)expression);
        }
        if (expression instanceof RelationalAtomExpression) {
            return this.toMinion((RelationalAtomExpression)expression);
        }
        if (expression instanceof translator.expression.AllDifferent) {
            return this.toMinion((translator.expression.AllDifferent)expression);
        }
        if (expression instanceof LexConstraint) {
            return this.toMinion((LexConstraint)expression);
        }
        if (expression instanceof ElementConstraint) {
            return this.toMinion((ElementConstraint)expression);
        }
        if (expression instanceof Atmost) {
            return this.toMinion((Atmost)expression);
        }
        if (expression instanceof TableConstraint) {
            return this.toMinion((TableConstraint)expression);
        }
        if (expression instanceof TableConstraintNew) {
            return this.toMinionTable(expression);
        }
        if (expression instanceof AbsoluteValue) {
            return this.toMinion((AbsoluteValue)expression);
        }
        if (expression instanceof Negation) {
            return this.toMinion((Negation)expression);
        }
        if (expression instanceof BinaryNonLinearConstraint) {
            return this.toMinion((BinaryNonLinearConstraint)expression);
        }
        if (expression instanceof MinimumConstraint) {
            return this.toMinion((MinimumConstraint)expression);
        }
        if (expression instanceof GlobalCardinality) {
            return this.toMinionGCC((GlobalCardinality)expression);
        }
        throw new MinionException("Cannot tailor expression of type " + expression.getClass() + " to Minion yet:" + expression);
    }

    private MinionConstraint toMinionGCC(GlobalCardinality globalCardinality) throws MinionException {
        Expression expression = globalCardinality.getVariables();
        if (expression instanceof Array) {
            MinionArray minionArray = this.toMinionArray((Array)expression);
            Expression expression2 = globalCardinality.getValues();
            if (expression2 instanceof ConstantVector) {
                int[] nArray = ((ConstantVector)expression2).getElements();
                Expression expression3 = globalCardinality.getCapacities();
                if (expression3 instanceof ConstantVector) {
                    int[] nArray2 = ((ConstantVector)expression3).getElements();
                    return new MinionGCC(minionArray, nArray, nArray2);
                }
                if (expression3 instanceof Array) {
                    MinionArray minionArray2 = this.toMinionArray((Array)expression3);
                    return new MinionGCC(minionArray, nArray, minionArray2);
                }
                throw new MinionException("Cannot tailor " + globalCardinality + " to Minion yet, sorry." + "The capacity values have to be integers at the moment.");
            }
            throw new MinionException("Cannot tailor " + globalCardinality + " to Minion yet, sorry." + "The values of the 2nd argument have to be integers at the moment.");
        }
        throw new MinionException("Cannot tailor " + globalCardinality + " to Minion, sorry.");
    }

    private MinionConstraint toMinionTable(Expression expression) throws MinionException {
        if (expression instanceof TableConstraintNew) {
            TableConstraintNew tableConstraintNew = (TableConstraintNew)expression;
            AtomExpression[] atomExpressionArray = tableConstraintNew.getVariables();
            MinionAtom[] minionAtomArray = new MinionAtom[atomExpressionArray.length];
            for (int i = 0; i < atomExpressionArray.length; ++i) {
                atomExpressionArray[i].willBeFlattenedToVariable(true);
                minionAtomArray[i] = atomExpressionArray[i] instanceof ArithmeticAtomExpression ? this.toMinion((ArithmeticAtomExpression)atomExpressionArray[i]) : this.toMinion((RelationalAtomExpression)atomExpressionArray[i]);
                this.variableIsDiscrete.put(minionAtomArray[i].getVariableName(), new Boolean(true));
            }
            if (tableConstraintNew.isGonnaBeFlattenedToVariable()) {
                if (this.solverSettings.supportsReificationOf(221)) {
                    Table table = new Table(minionAtomArray, tableConstraintNew.getTupleList());
                    table.setIsNegative(tableConstraintNew.isConflictingTableConstraint());
                    return this.reifyMinionConstraint(new Table(minionAtomArray, tableConstraintNew.getTupleList()));
                }
                throw new MinionException("Cannot tailor TABLE constraint to Minion:" + tableConstraintNew + "\ntable is not reifiable.");
            }
            Table table = new Table(minionAtomArray, tableConstraintNew.getTupleList());
            table.setIsNegative(tableConstraintNew.isConflictingTableConstraint());
            return table;
        }
        throw new MinionException("Cannot tailor constraint:" + expression);
    }

    private MinionConstraint toMinion(MinimumConstraint minimumConstraint) throws MinionException {
        MinionArray minionArray = this.toMinionArray(minimumConstraint.getArguments());
        Expression expression = minimumConstraint.getResult();
        if (expression instanceof ArithmeticAtomExpression) {
            MinionAtom minionAtom = this.toMinion((ArithmeticAtomExpression)expression);
            return new Minimum(minionArray, minionAtom, !minimumConstraint.isMaximum());
        }
        throw new MinionException("Illegal minimum constraint: " + minimumConstraint + ". The result '" + expression + "' is not an atomic expression.");
    }

    private MinionConstraint toMinion(TableConstraint tableConstraint) throws MinionException {
        Variable[] variableArray = tableConstraint.getVariables();
        MinionAtom[] minionAtomArray = new MinionAtom[variableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            variableArray[i].willBeFlattenedToVariable(true);
            minionAtomArray[i] = this.toMinion(new ArithmeticAtomExpression(variableArray[i]));
            this.variableIsDiscrete.put(minionAtomArray[i].getVariableName(), new Boolean(true));
        }
        if (tableConstraint.isGonnaBeFlattenedToVariable()) {
            if (this.solverSettings.supportsReificationOf(221)) {
                Table table = new Table(minionAtomArray, tableConstraint.getTupleList());
                table.setIsNegative(tableConstraint.isConflictingTableConstraint());
                return this.reifyMinionConstraint(new Table(minionAtomArray, tableConstraint.getTupleList()));
            }
            throw new MinionException("Cannot tailor TABLE constraint to Minion:" + tableConstraint + "\ntable is not reifiable.");
        }
        Table table = new Table(minionAtomArray, tableConstraint.getTupleList());
        table.setIsNegative(tableConstraint.isConflictingTableConstraint());
        return table;
    }

    private MinionConstraint toMinion(Atmost atmost) throws MinionException {
        Expression expression;
        int n;
        ArrayList<Expression> arrayList;
        MinionArray minionArray = this.toMinionArray(atmost.getArray());
        int[] nArray = atmost.getOccurrences();
        int[] nArray2 = atmost.getValues();
        if (nArray.length == 0) {
            arrayList = atmost.getOccurrenceExpressions();
            for (n = arrayList.size() - 1; n >= 0; --n) {
                expression = arrayList.remove(n);
                if (expression.getType() != 3) {
                    throw new MinionException("Infeasible atmost/aleast argument that is not a constant " + expression + " in " + atmost);
                }
                nArray[n] = ((ArithmeticAtomExpression)expression).getConstant();
            }
        }
        if (nArray2.length == 0) {
            arrayList = atmost.getOccurrenceExpressions();
            for (n = arrayList.size() - 1; n >= 0; --n) {
                expression = arrayList.remove(n);
                if (expression.getType() != 3) {
                    throw new MinionException("Infeasible atmost/aleast argument that is not a constant " + expression + " in " + atmost);
                }
                nArray2[n] = ((ArithmeticAtomExpression)expression).getConstant();
            }
        }
        if (nArray.length != nArray2.length) {
            throw new MinionException("Cannot tailor atmost/atleast constraint:" + atmost + ".\n Occurrences and values have different sizes.");
        }
        if (atmost.isGonnaBeFlattenedToVariable()) {
            if (atmost.isAtmost() && this.solverSettings.supportsReificationOf(224) || !atmost.isAtmost() && this.solverSettings.supportsReificationOf(223)) {
                return this.reifyMinionConstraint(new OccurrenceLeq(minionArray, nArray2, nArray, atmost.isAtmost()));
            }
            throw new MinionException("Cannot tailor ATMOST/ATLEAST constraint to Minion:" + atmost + "\natmost/atleast is not reifiable.");
        }
        return new OccurrenceLeq(minionArray, nArray2, nArray, atmost.isAtmost());
    }

    protected MinionConstraint toMinion(ElementConstraint elementConstraint) throws MinionException {
        int[] nArray = elementConstraint.getArguments()[0].getDomain();
        MinionArray minionArray = this.toMinionArray((Array)elementConstraint.getArguments()[0]);
        Expression expression = elementConstraint.getArguments()[1];
        Expression expression2 = elementConstraint.getArguments()[2];
        if (!(expression instanceof ArithmeticAtomExpression) && !(expression instanceof RelationalAtomExpression)) {
            throw new MinionException("Cannot tailor expression '" + elementConstraint + "' to Minion element constraint:\n" + " The index-expression has to be an atom:" + expression);
        }
        MinionAtom minionAtom = (MinionAtom)this.toMinion(expression);
        if (!(expression2 instanceof ArithmeticAtomExpression) && !(expression2 instanceof RelationalAtomExpression)) {
            throw new MinionException("Cannot tailor expression '" + elementConstraint + "' to Minion element constraint:\n" + " The result-expression has to be an atom:" + expression2);
        }
        MinionAtom minionAtom2 = (MinionAtom)this.toMinion(expression2);
        boolean bl = true;
        if (nArray[1] - nArray[0] > this.settings.getDiscreteUpperBound()) {
            bl = false;
        }
        if (elementConstraint.isGonnaBeFlattenedToVariable()) {
            this.minionModel.constraintList.add(new Element(minionArray, minionAtom, minionAtom2, bl));
            return minionAtom2;
        }
        return new Element(minionArray, minionAtom, minionAtom2, bl);
    }

    protected MinionConstraint toMinion(LexConstraint lexConstraint) throws MinionException {
        if (!(lexConstraint.getLeftArray() instanceof Array)) {
            throw new MinionException("Infeasible argument '" + lexConstraint.getLeftArray() + "' for lex-constraint:" + lexConstraint + ". Expected an array.");
        }
        if (!(lexConstraint.getRightArray() instanceof Array)) {
            throw new MinionException("Infeasible argument '" + lexConstraint.getRightArray() + "' for lex-constraint:" + lexConstraint + ". Expected an array.");
        }
        MinionArray minionArray = this.toMinionArray((Array)lexConstraint.getLeftArray());
        MinionArray minionArray2 = this.toMinionArray((Array)lexConstraint.getRightArray());
        if (lexConstraint.getOperator() == 109) {
            return new LexlessConstraint(minionArray2, minionArray, false);
        }
        if (lexConstraint.getOperator() == 107) {
            return new LexlessConstraint(minionArray2, minionArray, true);
        }
        if (lexConstraint.getOperator() == 105) {
            return new LexlessConstraint(minionArray, minionArray2, false);
        }
        if (lexConstraint.getOperator() == 103) {
            return new LexlessConstraint(minionArray, minionArray2, true);
        }
        throw new MinionException("Unknown lex-operator in lex-constraint:" + lexConstraint);
    }

    protected MinionConstraint toMinion(translator.expression.AllDifferent allDifferent) throws MinionException {
        MinionArray minionArray = this.toMinionArray((Array)allDifferent.getArgument());
        return new AllDifferent(minionArray);
    }

    protected MinionArray toMinionArray(Array array) throws MinionException {
        if (array instanceof SimpleArray) {
            if (((SimpleArray)array).willBeFlattenedToVector()) {
                SimpleArray simpleArray = (SimpleArray)array;
                String string = simpleArray.getArrayName();
                String string2 = "ALIAS " + string + this.FLATTENED_TO_VECTOR_SUFFIX;
                BasicDomain[] basicDomainArray = simpleArray.getIndexDomains();
                if (basicDomainArray.length == 1) {
                    return new MinionSimpleArray(((SimpleArray)array).getArrayName());
                }
                if (basicDomainArray.length == 2) {
                    int n = 0;
                    int n2 = 0;
                    if (!(basicDomainArray[0] instanceof ConstantDomain)) {
                        throw new MinionException("Cannot tailor to Minion if index-domain '" + basicDomainArray[0] + "' of " + string + " cannot be evaluated to a constant.");
                    }
                    Object object = (ConstantDomain)basicDomainArray[0];
                    n = object.getRange()[1] - object.getRange()[0] + 1;
                    if (!(basicDomainArray[1] instanceof ConstantDomain)) {
                        throw new MinionException("Cannot tailor to Minion if index-domain '" + basicDomainArray[1] + "' of " + string + " cannot be evaluated to a constant.");
                    }
                    object = (ConstantDomain)basicDomainArray[1];
                    n2 = object.getRange()[1] - object.getRange()[0] + 1;
                    object = "";
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            object = (String)object + string + "[" + i + "," + j + "]";
                            if (i != n - 1 || j != n2 - 1) {
                                object = (String)object + ",";
                            }
                            if (j != n2 - 1) continue;
                            object = (String)object + "\n\t\t";
                        }
                    }
                    string2 = string2 + "[" + n * n2 + "] = [" + (String)object + "]\n";
                } else if (basicDomainArray.length == 3) {
                    int n = 0;
                    int n3 = 0;
                    int n4 = 0;
                    if (!(basicDomainArray[0] instanceof ConstantDomain)) {
                        throw new MinionException("Cannot tailor to Minion if index-domain '" + basicDomainArray[0] + "' of " + string + " cannot be evaluated to a constant.");
                    }
                    Object object = (ConstantDomain)basicDomainArray[0];
                    n3 = object.getRange()[1] - object.getRange()[0] + 1;
                    if (!(basicDomainArray[1] instanceof ConstantDomain)) {
                        throw new MinionException("Cannot tailor to Minion if index-domain '" + basicDomainArray[1] + "' of " + string + " cannot be evaluated to a constant.");
                    }
                    object = (ConstantDomain)basicDomainArray[1];
                    n4 = object.getRange()[1] - object.getRange()[0] + 1;
                    if (!(basicDomainArray[2] instanceof ConstantDomain)) {
                        throw new MinionException("Cannot tailor to Minion if index-domain '" + basicDomainArray[2] + "' of " + string + " cannot be evaluated to a constant.");
                    }
                    object = (ConstantDomain)basicDomainArray[2];
                    n = object.getRange()[2] - object.getRange()[0] + 1;
                    object = "";
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            for (int k = 0; k < n4; ++k) {
                                object = (String)object + string + "[" + i + "," + j + "," + k + "]";
                                if (i != n - 1) {
                                    object = (String)object + ",";
                                }
                                if (k != n4 - 1) continue;
                                object = (String)object + "\n\t\t";
                            }
                        }
                    }
                    string2 = string2 + "[" + n * n3 * n4 + "] = [" + (String)object + "]\n";
                } else {
                    throw new MinionException("Sorry, cannot flatten arrays with more than 3 dimensions:" + array);
                }
                this.minionModel.addAlias(string2);
                return new MinionSimpleArray(string + this.FLATTENED_TO_VECTOR_SUFFIX);
            }
            return new MinionSimpleArray(((SimpleArray)array).getArrayName());
        }
        if (array instanceof IndexedArray) {
            int n;
            String string = ((IndexedArray)array).getArrayName();
            BasicDomain[] basicDomainArray = ((IndexedArray)array).getIndexRanges();
            ConstantDomain[] constantDomainArray = new ConstantDomain[basicDomainArray.length];
            boolean[] blArray = new boolean[basicDomainArray.length];
            int[] nArray = new int[constantDomainArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
            for (n = 0; n < basicDomainArray.length; ++n) {
                basicDomainArray[n] = (BasicDomain)basicDomainArray[n].evaluate();
                if (!(basicDomainArray[n] instanceof ConstantDomain)) {
                    throw new MinionException("Sorry, cannot translate arrays that are indexed with variables yet:" + array);
                }
                constantDomainArray[n] = (ConstantDomain)basicDomainArray[n];
                blArray[n] = this.isFullDomain(string, constantDomainArray[n], n);
            }
            return new MinionIndexedArray(string, constantDomainArray, blArray, nArray);
        }
        if (array instanceof VariableArray) {
            VariableArray variableArray = (VariableArray)array;
            AtomExpression[] atomExpressionArray = variableArray.getVariables();
            MinionAtom[] minionAtomArray = new MinionAtom[atomExpressionArray.length];
            for (int i = 0; i < atomExpressionArray.length; ++i) {
                if (atomExpressionArray[i] instanceof RelationalAtomExpression) {
                    atomExpressionArray[i].willBeFlattenedToVariable(true);
                    minionAtomArray[i] = this.toMinion((RelationalAtomExpression)atomExpressionArray[i]);
                    continue;
                }
                if (atomExpressionArray[i] instanceof ArithmeticAtomExpression) {
                    atomExpressionArray[i].willBeFlattenedToVariable(true);
                    minionAtomArray[i] = this.toMinion((ArithmeticAtomExpression)atomExpressionArray[i]);
                    continue;
                }
                throw new MinionException("Unfeasible variable '" + atomExpressionArray[i] + "' with type " + atomExpressionArray[i].getClass() + " in VariableArray: " + variableArray);
            }
            return new MinionVariableArray(minionAtomArray);
        }
        throw new MinionException("Sorry, cannot translate array type yet:" + array);
    }

    protected boolean isFullDomain(String string, ConstantDomain constantDomain, int n) throws MinionException {
        Domain domain = this.normalisedModel.getDomainOfVariable(string);
        if (domain == null) {
            throw new MinionException("Unknown array variable '" + string + ", or cannot tailor constant vector to Minion");
        }
        if (domain instanceof ArrayDomain) {
            ArrayDomain arrayDomain = (ArrayDomain)domain;
            Domain[] domainArray = arrayDomain.getIndexDomains();
            if (n < domainArray.length && n >= 0) {
                Domain domain2 = domainArray[n];
                return domain2 instanceof ConstantDomain && domain2.getType() == constantDomain.getType() && constantDomain.isSmallerThanSameType((ConstantDomain)domain2) == 'e';
            }
            throw new MinionException("Wrong dimensions: the variable '" + string + "' has been declared to be a " + domainArray.length + "-dimensional array/matrix, so you cannot index it at dimension '" + n + "', sorry.");
        }
        if (domain instanceof ConstantArrayDomain) {
            ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)domain;
            ConstantDomain[] constantDomainArray = constantArrayDomain.getIndexDomains();
            if (n < constantDomainArray.length && n >= 0) {
                ConstantDomain constantDomain2 = constantDomainArray[n];
                return constantDomain2 instanceof ConstantDomain && constantDomain2.getType() == constantDomain.getType() && constantDomain.isSmallerThanSameType(constantDomain2) == 'e';
            }
            throw new MinionException("Wrong dimensions: the variable '" + string + "' has been declared to be a " + constantDomainArray.length + "-dimensional array/matrix, so you cannot index it at dimension '" + n + "', sorry.");
        }
        throw new MinionException("Incompatible types: cannot dereference variable that is not an array/matrix variable:" + string);
    }

    protected MinionAtom toMinion(Multiplication multiplication) throws MinionException {
        ArrayList<Expression> arrayList = multiplication.getArguments();
        if (arrayList.size() != 2) {
            throw new MinionException("Minion's product constraint only takes two arguments. Therefore cannot translate:" + multiplication);
        }
        arrayList.get(0).willBeFlattenedToVariable(true);
        arrayList.get(1).willBeFlattenedToVariable(true);
        MinionAtom minionAtom = (MinionAtom)this.toMinion(arrayList.get(0));
        MinionAtom minionAtom2 = (MinionAtom)this.toMinion(arrayList.get(1));
        MinionAtom minionAtom3 = this.createMinionAuxiliaryVariable(multiplication.getDomain()[0], multiplication.getDomain()[1]);
        ProductConstraint productConstraint = new ProductConstraint(minionAtom, minionAtom2, minionAtom3);
        this.minionModel.addConstraint(productConstraint);
        return minionAtom3;
    }

    protected MinionConstraint toMinion(translator.expression.ProductConstraint productConstraint) throws MinionException {
        Expression[] expressionArray = productConstraint.getArguments();
        if (expressionArray.length != 2) {
            throw new MinionException("Minion's product constraint only takes two arguments. Therefore cannot translate:" + productConstraint);
        }
        expressionArray[0].willBeFlattenedToVariable(true);
        expressionArray[1].willBeFlattenedToVariable(true);
        MinionAtom[] minionAtomArray = new MinionAtom[]{(MinionAtom)this.toMinion(expressionArray[0]), (MinionAtom)this.toMinion(expressionArray[1])};
        Expression expression = productConstraint.getResult();
        expression.willBeFlattenedToVariable(true);
        MinionAtom minionAtom = (MinionAtom)this.toMinion(expression);
        ProductConstraint productConstraint2 = new ProductConstraint(minionAtomArray[0], minionAtomArray[1], minionAtom);
        if (productConstraint.isGonnaBeFlattenedToVariable()) {
            return this.reifyMinionConstraint(productConstraint2);
        }
        return productConstraint2;
    }

    protected MinionConstraint toMinion(Conjunction conjunction) throws MinionException {
        ArrayList<Expression> arrayList = conjunction.getArguments();
        MinionAtom[] minionAtomArray = new MinionAtom[arrayList.size()];
        if (minionAtomArray.length == 1) {
            if (conjunction.isGonnaBeFlattenedToVariable()) {
                return (MinionAtom)this.toMinion(arrayList.get(0));
            }
            return new EqConstraint((MinionAtom)this.toMinion(arrayList.get(0)), new MinionConstant(1));
        }
        for (int i = 0; i < minionAtomArray.length; ++i) {
            Expression expression = arrayList.get(i);
            expression.willBeFlattenedToVariable(true);
            minionAtomArray[i] = (MinionAtom)this.toMinion(expression);
        }
        return new SumGeqConstraint(minionAtomArray, new MinionConstant(minionAtomArray.length));
    }

    protected MinionConstraint toMinion(Disjunction disjunction) throws MinionException {
        ArrayList<Expression> arrayList = disjunction.getArguments();
        MinionAtom[] minionAtomArray = new MinionAtom[arrayList.size()];
        if (minionAtomArray.length == 1) {
            if (disjunction.isGonnaBeFlattenedToVariable()) {
                return (MinionAtom)this.toMinion(arrayList.get(0));
            }
            return new EqConstraint((MinionAtom)this.toMinion(arrayList.get(0)), new MinionConstant(1));
        }
        for (int i = 0; i < minionAtomArray.length; ++i) {
            Expression expression = arrayList.get(i);
            expression.willBeFlattenedToVariable(true);
            minionAtomArray[i] = (MinionAtom)this.toMinion(expression);
        }
        if (disjunction.isGonnaBeFlattenedToVariable()) {
            return this.reifyMinionConstraint(new SumGeqConstraint(minionAtomArray, new MinionConstant(1)));
        }
        return new SumGeqConstraint(minionAtomArray, new MinionConstant(1), !disjunction.isNested());
    }

    protected MinionConstraint toMinion(Reification reification) throws MinionException {
        Object object;
        Expression expression = reification.getReifiedConstraint();
        if (expression instanceof SumConstraint && !reification.getIsReifyImplied()) {
            object = (SumConstraint)expression;
            if (((SumConstraint)object).getOperator() == 101) {
                this.reifiedSumAuxVar = reification.getReifiedVariable().toArithmeticExpression();
                expression.willBeFlattenedToVariable(true);
                MinionConstraint minionConstraint = this.toMinion(expression);
                return minionConstraint;
            }
            expression.willBeFlattenedToVariable(false);
        } else {
            if (this.settings.useMinionMinimumForConjunction() && expression instanceof Conjunction) {
                Conjunction conjunction = (Conjunction)expression;
                ArrayList<Expression> arrayList = conjunction.getArguments();
                MinionAtom[] minionAtomArray = new MinionAtom[arrayList.size()];
                if (minionAtomArray.length == 1) {
                    if (conjunction.isGonnaBeFlattenedToVariable()) {
                        return (MinionAtom)this.toMinion(arrayList.get(0));
                    }
                    return new EqConstraint((MinionAtom)this.toMinion(arrayList.get(0)), this.toMinion(reification.getReifiedVariable()));
                }
                for (int i = 0; i < minionAtomArray.length; ++i) {
                    Expression expression2 = arrayList.get(i);
                    expression2.willBeFlattenedToVariable(true);
                    minionAtomArray[i] = (MinionAtom)this.toMinion(expression2);
                }
                return new Minimum(minionAtomArray, this.toMinion(reification.getReifiedVariable()), true);
            }
            if (this.settings.useMinionMaximumForDisjunction() && expression instanceof Disjunction) {
                Disjunction disjunction = (Disjunction)expression;
                ArrayList<Expression> arrayList = disjunction.getArguments();
                MinionAtom[] minionAtomArray = new MinionAtom[arrayList.size()];
                if (minionAtomArray.length == 1) {
                    if (disjunction.isGonnaBeFlattenedToVariable()) {
                        return (MinionAtom)this.toMinion(arrayList.get(0));
                    }
                    return new EqConstraint((MinionAtom)this.toMinion(arrayList.get(0)), this.toMinion(reification.getReifiedVariable()));
                }
                for (int i = 0; i < minionAtomArray.length; ++i) {
                    Expression expression3 = arrayList.get(i);
                    expression3.willBeFlattenedToVariable(true);
                    minionAtomArray[i] = (MinionAtom)this.toMinion(expression3);
                }
                return new Minimum(minionAtomArray, this.toMinion(reification.getReifiedVariable()), false);
            }
            if (this.settings.useMinionProductForConjunction() && expression instanceof Conjunction && ((Conjunction)expression).getArguments().size() == 2) {
                Conjunction conjunction = (Conjunction)expression;
                ArrayList<Expression> arrayList = conjunction.getArguments();
                MinionAtom[] minionAtomArray = new MinionAtom[arrayList.size()];
                if (minionAtomArray.length == 1) {
                    if (conjunction.isGonnaBeFlattenedToVariable()) {
                        return (MinionAtom)this.toMinion(arrayList.get(0));
                    }
                    return new EqConstraint((MinionAtom)this.toMinion(arrayList.get(0)), this.toMinion(reification.getReifiedVariable()));
                }
                for (int i = 0; i < minionAtomArray.length; ++i) {
                    Expression expression4 = arrayList.get(i);
                    expression4.willBeFlattenedToVariable(true);
                    minionAtomArray[i] = (MinionAtom)this.toMinion(expression4);
                }
                return new ProductConstraint(minionAtomArray[0], minionAtomArray[1], this.toMinion(reification.getReifiedVariable()));
            }
        }
        expression.willBeFlattenedToVariable(false);
        MinionConstraint minionConstraint = this.toMinion(expression);
        if (minionConstraint instanceof MinionAtom) {
            return !reification.getIsReifyImplied() ? new EqConstraint((MinionAtom)minionConstraint, this.toMinion(reification.getReifiedVariable())) : new IneqConstraint(this.toMinion(reification.getReifiedVariable()), (MinionAtom)minionConstraint, 0);
        }
        object = this.toMinion(reification.getReifiedVariable());
        if (reification.isGonnaBeFlattenedToVariable()) {
            Reify reify = new Reify(minionConstraint, (MinionAtom)object);
            reify.setIsReifyImply(reification.getIsReifyImplied());
            this.minionModel.addConstraint(reify);
            return object;
        }
        Reify reify = new Reify(minionConstraint, (MinionAtom)object);
        reify.setIsReifyImply(reification.getIsReifyImplied());
        return reify;
    }

    private MinionAtom toMinion(AbsoluteValue absoluteValue) throws MinionException {
        if (absoluteValue.getArgument() instanceof ArithmeticAtomExpression) {
            MinionAtom minionAtom;
            ArithmeticAtomExpression arithmeticAtomExpression = (ArithmeticAtomExpression)absoluteValue.getArgument();
            MinionAtom minionAtom2 = this.toMinion(arithmeticAtomExpression);
            if (this.hasCommonSubExpression(minionAtom2)) {
                minionAtom = this.getCommonSubExpression(minionAtom2);
            } else {
                int n = arithmeticAtomExpression.getDomain()[1];
                if (n < 0) {
                    n = -n;
                }
                minionAtom = this.createMinionAuxiliaryVariable(0, n);
                this.addToSubExpressions(minionAtom2, minionAtom);
            }
            this.minionModel.constraintList.add(new MinionAbsoluteValue(minionAtom2, minionAtom));
            return minionAtom;
        }
        throw new MinionException("Internal error or invalid argument. Cannot tailor constraint expression '" + absoluteValue.getArgument() + "' as argument of an absolute constraint: " + absoluteValue);
    }

    private MinionConstraint toMinion(Negation negation) throws MinionException {
        RelationalAtomExpression relationalAtomExpression;
        if (!negation.isNested()) {
            if (!(negation.getArgument() instanceof AtomExpression)) {
                throw new MinionException("Cannot tailor negation " + negation + " to Minion because the argument is not flattened to a variable.");
            }
            MinionAtom minionAtom = (MinionAtom)this.toMinion(negation.getArgument());
            return new EqConstraint(new MinionConstant(0), minionAtom);
        }
        if (this.hasCommonSubExpression(negation)) {
            relationalAtomExpression = this.getCommonSubExpression(negation).toRelationalAtomExpression();
        } else {
            relationalAtomExpression = new RelationalAtomExpression(this.createAuxVariable());
            this.addToSubExpressions(negation, relationalAtomExpression.toArithmeticExpression());
            if (this.settings.getAuxVarDetails()) {
                this.addToAuxVarDetails(relationalAtomExpression.toString(), negation);
            }
        }
        if (!(negation.getArgument() instanceof AtomExpression)) {
            throw new MinionException("Cannot tailor negation " + negation + " to Minion because the argument is not flattened to a variable.");
        }
        MinionAtom minionAtom = this.toMinion(relationalAtomExpression.toArithmeticExpression());
        MinionAtom minionAtom2 = (MinionAtom)this.toMinion(negation.getArgument());
        if (negation.isGonnaBeFlattenedToVariable()) {
            this.minionModel.addConstraint(new DiseqConstraint(minionAtom, minionAtom2));
            return minionAtom;
        }
        return new DiseqConstraint(minionAtom, minionAtom2);
    }

    private MinionConstraint toMinion(AbsoluteConstraint absoluteConstraint) throws MinionException {
        if (!(absoluteConstraint.getArgument() instanceof ArithmeticAtomExpression)) {
            throw new MinionException("Flattening error. Cannot tailor argument '" + absoluteConstraint.getArgument() + "'  of absolute value constraint '" + absoluteConstraint + "' when it is not a variable/atom expression.");
        }
        MinionAtom minionAtom = this.toMinion((ArithmeticAtomExpression)absoluteConstraint.getArgument());
        if (!(absoluteConstraint.getResult() instanceof ArithmeticAtomExpression)) {
            throw new MinionException("Flattening error. Cannot tailor result '" + absoluteConstraint.getResult() + "'  of absolute value constraint '" + absoluteConstraint + "' when it is not a variable/atom expression.");
        }
        MinionAtom minionAtom2 = this.toMinion((ArithmeticAtomExpression)absoluteConstraint.getResult());
        return new MinionAbsoluteValue(minionAtom, minionAtom2);
    }

    private MinionConstraint toMinion(SumConstraint sumConstraint) throws MinionException {
        int n = sumConstraint.getRelationalOperator();
        if (n == 102 || n == 106 || n == 100) {
            return this.toMinionStrongIneqSumConstraint(sumConstraint);
        }
        return this.toMinionWeakIneqSumConstraint(sumConstraint);
    }

    private MinionConstraint toMinion(BinaryNonLinearConstraint binaryNonLinearConstraint) throws MinionException {
        Expression expression = binaryNonLinearConstraint.getLeftArgument();
        Expression expression2 = binaryNonLinearConstraint.getRightArgument();
        Expression expression3 = binaryNonLinearConstraint.getResult();
        if (!(expression instanceof ArithmeticAtomExpression)) {
            throw new MinionException("Error in flattening: expected an arithmetic atomic expression instead of '" + expression + "' in constraint:" + binaryNonLinearConstraint);
        }
        if (!(expression2 instanceof ArithmeticAtomExpression)) {
            throw new MinionException("Error in flattening: expected an arithmetic atomic expression instead of '" + expression2 + "' in constraint:" + binaryNonLinearConstraint);
        }
        if (!(expression3 instanceof ArithmeticAtomExpression)) {
            throw new MinionException("Error in flattening: expected an arithmetic atomic expression instead of '" + expression3 + "' in constraint:" + binaryNonLinearConstraint);
        }
        MinionAtom minionAtom = this.toMinion((ArithmeticAtomExpression)expression);
        MinionAtom minionAtom2 = this.toMinion((ArithmeticAtomExpression)expression2);
        MinionAtom minionAtom3 = this.toMinion((ArithmeticAtomExpression)expression3);
        if (binaryNonLinearConstraint.getType() == 122) {
            return new Modulo(minionAtom, minionAtom2, minionAtom3);
        }
        if (binaryNonLinearConstraint.getType() == 114) {
            return new Power(minionAtom, minionAtom2, minionAtom3);
        }
        if (binaryNonLinearConstraint.getType() == 112) {
            return new Division(minionAtom, minionAtom2, minionAtom3);
        }
        throw new MinionException("Cannot translate constraint " + binaryNonLinearConstraint);
    }

    private MinionConstraint toMinionStrongIneqSumConstraint(SumConstraint sumConstraint) throws MinionException {
        Object object;
        Expression[] expressionArray = sumConstraint.getPositiveArguments();
        Expression[] expressionArray2 = sumConstraint.getNegativeArguments();
        Expression expression = sumConstraint.getResult();
        expression.willBeFlattenedToVariable(true);
        MinionAtom minionAtom = (MinionAtom)this.toMinion(expression);
        int n = sumConstraint.getRelationalOperator();
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        if (this.hasCommonSubExpression(new Sum(expressionArray, expressionArray2))) {
            arithmeticAtomExpression = this.getCommonSubExpression(new Sum(expressionArray, expressionArray2)).copy();
        } else {
            arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(sumConstraint.getSumDomain()[0], sumConstraint.getSumDomain()[1]));
            object = new Sum(expressionArray, expressionArray2);
            this.addToSubExpressions((Expression)object, arithmeticAtomExpression);
            if (this.settings.getAuxVarDetails()) {
                this.addToAuxVarDetails(arithmeticAtomExpression.toString(), (Expression)object);
            }
            SumConstraint sumConstraint2 = new SumConstraint(expressionArray, expressionArray2, 101, arithmeticAtomExpression, true);
            MinionConstraint minionConstraint = this.toMinionWeakIneqSumConstraint(sumConstraint2);
            this.minionModel.addConstraint(minionConstraint);
        }
        if (sumConstraint.isGonnaBeFlattenedToVariable()) {
            if (n == 102) {
                object = new IneqConstraint(this.toMinion(arithmeticAtomExpression), minionAtom, -1);
                return this.reifyMinionConstraint((MinionConstraint)object);
            }
            if (n == 106) {
                object = new IneqConstraint(minionAtom, this.toMinion(arithmeticAtomExpression), -1);
                return this.reifyMinionConstraint((MinionConstraint)object);
            }
            if (n == 100) {
                object = new DiseqConstraint(this.toMinion(arithmeticAtomExpression), minionAtom);
                return this.reifyMinionConstraint((MinionConstraint)object);
            }
            throw new MinionException("Internal error. Tried to tailor non-strong relational sum by strong sum method:" + sumConstraint);
        }
        if (n == 102) {
            return new IneqConstraint(this.toMinion(arithmeticAtomExpression), minionAtom, -1);
        }
        if (n == 106) {
            return new IneqConstraint(minionAtom, this.toMinion(arithmeticAtomExpression), -1);
        }
        if (n == 100) {
            return new DiseqConstraint(this.toMinion(arithmeticAtomExpression), minionAtom);
        }
        throw new MinionException("Internal error. Tried to tailor non-strong relational sum by strong sum method:" + sumConstraint);
    }

    private MinionConstraint toMinionWeakIneqSumConstraint(SumConstraint sumConstraint) throws MinionException {
        Expression[] expressionArray = sumConstraint.getPositiveArguments();
        Expression[] expressionArray2 = sumConstraint.getNegativeArguments();
        if (sumConstraint.isGonnaBeFlattenedToVariable()) {
            int n;
            MinionConstraint minionConstraint;
            Object object;
            Object object2;
            if (expressionArray2.length > 0) {
                for (int i = 0; i < expressionArray2.length; ++i) {
                    ArithmeticAtomExpression arithmeticAtomExpression;
                    Expression expression = expressionArray2[i];
                    if (expression.getType() == 3) {
                        expressionArray2[i] = new ArithmeticAtomExpression(-((ArithmeticAtomExpression)expression).getConstant());
                        continue;
                    }
                    if (expression.getType() == 0) {
                        expressionArray2[i] = ((RelationalAtomExpression)expression).getBool() ? new ArithmeticAtomExpression(-1) : new ArithmeticAtomExpression(0);
                        continue;
                    }
                    if (expression instanceof Multiplication) {
                        object2 = (Multiplication)expression;
                        if (((Multiplication)object2).getArguments().size() != 2) {
                            throw new MinionException("Flattening error. Cannot tailor non-binary multiplication '" + expression + "' in sum:" + sumConstraint);
                        }
                        if (this.hasCommonSubExpression((Expression)object2)) {
                            expressionArray2[i] = this.getCommonSubExpression((Expression)object2);
                            continue;
                        }
                        arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(((Multiplication)object2).getDomain()[0], ((Multiplication)object2).getDomain()[1]));
                        this.addToSubExpressions((Expression)object2, arithmeticAtomExpression);
                        if (this.settings.getAuxVarDetails()) {
                            this.addToAuxVarDetails(arithmeticAtomExpression.toString(), (Expression)object2);
                        }
                        object = this.toMinion(((Multiplication)object2).getArguments().get(0));
                        minionConstraint = this.toMinion(((Multiplication)object2).getArguments().get(1));
                        if (!(object instanceof MinionAtom)) {
                            throw new MinionException("Flattening error. Cannot tailor non atomic argument '" + object + "' in sum:" + sumConstraint);
                        }
                        if (!(minionConstraint instanceof MinionAtom)) {
                            throw new MinionException("Flattening error. Cannot tailor non atomic argument '" + minionConstraint + "' in sum:" + sumConstraint);
                        }
                        this.minionModel.addConstraint(new ProductConstraint((MinionAtom)object, (MinionAtom)minionConstraint, this.toMinion(arithmeticAtomExpression.copy())));
                        expressionArray2[i] = arithmeticAtomExpression;
                        continue;
                    }
                    if (!(expression instanceof AtomExpression)) {
                        throw new MinionException("Flattening error. Cannot tailor non atomic argument '" + expression + "' in sum:" + sumConstraint);
                    }
                    object2 = this.toMinion(expression);
                    if (!(object2 instanceof MinionAtom)) {
                        throw new MinionException("Flattening error. Cannot tailor non atomic argument '" + object2 + "' in sum:" + sumConstraint);
                    }
                    if (this.hasCommonSubExpression(new UnaryMinus(expression))) {
                        expressionArray2[i] = this.getCommonSubExpression(new UnaryMinus(expression));
                        continue;
                    }
                    arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(-expression.getDomain()[1], -expression.getDomain()[0]));
                    object = new UnaryMinus(expression);
                    this.addToSubExpressions((Expression)object, arithmeticAtomExpression);
                    if (this.settings.getAuxVarDetails()) {
                        this.addToAuxVarDetails(arithmeticAtomExpression.toString(), (Expression)object);
                    }
                    this.minionModel.constraintList.add(new MinusEq(this.toMinion(arithmeticAtomExpression.copy()), (MinionAtom)object2));
                    expressionArray2[i] = arithmeticAtomExpression;
                }
            }
            MinionAtom[] minionAtomArray = new MinionAtom[expressionArray.length + expressionArray2.length];
            for (n = 0; n < expressionArray.length; ++n) {
                expressionArray[n].willBeFlattenedToVariable(true);
                minionAtomArray[n] = (MinionAtom)this.toMinion(expressionArray[n]);
            }
            for (n = expressionArray.length; n < minionAtomArray.length; ++n) {
                minionAtomArray[n] = (MinionAtom)this.toMinion(expressionArray2[n - expressionArray.length]);
            }
            Expression expression = sumConstraint.getResult();
            expression.willBeFlattenedToVariable(true);
            object2 = (MinionAtom)this.toMinion(expression);
            int n2 = sumConstraint.getRelationalOperator();
            if (n2 == 104) {
                return this.reifyMinionConstraint(new SumLeqConstraint(minionAtomArray, (MinionAtom)object2));
            }
            if (n2 == 108) {
                return this.reifyMinionConstraint(new SumGeqConstraint(minionAtomArray, (MinionAtom)object2));
            }
            if (n2 == 101) {
                MinionAtom minionAtom;
                object = new SumLeqConstraint(minionAtomArray, (MinionAtom)object2);
                minionConstraint = new SumGeqConstraint(minionAtomArray, (MinionAtom)object2);
                MinionAtom minionAtom2 = this.reifyMinionConstraint((MinionConstraint)object);
                sumConstraint.setOperator(104);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarDetails(((Object)minionAtom2).toString(), sumConstraint.copy());
                }
                sumConstraint.setOperator(108);
                MinionAtom minionAtom3 = this.reifyMinionConstraint(minionConstraint);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarDetails(((Object)minionAtom3).toString(), sumConstraint.copy());
                }
                sumConstraint.setOperator(101);
                if (this.reifiedSumAuxVar != null) {
                    minionAtom = this.toMinion(this.reifiedSumAuxVar);
                    this.reifiedSumAuxVar = null;
                } else {
                    minionAtom = this.createMinionAuxiliaryVariable();
                }
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarDetails(((Object)minionAtom).toString(), sumConstraint);
                }
                ProductConstraint productConstraint = new ProductConstraint(minionAtom2, minionAtom3, minionAtom);
                return productConstraint;
            }
            throw new MinionException("Interal error: expected only weak operator instead of operator '" + n2 + "' in constraint:" + sumConstraint);
        }
        boolean bl = expressionArray2.length > 0;
        boolean bl2 = false;
        for (int i = 0; i < expressionArray.length; ++i) {
            if (expressionArray[i] instanceof UnaryMinus) {
                bl = true;
            }
            if (!(expressionArray[i] instanceof Multiplication)) continue;
            bl2 = true;
        }
        if (bl || bl2) {
            return this.toMinionWeakWeightedSumConstraint(sumConstraint);
        }
        return this.toSimpleUnReifiedWeakSumConstraint(sumConstraint);
    }

    private MinionConstraint toMinionWeakWeightedSumConstraint(SumConstraint sumConstraint) throws MinionException {
        Object object;
        Object object2;
        Expression expression;
        int n;
        Object object3;
        Object object4;
        Expression[] expressionArray = sumConstraint.getPositiveArguments();
        Expression[] expressionArray2 = sumConstraint.getNegativeArguments();
        int n2 = sumConstraint.getRelationalOperator();
        Expression expression2 = sumConstraint.getResult();
        expression2.willBeFlattenedToVariable(true);
        MinionAtom minionAtom = (MinionAtom)this.toMinion(expression2);
        if (expressionArray.length == 1 && expressionArray2.length == 1 && expression2.getType() == 3 && ((ArithmeticAtomExpression)expression2).getConstant() == 0) {
            object4 = expressionArray[0];
            object4.willBeFlattenedToVariable(true);
            object3 = expressionArray2[0];
            object3.willBeFlattenedToVariable(true);
            if (!sumConstraint.isGonnaBeFlattenedToVariable()) {
                if (n2 == 104) {
                    return new IneqConstraint((MinionAtom)this.toMinion((Expression)object4), (MinionAtom)this.toMinion((Expression)object3));
                }
                if (n2 == 108) {
                    return new IneqConstraint((MinionAtom)this.toMinion((Expression)object3), (MinionAtom)this.toMinion((Expression)object4));
                }
                if (n2 == 101) {
                    return new EqConstraint((MinionAtom)this.toMinion((Expression)object3), (MinionAtom)this.toMinion((Expression)object4));
                }
            } else {
                if (n2 == 104) {
                    return this.reifyMinionConstraint(new IneqConstraint((MinionAtom)this.toMinion((Expression)object4), (MinionAtom)this.toMinion((Expression)object3)));
                }
                if (n2 == 108) {
                    return this.reifyMinionConstraint(new IneqConstraint((MinionAtom)this.toMinion((Expression)object3), (MinionAtom)this.toMinion((Expression)object4)));
                }
                if (n2 == 101) {
                    return this.reifyMinionConstraint(new EqConstraint((MinionAtom)this.toMinion((Expression)object3), (MinionAtom)this.toMinion((Expression)object4)));
                }
            }
        }
        object4 = new int[expressionArray.length + expressionArray2.length];
        object3 = new MinionAtom[expressionArray.length + expressionArray2.length];
        for (n = 0; n < expressionArray.length; ++n) {
            expression = expressionArray[n];
            expression.orderExpression();
            expression = expression.evaluate();
            if (expression instanceof Multiplication) {
                object2 = (Multiplication)expression;
                if (((Multiplication)object2).getArguments().size() > 2) {
                    throw new MinionException("Cannot translate n-ary product constraint:" + expression);
                }
                if (((Multiplication)object2).getArguments().size() == 1) {
                    object4[n] = true;
                    object = ((Multiplication)object2).getArguments().remove(0);
                    object.willBeFlattenedToVariable(true);
                    object3[n] = (MinionAtom)this.toMinion((Expression)object);
                }
                if (((Multiplication)object2).getArguments().get(0).getType() == 3) {
                    object4[n] = ((ArithmeticAtomExpression)((Multiplication)object2).getArguments().remove(0)).getConstant();
                    object = ((Multiplication)object2).getArguments().remove(0);
                    object.willBeFlattenedToVariable(true);
                    object3[n] = (MinionAtom)this.toMinion((Expression)object);
                    continue;
                }
                ((Multiplication)object2).willBeFlattenedToVariable(true);
                object4[n] = true;
                object3[n] = this.toMinion((Multiplication)object2);
                continue;
            }
            expression.willBeFlattenedToVariable(true);
            object4[n] = true;
            object3[n] = (MinionAtom)this.toMinion(expression);
        }
        for (n = expressionArray.length; n < expressionArray.length + expressionArray2.length; ++n) {
            expression = expressionArray2[n - expressionArray.length];
            if (expression instanceof Multiplication) {
                expression.orderExpression();
                expression.evaluate();
                object2 = (Multiplication)expression;
                if (((Multiplication)object2).getArguments().size() > 2) {
                    throw new MinionException("Cannot translate n-ary product constraint:" + expression);
                }
                if (((Multiplication)object2).getArguments().size() == 1) {
                    object4[n] = -1;
                    object = ((Multiplication)object2).getArguments().remove(0);
                    object.willBeFlattenedToVariable(true);
                    object3[n] = (MinionAtom)this.toMinion((Expression)object);
                }
                if (((Multiplication)object2).getArguments().get(0).getType() == 3) {
                    object4[n] = -((ArithmeticAtomExpression)((Multiplication)object2).getArguments().remove(0)).getConstant();
                    object = ((Multiplication)object2).getArguments().remove(0);
                    object.willBeFlattenedToVariable(true);
                    object3[n] = (MinionAtom)this.toMinion((Expression)object);
                    continue;
                }
                ((Multiplication)object2).willBeFlattenedToVariable(true);
                object4[n] = -1;
                object3[n] = this.toMinion((Multiplication)object2);
                continue;
            }
            expression.willBeFlattenedToVariable(true);
            object4[n] = -1;
            object3[n] = (MinionAtom)this.toMinion(expression);
        }
        n = 1;
        for (int i = 0; i < ((Object)object4).length; ++i) {
            n = n != 0 && object4[i] == true ? 1 : 0;
        }
        if (!sumConstraint.isGonnaBeFlattenedToVariable()) {
            if (n2 == 104) {
                return n != 0 ? new SumLeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumLeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom);
            }
            if (n2 == 108) {
                return n != 0 ? new SumGeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumGeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom);
            }
            if (n2 == 101) {
                MinionConstraint minionConstraint = n != 0 ? new SumGeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumGeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom);
                this.minionModel.addConstraint(minionConstraint);
                return n != 0 ? new SumLeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumLeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom);
            }
            throw new MinionException("Internal error: tried to translate non-weak sumConstraint with weak-sumConstraint method:" + sumConstraint);
        }
        if (n2 == 104) {
            return this.reifyMinionConstraint(n != 0 ? new SumLeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumLeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom));
        }
        if (n2 == 108) {
            return this.reifyMinionConstraint(n != 0 ? new SumGeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumGeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom));
        }
        if (n2 == 101) {
            MinionConstraint minionConstraint = n != 0 ? new SumGeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumGeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom);
            object2 = n != 0 ? new SumLeqConstraint((MinionAtom[])object3, minionAtom) : new WeightedSumLeqConstraint((MinionAtom[])object3, (int[])object4, minionAtom);
            object = this.reifyMinionConstraint(minionConstraint);
            MinionAtom minionAtom2 = this.reifyMinionConstraint((MinionConstraint)object2);
            MinionAtom minionAtom3 = this.createMinionAuxiliaryVariable();
            if (this.settings.getAuxVarDetails()) {
                this.addToAuxVarDetails(((Object)minionAtom3).toString(), sumConstraint);
            }
            ProductConstraint productConstraint = new ProductConstraint((MinionAtom)object, minionAtom2, minionAtom3);
            this.minionModel.addConstraint(productConstraint);
            return minionAtom3;
        }
        throw new MinionException("Internal error: tried to translate non-weak sumConstraint with weak-sumConstraint method:" + sumConstraint);
    }

    private MinionConstraint toSimpleUnReifiedWeakSumConstraint(SumConstraint sumConstraint) throws MinionException {
        int n = sumConstraint.getRelationalOperator();
        Expression[] expressionArray = sumConstraint.getPositiveArguments();
        Expression expression = sumConstraint.getResult();
        boolean bl = expression.getType() == 0 || expression.getType() == 3;
        MinionAtom[] minionAtomArray = new MinionAtom[expressionArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            expressionArray[i].willBeFlattenedToVariable(true);
            minionAtomArray[i] = (MinionAtom)this.toMinion(expressionArray[i]);
            if (!bl || this.minionModel.variableHasBooleanDomain(minionAtomArray[i].getVariableName())) continue;
            bl = false;
        }
        expression.willBeFlattenedToVariable(true);
        MinionAtom minionAtom = (MinionAtom)this.toMinion(expression);
        if (n == 104) {
            if (this.minionModel.solverSettings.useWatchedSum()) {
                if (bl && !sumConstraint.isNested()) {
                    return new SumLeqConstraint(minionAtomArray, minionAtom, true);
                }
                return new SumLeqConstraint(minionAtomArray, minionAtom, false);
            }
            return new SumLeqConstraint(minionAtomArray, minionAtom);
        }
        if (n == 108) {
            if (this.minionModel.solverSettings.useWatchedSum()) {
                if (bl && !sumConstraint.isNested()) {
                    return new SumGeqConstraint(minionAtomArray, minionAtom, true);
                }
                return new SumGeqConstraint(minionAtomArray, minionAtom, false);
            }
            return new SumGeqConstraint(minionAtomArray, minionAtom);
        }
        if (n == 101) {
            if (this.minionModel.solverSettings.useWatchedSum()) {
                if (bl && !sumConstraint.isNested()) {
                    this.minionModel.addConstraint(new SumLeqConstraint(minionAtomArray, minionAtom, true));
                    return new SumGeqConstraint(minionAtomArray, minionAtom, true);
                }
                this.minionModel.addConstraint(new SumLeqConstraint(minionAtomArray, minionAtom, false));
                return new SumGeqConstraint(minionAtomArray, minionAtom, false);
            }
            this.minionModel.addConstraint(new SumLeqConstraint(minionAtomArray, minionAtom));
            return new SumGeqConstraint(minionAtomArray, minionAtom);
        }
        throw new MinionException("Internal error: expected only sumconstraint with operators =,<=,>= instead of:" + sumConstraint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MinionConstraint toMinion(NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression) throws MinionException {
        int n = nonCommutativeRelationalBinaryExpression.getOperator();
        Expression expression = nonCommutativeRelationalBinaryExpression.getLeftArgument();
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        Expression expression2 = nonCommutativeRelationalBinaryExpression.getRightArgument();
        ArithmeticAtomExpression arithmeticAtomExpression2 = null;
        if (!(expression instanceof ArithmeticAtomExpression)) {
            if (!(expression instanceof RelationalAtomExpression)) throw new MinionException("Cannot translate constraint nested in another expression as in:" + nonCommutativeRelationalBinaryExpression);
            arithmeticAtomExpression = ((RelationalAtomExpression)expression).toArithmeticExpression();
        } else {
            arithmeticAtomExpression = (ArithmeticAtomExpression)expression;
        }
        if (!(expression2 instanceof ArithmeticAtomExpression)) {
            if (!(expression2 instanceof RelationalAtomExpression)) throw new MinionException("Cannot translate constraint nested in another expression as in:" + nonCommutativeRelationalBinaryExpression);
            arithmeticAtomExpression2 = ((RelationalAtomExpression)expression2).toArithmeticExpression();
        } else {
            arithmeticAtomExpression2 = (ArithmeticAtomExpression)expression2;
        }
        IneqConstraint ineqConstraint = null;
        if (n == 104) {
            ineqConstraint = new IneqConstraint(this.toMinion(arithmeticAtomExpression), this.toMinion(arithmeticAtomExpression2), 0);
        } else if (n == 108) {
            ineqConstraint = new IneqConstraint(this.toMinion(arithmeticAtomExpression2), this.toMinion(arithmeticAtomExpression), 0);
        } else if (n == 102) {
            ineqConstraint = new IneqConstraint(this.toMinion(arithmeticAtomExpression), this.toMinion(arithmeticAtomExpression2), -1);
        } else if (n == 106) {
            ineqConstraint = new IneqConstraint(this.toMinion(arithmeticAtomExpression2), this.toMinion(arithmeticAtomExpression), -1);
        } else {
            if (n != 116) throw new MinionException("Unknown non-commutative binary relation:" + nonCommutativeRelationalBinaryExpression);
            ineqConstraint = new IneqConstraint(this.toMinion(arithmeticAtomExpression), this.toMinion(arithmeticAtomExpression2), 0);
        }
        if (!nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) return ineqConstraint;
        return this.reifyMinionConstraint(ineqConstraint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private MinionConstraint toMinion(CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression) throws MinionException {
        Object object;
        MinionAtom minionAtom;
        MinionAtom minionAtom2;
        ArithmeticAtomExpression arithmeticAtomExpression;
        ArithmeticAtomExpression arithmeticAtomExpression2;
        int n;
        block24: {
            Expression expression;
            block26: {
                MinionConstraint minionConstraint;
                block23: {
                    Expression expression2;
                    block25: {
                        n = commutativeBinaryRelationalExpression.getOperator();
                        expression2 = commutativeBinaryRelationalExpression.getLeftArgument();
                        arithmeticAtomExpression2 = null;
                        expression = commutativeBinaryRelationalExpression.getRightArgument();
                        arithmeticAtomExpression = null;
                        minionAtom2 = null;
                        minionAtom = null;
                        if (expression2 instanceof ArithmeticAtomExpression) break block25;
                        if (expression2 instanceof RelationalAtomExpression) {
                            arithmeticAtomExpression2 = ((RelationalAtomExpression)expression2).toArithmeticExpression();
                            break block23;
                        } else {
                            if (expression2 instanceof UnaryMinus) {
                                UnaryMinus unaryMinus = (UnaryMinus)expression2;
                                if (unaryMinus.getArgument() instanceof ArithmeticAtomExpression) {
                                    return new MinusEq(this.toMinion(arithmeticAtomExpression), this.toMinion((ArithmeticAtomExpression)unaryMinus.getArgument()));
                                }
                                throw new MinionException("Internal error. Cannot translate constraint nested in another expression as in:" + commutativeBinaryRelationalExpression);
                            }
                            if (expression2 instanceof AbsoluteValue) {
                                minionAtom = this.toMinion((AbsoluteValue)expression2);
                                break block23;
                            } else {
                                if (!(expression2 instanceof Negation)) {
                                    throw new MinionException("Cannot translate constraint nested in another expression as in:" + commutativeBinaryRelationalExpression);
                                }
                                object = (Negation)expression2;
                                minionConstraint = this.toMinion(((Negation)object).getArgument());
                                if (!(minionConstraint instanceof MinionAtom)) {
                                    throw new MinionException("Flattening error. Cannot apply Negation on non-flattened argument '" + minionConstraint + "' in " + commutativeBinaryRelationalExpression);
                                }
                                minionAtom = this.createMinionAuxiliaryVariable();
                                this.minionModel.constraintList.add(new DiseqConstraint(minionAtom, (MinionAtom)minionConstraint));
                            }
                        }
                        break block23;
                    }
                    arithmeticAtomExpression2 = (ArithmeticAtomExpression)expression2;
                }
                if (expression instanceof ArithmeticAtomExpression) break block26;
                if (expression instanceof RelationalAtomExpression) {
                    arithmeticAtomExpression = ((RelationalAtomExpression)expression).toArithmeticExpression();
                    break block24;
                } else {
                    if (expression instanceof UnaryMinus) {
                        object = (UnaryMinus)expression;
                        if (((UnaryMinus)object).getArgument() instanceof ArithmeticAtomExpression) {
                            return new MinusEq(this.toMinion(arithmeticAtomExpression2), this.toMinion((ArithmeticAtomExpression)((UnaryMinus)object).getArgument()));
                        }
                        throw new MinionException("Internal error. Cannot translate constraint nested in another expression as in:" + commutativeBinaryRelationalExpression);
                    }
                    if (expression instanceof AbsoluteValue) {
                        minionAtom2 = this.toMinion((AbsoluteValue)expression);
                        break block24;
                    } else {
                        if (!(expression instanceof Negation)) {
                            throw new MinionException("Internal error. Cannot translate constraint nested in another expression as in:" + commutativeBinaryRelationalExpression);
                        }
                        object = (Negation)expression;
                        minionConstraint = this.toMinion(((Negation)object).getArgument());
                        if (!(minionConstraint instanceof MinionAtom)) {
                            throw new MinionException("Flattening error. Cannot apply Negation on non-flattened argument '" + minionConstraint + "' in " + commutativeBinaryRelationalExpression);
                        }
                        if (minionAtom == null) {
                            minionAtom = this.toMinion(arithmeticAtomExpression2);
                        }
                        return new DiseqConstraint(minionAtom, (MinionAtom)minionConstraint);
                    }
                }
            }
            arithmeticAtomExpression = (ArithmeticAtomExpression)expression;
        }
        object = null;
        if (minionAtom == null) {
            minionAtom = this.toMinion(arithmeticAtomExpression2);
        }
        if (minionAtom2 == null) {
            minionAtom2 = this.toMinion(arithmeticAtomExpression);
        }
        if (n == 101 || n == 115) {
            object = new EqConstraint(minionAtom, minionAtom2);
        } else {
            if (n != 100) {
                throw new MinionException("Unknown commutative binary relation:" + commutativeBinaryRelationalExpression);
            }
            object = new DiseqConstraint(minionAtom, minionAtom2);
        }
        if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
            return this.reifyMinionConstraint((MinionConstraint)object);
        }
        return object;
    }

    private MinionAtom reifyMinionConstraint(MinionConstraint minionConstraint) throws MinionException {
        MinionAtom minionAtom = null;
        if (this.hasCommonSubExpression(minionConstraint)) {
            return this.getCommonSubExpression(minionConstraint);
        }
        minionAtom = this.createMinionAuxiliaryVariable();
        Reify reify = new Reify(minionConstraint, minionAtom);
        this.minionModel.addConstraint(reify);
        return minionAtom;
    }

    private MinionAtom createMinionAuxiliaryVariable() {
        SingleVariable singleVariable = new SingleVariable("aux" + this.noMinionAuxVars++, new BoolDomain());
        MinionSingleVariable minionSingleVariable = new MinionSingleVariable("aux" + (this.noMinionAuxVars - 1));
        this.minionModel.addAuxiliaryVariable(singleVariable);
        return minionSingleVariable;
    }

    private MinionAtom createMinionAuxiliaryVariable(int n, int n2) {
        SingleVariable singleVariable = new SingleVariable("aux" + this.noMinionAuxVars++, new BoundedIntRange(n, n2));
        MinionSingleVariable minionSingleVariable = new MinionSingleVariable("aux" + (this.noMinionAuxVars - 1));
        this.minionModel.addAuxiliaryVariable(singleVariable);
        return minionSingleVariable;
    }

    private Variable createAuxVariable(int n, int n2) {
        SingleVariable singleVariable = new SingleVariable(this.MINION_AUXVAR_NAME + this.noMinionAuxVars++, new BoundedIntRange(n, n2));
        this.minionModel.addAuxiliaryVariable(singleVariable);
        return singleVariable;
    }

    private Variable createAuxVariable() {
        SingleVariable singleVariable = new SingleVariable(this.MINION_AUXVAR_NAME + this.noMinionAuxVars++, new BoolDomain());
        this.minionModel.addAuxiliaryVariable(singleVariable);
        return singleVariable;
    }

    private MinionAtom toMinion(ArithmeticAtomExpression arithmeticAtomExpression) throws MinionException {
        if (arithmeticAtomExpression.getType() == 3) {
            return new MinionConstant(arithmeticAtomExpression.getConstant());
        }
        Variable variable = arithmeticAtomExpression.getVariable();
        if (variable instanceof ArrayVariable) {
            ArrayVariable arrayVariable = (ArrayVariable)variable;
            int[] nArray = arrayVariable.getIntegerIndices();
            if (nArray == null) {
                throw new MinionException("Flattening error. Cannot translate array element with non-constant element index:" + arithmeticAtomExpression);
            }
            if (arithmeticAtomExpression.isNegated()) {
                return new MinionArrayElement(arrayVariable.getArrayNameOnly(), nArray, true);
            }
            return new MinionArrayElement(arrayVariable.getArrayNameOnly(), nArray);
        }
        if (arithmeticAtomExpression.isNegated()) {
            return new MinionSingleVariable(variable.getVariableName(), true);
        }
        return new MinionSingleVariable(variable.getVariableName());
    }

    protected MinionAtom toMinion(RelationalAtomExpression relationalAtomExpression) throws MinionException {
        if (relationalAtomExpression.getType() == 0) {
            return relationalAtomExpression.getBool() ? new MinionConstant(1) : new MinionConstant(0);
        }
        Variable variable = relationalAtomExpression.getVariable();
        if (variable instanceof ArrayVariable) {
            ArrayVariable arrayVariable = (ArrayVariable)variable;
            int[] nArray = arrayVariable.getIntegerIndices();
            if (nArray == null) {
                throw new MinionException("Flattening error. Cannot translate array element with non-constant element index:" + relationalAtomExpression);
            }
            return new MinionArrayElement(arrayVariable.getArrayNameOnly(), nArray, relationalAtomExpression.isNegated());
        }
        return new MinionSingleVariable(variable.getVariableName(), relationalAtomExpression.isNegated());
    }

    protected void addToSubExpressions(Expression expression, ArithmeticAtomExpression arithmeticAtomExpression) {
        if (!this.useCommonSubexpressions) {
            return;
        }
        this.essenceSubExpressions.put(((Object)expression).toString(), arithmeticAtomExpression);
    }

    protected void addToSubExpressions(MinionConstraint minionConstraint, MinionAtom minionAtom) {
        if (!this.useCommonSubexpressions) {
            return;
        }
        this.minionSubExpressions.put(((Object)minionConstraint).toString(), minionAtom);
    }

    protected void addToAuxVarDetails(String string, Expression expression) {
        this.normalisedModel.addAuxVarDetail(string, expression);
    }

    protected ArithmeticAtomExpression getCommonSubExpression(Expression expression) {
        ++this.usedCommonSubExpressions;
        String string = ((Object)expression).toString();
        if (this.settings.getCseDetails() || this.settings.useCSEVarOrdering()) {
            if (this.subexpressionCount.containsKey(string)) {
                Integer n = this.subexpressionCount.get(string);
                n = n + 1;
                this.subexpressionCount.put(string, n);
            } else {
                this.subexpressionList.add(string);
                this.subexpressionCount.put(string, new Integer(1));
            }
        }
        return this.essenceSubExpressions.get(((Object)expression).toString());
    }

    protected MinionAtom getCommonSubExpression(MinionConstraint minionConstraint) {
        ++this.usedCommonSubExpressions;
        String string = ((Object)minionConstraint).toString();
        if (this.settings.getCseDetails() || this.settings.useCSEVarOrdering()) {
            if (this.subexpressionCount.containsKey(string)) {
                Integer n = this.subexpressionCount.get(string);
                n = n + 1;
                this.subexpressionCount.put(string, n);
            } else {
                this.subexpressionList.add(string);
                this.subexpressionCount.put(string, new Integer(1));
            }
        }
        return this.minionSubExpressions.get(((Object)minionConstraint).toString());
    }

    protected boolean hasCommonSubExpression(MinionConstraint minionConstraint) {
        if (!this.useCommonSubexpressions) {
            return false;
        }
        return this.minionSubExpressions.containsKey(((Object)minionConstraint).toString());
    }

    protected boolean hasCommonSubExpression(Expression expression) {
        if (!this.useCommonSubexpressions) {
            return false;
        }
        return this.essenceSubExpressions.containsKey(((Object)expression).toString());
    }

    private void writeTimeInfo(String string) {
        if (this.settings.giveTranslationTimeInfo()) {
            System.out.println(string);
        }
    }

    public String getCseInfo() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.settings.getCseDetails()) {
            return stringBuffer.toString();
        }
        ArrayList<String> arrayList = this.normalisedModel.getSubexpressionList();
        if (arrayList.size() == 0) {
            stringBuffer.append("No common subexpression eliminated\n");
            return stringBuffer.toString();
        }
        stringBuffer.append("#Common Subexpressions Eliminated: " + this.usedCommonSubExpressions + "\n");
        stringBuffer.append("#Common Subexpressions: " + arrayList.size() + "\n\n");
        HashMap<String, Integer> hashMap = this.normalisedModel.getSubexpressionCount();
        stringBuffer.append("<#Occurrences>\t<Common Subexpression>\n\n");
        for (n = 0; n < arrayList.size(); ++n) {
            String string = arrayList.get(n);
            stringBuffer.append("<" + hashMap.get(string) + ">" + "\t<" + string + ">\n");
        }
        n = 0;
        for (int i = 0; i < this.subexpressionList.size(); ++i) {
            n += this.subexpressionCount.get(this.subexpressionList.get(i)).intValue();
        }
        stringBuffer.append("\nSUM: " + n + "\n");
        stringBuffer.append("END\n");
        return stringBuffer.toString();
    }
}

