/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.minion;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.BoolDomain;
import translator.expression.BoundedIntRange;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.SingleIntRange;
import translator.expression.SparseIntRange;
import translator.expression.Variable;
import translator.solver.Minion;
import translator.tailor.minion.DiseqConstraint;
import translator.tailor.minion.MinionAliasMatrix;
import translator.tailor.minion.MinionAliasVector;
import translator.tailor.minion.MinionAtom;
import translator.tailor.minion.MinionConstant;
import translator.tailor.minion.MinionConstraint;
import translator.tailor.minion.MinionException;
import translator.tailor.minion.MinionSingleVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinionModel {
    public final String MINION_HEADER = "MINION 3";
    public final int DISCRETE_UPPER_BOUND = 200;
    public final String REDUCED_ARRAY_SUFFIX = "_ORIG";
    ArrayList<MinionConstraint> constraintList;
    HashMap<String, ConstantDomain> decisionVariables;
    HashMap<String, MinionAtom> equalAtoms;
    HashMap<String, Boolean> variableIsDiscrete = new HashMap();
    ArrayList<String> decisionVariablesNames;
    ArrayList<String> allOriginalDecisionVariables;
    HashMap<String, ConstantDomain> allDecisionVariablesDomains;
    ArrayList<String> variableAliases;
    ArrayList<Variable> auxVariables;
    HashMap<String, Domain> auxVarDomains;
    HashMap<String, Expression> auxVarDetails;
    Minion solverSettings;
    int usedCommonSubExpressions;
    int usedInferredEqualSubExpressions;
    int noSimpleConjunctionCSEs = 0;
    int noSimpleDisjunctionCSEs = 0;
    int noNegatedCSEs = 0;
    MinionAtom objective;
    boolean maximising;
    TranslationSettings settings;
    HashMap<String, ArithmeticAtomExpression> essenceCommonSubexpressions;
    HashMap<String, MinionAtom> minionCommonSubexpressions;
    HashMap<String, Integer> subexpressionCount;
    HashMap<String, Boolean> variableAppearsInDiseqConstraint;

    public MinionModel(ArrayList<MinionConstraint> arrayList, HashMap<String, ConstantDomain> hashMap, ArrayList<String> arrayList2, ArrayList<Variable> arrayList3, Minion minion, TranslationSettings translationSettings, HashMap<String, ArithmeticAtomExpression> hashMap2, HashMap<String, MinionAtom> hashMap3, HashMap<String, Integer> hashMap4) {
        this.constraintList = arrayList;
        this.decisionVariables = hashMap;
        this.decisionVariablesNames = arrayList2;
        this.allOriginalDecisionVariables = (ArrayList)arrayList2.clone();
        this.allDecisionVariablesDomains = (HashMap)hashMap.clone();
        this.auxVariables = arrayList3;
        this.auxVarDomains = new HashMap();
        for (int i = 0; i < this.auxVariables.size(); ++i) {
            Variable variable = arrayList3.get(i);
            int[] nArray = variable.getDomain();
            if (nArray[0] == 0 && nArray[1] == 1) {
                this.auxVarDomains.put(variable.getVariableName(), new BoolDomain());
                continue;
            }
            this.auxVarDomains.put(variable.getVariableName(), new BoundedIntRange(nArray[0], nArray[1]));
        }
        this.essenceCommonSubexpressions = hashMap2;
        this.minionCommonSubexpressions = hashMap3;
        this.subexpressionCount = hashMap4;
        this.solverSettings = minion;
        this.usedCommonSubExpressions = 0;
        this.usedInferredEqualSubExpressions = 0;
        this.variableAliases = new ArrayList();
        this.settings = translationSettings;
        this.equalAtoms = new HashMap();
        this.variableAppearsInDiseqConstraint = new HashMap();
        this.auxVarDetails = new HashMap();
    }

    public void setAmountOfUsedCommonSubExpressions(int n) {
        this.usedCommonSubExpressions = n;
    }

    public void setAmountOfUsedEqualSubExpressions(int n) {
        this.usedInferredEqualSubExpressions = n;
    }

    public void setVariableAppearsInDisequality(String string) {
        this.variableAppearsInDiseqConstraint.put(string, new Boolean(true));
    }

    public void setNoSimpleConjunctionCSEs(int n) {
        this.noSimpleConjunctionCSEs = n;
    }

    public void setNoSimpleDisjunctionCSEs(int n) {
        this.noSimpleDisjunctionCSEs = n;
    }

    public void setAuxVarDetails(HashMap<String, Expression> hashMap) {
        this.auxVarDetails = hashMap;
    }

    public void setNoNegatedCSEs(int n) {
        this.noNegatedCSEs = n;
    }

    public void setObjective(MinionAtom minionAtom, boolean bl) {
        this.objective = minionAtom;
        this.maximising = bl;
    }

    public void setEqualAtoms(HashMap<String, MinionAtom> hashMap) {
        this.equalAtoms = hashMap;
    }

    protected void addConstraint(MinionConstraint minionConstraint) {
        this.constraintList.add(minionConstraint);
    }

    protected void applyEqualAtoms() throws MinionException {
        if (this.equalAtoms.size() == 0) {
            return;
        }
        for (int i = this.decisionVariablesNames.size() - 1; i >= 0; --i) {
            Object object;
            Domain domain;
            Object object2;
            String string = this.decisionVariablesNames.get(i);
            if (this.equalAtoms.containsKey(string)) {
                object2 = this.equalAtoms.get(string);
                domain = this.decisionVariables.get(string);
                if (domain == null) {
                    throw new MinionException("Internal error: Unknown replacement variable: " + string);
                }
                object = new StringBuffer("ALIAS ").append(string + " = " + object2.toString());
                this.addAlias(((StringBuffer)object).toString());
                this.decisionVariablesNames.remove(i);
                this.decisionVariables.remove(string);
                continue;
            }
            object2 = this.decisionVariables.get(string);
            if (!(object2 instanceof ConstantArrayDomain)) continue;
            domain = (ConstantArrayDomain)object2;
            object = ((ConstantArrayDomain)domain).getIndexDomains();
            if (((ConstantDomain[])object).length == 1) {
                int n = object[0].getRange()[1] - object[0].getRange()[0] + 1;
                MinionAliasVector minionAliasVector = new MinionAliasVector(string, n);
                String string2 = string + this.REDUCED_ARRAY_SUFFIX;
                int n2 = 0;
                boolean bl = false;
                for (int j = 0; j < n; ++j) {
                    if (this.equalAtoms.containsKey(string + "[" + j + "]")) {
                        String string3 = ((Object)this.equalAtoms.get(string + "[" + j + "]")).toString();
                        if (string3.startsWith(string + "[")) {
                            minionAliasVector.placeElementAt(string3.replaceFirst(string, string2), j);
                        } else {
                            minionAliasVector.placeElementAt(string3, j);
                        }
                        bl = true;
                        continue;
                    }
                    minionAliasVector.placeElementAt(string2 + "[" + n2 + "]", j);
                    ++n2;
                }
                if (bl) {
                    String string4 = "ALIAS " + string + "[" + n + "] = " + minionAliasVector.toString();
                    this.addAlias(string4);
                    this.decisionVariablesNames.remove(i);
                    this.decisionVariables.remove(string);
                    if (n2 <= 0) continue;
                    this.decisionVariablesNames.add(i, string2);
                    this.decisionVariables.put(string2, new ConstantArrayDomain(new BoundedIntRange[]{new BoundedIntRange(0, n2 - 1)}, ((ConstantArrayDomain)domain).getBaseDomain()));
                    continue;
                }
                minionAliasVector = null;
                continue;
            }
            if (((ConstantDomain[])object).length == 2) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                int n = object[0].getRange()[1] - object[0].getRange()[0] + 1;
                int n3 = object[1].getRange()[1] - object[1].getRange()[0] + 1;
                MinionAliasMatrix minionAliasMatrix = new MinionAliasMatrix(string, n3, n);
                String string5 = string + this.REDUCED_ARRAY_SUFFIX;
                int n4 = 0;
                boolean bl = false;
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n; ++k) {
                        if (this.equalAtoms.containsKey(string + "[" + j + ", " + k + "]")) {
                            MinionAtom minionAtom = this.equalAtoms.get(string + "[" + j + ", " + k + "]");
                            String string6 = minionAtom.getVariableName();
                            if (string6.equals(string)) {
                                int n5 = (Integer)hashMap.get(((Object)minionAtom).toString());
                                String string7 = string5 + "[" + n5 + "]";
                                minionAliasMatrix.placeElementAt(string7, j, k);
                            } else {
                                minionAliasMatrix.placeElementAt(((Object)minionAtom).toString(), j, k);
                            }
                            bl = true;
                            continue;
                        }
                        minionAliasMatrix.placeElementAt(string5 + "[" + n4 + "]", j, k);
                        hashMap.put(string + "[" + j + ", " + k + "]", n4);
                        ++n4;
                    }
                }
                if (bl) {
                    String string8 = "ALIAS " + string + "[" + n3 + "," + n + "] = " + minionAliasMatrix.toString();
                    this.addAlias(string8);
                    this.decisionVariablesNames.remove(i);
                    this.decisionVariables.remove(string);
                    if (n4 <= 0) continue;
                    this.decisionVariablesNames.add(i, string5);
                    this.decisionVariables.put(string5, new ConstantArrayDomain(new BoundedIntRange[]{new BoundedIntRange(0, n4 - 1)}, ((ConstantArrayDomain)domain).getBaseDomain()));
                    continue;
                }
                minionAliasMatrix = null;
                continue;
            }
            throw new MinionException("Sorry, cannot perform direct variable usage on arrays larger than 2-dimensions yet, sorry:" + string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MINION 3\n\n");
        stringBuffer.append("#" + this.settings.OUTPUTFILE_HEADER + "\n");
        stringBuffer.append("#" + this.settings.OUTPUTFILE_HEADER_BUGS + "\n\n");
        if (this.settings.giveTranslationInfo()) {
            stringBuffer.append(this.printStatistics() + "\n\n");
        }
        stringBuffer.append(this.printVariables());
        stringBuffer.append(this.printSearch());
        stringBuffer.append("\n" + this.printConstraints());
        this.printModelStatistics();
        return stringBuffer + "\n**EOF**\n";
    }

    private String printSearch() {
        StringBuffer stringBuffer = new StringBuffer("**SEARCH**\n\n");
        if (this.objective != null) {
            if (this.maximising) {
                stringBuffer.append("MAXIMISING ");
            } else {
                stringBuffer.append("MINIMISING ");
            }
            stringBuffer.append(this.objective + "\n\n");
        }
        StringBuffer stringBuffer2 = new StringBuffer("PRINT [");
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < this.allOriginalDecisionVariables.size(); ++i) {
            String string = this.allOriginalDecisionVariables.get(i);
            if (string.startsWith("aux")) continue;
            if (i > 0) {
                stringBuffer3.append(",");
            }
            if (i % 8 == 0) {
                stringBuffer3.append("\n");
            }
            if (this.allDecisionVariablesDomains.get(this.allOriginalDecisionVariables.get(i)).getType() != 10) {
                stringBuffer3.append("[" + this.allOriginalDecisionVariables.get(i) + "]");
                continue;
            }
            stringBuffer3.append(this.allOriginalDecisionVariables.get(i));
        }
        stringBuffer2.append(stringBuffer3).append("]\n\n");
        StringBuffer stringBuffer4 = new StringBuffer("");
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            if (this.decisionVariablesNames.get(i).startsWith("aux")) continue;
            if (i > 0) {
                stringBuffer4.append(",");
            }
            if (i % 8 == 0) {
                stringBuffer4.append("\n");
            }
            stringBuffer4.append(this.decisionVariablesNames.get(i));
        }
        StringBuffer stringBuffer5 = new StringBuffer("VARORDER [" + stringBuffer4);
        StringBuffer stringBuffer6 = new StringBuffer("");
        StringBuffer stringBuffer7 = new StringBuffer("");
        if (this.settings.useCSEVarOrdering()) {
            int n = 0;
            for (int i = 0; i < this.auxVariables.size(); ++i) {
                Variable variable = this.auxVariables.get(i);
                if (this.isEssenceCommonSubexpression(variable.getVariableName())) {
                    ++n;
                    if (stringBuffer7.length() > 0) {
                        stringBuffer7.append(",");
                    }
                    if (n % 8 == 0) {
                        stringBuffer7.append("\n");
                    }
                    stringBuffer7.append(this.auxVariables.get(i).toString());
                    continue;
                }
                if (stringBuffer6.length() > 0) {
                    stringBuffer6.append(",");
                }
                if ((i - n) % 8 == 0) {
                    stringBuffer6.append("\n");
                }
                stringBuffer6.append(this.auxVariables.get(i).toString());
            }
        } else {
            for (int i = 0; i < this.auxVariables.size(); ++i) {
                if (i > 0) {
                    stringBuffer6.append(",");
                }
                if (i % 8 == 0) {
                    stringBuffer6.append("\n");
                }
                stringBuffer6.append(this.auxVariables.get(i).toString());
            }
        }
        if (stringBuffer7.length() > 0) {
            stringBuffer5.append(",\n# CSE aux vars\n").append(stringBuffer7).append(",\n# non-CSE aux vars\n").append(stringBuffer6).append("]\n\n");
        } else if (stringBuffer6.length() > 0) {
            stringBuffer5.append(",").append(stringBuffer6).append("]\n\n");
        } else {
            stringBuffer5.append("]\n\n");
        }
        return stringBuffer + stringBuffer2.toString() + stringBuffer5;
    }

    private String printStatistics() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("# Model statistics:\n");
        stringBuffer.append("#   Constraints:" + this.constraintList.size() + "\n");
        stringBuffer.append("#   Auxiliary variables: " + this.auxVariables.size() + "\n");
        if (this.settings.useCommonSubExpressions()) {
            if (this.usedCommonSubExpressions > 0) {
                stringBuffer.append("#   Eliminated common subexpressions:" + this.usedCommonSubExpressions + "\n");
            }
        } else {
            stringBuffer.append("#   Did not eliminate common subexpressions\n");
        }
        if (this.settings.useEqualCommonSubExpressions()) {
            if (this.usedInferredEqualSubExpressions > 0) {
                stringBuffer.append("#   Eliminated inferred common subexpressions:" + this.usedInferredEqualSubExpressions + "\n");
            }
        } else {
            stringBuffer.append("#   Did not eliminate inferred common subexpressions\n");
        }
        if (this.settings.useExplicitCommonSubExpressions()) {
            if (this.equalAtoms.size() > 0) {
                stringBuffer.append("#   Variables eliminated over direct equality:" + this.equalAtoms.size() + "\n");
            }
        } else {
            stringBuffer.append("#   Did not eliminate variables over direct equality\n");
        }
        if (this.settings.useNegatedCSEs() && this.noNegatedCSEs > 0) {
            stringBuffer.append("#   Eliminated negated common subexpressions: " + this.noNegatedCSEs + "\n");
        }
        if (this.settings.getUseSimpleConjunctionCSE() && this.noSimpleConjunctionCSEs > 0) {
            stringBuffer.append("#   Eliminated CS in conjunctions:" + this.noSimpleConjunctionCSEs + "\n");
        }
        if (this.settings.getUseSimpleDisjunctionCSE() && this.noSimpleDisjunctionCSEs > 0) {
            stringBuffer.append("#   Eliminated CS in disjunctions:" + this.noSimpleDisjunctionCSEs + "\n");
        }
        return stringBuffer.toString();
    }

    private String printConstraints() {
        StringBuffer stringBuffer = new StringBuffer("**CONSTRAINTS**\n\n");
        for (int i = 0; i < this.constraintList.size(); ++i) {
            stringBuffer.append(((Object)this.constraintList.get(i)).toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private String printVariables() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer3 = new StringBuffer("**VARIABLES**\n");
        for (n = 0; n < this.decisionVariablesNames.size(); ++n) {
            int n2;
            Object object3;
            object2 = this.decisionVariablesNames.get(n);
            object = this.decisionVariables.get(object2);
            stringBuffer2 = new StringBuffer("");
            stringBuffer = new StringBuffer("");
            if (object instanceof BoolDomain) {
                stringBuffer2.append("BOOL");
            } else if (object instanceof SparseIntRange) {
                Object object4;
                object3 = ((SparseIntRange)object).getFullDomain();
                int n3 = object3[((int[])object3).length - 1] - object3[0] - 1;
                if (n3 <= this.settings.DISCRETE_UPPER_BOUND) {
                    stringBuffer2.append("DISCRETE");
                    stringBuffer.append("{" + (int)object3[0] + ".." + (int)object3[((Object)object3).length - 1] + "}");
                    object4 = object3[0];
                    for (n2 = 0; n2 < ((Object)object3).length; ++n2) {
                        if (object3[n2] != object4) {
                            while (object3[n2] != object4) {
                                this.constraintList.add(new DiseqConstraint(new MinionSingleVariable((String)object2), new MinionConstant((int)object4)));
                                ++object4;
                            }
                        }
                        ++object4;
                    }
                } else {
                    stringBuffer2.append("SPARSEBOUND");
                    stringBuffer.append("{" + (int)object3[0]);
                    for (object4 = 1; object4 < ((Object)object3).length; ++object4) {
                        stringBuffer.append("," + (int)object3[object4]);
                    }
                    stringBuffer.append("}");
                }
            } else if (object instanceof BoundedIntRange) {
                object3 = ((BoundedIntRange)object).getRange();
                if (object3[1] - object3[0] > this.settings.getDiscreteUpperBound()) {
                    stringBuffer2.append("BOUND");
                } else {
                    stringBuffer2.append("DISCRETE");
                }
                stringBuffer.append("{" + (int)object3[0] + ".." + (int)object3[1] + "}");
            } else if (object instanceof SingleIntRange) {
                stringBuffer2.append("DISCRETE");
                stringBuffer.append("{" + ((SingleIntRange)object).getSingleRange() + ".." + ((SingleIntRange)object).getSingleRange() + "}");
            } else if (object instanceof ConstantArrayDomain) {
                int n4;
                object3 = (ConstantArrayDomain)object;
                ConstantDomain constantDomain = object3.getBaseDomain();
                if (constantDomain instanceof BoolDomain) {
                    stringBuffer2.append("BOOL");
                } else if (constantDomain instanceof SparseIntRange) {
                    stringBuffer2.append("SPARSEBOUND");
                    int[] nArray = ((SparseIntRange)constantDomain).getFullDomain();
                    stringBuffer.append("{" + nArray[0]);
                    if (nArray.length > 1) {
                        for (n2 = 1; n2 < nArray.length; ++n2) {
                            stringBuffer.append("," + nArray[n2]);
                        }
                    }
                    stringBuffer.append("}");
                } else if (constantDomain instanceof BoundedIntRange) {
                    int[] nArray = ((BoundedIntRange)constantDomain).getRange();
                    if (nArray[1] - nArray[0] > this.settings.getDiscreteUpperBound()) {
                        stringBuffer2.append("BOUND");
                    } else {
                        stringBuffer2.append("DISCRETE");
                    }
                    stringBuffer.append("{" + nArray[0] + ".." + nArray[1] + "}");
                }
                ConstantDomain[] constantDomainArray = object3.getIndexDomains();
                int[] nArray = new int[constantDomainArray.length];
                StringBuffer stringBuffer4 = new StringBuffer("");
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (constantDomainArray[n4] instanceof BoolDomain) {
                        nArray[n4] = 2;
                        continue;
                    }
                    if (constantDomainArray[n4] instanceof BoundedIntRange) {
                        int[] nArray2 = ((BoundedIntRange)constantDomainArray[n4]).getRange();
                        nArray[n4] = nArray2[1] - nArray2[0] + 1;
                        continue;
                    }
                    if (!(constantDomainArray[n4] instanceof SingleIntRange)) continue;
                    nArray[n4] = 1;
                }
                stringBuffer4.append(nArray[0] + "");
                for (n4 = 1; n4 < nArray.length; ++n4) {
                    stringBuffer4.append("," + nArray[n4]);
                }
                object2 = (String)object2 + "[" + stringBuffer4 + "]";
            }
            stringBuffer3.append(stringBuffer2 + " " + (String)object2 + " " + stringBuffer + "\n");
        }
        if (this.auxVariables.size() > 0) {
            stringBuffer3.append("\n# auxiliary variables\n");
        }
        for (n = 0; n < this.auxVariables.size(); ++n) {
            object2 = this.auxVariables.get(n);
            object = object2.getDomain();
            stringBuffer2 = new StringBuffer("");
            stringBuffer = new StringBuffer("");
            if (object[0] == false && object[1] == true) {
                stringBuffer2.append("BOOL");
            } else {
                if (object[1] - object[0] > this.DISCRETE_UPPER_BOUND) {
                    stringBuffer2.append("BOUND");
                } else {
                    stringBuffer2.append("DISCRETE");
                }
                stringBuffer.append("{" + (int)object[0] + ".." + (int)object[1] + "}");
            }
            stringBuffer3.append(stringBuffer2 + " " + object2.getVariableName() + " " + stringBuffer);
            if (this.settings.getAuxVarDetails()) {
                if (this.auxVarDetails.containsKey(object2.getVariableName())) {
                    stringBuffer3.append(" # " + ((Object)this.auxVarDetails.get(object2.getVariableName())).toString() + "\n");
                    continue;
                }
                stringBuffer3.append(" # no info available (bug)\n");
                continue;
            }
            stringBuffer3.append("\n");
        }
        stringBuffer3.append("\n# aliases\n");
        for (n = this.variableAliases.size() - 1; n >= 0; --n) {
            stringBuffer3.append(this.variableAliases.get(n) + "\n");
        }
        return stringBuffer3 + "\n";
    }

    protected void addAuxiliaryVariable(Variable variable) {
        this.auxVariables.add(variable);
        int[] nArray = variable.getDomain();
        if (nArray[0] == 0 && nArray[1] == 1) {
            this.auxVarDomains.put(variable.getVariableName(), new BoolDomain());
        } else {
            this.auxVarDomains.put(variable.getVariableName(), new BoundedIntRange(nArray[0], nArray[1]));
        }
    }

    protected boolean variableHasBooleanDomain(String string) {
        if (this.decisionVariables.containsKey(string)) {
            Domain domain = this.decisionVariables.get(string);
            if (domain instanceof ArrayDomain) {
                Domain domain2 = ((ArrayDomain)domain).getBaseDomain();
                return domain2 instanceof BoolDomain;
            }
            if (domain instanceof ConstantArrayDomain) {
                ConstantDomain constantDomain = ((ConstantArrayDomain)domain).getBaseDomain();
                return constantDomain instanceof BoolDomain;
            }
            return domain instanceof BoolDomain;
        }
        if (this.auxVarDomains.containsKey(string)) {
            Domain domain = this.auxVarDomains.get(string);
            return domain instanceof BoolDomain;
        }
        return false;
    }

    public void addAlias(String string) {
        for (int i = 0; i < this.variableAliases.size(); ++i) {
            if (!this.variableAliases.get(i).equals(string)) continue;
            return;
        }
        this.variableAliases.add(string);
    }

    public String getEssenceSolution(String string) {
        int n;
        if (this.objective != null) {
            return this.getEssenceSolutionFromOptimisationProblem(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = "$ Solving statistics:\n$\n";
        String string3 = "";
        int n2 = 0;
        boolean bl = true;
        while (n2 + 8 < stringBuilder.length()) {
            if (stringBuilder.substring(n2, n2 + 4).equals("Solu")) {
                ++n2;
                continue;
            }
            if (stringBuilder.substring(n2, n2 + 4).equals("Solv")) {
                ++n2;
                continue;
            }
            if (stringBuilder.substring(n2, n2 + 3).equals("Sol")) {
                string3 = stringBuilder.substring(0, n2 - 1);
                stringBuilder = stringBuilder.delete(0, n2 - 1);
                bl = false;
                break;
            }
            if (stringBuilder.substring(n2, n2 + 3).equals("ble") && stringBuilder.substring(n2 + 6, n2 + 8).equals("no")) {
                string3 = stringBuilder.substring(0, n2 + 8);
                bl = true;
                break;
            }
            ++n2;
        }
        StringBuilder stringBuilder2 = new StringBuilder(string3);
        String string4 = "";
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < stringBuilder2.length(); ++i) {
            if (stringBuilder2.charAt(i) == '#') {
                stringBuilder2.deleteCharAt(i);
                stringBuilder2.insert(i, '$');
            }
            if (i + 7 < stringBuilder2.length() && stringBuilder2.substring(i, i + 7).equals("Parsing")) {
                n4 = i;
            }
            if (i + 7 >= stringBuilder2.length() || !stringBuilder2.substring(i, i + 7).equals("Parsing") && !stringBuilder2.substring(i, i + 5).equals("Setup") && !stringBuilder2.substring(i, i + 5).equals("First") && !stringBuilder2.substring(i, i + 7).equals("Initial")) continue;
            stringBuilder2.insert(i, '$');
            stringBuilder2.insert(i + 1, ' ');
            if (n3 == 0) {
                n2 = i;
            }
            ++n3;
            i += 2;
        }
        string4 = stringBuilder2.substring(n4, stringBuilder2.length());
        String string5 = "";
        if (!bl) {
            for (n = 0; n < this.allOriginalDecisionVariables.size(); ++n) {
                int n5;
                CharSequence charSequence;
                String string6 = this.allOriginalDecisionVariables.get(n);
                ConstantDomain constantDomain = this.allDecisionVariablesDomains.get(string6);
                if (constantDomain.getType() != 10) {
                    int n6 = 6;
                    while (stringBuilder.charAt(n6) != '\n' && stringBuilder.charAt(n6) != '\r') {
                        ++n6;
                    }
                    String string7 = stringBuilder.substring(5, n6 - 1);
                    string5 = string5.concat("variable " + string6 + " is " + string7 + ", \n\n");
                    stringBuilder = stringBuilder.delete(0, n6);
                    continue;
                }
                ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)constantDomain).getIndexDomains();
                if (constantDomainArray.length == 1) {
                    int n7 = 6;
                    while (stringBuilder.charAt(n7) != '\n' && stringBuilder.charAt(n7) != '\r') {
                        ++n7;
                    }
                    String string8 = "";
                    for (int i = 6; i < n7; ++i) {
                        String string9 = "";
                        while (stringBuilder.charAt(i) != ' ' && stringBuilder.charAt(i) != '\n' && stringBuilder.charAt(i) != '\r') {
                            string9 = string9 + stringBuilder.charAt(i);
                            ++i;
                        }
                        string8 = string8.concat(string9 + ", ");
                    }
                    string8 = string8.substring(0, string8.length() - 2);
                    string5 = string5.concat("variable " + string6 + " is [" + string8 + "],\n\n");
                    stringBuilder = stringBuilder.delete(0, n7);
                    continue;
                }
                if (constantDomainArray.length == 2) {
                    int n8 = constantDomainArray[0].getRange()[1] - constantDomainArray[0].getRange()[0] + 1;
                    String string10 = "\n\t[ ";
                    for (int i = 0; i < n8; ++i) {
                        boolean bl2 = true;
                        charSequence = "";
                        n5 = 6;
                        while (stringBuilder.charAt(n5) != '\n' && stringBuilder.charAt(n5) != '\r') {
                            String string11 = "";
                            while (stringBuilder.charAt(n5) != ' ') {
                                string11 = string11 + stringBuilder.charAt(n5);
                                ++n5;
                            }
                            charSequence = bl2 ? string11 : (String)charSequence + ", " + string11;
                            bl2 = false;
                            ++n5;
                        }
                        string10 = i >= 1 ? string10.concat(",\n\t  [" + (String)charSequence + "]") : string10.concat("[" + (String)charSequence + "]");
                        stringBuilder = stringBuilder.delete(0, n5);
                    }
                    string10 = string10.concat(" ],\n\n");
                    string5 = string5 + "variable " + string6 + " is " + string10;
                    continue;
                }
                if (constantDomainArray.length != 3) continue;
                int n9 = constantDomainArray[0].getRange()[1] - constantDomainArray[0].getRange()[0] + 1;
                int n10 = constantDomainArray[1].getRange()[1] - constantDomainArray[1].getRange()[0] + 1;
                StringBuffer stringBuffer = new StringBuffer("[   ");
                for (int i = 0; i < n9; ++i) {
                    charSequence = new StringBuffer("[");
                    for (n5 = 0; n5 < n10; ++n5) {
                        boolean bl3 = true;
                        StringBuffer stringBuffer2 = new StringBuffer("");
                        int n11 = 6;
                        while (stringBuilder.charAt(n11) != '\n' && stringBuilder.charAt(n11) != '\r') {
                            StringBuffer stringBuffer3 = new StringBuffer("");
                            while (stringBuilder.charAt(n11) != ' ') {
                                stringBuffer3.append(stringBuilder.charAt(n11));
                                ++n11;
                            }
                            if (bl3) {
                                stringBuffer2 = stringBuffer3;
                            } else {
                                stringBuffer2.append(", " + stringBuffer3);
                            }
                            bl3 = false;
                            ++n11;
                        }
                        if (n5 >= 1) {
                            ((StringBuffer)charSequence).append(",\n\t [" + stringBuffer2 + "]");
                        } else {
                            ((StringBuffer)charSequence).append("[" + stringBuffer2 + "]");
                        }
                        stringBuilder = stringBuilder.delete(0, n11);
                    }
                    ((StringBuffer)charSequence).append(" ],");
                    stringBuffer.append("\n\t" + charSequence + "\n");
                }
                stringBuffer.append(" ]");
                string5 = string5 + "variable " + string6 + " is " + stringBuffer + "\n\n";
            }
            stringBuilder2 = stringBuilder;
        } else {
            stringBuilder2 = stringBuilder2.delete(0, n4);
        }
        for (n = 0; n < stringBuilder2.length(); ++n) {
            if (stringBuilder2.charAt(n) == '#') {
                stringBuilder2.deleteCharAt(n);
                stringBuilder2.insert(n, '$');
            }
            if (n + 7 < stringBuilder2.length() && (stringBuilder2.substring(n, n + 7).equals("Solutio") || stringBuilder2.substring(n, n + 5).equals("Solve") || stringBuilder2.substring(n, n + 7).equals("Problem") || stringBuilder2.substring(n, n + 5).equals("Total"))) {
                stringBuilder2.insert(n, '$');
                stringBuilder2.insert(n + 1, ' ');
                n += 2;
                continue;
            }
            if (n + 6 >= stringBuilder2.length() || !stringBuilder2.substring(n, n + 5).equals("\nTime") && !stringBuilder2.substring(n, n + 6).equals("\nNodes")) continue;
            stringBuilder2.insert(n + 1, '$');
            stringBuilder2.insert(n + 2, ' ');
            n += 3;
        }
        if (bl) {
            return "$ no solution found\n\n" + stringBuilder2;
        }
        string2 = string2 + string4 + stringBuilder2;
        string2 = string2 + "\n\n" + string5;
        string2 = string2.substring(0, string2.length() - 2);
        return string2;
    }

    private String getEssenceSolutionFromOptimisationProblem(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = "$ solving statistics\n$\n";
        int n = 0;
        while (n + 7 < stringBuffer.length()) {
            if (stringBuffer.substring(n, n + 7).equals("Parsing")) {
                stringBuffer = stringBuffer.delete(0, n - 1);
                break;
            }
            ++n;
        }
        if (n + 7 == stringBuffer.length()) {
            return string2 + "$ no solutions\n";
        }
        n = 0;
        while (n + 16 < stringBuffer.length()) {
            if (stringBuffer.substring(n, n + 16).equals("found with Value")) {
                while (stringBuffer.charAt(n + 16) != '\n' && n + 16 < stringBuffer.length()) {
                    ++n;
                }
                string2 = string2 + this.printEssenceOptimisationSolution(stringBuffer.substring(0, n + 16)) + "\n\n$------------------------\n";
                stringBuffer = stringBuffer.delete(0, n + 16);
                n = 0;
                continue;
            }
            ++n;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        for (n = 0; n < stringBuffer2.length(); ++n) {
            if (stringBuffer2.charAt(n) == '#') {
                stringBuffer2.deleteCharAt(n);
                stringBuffer2.insert(n, '$');
            }
            if (n + 7 < stringBuffer2.length() && (stringBuffer2.substring(n, n + 7).equals("Solutio") || stringBuffer2.substring(n, n + 5).equals("Solve") || stringBuffer2.substring(n, n + 7).equals("Problem") || stringBuffer2.substring(n, n + 5).equals("Total"))) {
                stringBuffer2.insert(n, '$');
                stringBuffer2.insert(n + 1, ' ');
                n += 2;
                continue;
            }
            if (n + 6 >= stringBuffer2.length() || !stringBuffer2.substring(n, n + 5).equals("\nTime") && !stringBuffer2.substring(n, n + 6).equals("\nNodes")) continue;
            stringBuffer2.insert(n + 1, '$');
            stringBuffer2.insert(n + 2, ' ');
            n += 3;
        }
        return string2 + "\n" + stringBuffer2;
    }

    private String printEssenceOptimisationSolution(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = "";
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '#') {
                stringBuffer.deleteCharAt(i);
                stringBuffer.insert(i, '$');
            }
            if (i + 7 < stringBuffer.length() && (stringBuffer.substring(i, i + 7).equals("Parsing") || stringBuffer.substring(i, i + 5).equals("Setup") || stringBuffer.substring(i, i + 5).equals("First") || stringBuffer.substring(i, i + 7).equals("Initial"))) {
                stringBuffer.insert(i, '$');
                stringBuffer.insert(i + 1, ' ');
                i += 2;
            }
            if (i + 3 >= stringBuffer.length() || !stringBuffer.substring(i, i + 3).equals("Sol") || n2 != 0) continue;
            n = i;
            ++n2;
        }
        if (n > 0) {
            string2 = string2 + stringBuffer.substring(0, n - 1) + "\n";
        }
        String string3 = new String(stringBuffer.substring(n));
        String string4 = "";
        for (int i = 0; i < this.allOriginalDecisionVariables.size(); ++i) {
            String string5 = this.allOriginalDecisionVariables.get(i);
            ConstantDomain constantDomain = this.allDecisionVariablesDomains.get(string5);
            if (constantDomain.getType() != 10) {
                int n3 = 6;
                while (string3.charAt(n3) != '\n' && string3.charAt(n3) != '\r') {
                    ++n3;
                }
                String string6 = string3.substring(5, n3 - 1);
                string4 = string4.concat("variable " + string5 + " is " + string6 + ", \n");
                string3 = string3.substring(n3 + 1);
                continue;
            }
            ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)constantDomain).getIndexDomains();
            if (constantDomainArray.length == 1) {
                int n4 = 6;
                while (string3.charAt(n4) != '\n' && string3.charAt(n4) != '\r') {
                    ++n4;
                }
                String string7 = "";
                for (int j = 5; j < n4; ++j) {
                    String string8 = "";
                    while (string3.charAt(j) != ' ' && string3.charAt(j) != '\n' && string3.charAt(j) != '\r') {
                        string8 = string8 + string3.charAt(j);
                        ++j;
                    }
                    string7 = string7.concat(string8 + ", ");
                }
                string7 = string7.substring(0, string7.length() - 2);
                string4 = string4.concat("variable " + string5 + " is [" + string7 + "],\n\n");
                string3 = string3.substring(n4 + 1);
                continue;
            }
            if (constantDomainArray.length == 2) {
                int n5 = 6;
                while (string3.charAt(n5) != '\n' && string3.charAt(n5) != '\r') {
                    ++n5;
                }
                int n6 = constantDomainArray[0].getRange()[1] - constantDomainArray[0].getRange()[0] + 1;
                String string9 = "[ ";
                for (int j = 0; j < n6; ++j) {
                    String string10 = string3.substring(5, 6);
                    for (int k = 7; k < n5; ++k) {
                        String string11 = "";
                        while (string3.charAt(k) != ' ' && string3.charAt(k) != '\n' && string3.charAt(k) != '\r') {
                            string11 = string11 + string3.charAt(k);
                            ++k;
                        }
                        string10 = string10.concat(", " + string11);
                    }
                    string9 = j >= 1 ? string9.concat(",\n\t[" + string10 + "]") : string9.concat("[" + string10 + "]");
                    string3 = string3.substring(n5 + 1);
                }
                string9 = string9.concat(" ],\n");
                string4 = string4 + "variable " + string5 + " is " + string9;
                continue;
            }
            if (constantDomainArray.length != 3) continue;
            int n7 = 6;
            while (string3.charAt(n7) != '\n' && string3.charAt(n7) != '\r') {
                ++n7;
            }
        }
        string2 = string2 + "\n" + string4;
        StringBuffer stringBuffer2 = new StringBuffer(string3);
        for (int i = 0; i < stringBuffer2.length(); ++i) {
            if (stringBuffer2.charAt(i) == '#') {
                stringBuffer2.deleteCharAt(i);
                stringBuffer2.insert(i, '$');
            }
            if (i + 7 < stringBuffer2.length() && (stringBuffer2.substring(i, i + 7).equals("Solutio") || stringBuffer2.substring(i, i + 5).equals("Solve") || stringBuffer2.substring(i, i + 7).equals("Problem") || stringBuffer2.substring(i, i + 5).equals("Total"))) {
                stringBuffer2.insert(i, '$');
                stringBuffer2.insert(i + 1, ' ');
                i += 2;
                continue;
            }
            if (i + 6 >= stringBuffer2.length() || !stringBuffer2.substring(i, i + 5).equals("\nTime") && !stringBuffer2.substring(i, i + 6).equals("\nNodes")) continue;
            stringBuffer2.insert(i + 1, '$');
            stringBuffer2.insert(i + 2, ' ');
            i += 3;
        }
        return string2 + stringBuffer2;
    }

    public void printModelStatistics() {
        if (this.settings.giveTranslationInfo()) {
            System.out.println("\n" + this.printStatistics());
        }
    }

    protected int getAmountOfAuxiliaryVariables() {
        return this.auxVariables.size();
    }

    protected int getAmountOfConstraints() {
        return this.constraintList.size();
    }

    protected boolean isEssenceCommonSubexpression(String string) {
        Expression expression = this.auxVarDetails.get(string);
        if (expression != null) {
            return this.subexpressionCount.containsKey(((Object)expression).toString());
        }
        return false;
    }

    protected boolean isMinionCSE(MinionAtom minionAtom) {
        return this.minionCommonSubexpressions.containsValue(minionAtom);
    }
}

