/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import translator.expression.Expression;
import translator.tailor.gecode.GecodeConstraint;

public class RelationalConstraint
implements GecodeConstraint {
    char consistencyLevel = (char)3;
    char[] supportedConsistencyLevels = new char[0];
    boolean isReifiable = false;
    char propagationKind = (char)30;

    public char getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public char[] getSupportedConsistencyLevels() {
        return this.supportedConsistencyLevels;
    }

    public void setConsistencyLevel(char c) {
        for (int i = 0; i < this.supportedConsistencyLevels.length; ++i) {
            if (c != this.supportedConsistencyLevels[i]) continue;
            this.consistencyLevel = c;
            return;
        }
    }

    public void setPropagationKind(char c) {
        if (c == '\u001e' || c == '\u001f' || c == ' ') {
            this.propagationKind = c;
        }
    }

    public boolean isReifiable() {
        return this.isReifiable;
    }

    public String toCCString() {
        return "";
    }

    public String computeConstantName(Expression expression) {
        StringBuffer stringBuffer = new StringBuffer(((Object)expression).toString());
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '-' || stringBuffer.charAt(i) == '[' || stringBuffer.charAt(i) == ']' || stringBuffer.charAt(i) == '(' || stringBuffer.charAt(i) == ')') {
                stringBuffer.replace(i, i + 1, "_");
                continue;
            }
            if (stringBuffer.charAt(i) == '*') {
                stringBuffer.replace(i, i + 1, "_m_");
                continue;
            }
            if (stringBuffer.charAt(i) == '+') {
                stringBuffer.replace(i, i + 1, "_a_");
                continue;
            }
            if (stringBuffer.charAt(i) != ' ' && stringBuffer.charAt(i) != ',') continue;
            stringBuffer.deleteCharAt(i);
            --i;
        }
        if (stringBuffer.length() > 20) {
            return "int_" + stringBuffer.toString().substring(stringBuffer.length() - 20);
        }
        return "int_" + stringBuffer.toString();
    }

    protected String operatorToString(char c) {
        if (c == '\n') {
            return "IRT_EQ";
        }
        if (c == '\u000e') {
            return "IRT_GQ";
        }
        if (c == '\u000f') {
            return "IRT_GR";
        }
        if (c == '\r') {
            return "IRT_LE";
        }
        if (c == '\f') {
            return "IRT_LQ";
        }
        if (c == '\u000b') {
            return "IRT_NQ";
        }
        if (c == '\u0014') {
            return "BOT_AND";
        }
        if (c == '\u0015') {
            return "BOT_OR";
        }
        if (c == '\u0016') {
            return "BOT_IMP";
        }
        if (c == '\u0017') {
            return "BOT_EQV";
        }
        if (c == '\u0018') {
            return "BOT_XOR";
        }
        return "unknown OP";
    }

    protected String consistencyToString(char c) {
        if (c == '\u0000') {
            return "ICL_VAL";
        }
        if (c == '\u0002') {
            return "ICL_DOM";
        }
        if (c == '\u0001') {
            return "ICL_BND";
        }
        return "ICL_DEF";
    }

    protected String propagationToString(char c) {
        if (c == '\u001e') {
            return "PK_DEF";
        }
        if (c == '\u001f') {
            return "PK_SPEED";
        }
        if (c == ' ') {
            return "PK_MEM";
        }
        return "PK_DEF";
    }
}

