/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.AbsoluteConstraint;
import translator.expression.AbsoluteValue;
import translator.expression.AllDifferent;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Array;
import translator.expression.ArrayDomain;
import translator.expression.ArrayVariable;
import translator.expression.AtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BinaryNonLinearConstraint;
import translator.expression.BinaryRelationalExpression;
import translator.expression.BoolDomain;
import translator.expression.BoundedExpressionRange;
import translator.expression.BoundedIntRange;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Conjunction;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Disjunction;
import translator.expression.Domain;
import translator.expression.ElementConstraint;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IndexedArray;
import translator.expression.LexConstraint;
import translator.expression.MatrixDomain;
import translator.expression.MinimumConstraint;
import translator.expression.Multiplication;
import translator.expression.NaryRelationalExpression;
import translator.expression.NonCommutativeRelationalBinaryExpression;
import translator.expression.ProductConstraint;
import translator.expression.QuantifiedExpression;
import translator.expression.QuantifiedSum;
import translator.expression.Reification;
import translator.expression.RelationalAtomExpression;
import translator.expression.RelationalExpression;
import translator.expression.SimpleArray;
import translator.expression.SingleArray;
import translator.expression.SingleExpressionRange;
import translator.expression.SingleIntRange;
import translator.expression.SingleVariable;
import translator.expression.Sum;
import translator.expression.SumConstraint;
import translator.expression.Variable;
import translator.expression.VariableArray;
import translator.normaliser.NormalisedModel;
import translator.solver.Gecode;
import translator.tailor.gecode.ArgsArrayVariable;
import translator.tailor.gecode.GecodeAbs;
import translator.tailor.gecode.GecodeArray;
import translator.tailor.gecode.GecodeArrayVariable;
import translator.tailor.gecode.GecodeAtom;
import translator.tailor.gecode.GecodeBoolArrayElem;
import translator.tailor.gecode.GecodeBoolAtomVariable;
import translator.tailor.gecode.GecodeBoolVar;
import translator.tailor.gecode.GecodeBoolVarArgs;
import translator.tailor.gecode.GecodeBoolVarArray;
import translator.tailor.gecode.GecodeConstant;
import translator.tailor.gecode.GecodeConstraint;
import translator.tailor.gecode.GecodeDistinct;
import translator.tailor.gecode.GecodeDiv;
import translator.tailor.gecode.GecodeElement;
import translator.tailor.gecode.GecodeException;
import translator.tailor.gecode.GecodeForall;
import translator.tailor.gecode.GecodeForallLinear;
import translator.tailor.gecode.GecodeIf;
import translator.tailor.gecode.GecodeIntArray;
import translator.tailor.gecode.GecodeIntArrayElem;
import translator.tailor.gecode.GecodeIntAtomVariable;
import translator.tailor.gecode.GecodeIntVar;
import translator.tailor.gecode.GecodeIntVarArgs;
import translator.tailor.gecode.GecodeIntVarArray;
import translator.tailor.gecode.GecodeLinear;
import translator.tailor.gecode.GecodeMin;
import translator.tailor.gecode.GecodeMod;
import translator.tailor.gecode.GecodeModel;
import translator.tailor.gecode.GecodeMult;
import translator.tailor.gecode.GecodePostConstraint;
import translator.tailor.gecode.GecodeVariable;
import translator.tailor.gecode.IntegerVariable;
import translator.tailor.gecode.RelationalConstraint;
import translator.tailor.gecode.SimpleBoolRelation;
import translator.tailor.gecode.SimpleIntRelation;

public class GecodeTailor {
    private TranslationSettings settings;
    private NormalisedModel essencePmodel;
    private ArrayList<GecodeConstraint> constraintBuffer = new ArrayList();
    private ArrayList<GecodeConstraint> additionalBoundsConstraintsBuffer = new ArrayList();
    private ArrayList<GecodeArrayVariable> bufferArrays = new ArrayList();
    private ArrayList<GecodeArrayVariable> variableList = new ArrayList();
    private ArrayList<GecodeArrayVariable> multiDimensionalArrays = new ArrayList();
    private HashMap<String, String> argVarNamesMap;
    private HashMap<String, String> argWeightsNamesMap;
    private HashMap<String, int[]> argWeightsMap;
    private HashMap<Integer, String> argConstantNamesMap;
    private HashMap<Expression, String> constantNamesMap;
    private ArrayList<String> constArgumentList;
    private ArrayList<Expression> constantList;
    private int noReusedConstArguments = 0;
    private int noReusedConstants = 0;
    private ArrayList<GecodeIntVar> singleIntVariableList = new ArrayList();
    private ArrayList<GecodeIntVar> auxIntVariableList;
    private ArrayList<GecodeBoolVar> singleBoolVariableList = new ArrayList();
    private ArrayList<GecodeBoolVar> auxBoolVariableList;
    private ArrayList<GecodeArray> auxArrayList;
    private GecodeIntVarArgs auxIntVariableBuffer;
    private GecodeBoolVarArgs auxBoolVariableBuffer;
    private GecodeIntVarArray integerVariableBuffer;
    private GecodeBoolVarArray booleanVariableBuffer;
    int numberOfBufferArrays = 0;

    public GecodeTailor() {
        this.auxIntVariableList = new ArrayList();
        this.auxBoolVariableList = new ArrayList();
        this.auxArrayList = new ArrayList();
        this.settings = new TranslationSettings();
        this.settings.setTargetSolver(new Gecode(this.settings));
        this.argVarNamesMap = new HashMap();
        this.argWeightsNamesMap = new HashMap();
        this.argConstantNamesMap = new HashMap();
        this.argWeightsMap = new HashMap();
        this.constArgumentList = new ArrayList();
        this.constantList = new ArrayList();
        this.constantNamesMap = new HashMap();
        this.integerVariableBuffer = new GecodeIntVarArray(((Gecode)this.settings.getTargetSolver()).SINGLE_INT_VAR_ARRAY_NAME, 0, 0, 0);
        this.booleanVariableBuffer = new GecodeBoolVarArray(((Gecode)this.settings.getTargetSolver()).SINGLE_BOOL_VAR_ARRAY_NAME, 0);
        this.auxIntVariableBuffer = new GecodeIntVarArgs(((Gecode)this.settings.getTargetSolver()).AUX_INT_VAR_ARRAY_NAME, 0, 0, 0);
        this.auxBoolVariableBuffer = new GecodeBoolVarArgs(((Gecode)this.settings.getTargetSolver()).AUX_BOOL_VAR_ARRAY_NAME, 0);
    }

    public GecodeModel tailorToGecode(NormalisedModel normalisedModel, TranslationSettings translationSettings) throws GecodeException, Exception {
        this.settings = translationSettings;
        this.essencePmodel = normalisedModel;
        this.tailorDecisionVariables();
        ArrayList<Expression> arrayList = normalisedModel.getConstraints();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.constraintBuffer.add(this.tailorToGecode(arrayList.get(i)));
        }
        if (this.booleanVariableBuffer.getLength() > 0) {
            this.bufferArrays.add(this.booleanVariableBuffer);
        }
        if (this.integerVariableBuffer.getLength() > 0) {
            this.bufferArrays.add(this.integerVariableBuffer);
        }
        this.tailorAuxiliaryVariables();
        ArrayList<ArgsArrayVariable> arrayList2 = new ArrayList<ArgsArrayVariable>();
        if (this.auxBoolVariableBuffer.getLength() > 0) {
            arrayList2.add(this.auxBoolVariableBuffer);
        }
        if (this.auxIntVariableBuffer.getLength() > 0) {
            arrayList2.add(this.auxIntVariableBuffer);
        }
        for (int i = 0; i < this.additionalBoundsConstraintsBuffer.size(); ++i) {
            this.constraintBuffer.add(this.additionalBoundsConstraintsBuffer.get(i));
        }
        GecodeModel gecodeModel = new GecodeModel(translationSettings, this.variableList, this.bufferArrays, this.constraintBuffer, this.singleIntVariableList, this.singleBoolVariableList, arrayList2, this.auxIntVariableList, this.auxBoolVariableList, this.multiDimensionalArrays, normalisedModel.getUndefinedParameters(), this.constantList, this.constArgumentList, this.argWeightsMap, this.constantNamesMap, this.auxArrayList);
        Expression expression = this.essencePmodel.getObjectiveExpression();
        if (expression != null) {
            if (expression instanceof AtomExpression) {
                GecodeAtom gecodeAtom = expression instanceof RelationalExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
                gecodeModel.setObjective(gecodeAtom);
                gecodeModel.setIsMinimisingObjective(!this.essencePmodel.isObjectiveMaximising());
            } else {
                throw new GecodeException("Flattening error. Expected atom as objective expression instead of:" + expression);
            }
        }
        gecodeModel.setCommonSubexpressions(this.essencePmodel.getAmountOfCommonSubExpressionsUsed());
        gecodeModel.setCommonQuantifiedSubexpressions(this.essencePmodel.getNumberOfQuantifiedCSE());
        gecodeModel.noReusedConstArguments = this.noReusedConstArguments;
        return gecodeModel;
    }

    protected GecodeConstraint tailorToGecode(Expression expression) throws GecodeException, Exception {
        if (expression.isLinearExpression() && this.settings.getUseGecodeLinearMinimodelPostConstraints()) {
            return this.tailorLinearExpression(expression);
        }
        if (expression instanceof AbsoluteValue) {
            return this.tailorAbsoluteValue((AbsoluteValue)expression);
        }
        if (expression instanceof AbsoluteConstraint) {
            return this.tailorAbsoluteConstraint((AbsoluteConstraint)expression);
        }
        if (expression instanceof SumConstraint) {
            return this.tailorSumConstraint((SumConstraint)expression);
        }
        if (expression instanceof ProductConstraint) {
            return this.tailorProductConstraint((ProductConstraint)expression);
        }
        if (expression instanceof AllDifferent) {
            return this.tailorAllDifferent((AllDifferent)expression);
        }
        if (expression instanceof NonCommutativeRelationalBinaryExpression) {
            return this.tailorRelation((BinaryRelationalExpression)expression);
        }
        if (expression instanceof CommutativeBinaryRelationalExpression) {
            return this.tailorRelation((BinaryRelationalExpression)expression);
        }
        if (expression instanceof Conjunction) {
            if (!this.settings.getUseGecodeBooleanMinimodelPostConstraints()) {
                return this.tailorConjunction((Conjunction)expression);
            }
            return new GecodePostConstraint(expression.toSolverExpression(this.settings.getTargetSolver()), true);
        }
        if (expression instanceof Disjunction) {
            if (!this.settings.getUseGecodeBooleanMinimodelPostConstraints()) {
                return this.tailorDisjunction((Disjunction)expression);
            }
            return new GecodePostConstraint(expression.toSolverExpression(this.settings.getTargetSolver()), true);
        }
        if (expression instanceof LexConstraint) {
            return this.tailorLexConstraint((LexConstraint)expression);
        }
        if (expression instanceof Reification) {
            return this.tailorReification((Reification)expression);
        }
        if (expression instanceof ElementConstraint) {
            return this.tailorElement((ElementConstraint)expression);
        }
        if (expression instanceof BinaryNonLinearConstraint) {
            return this.tailorBinaryNonLinearConstraint((BinaryNonLinearConstraint)expression);
        }
        if (expression instanceof QuantifiedExpression) {
            return this.tailorQuantifiedExpression((QuantifiedExpression)expression);
        }
        if (expression instanceof MinimumConstraint) {
            return this.tailorMinimumConstraint((MinimumConstraint)expression);
        }
        throw new GecodeException("Cannot tailor constraint to Gecode (yet):" + expression);
    }

    protected void tailorDecisionVariables() throws GecodeException {
        ArrayList<String> arrayList = this.essencePmodel.getDecisionVariablesNames();
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            GecodeVariable gecodeVariable = this.tailorToGecode(arrayList.get(i));
            if (gecodeVariable instanceof GecodeBoolVar) {
                this.booleanVariableBuffer.increaseLength();
                this.singleBoolVariableList.add((GecodeBoolVar)gecodeVariable);
                continue;
            }
            if (gecodeVariable instanceof GecodeIntVar) {
                this.integerVariableBuffer.increaseLength();
                if (bl) {
                    this.integerVariableBuffer.setLowerBound(gecodeVariable.getBounds()[0]);
                } else {
                    this.integerVariableBuffer.addLowerBound(gecodeVariable.getBounds()[0]);
                    if (gecodeVariable.getBounds()[0] > this.integerVariableBuffer.getLowerBound()) {
                        this.additionalBoundsConstraintsBuffer.add(new SimpleIntRelation((GecodeIntAtomVariable)((GecodeIntVar)gecodeVariable), '\u000e', new GecodeConstant(gecodeVariable.getBounds()[0])));
                    }
                }
                if (bl) {
                    this.integerVariableBuffer.setUpperBound(gecodeVariable.getBounds()[1]);
                } else {
                    this.integerVariableBuffer.addUpperBound(gecodeVariable.getBounds()[1]);
                    if (gecodeVariable.getBounds()[1] < this.integerVariableBuffer.getUpperBound()) {
                        this.additionalBoundsConstraintsBuffer.add(new SimpleIntRelation((GecodeIntAtomVariable)((GecodeIntVar)gecodeVariable), '\f', new GecodeConstant(gecodeVariable.getBounds()[1])));
                    }
                }
                this.singleIntVariableList.add((GecodeIntVar)gecodeVariable);
                bl = false;
                continue;
            }
            if (gecodeVariable instanceof GecodeArrayVariable) {
                GecodeArrayVariable gecodeArrayVariable = (GecodeArrayVariable)gecodeVariable;
                if (!gecodeArrayVariable.isMultiDimensional()) {
                    this.variableList.add(gecodeArrayVariable);
                    continue;
                }
                this.multiDimensionalArrays.add(gecodeArrayVariable);
                continue;
            }
            throw new GecodeException("Internal error. Cannot map variable that is neither and int/bool atom nor an array variable:" + gecodeVariable);
        }
    }

    protected void tailorAuxiliaryVariables() throws GecodeException {
        ArrayList<Variable> arrayList = this.essencePmodel.getAuxVariables();
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            Variable variable;
            Variable variable2 = arrayList.get(i);
            if (variable2 instanceof SingleVariable) {
                variable = (SingleVariable)variable2;
                if (((SingleVariable)variable).isBooleanVariable()) {
                    this.auxBoolVariableBuffer.increaseLength();
                    this.auxBoolVariableList.add(new GecodeBoolVar(((SingleVariable)variable).getVariableName()));
                    continue;
                }
                this.auxIntVariableBuffer.increaseLength();
                if (bl) {
                    this.auxIntVariableBuffer.setLowerBound(((SingleVariable)variable).getDomain()[0]);
                } else {
                    this.auxIntVariableBuffer.addLowerBound(((SingleVariable)variable).getDomain()[0]);
                    if (((SingleVariable)variable).getDomain()[0] > this.integerVariableBuffer.getLowerBound()) {
                        this.additionalBoundsConstraintsBuffer.add(new SimpleIntRelation((GecodeIntAtomVariable)new GecodeIntVar(((SingleVariable)variable).getVariableName(), ((SingleVariable)variable).getDomain()[0], ((SingleVariable)variable).getDomain()[1]), '\u000e', new GecodeConstant(((SingleVariable)variable).getDomain()[0])));
                    }
                }
                if (bl) {
                    this.auxIntVariableBuffer.setUpperBound(((SingleVariable)variable).getDomain()[1]);
                } else {
                    this.auxIntVariableBuffer.addUpperBound(((SingleVariable)variable).getDomain()[1]);
                    if (((SingleVariable)variable).getDomain()[1] < this.integerVariableBuffer.getUpperBound()) {
                        this.additionalBoundsConstraintsBuffer.add(new SimpleIntRelation((GecodeIntAtomVariable)new GecodeIntVar(((SingleVariable)variable).getVariableName(), ((SingleVariable)variable).getDomain()[0], ((SingleVariable)variable).getDomain()[1]), '\f', new GecodeConstant(((SingleVariable)variable).getDomain()[1])));
                    }
                }
                this.auxIntVariableList.add(new GecodeIntVar(((SingleVariable)variable).getVariableName(), ((SingleVariable)variable).getDomain()[0], ((SingleVariable)variable).getDomain()[1]));
                bl = false;
                continue;
            }
            if (variable2 instanceof ArrayVariable) {
                variable = (ArrayVariable)variable2;
                String string = ((ArrayVariable)variable).getArrayNameOnly();
                Domain domain = ((ArrayVariable)variable).getBaseDomain();
                if (domain.getType() == 10) {
                    ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)domain;
                    ConstantDomain[] constantDomainArray = constantArrayDomain.getIndexDomains();
                    ConstantDomain constantDomain = constantArrayDomain.getBaseDomain();
                    int n = constantDomainArray.length;
                    int[] nArray = new int[n];
                    for (int j = 0; j < constantDomainArray.length; ++j) {
                        nArray[j] = constantDomainArray[j].getFullDomain().length;
                    }
                    if (constantDomain.getType() == 0) {
                        if (n == 1) {
                            this.auxArrayList.add(new GecodeBoolVarArray(string, nArray[0]));
                            continue;
                        }
                        this.auxArrayList.add(new GecodeBoolVarArray(string, nArray));
                        continue;
                    }
                    if (constantDomain.getType() == 1 || constantDomain.getType() == 3) {
                        if (n == 1) {
                            this.auxArrayList.add(new GecodeIntVarArray(string, nArray[0], constantDomain.getFullDomain()));
                            continue;
                        }
                        this.auxArrayList.add(new GecodeIntVarArray(string, nArray, constantDomain.getFullDomain()));
                        continue;
                    }
                    if (constantDomain.getType() == 2) {
                        if (n == 1) {
                            this.auxArrayList.add(new GecodeIntVarArray(string, nArray[0], constantDomain.getRange()[0], constantDomain.getRange()[1]));
                            continue;
                        }
                        this.auxArrayList.add(new GecodeIntVarArray(string, nArray, constantDomain.getRange()[0], constantDomain.getRange()[1]));
                        continue;
                    }
                    throw new GecodeException("Sorry, cannot tailor array '" + string + "' with base-domain " + constantDomain + " to Gecode (yet).");
                }
                if (this.settings.isClassLevelTransformation()) {
                    if (domain instanceof ArrayDomain) {
                        this.auxArrayList.add(this.tailorToSimpleArrayPC(string, ((ArrayDomain)domain).getIndexDomains(), ((ArrayDomain)domain).getBaseDomain()));
                        continue;
                    }
                    throw new GecodeException("Cannot tailor variable '" + string + "' with domain-type " + domain.getClass().getSimpleName() + " to Gecode (yet).");
                }
                throw new GecodeException("Cannot tailor variable '" + string + "' with domain-type " + domain.getClass().getSimpleName() + " to Gecode (yet).");
            }
            throw new GecodeException("Internal error. Auxiliary variable '" + variable2 + "' is not a simple/single variable but of type:" + variable2.getClass().getSimpleName());
        }
    }

    private GecodeVariable tailorToGecode(String string) throws GecodeException {
        Domain domain = this.essencePmodel.getDomainOfVariable(string);
        if (domain == null) {
            throw new GecodeException("Tailoring error. Cannot map variable '" + string + "' to a domain");
        }
        if (domain.getType() == 2) {
            BoundedIntRange boundedIntRange = (BoundedIntRange)domain;
            return new GecodeIntVar(string, boundedIntRange.getRange()[0], boundedIntRange.getRange()[1]);
        }
        if (domain.getType() == 1) {
            SingleIntRange singleIntRange = (SingleIntRange)domain;
            return new GecodeIntVar(string, singleIntRange.getRange()[0], singleIntRange.getRange()[0]);
        }
        if (domain.getType() == 0) {
            return new GecodeBoolVar(string);
        }
        if (domain.getType() == 10) {
            ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)domain;
            ConstantDomain[] constantDomainArray = constantArrayDomain.getIndexDomains();
            ConstantDomain constantDomain = constantArrayDomain.getBaseDomain();
            int n = constantDomainArray.length;
            int[] nArray = new int[n];
            for (int i = 0; i < constantDomainArray.length; ++i) {
                nArray[i] = constantDomainArray[i].getFullDomain().length;
            }
            if (constantDomain.getType() == 0) {
                if (n == 1) {
                    return new GecodeBoolVarArray(string, nArray[0]);
                }
                return new GecodeBoolVarArray(string, nArray);
            }
            if (constantDomain.getType() == 1 || constantDomain.getType() == 3) {
                if (n == 1) {
                    return new GecodeIntVarArray(string, nArray[0], constantDomain.getFullDomain());
                }
                return new GecodeIntVarArray(string, nArray, constantDomain.getFullDomain());
            }
            if (constantDomain.getType() == 2) {
                if (n == 1) {
                    return new GecodeIntVarArray(string, nArray[0], constantDomain.getRange()[0], constantDomain.getRange()[1]);
                }
                return new GecodeIntVarArray(string, nArray, constantDomain.getRange()[0], constantDomain.getRange()[1]);
            }
            throw new GecodeException("Sorry, cannot tailor array '" + string + "' with base-domain " + constantDomain + " to Gecode (yet).");
        }
        if (this.settings.isClassLevelTransformation()) {
            if (domain instanceof ArrayDomain) {
                return this.tailorToSimpleArrayPC(string, ((ArrayDomain)domain).getIndexDomains(), ((ArrayDomain)domain).getBaseDomain());
            }
            if (domain instanceof ExpressionRange) {
                ExpressionRange expressionRange = (ExpressionRange)domain;
                return new GecodeIntVar(string, expressionRange.getLowerAndUpperBound()[0], expressionRange.getLowerAndUpperBound()[1]);
            }
        }
        throw new GecodeException("Cannot tailor variable '" + string + "' with domain-type " + domain.getClass().getSimpleName() + " to Gecode (yet).");
    }

    protected char mapOperatorToGecode(int n) throws GecodeException {
        switch (n) {
            case 101: {
                return '\n';
            }
            case 108: {
                return '\u000e';
            }
            case 106: {
                return '\u000f';
            }
            case 104: {
                return '\f';
            }
            case 102: {
                return '\r';
            }
            case 100: {
                return '\u000b';
            }
            case 118: {
                return '\u0014';
            }
            case 117: {
                return '\u0015';
            }
            case 116: {
                return '\f';
            }
            case 115: {
                return '\u0017';
            }
            case 109: {
                return '\u000e';
            }
            case 107: {
                return '\u000f';
            }
            case 105: {
                return '\f';
            }
            case 103: {
                return '\r';
            }
        }
        throw new GecodeException("Cannot map Essence' operator with number '" + n + "' because it is unknown.");
    }

    private GecodeConstraint tailorMinimumConstraint(MinimumConstraint minimumConstraint) throws GecodeException, Exception {
        Expression expression = minimumConstraint.getResult();
        GecodeAtom gecodeAtom = expression instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
        Array array = minimumConstraint.getArguments();
        if (array instanceof VariableArray && minimumConstraint.isBinary()) {
            AtomExpression[] atomExpressionArray = ((VariableArray)array).getVariables();
            GecodeAtom gecodeAtom2 = atomExpressionArray[0] instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)atomExpressionArray[0]) : this.tailorArithmeticAtom((ArithmeticAtomExpression)atomExpressionArray[0]);
            GecodeAtom gecodeAtom3 = atomExpressionArray[1] instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)atomExpressionArray[1]) : this.tailorArithmeticAtom((ArithmeticAtomExpression)atomExpressionArray[1]);
            return new GecodeMin(gecodeAtom2, gecodeAtom3, gecodeAtom, !minimumConstraint.isMaximum());
        }
        throw new GecodeException("Cannot tailor " + minimumConstraint + " yet, sorry.");
    }

    private GecodeConstraint tailorQuantifiedExpression(QuantifiedExpression quantifiedExpression) throws GecodeException, Exception {
        if (quantifiedExpression.getType() == 202) {
            Object object;
            ArrayList<GecodeConstraint> arrayList = new ArrayList<GecodeConstraint>();
            if (quantifiedExpression.getQuantifiedExpression().getType() == 118) {
                object = ((Conjunction)quantifiedExpression.getQuantifiedExpression()).getArguments();
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    arrayList.add(this.tailorToGecode((Expression)((ArrayList)object).get(i)));
                }
            } else {
                object = quantifiedExpression.getQuantifiedExpression();
                arrayList.add(this.tailorToGecode((Expression)object));
            }
            object = quantifiedExpression.getQuantifiedDomain();
            if (!(object instanceof ExpressionRange)) {
                throw new GecodeException("Cannot tailor quantification " + quantifiedExpression + ": expected a range domain instead of:" + object);
            }
            ExpressionRange expressionRange = (ExpressionRange)object;
            return new GecodeForall(arrayList, quantifiedExpression.getQuantifiedVariables(), expressionRange.getLowerAndUpperBound()[0], expressionRange.getLowerAndUpperBound()[1]);
        }
        throw new GecodeException("Cannot tailor quantification " + quantifiedExpression + " yet, sorry.");
    }

    private GecodeConstraint tailorAbsoluteValue(AbsoluteValue absoluteValue) throws GecodeException, Exception {
        throw new GecodeException("Cannot tailor absolute value:" + absoluteValue);
    }

    private GecodeConstraint tailorReification(Reification reification) throws GecodeException, Exception {
        Expression expression = reification.getReifiedConstraint();
        if (expression instanceof CommutativeBinaryRelationalExpression || expression instanceof NonCommutativeRelationalBinaryExpression) {
            return this.tailorBinaryRelationalExpression(reification);
        }
        if (expression instanceof NaryRelationalExpression) {
            return this.tailorReifiedNaryRelationalExpression((NaryRelationalExpression)expression, reification.getReifiedVariable(), expression instanceof Conjunction);
        }
        if (expression instanceof SumConstraint) {
            return this.tailorReifiedSum((SumConstraint)expression, reification.getReifiedVariable());
        }
        throw new GecodeException("Cannot tailor reification " + reification + " yet, sorry.");
    }

    private GecodeConstraint tailorBinaryRelationalExpression(Reification reification) throws GecodeException, Exception {
        Expression expression = reification.getReifiedConstraint();
        if (expression instanceof CommutativeBinaryRelationalExpression) {
            CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression = (CommutativeBinaryRelationalExpression)expression;
            Expression expression2 = commutativeBinaryRelationalExpression.getLeftArgument();
            Expression expression3 = commutativeBinaryRelationalExpression.getRightArgument();
            if (!(expression2 instanceof AtomExpression)) {
                throw new GecodeException("Flattening error. Expected an atom expression instead of " + expression2 + " in " + reification);
            }
            if (!(expression3 instanceof AtomExpression)) {
                throw new GecodeException("Flattening error. Expected an atom expression instead of " + expression3 + " in " + reification);
            }
            GecodeAtom gecodeAtom = expression2 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression2) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2);
            GecodeAtom gecodeAtom2 = expression3 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression3) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression3);
            GecodeAtom gecodeAtom3 = this.tailorRelationalAtom(reification.getReifiedVariable());
            char c = this.mapOperatorToGecode(commutativeBinaryRelationalExpression.getOperator());
            if (gecodeAtom instanceof IntegerVariable) {
                if (gecodeAtom instanceof GecodeIntVar) {
                    return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom, c, gecodeAtom2, gecodeAtom3);
                }
                return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom2, c, gecodeAtom, gecodeAtom3);
            }
            if (gecodeAtom instanceof GecodeVariable) {
                return new SimpleBoolRelation((GecodeVariable)gecodeAtom, c, gecodeAtom2, gecodeAtom3);
            }
            return new SimpleBoolRelation((GecodeVariable)gecodeAtom2, c, gecodeAtom, gecodeAtom3);
        }
        if (expression instanceof NonCommutativeRelationalBinaryExpression) {
            NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression = (NonCommutativeRelationalBinaryExpression)expression;
            Expression expression4 = nonCommutativeRelationalBinaryExpression.getLeftArgument();
            Expression expression5 = nonCommutativeRelationalBinaryExpression.getRightArgument();
            if (!(expression4 instanceof AtomExpression)) {
                throw new GecodeException("Flattening error. Expected an atom expression instead of " + expression4 + " in " + reification);
            }
            if (!(expression5 instanceof AtomExpression)) {
                throw new GecodeException("Flattening error. Expected an atom expression instead of " + expression5 + " in " + reification);
            }
            GecodeAtom gecodeAtom = expression4 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression4) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression4);
            GecodeAtom gecodeAtom4 = expression5 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression5) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression5);
            GecodeAtom gecodeAtom5 = this.tailorRelationalAtom(reification.getReifiedVariable());
            char c = this.mapOperatorToGecode(nonCommutativeRelationalBinaryExpression.getOperator());
            if (gecodeAtom instanceof IntegerVariable) {
                if (gecodeAtom instanceof GecodeIntVar) {
                    return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom, c, gecodeAtom4, gecodeAtom5);
                }
                return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom4, this.invertRelationalGecodeOperator(c), gecodeAtom, gecodeAtom5);
            }
            if (gecodeAtom instanceof GecodeVariable) {
                return new SimpleBoolRelation((GecodeVariable)gecodeAtom, c, gecodeAtom4, gecodeAtom5);
            }
            return new SimpleBoolRelation((GecodeVariable)gecodeAtom4, this.invertRelationalGecodeOperator(c), gecodeAtom, gecodeAtom5);
        }
        throw new GecodeException("Cannot tailor reification " + reification + " yet, sorry.");
    }

    private GecodeConstraint tailorReifiedSum(SumConstraint sumConstraint, RelationalAtomExpression relationalAtomExpression) throws GecodeException, Exception {
        GecodeConstraint gecodeConstraint = this.tailorSumConstraint(sumConstraint);
        if (gecodeConstraint instanceof GecodeLinear) {
            GecodeLinear gecodeLinear = (GecodeLinear)gecodeConstraint;
            gecodeLinear.setReifiedVariable(this.tailorRelationalAtom(relationalAtomExpression));
            return gecodeLinear;
        }
        if (gecodeConstraint instanceof SimpleIntRelation) {
            SimpleIntRelation simpleIntRelation = (SimpleIntRelation)gecodeConstraint;
            simpleIntRelation.setReifiedVariable(this.tailorRelationalAtom(relationalAtomExpression));
            return simpleIntRelation;
        }
        throw new GecodeException("Cannot tailor reified sum '" + sumConstraint + "<=>" + relationalAtomExpression + "' to Gecode yet, sorry.");
    }

    private GecodeConstraint tailorReifiedNaryRelationalExpression(NaryRelationalExpression naryRelationalExpression, RelationalAtomExpression relationalAtomExpression, boolean bl) throws GecodeException, Exception {
        ArrayList<Expression> arrayList = naryRelationalExpression.getArguments();
        GecodeAtom[] gecodeAtomArray = new GecodeAtom[arrayList.size()];
        for (int i = 0; i < gecodeAtomArray.length; ++i) {
            if (!(arrayList.get(i) instanceof RelationalAtomExpression)) {
                throw new GecodeException("Type error: cannot apply " + (bl ? "conjunction" : "disjunction") + " on integer argument '" + arrayList.get(i) + "' in expression " + naryRelationalExpression);
            }
            gecodeAtomArray[i] = this.tailorRelationalAtom((RelationalAtomExpression)arrayList.get(i));
        }
        GecodeAtom gecodeAtom = this.tailorRelationalAtom(relationalAtomExpression);
        GecodeLinear gecodeLinear = bl ? new GecodeLinear(gecodeAtomArray, '\n', new GecodeConstant(gecodeAtomArray.length), gecodeAtom) : new GecodeLinear(gecodeAtomArray, '\n', new GecodeConstant(1), gecodeAtom);
        if (this.isPreviouslyDefinedArgument(gecodeAtomArray)) {
            gecodeLinear.setArgsVarName(this.getPreviouslyDefinedArgument(gecodeAtomArray));
            gecodeLinear.setArgIsAlreadyDefined(true);
        } else {
            this.addArgumentToMap(gecodeAtomArray, gecodeLinear.getArgVarName());
        }
        return gecodeLinear;
    }

    private GecodeConstraint tailorLexConstraint(LexConstraint lexConstraint) throws GecodeException {
        Expression expression = lexConstraint.getLeftArray();
        Expression expression2 = lexConstraint.getRightArray();
        if (!(expression instanceof SingleArray)) {
            throw new GecodeException("Infeasible argument for lex constraint " + lexConstraint + ".\nExpected array instead of " + expression + " of type " + expression.getClass().getSimpleName());
        }
        if (!(expression2 instanceof SingleArray)) {
            throw new GecodeException("Infeasible argument for lex constraint " + lexConstraint + ".\nExpected array instead of :" + expression2 + " of type " + expression2.getClass().getSimpleName());
        }
        GecodeArray gecodeArray = this.tailorArray((SingleArray)expression);
        GecodeArray gecodeArray2 = this.tailorArray((SingleArray)expression2);
        if (gecodeArray instanceof GecodeBoolVarArgs && gecodeArray2 instanceof GecodeBoolVarArgs) {
            return new SimpleBoolRelation((GecodeBoolVarArgs)gecodeArray, this.mapOperatorToGecode(lexConstraint.getOperator()), (GecodeBoolVarArgs)gecodeArray2);
        }
        if (gecodeArray instanceof GecodeIntVarArgs && gecodeArray2 instanceof GecodeIntVarArgs) {
            return new SimpleIntRelation((GecodeIntVarArgs)gecodeArray, this.mapOperatorToGecode(lexConstraint.getOperator()), (GecodeIntVarArgs)gecodeArray2);
        }
        throw new GecodeException("Cannot tailor lex constraint " + lexConstraint + " yet, sorry.");
    }

    private GecodeArray tailorArray(SingleArray singleArray) throws GecodeException {
        if (singleArray instanceof SimpleArray) {
            return this.tailorSimpleArray((SimpleArray)singleArray);
        }
        if (singleArray instanceof IndexedArray) {
            return this.tailorIndexedArray((IndexedArray)singleArray);
        }
        throw new GecodeException("Cannot tailor array " + singleArray + " yet, sorry.");
    }

    private GecodeArray tailorIndexedArrayPC(IndexedArray indexedArray, ArrayDomain arrayDomain) throws GecodeException {
        Domain[] domainArray = arrayDomain.getIndexDomains();
        Expression[] expressionArray = new Expression[domainArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            if (!(domainArray[i] instanceof ExpressionRange)) {
                throw new GecodeException("Cannot tailor " + indexedArray + " because of infeasible index expression domain: " + domainArray[i]);
            }
            expressionArray[i] = ((ExpressionRange)domainArray[i]).getLowerAndUpperBound()[1];
        }
        BasicDomain[] basicDomainArray = indexedArray.getIndexRanges();
        Expression[][] expressionArray2 = new Expression[basicDomainArray.length][2];
        for (int i = 0; i < basicDomainArray.length; ++i) {
            if (basicDomainArray[i] instanceof SingleExpressionRange) {
                expressionArray2[i][0] = ((SingleExpressionRange)basicDomainArray[i]).getSingleExpressionRange();
                expressionArray2[i][1] = ((SingleExpressionRange)basicDomainArray[i]).getSingleExpressionRange();
                continue;
            }
            if (basicDomainArray[i] instanceof BoundedExpressionRange) {
                expressionArray2[i][0] = ((BoundedExpressionRange)basicDomainArray[i]).getLowerBound();
                expressionArray2[i][1] = ((BoundedExpressionRange)basicDomainArray[i]).getUpperBound();
                continue;
            }
            throw new GecodeException("Cannot tailor " + indexedArray + " because of infeasible index expression: " + basicDomainArray[i]);
        }
        if (arrayDomain.getBaseDomain() instanceof BoolDomain) {
            return new GecodeBoolVarArgs(indexedArray.getArrayName(), expressionArray, expressionArray2);
        }
        if (arrayDomain.getBaseDomain() instanceof BoundedExpressionRange) {
            BoundedExpressionRange boundedExpressionRange = (BoundedExpressionRange)arrayDomain.getBaseDomain();
            return new GecodeIntVarArgs(indexedArray.getArrayName(), expressionArray, expressionArray2, boundedExpressionRange.getLowerBound(), boundedExpressionRange.getUpperBound());
        }
        throw new GecodeException("Cannot tailor indexed array " + indexedArray + " yet, sorry.");
    }

    private GecodeArray tailorIndexedArray(IndexedArray indexedArray) throws GecodeException {
        String string = indexedArray.getArrayName();
        Domain domain = this.essencePmodel.getDomainOfVariable(string);
        if (!((domain = domain.evaluate()) instanceof ConstantArrayDomain)) {
            if (domain instanceof ArrayDomain) {
                return this.tailorIndexedArrayPC(indexedArray, (ArrayDomain)domain);
            }
            throw new GecodeException("Cannot tailor array " + indexedArray + " because its domain " + domain + " is not an array domain but of type: " + domain.getClass().getSimpleName());
        }
        ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)domain).getIndexDomains();
        for (int i = 0; i < constantDomainArray.length; ++i) {
            constantDomainArray[i] = (ConstantDomain)constantDomainArray[i].evaluate();
        }
        int[] nArray = new int[constantDomainArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = constantDomainArray[i].getRange()[1] - constantDomainArray[i].getRange()[0];
        }
        ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)indexedArray.getBaseDomain();
        BasicDomain[] basicDomainArray = indexedArray.getIndexRanges();
        for (int i = 0; i < basicDomainArray.length; ++i) {
            basicDomainArray[i] = (BasicDomain)basicDomainArray[i].evaluate();
            if (basicDomainArray[i] instanceof ConstantDomain) continue;
            throw new GecodeException("Cannot tailor array " + indexedArray + " because its index domain " + basicDomainArray[i] + " is not constant.");
        }
        ConstantDomain[] constantDomainArray2 = new ConstantDomain[basicDomainArray.length];
        for (int i = 0; i < constantDomainArray2.length; ++i) {
            constantDomainArray2[i] = (ConstantDomain)basicDomainArray[i];
        }
        int[][] nArray2 = new int[constantDomainArray2.length][2];
        for (int i = 0; i < nArray2.length; ++i) {
            if (constantDomainArray2[i] instanceof SingleIntRange) {
                nArray2[i][0] = ((SingleIntRange)constantDomainArray2[i]).getSingleRange();
                nArray2[i][1] = nArray2[i][0];
                continue;
            }
            if (constantDomainArray2[i] instanceof BoundedIntRange) {
                nArray2[i][0] = ((BoundedIntRange)constantDomainArray2[i]).getRange()[0];
                nArray2[i][1] = ((BoundedIntRange)constantDomainArray2[i]).getRange()[1];
                continue;
            }
            throw new GecodeException("Cannot tailor indexed array " + indexedArray + ".\nThe index " + constantDomainArray2[i] + " has an unexpected type: " + constantDomainArray2[i].getClass().getSimpleName());
        }
        if (constantArrayDomain.getBaseDomain() instanceof BoolDomain) {
            return new GecodeBoolVarArgs(string, nArray, nArray2);
        }
        return new GecodeIntVarArgs(string, nArray, nArray2, constantArrayDomain.getRange()[0], constantArrayDomain.getRange()[1]);
    }

    private GecodeArray tailorToSimpleArrayPC(String string, Domain[] domainArray, Domain domain) throws GecodeException {
        Expression[] expressionArray = new Expression[domainArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            if (domainArray[i] instanceof ConstantDomain) {
                int n = ((ConstantDomain)domainArray[i]).getRange()[1] - ((ConstantDomain)domainArray[i]).getRange()[0] + 1;
                expressionArray[i] = new ArithmeticAtomExpression(n);
            } else if (domainArray[i] instanceof ExpressionRange) {
                expressionArray[i] = new Sum(new Expression[]{((ExpressionRange)domainArray[i]).getLowerAndUpperBound()[1].copy(), new ArithmeticAtomExpression(1)}, new Expression[]{((ExpressionRange)domainArray[i]).getLowerAndUpperBound()[0].copy()});
            } else {
                throw new GecodeException("Cannot tailor array " + string + " because index-domain " + expressionArray[i] + " is neither constant nor an expression range.");
            }
            expressionArray[i] = expressionArray[i].reduceExpressionTree();
            expressionArray[i] = expressionArray[i].evaluate();
        }
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        ArithmeticAtomExpression arithmeticAtomExpression2 = null;
        if (domain instanceof BoolDomain) {
            return new GecodeBoolVarArray(string, expressionArray);
        }
        if (domain instanceof ConstantDomain) {
            ConstantDomain constantDomain = (ConstantDomain)domain;
            arithmeticAtomExpression = new ArithmeticAtomExpression(constantDomain.getRange()[0]);
            arithmeticAtomExpression2 = new ArithmeticAtomExpression(constantDomain.getRange()[1]);
            return new GecodeIntVarArray(string, expressionArray, (Expression)arithmeticAtomExpression, (Expression)arithmeticAtomExpression2);
        }
        if (domain instanceof ExpressionRange) {
            ExpressionRange expressionRange = (ExpressionRange)domain;
            return new GecodeIntVarArray(string, expressionArray, expressionRange.getLowerAndUpperBound()[0], expressionRange.getLowerAndUpperBound()[1]);
        }
        throw new GecodeException("Cannot tailor array " + string + " with undefined basedomain:" + domain + " of type:" + domain.getClass().getSimpleName());
    }

    private GecodeArray tailorSimpleArray(SimpleArray simpleArray) throws GecodeException {
        if (this.settings.isClassLevelTransformation()) {
            return this.tailorToSimpleArrayPC(simpleArray.getArrayName(), simpleArray.getIndexDomains(), simpleArray.getBaseDomain());
        }
        String string = simpleArray.getArrayName();
        BasicDomain[] basicDomainArray = simpleArray.getIndexDomains();
        ConstantDomain[] constantDomainArray = new ConstantDomain[basicDomainArray.length];
        for (int i = 0; i < constantDomainArray.length; ++i) {
            if (!(basicDomainArray[i] instanceof ConstantDomain)) {
                throw new GecodeException("Cannot tailor array " + simpleArray + " because index-domain " + constantDomainArray[i] + " is not constant.");
            }
            constantDomainArray[i] = (ConstantDomain)basicDomainArray[i];
        }
        Domain domain = simpleArray.getBaseDomain();
        if (!(domain instanceof ConstantDomain)) {
            throw new GecodeException("Cannot tailor array " + simpleArray + " with non-constant domain yet, sorry.");
        }
        ConstantDomain constantDomain = (ConstantDomain)domain;
        int n = constantDomainArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < constantDomainArray.length; ++i) {
            nArray[i] = constantDomainArray[i].getFullDomain().length;
        }
        if (constantDomain.getType() == 0) {
            if (n == 1) {
                return new GecodeBoolVarArray(string, nArray[0]);
            }
            return new GecodeBoolVarArray(string, nArray);
        }
        if (constantDomain.getType() == 1 || constantDomain.getType() == 3) {
            if (n == 1) {
                return new GecodeIntVarArray(string, nArray[0], constantDomain.getFullDomain());
            }
            return new GecodeIntVarArray(string, nArray, constantDomain.getFullDomain());
        }
        if (constantDomain.getType() == 2) {
            if (n == 1) {
                return new GecodeIntVarArray(string, nArray[0], constantDomain.getRange()[0], constantDomain.getRange()[1]);
            }
            return new GecodeIntVarArray(string, nArray, constantDomain.getRange()[0], constantDomain.getRange()[1]);
        }
        throw new GecodeException("Sorry, cannot tailor array '" + string + "' with base-domain " + constantDomain + " to Gecode (yet).");
    }

    private GecodeConstraint tailorBinaryNonLinearConstraint(BinaryNonLinearConstraint binaryNonLinearConstraint) throws GecodeException, Exception {
        if (binaryNonLinearConstraint.getType() == 112) {
            Expression expression = binaryNonLinearConstraint.getLeftArgument();
            Expression expression2 = binaryNonLinearConstraint.getRightArgument();
            Expression expression3 = binaryNonLinearConstraint.getResult();
            if (!(expression instanceof ArithmeticAtomExpression && expression2 instanceof ArithmeticAtomExpression && expression3 instanceof ArithmeticAtomExpression)) {
                throw new GecodeException("Cannot tailor constraint '" + binaryNonLinearConstraint + "': type error. Division requires integer types.");
            }
            GecodeAtom gecodeAtom = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
            GecodeAtom gecodeAtom2 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2);
            GecodeAtom gecodeAtom3 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression3);
            GecodeDiv gecodeDiv = new GecodeDiv(gecodeAtom, gecodeAtom2, gecodeAtom3);
            if (expression2.getType() == 3) {
                int n = ((ArithmeticAtomExpression)expression2).getConstant();
                this.addConstantArgumentToMap(n);
            } else if (gecodeAtom2 instanceof GecodeConstant) {
                this.addConstantArgumentToMap(((GecodeConstant)gecodeAtom2).getConstant());
            }
            return gecodeDiv;
        }
        if (binaryNonLinearConstraint.getType() == 122) {
            Expression expression = binaryNonLinearConstraint.getLeftArgument();
            Expression expression4 = binaryNonLinearConstraint.getRightArgument();
            Expression expression5 = binaryNonLinearConstraint.getResult();
            if (!(expression instanceof ArithmeticAtomExpression && expression4 instanceof ArithmeticAtomExpression && expression5 instanceof ArithmeticAtomExpression)) {
                throw new GecodeException("Cannot tailor constraint '" + binaryNonLinearConstraint + "': type error. Modulo requires integer types.");
            }
            GecodeAtom gecodeAtom = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
            GecodeAtom gecodeAtom4 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression4);
            GecodeAtom gecodeAtom5 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression5);
            GecodeMod gecodeMod = new GecodeMod(gecodeAtom, gecodeAtom4, gecodeAtom5);
            if (expression4.getType() == 3) {
                int n = ((ArithmeticAtomExpression)expression4).getConstant();
                this.addConstantArgumentToMap(n);
            }
            return gecodeMod;
        }
        throw new GecodeException("Cannot tailor constraint '" + binaryNonLinearConstraint + "' of type " + binaryNonLinearConstraint.getClass().getSimpleName() + " yet, sorry.");
    }

    private GecodeConstraint tailorProductConstraint(ProductConstraint productConstraint) throws GecodeException, Exception {
        GecodeAtom gecodeAtom;
        GecodeAtom gecodeAtom2;
        GecodeAtom gecodeAtom3;
        Expression expression = productConstraint.getResult();
        Expression[] expressionArray = productConstraint.getArguments();
        if (expressionArray.length > 2) {
            throw new GecodeException("Flattening error of expression:" + productConstraint + ". Gecode only supports binary multiplication.");
        }
        boolean bl = true;
        boolean bl2 = true;
        if (expressionArray[0] instanceof ArithmeticAtomExpression) {
            if (this.essencePmodel.getDecisionVariables().get(((Object)expressionArray[0]).toString()) instanceof BoolDomain) {
                expressionArray[0] = ((ArithmeticAtomExpression)expressionArray[0]).toRelationalAtomExpression();
                gecodeAtom3 = this.tailorRelationalAtom((RelationalAtomExpression)expressionArray[0]);
            } else {
                bl = false;
                bl2 = false;
                gecodeAtom3 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expressionArray[0]);
            }
        } else if (expressionArray[0] instanceof RelationalAtomExpression) {
            gecodeAtom3 = this.tailorRelationalAtom((RelationalAtomExpression)expressionArray[0]);
        } else {
            throw new GecodeException("Cannot tailor '" + expressionArray[0] + "' in expression '" + productConstraint + "' to Gecode:\nit is not an atom but of type: " + expressionArray[0].getClass().getSimpleName());
        }
        if (expressionArray[1] instanceof ArithmeticAtomExpression) {
            gecodeAtom2 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expressionArray[1]);
            if (this.essencePmodel.getDecisionVariables().get(((Object)expressionArray[1]).toString()) instanceof BoolDomain) {
                expressionArray[1] = ((ArithmeticAtomExpression)expressionArray[1]).toRelationalAtomExpression();
                gecodeAtom2 = this.tailorRelationalAtom((RelationalAtomExpression)expressionArray[1]);
            } else {
                bl = false;
                bl2 = false;
                gecodeAtom2 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expressionArray[1]);
            }
        } else if (expressionArray[1] instanceof RelationalAtomExpression) {
            gecodeAtom2 = this.tailorRelationalAtom((RelationalAtomExpression)expressionArray[1]);
        } else {
            throw new GecodeException("Cannot tailor '" + expressionArray[1] + "' in expression '" + productConstraint + "' to Gecode:\nit is not an atom but of type: " + expressionArray[1].getClass().getSimpleName());
        }
        if (expression instanceof ArithmeticAtomExpression) {
            gecodeAtom = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
            bl = bl2;
        } else if (expression instanceof RelationalAtomExpression) {
            gecodeAtom = this.tailorRelationalAtom((RelationalAtomExpression)expression);
        } else {
            throw new GecodeException("Cannot tailor '" + expression + "' in expression '" + productConstraint + "' to Gecode:\nit is not an atom but of type: " + expression.getClass().getSimpleName());
        }
        if (bl) {
            if (gecodeAtom3 instanceof GecodeConstant) {
                return new SimpleBoolRelation((GecodeVariable)gecodeAtom2, this.mapOperatorToGecode(118), gecodeAtom3, gecodeAtom);
            }
            return new SimpleBoolRelation((GecodeVariable)gecodeAtom3, this.mapOperatorToGecode(118), gecodeAtom2, gecodeAtom);
        }
        return new GecodeMult(gecodeAtom3, gecodeAtom2, gecodeAtom);
    }

    private GecodeDistinct tailorAllDifferent(AllDifferent allDifferent) throws GecodeException {
        Expression expression = allDifferent.getArgument();
        if (!(expression instanceof SingleArray)) {
            throw new GecodeException("Expected array as argument of alldifferent '" + allDifferent + "' instead of: " + expression);
        }
        GecodeArray gecodeArray = this.tailorArray((SingleArray)expression);
        if (gecodeArray instanceof GecodeArray) {
            return new GecodeDistinct(gecodeArray);
        }
        throw new GecodeException("Expected integer array instead of '" + gecodeArray + "' with basic domain:" + ((Array)expression).getBaseDomain().getClass().getSimpleName());
    }

    private GecodeElement tailorElement(ElementConstraint elementConstraint) throws GecodeException, Exception {
        GecodeAtom gecodeAtom;
        Expression expression = elementConstraint.getArray();
        if (!(expression instanceof SingleArray)) {
            throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " because the array " + expression + " is not of type SingleArray.");
        }
        GecodeArray gecodeArray = this.tailorArray((SingleArray)expression);
        Expression expression2 = elementConstraint.getIndexExpression();
        if (!(expression2 instanceof AtomExpression)) {
            throw new GecodeException("Flattening error. Expected atom expression instead of " + expression2 + " as index in element constraint: " + elementConstraint);
        }
        GecodeAtom gecodeAtom2 = expression2 instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2) : this.tailorRelationalAtom((RelationalAtomExpression)expression2);
        Expression expression3 = elementConstraint.getValueExpression();
        if (!(expression3 instanceof AtomExpression)) {
            throw new GecodeException("Flattening error. Expected atom expression instead of " + expression3 + " as value in element constraint: " + elementConstraint);
        }
        GecodeAtom gecodeAtom3 = gecodeAtom = expression3 instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression3) : this.tailorRelationalAtom((RelationalAtomExpression)expression3);
        if (gecodeArray instanceof GecodeIntVarArgs) {
            GecodeIntVarArgs gecodeIntVarArgs = (GecodeIntVarArgs)gecodeArray;
            if (gecodeAtom2 instanceof GecodeIntVar) {
                if (gecodeAtom instanceof GecodeIntVar) {
                    return new GecodeElement(gecodeIntVarArgs, (GecodeIntVar)gecodeAtom2, (GecodeIntVar)gecodeAtom);
                }
                if (gecodeAtom instanceof GecodeConstant) {
                    return new GecodeElement(gecodeIntVarArgs, (GecodeIntVar)gecodeAtom2, (GecodeConstant)gecodeAtom);
                }
                throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " to Gecode." + " The value " + gecodeAtom + " has an infeasible type: " + gecodeAtom.getClass().getSimpleName() + ". Expecting an IntVar or a constant.");
            }
            throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " to Gecode." + " The index " + gecodeAtom2 + " has an infeasible type: " + gecodeAtom2.getClass().getSimpleName() + ". Expecting an IntVar.");
        }
        if (gecodeArray instanceof GecodeBoolVarArgs) {
            GecodeBoolVarArgs gecodeBoolVarArgs = (GecodeBoolVarArgs)gecodeArray;
            if (gecodeAtom2 instanceof GecodeBoolVar) {
                if (gecodeAtom instanceof GecodeBoolVar) {
                    return new GecodeElement(gecodeBoolVarArgs, (GecodeIntVar)gecodeAtom2, (GecodeBoolVar)gecodeAtom);
                }
                if (gecodeAtom instanceof GecodeConstant) {
                    return new GecodeElement(gecodeBoolVarArgs, (GecodeIntVar)gecodeAtom2, (GecodeConstant)gecodeAtom);
                }
                throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " to Gecode." + " The value " + gecodeAtom + " has an infeasible type: " + gecodeAtom.getClass().getSimpleName() + ". Expecting a BoolVar or a constant.");
            }
            throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " to Gecode." + " The index " + gecodeAtom2 + " has an infeasible type: " + gecodeAtom2.getClass().getSimpleName() + ". Expecting an IntVar.");
        }
        if (gecodeArray instanceof GecodeIntArray) {
            GecodeIntArray gecodeIntArray = (GecodeIntArray)gecodeArray;
            if (gecodeAtom2 instanceof GecodeVariable) {
                if (gecodeAtom instanceof GecodeAtom) {
                    return new GecodeElement(gecodeIntArray, (GecodeVariable)gecodeAtom2, gecodeAtom);
                }
                throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " to Gecode." + " The value " + gecodeAtom + " has an infeasible type: " + gecodeAtom.getClass().getSimpleName() + ". Expecting an IntVar or a constant.");
            }
            throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " to Gecode." + " The index " + gecodeAtom2 + " has an infeasible type: " + gecodeAtom2.getClass().getSimpleName() + ". Expecting an IntVar.");
        }
        throw new GecodeException("Cannot tailor element constraint " + elementConstraint + " to Gecode yet." + " The array " + gecodeArray + " has an infeasible type: " + gecodeArray.getClass().getSimpleName());
    }

    private GecodeConstraint tailorSumConstraint(SumConstraint sumConstraint) throws GecodeException, Exception {
        GecodeAtom gecodeAtom;
        Expression expression;
        ArrayList<Expression> arrayList;
        int n;
        if (this.settings.getUseGecodeLinearMinimodelPostConstraints()) {
            StringBuffer stringBuffer = new StringBuffer(sumConstraint.toGecodeString());
            return new GecodePostConstraint(stringBuffer.toString());
        }
        Expression[] expressionArray = sumConstraint.getPositiveArguments();
        Expression[] expressionArray2 = sumConstraint.getNegativeArguments();
        Expression expression2 = sumConstraint.getResult();
        if (expressionArray2.length == 0) {
            boolean bl = true;
            boolean bl2 = true;
            for (n = 0; n < expressionArray.length; ++n) {
                bl &= !(expressionArray[n] instanceof Multiplication);
                bl2 &= expressionArray[n] instanceof AtomExpression;
            }
            if (bl) {
                GecodeAtom gecodeAtom2;
                if (!bl2) {
                    throw new GecodeException("Flattening error. There is a non-atomic argument in the sum constraint: " + sumConstraint);
                }
                GecodeAtom[] gecodeAtomArray = new GecodeAtom[expressionArray.length];
                for (int i = 0; i < gecodeAtomArray.length; ++i) {
                    gecodeAtomArray[i] = expressionArray[i] instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expressionArray[i]) : this.tailorRelationalAtom((RelationalAtomExpression)expressionArray[i]);
                }
                if (!(expression2 instanceof AtomExpression)) {
                    throw new GecodeException("Flattening error. Expected atom as result in " + sumConstraint + " instead of: " + expression2);
                }
                GecodeAtom gecodeAtom3 = gecodeAtom2 = expression2 instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2) : this.tailorRelationalAtom((RelationalAtomExpression)expression2);
                if (this.isPreviouslyDefinedArgument(gecodeAtomArray)) {
                    GecodeLinear gecodeLinear = new GecodeLinear(gecodeAtomArray, this.mapOperatorToGecode(sumConstraint.getOperator()), gecodeAtom2);
                    gecodeLinear.setArgIsAlreadyDefined(true);
                    gecodeLinear.setArgsVarName(this.getPreviouslyDefinedArgument(gecodeAtomArray));
                    return gecodeLinear;
                }
                GecodeLinear gecodeLinear = new GecodeLinear(gecodeAtomArray, this.mapOperatorToGecode(sumConstraint.getOperator()), gecodeAtom2);
                this.addArgumentToMap(gecodeAtomArray, gecodeLinear.getArgVarName());
                return gecodeLinear;
            }
        }
        int[] nArray = new int[expressionArray.length + expressionArray2.length];
        GecodeAtom[] gecodeAtomArray = new GecodeAtom[nArray.length];
        for (n = 0; n < expressionArray.length; ++n) {
            if (expressionArray[n] instanceof Multiplication) {
                arrayList = ((Multiplication)expressionArray[n]).getArguments();
                if (arrayList.size() > 2) {
                    throw new GecodeException("Flattening error. Expected binary multiplication instead of " + expressionArray[n] + " in :" + sumConstraint);
                }
                if (arrayList.get(0).getType() != 3) {
                    throw new GecodeException("Flattening error. Expected linear multiplication instead of " + expressionArray[n] + " in :" + sumConstraint);
                }
                nArray[n] = ((ArithmeticAtomExpression)arrayList.get(0)).getConstant();
                expression = arrayList.get(1);
                if (!(expression instanceof AtomExpression)) {
                    throw new GecodeException("Flattening error. There is a non-atomic argument " + expression + " in the sum constraint: " + sumConstraint);
                }
                gecodeAtomArray[n] = expression instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression) : this.tailorRelationalAtom((RelationalAtomExpression)expression);
                continue;
            }
            if (expressionArray[n] instanceof AtomExpression) {
                nArray[n] = 1;
                gecodeAtomArray[n] = expressionArray[n] instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expressionArray[n]) : this.tailorRelationalAtom((RelationalAtomExpression)expressionArray[n]);
                continue;
            }
            throw new GecodeException("Flattening error. Expected atom as result in " + sumConstraint + " instead of: " + expressionArray[n]);
        }
        for (n = 0; n < expressionArray2.length; ++n) {
            if (expressionArray2[n] instanceof Multiplication) {
                arrayList = ((Multiplication)expressionArray2[n]).getArguments();
                if (arrayList.size() > 2) {
                    throw new GecodeException("Flattening error. Expected binary multiplication instead of " + expressionArray2[n] + " in :" + sumConstraint);
                }
                if (arrayList.get(0).getType() != 3) {
                    throw new GecodeException("Flattening error. Expected linear multiplication instead of " + expressionArray2[n] + " in :" + sumConstraint);
                }
                nArray[n + expressionArray.length] = -((ArithmeticAtomExpression)arrayList.get(0)).getConstant();
                expression = (Expression)arrayList.get(1);
                if (!(expression instanceof AtomExpression)) {
                    throw new GecodeException("Flattening error. There is a non-atomic argument " + expression + " in the sum constraint: " + sumConstraint);
                }
                gecodeAtomArray[n + expressionArray.length] = expression instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression) : this.tailorRelationalAtom((RelationalAtomExpression)expression);
                continue;
            }
            if (expressionArray2[n] instanceof AtomExpression) {
                nArray[n + expressionArray.length] = -1;
                gecodeAtomArray[n + expressionArray.length] = expressionArray2[n] instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expressionArray2[n]) : this.tailorRelationalAtom((RelationalAtomExpression)expressionArray2[n]);
                continue;
            }
            throw new GecodeException("Flattening error. Expected atom as result in " + sumConstraint + " instead of: " + expressionArray2[n]);
        }
        if (!(expression2 instanceof AtomExpression)) {
            throw new GecodeException("Flattening error. Expected atom as result in " + sumConstraint + " instead of: " + expression2);
        }
        GecodeAtom gecodeAtom4 = gecodeAtom = expression2 instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2) : this.tailorRelationalAtom((RelationalAtomExpression)expression2);
        if (this.isPreviouslyDefinedArgument(gecodeAtomArray)) {
            arrayList = new GecodeLinear(gecodeAtomArray, nArray, this.mapOperatorToGecode(sumConstraint.getOperator()), gecodeAtom);
            ((GecodeLinear)((Object)arrayList)).setArgIsAlreadyDefined(true);
            ((GecodeLinear)((Object)arrayList)).setArgsVarName(this.getPreviouslyDefinedArgument(gecodeAtomArray));
            if (this.isPreviouslyDefinedWeight(nArray)) {
                ((GecodeLinear)((Object)arrayList)).setWeightsVarName(this.getPreviouslyDefinedWeight(nArray));
            } else {
                this.addWeightArgumentToMap(nArray, ((GecodeLinear)((Object)arrayList)).getWeightsVarName());
            }
            return arrayList;
        }
        arrayList = new GecodeLinear(gecodeAtomArray, nArray, this.mapOperatorToGecode(sumConstraint.getOperator()), gecodeAtom);
        this.addArgumentToMap(gecodeAtomArray, ((GecodeLinear)((Object)arrayList)).getArgVarName());
        if (this.isPreviouslyDefinedWeight(nArray)) {
            ((GecodeLinear)((Object)arrayList)).setWeightsVarName(this.getPreviouslyDefinedWeight(nArray));
        } else {
            this.addWeightArgumentToMap(nArray, ((GecodeLinear)((Object)arrayList)).getWeightsVarName());
        }
        return arrayList;
    }

    private RelationalConstraint tailorConjunction(Conjunction conjunction) throws GecodeException, Exception {
        ArrayList<Expression> arrayList = conjunction.getArguments();
        GecodeAtom[] gecodeAtomArray = new GecodeAtom[arrayList.size()];
        for (int i = 0; i < gecodeAtomArray.length; ++i) {
            if (!(arrayList.get(i) instanceof RelationalAtomExpression)) {
                throw new GecodeException("Type error: cannot apply conjunction on integer argument '" + arrayList.get(i) + "' in expression " + conjunction);
            }
            gecodeAtomArray[i] = this.tailorRelationalAtom((RelationalAtomExpression)arrayList.get(i));
        }
        GecodeLinear gecodeLinear = new GecodeLinear(gecodeAtomArray, '\n', new GecodeConstant(gecodeAtomArray.length));
        if (this.isPreviouslyDefinedArgument(gecodeAtomArray)) {
            gecodeLinear.setArgsVarName(this.getPreviouslyDefinedArgument(gecodeAtomArray));
            gecodeLinear.setArgIsAlreadyDefined(true);
        } else {
            this.addArgumentToMap(gecodeAtomArray, gecodeLinear.getArgVarName());
        }
        return gecodeLinear;
    }

    private RelationalConstraint tailorDisjunction(Disjunction disjunction) throws GecodeException, Exception {
        ArrayList<Expression> arrayList = disjunction.getArguments();
        GecodeAtom[] gecodeAtomArray = new GecodeAtom[arrayList.size()];
        for (int i = 0; i < gecodeAtomArray.length; ++i) {
            if (!(arrayList.get(i) instanceof RelationalAtomExpression)) {
                throw new GecodeException("Type error: cannot apply disjunction on integer argument '" + arrayList.get(i) + "' in expression " + disjunction);
            }
            gecodeAtomArray[i] = this.tailorRelationalAtom((RelationalAtomExpression)arrayList.get(i));
        }
        GecodeLinear gecodeLinear = new GecodeLinear(gecodeAtomArray, '\u000e', new GecodeConstant(1));
        if (this.isPreviouslyDefinedArgument(gecodeAtomArray)) {
            gecodeLinear.setArgsVarName(this.getPreviouslyDefinedArgument(gecodeAtomArray));
            gecodeLinear.setArgIsAlreadyDefined(true);
        } else {
            this.addArgumentToMap(gecodeAtomArray, gecodeLinear.getArgVarName());
        }
        return gecodeLinear;
    }

    private RelationalConstraint tailorQuantifiedSum(QuantifiedSum quantifiedSum, Expression expression, int n, boolean bl) throws GecodeException, Exception {
        Object object;
        Expression expression2 = quantifiedSum.getQuantifiedExpression();
        Domain domain = quantifiedSum.getQuantifiedDomain();
        ExpressionRange expressionRange = null;
        if (!(domain instanceof ExpressionRange)) {
            throw new GecodeException("Infeasible quantified domain " + domain + " of " + quantifiedSum);
        }
        expressionRange = (ExpressionRange)domain;
        ArrayVariable arrayVariable = null;
        if (expression2 instanceof AtomExpression) {
            object = ((AtomExpression)expression2).getVariable();
            if (!(object instanceof ArrayVariable)) {
                throw new GecodeException("Internal error. Unexpected variable type " + object.getClass().getSimpleName() + " of quantified sum argument " + object + " in " + quantifiedSum);
            }
        } else {
            throw new GecodeException("Internal error. Unexpected argument type " + expression2.getClass().getSimpleName() + " of quantified sum argument " + expression2 + " in " + quantifiedSum);
        }
        arrayVariable = (ArrayVariable)object;
        object = expression instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
        int n2 = arrayVariable.getDimension();
        if (n2 == 1) {
            Expression expression3 = arrayVariable.getExpressionIndices()[0];
            MatrixDomain matrixDomain = (MatrixDomain)arrayVariable.getBaseDomain();
            Domain domain2 = matrixDomain.getIndexDomains()[0];
            if (expression3.getCategory() == 2) {
                Expression[] expressionArray = expression3.getDefinedDomain();
                if (domain2 instanceof ExpressionRange) {
                    ExpressionRange expressionRange2 = (ExpressionRange)domain2;
                    if (((Object)expressionArray[0]).toString().equals(((Object)expressionRange2.getLowerAndUpperBound()[0]).toString()) && ((Object)expressionArray[1]).toString().equals(((Object)expressionRange2.getLowerAndUpperBound()[1]).toString())) {
                        return new GecodeForallLinear((GecodeVariable)(expression2 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression2) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2)), this.mapOperatorToGecode(n), (GecodeAtom)object);
                    }
                    GecodeVariable gecodeVariable = (GecodeVariable)(expression2 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression2) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2));
                    Expression expression4 = expressionRange.getLowerAndUpperBound()[0];
                    Expression expression5 = expressionRange.getLowerAndUpperBound()[1];
                    int n3 = 0;
                    if (!arrayVariable.getArrayNameOnly().startsWith("aux")) {
                        n3 = this.essencePmodel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), 0);
                    } else if (expression4.getType() == 3) {
                        n3 = ((ArithmeticAtomExpression)expression4).getConstant();
                    }
                    return new GecodeForallLinear(gecodeVariable, n3, quantifiedSum.getQuantifiedVariables(), expression4, expression5, this.mapOperatorToGecode(n), (GecodeAtom)object);
                }
                throw new GecodeException("Infeasible index domain for " + arrayVariable + ": expected expression range instead of " + domain2);
            }
            throw new GecodeException("Cannot tailor quantified sum " + quantifiedSum + " with un-quantified argument " + expression2 + " yet.");
        }
        if (n2 == 2) {
            int n4;
            Object object2;
            int n5;
            Object object3;
            Expression[] expressionArray = arrayVariable.getExpressionIndices();
            MatrixDomain matrixDomain = (MatrixDomain)arrayVariable.getBaseDomain();
            Domain[] domainArray = matrixDomain.getIndexDomains();
            String[] stringArray = quantifiedSum.getQuantifiedVariables();
            boolean bl2 = true;
            int n6 = 0;
            for (int i = 0; i < expressionArray.length; ++i) {
                if (expressionArray[i].getCategory() == 2) {
                    object3 = expressionArray[i].getQuantifyingVariables();
                    for (n5 = 0; n5 < ((ArrayList)object3).size(); ++n5) {
                        object2 = ((Object)((Expression)((ArrayList)object3).get(n5))).toString();
                        n4 = 0;
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (!((String)object2).equals(stringArray[j])) continue;
                            n4 = 1;
                            break;
                        }
                        if (n4 != 0) continue;
                        bl2 = false;
                        n6 = n5;
                    }
                    continue;
                }
                bl2 = false;
            }
            if (bl2) {
                Domain domain3;
                int n7;
                Expression[][] expressionArray2 = new Expression[expressionArray.length][2];
                for (n7 = 0; n7 < expressionArray2.length; ++n7) {
                    expressionArray2[n7] = expressionArray[n7].getDefinedDomain();
                }
                n7 = 1;
                for (n5 = 0; n5 < expressionArray.length; ++n5) {
                    if (!(domainArray[n5] instanceof ExpressionRange)) continue;
                    object2 = (ExpressionRange)domainArray[n5];
                    if (((Object)expressionArray2[n5][0]).toString().equals(((Object)object2.getLowerAndUpperBound()[0]).toString()) && ((Object)expressionArray2[n5][1]).toString().equals(((Object)object2.getLowerAndUpperBound()[1]).toString())) continue;
                    n7 = 0;
                }
                if (n7 != 0) {
                    return new GecodeForallLinear((GecodeVariable)(expression2 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression2) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2)), this.mapOperatorToGecode(n), (GecodeAtom)object);
                }
                GecodeVariable gecodeVariable = (GecodeVariable)(expression2 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression2) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2));
                object2 = new int[domainArray.length];
                if (arrayVariable.getArrayNameOnly().startsWith("aux")) {
                    for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                        object2[n4] = false;
                    }
                } else {
                    for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                        object2[n4] = this.essencePmodel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), n4);
                    }
                }
                if (!((domain3 = quantifiedSum.getQuantifiedDomain()) instanceof ExpressionRange)) {
                    throw new GecodeException("Cannot tailor sum with quantifying domain " + domain3 + ", because it is not an expression range.");
                }
                Expression expression6 = expressionRange.getLowerAndUpperBound()[0];
                Expression expression7 = expressionRange.getLowerAndUpperBound()[1];
                return new GecodeForallLinear(gecodeVariable, (int)object2[n6], stringArray, expression6, expression7, this.mapOperatorToGecode(n), (GecodeAtom)object);
            }
            GecodeVariable gecodeVariable = (GecodeVariable)(expression2 instanceof RelationalAtomExpression ? this.tailorRelationalAtom((RelationalAtomExpression)expression2) : this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2));
            object3 = new int[domainArray.length];
            for (n5 = 0; n5 < ((Object)object3).length; ++n5) {
                object3[n5] = this.essencePmodel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), n5);
            }
            Domain domain4 = quantifiedSum.getQuantifiedDomain();
            if (!(domain4 instanceof ExpressionRange)) {
                throw new GecodeException("Cannot tailor sum with quantifying domain " + domain4 + ", because it is not an expression range.");
            }
            object2 = expressionRange.getLowerAndUpperBound()[0];
            Expression expression8 = expressionRange.getLowerAndUpperBound()[1];
            return new GecodeForallLinear(gecodeVariable, (int)object3[n6], stringArray, (Expression)object2, expression8, this.mapOperatorToGecode(n), (GecodeAtom)object);
        }
        throw new GecodeException("Cannot tailor quantified sum " + quantifiedSum + " relop " + expression + " to Gecode yet, sorry.");
    }

    private RelationalConstraint tailorRelation(BinaryRelationalExpression binaryRelationalExpression) throws GecodeException, Exception {
        if (this.settings.isClassLevelTransformation() && binaryRelationalExpression.getRightArgument() instanceof QuantifiedSum) {
            return this.tailorQuantifiedSum((QuantifiedSum)binaryRelationalExpression.getRightArgument(), binaryRelationalExpression.getLeftArgument(), binaryRelationalExpression.getOperator(), true);
        }
        if (this.settings.isClassLevelTransformation() && binaryRelationalExpression.getLeftArgument() instanceof QuantifiedSum) {
            return this.tailorQuantifiedSum((QuantifiedSum)binaryRelationalExpression.getLeftArgument(), binaryRelationalExpression.getRightArgument(), binaryRelationalExpression.getOperator(), false);
        }
        if (this.settings.isClassLevelTransformation() && binaryRelationalExpression.getLeftArgument() instanceof QuantifiedSum && binaryRelationalExpression.getRightArgument() instanceof QuantifiedSum) {
            throw new GecodeException("Cannot handle two quantified sums yet:" + binaryRelationalExpression);
        }
        if (binaryRelationalExpression instanceof NonCommutativeRelationalBinaryExpression) {
            NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression = (NonCommutativeRelationalBinaryExpression)binaryRelationalExpression;
            Expression expression = nonCommutativeRelationalBinaryExpression.getLeftArgument();
            Expression expression2 = nonCommutativeRelationalBinaryExpression.getRightArgument();
            if (binaryRelationalExpression.getType() == 116 && expression.getCategory() <= 2) {
                ArrayList<GecodeConstraint> arrayList = new ArrayList<GecodeConstraint>();
                if (expression2 instanceof Conjunction) {
                    ArrayList<Expression> arrayList2 = ((Conjunction)expression2).getArguments();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        arrayList.add(this.tailorToGecode(arrayList2.get(i)));
                    }
                } else {
                    arrayList.add(this.tailorToGecode(expression2));
                }
                return new GecodeIf(expression, arrayList);
            }
            if (expression instanceof ArithmeticAtomExpression) {
                GecodeAtom gecodeAtom = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
                GecodeAtom gecodeAtom2 = null;
                if (expression2 instanceof ArithmeticAtomExpression) {
                    gecodeAtom2 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2);
                } else if (expression2.getCategory() <= 2) {
                    gecodeAtom2 = new GecodeConstant(expression2);
                } else {
                    throw new GecodeException(expression2 instanceof RelationalAtomExpression ? "Type error. Cannot apply relational operator on arithmetic and boolean argument in: " + binaryRelationalExpression : "Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of: " + expression2);
                }
                return this.tailorSimpleIntegerRelation(gecodeAtom, this.mapOperatorToGecode(nonCommutativeRelationalBinaryExpression.getOperator()), gecodeAtom2);
            }
            if (expression instanceof RelationalAtomExpression) {
                GecodeAtom gecodeAtom = this.tailorRelationalAtom((RelationalAtomExpression)expression);
                GecodeAtom gecodeAtom3 = null;
                if (expression2 instanceof RelationalAtomExpression) {
                    gecodeAtom3 = this.tailorRelationalAtom((RelationalAtomExpression)expression2);
                } else if (expression2.getCategory() <= 2) {
                    gecodeAtom3 = new GecodeConstant(expression2);
                } else {
                    throw new GecodeException(expression2 instanceof RelationalAtomExpression ? "Type error. Cannot apply relational operator on arithmetic and boolean argument in: " + binaryRelationalExpression : "Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of: " + expression2);
                }
                return this.tailorSimpleBooleanRelation(gecodeAtom, this.mapOperatorToGecode(nonCommutativeRelationalBinaryExpression.getOperator()), gecodeAtom3);
            }
            if (expression.getCategory() <= 2) {
                GecodeConstant gecodeConstant = new GecodeConstant(expression);
                GecodeAtom gecodeAtom = null;
                if (expression2 instanceof AtomExpression) {
                    gecodeAtom = expression2 instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2) : this.tailorRelationalAtom((RelationalAtomExpression)expression2);
                } else if (expression2.getCategory() <= 2) {
                    gecodeAtom = new GecodeConstant(expression2);
                } else {
                    throw new GecodeException(expression2 instanceof RelationalAtomExpression ? "Type error. Cannot apply relational operator on arithmetic and boolean argument in: " + binaryRelationalExpression : "Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of: " + expression2);
                }
                return this.tailorSimpleBooleanRelation(gecodeConstant, this.mapOperatorToGecode(nonCommutativeRelationalBinaryExpression.getOperator()), gecodeAtom);
            }
            throw new GecodeException("Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of :" + expression);
        }
        if (binaryRelationalExpression instanceof CommutativeBinaryRelationalExpression) {
            CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression = (CommutativeBinaryRelationalExpression)binaryRelationalExpression;
            Expression expression = commutativeBinaryRelationalExpression.getLeftArgument();
            Expression expression3 = commutativeBinaryRelationalExpression.getRightArgument();
            if (expression instanceof ArithmeticAtomExpression) {
                GecodeAtom gecodeAtom = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
                GecodeAtom gecodeAtom4 = null;
                if (expression3 instanceof ArithmeticAtomExpression) {
                    gecodeAtom4 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression3);
                } else if (expression3.getCategory() <= 2) {
                    gecodeAtom4 = new GecodeConstant(expression3);
                } else {
                    throw new GecodeException(expression3 instanceof RelationalAtomExpression ? "Type error. Cannot apply relational operator on arithmetic and boolean argument in: " + binaryRelationalExpression : "Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of: " + expression3);
                }
                return this.tailorSimpleIntegerRelation(gecodeAtom, this.mapOperatorToGecode(commutativeBinaryRelationalExpression.getOperator()), gecodeAtom4);
            }
            if (expression instanceof RelationalAtomExpression) {
                GecodeAtom gecodeAtom = this.tailorRelationalAtom((RelationalAtomExpression)expression);
                GecodeAtom gecodeAtom5 = null;
                if (expression3 instanceof RelationalAtomExpression) {
                    gecodeAtom5 = this.tailorRelationalAtom((RelationalAtomExpression)expression3);
                } else if (expression3.getCategory() == 2) {
                    gecodeAtom5 = new GecodeConstant(expression3);
                } else {
                    throw new GecodeException(expression3 instanceof RelationalAtomExpression ? "Type error. Cannot apply relational operator on arithmetic and boolean argument in: " + binaryRelationalExpression : "Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of: " + expression3);
                }
                return this.tailorSimpleBooleanRelation(gecodeAtom, this.mapOperatorToGecode(commutativeBinaryRelationalExpression.getOperator()), gecodeAtom5);
            }
            if (expression.getCategory() <= 2) {
                GecodeConstant gecodeConstant = new GecodeConstant(expression);
                GecodeAtom gecodeAtom = null;
                if (expression3 instanceof AtomExpression) {
                    gecodeAtom = expression3 instanceof ArithmeticAtomExpression ? this.tailorArithmeticAtom((ArithmeticAtomExpression)expression3) : this.tailorRelationalAtom((RelationalAtomExpression)expression3);
                } else if (expression3.getCategory() <= 2) {
                    gecodeAtom = new GecodeConstant(expression3);
                } else {
                    throw new GecodeException(expression3 instanceof RelationalAtomExpression ? "Type error. Cannot apply relational operator on arithmetic and boolean argument in: " + binaryRelationalExpression : "Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of: " + expression3);
                }
                return this.tailorSimpleBooleanRelation(gecodeConstant, this.mapOperatorToGecode(commutativeBinaryRelationalExpression.getOperator()), gecodeAtom);
            }
            throw new GecodeException("Flattening error. Cannot tailor " + binaryRelationalExpression + " to Gecode.\nExpected an atom instead of :" + expression);
        }
        throw new GecodeException("Sorry, cannot tailor relation " + binaryRelationalExpression + " to Gecode (yet).");
    }

    private SimpleIntRelation tailorSimpleIntegerRelation(GecodeAtom gecodeAtom, char c, GecodeAtom gecodeAtom2) throws GecodeException {
        if (gecodeAtom instanceof GecodeIntAtomVariable) {
            if (gecodeAtom2 instanceof GecodeIntAtomVariable) {
                return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom, c, (GecodeIntAtomVariable)gecodeAtom2);
            }
            if (gecodeAtom2 instanceof GecodeConstant) {
                this.addConstantArgumentToMap(((GecodeConstant)gecodeAtom2).getConstant());
                return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom, c, (GecodeConstant)gecodeAtom2);
            }
            throw new GecodeException("Sorry, cannot tailor " + gecodeAtom + " " + c + " " + gecodeAtom2 + " to Gecode.\nExpected constant or variable atom instead of: " + gecodeAtom2);
        }
        if (gecodeAtom instanceof GecodeConstant) {
            this.addConstantArgumentToMap(((GecodeConstant)gecodeAtom).getConstant());
            if (gecodeAtom2 instanceof GecodeIntAtomVariable) {
                if (this.isCommutativeOperator(c)) {
                    return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom2, c, (GecodeConstant)gecodeAtom);
                }
                return new SimpleIntRelation((GecodeIntAtomVariable)gecodeAtom2, this.invertRelationalGecodeOperator(c), (GecodeConstant)gecodeAtom);
            }
            throw new GecodeException("Sorry, cannot tailor " + gecodeAtom + " " + c + " " + gecodeAtom2 + " to Gecode.\nExpected a variable atom instead of: " + gecodeAtom2);
        }
        throw new GecodeException("Sorry, cannot tailor " + gecodeAtom + " " + c + " " + gecodeAtom2 + " to Gecode.\n");
    }

    private SimpleBoolRelation tailorSimpleBooleanRelation(GecodeAtom gecodeAtom, char c, GecodeAtom gecodeAtom2) throws GecodeException {
        if (gecodeAtom instanceof GecodeBoolAtomVariable) {
            if (gecodeAtom2 instanceof GecodeBoolAtomVariable) {
                return new SimpleBoolRelation((GecodeBoolAtomVariable)gecodeAtom, c, (GecodeBoolAtomVariable)gecodeAtom2);
            }
            if (gecodeAtom2 instanceof GecodeConstant) {
                this.addConstantArgumentToMap(((GecodeConstant)gecodeAtom2).getConstant());
                return new SimpleBoolRelation((GecodeBoolAtomVariable)gecodeAtom, c, (GecodeConstant)gecodeAtom2);
            }
            throw new GecodeException("Sorry, cannot tailor " + gecodeAtom + " " + c + " " + gecodeAtom2 + " to Gecode.\nExpected constant or variable atom instead of: " + gecodeAtom2);
        }
        if (gecodeAtom instanceof GecodeConstant) {
            this.addConstantArgumentToMap(((GecodeConstant)gecodeAtom).getConstant());
            if (gecodeAtom2 instanceof GecodeBoolAtomVariable) {
                if (this.isCommutativeOperator(c)) {
                    return new SimpleBoolRelation((GecodeBoolAtomVariable)gecodeAtom2, c, (GecodeConstant)gecodeAtom);
                }
                return new SimpleBoolRelation((GecodeBoolAtomVariable)gecodeAtom2, this.invertRelationalGecodeOperator(c), (GecodeConstant)gecodeAtom);
            }
            throw new GecodeException("Sorry, cannot tailor " + gecodeAtom + " " + c + " " + gecodeAtom2 + " to Gecode.\nExpected a variable atom instead of: " + gecodeAtom2);
        }
        throw new GecodeException("Sorry, cannot tailor " + gecodeAtom + " " + c + " " + gecodeAtom2 + " to Gecode.\n");
    }

    private GecodeAbs tailorAbsoluteConstraint(AbsoluteConstraint absoluteConstraint) throws GecodeException, Exception {
        Expression expression = absoluteConstraint.getArgument();
        Expression expression2 = absoluteConstraint.getResult();
        if (!(expression instanceof ArithmeticAtomExpression)) {
            throw new GecodeException("Cannot tailor argument '" + expression + "' of abs-expression '" + absoluteConstraint + "' to Gecode because it is not an integer atom.");
        }
        GecodeAtom gecodeAtom = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression);
        if (!(expression2 instanceof ArithmeticAtomExpression)) {
            throw new GecodeException("Cannot tailor argument '" + expression2 + "' of abs-expression '" + absoluteConstraint + "' to Gecode because it is not an integer atom.");
        }
        GecodeAtom gecodeAtom2 = this.tailorArithmeticAtom((ArithmeticAtomExpression)expression2);
        if (!(gecodeAtom instanceof GecodeAtom) || !(gecodeAtom2 instanceof GecodeAtom)) {
            throw new GecodeException("Error. Cannot tailor absolute constraint '" + absoluteConstraint + "' to Gecode: argument and result have to be integer variables instead of:" + absoluteConstraint.getClass().getSimpleName());
        }
        return new GecodeAbs(gecodeAtom, gecodeAtom2);
    }

    private GecodeArrayVariable tailorToGecodeIntArray(Array array) throws GecodeException {
        if (array instanceof SimpleArray) {
            SimpleArray simpleArray = (SimpleArray)array;
            BasicDomain[] basicDomainArray = simpleArray.getIndexDomains();
            if (basicDomainArray.length > 1) {
                throw new GecodeException("Cannot tailor multi-dimensional arrays like '" + array + "' yet, sorry.");
            }
            if (!(basicDomainArray[0] instanceof ConstantDomain)) {
                throw new GecodeException("Expected constant index domain instead of:" + basicDomainArray[0]);
            }
            ConstantDomain constantDomain = (ConstantDomain)basicDomainArray[0];
            int n = constantDomain.getRange()[1] - constantDomain.getRange()[0] + 1;
            Domain domain = simpleArray.getBaseDomain();
            if (domain instanceof BoolDomain) {
                return new GecodeBoolVarArray(simpleArray.getArrayName(), n);
            }
            if (!(domain instanceof ConstantDomain)) {
                throw new GecodeException("Expected constant index domain instead of:" + domain);
            }
            ConstantDomain constantDomain2 = (ConstantDomain)domain;
            return new GecodeIntVarArray(simpleArray.getArrayName(), n, constantDomain2.getRange()[0], constantDomain2.getRange()[1]);
        }
        throw new GecodeException("Cannot tailor array '" + array + "' of type " + array.getClass().getSimpleName() + " yet, sorry.");
    }

    private GecodeAtom tailorArithmeticAtom(ArithmeticAtomExpression arithmeticAtomExpression) throws GecodeException, Exception {
        if (arithmeticAtomExpression.getType() == 3) {
            return new GecodeConstant(arithmeticAtomExpression.getConstant());
        }
        if (arithmeticAtomExpression.getCategory() <= 1) {
            return new GecodeConstant(arithmeticAtomExpression);
        }
        if (arithmeticAtomExpression.getType() == 21) {
            Variable variable = arithmeticAtomExpression.getVariable();
            GecodeIntVar gecodeIntVar = new GecodeIntVar(variable.getVariableName(), variable.getDomain()[0], variable.getDomain()[1]);
            gecodeIntVar.setIsParameter(arithmeticAtomExpression.isParameter());
            gecodeIntVar.setIsQuantifiedVariable(arithmeticAtomExpression.isQuantifiedVariable());
            return gecodeIntVar;
        }
        if (arithmeticAtomExpression.getType() == 22) {
            ArrayVariable arrayVariable = (ArrayVariable)arithmeticAtomExpression.getVariable();
            if (arrayVariable.getExpressionIndices() != null) {
                if (!this.settings.isClassLevelTransformation()) {
                    throw new GecodeException("Sorry. Cannot tailor array variables with non-integer indices such as '" + arithmeticAtomExpression + "' yet.");
                }
                Expression[] expressionArray = arrayVariable.getExpressionIndices();
                for (int i = 0; i < expressionArray.length; ++i) {
                    if (expressionArray[i].getCategory() != 3 || this.settings.isClassLevelTransformation()) continue;
                    throw new GecodeException("Flattening error.'" + arithmeticAtomExpression + "' is indexed by a decision variable.");
                }
                return new GecodeIntArrayElem(arrayVariable.getArrayNameOnly(), expressionArray, arrayVariable.getDefinedDomain()[0], arrayVariable.getDefinedDomain()[1]);
            }
            return new GecodeIntArrayElem(arrayVariable.getArrayNameOnly(), arrayVariable.getIntegerIndices(), arrayVariable.getDomain()[0], arrayVariable.getDomain()[1]);
        }
        throw new GecodeException("Unknown arithmetic atomic type: " + arithmeticAtomExpression);
    }

    private GecodeAtom tailorRelationalAtom(RelationalAtomExpression relationalAtomExpression) throws GecodeException, Exception {
        if (relationalAtomExpression.getType() == 0) {
            return new GecodeConstant(relationalAtomExpression.getBool() ? 1 : 0);
        }
        if (relationalAtomExpression.getType() == 5) {
            Variable variable = relationalAtomExpression.getVariable();
            return new GecodeBoolVar(variable.getVariableName());
        }
        if (relationalAtomExpression.getType() == 6) {
            ArrayVariable arrayVariable = (ArrayVariable)relationalAtomExpression.getVariable();
            if (arrayVariable.getExpressionIndices() != null) {
                if (!this.settings.isClassLevelTransformation()) {
                    throw new GecodeException("Sorry. Cannot tailor array variables with non-integer indices such as '" + relationalAtomExpression + "' yet.");
                }
                Expression[] expressionArray = arrayVariable.getExpressionIndices();
                for (int i = 0; i < expressionArray.length; ++i) {
                    if (expressionArray[i].getCategory() != 3 || this.settings.isClassLevelTransformation()) continue;
                    throw new GecodeException("Flattening error.'" + relationalAtomExpression + "' is indexed by a decision variable.");
                }
                return new GecodeBoolArrayElem(arrayVariable.getArrayNameOnly(), expressionArray);
            }
            return new GecodeBoolArrayElem(arrayVariable.getArrayNameOnly(), arrayVariable.getIntegerIndices());
        }
        throw new GecodeException("Unknown arithmetic atomic type: " + relationalAtomExpression);
    }

    private GecodePostConstraint tailorLinearExpression(Expression expression) throws GecodeException, Exception {
        return new GecodePostConstraint(this.adaptLinearExpression(expression));
    }

    private String adaptLinearExpression(Expression expression) throws GecodeException, Exception {
        if (expression instanceof AbsoluteConstraint) {
            return "|" + this.adaptLinearExpression(((AbsoluteConstraint)expression).getArgument()) + "| == " + this.adaptLinearExpression(((AbsoluteConstraint)expression).getResult());
        }
        if (expression instanceof AbsoluteValue) {
            return "|" + this.adaptLinearExpression(((AbsoluteValue)expression).getArgument()) + "|";
        }
        if (expression instanceof ArithmeticAtomExpression) {
            if (expression.getType() == 22) {
                Object object;
                Object object2;
                ArrayVariable arrayVariable = (ArrayVariable)((ArithmeticAtomExpression)expression).getVariable();
                if (arrayVariable.getExpressionIndices() != null) {
                    throw new GecodeException("Sorry. Cannot tailor array variables with non-integer indices such as '" + expression + "' yet.");
                }
                int n = arrayVariable.getIntegerIndices().length;
                if (n == 0) {
                    throw new GecodeException("Cannot tailor array variable " + arrayVariable + " with non-constant index yet, sorry.");
                }
                if (!arrayVariable.isIndexAdaptedToSolver()) {
                    object2 = new int[n];
                    object = this.essencePmodel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    if (!(object instanceof ConstantArrayDomain)) {
                        throw new GecodeException("Expected constant domain for variable '" + arrayVariable + "' instead of: " + object);
                    }
                    ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)object).getIndexDomains();
                    if (constantDomainArray.length != ((int[])object2).length) {
                        throw new GecodeException("Unfeasible amount of array indices: " + arrayVariable.getArrayNameOnly() + " is " + constantDomainArray.length + "-dimensional but it is indexed with " + ((Object)object2).length + " indices.");
                    }
                    for (int i = 0; i < constantDomainArray.length; ++i) {
                        object2[i] = this.settings.getTargetSolver().getArrayIndexingStartValue() - constantDomainArray[i].getRange()[0];
                    }
                    arrayVariable = arrayVariable.adaptOffsetToIndices((int[])object2);
                }
                if (n == 1) {
                    return arrayVariable.toString();
                }
                object2 = new StringBuffer(arrayVariable.getArrayNameOnly() + "(");
                object = arrayVariable.getIntegerIndices();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)object2).append(",");
                    }
                    ((StringBuffer)object2).append((int)object[i]);
                }
                return ((StringBuffer)object2).toString() + ")";
            }
            return ((Object)expression).toString();
        }
        if (expression instanceof RelationalAtomExpression) {
            if (expression.getType() == 6) {
                Object object;
                Object object3;
                ArrayVariable arrayVariable = (ArrayVariable)((RelationalAtomExpression)expression).getVariable();
                if (arrayVariable.getExpressionIndices() != null) {
                    throw new GecodeException("Sorry. Cannot tailor array variables with non-integer indices such as '" + expression + "' yet.");
                }
                if (!arrayVariable.isIndexAdaptedToSolver()) {
                    object3 = new int[arrayVariable.getIntegerIndices().length];
                    object = this.essencePmodel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    if (!(object instanceof ConstantArrayDomain)) {
                        throw new GecodeException("Expected constant domain for variable '" + arrayVariable + "' instead of: " + object);
                    }
                    ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)object).getIndexDomains();
                    if (constantDomainArray.length != ((int[])object3).length) {
                        throw new GecodeException("Unfeasible amount of array indices: " + arrayVariable.getArrayNameOnly() + " is " + constantDomainArray.length + "-dimensional but it is indexed with " + ((Object)object3).length + " indices.");
                    }
                    for (int i = 0; i < constantDomainArray.length; ++i) {
                        object3[i] = this.settings.getTargetSolver().getArrayIndexingStartValue() - constantDomainArray[i].getRange()[0];
                    }
                    arrayVariable = arrayVariable.adaptOffsetToIndices((int[])object3);
                }
                if (arrayVariable.getIntegerIndices().length == 1) {
                    return arrayVariable.toString();
                }
                object3 = new StringBuffer(arrayVariable.getArrayNameOnly() + "(");
                object = arrayVariable.getIntegerIndices();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)object3).append(",");
                    }
                    ((StringBuffer)object3).append((int)object[i]);
                }
                return ((StringBuffer)object3).toString() + ")";
            }
            return ((Object)expression).toString();
        }
        if (expression instanceof SumConstraint) {
            int n;
            StringBuffer stringBuffer = new StringBuffer("");
            SumConstraint sumConstraint = (SumConstraint)expression;
            Expression[] expressionArray = sumConstraint.getPositiveArguments();
            for (n = 0; n < expressionArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append(this.adaptLinearExpression(expressionArray[n]));
            }
            expressionArray = sumConstraint.getNegativeArguments();
            for (n = 0; n < expressionArray.length; ++n) {
                stringBuffer.append("-" + this.adaptLinearExpression(expressionArray[n]));
            }
            stringBuffer.append(" " + this.relationalOperatorToString(this.mapOperatorToGecode(sumConstraint.getOperator())) + " " + this.adaptLinearExpression(sumConstraint.getResult()));
            return stringBuffer.toString();
        }
        if (expression instanceof CommutativeBinaryRelationalExpression) {
            CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression = (CommutativeBinaryRelationalExpression)expression;
            return this.adaptLinearExpression(commutativeBinaryRelationalExpression.getLeftArgument()) + " " + this.relationalOperatorToString(this.mapOperatorToGecode(commutativeBinaryRelationalExpression.getOperator())) + " " + this.adaptLinearExpression(commutativeBinaryRelationalExpression.getRightArgument());
        }
        if (expression instanceof NonCommutativeRelationalBinaryExpression) {
            NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression = (NonCommutativeRelationalBinaryExpression)expression;
            return this.adaptLinearExpression(nonCommutativeRelationalBinaryExpression.getLeftArgument()) + " " + this.relationalOperatorToString(this.mapOperatorToGecode(nonCommutativeRelationalBinaryExpression.getOperator())) + " " + this.adaptLinearExpression(nonCommutativeRelationalBinaryExpression.getRightArgument());
        }
        if (expression instanceof Sum) {
            int n;
            StringBuffer stringBuffer = new StringBuffer("");
            Sum sum = (Sum)expression;
            ArrayList<Expression> arrayList = sum.getPositiveArguments();
            for (n = 0; n < arrayList.size(); ++n) {
                if (n > 0) {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append(this.adaptLinearExpression(arrayList.get(n)));
            }
            arrayList = sum.getNegativeArguments();
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuffer.append("-" + this.adaptLinearExpression(arrayList.get(n)));
            }
            return stringBuffer.toString();
        }
        if (expression instanceof Multiplication) {
            ArrayList<Expression> arrayList = ((Multiplication)expression).getArguments();
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append("*");
                }
                stringBuffer.append(this.adaptLinearExpression(arrayList.get(i)));
            }
            return stringBuffer.toString();
        }
        if (expression instanceof ProductConstraint) {
            ProductConstraint productConstraint = (ProductConstraint)expression;
            Expression[] expressionArray = productConstraint.getArguments();
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < expressionArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("*");
                }
                stringBuffer.append(this.adaptLinearExpression(expressionArray[i]));
            }
            stringBuffer.append(" == " + this.adaptLinearExpression(productConstraint.getResult()));
            return stringBuffer.toString();
        }
        throw new GecodeException("Cannot tailor linear expression " + expression + " of type " + expression.getClass().getSimpleName() + " yet, sorry.");
    }

    public char invertRelationalGecodeOperator(char c) throws GecodeException {
        if (c == '\n') {
            return '\u000b';
        }
        if (c == '\u000e') {
            return '\r';
        }
        if (c == '\f') {
            return '\u000f';
        }
        if (c == '\r') {
            return '\u000e';
        }
        if (c == '\u000f') {
            return '\f';
        }
        if (c == '\u000b') {
            return '\n';
        }
        throw new GecodeException("Internal error. Cannot convert unknown operator: " + c + ".");
    }

    private boolean isCommutativeOperator(char c) throws GecodeException {
        if (c == '\n') {
            return true;
        }
        if (c == '\u000e') {
            return false;
        }
        if (c == '\f') {
            return false;
        }
        if (c == '\r') {
            return false;
        }
        if (c == '\u000f') {
            return false;
        }
        if (c == '\u000b') {
            return true;
        }
        throw new GecodeException("Internal error. Cannot convert unknown operator: " + c + ".");
    }

    private String relationalOperatorToString(int n) throws GecodeException {
        if (n == 10) {
            return "==";
        }
        if (n == 14) {
            return ">=";
        }
        if (n == 12) {
            return "<=";
        }
        if (n == 13) {
            return "<";
        }
        if (n == 15) {
            return ">";
        }
        if (n == 11) {
            return "!=";
        }
        throw new GecodeException("Internal error. Cannot convert unknown operator: " + n + ".");
    }

    private void addArgumentToMap(GecodeAtom[] gecodeAtomArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < gecodeAtomArray.length; ++i) {
            stringBuffer.append(" " + gecodeAtomArray[i] + " ");
        }
        this.argVarNamesMap.put(stringBuffer.toString(), string);
    }

    private void addWeightArgumentToMap(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(" " + nArray[i] + " ");
        }
        this.argWeightsNamesMap.put(stringBuffer.toString(), string);
        this.argWeightsMap.put(string, nArray);
        this.constArgumentList.add(string);
    }

    private void addConstantArgumentToMap(int n) {
        if (!this.constantList.contains(new ArithmeticAtomExpression(n))) {
            this.constantList.add(new ArithmeticAtomExpression(n));
        }
        this.constantNamesMap.put(new ArithmeticAtomExpression(n), this.computeConstantName(new ArithmeticAtomExpression(n)));
    }

    private void addConstantArgumentToMap(Expression expression) {
        if (!this.constantList.contains(expression)) {
            this.constantList.add(expression);
        }
        this.constantNamesMap.put(expression, this.computeConstantName(expression));
    }

    private boolean isPreviouslyDefinedArgument(GecodeAtom[] gecodeAtomArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < gecodeAtomArray.length; ++i) {
            stringBuffer.append(" " + gecodeAtomArray[i] + " ");
        }
        return this.argVarNamesMap.containsKey(stringBuffer.toString());
    }

    private boolean isPreviouslyDefinedWeight(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(" " + nArray[i] + " ");
        }
        return this.argWeightsNamesMap.containsKey(stringBuffer.toString());
    }

    private String getPreviouslyDefinedArgument(GecodeAtom[] gecodeAtomArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < gecodeAtomArray.length; ++i) {
            stringBuffer.append(" " + gecodeAtomArray[i] + " ");
        }
        return this.argVarNamesMap.get(stringBuffer.toString());
    }

    private String getPreviouslyDefinedWeight(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(" " + nArray[i] + " ");
        }
        ++this.noReusedConstArguments;
        return this.argWeightsNamesMap.get(stringBuffer.toString());
    }

    private String computeConstantName(Expression expression) {
        StringBuffer stringBuffer = new StringBuffer(((Object)expression).toString());
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '-' || stringBuffer.charAt(i) == '[' || stringBuffer.charAt(i) == ']' || stringBuffer.charAt(i) == '(' || stringBuffer.charAt(i) == ')') {
                stringBuffer.replace(i, i + 1, "_");
                continue;
            }
            if (stringBuffer.charAt(i) == '*') {
                stringBuffer.replace(i, i + 1, "_m_");
                continue;
            }
            if (stringBuffer.charAt(i) == '+') {
                stringBuffer.replace(i, i + 1, "_a_");
                continue;
            }
            if (stringBuffer.charAt(i) != ' ' && stringBuffer.charAt(i) != ',') continue;
            stringBuffer.deleteCharAt(i);
            --i;
        }
        if (stringBuffer.length() > 20) {
            return "int_" + stringBuffer.toString().substring(stringBuffer.length() - 20);
        }
        return "int_" + stringBuffer.toString();
    }
}

