/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.Multiplication;
import translator.expression.Sum;
import translator.solver.Gecode;
import translator.tailor.gecode.ArgsArrayVariable;
import translator.tailor.gecode.GecodeArray;
import translator.tailor.gecode.GecodeArrayVariable;
import translator.tailor.gecode.GecodeAtom;
import translator.tailor.gecode.GecodeBoolVar;
import translator.tailor.gecode.GecodeBoolVarArgs;
import translator.tailor.gecode.GecodeBoolVarArray;
import translator.tailor.gecode.GecodeConstraint;
import translator.tailor.gecode.GecodeException;
import translator.tailor.gecode.GecodeForall;
import translator.tailor.gecode.GecodeIf;
import translator.tailor.gecode.GecodeIntArray;
import translator.tailor.gecode.GecodeIntVar;
import translator.tailor.gecode.GecodeIntVarArgs;
import translator.tailor.gecode.GecodeIntVarArray;
import translator.tailor.gecode.GecodeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GecodeModel {
    public final int DEFAULT_PARAMETER_VALUE = 4;
    private ArrayList<GecodeArrayVariable> variableList;
    private ArrayList<GecodeArrayVariable> bufferArrays;
    private ArrayList<GecodeArrayVariable> multiDimensionalArrays;
    private ArrayList<ArgsArrayVariable> auxBufferArrays;
    private ArrayList<GecodeIntVar> singleIntVarNames;
    private ArrayList<GecodeBoolVar> singleBoolVarNames;
    private ArrayList<GecodeIntVar> auxIntVarNames;
    private ArrayList<GecodeBoolVar> auxBoolVarNames;
    private ArrayList<String> declaredPartialArrayNames;
    private ArrayList<GecodeArray> auxArrayList;
    private ArrayList<String> undefinedParameters;
    private ArrayList<Expression> constantList;
    private ArrayList<String> constArgumentList;
    protected int noReusedConstArguments = 0;
    private int noReusedConstants = 0;
    private HashMap<String, int[]> argWeightsMap;
    private HashMap<Expression, String> constantNamesMap;
    private GecodeAtom objective;
    private boolean isMinimising;
    private HashMap<GecodeVariable, Domain> variableDomains = new HashMap();
    private ArrayList<GecodeConstraint> constraints;
    private TranslationSettings settings;
    private String modelName;
    private int solutionBreak = 10;
    private int commonSubexpressions = 0;
    private Expression commonQuantifiedSubexpressions;

    public GecodeModel(TranslationSettings translationSettings, ArrayList<GecodeArrayVariable> arrayList, ArrayList<GecodeArrayVariable> arrayList2, ArrayList<GecodeConstraint> arrayList3, ArrayList<GecodeIntVar> arrayList4, ArrayList<GecodeBoolVar> arrayList5, ArrayList<ArgsArrayVariable> arrayList6, ArrayList<GecodeIntVar> arrayList7, ArrayList<GecodeBoolVar> arrayList8, ArrayList<GecodeArrayVariable> arrayList9, ArrayList<String> arrayList10, ArrayList<Expression> arrayList11, ArrayList<String> arrayList12, HashMap<String, int[]> hashMap, HashMap<Expression, String> hashMap2, ArrayList<GecodeArray> arrayList13) {
        this.settings = translationSettings;
        this.variableList = arrayList;
        this.constraints = arrayList3;
        this.undefinedParameters = arrayList10;
        this.constantList = this.removeDuplicates(arrayList11);
        this.constArgumentList = arrayList12;
        this.argWeightsMap = hashMap;
        this.constantNamesMap = hashMap2;
        this.auxArrayList = arrayList13;
        this.modelName = translationSettings.getModelName();
        String string = this.modelName.substring(0, 1);
        this.modelName = this.modelName.substring(1, this.modelName.length());
        string = string.toUpperCase();
        this.modelName = string + this.modelName;
        StringBuffer stringBuffer = new StringBuffer(this.modelName);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '[' || stringBuffer.charAt(i) == ']' || stringBuffer.charAt(i) == '(' || stringBuffer.charAt(i) == '-' || stringBuffer.charAt(i) == ')') {
                stringBuffer.replace(i, i + 1, "_");
                continue;
            }
            if (stringBuffer.charAt(i) != ',') continue;
            stringBuffer.deleteCharAt(i);
        }
        this.modelName = stringBuffer.toString();
        this.bufferArrays = arrayList2;
        this.singleIntVarNames = arrayList4;
        this.singleBoolVarNames = arrayList5;
        this.multiDimensionalArrays = arrayList9;
        this.declaredPartialArrayNames = new ArrayList();
        this.auxBufferArrays = arrayList6;
        this.auxBoolVarNames = arrayList8;
        this.auxIntVarNames = arrayList7;
    }

    public ArrayList<GecodeArrayVariable> getDecisionVariables() {
        return this.variableList;
    }

    public Domain getDomainOfVariable(GecodeVariable gecodeVariable) throws GecodeException {
        Domain domain = this.variableDomains.get(gecodeVariable);
        if (domain == null) {
            throw new GecodeException("Internal error. Trying to get domain of unknown variable:" + gecodeVariable);
        }
        return domain;
    }

    public void setObjective(GecodeAtom gecodeAtom) {
        this.objective = gecodeAtom;
    }

    public void setIsMinimisingObjective(boolean bl) {
        this.isMinimising = bl;
    }

    public String toSimpleString() {
        StringBuffer stringBuffer = new StringBuffer("#include \"examples/support.hh\"\n#include \"gecode/minimodel.hh\"\n\n");
        stringBuffer.append("\n\nConstraints: " + this.constraints);
        stringBuffer.append("\n\n1-dim. array-Variables: " + this.variableList);
        stringBuffer.append("\n\nBuffered variables: " + this.bufferArrays);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("/** \n *  " + this.settings.OUTPUTFILE_HEADER + "\n *  " + this.settings.OUTPUTFILE_HEADER_BUGS + " \n *\n");
        if (this.settings.giveTranslationInfo()) {
            stringBuffer.append(" *  Model statistics:\n");
            stringBuffer.append(" *    propagators: " + this.constraints.size() + "\n");
            if (this.auxArrayList.size() > 0) {
                Expression[] expressionArray = new Expression[this.auxArrayList.size()];
                for (int i = 0; i < this.auxArrayList.size(); ++i) {
                    if (this.auxArrayList.get(i) instanceof GecodeIntVarArray) {
                        expressionArray[i] = ((GecodeIntVarArray)this.auxArrayList.get(i)).getDefinedLength();
                        continue;
                    }
                    if (this.auxArrayList.get(i) instanceof GecodeBoolVarArray) {
                        expressionArray[i] = ((GecodeBoolVarArray)this.auxArrayList.get(i)).getDefinedLength();
                        continue;
                    }
                    System.out.println("Don't know what kind of array " + this.auxArrayList.get(i) + " is: " + this.auxArrayList.get(i).getClass().getSimpleName());
                }
                stringBuffer.append(" *    auxiliary array variables: " + new Sum(expressionArray, new Expression[0]).evaluate());
                stringBuffer.append("\n");
            }
            if (this.auxBoolVarNames.size() + this.auxIntVarNames.size() > 0) {
                stringBuffer.append(" *    auxiliary variables: " + (this.auxBoolVarNames.size() + this.auxIntVarNames.size()) + "\n");
            }
            if (this.commonSubexpressions > 0) {
                stringBuffer.append(" *    eliminated common subexpressions: " + this.commonSubexpressions + "\n");
            }
            if (this.commonQuantifiedSubexpressions != null) {
                stringBuffer.append(" *    eliminated common subexpressions: " + this.commonQuantifiedSubexpressions.reduceExpressionTree().evaluate() + "\n");
            }
        }
        stringBuffer.append(" */\n\n");
        stringBuffer.append("#include \"examples/support.hh\"\n#include \"gecode/minimodel.hh\"\n\n");
        stringBuffer.append("\n/* for debugging */\n// #include <iostream>\n// using namespace std;\n\n\n");
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append(this.parameterClassDeclarationToString() + "\n\n");
        }
        stringBuffer.append(this.modelClassToString() + "\n\n");
        stringBuffer.append(this.mainFunctionToString());
        return stringBuffer.toString();
    }

    private String mainFunctionToString() {
        StringBuffer stringBuffer = new StringBuffer("int\nmain(int argc, char* argv[]) {\n");
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append("   " + this.modelName + "Options opt(\"" + this.modelName + "\", ");
            for (int i = 0; i < this.undefinedParameters.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.DEFAULT_PARAMETER_VALUE + i);
            }
            stringBuffer.append("); // default parameter value(s) (random)  \n");
        } else {
            stringBuffer.append("   Options opt(\"" + this.modelName + "\");\n");
        }
        stringBuffer.append("   opt.solutions(" + this.settings.getNoOfSolutions() + ");\n");
        stringBuffer.append("   opt.parse(argc, argv);\n");
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append("   Example::run<" + this.modelName + ", " + (this.objective != null ? "BAB" : "DFS") + ", " + this.modelName + "Options>(opt);\n");
        } else {
            stringBuffer.append("   Example::run<" + this.modelName + ", " + (this.objective != null ? "BAB" : "DFS") + ", Options>(opt);\n");
        }
        stringBuffer.append("   return 0;\n}\n\n");
        return stringBuffer.toString();
    }

    private String modelClassToString() {
        StringBuffer stringBuffer = new StringBuffer("/* ************************************* \n * " + this.modelName + " problem class\n *\n * ************************************* */\n");
        stringBuffer.append("class " + this.modelName + " : public Example {\n\n");
        stringBuffer.append("protected:\n");
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append(this.parameterDeclarationToString());
        }
        stringBuffer.append("  // variables:\n" + this.variableDeclarationToString() + "\n");
        stringBuffer.append("public: \n\n");
        stringBuffer.append(this.multiDimensionalFunctionsToString());
        stringBuffer.append(this.actualProblemConstructorToString() + "\n");
        if (this.objective != null) {
            stringBuffer.append(this.objectiveToString() + "\n");
        }
        stringBuffer.append(this.printingMethodToString() + "\n\n");
        stringBuffer.append(this.copyMethodToString());
        stringBuffer.append("\n\n");
        stringBuffer.append(this.cloningConstructorToString());
        stringBuffer.append("\n};\n");
        return stringBuffer.toString();
    }

    private String parameterDeclarationToString() {
        StringBuffer stringBuffer = new StringBuffer("  // parameter declaration\n");
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append("   int ");
            for (int i = 0; i < this.undefinedParameters.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.undefinedParameters.get(i));
            }
            stringBuffer.append("; \n");
        }
        return stringBuffer.toString();
    }

    private String actualProblemConstructorToString() {
        StringBuffer stringBuffer = new StringBuffer("   // actual problem\n   " + this.modelName);
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append("(const " + this.modelName + "Options& opt) : ");
        } else {
            stringBuffer.append("(const Options& opt) : ");
        }
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append(this.parameterInitialisationToString() + ",\n\t\t\t\t\t\t");
        }
        stringBuffer.append(this.variableInitialisationToString());
        stringBuffer.append(" {\n\n");
        stringBuffer.append(this.constantDeclarationToString());
        stringBuffer.append(this.bufferArraysDeclaration() + "\n");
        stringBuffer.append(this.constraintsToString() + "\n");
        stringBuffer.append(this.branchingToString() + "\n");
        stringBuffer.append("   }\n\n");
        return stringBuffer.toString();
    }

    private String constantDeclarationToString() {
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.constantList.size() > 0) {
            stringBuffer.append("       /* defining constants */\n");
            for (n = 0; n < this.constantList.size(); ++n) {
                object2 = this.constantList.get(n);
                object = this.constantNamesMap.get(object2);
                stringBuffer.append("\tIntVar " + (String)object + "(this, " + object2 + ", " + object2 + ");\n");
            }
        }
        if (this.constArgumentList.size() > 0) {
            for (n = 0; n < this.constArgumentList.size(); ++n) {
                object2 = this.constArgumentList.get(n);
                object = this.argWeightsMap.get(object2);
                stringBuffer.append("\tIntArgs " + (String)object2 + "(" + ((Object)object).length + ");\n");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    stringBuffer.append("\t  " + (String)object2 + "[" + i + "] = " + (int)object[i] + ";\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    private String parameterInitialisationToString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.undefinedParameters.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",\n\t\t\t\t\t\t");
            }
            stringBuffer.append(this.undefinedParameters.get(i) + "(opt." + this.undefinedParameters.get(i) + ")");
        }
        return stringBuffer.toString();
    }

    private String variableDeclarationToString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        for (n = 0; n < this.variableList.size(); ++n) {
            stringBuffer.append("   " + this.variableList.get(n).toDeclarationCCString() + ";\n");
        }
        for (n = 0; n < this.multiDimensionalArrays.size(); ++n) {
            stringBuffer.append("   " + this.multiDimensionalArrays.get(n).toDeclarationCCString() + ";\n");
        }
        for (n = 0; n < this.bufferArrays.size(); ++n) {
            stringBuffer.append("   " + this.bufferArrays.get(n).toDeclarationCCString() + ";\n");
        }
        return stringBuffer.toString();
    }

    private String parameterClassDeclarationToString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("/* ************************************* \n * Options class for parameters\n *\n * ************************************* */\n");
        stringBuffer.append("class " + this.modelName + "Options : public Options {\npublic:\n");
        stringBuffer.append("   // parameters to be given on command line\n   int ");
        for (n = 0; n < this.undefinedParameters.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.undefinedParameters.get(n));
        }
        stringBuffer.append("; \n\n");
        stringBuffer.append("  // initialise options\n");
        stringBuffer.append("   " + this.modelName + "Options(const char* s, ");
        for (n = 0; n < this.undefinedParameters.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("int " + this.undefinedParameters.get(n) + "0");
        }
        stringBuffer.append(")\n     : Options(s), ");
        for (n = 0; n < this.undefinedParameters.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.undefinedParameters.get(n) + "(" + this.undefinedParameters.get(n) + "0)");
        }
        stringBuffer.append("{}\n\n");
        stringBuffer.append("\n  // parsing the parameter arguments \n");
        stringBuffer.append("  void parse(int& argc, char* argv[]) {\n");
        stringBuffer.append("    Options::parse(argc,argv);\n");
        stringBuffer.append("    if (argc < " + (this.undefinedParameters.size() + 1) + ") {\n");
        stringBuffer.append("      std::cerr << \"Expected " + this.undefinedParameters.size() + " parameter arguments, but only got \"" + "<< (argc-1) << \" arguments.\\n" + "Expected parameters are (ordered):\\n");
        for (n = 0; n < this.undefinedParameters.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.undefinedParameters.get(n));
        }
        stringBuffer.append("\\n");
        stringBuffer.append("Will use the default value of each parameter.\" << std::endl;\n");
        stringBuffer.append("      return;\n    }\n");
        for (n = 0; n < this.undefinedParameters.size(); ++n) {
            stringBuffer.append("    " + this.undefinedParameters.get(n) + " = atoi(argv[" + (n + 1) + "]);\n");
        }
        stringBuffer.append("  }\n\n");
        stringBuffer.append("  // help message \n");
        stringBuffer.append("  virtual void help(void) {\n");
        stringBuffer.append("    Options::help();\n");
        for (n = 0; n < this.undefinedParameters.size(); ++n) {
            stringBuffer.append("    std::cerr << \"\\tparameter " + this.undefinedParameters.get(n) + " (default value = " + (this.DEFAULT_PARAMETER_VALUE + n) + ") \" << std::endl;\n");
        }
        stringBuffer.append("  }\n");
        stringBuffer.append("};\n\n");
        return stringBuffer.toString();
    }

    private String auxVariableDeclarationToString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.auxBufferArrays.size() > 0) {
            stringBuffer.append("      // defining the ArgsVarArrays that hold the aux variables\n");
        }
        for (n = 0; n < this.auxBufferArrays.size(); ++n) {
            stringBuffer.append("\t" + this.auxBufferArrays.get(n).toDeclarationCCString() + ";\n");
        }
        if (this.auxArrayList.size() > 0) {
            stringBuffer.append("      // Declaring auxiliary arrays \n");
        }
        for (n = 0; n < this.auxArrayList.size(); ++n) {
            if (!(this.auxArrayList.get(n) instanceof GecodeIntArray)) continue;
            GecodeIntArray gecodeIntArray = (GecodeIntArray)this.auxArrayList.get(n);
            Expression expression = gecodeIntArray.getDefinedBounds()[0].evaluate();
            Expression expression2 = gecodeIntArray.getDefinedBounds()[1].evaluate();
            if (expression.getType() == 3 && expression2.getType() == 3) {
                if (((ArithmeticAtomExpression)expression).getConstant() == 0 && ((ArithmeticAtomExpression)expression2).getConstant() == 1) {
                    stringBuffer.append("\tBoolVarArray " + ((GecodeIntVarArray)gecodeIntArray).getName());
                }
            } else {
                stringBuffer.append("\t" + gecodeIntArray.toDeclarationCCString());
            }
            try {
                stringBuffer.append("(this, " + gecodeIntArray.getDefinedLength() + ", " + gecodeIntArray.getDefinedBounds()[0].toSolverExpression(this.settings.getTargetSolver()) + ", " + gecodeIntArray.getDefinedBounds()[1].toSolverExpression(this.settings.getTargetSolver()) + ");\n");
                continue;
            }
            catch (Exception exception) {
                System.out.println("Could not print the bounds of array because of exception: " + exception.getMessage() + "\n types: lb:" + gecodeIntArray.getDefinedBounds()[0].getClass().getSimpleName() + " and ub:" + gecodeIntArray.getDefinedBounds()[1].getClass().getSimpleName());
            }
        }
        return stringBuffer.toString();
    }

    private String objectiveToString() {
        StringBuffer stringBuffer = new StringBuffer("   // Method to state the objective\n   void\n   constrain(Space* s) {\n");
        stringBuffer.append("\trel(this, " + this.objective + ", " + (this.isMinimising ? "IRT_LE" : "IRT_GR") + ", static_cast<" + this.modelName + "*>(s)->" + this.objective + ".val());\n   }\n");
        return stringBuffer.toString();
    }

    private String copyMethodToString() {
        StringBuffer stringBuffer = new StringBuffer("   // copy during cloning\n   virtual Space*\n   copy(bool share) {\n");
        stringBuffer.append("\treturn new " + this.modelName + "(share, *this);\n");
        stringBuffer.append("   }\n");
        return stringBuffer.toString();
    }

    private String cloningConstructorToString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("   // constructor for cloning\n   " + this.modelName + "(bool share, " + this.modelName + "& s) : Example(share,s)");
        if (this.undefinedParameters.size() > 0) {
            stringBuffer.append(", ");
            for (n = 0; n < this.undefinedParameters.size(); ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.undefinedParameters.get(n) + "(s." + this.undefinedParameters.get(n) + ")");
            }
        }
        stringBuffer.append("{\n");
        for (n = 0; n < this.variableList.size(); ++n) {
            stringBuffer.append("\t" + this.variableList.get(n) + ".update(this, share, s." + this.variableList.get(n) + ");\n");
        }
        for (n = 0; n < this.multiDimensionalArrays.size(); ++n) {
            stringBuffer.append("\t" + this.multiDimensionalArrays.get(n) + ".update(this, share, s." + this.multiDimensionalArrays.get(n) + ");\n");
        }
        for (n = 0; n < this.bufferArrays.size(); ++n) {
            stringBuffer.append("\t" + this.bufferArrays.get(n) + ".update(this, share, s." + this.bufferArrays.get(n) + ");\n");
        }
        stringBuffer.append("\n   }\n");
        return stringBuffer.toString();
    }

    private String printingMethodToString() {
        GecodeArrayVariable gecodeArrayVariable;
        int n;
        StringBuffer stringBuffer = new StringBuffer("   // method for printing solutions\n");
        String string = "os";
        stringBuffer.append("   virtual void print(std::ostream& " + string + ") {\n\t" + string + " << \"\\n\";\n");
        for (n = 0; n < this.variableList.size(); ++n) {
            gecodeArrayVariable = this.variableList.get(n);
            stringBuffer.append("\t" + string + "  << \" " + gecodeArrayVariable.getVariableName() + ":\" << std::endl;\n");
            if (this.settings.isClassLevelTransformation()) {
                stringBuffer.append("\tfor(int i=0; i<" + gecodeArrayVariable.getDefinedLength() + "; i++) {\n");
            } else {
                stringBuffer.append("\tfor(int i=0; i<" + gecodeArrayVariable.getLength() + "; i++) {\n");
            }
            stringBuffer.append("\t   " + string + "  << " + gecodeArrayVariable.getVariableName() + "[i] << \",  \";\n");
            stringBuffer.append("\t   if(i % " + this.solutionBreak + " == 0 && i!=0) " + string + " << \"\\n\";\n\t}\n");
            stringBuffer.append("\t" + string + " << std::endl;\n\n");
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.multiDimensionalArrays.size(); ++n) {
            Expression expression;
            gecodeArrayVariable = this.multiDimensionalArrays.get(n);
            Expression[] expressionArray = gecodeArrayVariable.getDefinedLengths();
            if (expressionArray.length == 2) {
                expression = expressionArray[0].copy();
                stringBuffer.append("\t" + string + "  << \" " + gecodeArrayVariable.getVariableName() + ":\" << std::endl;\n");
                if (this.settings.isClassLevelTransformation()) {
                    stringBuffer.append("\tfor(int i=0; i<" + gecodeArrayVariable.getDefinedLength() + "; i++) {\n");
                } else {
                    stringBuffer.append("\tfor(int i=0; i<" + gecodeArrayVariable.getLength() + "; i++) {\n");
                }
                stringBuffer.append("\t       " + string + "  << " + gecodeArrayVariable.getVariableName() + "[i] << \",  \";\n");
                stringBuffer.append("\t   if((i+1) % " + expression + " == 0 && i!=0) " + string + " << \"\\n\";\n\t}\n");
                stringBuffer.append("\t" + string + " << std::endl;\n\n");
            }
            if (expressionArray.length != 3) continue;
            expression = expressionArray[1].copy();
            Expression expression2 = new Multiplication(new Expression[]{expressionArray[1].copy(), expressionArray[0].copy()}).evaluate();
            stringBuffer.append("\t" + string + "  << \" " + gecodeArrayVariable.getVariableName() + ":\" << std::endl;\n");
            if (this.settings.isClassLevelTransformation()) {
                stringBuffer.append("\tfor(int i=0; i<" + gecodeArrayVariable.getDefinedLength() + "; i++) {\n");
            } else {
                stringBuffer.append("\tfor(int i=0; i<" + gecodeArrayVariable.getLength() + "; i++) {\n");
            }
            stringBuffer.append("\t       " + string + "  << " + gecodeArrayVariable.getVariableName() + "[i] << \",  \";\n");
            stringBuffer.append("\t   if((i+1) % " + expression + " == 0 && i!=0) " + string + " << \"\\n\";\n\t}\n");
            stringBuffer.append("\t   if((i+1) % " + new Sum(new Expression[]{expression2}, new Expression[]{new ArithmeticAtomExpression(1)}).evaluate() + " == 0 && i!=0) " + string + " << \"\\n\\n\";\n\t}\n");
            stringBuffer.append("\t" + string + " << std::endl;\n\n");
        }
        for (n = 0; n < this.bufferArrays.size(); ++n) {
            gecodeArrayVariable = this.bufferArrays.get(n);
            boolean bl = gecodeArrayVariable instanceof GecodeIntVarArray;
            stringBuffer.append("\t" + string + " << \" Solution: \" ;\n");
            for (int i = 0; i < gecodeArrayVariable.getLength(); ++i) {
                if (bl) {
                    stringBuffer.append("\t" + string + "  << \" " + this.singleIntVarNames.get(i).getVariableName() + "=\"");
                } else {
                    stringBuffer.append("\t" + string + "  << \" " + this.singleBoolVarNames.get(i).getVariableName() + "=\"");
                }
                stringBuffer.append(" << " + gecodeArrayVariable.getVariableName() + "[" + i + "]");
                if (i != gecodeArrayVariable.getLength() - 1) {
                    stringBuffer.append("<< \", \"");
                }
                if (i % this.solutionBreak == 0 && i != 0) {
                    stringBuffer.append("<< \" \\n\\t \"");
                }
                stringBuffer.append(";\n");
            }
        }
        stringBuffer.append("   }\n");
        return stringBuffer.toString();
    }

    private String bufferArraysDeclaration() {
        GecodeArray gecodeArray;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.bufferArrays.size() > 0) {
            stringBuffer.append("      // mapping single variables to the array\n");
        }
        for (n = 0; n < this.bufferArrays.size(); ++n) {
            GecodeVariable gecodeVariable;
            int n2;
            gecodeArray = this.bufferArrays.get(n);
            if (gecodeArray instanceof GecodeIntVarArray) {
                stringBuffer.append("      // defining integer variables\n\tIntVar");
                for (n2 = 0; n2 < gecodeArray.getLength(); ++n2) {
                    gecodeVariable = this.singleIntVarNames.get(n2);
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    if (n2 % 4 == 0) {
                        stringBuffer.append("\n\t ");
                    }
                    if (this.settings.isClassLevelTransformation()) {
                        stringBuffer.append(((GecodeIntVar)gecodeVariable).getVariableName() + "(this, " + ((GecodeIntVar)gecodeVariable).getDefinedBounds()[0] + ", " + ((GecodeIntVar)gecodeVariable).getDefinedBounds()[1] + ")");
                        continue;
                    }
                    stringBuffer.append(((GecodeIntVar)gecodeVariable).getVariableName() + "(this, " + ((GecodeIntVar)gecodeVariable).getBounds()[0] + ", " + ((GecodeIntVar)gecodeVariable).getBounds()[1] + ")");
                }
            } else if (gecodeArray instanceof GecodeBoolVarArray) {
                stringBuffer.append("      // defining boolean variables\n\tBoolVar");
                for (n2 = 0; n2 < gecodeArray.getLength(); ++n2) {
                    gecodeVariable = this.singleBoolVarNames.get(n2);
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    if (n2 % 5 == 0) {
                        stringBuffer.append("\n\t ");
                    }
                    stringBuffer.append(((GecodeBoolVar)gecodeVariable).getVariableName() + "(this, " + ((GecodeBoolVar)gecodeVariable).getBounds()[0] + "," + ((GecodeBoolVar)gecodeVariable).getBounds()[1] + ")");
                }
            }
            stringBuffer.append(";\n\n");
        }
        for (n = 0; n < this.bufferArrays.size(); ++n) {
            int n3;
            String string;
            gecodeArray = this.bufferArrays.get(n);
            stringBuffer.append("      // assigning each variable to a container/buffer\n");
            if (gecodeArray instanceof GecodeIntVarArray) {
                string = gecodeArray.getVariableName();
                for (n3 = 0; n3 < gecodeArray.getLength(); ++n3) {
                    stringBuffer.append("\t" + string + "[" + n3 + "] = " + this.singleIntVarNames.get(n3).getVariableName() + ";\n");
                }
            } else if (gecodeArray instanceof GecodeBoolVarArray) {
                string = gecodeArray.getVariableName();
                for (n3 = 0; n3 < gecodeArray.getLength(); ++n3) {
                    stringBuffer.append("\t" + string + "[" + n3 + "] = " + this.singleBoolVarNames.get(n3).getVariableName() + ";");
                }
            }
            stringBuffer.append("\n");
        }
        if (this.auxBufferArrays.size() == 0 && this.auxArrayList.size() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.auxVariableDeclarationToString());
        stringBuffer.append("\n\n");
        for (n = 0; n < this.auxBufferArrays.size(); ++n) {
            GecodeVariable gecodeVariable;
            int n4;
            gecodeArray = this.auxBufferArrays.get(n);
            if (gecodeArray instanceof GecodeIntVarArgs) {
                stringBuffer.append("      // defining auxiliary integer variables\n\tIntVar");
                for (n4 = 0; n4 < gecodeArray.getLength(); ++n4) {
                    gecodeVariable = this.auxIntVarNames.get(n4);
                    if (n4 > 0) {
                        stringBuffer.append(", ");
                    }
                    if (n4 % 4 == 0) {
                        stringBuffer.append("\n\t ");
                    }
                    if (this.settings.isClassLevelTransformation()) {
                        stringBuffer.append(((GecodeIntVar)gecodeVariable).getVariableName() + "(this, " + ((GecodeIntVar)gecodeVariable).getDefinedBounds()[0] + ", " + ((GecodeIntVar)gecodeVariable).getDefinedBounds()[1] + ")");
                        continue;
                    }
                    stringBuffer.append(((GecodeIntVar)gecodeVariable).getVariableName() + "(this, " + ((GecodeIntVar)gecodeVariable).getBounds()[0] + ", " + ((GecodeIntVar)gecodeVariable).getBounds()[1] + ")");
                }
            } else if (gecodeArray instanceof GecodeBoolVarArgs) {
                stringBuffer.append("      // defining auxiliary boolean variables\n\tBoolVar");
                for (n4 = 0; n4 < gecodeArray.getLength(); ++n4) {
                    gecodeVariable = this.auxBoolVarNames.get(n4);
                    if (n4 > 0) {
                        stringBuffer.append(", ");
                    }
                    if (n4 % 5 == 0) {
                        stringBuffer.append("\n\t ");
                    }
                    stringBuffer.append(((GecodeBoolVar)gecodeVariable).getVariableName() + "(this, " + ((GecodeBoolVar)gecodeVariable).getBounds()[0] + "," + ((GecodeBoolVar)gecodeVariable).getBounds()[1] + ")");
                }
            }
            stringBuffer.append(";\n\n");
        }
        for (n = 0; n < this.auxBufferArrays.size(); ++n) {
            int n5;
            String string;
            gecodeArray = this.auxBufferArrays.get(n);
            stringBuffer.append("      // assigning each auxilary variable to the corresponding container/buffer\n");
            if (gecodeArray instanceof GecodeIntVarArgs) {
                string = gecodeArray.getVariableName();
                for (n5 = 0; n5 < gecodeArray.getLength(); ++n5) {
                    if (n5 != 0 && n5 % 3 == 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("\t" + string + "[" + n5 + "] = " + this.auxIntVarNames.get(n5).getVariableName() + ";");
                }
            } else if (gecodeArray instanceof GecodeBoolVarArgs) {
                string = gecodeArray.getVariableName();
                for (n5 = 0; n5 < gecodeArray.getLength(); ++n5) {
                    if (n5 != 0 && n5 % 3 == 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("\t" + string + "[" + n5 + "] = " + this.auxBoolVarNames.get(n5).getVariableName() + ";");
                }
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    private String branchingToString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = ((Gecode)this.settings.getTargetSolver()).toGecodeVariableBranching(this.settings.getVarBranching());
        String string2 = ((Gecode)this.settings.getTargetSolver()).toGecodeValueBranching(this.settings.getValBranching());
        for (n = 0; n < this.variableList.size(); ++n) {
            stringBuffer.append("\tbranch(this, " + this.variableList.get(n) + ", " + string + ", " + string2 + ");\n");
        }
        for (n = 0; n < this.multiDimensionalArrays.size(); ++n) {
            stringBuffer.append("\tbranch(this, " + this.multiDimensionalArrays.get(n) + ", " + string + ", " + string2 + ");\n");
        }
        for (n = 0; n < this.bufferArrays.size(); ++n) {
            stringBuffer.append("\tbranch(this, " + this.bufferArrays.get(n) + ", " + string + ", " + string2 + ");\n");
        }
        for (n = 0; n < this.auxBufferArrays.size(); ++n) {
            stringBuffer.append("\tbranch(this, " + this.auxBufferArrays.get(n) + ", " + string + ", " + string2 + ");\n");
        }
        return stringBuffer.toString();
    }

    private String variableInitialisationToString() {
        GecodeArrayVariable gecodeArrayVariable;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        for (n = 0; n < this.variableList.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(",\n\t\t\t\t");
            }
            gecodeArrayVariable = this.variableList.get(n);
            if (this.settings.isClassLevelTransformation()) {
                stringBuffer.append("\t" + gecodeArrayVariable + "(this, " + gecodeArrayVariable.getDefinedLength() + ", " + gecodeArrayVariable.getDefinedBounds()[0] + ", " + gecodeArrayVariable.getDefinedBounds()[1] + ")");
                continue;
            }
            stringBuffer.append("\t" + gecodeArrayVariable + "(this, " + gecodeArrayVariable.getLength() + ", " + gecodeArrayVariable.getLowerBound() + ", " + gecodeArrayVariable.getUpperBound() + ")");
        }
        if (this.variableList.size() > 0 && this.multiDimensionalArrays.size() > 0) {
            stringBuffer.append(",\n\t\t\t\t");
        }
        for (n = 0; n < this.multiDimensionalArrays.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(",\n\t\t\t\t");
            }
            gecodeArrayVariable = this.multiDimensionalArrays.get(n);
            if (this.settings.isClassLevelTransformation()) {
                stringBuffer.append("\t" + gecodeArrayVariable + "(this, " + gecodeArrayVariable.getDefinedLength() + ", " + gecodeArrayVariable.getDefinedBounds()[0] + ", " + gecodeArrayVariable.getDefinedBounds()[1] + ")");
                continue;
            }
            stringBuffer.append("\t" + gecodeArrayVariable + "(this, " + gecodeArrayVariable.getLength() + ", " + gecodeArrayVariable.getLowerBound() + ", " + gecodeArrayVariable.getUpperBound() + ")");
        }
        for (n = 0; n < this.bufferArrays.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(",\n\t\t\t\t");
            } else if (this.variableList.size() > 0 || this.multiDimensionalArrays.size() > 0) {
                stringBuffer.append(",\n\t\t\t\t");
            }
            gecodeArrayVariable = this.bufferArrays.get(n);
            if (this.settings.isClassLevelTransformation()) {
                stringBuffer.append("\t" + gecodeArrayVariable + "(this, " + gecodeArrayVariable.getDefinedLength() + ")");
                continue;
            }
            stringBuffer.append("\t" + gecodeArrayVariable + "(this, " + gecodeArrayVariable.getLength() + ")");
        }
        return stringBuffer.toString();
    }

    private String constraintsToString() {
        StringBuffer stringBuffer = new StringBuffer("      /* constraints */\n");
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (this.constraints.get(i) instanceof GecodeForall || this.constraints.get(i) instanceof GecodeIf) {
                stringBuffer.append("\t" + this.constraints.get(i) + "\n");
                continue;
            }
            stringBuffer.append("\t" + this.constraints.get(i) + ";\n");
        }
        return stringBuffer.toString();
    }

    private String multiDimensionalFunctionsToString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.multiDimensionalArrays.size() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("   ");
        for (int i = 0; i < this.multiDimensionalArrays.size(); ++i) {
            String string;
            Object[] objectArray;
            GecodeArrayVariable gecodeArrayVariable = this.multiDimensionalArrays.get(i);
            String string2 = gecodeArrayVariable.getVariableName();
            string2 = string2.substring("_".length(), string2.length());
            if (this.settings.isClassLevelTransformation()) {
                objectArray = gecodeArrayVariable.getDefinedLengths();
                stringBuffer.append("// Defining method to access multi-dimensional array " + string2 + " \n");
                if (objectArray.length == 2) {
                    string = gecodeArrayVariable instanceof GecodeIntVarArray ? "IntVar" : "BoolVar";
                    stringBuffer.append("   " + string + "& " + string2 + "(int row, int col) {\n");
                    stringBuffer.append("\tif(row < 0 || row >= " + objectArray[0] + ")\n\t   std::cerr << \"Row index of " + string2 + "[\" << row << \",\" << col << \"] out of bounds:\" << row << std::endl;\n");
                    stringBuffer.append("\tif(col < 0 || col >= " + objectArray[1] + ")\n\t   std::cerr << \"Column index of " + string2 + "[\" << row << \",\" << col << \"]  out of bounds:\" << col << std::endl;\n");
                    stringBuffer.append("\treturn " + gecodeArrayVariable.getVariableName() + "[row*(" + objectArray[1] + ") + col];\n");
                    stringBuffer.append("   }\n\n");
                }
                if (objectArray.length != 3) continue;
                string = gecodeArrayVariable instanceof GecodeIntVarArray ? "IntVar" : "BoolVar";
                stringBuffer.append("   " + string + "& " + string2 + "(int plane, int row, int col) {\n");
                stringBuffer.append("\tif(plane < 0 || plane >= " + objectArray[0] + ")\n\t   std::cerr << \"Plane index of " + string2 + "[\" << plane << \",\" << row << \",\" << col << \"]  out of bounds:\" << plane << std::endl;\n");
                stringBuffer.append("\tif(row < 0 || row >= " + objectArray[1] + ")\n\t   std::cerr << \"Row index of " + string2 + "[\" << plane << \",\" << row << \",\" << col << \"] out of bounds:\" << row << std::endl;\n");
                stringBuffer.append("\tif(col < 0 || col >= " + objectArray[2] + ")\n\t   std::cerr << \"Column index of " + string2 + "[\" << plane << \",\" << row << \",\" << col << \"]  out of bounds:\" << col << std::endl;\n");
                stringBuffer.append("\treturn " + gecodeArrayVariable.getVariableName() + "[plane*(" + objectArray[1] + ")*(" + objectArray[2] + ") + row*(" + objectArray[2] + ") + col];\n");
                stringBuffer.append("   }\n\n");
                continue;
            }
            objectArray = gecodeArrayVariable.getLengths();
            stringBuffer.append("// Defining method to access multi-dimensional array " + string2 + " \n");
            if (objectArray.length == 2) {
                string = gecodeArrayVariable instanceof GecodeIntVarArray ? "IntVar" : "BoolVar";
                stringBuffer.append("   " + string + "& " + string2 + "(int row, int col) {\n");
                stringBuffer.append("\tif(row < 0 || row >= " + (int)objectArray[0] + ")\n\t   std::cerr << \"Row index of " + string2 + "[\" << row << \",\" << col << \"] out of bounds:\" << row << std::endl;\n");
                stringBuffer.append("\tif(col < 0 || col >= " + (int)objectArray[1] + ")\n\t   std::cerr << \"Column index of " + string2 + "[\" << row << \",\" << col << \"]  out of bounds:\" << col << std::endl;\n");
                stringBuffer.append("\treturn " + gecodeArrayVariable.getVariableName() + "[row*" + (int)objectArray[1] + " + col];\n");
                stringBuffer.append("   }\n\n");
            }
            if (objectArray.length != 3) continue;
            string = gecodeArrayVariable instanceof GecodeIntVarArray ? "IntVar" : "BoolVar";
            stringBuffer.append("   " + string + "& " + string2 + "(int plane, int row, int col) {\n");
            stringBuffer.append("\tif(plane < 0 || plane >= " + (int)objectArray[0] + ")\n\t   std::cerr << \"Plane index of " + string2 + "[\" << plane << \",\" << row << \",\" << col << \"]  out of bounds:\" << plane << std::endl;\n");
            stringBuffer.append("\tif(row < 0 || row >= " + (int)objectArray[1] + ")\n\t   std::cerr << \"Row index of " + string2 + "[\" << plane << \",\" << row << \",\" << col << \"] out of bounds:\" << row << std::endl;\n");
            stringBuffer.append("\tif(col < 0 || col >= " + (int)objectArray[2] + ")\n\t   std::cerr << \"Column index of " + string2 + "[\" << plane << \",\" << row << \",\" << col << \"]  out of bounds:\" << col << std::endl;\n");
            stringBuffer.append("\treturn " + gecodeArrayVariable.getVariableName() + "[plane*" + (int)objectArray[1] + "*" + (int)objectArray[2] + " + row*" + (int)objectArray[2] + " + col];\n");
            stringBuffer.append("   }\n\n");
        }
        return stringBuffer.toString();
    }

    private ArrayList<Expression> removeDuplicates(ArrayList<Expression> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Expression expression = arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                if (!((Object)expression).toString().equals(((Object)arrayList.get(j)).toString())) continue;
                arrayList.remove(j);
            }
        }
        return arrayList;
    }

    public void setCommonSubexpressions(int n) {
        this.commonSubexpressions = n;
    }

    public void setCommonQuantifiedSubexpressions(Expression expression) {
        this.commonQuantifiedSubexpressions = expression;
    }
}

