/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import translator.tailor.gecode.ArgsArrayVariable;
import translator.tailor.gecode.ConstantArgsArray;
import translator.tailor.gecode.GecodeAtom;
import translator.tailor.gecode.GecodeConstant;
import translator.tailor.gecode.GecodeVariable;
import translator.tailor.gecode.IntegerVariable;
import translator.tailor.gecode.RelationalConstraint;

public class GecodeLinear
extends RelationalConstraint {
    private ArgsArrayVariable variableArray;
    private GecodeAtom[] variables;
    private int[] weights;
    private String argVarName;
    private String weightsArgsName;
    private ConstantArgsArray constantArray;
    private char relation;
    private GecodeAtom result;
    private GecodeAtom reifiedVar;
    private boolean argIsAlreadydefined = false;

    public GecodeLinear(GecodeAtom[] gecodeAtomArray, char c, GecodeConstant gecodeConstant) {
        this.variables = gecodeAtomArray;
        this.relation = c;
        this.result = gecodeConstant;
        this.argVarName = this.computeArgsArrayName();
        this.isReifiable = true;
        this.supportedConsistencyLevels = new char[]{'\u0001', '\u0002'};
    }

    public GecodeLinear(GecodeAtom[] gecodeAtomArray, char c, GecodeAtom gecodeAtom) {
        this.variables = gecodeAtomArray;
        this.relation = c;
        this.result = gecodeAtom;
        this.argVarName = this.computeArgsArrayName();
        this.isReifiable = true;
        this.supportedConsistencyLevels = new char[]{'\u0001', '\u0002'};
    }

    public GecodeLinear(GecodeAtom[] gecodeAtomArray, char c, GecodeAtom gecodeAtom, GecodeAtom gecodeAtom2) {
        this.variables = gecodeAtomArray;
        this.relation = c;
        this.result = gecodeAtom;
        this.reifiedVar = gecodeAtom2;
        this.argVarName = this.computeArgsArrayName();
        this.isReifiable = true;
        this.supportedConsistencyLevels = new char[]{'\u0001', '\u0002'};
    }

    public GecodeLinear(GecodeAtom[] gecodeAtomArray, int[] nArray, char c, GecodeConstant gecodeConstant) {
        this.variables = gecodeAtomArray;
        this.weights = nArray;
        this.relation = c;
        this.result = gecodeConstant;
        this.argVarName = this.computeArgsArrayName();
        this.weightsArgsName = this.computeWeightsArgName();
    }

    public GecodeLinear(GecodeAtom[] gecodeAtomArray, int[] nArray, char c, GecodeAtom gecodeAtom) {
        this.variables = gecodeAtomArray;
        this.weights = nArray;
        this.relation = c;
        this.result = gecodeAtom;
        this.argVarName = this.computeArgsArrayName();
        this.weightsArgsName = this.computeWeightsArgName();
    }

    public void setReifiedVariable(GecodeAtom gecodeAtom) {
        this.reifiedVar = gecodeAtom;
    }

    public GecodeAtom getReifiedVar() {
        return this.reifiedVar;
    }

    public void setArgsVarName(String string) {
        this.argVarName = string;
    }

    public String getArgVarName() {
        return this.argVarName;
    }

    public void setWeightsVarName(String string) {
        this.weightsArgsName = string;
    }

    public String getWeightsVarName() {
        return this.weightsArgsName;
    }

    public void setArgIsAlreadyDefined(boolean bl) {
        this.argIsAlreadydefined = bl;
    }

    public boolean getArgIsAlreadyDefined() {
        return this.argIsAlreadydefined;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.variables == null) {
            stringBuffer.append("linear(this, ");
            if (this.constantArray != null) {
                stringBuffer.append(this.constantArray + ", ");
            }
            stringBuffer.append(this.variableArray + ", " + this.operatorToString(this.relation) + ", " + this.result);
        } else {
            if (!this.argIsAlreadydefined) {
                if (this.variables[0] instanceof IntegerVariable || this.variables[0] instanceof GecodeConstant) {
                    stringBuffer.append("IntVarArgs " + this.argVarName + "(" + this.variables.length + ");\n");
                } else {
                    stringBuffer.append("BoolVarArgs " + this.argVarName + "(" + this.variables.length + ");\n");
                }
                for (int i = 0; i < this.variables.length; ++i) {
                    if (this.variables[i] instanceof GecodeConstant) {
                        stringBuffer.append("\t  " + this.argVarName + "[" + i + "] = IntVar(this, " + this.variables[i] + ", " + this.variables[i] + ");\n");
                        continue;
                    }
                    if (this.variables[i] instanceof GecodeVariable) {
                        if (((GecodeVariable)this.variables[i]).isQuantifiedVariable()) {
                            stringBuffer.append("\t  " + this.argVarName + "[" + i + "] = IntVar(this, " + this.variables[i] + ", " + this.variables[i] + ");\n");
                            continue;
                        }
                        if (((GecodeVariable)this.variables[i]).isParameter()) {
                            stringBuffer.append("\t  " + this.argVarName + "[" + i + "] = IntVar(this, " + this.variables[i] + ", " + this.variables[i] + ");\n");
                            continue;
                        }
                        stringBuffer.append("\t  " + this.argVarName + "[" + i + "] = " + this.variables[i] + ";\n");
                        continue;
                    }
                    stringBuffer.append("\t  " + this.argVarName + "[" + i + "] = " + this.variables[i] + ";\n");
                }
            }
            stringBuffer.append("\tlinear(this, " + (this.weights != null ? this.weightsArgsName + ", " : "") + this.argVarName + ", " + this.operatorToString(this.relation) + ", " + this.result);
        }
        if (this.reifiedVar != null) {
            stringBuffer.append(", " + this.reifiedVar);
        }
        if (this.consistencyLevel == '\u0003' && this.propagationKind == '\u001e') {
            stringBuffer.append(")");
        } else {
            stringBuffer.append(", " + this.consistencyToString(this.consistencyLevel) + ", " + this.propagationToString(this.propagationKind) + ")");
        }
        return stringBuffer.toString();
    }

    public String toCCString() {
        return this.toString();
    }

    private String computeArgsArrayName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        for (n = 0; n < this.variables.length; ++n) {
            stringBuffer.append("_" + this.variables[n]);
        }
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (stringBuffer.charAt(n) == ' ' || stringBuffer.charAt(n) == '*' || stringBuffer.charAt(n) == '+' || stringBuffer.charAt(n) == '-' || stringBuffer.charAt(n) == '[' || stringBuffer.charAt(n) == ']' || stringBuffer.charAt(n) == '(' || stringBuffer.charAt(n) == ')') {
                stringBuffer.replace(n, n + 1, "_");
                continue;
            }
            if (stringBuffer.charAt(n) != ',') continue;
            stringBuffer.deleteCharAt(n);
        }
        if (stringBuffer.length() > 23) {
            return "_" + stringBuffer.toString().substring(stringBuffer.length() - 23);
        }
        return stringBuffer.toString();
    }

    private String computeWeightsArgName() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.weights.length; ++i) {
            stringBuffer.append("_" + (this.weights[i] > 0 ? Integer.valueOf(this.weights[i]) : "_" + -this.weights[i]));
        }
        if (stringBuffer.length() > 18) {
            return "_int" + stringBuffer.toString().substring(stringBuffer.length() - 18);
        }
        return "_int" + stringBuffer.toString();
    }
}

