/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.Expression;
import translator.expression.Multiplication;
import translator.tailor.gecode.GecodeIntArray;

public class GecodeIntVarArray
implements GecodeIntArray {
    private String name;
    private int lb;
    private int ub;
    private Expression lbExpr;
    private Expression ubExpr;
    private int[] sparseDomain;
    private int length;
    private Expression lengthExpr;
    private int[] lengths;
    private Expression[] lengthExprs;
    private boolean isParameter = false;
    private boolean isQuantifiedVar = false;

    public GecodeIntVarArray(String string, int n, int n2, int n3) {
        this.name = string;
        this.length = n;
        this.lb = n2;
        this.ub = n3;
        this.lbExpr = new ArithmeticAtomExpression(n2);
        this.ubExpr = new ArithmeticAtomExpression(n3);
        this.lengthExpr = new ArithmeticAtomExpression(n);
    }

    public GecodeIntVarArray(String string, Expression expression, Expression expression2, Expression expression3) {
        this.name = string;
        if (expression.getType() == 3) {
            this.length = ((ArithmeticAtomExpression)expression).getConstant();
        }
        this.lengthExpr = expression.evaluate();
        if (expression2.getType() == 3) {
            this.lb = ((ArithmeticAtomExpression)expression2).getConstant();
        }
        this.lbExpr = expression2;
        if (expression3.getType() == 3) {
            this.ub = ((ArithmeticAtomExpression)expression3).getConstant();
        }
        this.ubExpr = expression3;
    }

    public GecodeIntVarArray(String string, int n, int[] nArray) {
        this.name = string;
        this.length = n;
        this.sparseDomain = nArray;
        this.lb = nArray[0];
        this.ub = nArray[nArray.length - 1];
        this.lbExpr = new ArithmeticAtomExpression(this.lb);
        this.ubExpr = new ArithmeticAtomExpression(this.ub);
        this.lengthExpr = new ArithmeticAtomExpression(n);
    }

    public GecodeIntVarArray(String string, int[] nArray, int n, int n2) {
        int n3;
        this.name = string;
        this.lengths = nArray;
        this.length = 1;
        for (n3 = 0; n3 < this.lengths.length; ++n3) {
            this.length *= nArray[n3];
        }
        this.lb = n;
        this.ub = n2;
        this.lbExpr = new ArithmeticAtomExpression(n);
        this.ubExpr = new ArithmeticAtomExpression(n2);
        this.lengthExpr = new ArithmeticAtomExpression(this.length);
        this.lengthExprs = new Expression[this.lengths.length];
        for (n3 = 0; n3 < this.lengths.length; ++n3) {
            this.lengthExprs[n3] = new ArithmeticAtomExpression(this.lengths[n3]);
        }
    }

    public GecodeIntVarArray(String string, Expression[] expressionArray, Expression expression, Expression expression2) {
        this.name = string;
        this.lengthExprs = expressionArray;
        this.lengthExpr = new Multiplication(this.lengthExprs);
        this.lengthExpr = this.lengthExpr.evaluate();
        if (expression.getType() == 3) {
            this.lb = ((ArithmeticAtomExpression)expression).getConstant();
        }
        this.lbExpr = expression;
        if (expression2.getType() == 3) {
            this.ub = ((ArithmeticAtomExpression)expression2).getConstant();
        }
        this.ubExpr = expression2;
        this.lengths = new int[this.lengthExprs.length];
        for (int i = 0; i < this.lengthExprs.length; ++i) {
            if (this.lengthExprs[i].getType() != 3) continue;
            this.lengths[i] = ((ArithmeticAtomExpression)expressionArray[i]).getConstant();
        }
    }

    public GecodeIntVarArray(String string, int[] nArray, int[] nArray2) {
        this.name = string;
        this.lengths = nArray;
        this.length = 1;
        for (int i = 0; i < this.lengths.length; ++i) {
            this.length *= nArray[i];
        }
        this.lengthExpr = new ArithmeticAtomExpression(this.length);
        this.sparseDomain = nArray2;
        this.lb = nArray2[0];
        this.ub = nArray2[nArray2.length - 1];
        this.lbExpr = new ArithmeticAtomExpression(this.lb);
        this.ubExpr = new ArithmeticAtomExpression(this.ub);
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVar;
    }

    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVar = bl;
    }

    public int getLength() {
        return this.length;
    }

    public Expression getDefinedLength() {
        return this.lengthExpr;
    }

    public int getLowerBound() {
        return this.lb;
    }

    public int getUpperBound() {
        return this.ub;
    }

    public int[] getBounds() {
        return new int[]{this.lb, this.ub};
    }

    public Expression[] getDefinedBounds() {
        return new Expression[]{this.lbExpr, this.ubExpr};
    }

    public char getType() {
        return '\r';
    }

    public String getVariableName() {
        if (this.lengths != null || this.lengthExprs != null) {
            if (this.lengths != null && this.lengths.length == 2 || this.lengthExprs != null && this.lengthExprs.length == 2) {
                return "_" + this.name;
            }
            if (this.lengths != null && this.lengths.length == 3 || this.lengthExprs != null && this.lengthExprs.length == 3) {
                return "__" + this.name;
            }
        }
        return this.name;
    }

    public String toDeclarationCCString() {
        if (this.lengths != null || this.lengthExprs != null) {
            if (this.lengths != null && this.lengths.length == 2 || this.lengthExprs != null && this.lengthExprs.length == 2) {
                return "IntVarArray _" + this.name;
            }
            if (this.lengths != null && this.lengths.length == 3 || this.lengthExprs != null && this.lengthExprs.length == 3) {
                return "IntVarArray __" + this.name;
            }
        }
        return "IntVarArray " + this.name;
    }

    public boolean isArgsVariable() {
        return false;
    }

    public String toString() {
        if (this.lengths != null || this.lengthExprs != null) {
            if (this.lengths != null && this.lengths.length == 2 || this.lengthExprs != null && this.lengthExprs.length == 2) {
                return "_" + this.name;
            }
            if (this.lengths != null && this.lengths.length == 3 || this.lengthExprs != null && this.lengthExprs.length == 3) {
                return "__" + this.name;
            }
        }
        return this.name;
    }

    public void addLowerBound(int n) {
        if (n < this.lb) {
            this.lb = n;
        }
    }

    public void addUpperBound(int n) {
        if (n > this.ub) {
            this.ub = n;
        }
    }

    public void increaseLength() {
        ++this.length;
    }

    public void setLowerBound(int n) {
        this.lb = n;
    }

    public void setUpperBound(int n) {
        this.ub = n;
    }

    public int[] getSparseDomain() {
        return this.sparseDomain;
    }

    public boolean isSparseDomain() {
        return this.sparseDomain != null;
    }

    public boolean isMultiDimensional() {
        return this.lengths != null && this.lengths.length >= 2 || this.lengthExprs != null && this.lengthExprs.length >= 2;
    }

    public int getDimension() {
        if (this.lengths == null && this.lengthExprs == null) {
            return 1;
        }
        return this.lengths.length;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public Expression[] getDefinedLengths() {
        return this.lengthExprs;
    }

    public String getName() {
        return this.name;
    }
}

