/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import java.util.Random;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Expression;
import translator.expression.Multiplication;
import translator.expression.Sum;
import translator.tailor.gecode.ArgsArrayVariable;
import translator.tailor.gecode.IntegerVariable;

public class GecodeIntVarArgs
implements IntegerVariable,
ArgsArrayVariable {
    private String name;
    private int length;
    private int ub;
    private int lb;
    private Expression ubExpr;
    private Expression lbExpr;
    private Expression lengthExpr;
    private int[] indexDomains;
    private int[][] referencedIndices;
    private Expression[] indexDomainExprs;
    private Expression[][] referencedIndicesExpr;
    private String originalName;
    private boolean isParameter = false;
    private boolean isQuantifiedVar = false;

    public GecodeIntVarArgs(String string, int n, int n2, int n3) {
        this.length = n;
        this.lengthExpr = new ArithmeticAtomExpression(n);
        this.originalName = string;
        this.name = this.computePartialArrayName(string);
        this.lb = n2;
        this.lbExpr = new ArithmeticAtomExpression(n2);
        this.ub = n3;
        this.ubExpr = new ArithmeticAtomExpression(n3);
    }

    public GecodeIntVarArgs(String string, int[] nArray, int[][] nArray2, int n, int n2) {
        int n3;
        this.indexDomains = nArray;
        this.indexDomainExprs = new Expression[this.indexDomains.length];
        for (n3 = 0; n3 < this.indexDomains.length; ++n3) {
            this.indexDomainExprs[n3] = new ArithmeticAtomExpression(this.indexDomains[n3]);
        }
        this.referencedIndices = nArray2;
        this.referencedIndicesExpr = new Expression[this.referencedIndices.length][2];
        for (n3 = 0; n3 < this.referencedIndices.length; ++n3) {
            this.referencedIndicesExpr[n3][0] = new ArithmeticAtomExpression(this.referencedIndices[n3][0]);
            this.referencedIndicesExpr[n3][1] = new ArithmeticAtomExpression(this.referencedIndices[n3][1]);
        }
        this.length = 1;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (this.referencedIndices[n3][0] == this.referencedIndices[n3][1]) continue;
            this.length *= this.referencedIndices[n3][1] - this.referencedIndices[n3][0] + 1;
        }
        this.lengthExpr = new ArithmeticAtomExpression(this.length);
        this.originalName = string;
        this.name = this.computePartialArrayName(string);
        this.lb = n;
        this.lbExpr = new ArithmeticAtomExpression(n);
        this.ub = n2;
        this.ubExpr = new ArithmeticAtomExpression(n2);
    }

    public GecodeIntVarArgs(String string, Expression[] expressionArray, Expression[][] expressionArray2, Expression expression, Expression expression2) {
        this.indexDomainExprs = expressionArray;
        this.referencedIndicesExpr = expressionArray2;
        this.lbExpr = expression;
        this.ubExpr = expression2;
        this.lengthExpr = new ArithmeticAtomExpression(1);
        for (int i = 0; i < this.indexDomainExprs.length; ++i) {
            if (((Object)this.referencedIndicesExpr[i][0]).toString().equals(((Object)this.referencedIndicesExpr[i][1]).toString())) continue;
            this.lengthExpr = new Multiplication(new Expression[]{this.lengthExpr.copy(), new Sum(new Expression[]{new ArithmeticAtomExpression(1), this.referencedIndicesExpr[i][1].copy()}, new Expression[]{this.referencedIndicesExpr[i][0].copy()})});
        }
        this.lengthExpr = this.lengthExpr.reduceExpressionTree().evaluate();
        System.out.println("length after evaluation: " + this.lengthExpr + ":" + this.lengthExpr.getClass().getSimpleName());
        this.originalName = string;
        this.name = this.computePartialArrayName(string);
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVar;
    }

    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVar = bl;
    }

    public int[] getBounds() {
        return new int[]{this.lb, this.ub};
    }

    public Expression[] getDefinedDomain() {
        return new Expression[]{this.lbExpr, this.ubExpr};
    }

    public int getLowerBound() {
        return this.lb;
    }

    public int getUpperBound() {
        return this.lb;
    }

    public int getLength() {
        return this.length;
    }

    public Expression getLengthExpr() {
        return this.lengthExpr;
    }

    public boolean isArgsVariable() {
        return true;
    }

    public char getType() {
        return '\u0004';
    }

    public String getVariableName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String toDeclarationCCString() {
        return "IntVarArgs " + this.name + "(" + this.lengthExpr + ")";
    }

    public boolean isIndexedArray() {
        return this.referencedIndices != null || this.referencedIndicesExpr != null;
    }

    public int[] getIndexDomains() {
        return this.indexDomains;
    }

    public Expression[] getIndexDomainExprs() {
        return this.indexDomainExprs;
    }

    public int[][] getReferencedIndex() {
        return this.referencedIndices;
    }

    public Expression[][] getReferencedIndicesExpr() {
        return this.referencedIndicesExpr;
    }

    public String getArrayDefinition() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.referencedIndices == null && this.referencedIndicesExpr == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("IntVarArgs " + this.name + "(" + this.lengthExpr + ");\n");
        if (this.indexDomainExprs.length == 1) {
            stringBuffer.append("\tfor(int i=" + this.referencedIndicesExpr[0][0] + "; i<=" + this.referencedIndicesExpr[0][1] + "; i++)\n");
            stringBuffer.append("\t   " + this.name + "[i] = " + this.originalName + "[i];\n");
        } else if (this.indexDomainExprs.length == 2) {
            if (this.referencedIndicesExpr[0][0] != this.referencedIndicesExpr[0][1]) {
                stringBuffer.append("\tfor(int i=" + this.referencedIndicesExpr[0][0] + "; i<=" + this.referencedIndicesExpr[0][1] + "; i++)\n");
                if (this.referencedIndicesExpr[1][0] != this.referencedIndicesExpr[1][1]) {
                    stringBuffer.append("\t   for(int j=" + this.referencedIndicesExpr[0][0] + "; j<=" + this.referencedIndicesExpr[0][1] + "; j++)\n");
                    stringBuffer.append("\t       " + this.name + "[i*" + this.indexDomainExprs[0] + " +j)] = " + this.originalName + "(i,j);\n");
                } else {
                    stringBuffer.append("\t   " + this.name + "[i] = " + this.originalName + "(i," + this.referencedIndicesExpr[1][0] + ");\n");
                }
            } else {
                stringBuffer.append("\tfor(int i=" + this.referencedIndicesExpr[1][0] + "; i<=" + this.referencedIndicesExpr[1][1] + "; i++)\n");
                stringBuffer.append("\t   " + this.name + "[i] = " + this.originalName + "(" + this.referencedIndicesExpr[0][0] + ",i);\n");
            }
        } else {
            return "oioioi";
        }
        return stringBuffer.toString();
    }

    public void addLowerBound(int n) {
        if (n < this.lb) {
            this.lb = n;
            this.lbExpr = new ArithmeticAtomExpression(this.lb);
        }
    }

    public void addUpperBound(int n) {
        if (n > this.ub) {
            this.ub = n;
            this.ubExpr = new ArithmeticAtomExpression(this.ub);
        }
    }

    public void increaseLength() {
        ++this.length;
        this.lengthExpr = new Sum(new Expression[]{this.lengthExpr.copy(), new ArithmeticAtomExpression(1)}, new Expression[0]);
        this.lengthExpr = this.lengthExpr.evaluate();
    }

    public void setLowerBound(int n) {
        this.lb = n;
    }

    public void setUpperBound(int n) {
        this.ub = n;
    }

    public void setLowerBoundExpr(Expression expression) {
        this.lbExpr = expression;
    }

    public void setUpperBoundExpr(Expression expression) {
        this.ubExpr = expression;
    }

    private String computePartialArrayName(String string) {
        String string2 = string + "_part";
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.referencedIndices != null) {
            for (int i = 0; i < this.referencedIndices.length; ++i) {
                if (this.referencedIndices[i][0] != this.referencedIndices[i][1]) {
                    stringBuffer.append(this.referencedIndices[i][0] + this.referencedIndices[i][1]);
                    continue;
                }
                stringBuffer.append(this.referencedIndices[i][0]);
            }
        }
        string2 = string2 + stringBuffer.toString() + "_";
        Random random = new Random();
        if ((string2 = string2 + random.nextInt(11111)).length() > 23) {
            return "_" + string2.toString().substring(string2.length() - 24 - 1);
        }
        return string2;
    }
}

