/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.Expression;
import translator.tailor.gecode.GecodeIntAtomVariable;

public class GecodeIntVar
implements GecodeIntAtomVariable {
    private String name;
    private int lb;
    private int ub;
    private Expression lbExpr;
    private Expression ubExpr;
    private boolean isParameter = false;
    private boolean isQuantifiedVar = false;

    public GecodeIntVar(String string, int n, int n2) {
        this.name = string;
        this.lb = n;
        this.ub = n2;
        this.lbExpr = new ArithmeticAtomExpression(n);
        this.ubExpr = new ArithmeticAtomExpression(n2);
    }

    public GecodeIntVar(String string, Expression expression, Expression expression2) {
        if (expression.getType() == 3) {
            this.lb = ((ArithmeticAtomExpression)expression).getConstant();
        }
        this.lbExpr = expression;
        if (expression2.getType() == 3) {
            this.ub = ((ArithmeticAtomExpression)expression2).getConstant();
        }
        this.ubExpr = expression2;
        this.name = string;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVar;
    }

    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVar = bl;
    }

    public int[] getBounds() {
        return new int[]{this.lb, this.ub};
    }

    public Expression[] getDefinedBounds() {
        return new Expression[]{this.lbExpr, this.ubExpr};
    }

    public boolean isArgsVariable() {
        return false;
    }

    public char getType() {
        return '\u0002';
    }

    public String getVariableName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String toDeclarationCCString() {
        return "IntVar " + this.name;
    }
}

