/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Expression;
import translator.expression.Sum;
import translator.tailor.gecode.GecodeAtom;
import translator.tailor.gecode.GecodeBoolArrayElem;
import translator.tailor.gecode.GecodeConstraint;
import translator.tailor.gecode.GecodeIntArrayElem;
import translator.tailor.gecode.GecodeVariable;
import translator.tailor.gecode.RelationalConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GecodeForallLinear
extends RelationalConstraint {
    GecodeVariable quantifiedVariable;
    ArrayList<RelationalConstraint> quantifiedConstraints;
    GecodeAtom result;
    GecodeAtom reifiedVar;
    Expression[] weights;
    char relop;
    String[] quantifiedVariables;
    Expression lowerBound;
    Expression upperBound;
    String argumentName;
    Expression offsetFromZero;

    public GecodeForallLinear(GecodeVariable gecodeVariable, char c, GecodeAtom gecodeAtom) {
        this.quantifiedVariable = gecodeVariable;
        this.relop = c;
        this.result = gecodeAtom;
    }

    public GecodeForallLinear(GecodeVariable gecodeVariable, int n, String[] stringArray, Expression expression, Expression expression2, char c, GecodeAtom gecodeAtom) {
        this.quantifiedVariable = gecodeVariable;
        this.quantifiedVariables = stringArray;
        this.lowerBound = expression;
        this.upperBound = expression2;
        this.relop = c;
        this.result = gecodeAtom;
        this.argumentName = this.computeArgsArrayName();
        this.offsetFromZero = new ArithmeticAtomExpression(n);
    }

    public GecodeForallLinear(GecodeVariable gecodeVariable, Expression expression, String[] stringArray, Expression expression2, Expression expression3, char c, GecodeAtom gecodeAtom) {
        this.quantifiedVariable = gecodeVariable;
        this.quantifiedVariables = stringArray;
        this.lowerBound = expression2;
        this.upperBound = expression3;
        this.relop = c;
        this.result = gecodeAtom;
        this.argumentName = this.computeArgsArrayName();
        this.offsetFromZero = expression;
    }

    public GecodeForallLinear(GecodeVariable gecodeVariable, ArrayList<GecodeConstraint> arrayList, Expression expression, String[] stringArray, Expression expression2, Expression expression3, char c, GecodeAtom gecodeAtom) {
        this.quantifiedVariable = gecodeVariable;
        this.quantifiedVariables = stringArray;
        this.lowerBound = expression2;
        this.upperBound = expression3;
        this.relop = c;
        this.result = gecodeAtom;
        this.argumentName = this.computeArgsArrayName();
        this.offsetFromZero = expression;
    }

    public String getArgsArrayName() {
        return this.argumentName;
    }

    public void setArgsArrayName(String string) {
        this.argumentName = string;
    }

    @Override
    public String toString() {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.quantifiedVariables == null) {
            stringBuffer.append("linear(this, " + this.quantifiedVariable.getVariableName() + ", ");
            if (this.reifiedVar == null) {
                stringBuffer.append(this.operatorToString(this.relop) + ", " + this.result);
            } else {
                stringBuffer.append(this.result + ", " + this.operatorToString(this.relop) + ", " + this.reifiedVar);
            }
            if (this.consistencyLevel == '\u0003' && this.propagationKind == '\u001e') {
                stringBuffer.append(")");
            } else {
                stringBuffer.append(", " + this.consistencyToString(this.consistencyLevel) + ", " + this.propagationToString(this.propagationKind) + ")");
            }
            return stringBuffer.toString();
        }
        Expression[] expressionArray = null;
        if (this.quantifiedVariable instanceof GecodeIntArrayElem) {
            object = (GecodeIntArrayElem)this.quantifiedVariable;
            expressionArray = ((GecodeIntArrayElem)object).getIndices();
        } else {
            object = (GecodeBoolArrayElem)this.quantifiedVariable;
            expressionArray = ((GecodeBoolArrayElem)object).getIndices();
        }
        object = new Sum(new Expression[]{new ArithmeticAtomExpression(1), this.upperBound}, new Expression[]{this.lowerBound});
        object = object.evaluate();
        if (this.quantifiedVariable instanceof GecodeIntArrayElem) {
            stringBuffer.append("IntVarArgs " + this.argumentName + "(" + object + ");\n");
        } else {
            stringBuffer.append("BoolVarArgs " + this.argumentName + "(" + object + ");\n");
        }
        for (n = 0; n < this.quantifiedVariables.length; ++n) {
            stringBuffer.append("\tfor(int " + this.quantifiedVariables[n] + "=" + this.lowerBound + ";" + this.quantifiedVariables[n] + "<=" + this.upperBound + ";" + this.quantifiedVariables[n] + "++) {\n");
        }
        if (this.quantifiedConstraints != null) {
            for (n = 0; n < this.quantifiedConstraints.size(); ++n) {
                stringBuffer.append("\t  " + this.quantifiedConstraints.get(n));
            }
        }
        if (!((Object)this.offsetFromZero).toString().equals("0")) {
            stringBuffer.append("\t  " + this.argumentName + "[" + this.quantifiedVariables[0] + "-" + this.offsetFromZero + "] =  " + this.quantifiedVariable + ";\n");
        } else {
            stringBuffer.append("\t  " + this.argumentName + "[" + this.quantifiedVariables[0] + "] =  " + this.quantifiedVariable + ";\n");
        }
        for (n = 0; n < this.quantifiedVariables.length; ++n) {
            stringBuffer.append("\t}\n");
        }
        stringBuffer.append("\tlinear(this, " + this.argumentName + ", ");
        if (this.reifiedVar == null) {
            stringBuffer.append(this.operatorToString(this.relop) + ", " + this.result);
        } else {
            stringBuffer.append(this.result + ", " + this.operatorToString(this.relop) + ", " + this.reifiedVar);
        }
        if (this.consistencyLevel == '\u0003' && this.propagationKind == '\u001e') {
            stringBuffer.append(")");
        } else {
            stringBuffer.append(", " + this.consistencyToString(this.consistencyLevel) + ", " + this.propagationToString(this.propagationKind) + ")");
        }
        return stringBuffer.toString();
    }

    private String computeArgsArrayName() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.quantifiedVariable.getVariableName());
        Expression[] expressionArray = null;
        if (this.quantifiedVariable instanceof GecodeIntArrayElem) {
            object = (GecodeIntArrayElem)this.quantifiedVariable;
            expressionArray = ((GecodeIntArrayElem)object).getIndices();
        } else {
            object = (GecodeBoolArrayElem)this.quantifiedVariable;
            expressionArray = ((GecodeBoolArrayElem)object).getIndices();
        }
        if (expressionArray.length == 1) {
            stringBuffer.append("_col_" + this.lowerBound + "_" + this.upperBound);
        } else {
            object = expressionArray[0].getQuantifyingVariables();
            boolean bl = true;
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                boolean bl2 = false;
                for (int j = 0; j < this.quantifiedVariables.length; ++j) {
                    if (!((Object)((Expression)((ArrayList)object).get(i))).toString().equals(this.quantifiedVariables[j])) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
            }
            if (bl) {
                stringBuffer.append("_col_" + this.lowerBound + "_" + this.upperBound);
            } else {
                stringBuffer.append("_row_" + this.lowerBound + "_" + this.upperBound);
            }
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == ' ' || stringBuffer.charAt(i) == '*' || stringBuffer.charAt(i) == '+' || stringBuffer.charAt(i) == '-' || stringBuffer.charAt(i) == '[' || stringBuffer.charAt(i) == ']' || stringBuffer.charAt(i) == '(' || stringBuffer.charAt(i) == ')') {
                stringBuffer.replace(i, i + 1, "_");
                continue;
            }
            if (stringBuffer.charAt(i) != ',') continue;
            stringBuffer.deleteCharAt(i);
        }
        if (stringBuffer.length() > 23) {
            return "_" + stringBuffer.toString().substring(stringBuffer.length() - 23);
        }
        return stringBuffer.toString();
    }
}

