/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.Expression;
import translator.expression.Multiplication;
import translator.expression.Sum;
import translator.tailor.gecode.BooleanVariable;
import translator.tailor.gecode.GecodeArrayVariable;

public class GecodeBoolVarArray
implements GecodeArrayVariable,
BooleanVariable {
    private int length;
    private Expression lengthExpr;
    private int[] lengths;
    private Expression[] lengthExprs;
    private String name;
    private boolean isParameter = false;
    private boolean isQuantifiedVar = false;

    public GecodeBoolVarArray(String string, int n) {
        this.name = string;
        this.length = n;
        this.lengthExpr = new ArithmeticAtomExpression(n);
    }

    public GecodeBoolVarArray(String string, Expression expression) {
        this.name = string;
        this.lengthExpr = expression;
        if (this.lengthExpr.getType() == 3) {
            this.length = ((ArithmeticAtomExpression)this.lengthExpr).getConstant();
        }
        if (this.lengthExpr.getType() == 3) {
            this.length = ((ArithmeticAtomExpression)this.lengthExpr).getConstant();
        }
    }

    public GecodeBoolVarArray(String string, int[] nArray) {
        int n;
        this.name = string;
        this.lengths = nArray;
        this.lengthExprs = new Expression[this.lengths.length];
        for (n = 0; n < this.lengthExprs.length; ++n) {
            this.lengthExprs[n] = new ArithmeticAtomExpression(nArray[n]);
        }
        this.length = 1;
        for (n = 0; n < this.lengths.length; ++n) {
            this.length *= nArray[n];
        }
        this.lengthExpr = new ArithmeticAtomExpression(this.length);
    }

    public GecodeBoolVarArray(String string, Expression[] expressionArray) {
        this.name = string;
        this.lengthExprs = expressionArray;
        this.lengthExpr = new Multiplication(expressionArray);
        this.lengthExpr = this.lengthExpr.evaluate();
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVar;
    }

    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVar = bl;
    }

    public int getLength() {
        return this.length;
    }

    public Expression getDefinedLength() {
        return this.lengthExpr;
    }

    public int getLowerBound() {
        return 0;
    }

    public int getUpperBound() {
        return 1;
    }

    public int[] getBounds() {
        return new int[]{0, 1};
    }

    public Expression[] getDefinedBounds() {
        return new Expression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    public char getType() {
        return '\f';
    }

    public String getVariableName() {
        if (this.lengths != null || this.lengthExprs != null) {
            if (this.lengths != null && this.lengths.length == 2 || this.lengthExprs != null && this.lengthExprs.length == 2) {
                return "_" + this.name;
            }
            if (this.lengths != null && this.lengths.length == 3 || this.lengthExprs != null && this.lengthExprs.length == 3) {
                return "__" + this.name;
            }
        }
        return this.name;
    }

    public String toDeclarationCCString() {
        if (this.lengths != null || this.lengthExprs != null) {
            if (this.lengths != null && this.lengths.length == 2 || this.lengthExprs != null && this.lengthExprs.length == 2) {
                return "BoolVarArray _" + this.name;
            }
            if (this.lengths != null && this.lengths.length == 3 || this.lengthExprs != null && this.lengthExprs.length == 3) {
                return "BoolVarArray __" + this.name;
            }
        }
        return "BoolVarArray " + this.name;
    }

    public boolean isArgsVariable() {
        return false;
    }

    public String toString() {
        if (this.lengths != null || this.lengthExprs != null) {
            if (this.lengths != null && this.lengths.length == 2 || this.lengthExprs != null && this.lengthExprs.length == 2) {
                return "_" + this.name;
            }
            if (this.lengths != null && this.lengths.length == 3 || this.lengthExprs != null && this.lengthExprs.length == 3) {
                return "__" + this.name;
            }
        }
        return this.name;
    }

    public void increaseLength() {
        if (this.lengthExpr == null) {
            ++this.length;
        } else {
            ++this.length;
            this.lengthExpr = new Sum(new Expression[]{this.lengthExpr, new ArithmeticAtomExpression(1)}, new Expression[0]);
            this.lengthExpr = this.lengthExpr.evaluate();
        }
    }

    public boolean isMultiDimensional() {
        return this.lengths != null && this.lengths.length >= 2 || this.lengthExprs != null && this.lengthExprs.length >= 2;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public Expression[] getDefinedLengths() {
        return this.lengthExprs;
    }
}

