/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import java.util.Random;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Expression;
import translator.expression.Multiplication;
import translator.expression.Sum;
import translator.tailor.gecode.ArgsArrayVariable;
import translator.tailor.gecode.BooleanVariable;

public class GecodeBoolVarArgs
implements ArgsArrayVariable,
BooleanVariable {
    private String name;
    private int length;
    private Expression lengthExpr;
    private boolean isParameter = false;
    private boolean isQuantifiedVar = false;
    private int[] indexDomains;
    private Expression[] indexDomainExprs;
    private int[][] referencedIndices;
    private Expression[][] referencedIndicesExpr;
    private String originalName;

    public GecodeBoolVarArgs(String string, int n) {
        this.length = n;
        this.name = string;
        this.originalName = string;
    }

    public GecodeBoolVarArgs(String string, int[] nArray, int[][] nArray2) {
        int n;
        this.indexDomains = nArray;
        this.indexDomainExprs = new Expression[this.indexDomains.length];
        for (n = 0; n < this.indexDomains.length; ++n) {
            this.indexDomainExprs[n] = new ArithmeticAtomExpression(this.indexDomains[n]);
        }
        this.referencedIndices = nArray2;
        this.referencedIndicesExpr = new Expression[this.referencedIndices.length][2];
        for (n = 0; n < this.referencedIndices.length; ++n) {
            this.referencedIndicesExpr[n][0] = new ArithmeticAtomExpression(this.referencedIndices[n][0]);
            this.referencedIndicesExpr[n][1] = new ArithmeticAtomExpression(this.referencedIndices[n][1]);
        }
        this.length = 1;
        for (n = 0; n < nArray.length; ++n) {
            if (this.referencedIndices[n][0] == this.referencedIndices[n][1]) continue;
            this.length *= this.referencedIndices[n][1] - this.referencedIndices[n][0] + 1;
        }
        this.lengthExpr = new ArithmeticAtomExpression(this.length);
        this.originalName = string;
        this.name = this.computePartialArrayName(string);
    }

    public GecodeBoolVarArgs(String string, Expression[] expressionArray, Expression[][] expressionArray2) {
        this.indexDomainExprs = expressionArray;
        this.referencedIndicesExpr = expressionArray2;
        this.lengthExpr = new ArithmeticAtomExpression(1);
        for (int i = 0; i < this.indexDomainExprs.length; ++i) {
            if (((Object)this.referencedIndicesExpr[i][0]).toString().equals(((Object)this.referencedIndicesExpr[i][1]).toString())) continue;
            this.lengthExpr = new Multiplication(new Expression[]{this.lengthExpr.copy(), new Sum(new Expression[]{new ArithmeticAtomExpression(1), this.referencedIndicesExpr[i][1].copy()}, new Expression[]{this.referencedIndicesExpr[i][0].copy()})});
        }
        this.lengthExpr = this.lengthExpr.evaluate();
        this.originalName = string;
        this.name = this.computePartialArrayName(string);
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVar;
    }

    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVar = bl;
    }

    public int[] getBounds() {
        return new int[]{0, 1};
    }

    public char getType() {
        return '\u0003';
    }

    public String getVariableName() {
        return this.name;
    }

    public boolean isArgsVariable() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public int getLowerBound() {
        return 0;
    }

    public int getUpperBound() {
        return 1;
    }

    public String toDeclarationCCString() {
        return "BoolVarArgs " + this.name + "(" + this.length + ")";
    }

    public boolean isIndexedArray() {
        return this.referencedIndices != null && this.referencedIndicesExpr != null;
    }

    public int[] getIndexDomains() {
        return this.indexDomains;
    }

    public Expression[] getIndexDomainExprs() {
        return this.indexDomainExprs;
    }

    public int[][] getReferencedIndex() {
        return this.referencedIndices;
    }

    public Expression[][] getReferencedIndexExprs() {
        return this.referencedIndicesExpr;
    }

    public String getArrayDefinition() {
        if (this.referencedIndices == null && this.referencedIndicesExpr == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("BoolVarArgs " + this.name + "(" + this.length + ");\n");
        if (this.indexDomainExprs.length == 1) {
            stringBuffer.append("\tfor(int i=" + this.referencedIndicesExpr[0][0] + "; i<=" + this.referencedIndicesExpr[0][1] + "; i++)\n");
            stringBuffer.append("\t   " + this.name + "[i] = " + this.originalName + "[i];\n");
        } else if (this.indexDomainExprs.length == 2) {
            if (!((Object)this.referencedIndicesExpr[0][0]).toString().equals(((Object)this.referencedIndicesExpr[0][1]).toString())) {
                stringBuffer.append("\tfor(int i=0; i<=" + this.indexDomainExprs[0] + "; i++)\n");
                if (!((Object)this.referencedIndicesExpr[1][0]).toString().equals(((Object)this.referencedIndicesExpr[1][1]).toString())) {
                    stringBuffer.append("\t   for(int j=" + this.referencedIndicesExpr[0][0] + "; j<=" + this.referencedIndicesExpr[0][1] + "; j++)\n");
                    stringBuffer.append("\t       " + this.name + "[i*" + this.indexDomainExprs[0] + " +j)] = " + this.originalName + "(i,j);\n");
                } else {
                    stringBuffer.append("\t   " + this.name + "[i] = " + this.originalName + "(i," + this.referencedIndicesExpr[1][0] + ");\n");
                }
            } else {
                stringBuffer.append("\tfor(int i=" + this.referencedIndicesExpr[1][0] + "; i<=" + this.referencedIndicesExpr[1][1] + "; i++)\n");
                stringBuffer.append("\t   " + this.name + "[i] = " + this.originalName + "(" + this.referencedIndicesExpr[0][1] + ",i);\n");
            }
        } else {
            return "oioioi";
        }
        return stringBuffer.toString();
    }

    public void increaseLength() {
        ++this.length;
    }

    private String computePartialArrayName(String string) {
        String string2 = string + "_part";
        StringBuffer stringBuffer = new StringBuffer("_");
        if (this.referencedIndices != null) {
            for (int i = 0; i < this.referencedIndices.length; ++i) {
                if (this.referencedIndices[i][0] != this.referencedIndices[i][1]) {
                    stringBuffer.append(this.referencedIndices[i][0] + this.referencedIndices[i][1]);
                    continue;
                }
                stringBuffer.append(this.referencedIndices[i][0]);
            }
        }
        string2 = string2 + stringBuffer.toString() + "_";
        Random random = new Random();
        if ((string2 = string2 + random.nextInt(11111)).length() > 23) {
            return "_" + string2.toString().substring(string2.length() - 24 - 1);
        }
        return string2;
    }
}

