/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.gecode;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.Expression;
import translator.tailor.gecode.GecodeBoolAtomVariable;

public class GecodeBoolArrayElem
implements GecodeBoolAtomVariable {
    private String name;
    private int[] indices;
    private Expression[] exprIndices;
    private boolean isParameter = false;
    private boolean isQuantifiedVar = false;

    public GecodeBoolArrayElem(String string, int[] nArray) {
        this.name = string;
        this.indices = nArray;
        this.exprIndices = new Expression[nArray.length];
        for (int i = 0; i < this.indices.length; ++i) {
            this.exprIndices[i] = new ArithmeticAtomExpression(this.indices[i]);
        }
    }

    public GecodeBoolArrayElem(String string, Expression[] expressionArray) {
        this.name = string;
        this.exprIndices = expressionArray;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVar;
    }

    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVar = bl;
    }

    public boolean isArgsVariable() {
        return false;
    }

    public int[] getBounds() {
        return new int[]{0, 1};
    }

    public char getType() {
        return '\n';
    }

    public String getVariableName() {
        return this.name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        if (this.indices != null) {
            if (this.indices.length == 1) {
                stringBuffer.append("[" + this.indices[0] + "]");
            } else {
                stringBuffer.append("(");
                for (int i = 0; i < this.indices.length - 1; ++i) {
                    stringBuffer.append(this.indices[i] + ",");
                }
                stringBuffer.append(this.indices[this.indices.length - 1] + ")");
            }
        } else if (this.exprIndices.length == 1) {
            stringBuffer.append("[" + this.exprIndices[0] + "]");
        } else {
            stringBuffer.append("(");
            for (int i = 0; i < this.exprIndices.length - 1; ++i) {
                stringBuffer.append(this.exprIndices[i] + ",");
            }
            stringBuffer.append(this.exprIndices[this.exprIndices.length - 1] + ")");
        }
        return stringBuffer.toString();
    }

    public String toDeclarationCCString() {
        return this.toString();
    }

    public Expression[] getIndices() {
        return this.exprIndices;
    }
}

