/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor.flatzinc;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.ArithmeticExpression;
import translator.expression.AtomExpression;
import translator.expression.BinaryRelationalExpression;
import translator.expression.BoolDomain;
import translator.expression.BoundedIntRange;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.Variable;
import translator.normaliser.NormalisedModel;

public class FlatZincTailor {
    private TranslationSettings settings;
    private NormalisedModel essencePmodel;

    public StringBuffer toFlatZincString(NormalisedModel normalisedModel, TranslationSettings translationSettings) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.essencePmodel = normalisedModel;
        this.settings = translationSettings;
        stringBuffer.append(this.printHeader());
        stringBuffer.append(this.printVariableDeclaration());
        stringBuffer.append(this.printConstraints());
        if (this.essencePmodel.getObjectiveExpression() == null) {
            stringBuffer.append("\n\nsolve satisfy;\n");
        } else if (this.essencePmodel.isObjectiveMaximising()) {
            stringBuffer.append("\nsolve maximizing " + ((Object)this.essencePmodel.getObjectiveExpression()).toString() + ";\n");
        } else {
            stringBuffer.append("\nsolve minimizing " + ((Object)this.essencePmodel.getObjectiveExpression()).toString() + ";\n");
        }
        return stringBuffer;
    }

    private StringBuffer printConstraints() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("\n% constraints\n");
        ArrayList<Expression> arrayList = this.essencePmodel.getConstraints();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append("constraint ");
            stringBuffer.append(this.printExpression(arrayList.get(i)));
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    private StringBuffer printExpression(Expression expression) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (expression instanceof BinaryRelationalExpression) {
            BinaryRelationalExpression binaryRelationalExpression = (BinaryRelationalExpression)expression;
            if (!(binaryRelationalExpression.getLeftArgument() instanceof AtomExpression) || !(binaryRelationalExpression.getRightArgument() instanceof AtomExpression)) {
                throw new Exception("Not flattened properly for FlatZinc, expected atoms as arguments: " + expression);
            }
            AtomExpression atomExpression = (AtomExpression)binaryRelationalExpression.getLeftArgument();
            AtomExpression atomExpression2 = (AtomExpression)binaryRelationalExpression.getRightArgument();
            if (atomExpression instanceof ArithmeticExpression) {
                stringBuffer.append("int_");
            } else {
                stringBuffer.append("bool_");
            }
            stringBuffer.append(this.operatorToString(binaryRelationalExpression.getOperator()));
            stringBuffer.append("(" + atomExpression.toString() + ", " + atomExpression2.toString() + ");");
        }
        return stringBuffer;
    }

    private String operatorToString(int n) throws Exception {
        switch (n) {
            case 101: {
                return "eq";
            }
            case 100: {
                return "ne";
            }
            case 104: {
                return "lq";
            }
            case 108: {
                return "qq";
            }
            case 106: {
                return "gr";
            }
            case 102: {
                return "le";
            }
        }
        throw new Exception("Unkown operator in Flatzinc tailor:" + n);
    }

    private String printHeader() {
        StringBuffer stringBuffer = new StringBuffer("% ");
        StringBuilder stringBuilder = new StringBuilder();
        this.settings.getClass();
        stringBuffer.append(stringBuilder.append("This file has been automatically generated by TAILOR v0.3").append("\n% ").append(this.settings.OUTPUTFILE_HEADER_BUGS).append("\n").toString());
        return stringBuffer.toString();
    }

    private StringBuffer printVariableDeclaration() throws Exception {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("\n% decision variable declaration\n");
        ArrayList<String> arrayList = this.essencePmodel.getDecisionVariablesNames();
        HashMap<String, Domain> hashMap = this.essencePmodel.getDecisionVariables();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            object2 = hashMap.get(string);
            if (object2 instanceof BoolDomain) {
                stringBuffer.append("var bool :" + string + ";\n");
                continue;
            }
            if (object2 instanceof BoundedIntRange) {
                object = ((BoundedIntRange)object2).getRange();
                stringBuffer.append("var " + object[0] + ".." + object[1] + ": " + string + ";\n");
                continue;
            }
            if (object2 instanceof ConstantArrayDomain) {
                object = ((ConstantArrayDomain)object2).getBaseDomain();
                ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)object2).getIndexDomains();
                if (constantDomainArray.length > 1) {
                    throw new Exception("Sorry, cannot translate to FlatZinc since it does not support multi-dimensional arrays, like " + string);
                }
                int[] nArray = constantDomainArray[0].getRange();
                stringBuffer.append("array[" + nArray[0] + ".." + nArray[1] + "] of ");
                if (object instanceof BoolDomain) {
                    stringBuffer.append("var bool :" + string + ";\n");
                    continue;
                }
                if (object instanceof BoundedIntRange) {
                    int[] nArray2 = ((BoundedIntRange)object).getRange();
                    stringBuffer.append("var " + nArray2[0] + ".." + nArray2[1] + " :" + string + ";\n");
                    continue;
                }
                throw new Exception("Cannot tailor to FlatZinc (yet) because FlatZinc does not support " + (object instanceof ConstantDomain ? " problem classes and domain " + object + " of variable " + string + " is not entirely constant." : "domains of type:" + object.getClass().getSimpleName()) + " like " + object + " of variable " + string);
            }
            throw new Exception("Cannot tailor to FlatZinc (yet) because FlatZinc does not support " + (object2 instanceof ConstantDomain ? " problem classes and domain " + object2 + " of variable " + string + " is not entirely constant." : "domains of type:" + object2.getClass().getSimpleName()) + " like " + object2 + " of variable " + string);
        }
        ArrayList<Variable> arrayList2 = this.essencePmodel.getAuxVariables();
        if (arrayList2.size() > 0) {
            stringBuffer.append("\n% auxiliary variables\n\n");
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            object2 = arrayList2.get(i);
            object = object2.getDomain();
            if (object == null || ((int[])object).length == 0) {
                throw new Exception("FlatZinc does not support problem classes and auxiliary variable " + object2 + " ranges over a non-constant domain");
            }
            if (object[0] == 0 && object[1] == 1) {
                stringBuffer.append("var bool: " + object2.getVariableName() + ";\n");
                continue;
            }
            stringBuffer.append("var " + object[0] + ".." + object[1] + ": " + object2.getVariableName() + ";\n");
        }
        return stringBuffer;
    }
}

