/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor;

import translator.TranslationSettings;
import translator.normaliser.NormalisedModel;
import translator.solver.Gecode;
import translator.solver.Minion;
import translator.solver.TargetSolver;
import translator.tailor.FlatZincTailor;
import translator.tailor.Flattener;
import translator.tailor.TailorException;
import translator.tailor.gecode.GecodeException;
import translator.tailor.gecode.GecodeModel;
import translator.tailor.gecode.GecodeTailor;
import translator.tailor.minion.MinionException;
import translator.tailor.minion.MinionModel;
import translator.tailor.minion.MinionTailor;

public class Tailor {
    NormalisedModel problemModel;
    TargetSolver targetSolver;
    TranslationSettings settings;
    MinionTailor minionTailor;
    FlatZincTailor flatzincTailor;
    private String cseInfo;

    public Tailor(NormalisedModel normalisedModel, TranslationSettings translationSettings) {
        this.problemModel = normalisedModel;
        this.settings = translationSettings;
        this.targetSolver = this.settings.getTargetSolver();
    }

    public String tailor(NormalisedModel normalisedModel, TargetSolver targetSolver) throws TailorException, MinionException, GecodeException, Exception {
        this.problemModel = normalisedModel;
        this.targetSolver = targetSolver;
        if (this.settings.getGenerateFlatzincOutput()) {
            this.flatzincTailor = new FlatZincTailor();
            return this.flatzincTailor.toFlatZincString(normalisedModel, this.settings).toString();
        }
        if (targetSolver instanceof Minion) {
            this.minionTailor = new MinionTailor();
            MinionModel minionModel = this.minionTailor.tailorToMinion(normalisedModel, this.settings);
            long l = System.currentTimeMillis();
            String string = minionModel.toString();
            if (this.settings.giveTranslationTimeInfo()) {
                long l2 = System.currentTimeMillis();
                this.writeTimeInfo("Minion Model toString Time: " + (double)(l2 - l) / 1000.0 + "sec");
            }
            if (this.settings.getCseDetails()) {
                this.cseInfo = this.minionTailor.getCseInfo();
            }
            return string;
        }
        if (targetSolver instanceof Gecode) {
            GecodeTailor gecodeTailor = new GecodeTailor();
            GecodeModel gecodeModel = gecodeTailor.tailorToGecode(normalisedModel, this.settings);
            long l = System.currentTimeMillis();
            String string = gecodeModel.toString();
            if (this.settings.giveTranslationTimeInfo()) {
                long l3 = System.currentTimeMillis();
                this.writeTimeInfo("Gecode Model toString Time: " + (double)(l3 - l) / 1000.0 + "sec");
            }
            return string;
        }
        throw new TailorException("Cannot tailor model to specified solver: '" + targetSolver.getSolverName() + "'. no tailor for solver available.");
    }

    public NormalisedModel flattenModel() throws TailorException, Exception {
        Flattener flattener = new Flattener(this.settings, this.problemModel);
        this.targetSolver = this.settings.getTargetSolver();
        this.problemModel = flattener.flattenModel();
        if (this.settings.getCseDetails()) {
            this.cseInfo = flattener.getCseInfo();
        }
        return this.problemModel;
    }

    public String getEssenceSolution(String string) throws TailorException {
        if (this.targetSolver instanceof Minion) {
            if (this.minionTailor != null) {
                return this.minionTailor.getEssenceSolution(string);
            }
            throw new TailorException("Please tailor model before mapping the solver output.");
        }
        if (this.targetSolver instanceof Gecode && this.settings.getGenerateFlatzincOutput()) {
            return this.flatzincTailor.getEssenceSolution(string);
        }
        throw new TailorException("Cannot return Essence' output for solver '" + this.targetSolver.getSolverName() + "'. no tailor for solver available.");
    }

    private void writeTimeInfo(String string) {
        if (this.settings.giveTranslationTimeInfo()) {
            System.out.println(string);
        }
    }

    public String getCseInfo() {
        return this.cseInfo;
    }
}

