/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.AbsoluteConstraint;
import translator.expression.AbsoluteValue;
import translator.expression.AllDifferent;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArithmeticExpression;
import translator.expression.Array;
import translator.expression.ArrayDomain;
import translator.expression.ArrayVariable;
import translator.expression.Atmost;
import translator.expression.AtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BinaryMinimum;
import translator.expression.BinaryNonLinearConstraint;
import translator.expression.BinaryRelationalExpression;
import translator.expression.BoolDomain;
import translator.expression.BoundedExpressionRange;
import translator.expression.BoundedIntRange;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Conjunction;
import translator.expression.ConstantArray;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.ConstantMatrix;
import translator.expression.ConstantVector;
import translator.expression.Disjunction;
import translator.expression.Domain;
import translator.expression.ElementConstraint;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.GlobalCardinality;
import translator.expression.IndexedArray;
import translator.expression.InfiniteDomain;
import translator.expression.LexConstraint;
import translator.expression.MatrixDomain;
import translator.expression.Minimum;
import translator.expression.MinimumConstraint;
import translator.expression.Multiplication;
import translator.expression.NaryRelationalExpression;
import translator.expression.Negation;
import translator.expression.NonCommutativeArithmeticBinaryExpression;
import translator.expression.NonCommutativeRelationalBinaryExpression;
import translator.expression.ProductConstraint;
import translator.expression.QuantifiedExpression;
import translator.expression.QuantifiedSum;
import translator.expression.Reification;
import translator.expression.RelationalAtomExpression;
import translator.expression.RelationalExpression;
import translator.expression.SimpleArray;
import translator.expression.SimpleArrayVariable;
import translator.expression.SimpleVariable;
import translator.expression.SingleExpressionRange;
import translator.expression.SingleIntRange;
import translator.expression.SingleRange;
import translator.expression.SingleVariable;
import translator.expression.SparseIntRange;
import translator.expression.Sum;
import translator.expression.SumConstraint;
import translator.expression.TableConstraint;
import translator.expression.TableConstraintNew;
import translator.expression.UnaryArithmeticExpression;
import translator.expression.UnaryMinus;
import translator.expression.UnaryRelationalExpression;
import translator.expression.Variable;
import translator.expression.VariableArray;
import translator.normaliser.NormalisedModel;
import translator.normaliser.NormaliserException;
import translator.solver.Gecode;
import translator.solver.Minion;
import translator.solver.TargetSolver;
import translator.tailor.TailorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flattener {
    public final int CONSTANT_ARRAY_OFFSET_FROM_ZERO = 1;
    public String AUXVARIABLE_NAME = "aux";
    public final String AUXVARIABLE_ARRAY_NAME = "aux_array";
    protected int noAuxVariables;
    protected int noAuxArrayVariables = 0;
    protected int noUsedNegatedCSEs = 0;
    TranslationSettings settings;
    TargetSolver targetSolver;
    ArrayList<Expression> constraintBuffer;
    ArrayList<Expression> constraints;
    HashMap<String, ArithmeticAtomExpression> subExpressions;
    HashMap<String, Integer> subExpressionCount;
    HashMap<String, Expression> subExpressionCountPC;
    ArrayList<String> subexpressionList;
    HashMap<String, ArithmeticAtomExpression> equalSubExpressions;
    HashMap<String, ArithmeticAtomExpression> equalAtomsMap;
    ArrayList<ArithmeticAtomExpression> replaceableVariables;
    HashMap<String, Expression> auxVarExpressions;
    ArrayList<String> auxArrayNames;
    HashMap<String, MatrixDomain> auxArrayDomainsMap;
    HashMap<String, Domain> quantifiedVarNamesMap = new HashMap();
    HashMap<String, ArrayList<String>> quantifiedDomainsMap = new HashMap();
    NormalisedModel normalisedModel;
    boolean useCommonSubExpressions;
    boolean useEqualSubExpressions;
    boolean applyStrongCopyPropagation;
    int usedCommonSubExpressions;
    Expression usedQuantifiedCommonSubExpressions = new ArithmeticAtomExpression(0);
    int usedEqualSubExpressions;
    int noSimpleConjunctionCSEs = 0;
    int noSimpleDisjunctionCSEs = 0;
    int noNegatedCSEs = 0;
    boolean flatteningNegatedArgument = false;

    public Flattener(TranslationSettings translationSettings, NormalisedModel normalisedModel) {
        this.settings = translationSettings;
        this.targetSolver = this.settings.getTargetSolver();
        this.normalisedModel = normalisedModel;
        this.constraintBuffer = new ArrayList();
        this.subExpressions = new HashMap();
        this.subExpressionCount = new HashMap();
        this.subExpressionCountPC = new HashMap();
        this.subexpressionList = new ArrayList();
        this.equalSubExpressions = new HashMap();
        this.noAuxVariables = 0;
        this.usedCommonSubExpressions = 0;
        this.usedEqualSubExpressions = 0;
        this.useCommonSubExpressions = this.settings.useCommonSubExpressions();
        this.applyStrongCopyPropagation = this.settings.applyStrictCopyPropagation();
        this.useEqualSubExpressions = this.settings.useEqualCommonSubExpressions();
        this.equalAtomsMap = new HashMap();
        this.replaceableVariables = new ArrayList();
        this.auxVarExpressions = new HashMap();
        this.auxArrayDomainsMap = new HashMap();
        this.auxArrayNames = new ArrayList();
        this.quantifiedDomainsMap = this.normalisedModel.getQuantifierDomainsMap();
        this.quantifiedVarNamesMap = this.normalisedModel.getQuantifierNamesMap();
    }

    public NormalisedModel flattenModel() throws TailorException, Exception {
        int n;
        if (this.targetSolver.supportsNestedExpressions()) {
            return this.normalisedModel;
        }
        while (this.normalisedModel.getDecisionVariables().containsKey(this.AUXVARIABLE_NAME + "0")) {
            this.AUXVARIABLE_NAME = "_" + this.AUXVARIABLE_NAME;
        }
        ArrayList<Expression> arrayList = this.normalisedModel.getConstraints();
        this.constraints = new ArrayList();
        this.constraintBuffer.clear();
        this.normalisedModel.setFlattenedObjectiveExpression(this.flattenObjective());
        for (n = 0; n < this.constraintBuffer.size(); ++n) {
            this.constraints.add(this.constraintBuffer.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ArrayList<Expression> arrayList2 = this.flattenConstraint(arrayList.get(n));
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                Expression expression = arrayList2.remove(i);
                if ((expression = expression.evaluate()).getType() == 0) {
                    if (((RelationalAtomExpression)expression).getBool()) continue;
                    this.constraints.add(expression);
                    continue;
                }
                if (expression instanceof RelationalExpression) {
                    if (expression instanceof RelationalAtomExpression) {
                        this.constraints.add(new CommutativeBinaryRelationalExpression(new RelationalAtomExpression(true), 101, expression));
                        continue;
                    }
                    if (this.constraints.size() == 0) {
                        this.constraints.add(expression);
                        continue;
                    }
                    if (((Object)expression).toString().equals(((Object)this.constraints.get(this.constraints.size() - 1)).toString())) continue;
                    this.constraints.add(expression);
                    continue;
                }
                throw new TailorException("Constraint expression has to be a relational expression and not:" + expression + " of type " + expression.getClass().getSimpleName());
            }
        }
        this.normalisedModel.setAmountOfCommonSubExpressionsUsed(this.usedCommonSubExpressions);
        this.normalisedModel.setAmountOfEqualSubExpressionsUsed(this.usedEqualSubExpressions);
        this.normalisedModel.replaceConstraintsWith(this.constraints);
        this.normalisedModel.setNoSimpleConjunctionCSES(this.noSimpleConjunctionCSEs);
        this.normalisedModel.setNoSimpleDisjunctionCSES(this.noSimpleDisjunctionCSEs);
        this.normalisedModel.setNoNegatedCSEs(this.noNegatedCSEs);
        this.normalisedModel.setAuxArrayDomainMap(this.auxArrayDomainsMap);
        this.normalisedModel.setAuxArrayNames(this.auxArrayNames);
        if (this.useCommonSubExpressions) {
            this.normalisedModel.setSubExpressions(this.subExpressions);
            if (this.usedQuantifiedCommonSubExpressions.getType() != 3 || ((ArithmeticAtomExpression)this.usedQuantifiedCommonSubExpressions).getConstant() != 0) {
                this.normalisedModel.setNumberOfQuantifiedCSE(this.usedQuantifiedCommonSubExpressions.evaluate());
            }
        }
        if (this.settings.applyDirectVariableReusage()) {
            this.normalisedModel.setEqualAtoms(this.equalAtomsMap, this.replaceableVariables);
        }
        if (this.settings.getCseDetails() || this.settings.useCSEVarOrdering()) {
            this.normalisedModel.setSubexpressionCount(this.subExpressionCount);
            this.normalisedModel.setSubexpressionList(this.subexpressionList);
        }
        if (this.settings.getAuxVarDetails() || this.settings.useCSEVarOrdering()) {
            this.normalisedModel.setAuxVarDetailsHashMap(this.auxVarExpressions);
        }
        return this.normalisedModel;
    }

    protected ArrayList<Expression> flattenConstraint(Expression expression) throws TailorException, Exception {
        this.constraintBuffer.clear();
        expression.setIsNotNested();
        Expression expression2 = this.flattenExpression(expression);
        ArrayList<Expression> arrayList = this.constraintBuffer;
        arrayList.add(expression2);
        return arrayList;
    }

    protected Expression flattenExpression(Expression expression) throws TailorException, Exception {
        if (expression instanceof RelationalAtomExpression) {
            return this.flattenAtomExpression((RelationalAtomExpression)expression);
        }
        if (expression instanceof UnaryRelationalExpression) {
            return this.flattenUnaryRelationalExpression((UnaryRelationalExpression)expression);
        }
        if (expression instanceof NonCommutativeRelationalBinaryExpression) {
            return this.flattenNonCommutativeRelationalBinaryExpression((NonCommutativeRelationalBinaryExpression)expression);
        }
        if (expression instanceof QuantifiedExpression) {
            return this.flattenQuantifiedExpression((QuantifiedExpression)expression);
        }
        if (expression instanceof Conjunction) {
            return this.flattenConjunction((Conjunction)expression);
        }
        if (expression instanceof Disjunction) {
            return this.flattenDisjunction((Disjunction)expression);
        }
        if (expression instanceof ElementConstraint) {
            return this.flattenElementConstraint((ElementConstraint)expression);
        }
        if (expression instanceof QuantifiedSum) {
            return this.flattenQuantifiedSum((QuantifiedSum)expression);
        }
        if (expression instanceof CommutativeBinaryRelationalExpression) {
            return this.flattenCommutativeBinaryRelationalExpression((CommutativeBinaryRelationalExpression)expression);
        }
        if (expression instanceof LexConstraint) {
            return this.flattenLexConstraint((LexConstraint)expression);
        }
        if (expression instanceof Atmost) {
            return this.flattenAtmost((Atmost)expression);
        }
        if (expression instanceof TableConstraint) {
            return this.flattenTableConstraint((TableConstraint)expression);
        }
        if (expression instanceof TableConstraintNew) {
            return this.flattenTableConstraintNew(expression);
        }
        if (expression instanceof GlobalCardinality) {
            return this.flattenGCC((GlobalCardinality)expression);
        }
        if (expression instanceof QuantifiedSum) {
            return this.flattenQuantifiedSum((QuantifiedSum)expression);
        }
        if (expression instanceof ArithmeticAtomExpression) {
            return this.flattenAtomExpression((ArithmeticAtomExpression)expression);
        }
        if (expression instanceof UnaryArithmeticExpression) {
            return this.flattenUnaryArithmeticExpression((UnaryArithmeticExpression)expression);
        }
        if (expression instanceof Sum) {
            return this.flattenSum((Sum)expression);
        }
        if (expression instanceof Multiplication) {
            return this.flattenMultiplication((Multiplication)expression);
        }
        if (expression instanceof NonCommutativeArithmeticBinaryExpression) {
            return this.flattenNonCommArithm((NonCommutativeArithmeticBinaryExpression)expression);
        }
        if (expression instanceof BinaryMinimum) {
            return this.flattenBinaryMinimum((BinaryMinimum)expression);
        }
        if (expression instanceof Array) {
            return expression;
        }
        if (expression instanceof ConstantArray) {
            return expression;
        }
        if (expression instanceof AtomExpression) {
            if (((AtomExpression)expression).isParameter()) {
                return expression;
            }
            throw new TailorException("Unknown variable/expression: " + expression + " (expression with no domain associated). Type:" + expression.getClass().getSimpleName());
        }
        throw new TailorException("Unknown variable/expression: " + expression + " (expression with no domain associated). Type:" + expression.getClass().getSimpleName());
    }

    private Expression flattenTableConstraintNew(Expression expression) throws TailorException, Exception {
        TableConstraintNew tableConstraintNew = (TableConstraintNew)expression;
        if (this.targetSolver.supportsConstraint(221)) {
            AtomExpression[] atomExpressionArray = tableConstraintNew.getVariables();
            for (int i = 0; i < atomExpressionArray.length; ++i) {
                atomExpressionArray[i].willBeFlattenedToVariable(true);
                atomExpressionArray[i] = (AtomExpression)atomExpressionArray[i].evaluate();
                atomExpressionArray[i] = atomExpressionArray[i] instanceof ArithmeticAtomExpression ? (AtomExpression)this.flattenAtomExpression((ArithmeticAtomExpression)atomExpressionArray[i]) : (AtomExpression)this.flattenAtomExpression((RelationalAtomExpression)atomExpressionArray[i]);
            }
            if (tableConstraintNew.isGonnaBeFlattenedToVariable()) {
                if (this.targetSolver.supportsReificationOf(221)) {
                    tableConstraintNew.setVariables(new VariableArray(atomExpressionArray));
                    return this.reifyConstraint(tableConstraintNew);
                }
                throw new TailorException("Cannot tailor TABLECONSTRAINT '" + tableConstraintNew + "' to " + this.targetSolver.getSolverName() + ":\n" + "The solver does not support reification of tables.");
            }
            tableConstraintNew.setVariables(new VariableArray(atomExpressionArray));
            return tableConstraintNew;
        }
        throw new TailorException("Cannot tailor TABLE constraint: it is not supported by " + this.targetSolver.getSolverName());
    }

    private Expression flattenTableConstraint(TableConstraint tableConstraint) throws TailorException, Exception {
        if (this.targetSolver.supportsConstraint(221)) {
            Variable[] variableArray = tableConstraint.getVariables();
            for (int i = 0; i < variableArray.length; ++i) {
                variableArray[i].willBeFlattenedToVariable(true);
                variableArray[i] = ((ArithmeticAtomExpression)this.flattenExpression(new ArithmeticAtomExpression(variableArray[i]))).getVariable();
            }
            if (tableConstraint.isGonnaBeFlattenedToVariable()) {
                if (this.targetSolver.supportsReificationOf(221)) {
                    TableConstraint tableConstraint2 = new TableConstraint(variableArray, tableConstraint.getTupleList());
                    tableConstraint2.setToConflictingTableConstraint(tableConstraint.isConflictingTableConstraint());
                    return this.reifyConstraint(tableConstraint2);
                }
                throw new TailorException("Cannot tailor TABLECONSTRAINT '" + tableConstraint + "' to " + this.targetSolver.getSolverName() + ":\n" + "The solver does not support reification of tables.");
            }
            TableConstraint tableConstraint3 = new TableConstraint(variableArray, tableConstraint.getTupleList());
            tableConstraint3.setToConflictingTableConstraint(tableConstraint.isConflictingTableConstraint());
            return tableConstraint3;
        }
        throw new TailorException("Cannot tailor TABLE constraint: it is not supported by " + this.targetSolver.getSolverName());
    }

    private Expression flattenGCC(GlobalCardinality globalCardinality) throws TailorException, Exception {
        Expression expression = globalCardinality.getVariables();
        if (!((expression = expression.evaluate()) instanceof Array)) {
            throw new TailorException("Infeasible expression type of " + expression + ": expected Array type instead of " + expression.getClass().getSimpleName());
        }
        globalCardinality.setVariables(this.flattenExpression(expression));
        Expression expression2 = globalCardinality.getValues();
        if (expression2 == null) {
            throw new TailorException("Cannot tailor constraint:" + globalCardinality + ". The 'values' argument is infeasible.");
        }
        globalCardinality.setValues(this.flattenExpression(expression2));
        Expression expression3 = globalCardinality.getCapacities();
        if (expression3 == null) {
            throw new TailorException("Cannot tailor constraint:" + globalCardinality + ". The 'capacity' argument is infeasible.");
        }
        globalCardinality.setCapacities(this.flattenExpression(expression3));
        return globalCardinality;
    }

    private Expression flattenAtmost(Atmost atmost) throws TailorException, Exception {
        if (atmost.isAtmost() && this.targetSolver.supportsConstraint(223) || !atmost.isAtmost() && this.targetSolver.supportsConstraint(224)) {
            Array array = atmost.getArray();
            array = (Array)this.flattenExpression(array);
            if (atmost.isGonnaBeFlattenedToVariable()) {
                if (atmost.isAtmost() && this.targetSolver.supportsReificationOf(223) || !atmost.isAtmost() && this.targetSolver.supportsReificationOf(224)) {
                    atmost.setArray(array);
                    return this.reifyConstraint(atmost);
                }
                throw new TailorException("Cannot tailor ATMOST/ATLEAST constraint '" + atmost + "' to target solver yet: it is not reifiable.");
            }
            atmost.setArray(array);
            return atmost;
        }
        throw new TailorException("Cannot tailor ATMOST/ATLEAST to " + this.targetSolver.getSolverName() + " yet: it does not support ATLEAST/ATMOST.");
    }

    private Expression flattenLexConstraint(LexConstraint lexConstraint) throws TailorException, Exception {
        Array array = (Array)this.flattenExpression(lexConstraint.getLeftArray());
        Array array2 = (Array)this.flattenExpression(lexConstraint.getRightArray());
        if (lexConstraint.isGonnaBeFlattenedToVariable()) {
            if (this.targetSolver.supportsReificationOf(lexConstraint.getOperator())) {
                return this.reifyConstraint(new LexConstraint(array, lexConstraint.getOperator(), array2));
            }
            throw new TailorException("Cannot reify lex constraint since the reification is not supported by the target solver:" + lexConstraint);
        }
        return new LexConstraint(array, lexConstraint.getOperator(), array2);
    }

    private void addStrongEqualityToSubExpressions(Expression expression, Expression expression2) {
        if (!this.applyStrongCopyPropagation) {
            return;
        }
        if (expression.getType() == 3) {
            this.addToSubExpressions(expression2, expression);
        } else if (expression2.getType() == 3) {
            this.addToSubExpressions(expression, expression2);
        }
    }

    private Expression flattenNonCommutativeRelationalBinaryExpression(NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression) throws TailorException, Exception {
        Expression expression;
        Expression expression2;
        Expression expression3;
        Expression expression4 = nonCommutativeRelationalBinaryExpression.getLeftArgument();
        Expression expression5 = nonCommutativeRelationalBinaryExpression.getRightArgument();
        if (nonCommutativeRelationalBinaryExpression.getCategory() <= 2) {
            return nonCommutativeRelationalBinaryExpression.evaluate();
        }
        if (this.targetSolver.supportsConstraintsNestedAsArgumentOf(nonCommutativeRelationalBinaryExpression.getOperator())) {
            expression4 = this.flattenExpression(expression4);
            expression5 = this.flattenExpression(expression5);
            return new NonCommutativeRelationalBinaryExpression(expression4, nonCommutativeRelationalBinaryExpression.getOperator(), expression5);
        }
        if (expression4 instanceof QuantifiedSum || expression4 instanceof QuantifiedExpression) {
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(nonCommutativeRelationalBinaryExpression.getOperator())) {
                expression4.willBeFlattenedToVariable(true);
            }
            expression4 = this.flattenExpression(expression4);
        }
        if (expression5 instanceof QuantifiedSum || expression5 instanceof QuantifiedExpression) {
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(nonCommutativeRelationalBinaryExpression.getOperator())) {
                expression5.willBeFlattenedToVariable(true);
            }
            expression5 = this.flattenExpression(expression5);
        }
        if (expression4 instanceof Sum) {
            expression3 = (Sum)expression4;
            if (((Sum)expression3).getCategory() == 3) {
                Sum sum = (Sum)((Sum)expression3).copy();
                sum.setWillBeConvertedToSumConstraint(true);
                SumConstraint sumConstraint = (SumConstraint)this.flattenSum(sum);
                expression5.willBeFlattenedToVariable(true);
                Expression expression6 = this.flattenExpression(expression5);
                sumConstraint.setResult(expression6, nonCommutativeRelationalBinaryExpression.getOperator(), false);
                if (nonCommutativeRelationalBinaryExpression.getOperator() == 101 && !nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                    this.addToSubExpressions(expression3, expression6);
                }
                if (nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                    return this.reifyConstraint(sumConstraint);
                }
                return sumConstraint;
            }
        } else if (expression5 instanceof Sum && ((Sum)(expression3 = (Sum)expression5)).getCategory() == 3) {
            expression2 = (Sum)((Sum)expression3).copy();
            ((Sum)expression2).setWillBeConvertedToSumConstraint(true);
            expression = this.flattenSum((Sum)expression2);
            if (expression instanceof ArithmeticAtomExpression || expression instanceof RelationalAtomExpression) {
                expression5 = expression;
            } else {
                if (expression instanceof SumConstraint) {
                    SumConstraint sumConstraint = (SumConstraint)expression;
                    expression4.willBeFlattenedToVariable(true);
                    Expression expression7 = this.flattenExpression(expression4);
                    sumConstraint.setResult(expression7, nonCommutativeRelationalBinaryExpression.getOperator(), true);
                    if (nonCommutativeRelationalBinaryExpression.getOperator() == 101 && !nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                        this.addToSubExpressions(expression3, expression7);
                    }
                    if (nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                        return this.reifyConstraint(sumConstraint);
                    }
                    return sumConstraint;
                }
                throw new TailorException("Internal error. Expected type atom or SumConstraint instead of " + expression + " of type: " + expression.getClass().getSimpleName());
            }
        }
        if (expression4 instanceof Multiplication) {
            expression3 = (Multiplication)expression4;
            expression2 = (Multiplication)((Multiplication)expression3).copy();
            ((Multiplication)expression2).setWillBeConverteredToProductConstraint(true);
            expression = (ProductConstraint)this.flattenMultiplication((Multiplication)expression2);
            ArithmeticAtomExpression arithmeticAtomExpression = null;
            if (this.hasCommonSubExpression(expression3)) {
                arithmeticAtomExpression = this.getCommonSubExpression(expression3);
            } else {
                arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (((Multiplication)expression3).isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(((Multiplication)expression3).getQuantifyingVariables(), ((Multiplication)expression3).getDefinedDomain()[0], ((Multiplication)expression3).getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(((Multiplication)expression3).getDefinedDomain()[0], ((Multiplication)expression3).getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(((Multiplication)expression3).getDomain()[0], ((Multiplication)expression3).getDomain()[1]));
                this.addToSubExpressions(expression3, arithmeticAtomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression.toString(), expression3);
                }
                ((ProductConstraint)expression).setResult(arithmeticAtomExpression);
                this.constraintBuffer.add(expression);
            }
            expression5.willBeFlattenedToVariable(this.targetSolver.supportsConstraintsNestedAsArgumentOf(nonCommutativeRelationalBinaryExpression.getOperator()));
            expression5 = this.flattenExpression(expression5);
            if (nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(new NonCommutativeRelationalBinaryExpression(arithmeticAtomExpression, nonCommutativeRelationalBinaryExpression.getOperator(), expression5));
            }
            return new NonCommutativeRelationalBinaryExpression(arithmeticAtomExpression, nonCommutativeRelationalBinaryExpression.getOperator(), expression5);
        }
        if (expression5 instanceof Multiplication) {
            expression3 = (Multiplication)expression5;
            expression2 = (Multiplication)((Multiplication)expression3).copy();
            ((Multiplication)expression2).setWillBeConverteredToProductConstraint(true);
            expression = (ProductConstraint)this.flattenMultiplication((Multiplication)expression2);
            ArithmeticAtomExpression arithmeticAtomExpression = null;
            if (this.hasCommonSubExpression(expression3)) {
                arithmeticAtomExpression = this.getCommonSubExpression(expression3);
            } else {
                arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (((Multiplication)expression3).isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(((Multiplication)expression3).getQuantifyingVariables(), ((Multiplication)expression3).getDefinedDomain()[0], ((Multiplication)expression3).getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(((Multiplication)expression3).getDefinedDomain()[0], ((Multiplication)expression3).getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(((Multiplication)expression3).getDomain()[0], ((Multiplication)expression3).getDomain()[1]));
                this.addToSubExpressions(expression3, arithmeticAtomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression.toString(), expression3);
                }
            }
            ((ProductConstraint)expression).setResult(arithmeticAtomExpression);
            this.constraintBuffer.add(expression);
            expression4.willBeFlattenedToVariable(this.targetSolver.supportsConstraintsNestedAsArgumentOf(nonCommutativeRelationalBinaryExpression.getOperator()));
            expression4 = this.flattenExpression(expression4);
            if (nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(new NonCommutativeRelationalBinaryExpression(expression4, nonCommutativeRelationalBinaryExpression.getOperator(), arithmeticAtomExpression));
            }
            return new NonCommutativeRelationalBinaryExpression(expression4, nonCommutativeRelationalBinaryExpression.getOperator(), arithmeticAtomExpression);
        }
        if (this.targetSolver.supportsFeature(268) && this.settings.getUseMinionReifyImply() && nonCommutativeRelationalBinaryExpression.getOperator() == 116 && expression5.getType() != 0 && expression4.getType() != 0) {
            expression4.willBeFlattenedToVariable(true);
            expression4 = this.flattenExpression(expression4);
            if (expression4.getType() == 0) {
                if (!((RelationalAtomExpression)expression4).getBool()) {
                    return new RelationalAtomExpression(true);
                }
                return this.flattenExpression(expression5);
            }
            if (!(expression4 instanceof RelationalAtomExpression)) {
                throw new TailorException("Type error. Cannot tailor implication '" + nonCommutativeRelationalBinaryExpression + "' when " + expression4 + " is not relational.");
            }
            if ((expression5 = this.flattenExpression(expression5)) instanceof SumConstraint && ((SumConstraint)expression5).getOperator() == 101 && this.targetSolver instanceof Minion) {
                if (!nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                    expression3 = (SumConstraint)expression5.copy();
                    ((SumConstraint)expression3).setOperator(104);
                    expression2 = (SumConstraint)expression5;
                    ((SumConstraint)expression2).setOperator(108);
                    expression = new Reification(expression2, (RelationalAtomExpression)expression4);
                    ((Reification)expression).setIsReifyImplied(true);
                    Reification reification = new Reification(expression3, (RelationalAtomExpression)expression4);
                    reification.setIsReifyImplied(true);
                    this.constraintBuffer.add(expression);
                    return reification;
                }
                expression5 = this.reifyConstraint(expression5);
            }
            expression3 = new Reification(expression5, (RelationalAtomExpression)expression4);
            ((Reification)expression3).setIsReifyImplied(true);
            if (nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(expression3);
            }
            return expression3;
        }
        expression4.willBeFlattenedToVariable(true);
        expression5.willBeFlattenedToVariable(true);
        if (expression5.getType() == 0 && nonCommutativeRelationalBinaryExpression.getOperator() == 116) {
            if (((RelationalAtomExpression)expression5).getBool()) {
                return new RelationalAtomExpression(true);
            }
            return this.flattenExpression(new Negation(expression4));
        }
        if (expression5.getType() == 3 && nonCommutativeRelationalBinaryExpression.getOperator() == 116) {
            int n = ((ArithmeticAtomExpression)expression5).getConstant();
            if (n == 1) {
                return new RelationalAtomExpression(true);
            }
            if (n == 0) {
                return this.flattenExpression(new Negation(expression4).evaluate());
            }
        }
        expression4 = this.flattenExpression(expression4);
        if ((expression4 = expression4.evaluate()).getType() == 0 && nonCommutativeRelationalBinaryExpression.getOperator() == 116) {
            if (!((RelationalAtomExpression)expression4).getBool()) {
                return new RelationalAtomExpression(true);
            }
            if (!nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                expression5.willBeFlattenedToVariable(false);
            }
            return this.flattenExpression(expression5);
        }
        if (expression4.getType() == 3 && nonCommutativeRelationalBinaryExpression.getOperator() == 116) {
            int n = ((ArithmeticAtomExpression)expression4).getConstant();
            if (n == 0) {
                return new RelationalAtomExpression(true);
            }
            if (n == 1) {
                if (!nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
                    expression5.willBeFlattenedToVariable(false);
                }
                return this.flattenExpression(expression5);
            }
        } else if (expression4.getCategory() <= 2 && nonCommutativeRelationalBinaryExpression.getOperator() == 116 && this.settings.isClassLevelTransformation() && !nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
            nonCommutativeRelationalBinaryExpression.setLeftExpression(expression4);
            expression5.willBeFlattenedToVariable(false);
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            int n = this.constraintBuffer.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.constraintBuffer.remove(0));
            }
            expression5 = this.flattenExpression(expression5);
            Expression[] expressionArray = new Expression[this.constraintBuffer.size() + 1];
            for (int i = 0; i < expressionArray.length - 1; ++i) {
                expressionArray[i] = this.constraintBuffer.get(i);
            }
            expressionArray[expressionArray.length - 1] = expression5;
            nonCommutativeRelationalBinaryExpression.setRightExpression(new Conjunction(expressionArray));
            this.constraintBuffer.clear();
            this.constraintBuffer = arrayList;
            return nonCommutativeRelationalBinaryExpression;
        }
        expression5 = this.flattenExpression(expression5);
        expression5 = expression5.evaluate();
        if (expression4.getType() == 3 && expression5.getType() == 3) {
            NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression2 = new NonCommutativeRelationalBinaryExpression(expression4, nonCommutativeRelationalBinaryExpression.getOperator(), expression5);
            return nonCommutativeRelationalBinaryExpression2.evaluate();
        }
        if (nonCommutativeRelationalBinaryExpression.isGonnaBeFlattenedToVariable()) {
            return this.reifyConstraint(new NonCommutativeRelationalBinaryExpression(expression4, nonCommutativeRelationalBinaryExpression.getOperator(), expression5));
        }
        return new NonCommutativeRelationalBinaryExpression(expression4, nonCommutativeRelationalBinaryExpression.getOperator(), expression5);
    }

    private Expression flattenCommutativeBinaryRelationalExpression(CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression) throws TailorException, Exception {
        int n;
        boolean bl;
        Object object;
        boolean bl2;
        Object object2;
        Object object3;
        Expression expression;
        if (commutativeBinaryRelationalExpression.getCategory() <= 2) {
            return commutativeBinaryRelationalExpression.evaluate();
        }
        commutativeBinaryRelationalExpression.orderExpression();
        Expression expression2 = commutativeBinaryRelationalExpression.getLeftArgument();
        Expression expression3 = commutativeBinaryRelationalExpression.getRightArgument();
        if (commutativeBinaryRelationalExpression.getType() == 101 && !commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
            this.addStrongEqualityToSubExpressions(expression2, expression3);
        }
        if (!(!this.settings.applyDirectVariableReusage() || commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || commutativeBinaryRelationalExpression.getOperator() != 101 && commutativeBinaryRelationalExpression.getOperator() != 115 || !(expression2 instanceof ArithmeticAtomExpression) && !(expression2 instanceof RelationalAtomExpression) || !(expression3 instanceof ArithmeticAtomExpression) && !(expression3 instanceof RelationalAtomExpression) || expression2.getType() == 3 || expression2.getType() == 0 || expression3.getType() == 3 || expression3.getType() == 0 || expression2.getType() == 22 && expression2 instanceof ArithmeticAtomExpression && ((ArrayVariable)((ArithmeticAtomExpression)expression2).getVariable()).isIndexedBySomethingNotConstant() || expression2.getType() == 22 && expression2 instanceof RelationalAtomExpression && ((ArrayVariable)((RelationalAtomExpression)expression2).getVariable()).isIndexedBySomethingNotConstant() || expression3.getType() == 22 && expression3 instanceof ArithmeticAtomExpression && ((ArrayVariable)((ArithmeticAtomExpression)expression3).getVariable()).isIndexedBySomethingNotConstant() || expression3.getType() == 22 && expression3 instanceof RelationalAtomExpression && ((ArrayVariable)((RelationalAtomExpression)expression3).getVariable()).isIndexedBySomethingNotConstant())) {
            expression3.willBeFlattenedToVariable(true);
            expression3 = this.flattenExpression(expression3);
            this.addToDirectlyEqualAtoms(expression3, expression2);
            return new RelationalAtomExpression(true);
        }
        if (!(commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || commutativeBinaryRelationalExpression.getOperator() != 115 && commutativeBinaryRelationalExpression.getOperator() != 101)) {
            if (this.hasCommonSubExpression(expression2)) {
                this.addToEqualExpressions(expression3, this.subExpressions.get(((Object)expression2).toString()));
            } else if (this.hasCommonSubExpression(expression3)) {
                this.addToEqualExpressions(expression2, this.subExpressions.get(((Object)expression3).toString()));
            }
        }
        if (expression3 instanceof QuantifiedSum || expression3 instanceof QuantifiedExpression) {
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator())) {
                expression3.willBeFlattenedToVariable(true);
            }
            if (expression3 instanceof QuantifiedSum) {
                expression3.willBeFlattenedToVariable(false);
            }
            expression3 = this.flattenExpression(expression3);
        }
        if (expression2 instanceof QuantifiedSum || expression2 instanceof QuantifiedExpression) {
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator())) {
                expression2.willBeFlattenedToVariable(true);
            }
            if (expression2 instanceof QuantifiedSum) {
                expression2.willBeFlattenedToVariable(false);
            }
            expression2 = this.flattenExpression(expression2);
        }
        if (expression3 instanceof Sum) {
            if (expression2 instanceof Sum && commutativeBinaryRelationalExpression.getOperator() == 100) {
                Expression expression4;
                ArithmeticExpression arithmeticExpression;
                ArithmeticAtomExpression arithmeticAtomExpression;
                if (this.targetSolver.supportsConstraint(252)) {
                    int n2;
                    int n3;
                    Sum sum = (Sum)expression2;
                    Sum sum2 = (Sum)expression3;
                    ArrayList<Expression> arrayList = sum.getPositiveArguments();
                    ArrayList<Expression> arrayList2 = sum.getNegativeArguments();
                    ArrayList<Expression> arrayList3 = sum2.getPositiveArguments();
                    ArrayList<Expression> arrayList4 = sum2.getNegativeArguments();
                    for (n3 = arrayList3.size() - 1; n3 >= 0; --n3) {
                        arrayList2.add(arrayList3.remove(n3));
                    }
                    for (n3 = arrayList4.size() - 1; n3 >= 0; --n3) {
                        arrayList.add(arrayList4.remove(n3));
                    }
                    Sum sum3 = new Sum(arrayList, arrayList2);
                    sum3.orderExpression();
                    sum3 = (Sum)sum3.evaluate();
                    sum3 = (Sum)sum3.restructure();
                    arrayList = sum3.getPositiveArguments();
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        arrayList.add(n2, this.flattenExpression(arrayList.remove(n2)));
                    }
                    arrayList2 = sum3.getNegativeArguments();
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        arrayList2.add(n2, this.flattenExpression(arrayList2.remove(n2)));
                    }
                    return new SumConstraint(arrayList, arrayList2, commutativeBinaryRelationalExpression.getOperator(), new ArithmeticAtomExpression(0));
                }
                Sum sum = (Sum)expression2;
                Sum sum4 = (Sum)expression3;
                if (this.hasCommonSubExpression(sum4)) {
                    arithmeticAtomExpression = this.getCommonSubExpression(sum4);
                } else {
                    arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (sum4.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(sum4.getQuantifyingVariables(), sum4.getDefinedDomain()[0], sum4.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(sum4.getDefinedDomain()[0], sum4.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(sum4.getDomain()[0], sum4.getDomain()[1]));
                    this.addToSubExpressions(sum4, arithmeticAtomExpression);
                    if (this.settings.getAuxVarDetails()) {
                        this.addToAuxVarList(((Object)arithmeticAtomExpression).toString(), sum4.copy());
                    }
                    arithmeticExpression = (Sum)sum4.copy();
                    ((Sum)arithmeticExpression).setWillBeConvertedToSumConstraint(true);
                    expression4 = (SumConstraint)this.flattenSum((Sum)arithmeticExpression);
                    ((SumConstraint)expression4).setResult(arithmeticAtomExpression, 101, true);
                    this.constraintBuffer.add(expression4);
                }
                if (this.hasCommonSubExpression(sum)) {
                    arithmeticExpression = this.getCommonSubExpression(sum);
                } else {
                    arithmeticExpression = this.settings.isClassLevelTransformation() ? (sum.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(sum.getQuantifyingVariables(), sum.getDefinedDomain()[0], sum.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(sum.getDefinedDomain()[0], sum.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(sum.getDomain()[0], sum.getDomain()[1]));
                    this.addToSubExpressions(sum, arithmeticExpression);
                    if (this.settings.getAuxVarDetails()) {
                        this.addToAuxVarList(arithmeticExpression.toString(), sum.copy());
                    }
                    expression4 = (Sum)sum.copy();
                    ((Sum)expression4).setWillBeConvertedToSumConstraint(true);
                    SumConstraint sumConstraint = (SumConstraint)this.flattenSum((Sum)expression4);
                    sumConstraint.setResult(arithmeticExpression, 101, true);
                    this.constraintBuffer.add(sumConstraint);
                }
                if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                    this.reifyConstraint(new CommutativeBinaryRelationalExpression(arithmeticExpression, 100, arithmeticAtomExpression));
                }
                return new CommutativeBinaryRelationalExpression(arithmeticExpression, 100, arithmeticAtomExpression);
            }
            expression3.reduceExpressionTree();
            Sum sum = (Sum)expression3;
            Sum sum5 = (Sum)sum.copy();
            sum5.setWillBeConvertedToSumConstraint(true);
            if (sum5.getCategory() <= 2) {
                expression2.willBeFlattenedToVariable(true);
                expression2 = this.flattenExpression(expression2);
                CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression2 = new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), sum5);
                if (!commutativeBinaryRelationalExpression.isNested()) {
                    commutativeBinaryRelationalExpression2.setIsNotNested();
                }
                if (commutativeBinaryRelationalExpression.getOperator() == 101 && !commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                    this.addToSubExpressions(sum, expression2);
                }
                if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                    return this.reifyConstraint(commutativeBinaryRelationalExpression2);
                }
                return commutativeBinaryRelationalExpression2;
            }
            SumConstraint sumConstraint = (SumConstraint)this.flattenSum(sum5);
            expression2.willBeFlattenedToVariable(true);
            Expression expression5 = this.flattenExpression(expression2);
            sumConstraint.setResult(expression5, commutativeBinaryRelationalExpression.getOperator(), true);
            if (!commutativeBinaryRelationalExpression.isNested()) {
                sumConstraint.setIsNotNested();
            }
            if (commutativeBinaryRelationalExpression.getOperator() == 101 && !commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                this.addToSubExpressions(sum, expression5);
            }
            if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(sumConstraint);
            }
            return sumConstraint;
        }
        if (expression2 instanceof Sum) {
            expression2.reduceExpressionTree();
            Sum sum = (Sum)expression2;
            Sum sum6 = (Sum)sum.copy();
            sum6.setWillBeConvertedToSumConstraint(true);
            SumConstraint sumConstraint = (SumConstraint)this.flattenSum(sum6);
            expression3.willBeFlattenedToVariable(true);
            Expression expression6 = this.flattenExpression(expression3);
            sumConstraint.setResult(expression6, commutativeBinaryRelationalExpression.getOperator(), false);
            if (commutativeBinaryRelationalExpression.getOperator() == 101 && !commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                this.addToSubExpressions(sum, expression6);
            }
            if (!commutativeBinaryRelationalExpression.isNested()) {
                sumConstraint.setIsNotNested();
            }
            if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(sumConstraint);
            }
            return sumConstraint;
        }
        if (expression2 instanceof Multiplication && expression2.getCategory() == 3) {
            Multiplication multiplication = (Multiplication)expression2;
            Multiplication multiplication2 = (Multiplication)multiplication.copy();
            multiplication2.setWillBeConverteredToProductConstraint(true);
            ProductConstraint productConstraint = (ProductConstraint)this.flattenMultiplication(multiplication2);
            if (commutativeBinaryRelationalExpression.getOperator() == 101 && !commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                expression3.willBeFlattenedToVariable(this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator()));
                expression3 = this.flattenExpression(expression3);
                if (!this.hasCommonSubExpression(multiplication)) {
                    this.addToSubExpressions(multiplication, expression3);
                }
                productConstraint.setResult(expression3);
                if (!commutativeBinaryRelationalExpression.isNested()) {
                    productConstraint.setIsNotNested();
                }
                if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                    return this.reifyConstraint(productConstraint);
                }
                return productConstraint;
            }
            ArithmeticAtomExpression arithmeticAtomExpression = null;
            if (this.hasCommonSubExpression(multiplication)) {
                arithmeticAtomExpression = this.getCommonSubExpression(multiplication);
            } else {
                if (commutativeBinaryRelationalExpression.getOperator() == 101) {
                    int n4;
                    if (!this.settings.isClassLevelTransformation()) {
                        int n5 = expression3.getDomain()[0];
                        n4 = expression3.getDomain()[1];
                        if (multiplication.getDomain()[0] > n5) {
                            n5 = multiplication.getDomain()[0];
                        }
                        if (multiplication.getDomain()[1] < n4) {
                            n4 = multiplication.getDomain()[1];
                        }
                        arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(n5, n4));
                    } else {
                        Expression[] expressionArray = expression3.getDefinedDomain();
                        if (expressionArray[0].getType() == 3 && expressionArray[1].getType() == 3) {
                            n4 = ((ArithmeticAtomExpression)expressionArray[0]).getConstant();
                            int n6 = ((ArithmeticAtomExpression)expressionArray[1]).getConstant();
                            if (multiplication.getDomain()[0] > n4) {
                                n4 = multiplication.getDomain()[0];
                            }
                            if (multiplication.getDomain()[1] < n6) {
                                n6 = multiplication.getDomain()[1];
                            }
                            arithmeticAtomExpression = multiplication.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), new ArithmeticAtomExpression(n4), new ArithmeticAtomExpression(n6))) : new ArithmeticAtomExpression(this.createAuxVariable(n4, n6));
                        } else {
                            arithmeticAtomExpression = multiplication.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1]));
                        }
                    }
                } else {
                    arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (multiplication.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getDomain()[0], multiplication.getDomain()[1]));
                }
                this.addToSubExpressions(multiplication, arithmeticAtomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression.toString(), multiplication);
                }
                productConstraint.setResult(arithmeticAtomExpression);
                this.constraintBuffer.add(productConstraint);
            }
            expression3.willBeFlattenedToVariable(this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator()));
            if (expression3 instanceof Multiplication) {
                Multiplication multiplication3 = (Multiplication)expression3;
                Multiplication multiplication4 = (Multiplication)multiplication3.copy();
                multiplication4.setWillBeConverteredToProductConstraint(true);
                ProductConstraint productConstraint2 = (ProductConstraint)this.flattenMultiplication(multiplication4);
                if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                    ArithmeticAtomExpression arithmeticAtomExpression2 = null;
                    if (this.hasCommonSubExpression(multiplication3)) {
                        arithmeticAtomExpression2 = this.getCommonSubExpression(multiplication3);
                    } else {
                        if (commutativeBinaryRelationalExpression.getOperator() == 101) {
                            if (!this.settings.isClassLevelTransformation()) {
                                int n7 = expression2.getDomain()[0];
                                int n8 = expression2.getDomain()[1];
                                if (multiplication3.getDomain()[0] > n7) {
                                    n7 = multiplication3.getDomain()[0];
                                }
                                if (multiplication3.getDomain()[1] < n8) {
                                    n8 = multiplication3.getDomain()[1];
                                }
                                arithmeticAtomExpression2 = new ArithmeticAtomExpression(this.createAuxVariable(n7, n8));
                            } else {
                                Expression[] expressionArray = expression2.getDefinedDomain();
                                if (expressionArray[0].getType() == 3 && expressionArray[1].getType() == 3) {
                                    int n9 = ((ArithmeticAtomExpression)expressionArray[0]).getConstant();
                                    int n10 = ((ArithmeticAtomExpression)expressionArray[1]).getConstant();
                                    if (multiplication3.getDomain()[0] > n9) {
                                        n9 = multiplication3.getDomain()[0];
                                    }
                                    if (multiplication3.getDomain()[1] < n10) {
                                        n10 = multiplication3.getDomain()[1];
                                    }
                                    arithmeticAtomExpression2 = multiplication3.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication3.getQuantifyingVariables(), new ArithmeticAtomExpression(n9), new ArithmeticAtomExpression(n10))) : new ArithmeticAtomExpression(this.createAuxVariable(n9, n10));
                                } else {
                                    arithmeticAtomExpression2 = multiplication3.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication3.getQuantifyingVariables(), multiplication3.getDefinedDomain()[0], multiplication3.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication3.getDefinedDomain()[0], multiplication3.getDefinedDomain()[1]));
                                }
                            }
                        } else {
                            arithmeticAtomExpression2 = this.settings.isClassLevelTransformation() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication3.getDefinedDomain()[0], multiplication3.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication3.getDomain()[0], multiplication3.getDomain()[1]));
                        }
                        this.addToSubExpressions(multiplication3, arithmeticAtomExpression2);
                        if (this.settings.getAuxVarDetails()) {
                            this.addToAuxVarList(arithmeticAtomExpression2.toString(), multiplication3.copy());
                        }
                        productConstraint2.setResult(arithmeticAtomExpression2);
                        this.constraintBuffer.add(productConstraint2);
                    }
                    return this.reifyConstraint(new CommutativeBinaryRelationalExpression(arithmeticAtomExpression, commutativeBinaryRelationalExpression.getOperator(), arithmeticAtomExpression2));
                }
                productConstraint2.setResult(arithmeticAtomExpression);
                if (!productConstraint2.isNested()) {
                    productConstraint.setIsNotNested();
                }
                if (!this.hasCommonSubExpression(multiplication3)) {
                    this.addToSubExpressions(multiplication3, arithmeticAtomExpression);
                }
                return productConstraint2;
            }
            expression3 = this.flattenExpression(expression3);
            if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(new CommutativeBinaryRelationalExpression(arithmeticAtomExpression, commutativeBinaryRelationalExpression.getOperator(), expression3));
            }
            return new CommutativeBinaryRelationalExpression(arithmeticAtomExpression, commutativeBinaryRelationalExpression.getOperator(), expression3);
        }
        if (expression3 instanceof Multiplication && expression3.getCategory() == 3) {
            Multiplication multiplication = (Multiplication)expression3;
            Multiplication multiplication5 = (Multiplication)multiplication.copy();
            multiplication5.setWillBeConverteredToProductConstraint(true);
            ProductConstraint productConstraint = (ProductConstraint)this.flattenMultiplication(multiplication5);
            if (commutativeBinaryRelationalExpression.getOperator() == 101 && !commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                expression2.willBeFlattenedToVariable(this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator()));
                expression2 = this.flattenExpression(expression2);
                if (!this.hasCommonSubExpression(multiplication)) {
                    this.addToSubExpressions(multiplication, expression2);
                }
                productConstraint.setResult(expression2);
                if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                    return this.reifyConstraint(productConstraint);
                }
                return productConstraint;
            }
            ArithmeticAtomExpression arithmeticAtomExpression = null;
            if (this.hasCommonSubExpression(multiplication)) {
                arithmeticAtomExpression = this.getCommonSubExpression(multiplication);
            } else {
                if (commutativeBinaryRelationalExpression.getOperator() == 101 && !this.settings.isClassLevelTransformation()) {
                    int n11 = expression2.getDomain()[0];
                    int n12 = expression2.getDomain()[1];
                    if (multiplication.getDomain()[0] > n11) {
                        n11 = multiplication.getDomain()[0];
                    }
                    if (multiplication.getDomain()[1] < n12) {
                        n12 = multiplication.getDomain()[1];
                    }
                    arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(n11, n12));
                } else {
                    arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (multiplication.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getDomain()[0], multiplication.getDomain()[1]));
                }
                this.addToSubExpressions(multiplication, arithmeticAtomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression.toString(), multiplication);
                }
            }
            productConstraint.setResult(arithmeticAtomExpression);
            this.constraintBuffer.add(productConstraint);
            expression2.willBeFlattenedToVariable(this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator()));
            expression2 = this.flattenExpression(expression2);
            if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), arithmeticAtomExpression));
            }
            return new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), arithmeticAtomExpression);
        }
        if (expression3 instanceof AbsoluteValue && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(42))) {
            return this.flattenDirectAbsoluteValue(expression2, expression3, commutativeBinaryRelationalExpression);
        }
        if (expression2 instanceof AbsoluteValue && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(42))) {
            return this.flattenDirectAbsoluteValue(expression3, expression2, commutativeBinaryRelationalExpression);
        }
        if (expression3 instanceof Minimum && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(120))) {
            return this.flattenDirectMinimum(expression2, expression3, commutativeBinaryRelationalExpression);
        }
        if (expression2 instanceof Minimum && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(120))) {
            return this.flattenDirectMinimum(expression3, expression2, commutativeBinaryRelationalExpression);
        }
        if (expression3 instanceof BinaryMinimum && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(120))) {
            return this.flattenDirectBinaryMinimum(expression2, (BinaryMinimum)expression3, commutativeBinaryRelationalExpression);
        }
        if (expression2 instanceof BinaryMinimum && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(120))) {
            return this.flattenDirectBinaryMinimum(expression3, (BinaryMinimum)expression2, commutativeBinaryRelationalExpression);
        }
        if (expression3 instanceof NonCommutativeArithmeticBinaryExpression && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(((NonCommutativeArithmeticBinaryExpression)expression3).getOperator()))) {
            NonCommutativeArithmeticBinaryExpression nonCommutativeArithmeticBinaryExpression = (NonCommutativeArithmeticBinaryExpression)expression3;
            Expression expression7 = nonCommutativeArithmeticBinaryExpression.getLeftArgument();
            Expression expression8 = nonCommutativeArithmeticBinaryExpression.getRightArgument();
            expression2.willBeFlattenedToVariable(true);
            if (this.hasCommonSubExpression(expression2)) {
                expression2 = this.getCommonSubExpression(expression2);
            } else {
                expression2 = this.flattenExpression(expression2);
                if (!commutativeBinaryRelationalExpression.isNested()) {
                    this.addToSubExpressions(expression3, expression2);
                }
            }
            expression7.willBeFlattenedToVariable(true);
            expression8.willBeFlattenedToVariable(true);
            expression7 = this.flattenExpression(expression7);
            expression8 = this.flattenExpression(expression8);
            Expression expression9 = new BinaryNonLinearConstraint(expression7, nonCommutativeArithmeticBinaryExpression.getOperator(), expression8, expression2);
            expression9 = expression9.evaluate();
            if (expression9 instanceof AtomExpression) {
                return expression9;
            }
            if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(expression9);
            }
            if (!commutativeBinaryRelationalExpression.isNested()) {
                expression9.setIsNotNested();
            }
            return expression9;
        }
        if (expression2 instanceof NonCommutativeArithmeticBinaryExpression && commutativeBinaryRelationalExpression.getOperator() == 101 && (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || this.targetSolver.supportsReificationOf(((NonCommutativeArithmeticBinaryExpression)expression3).getOperator()))) {
            NonCommutativeArithmeticBinaryExpression nonCommutativeArithmeticBinaryExpression = (NonCommutativeArithmeticBinaryExpression)expression2;
            Expression expression10 = nonCommutativeArithmeticBinaryExpression.getLeftArgument();
            Expression expression11 = nonCommutativeArithmeticBinaryExpression.getRightArgument();
            expression3.willBeFlattenedToVariable(true);
            if (this.hasCommonSubExpression(expression3)) {
                expression3 = this.getCommonSubExpression(expression3);
            } else {
                expression3 = this.flattenExpression(expression3);
                if (!commutativeBinaryRelationalExpression.isNested()) {
                    this.addToSubExpressions(expression2, expression3);
                }
            }
            expression10.willBeFlattenedToVariable(true);
            expression11.willBeFlattenedToVariable(true);
            expression10 = this.flattenExpression(expression10);
            expression11 = this.flattenExpression(expression11);
            BinaryNonLinearConstraint binaryNonLinearConstraint = new BinaryNonLinearConstraint(expression10, nonCommutativeArithmeticBinaryExpression.getOperator(), expression11, expression3);
            if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                this.constraintBuffer.add(binaryNonLinearConstraint);
                return expression3;
            }
            if (!commutativeBinaryRelationalExpression.isNested()) {
                binaryNonLinearConstraint.setIsNotNested();
            }
            return binaryNonLinearConstraint;
        }
        if (!this.targetSolver.supportsVariableArrayIndexing()) {
            if ((expression3.getType() == 22 || expression3.getType() == 6) && expression3 instanceof AtomExpression && (expression = (AtomExpression)expression3).getVariable() instanceof ArrayVariable) {
                object3 = (ArrayVariable)expression.getVariable();
                object2 = ((ArrayVariable)object3).getExpressionIndices();
                bl2 = true;
                if (object2 != null) {
                    object = new int[((Expression[])object2).length];
                    bl = true;
                    for (n = 0; n < ((Expression[])object2).length; ++n) {
                        object2[n].willBeFlattenedToVariable(true);
                        object2[n] = this.flattenExpression(object2[n]);
                        if (object2[n].getType() == 3) {
                            object[n] = ((ArithmeticAtomExpression)object2[n]).getConstant();
                        } else {
                            bl = false;
                        }
                        if (object2[n].getCategory() != 3) continue;
                        bl2 = false;
                    }
                    if (bl) {
                        ((ArrayVariable)object3).setIntIndices((int[])object);
                        expression.setVariable((Variable)object3);
                    } else if (bl2) {
                        ((ArrayVariable)object3).setExpressionIndices((Expression[])object2);
                        expression.setVariable((Variable)object3);
                    }
                }
                if (this.normalisedModel.constantArrays.containsKey(((ArrayVariable)object3).getArrayNameOnly())) {
                    expression3 = this.flattenAtomExpression((AtomExpression)expression);
                    if (expression2.getType() == 3 || expression2.getType() == 0) {
                        return new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), expression3).evaluate();
                    }
                } else if (((ArrayVariable)object3).isIndexedBySomethingNotConstant() && !this.settings.isClassLevelTransformation() || !bl2) {
                    if (this.hasCommonSubExpression((Expression)object3)) {
                        object = this.getCommonSubExpression((Expression)object3);
                        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator())) {
                            expression2.willBeFlattenedToVariable(true);
                        }
                        expression2 = this.flattenExpression(expression2);
                        CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression3 = new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), (Expression)object);
                        if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                            return this.reifyConstraint(commutativeBinaryRelationalExpression3);
                        }
                        return commutativeBinaryRelationalExpression3;
                    }
                    ((ArrayVariable)object3).setWillBeFlattenedToPartwiseElementConstraint(true);
                    object = this.flattenToPartwiseElementConstraint(expression.copy());
                    if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                        expression2.willBeFlattenedToVariable(true);
                    }
                    expression2 = this.flattenExpression(expression2);
                    Expression expression12 = new RelationalAtomExpression(true);
                    if (this.constraintBuffer.size() > 0) {
                        expression12 = this.constraintBuffer.get(this.constraintBuffer.size() - 1);
                    }
                    if ((commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() || commutativeBinaryRelationalExpression.getOperator() == 100) && expression2 instanceof AtomExpression && expression12 instanceof ElementConstraint && ((Object)((ElementConstraint)expression12).getValueExpression()).toString().equals(((Object)expression2).toString())) {
                        AtomExpression atomExpression;
                        boolean bl3 = expression instanceof RelationalAtomExpression;
                        if (this.hasCommonSubExpression(expression)) {
                            atomExpression = this.getCommonSubExpression(expression);
                        } else {
                            atomExpression = this.settings.isClassLevelTransformation() ? (expression.isQuantified() ? (bl3 ? new RelationalAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), expression.getDefinedDomain()[0], expression.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), expression.getDefinedDomain()[0], expression.getDefinedDomain()[1]))) : (bl3 ? new RelationalAtomExpression(this.createAuxVariable(expression.getDefinedDomain()[0], expression.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(expression.getDefinedDomain()[0], expression.getDefinedDomain()[1])))) : (bl3 ? new ArithmeticAtomExpression(this.createAuxVariable(expression.getDomain()[0], expression.getDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(expression.getDomain()[0], expression.getDomain()[1])));
                            this.addToSubExpressions(expression, atomExpression);
                            this.addToAuxVarList(atomExpression.toString(), expression);
                        }
                        ((ElementConstraint)object).setResultExpression(atomExpression);
                        this.constraintBuffer.add((Expression)object);
                        CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression4 = new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), atomExpression);
                        return this.reifyConstraint(commutativeBinaryRelationalExpression4);
                    }
                    if (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                        this.addToSubExpressions(expression, expression2);
                    }
                    ((ElementConstraint)object).setResultExpression(expression2);
                    if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                        return this.reifyConstraint((Expression)object);
                    }
                    return object;
                }
            }
        } else if ((expression2.getType() == 22 || expression2.getType() == 6) && !(expression3 instanceof SimpleArrayVariable) && expression2 instanceof AtomExpression) {
            expression = (AtomExpression)expression2;
            object3 = (ArrayVariable)expression.getVariable();
            object2 = ((ArrayVariable)object3).getExpressionIndices();
            bl2 = true;
            if (object2 != null) {
                object = new int[((Expression[])object2).length];
                bl = true;
                for (n = 0; n < ((Expression[])object2).length; ++n) {
                    object2[n] = this.flattenExpression(object2[n]);
                    if (object2[n].getType() == 3) {
                        object[n] = ((ArithmeticAtomExpression)object2[n]).getConstant();
                    } else {
                        bl = false;
                    }
                    if (object2[n].getCategory() != 3) continue;
                    bl2 = false;
                }
                if (bl) {
                    ((ArrayVariable)object3).setIntIndices((int[])object);
                    expression.setVariable((Variable)object3);
                } else if (bl2) {
                    ((ArrayVariable)object3).setExpressionIndices((Expression[])object2);
                    expression.setVariable((Variable)object3);
                }
            }
            if (this.normalisedModel.constantArrays.containsKey(((ArrayVariable)object3).getArrayNameOnly())) {
                expression2 = this.flattenAtomExpression((AtomExpression)expression);
            } else if (((ArrayVariable)object3).isIndexedBySomethingNotConstant() && !this.settings.isClassLevelTransformation() || !bl2) {
                ((ArrayVariable)object3).setWillBeFlattenedToPartwiseElementConstraint(true);
                object = this.flattenToPartwiseElementConstraint(expression.copy());
                if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                    expression3.willBeFlattenedToVariable(true);
                }
                expression3 = this.flattenExpression(expression3);
                this.addToSubExpressions(expression, expression3);
                ((ElementConstraint)object).setResultExpression(expression3);
                if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                    this.constraintBuffer.add((Expression)object);
                    return expression3;
                }
                return object;
            }
        }
        if (this.settings.useCommonSubExpressions() && (commutativeBinaryRelationalExpression.getType() == 101 || commutativeBinaryRelationalExpression.getType() == 115) && expression3 instanceof BinaryRelationalExpression) {
            if (!(expression2 instanceof AtomExpression)) {
                expression2.willBeFlattenedToVariable(true);
            }
            expression2 = this.flattenExpression(expression2);
            this.addToSubExpressions(expression3, expression2);
            expression3.willBeFlattenedToVariable(false);
            expression3 = this.flattenExpression(expression3);
            if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(expression3);
            }
            if (!(expression2 instanceof RelationalAtomExpression)) {
                return new Reification(expression3, ((ArithmeticAtomExpression)expression2).toRelationalAtomExpression());
            }
            return new Reification(expression3, (RelationalAtomExpression)expression2);
        }
        if ((commutativeBinaryRelationalExpression.getType() == 101 || commutativeBinaryRelationalExpression.getType() == 115) && (expression3 instanceof Conjunction || expression3 instanceof Disjunction) && expression2 instanceof AtomExpression) {
            expression2.willBeFlattenedToVariable(false);
            expression2 = this.flattenExpression(expression2);
            if (expression3 instanceof Conjunction) {
                expression = (Conjunction)expression3;
                object3 = ((Conjunction)expression).getArguments();
                for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                    ((Expression)((ArrayList)object3).get(i)).willBeFlattenedToVariable(true);
                    ((ArrayList)object3).add(i, this.flattenExpression((Expression)((ArrayList)object3).remove(i)));
                    ((Conjunction)expression).setArguments((ArrayList<Expression>)object3);
                }
                expression3 = expression;
            } else {
                expression3.willBeFlattenedToVariable(false);
                expression3 = this.flattenExpression(expression3);
            }
            if (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                if (expression2 instanceof RelationalAtomExpression) {
                    return new Reification(expression3, (RelationalAtomExpression)expression2);
                }
                return new Reification(expression3, ((ArithmeticAtomExpression)expression2).toRelationalAtomExpression());
            }
            if (expression2 instanceof ArithmeticAtomExpression) {
                expression2 = ((ArithmeticAtomExpression)expression2).toRelationalAtomExpression();
            }
            if (expression2 instanceof RelationalAtomExpression) {
                this.constraintBuffer.add(new Reification(expression3, (RelationalAtomExpression)expression2));
            } else if (expression2 instanceof RelationalAtomExpression) {
                this.constraintBuffer.add(new Reification(expression3, (RelationalAtomExpression)expression2));
            }
            return expression2;
        }
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(commutativeBinaryRelationalExpression.getOperator())) {
            expression2.willBeFlattenedToVariable(true);
            expression3.willBeFlattenedToVariable(true);
        }
        expression2 = this.hasCommonSubExpression(expression2) ? this.getCommonSubExpression(expression2) : this.flattenExpression(expression2);
        expression = new RelationalAtomExpression(true);
        if (this.constraintBuffer.size() > 0) {
            expression = this.constraintBuffer.remove(this.constraintBuffer.size() - 1);
        }
        boolean bl4 = true;
        if (!(expression instanceof Reification) || !((Reification)expression).getReifiedVariable().toString().equals(((Object)expression2).toString())) {
            this.constraintBuffer.add(expression);
            bl4 = false;
        }
        expression3 = this.flattenExpression(expression3);
        object2 = this.constraintBuffer.remove(this.constraintBuffer.size() - 1);
        bl2 = true;
        if (!(object2 instanceof Reification) || !((Reification)object2).getReifiedVariable().toString().equals(((Object)expression3).toString())) {
            this.constraintBuffer.add((Expression)object2);
            bl2 = false;
        }
        if (((Object)expression2).toString().equals(((Object)expression3).toString()) && (commutativeBinaryRelationalExpression.getOperator() == 101 || commutativeBinaryRelationalExpression.getOperator() == 115)) {
            if (bl4) {
                this.constraintBuffer.add(expression);
            }
            if (bl2) {
                this.constraintBuffer.add((Expression)object2);
            }
            return new RelationalAtomExpression(true);
        }
        if (!commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable() && (commutativeBinaryRelationalExpression.getType() == 101 || commutativeBinaryRelationalExpression.getType() == 115) && bl4 && bl2) {
            String string;
            object = (Reification)expression;
            Reification reification = (Reification)object2;
            String string2 = ((Reification)object).getReifiedVariable().toString();
            int n13 = string2.compareTo(string = reification.getReifiedVariable().toString());
            if (n13 != 0 && string2.startsWith("aux") && string.startsWith("aux")) {
                boolean bl5;
                boolean bl6 = bl5 = string2.length() < string.length();
                if (n13 < 0 || bl5) {
                    this.normalisedModel.deleteLastAuxVariable();
                    --this.noAuxVariables;
                    reification.setReifiedVariable(((Reification)object).getReifiedVariable());
                } else if (n13 > 0) {
                    this.normalisedModel.deleteLastAuxVariable();
                    --this.noAuxVariables;
                    ((Reification)object).setReifiedVariable(reification.getReifiedVariable());
                }
            } else if (n13 != 0 && string2.startsWith("aux")) {
                this.normalisedModel.deleteLastAuxVariable();
                --this.noAuxVariables;
                ((Reification)object).setReifiedVariable(reification.getReifiedVariable());
            } else if (n13 != 0 && string.startsWith("aux")) {
                this.normalisedModel.deleteLastAuxVariable();
                --this.noAuxVariables;
                reification.setReifiedVariable(((Reification)object).getReifiedVariable());
            }
            this.constraintBuffer.add((Expression)object);
            this.constraintBuffer.add(reification);
            this.addToSubExpressions(((Reification)object).getReifiedConstraint(), ((Reification)object).getReifiedVariable());
            this.addToSubExpressions(reification.getReifiedConstraint(), reification.getReifiedVariable());
            return new RelationalAtomExpression(true);
        }
        if (bl4 && bl2) {
            this.constraintBuffer.add(expression);
            this.constraintBuffer.add((Expression)object2);
        } else if (bl4) {
            this.constraintBuffer.add(expression);
        } else if (bl2) {
            this.constraintBuffer.add((Expression)object2);
        }
        if (expression2.getType() == 3 && expression3.getType() == 3) {
            return new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), expression3).evaluate();
        }
        if (expression2.getType() == 0 && expression3.getType() == 0) {
            return new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), expression3).evaluate();
        }
        if (expression2.getCategory() <= 2 && expression3.getCategory() <= 2) {
            return new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), expression3).evaluate();
        }
        if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
            return this.reifyConstraint(new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), expression3));
        }
        return new CommutativeBinaryRelationalExpression(expression2, commutativeBinaryRelationalExpression.getOperator(), expression3);
    }

    private Expression flattenDirectMinimum(Expression expression, Expression expression2, CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression) throws TailorException, Exception {
        Expression expression3 = ((Minimum)expression2).getArgument();
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(130) || commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
            expression.willBeFlattenedToVariable(true);
        }
        if (this.hasCommonSubExpression(expression)) {
            expression = this.getCommonSubExpression(expression);
        } else {
            expression = this.flattenExpression(expression);
            this.addToSubExpressions(expression2, expression);
        }
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(130)) {
            expression3.willBeFlattenedToVariable(true);
        }
        if (!this.hasCommonSubExpression(expression3 = this.flattenExpression(expression3))) {
            this.addToSubExpressions(expression3, expression);
        }
        if (!(expression3 instanceof Array)) {
            throw new TailorException("Invalid argument of " + expression2 + ": " + expression3 + " is not an array.");
        }
        MinimumConstraint minimumConstraint = new MinimumConstraint((Array)expression3, expression, ((Minimum)expression2).isMaximum());
        if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
            return this.reifyConstraint(minimumConstraint);
        }
        if (!commutativeBinaryRelationalExpression.isNested()) {
            minimumConstraint.setIsNotNested();
        }
        return minimumConstraint;
    }

    private Expression flattenDirectAbsoluteValue(Expression expression, Expression expression2, CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression) throws TailorException, Exception {
        Expression expression3 = ((AbsoluteValue)expression2).getArgument();
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(129) || commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
            expression.willBeFlattenedToVariable(true);
        }
        if (this.hasCommonSubExpression(expression)) {
            expression = this.getCommonSubExpression(expression);
        } else {
            expression = this.flattenExpression(expression);
            this.addToSubExpressions(expression2, expression);
        }
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(128)) {
            expression3.willBeFlattenedToVariable(true);
        }
        if (!this.hasCommonSubExpression(expression3 = this.flattenExpression(expression3))) {
            this.addToSubExpressions(expression3, expression);
        }
        AbsoluteConstraint absoluteConstraint = new AbsoluteConstraint(expression3, expression);
        if (commutativeBinaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
            return this.reifyConstraint(absoluteConstraint);
        }
        if (!commutativeBinaryRelationalExpression.isNested()) {
            absoluteConstraint.setIsNotNested();
        }
        return absoluteConstraint;
    }

    private Expression flattenQuantifiedSumPC(QuantifiedSum quantifiedSum) throws TailorException, Exception {
        Expression expression;
        if (quantifiedSum.isFlattened()) {
            return quantifiedSum;
        }
        Expression expression2 = quantifiedSum.getQuantifiedExpression();
        Domain domain = quantifiedSum.getQuantifiedDomain();
        String[] stringArray = quantifiedSum.getQuantifiedVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            expression = new ArithmeticAtomExpression(new SingleVariable(stringArray[i], domain.copy()));
            expression.setIsQuantifiedVariable(true);
            expression2 = expression2.replaceVariableWithExpression(stringArray[i], expression);
        }
        expression2 = expression2.reduceExpressionTree();
        expression2.orderExpression();
        expression2 = expression2.evaluate();
        if (expression2.getCategory() <= 1) {
            if (domain instanceof ExpressionRange) {
                Expression expression3 = ((ExpressionRange)domain).getLowerAndUpperBound()[0];
                expression = ((ExpressionRange)domain).getLowerAndUpperBound()[1];
                Expression expression4 = new Multiplication(new Expression[]{expression2, new Sum(new Expression[]{expression, new ArithmeticAtomExpression(1)}, new Expression[]{expression3})});
                expression4 = expression4.reduceExpressionTree();
                expression4 = expression4.evaluate();
                return expression4;
            }
            throw new TailorException("Cannot tailor quantified sum " + quantifiedSum + " on class-level, because the quantified domain is not a range, " + "but of type:" + domain.getClass().getSimpleName());
        }
        if (expression2 instanceof AtomExpression && ((AtomExpression)expression2).getVariable() != null && (((AtomExpression)expression2).getVariable() instanceof SingleVariable || ((AtomExpression)expression2).getVariable() instanceof ArrayVariable && ((ArrayVariable)((AtomExpression)expression2).getVariable()).getIntegerIndices() != null)) {
            expression2 = this.flattenAtomExpression((AtomExpression)expression2);
            if (domain instanceof ExpressionRange) {
                Expression expression5 = ((ExpressionRange)domain).getLowerAndUpperBound()[0];
                expression = ((ExpressionRange)domain).getLowerAndUpperBound()[1];
                Expression expression6 = new Multiplication(new Expression[]{expression2, new Sum(new Expression[]{expression, new ArithmeticAtomExpression(1)}, new Expression[]{expression5})});
                expression6 = expression6.reduceExpressionTree();
                expression6 = expression6.evaluate();
                return expression6;
            }
            throw new TailorException("Cannot tailor quantified sum " + quantifiedSum + " on class-level, because the quantified domain is not a range, " + "but of type:" + domain.getClass().getSimpleName());
        }
        expression2.willBeFlattenedToVariable(true);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < this.constraintBuffer.size(); ++i) {
            arrayList.add(this.constraintBuffer.remove(0));
        }
        expression2 = this.flattenExpression(expression2);
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        int n = this.constraintBuffer.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(this.constraintBuffer.remove(0));
        }
        this.constraintBuffer = arrayList;
        Expression expression7 = new Conjunction(arrayList2);
        if ((expression7 = expression7.evaluate()).getType() != 0) {
            QuantifiedExpression quantifiedExpression = new QuantifiedExpression(true, quantifiedSum.getQuantifiedVariables(), quantifiedSum.getQuantifiedDomain(), (Expression)new Conjunction(arrayList2));
            quantifiedExpression.setIsAlreadyFlattened(true);
            this.constraintBuffer.add(quantifiedExpression);
        } else if (!((RelationalAtomExpression)expression7).getBool()) {
            this.constraintBuffer.add(expression7);
        }
        quantifiedSum.setQuantifiedExpression(expression2);
        quantifiedSum.setIsFlattened(true);
        return quantifiedSum;
    }

    private Expression flattenQuantifiedSum(QuantifiedSum quantifiedSum) throws TailorException, Exception {
        Expression expression;
        if (this.targetSolver.supportsConstraint(201)) {
            return quantifiedSum;
        }
        Domain domain = quantifiedSum.getQuantifiedDomain();
        int n = domain.getType();
        if (n != 0 && n != 2 && n != 3 && n != 1) {
            if (this.settings.isClassLevelTransformation()) {
                return this.flattenQuantifiedSumPC(quantifiedSum);
            }
            throw new TailorException("Cannot unfold quantified expression '" + quantifiedSum + "'. The binding domain is not entirely constant:" + domain);
        }
        int[] nArray = null;
        nArray = n == 0 ? ((BoolDomain)domain).getFullDomain() : (n == 2 ? ((BoundedIntRange)domain).getFullDomain() : (n == 1 ? ((SingleIntRange)domain).getFullDomain() : ((SparseIntRange)domain).getFullDomain()));
        String[] stringArray = quantifiedSum.getQuantifiedVariables();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        ArrayList<Expression> arrayList2 = this.insertVariablesForValues(arrayList, nArray, quantifiedSum.getQuantifiedExpression());
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
        ArrayList<Expression> arrayList4 = new ArrayList<Expression>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            expression = arrayList2.get(i).evaluate();
            if ((expression = this.insertConstantArraysInExpression(expression)) instanceof UnaryMinus) {
                arrayList4.add(((UnaryMinus)expression).getArgument());
                continue;
            }
            arrayList3.add(expression);
        }
        Sum sum = new Sum(arrayList3, arrayList4);
        sum.orderExpression();
        expression = sum.evaluate();
        expression = expression.reduceExpressionTree();
        expression.orderExpression();
        if (!quantifiedSum.isNested()) {
            expression.setIsNotNested();
        }
        if (quantifiedSum.isGonnaBeFlattenedToVariable()) {
            expression.willBeFlattenedToVariable(true);
        }
        if (expression instanceof Sum) {
            return this.flattenSum((Sum)expression);
        }
        return this.flattenExpression(expression);
    }

    private Expression flattenElementConstraint(ElementConstraint elementConstraint) throws TailorException, Exception {
        boolean bl = !this.targetSolver.supportsConstraintsNestedAsArgumentOf(222);
        Expression[] expressionArray = elementConstraint.getArguments();
        for (int i = 0; i < expressionArray.length; ++i) {
            if (bl) {
                expressionArray[i].willBeFlattenedToVariable(true);
            }
            expressionArray[i] = this.flattenExpression(expressionArray[i]);
        }
        if (expressionArray.length != 3) {
            throw new TailorException("Internal error. Element constraint has less/more than 3 arguments.");
        }
        elementConstraint = new ElementConstraint(expressionArray[0], expressionArray[1], expressionArray[2]);
        if (elementConstraint.isGonnaBeFlattenedToVariable()) {
            this.constraintBuffer.add(elementConstraint);
            elementConstraint.willBeFlattenedToVariable(false);
            return elementConstraint.getValueExpression();
        }
        return elementConstraint;
    }

    private Expression matchSubDisjunction(ArrayList<Expression> arrayList, boolean bl, boolean bl2, boolean bl3) {
        Expression expression;
        Expression[] expressionArray = new Expression[arrayList.size() - 1];
        NaryRelationalExpression naryRelationalExpression = bl ? new Disjunction(arrayList.subList(0, arrayList.size() - 1).toArray(expressionArray)) : new Conjunction(arrayList.subList(0, arrayList.size() - 1).toArray(expressionArray));
        if (naryRelationalExpression.getArguments().size() >= 3 && this.hasCommonSubExpression(naryRelationalExpression)) {
            expression = this.getCommonSubExpression(naryRelationalExpression);
            int n = arrayList.size();
            for (int i = 0; i <= n - 2; ++i) {
                arrayList.remove(0);
            }
            arrayList.add(expression);
            this.noSimpleDisjunctionCSEs = bl ? ++this.noSimpleDisjunctionCSEs : ++this.noSimpleDisjunctionCSEs;
        }
        if (bl) {
            expression = new Disjunction(arrayList);
            ((Disjunction)expression).setIsNestedInDisjunction(bl2);
            ((NaryRelationalExpression)expression).willBeFlattenedToVariable(bl3);
            return expression;
        }
        expression = new Conjunction(arrayList);
        ((Conjunction)expression).setIsNestedInConjunction(bl2);
        ((Conjunction)expression).willBeFlattenedToVariable(bl3);
        return expression;
    }

    private Expression flattenDisjunction(Disjunction disjunction) throws TailorException, Exception {
        if (disjunction.getCategory() <= 2) {
            return disjunction;
        }
        ArrayList<Expression> arrayList = disjunction.getArguments();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Expression expression;
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(117) || this.targetSolver instanceof Gecode && !this.settings.getUseGecodeBooleanMinimodelPostConstraints()) {
                arrayList.get(i).willBeFlattenedToVariable(true);
            }
            Expression expression2 = arrayList.remove(i);
            expression2.willBeFlattenedToVariable(true);
            if (expression2 instanceof QuantifiedExpression && ((QuantifiedExpression)expression2).getType() == 203) {
                ((QuantifiedExpression)expression2).setIsNestedInDisjunction(true);
            }
            if ((expression = this.flattenExpression(expression2)).getType() == 0) {
                if (!((RelationalAtomExpression)expression).getBool()) continue;
                return new RelationalAtomExpression(true);
            }
            if (expression instanceof Disjunction) {
                ArrayList<Expression> arrayList2 = ((Disjunction)expression).getArguments();
                for (int j = 0; j < arrayList2.size(); ++j) {
                    arrayList.add(i, arrayList2.get(j));
                }
                continue;
            }
            arrayList.add(i, expression);
        }
        if (arrayList.size() == 0) {
            return new RelationalAtomExpression(false);
        }
        disjunction.setArguments(arrayList);
        if (this.settings.getUseSimpleDisjunctionCSE() && arrayList.size() >= 4) {
            disjunction = (Disjunction)this.matchSubDisjunction(arrayList, true, disjunction.isNestedInDisjunction(), disjunction.isGonnaBeFlattenedToVariable());
        }
        if (this.targetSolver.supportsConstraint(291)) {
            if (disjunction.isGonnaBeFlattenedToVariable() && !disjunction.isNestedInDisjunction()) {
                if (disjunction.getArguments().size() == 1) {
                    Expression expression = disjunction.getArguments().get(0);
                    expression.willBeFlattenedToVariable(true);
                    return this.flattenExpression(expression);
                }
                return this.reifyConstraint(disjunction);
            }
            return disjunction;
        }
        if (disjunction.isGonnaBeFlattenedToVariable()) {
            return this.reifyConstraint(this.flattenRelationalNaryToBinaryCommutativeExpressions(arrayList, null, 117));
        }
        return this.flattenRelationalNaryToBinaryCommutativeExpressions(arrayList, null, 117);
    }

    private Expression flattenConjunction(Conjunction conjunction) throws TailorException, Exception {
        Expression expression;
        int n;
        if (conjunction.getCategory() <= 2) {
            return conjunction;
        }
        if (conjunction.getArguments().size() == 1) {
            return this.flattenExpression(conjunction.getArguments().get(0));
        }
        conjunction.orderExpression();
        conjunction = (Conjunction)conjunction.reduceExpressionTree();
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        if (conjunction.isGonnaBeFlattenedToVariable() && this.hasEqualSubExpression(conjunction)) {
            arithmeticAtomExpression = this.getEqualSubExpression(conjunction);
        }
        ArrayList<Expression> arrayList = conjunction.getArguments();
        conjunction.orderExpression();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList2.add(n, arrayList.get(arrayList.size() - n - 1));
        }
        arrayList = arrayList2;
        for (n = arrayList.size() - 1; n >= 0; --n) {
            Object object;
            Expression expression2;
            if (conjunction.isGonnaBeFlattenedToVariable() && (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(118) || this.targetSolver instanceof Gecode && !this.settings.getUseGecodeBooleanMinimodelPostConstraints())) {
                arrayList.get(n).willBeFlattenedToVariable(true);
            }
            if (!conjunction.isNested()) {
                arrayList.get(n).setIsNotNested();
            }
            if ((expression2 = arrayList.remove(n)) instanceof QuantifiedExpression && ((QuantifiedExpression)(object = (QuantifiedExpression)expression2)).getType() == 202) {
                ((QuantifiedExpression)object).setIsNestedInConjunction(true);
            }
            if ((expression = this.flattenExpression(expression2).evaluate()).getType() == 0) {
                if (((RelationalAtomExpression)expression).getBool()) continue;
                return new RelationalAtomExpression(false);
            }
            if (expression instanceof Conjunction) {
                object = ((Conjunction)expression).getArguments();
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    arrayList.add(n, (Expression)((ArrayList)object).get(i));
                }
                continue;
            }
            arrayList.add(n, expression);
        }
        if (arrayList.size() == 0) {
            return new RelationalAtomExpression(true);
        }
        conjunction.setArguments(arrayList);
        if (conjunction.isGonnaBeFlattenedToVariable() && conjunction.isNestedInConjunction() && this.settings.getUseSimpleConjunctionCSE() && arrayList.size() >= 4) {
            conjunction = (Conjunction)this.matchSubDisjunction(arrayList, false, conjunction.isNestedInConjunction(), conjunction.isGonnaBeFlattenedToVariable());
        }
        if (!conjunction.isGonnaBeFlattenedToVariable() && !conjunction.isNested()) {
            for (n = arrayList.size() - 1; n > 0; --n) {
                expression = arrayList.remove(n);
                expression.orderExpression();
                this.constraintBuffer.add(expression);
            }
            if (arrayList.size() == 1) {
                return arrayList.remove(0);
            }
            return new RelationalAtomExpression(true);
        }
        if (!conjunction.isGonnaBeFlattenedToVariable() || conjunction.isNestedInConjunction()) {
            return conjunction;
        }
        if (conjunction.getArguments().size() == 1) {
            Expression expression3 = conjunction.getArguments().get(0);
            expression3.willBeFlattenedToVariable(true);
            return this.flattenExpression(expression3);
        }
        if (arithmeticAtomExpression != null && !this.hasEqualSubExpression(conjunction)) {
            this.addToEqualExpressions(conjunction, arithmeticAtomExpression);
        }
        if (this.targetSolver.supportsConstraint(292)) {
            return this.reifyConstraint(conjunction);
        }
        return this.reifyConstraint(this.flattenRelationalNaryToBinaryCommutativeExpressions(arrayList, null, 118));
    }

    private Expression flattenRelationalNaryToBinaryCommutativeExpressions(ArrayList<Expression> arrayList, Expression expression, int n) throws TailorException {
        if (arrayList.size() == 1 && expression == null) {
            return arrayList.remove(0);
        }
        Expression expression2 = arrayList.remove(0);
        Expression expression3 = null;
        expression3 = expression != null ? expression : arrayList.remove(0);
        System.out.println("Creating something with le:" + expression3 + " op re:" + expression2);
        if (arrayList.size() == 0) {
            return new CommutativeBinaryRelationalExpression(expression3, n, expression2);
        }
        CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression = new CommutativeBinaryRelationalExpression(expression3, n, expression2);
        RelationalAtomExpression relationalAtomExpression = this.reifyConstraint(commutativeBinaryRelationalExpression);
        return this.flattenRelationalNaryToBinaryCommutativeExpressions(arrayList, relationalAtomExpression, n);
    }

    private Expression flattenUnaryRelationalExpression(UnaryRelationalExpression unaryRelationalExpression) throws TailorException, Exception {
        Expression expression = unaryRelationalExpression.getArgument();
        if (unaryRelationalExpression.getType() == 41) {
            Expression expression2;
            Expression expression3;
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(41)) {
                expression.willBeFlattenedToVariable(true);
            }
            boolean bl = false;
            if (expression instanceof CommutativeBinaryRelationalExpression || expression instanceof NonCommutativeRelationalBinaryExpression) {
                expression3 = new Reification(expression, new RelationalAtomExpression(false));
                expression2 = ((Reification)expression3).evaluate();
                expression2.willBeFlattenedToVariable(false);
                expression2 = this.flattenExpression(expression2);
                bl = true;
            } else {
                if ((expression = this.flattenExpression(expression)) instanceof RelationalAtomExpression) {
                    ((RelationalAtomExpression)expression).setIsNegated(true);
                    return expression;
                }
                if (expression instanceof ArithmeticAtomExpression && expression.getDomain()[0] == 0 && expression.getDomain()[1] == 1) {
                    ((ArithmeticAtomExpression)expression).setIsNegated(true);
                    return expression;
                }
                expression2 = new CommutativeBinaryRelationalExpression(new ArithmeticAtomExpression(0), 101, expression);
            }
            if (unaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                expression3 = null;
                if (this.hasCommonSubExpression(expression2)) {
                    expression3 = this.getCommonSubExpression(expression2);
                } else if (this.hasEqualSubExpression(expression2)) {
                    expression3 = this.getEqualSubExpression(expression2);
                    this.addToSubExpressions(expression2, expression3);
                    this.constraintBuffer.add(new Reification(expression2, ((ArithmeticAtomExpression)expression3).toRelationalAtomExpression()));
                } else {
                    expression3 = this.settings.isClassLevelTransformation() ? (unaryRelationalExpression.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(unaryRelationalExpression.getQuantifyingVariables(), new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1))) : new ArithmeticAtomExpression(this.createAuxVariable(new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)))) : new ArithmeticAtomExpression(this.createAuxVariable(0, 1));
                    this.addToSubExpressions(unaryRelationalExpression, expression3);
                    if (this.settings.getAuxVarDetails()) {
                        this.addToAuxVarList(((ArithmeticAtomExpression)expression3).toString(), unaryRelationalExpression);
                    }
                    this.constraintBuffer.add(new Reification(expression2, ((ArithmeticAtomExpression)expression3).toRelationalAtomExpression()));
                }
                return ((ArithmeticAtomExpression)expression3).toRelationalAtomExpression();
            }
            if (bl) {
                return expression2;
            }
            return new Negation(expression2);
        }
        if (unaryRelationalExpression.getType() == 220) {
            if (!(expression instanceof Array)) {
                throw new TailorException("Internal error: flattening of argument of alldifferent, '" + expression + "' of type '" + expression.getClass().getSimpleName() + "' did not result in an array.");
            }
            Array array = (Array)expression;
            if (unaryRelationalExpression.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(new AllDifferent(array));
            }
            return new AllDifferent(array);
        }
        throw new TailorException("Unknown unary relational expression:" + unaryRelationalExpression);
    }

    private Expression flattenQuantifiedExpressionPC(QuantifiedExpression quantifiedExpression) throws TailorException, Exception {
        int n;
        int n2;
        if (quantifiedExpression.isAlreadyFlattened()) {
            return quantifiedExpression;
        }
        if (quantifiedExpression.getType() == 203) {
            throw new TailorException("Sorry, cannot tailor existential quantification, like " + quantifiedExpression + ", on problem class level yet.");
        }
        Expression expression = quantifiedExpression.getQuantifiedExpression();
        Domain domain = quantifiedExpression.getQuantifiedDomain();
        String[] stringArray = quantifiedExpression.getQuantifiedVariables();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            arrayList.add(stringArray[n2]);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ArithmeticAtomExpression arithmeticAtomExpression = new ArithmeticAtomExpression(new SingleVariable((String)arrayList.get(n2), domain.copy()));
            arithmeticAtomExpression.setIsQuantifiedVariable(true);
            expression = expression.replaceVariableWithExpression((String)arrayList.get(n2), arithmeticAtomExpression);
        }
        expression = expression.reduceExpressionTree();
        expression.orderExpression();
        expression = expression.evaluate();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        int n3 = this.constraintBuffer.size();
        for (int i = 0; i < n3; ++i) {
            arrayList2.add(0, this.constraintBuffer.remove(0));
        }
        expression = this.flattenExpression(expression);
        this.constraintBuffer.add(expression);
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
        n3 = this.constraintBuffer.size();
        for (n = 0; n < n3; ++n) {
            arrayList3.add(0, this.constraintBuffer.remove(0));
        }
        this.constraintBuffer = arrayList2;
        for (n = 0; n < arrayList3.size(); ++n) {
            Expression expression2 = (Expression)arrayList3.remove(n);
            if (expression2 instanceof Conjunction && !quantifiedExpression.isGonnaBeFlattenedToVariable()) {
                ArrayList<Expression> arrayList4 = ((Conjunction)expression2).getArguments();
                int n4 = arrayList4.size();
                for (int i = 0; i < n4; ++i) {
                    Expression expression3 = this.flattenExpression(arrayList4.remove(0));
                    expression3.orderExpression();
                    expression3 = expression3.evaluate();
                    expression3 = expression3.reduceExpressionTree();
                    if (!quantifiedExpression.isNested()) {
                        expression3.setIsNotNested();
                    }
                    arrayList3.add(n, expression3);
                }
                continue;
            }
            expression2.orderExpression();
            expression2 = expression2.evaluate();
            expression2 = expression2.reduceExpressionTree();
            expression2.willBeFlattenedToVariable(true);
            if (!quantifiedExpression.isNested()) {
                expression2.setIsNotNested();
            }
            arrayList3.add(n, expression2);
        }
        Conjunction conjunction = new Conjunction(arrayList3);
        if (quantifiedExpression.isNestedInConjunction()) {
            conjunction.setIsNestedInConjunction(true);
        }
        if (quantifiedExpression.isGonnaBeFlattenedToVariable()) {
            conjunction.willBeFlattenedToVariable(true);
        }
        if (!quantifiedExpression.isNested()) {
            conjunction.setIsNotNested();
        }
        quantifiedExpression.setQuantifiedExpression(conjunction);
        quantifiedExpression.setIsAlreadyFlattened(true);
        return quantifiedExpression;
    }

    private Expression flattenQuantifiedExpression(QuantifiedExpression quantifiedExpression) throws TailorException, Exception {
        int n;
        if (quantifiedExpression.getType() == 202 && this.targetSolver.supportsConstraint(202) && !quantifiedExpression.isGonnaBeFlattenedToVariable() && !this.settings.isClassLevelTransformation()) {
            return quantifiedExpression;
        }
        if (quantifiedExpression.getType() == 203 && this.targetSolver.supportsConstraint(203) && !quantifiedExpression.isGonnaBeFlattenedToVariable() && !this.settings.isClassLevelTransformation()) {
            return quantifiedExpression;
        }
        Expression expression = quantifiedExpression.copy();
        Domain domain = quantifiedExpression.getQuantifiedDomain();
        int n2 = domain.getType();
        if (n2 != 0 && n2 != 2 && n2 != 3 && n2 != 1) {
            if (this.settings.isClassLevelTransformation()) {
                return this.flattenQuantifiedExpressionPC(quantifiedExpression);
            }
            throw new TailorException("Cannot unfold quantified expression '" + quantifiedExpression + "'. The binding domain is not entirely constant:" + domain);
        }
        int[] nArray = null;
        nArray = n2 == 0 ? ((BoolDomain)domain).getFullDomain() : (n2 == 2 ? ((BoundedIntRange)domain).getFullDomain() : (n2 == 1 ? ((SingleIntRange)domain).getFullDomain() : ((SparseIntRange)domain).getFullDomain()));
        String[] stringArray = quantifiedExpression.getQuantifiedVariables();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        ArrayList<Expression> arrayList2 = this.insertVariablesForValues(arrayList, nArray, quantifiedExpression.getQuantifiedExpression());
        for (n = 0; n < arrayList2.size(); ++n) {
            Expression expression2 = arrayList2.remove(n);
            expression2 = this.insertConstantArraysInExpression(expression2);
            expression2.orderExpression();
            expression2 = expression2.reduceExpressionTree();
            expression2 = expression2.evaluate();
            arrayList2.add(n, expression2);
        }
        n = arrayList2.size();
        for (int i = n - 1; i >= 0; --i) {
            arrayList2.add(n - i - 1, arrayList2.remove(i));
        }
        if (quantifiedExpression.getType() == 202) {
            if (arrayList2.size() == 1) {
                Expression expression3 = arrayList2.remove(0);
                if (quantifiedExpression.isGonnaBeFlattenedToVariable()) {
                    expression3.willBeFlattenedToVariable(true);
                }
                return this.flattenExpression(expression3);
            }
            Conjunction conjunction = new Conjunction(arrayList2);
            conjunction.reduceExpressionTree();
            if (quantifiedExpression.isNestedInDisjunction()) {
                conjunction.setIsNestedInConjunction(true);
            }
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(118) && quantifiedExpression.isGonnaBeFlattenedToVariable()) {
                for (int i = conjunction.getArguments().size() - 1; i >= 0; --i) {
                    conjunction.getArguments().get(i).willBeFlattenedToVariable(true);
                }
            }
            if (quantifiedExpression.isNestedInConjunction()) {
                conjunction.setIsNestedInConjunction(true);
            }
            if (quantifiedExpression.isGonnaBeFlattenedToVariable()) {
                conjunction.willBeFlattenedToVariable(true);
            }
            if (!quantifiedExpression.isNested()) {
                conjunction.setIsNotNested();
            }
            if (conjunction.getArguments().size() == 1) {
                return this.flattenExpression(conjunction.getArguments().get(0));
            }
            return this.flattenConjunction(conjunction);
        }
        if (arrayList2.size() == 1) {
            Expression expression4 = arrayList2.remove(0);
            if (quantifiedExpression.isGonnaBeFlattenedToVariable()) {
                expression4.willBeFlattenedToVariable(true);
            }
            if (!quantifiedExpression.isNested()) {
                expression4.setIsNotNested();
            }
            return this.flattenExpression(expression4);
        }
        Disjunction disjunction = new Disjunction(arrayList2);
        disjunction.reduceExpressionTree();
        if (quantifiedExpression.isGonnaBeFlattenedToVariable()) {
            disjunction.willBeFlattenedToVariable(true);
        }
        if (!quantifiedExpression.isNested()) {
            disjunction.setIsNotNested();
        }
        if (quantifiedExpression.isNestedInDisjunction()) {
            disjunction.setIsNestedInDisjunction(true);
        }
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(117) && quantifiedExpression.isGonnaBeFlattenedToVariable()) {
            for (int i = disjunction.getArguments().size() - 1; i >= 0; --i) {
                disjunction.getArguments().get(i).willBeFlattenedToVariable(true);
            }
        }
        if (disjunction.getArguments().size() == 1) {
            return this.flattenExpression(disjunction.getArguments().get(0));
        }
        return this.flattenDisjunction(disjunction);
    }

    private ArrayList<Expression> insertVariablesForValues(ArrayList<String> arrayList, int[] nArray, Expression expression) throws TailorException, Exception {
        if (arrayList.size() == 1) {
            String string = arrayList.get(0);
            ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
            for (int i = 0; i < nArray.length; ++i) {
                Expression expression2 = expression.copy().insertValueForVariable(nArray[i], string);
                arrayList2.add(expression2);
            }
            return arrayList2;
        }
        String string = arrayList.remove(0);
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
        for (int i = 0; i < nArray.length; ++i) {
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList4.add(new String(arrayList.get(j)));
            }
            Expression expression3 = expression.copy().insertValueForVariable(nArray[i], string);
            ArrayList<Expression> arrayList5 = this.insertVariablesForValues(arrayList4, nArray, expression3);
            for (int j = 0; j < arrayList5.size(); ++j) {
                arrayList3.add(arrayList5.get(j));
            }
        }
        return arrayList3;
    }

    private Expression flattenNonCommArithm(NonCommutativeArithmeticBinaryExpression nonCommutativeArithmeticBinaryExpression) throws TailorException, Exception {
        Expression expression = nonCommutativeArithmeticBinaryExpression.getLeftArgument();
        Expression expression2 = nonCommutativeArithmeticBinaryExpression.getRightArgument();
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(nonCommutativeArithmeticBinaryExpression.getType())) {
            expression.willBeFlattenedToVariable(true);
            expression2.willBeFlattenedToVariable(true);
        }
        if (this.hasCommonSubExpression(nonCommutativeArithmeticBinaryExpression)) {
            ArithmeticAtomExpression arithmeticAtomExpression = this.getCommonSubExpression(nonCommutativeArithmeticBinaryExpression);
            return arithmeticAtomExpression;
        }
        expression = this.flattenExpression(expression);
        expression = expression.evaluate();
        expression2 = this.flattenExpression(expression2);
        expression2 = expression2.evaluate();
        Expression expression3 = new NonCommutativeArithmeticBinaryExpression(expression, nonCommutativeArithmeticBinaryExpression.getOperator(), expression2);
        if ((expression3 = expression3.evaluate()) instanceof AtomExpression) {
            return expression3;
        }
        ArithmeticAtomExpression arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (nonCommutativeArithmeticBinaryExpression.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(nonCommutativeArithmeticBinaryExpression.getQuantifyingVariables(), nonCommutativeArithmeticBinaryExpression.getDefinedDomain()[0], nonCommutativeArithmeticBinaryExpression.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(nonCommutativeArithmeticBinaryExpression.getDefinedDomain()[0], nonCommutativeArithmeticBinaryExpression.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(nonCommutativeArithmeticBinaryExpression.getDomain()[0], nonCommutativeArithmeticBinaryExpression.getDomain()[1]));
        this.addToSubExpressions(nonCommutativeArithmeticBinaryExpression, arithmeticAtomExpression);
        if (this.settings.getAuxVarDetails()) {
            this.addToAuxVarList(((Object)arithmeticAtomExpression).toString(), nonCommutativeArithmeticBinaryExpression);
        }
        BinaryNonLinearConstraint binaryNonLinearConstraint = new BinaryNonLinearConstraint(expression, nonCommutativeArithmeticBinaryExpression.getType(), expression2, arithmeticAtomExpression);
        this.constraintBuffer.add(binaryNonLinearConstraint);
        return arithmeticAtomExpression;
    }

    private Expression flattenMultiplication(Multiplication multiplication) throws TailorException, Exception {
        if (multiplication.getCategory() <= 2) {
            return multiplication;
        }
        ArrayList<Expression> arrayList = multiplication.getArguments();
        if (multiplication.willBeConvertedToProductConstraint()) {
            return this.flattenToPartWiseProductConstraint(multiplication);
        }
        if (this.targetSolver.supportsConstraint(290)) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Expression expression = arrayList.remove(i);
                if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(290)) {
                    expression.willBeFlattenedToVariable(true);
                }
                arrayList.add(i, this.flattenExpression(expression));
            }
            if (multiplication.isGonnaBeFlattenedToVariable()) {
                return this.reifyConstraint(multiplication);
            }
            return multiplication;
        }
        if (multiplication.isGonnaBeFlattenedToVariable()) {
            Expression expression;
            Multiplication multiplication2 = this.flattenToBinaryMultiplication(((Multiplication)multiplication.copy()).getArguments(), null);
            AtomExpression atomExpression = null;
            if (this.hasCommonSubExpression(multiplication2)) {
                atomExpression = this.getCommonSubExpression(multiplication2);
            } else {
                if (this.settings.isClassLevelTransformation()) {
                    expression = multiplication.getDefinedDomain()[0];
                    Expression expression2 = multiplication.getDefinedDomain()[1];
                    int n = multiplication.getDomain()[0];
                    int n2 = multiplication.getDomain()[1];
                    atomExpression = multiplication.isQuantified() ? (n == 0 && n2 == 1 ? new RelationalAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), expression, expression2)) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), expression, expression2))) : (n == 0 && n2 == 1 ? new RelationalAtomExpression(this.createAuxVariable(n, n2)) : new ArithmeticAtomExpression(this.createAuxVariable(expression, expression2)));
                } else {
                    int n = multiplication.getDomain()[0];
                    int n3 = multiplication.getDomain()[1];
                    atomExpression = n == 0 && n3 == 1 ? new RelationalAtomExpression(this.createAuxVariable(n, n3)) : new ArithmeticAtomExpression(this.createAuxVariable(n, n3));
                }
                this.addToSubExpressions(multiplication2, atomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(((Object)atomExpression).toString(), multiplication);
                }
            }
            expression = new ProductConstraint(new Expression[]{multiplication2.getArguments().get(0), multiplication2.getArguments().get(1)}, atomExpression);
            this.constraintBuffer.add(expression);
            return atomExpression;
        }
        return this.flattenToBinaryMultiplication(multiplication.getArguments(), null);
    }

    private Multiplication flattenToBinaryMultiplication(ArrayList<Expression> arrayList, Expression expression) throws TailorException, Exception {
        ArithmeticAtomExpression arithmeticAtomExpression;
        if (arrayList.size() == 2 && expression == null) {
            Expression expression2 = arrayList.remove(0);
            Expression expression3 = arrayList.remove(0);
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(280)) {
                if (expression2.getCategory() == 3) {
                    expression2.willBeFlattenedToVariable(true);
                }
                if (expression3.getCategory() == 3) {
                    expression3.willBeFlattenedToVariable(true);
                }
            }
            return new Multiplication(new Expression[]{this.flattenExpression(expression2), this.flattenExpression(expression3)});
        }
        if (arrayList.size() < 2 && expression == null) {
            throw new TailorException("Internal error: Cannot flatten product to binary sum with less than 2 arguments:" + arrayList.toString());
        }
        if (arrayList.size() >= 4) {
            ArithmeticAtomExpression arithmeticAtomExpression2;
            ProductConstraint productConstraint;
            ArithmeticAtomExpression arithmeticAtomExpression3;
            Multiplication multiplication;
            Expression expression4;
            ArithmeticAtomExpression arithmeticAtomExpression4;
            Multiplication multiplication2;
            Expression expression5 = arrayList.remove(0);
            Expression expression6 = arrayList.remove(0);
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(280)) {
                if (expression5.getCategory() == 3) {
                    expression5.willBeFlattenedToVariable(true);
                }
                if (expression6.getCategory() == 3) {
                    expression6.willBeFlattenedToVariable(true);
                }
            }
            if (this.hasCommonSubExpression(multiplication2 = new Multiplication(new Expression[]{expression5 = this.flattenExpression(expression5), expression6 = this.flattenExpression(expression6)}))) {
                arithmeticAtomExpression4 = this.getCommonSubExpression(multiplication2);
            } else {
                expression4 = new ProductConstraint(new Expression[]{expression5, expression6});
                if (this.settings.isClassLevelTransformation()) {
                    arithmeticAtomExpression4 = multiplication2.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication2.getQuantifyingVariables(), multiplication2.getDefinedDomain()[0], multiplication2.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication2.getDefinedDomain()[0], multiplication2.getDefinedDomain()[1]));
                } else {
                    int n = multiplication2.getDomain()[0];
                    int n2 = multiplication2.getDomain()[1];
                    arithmeticAtomExpression4 = new ArithmeticAtomExpression(this.createAuxVariable(n, n2));
                }
                this.addToSubExpressions(multiplication2, arithmeticAtomExpression4);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(((Object)arithmeticAtomExpression4).toString(), multiplication2);
                }
                ((ProductConstraint)expression4).setResult(arithmeticAtomExpression4);
                this.constraintBuffer.add(expression4);
            }
            expression4 = arrayList.remove(0);
            Expression expression7 = arrayList.remove(0);
            if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(280)) {
                expression4.willBeFlattenedToVariable(true);
                expression7.willBeFlattenedToVariable(true);
            }
            if (this.hasCommonSubExpression(multiplication = new Multiplication(new Expression[]{expression4 = this.flattenExpression(expression4), expression7 = this.flattenExpression(expression7)}))) {
                arithmeticAtomExpression3 = this.getCommonSubExpression(multiplication);
            } else {
                productConstraint = new ProductConstraint(new Expression[]{expression4, expression7});
                if (this.settings.isClassLevelTransformation()) {
                    arithmeticAtomExpression3 = multiplication.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1]));
                } else {
                    int n = multiplication.getDomain()[0];
                    int n3 = multiplication.getDomain()[1];
                    arithmeticAtomExpression3 = new ArithmeticAtomExpression(this.createAuxVariable(n, n3));
                }
                this.addToSubExpressions(multiplication, arithmeticAtomExpression3);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(((Object)arithmeticAtomExpression3).toString(), multiplication);
                }
                productConstraint.setResult(arithmeticAtomExpression3);
                this.constraintBuffer.add(productConstraint);
            }
            if (arrayList.size() == 0) {
                return new Multiplication(new Expression[]{arithmeticAtomExpression4, arithmeticAtomExpression3});
            }
            productConstraint = new ProductConstraint(new Expression[]{arithmeticAtomExpression4, arithmeticAtomExpression3});
            Multiplication multiplication3 = new Multiplication(new Expression[]{arithmeticAtomExpression4, arithmeticAtomExpression3});
            if (this.hasCommonSubExpression(multiplication3)) {
                arithmeticAtomExpression2 = this.getCommonSubExpression(multiplication3);
            } else {
                if (this.settings.isClassLevelTransformation()) {
                    arithmeticAtomExpression2 = multiplication3.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication3.getQuantifyingVariables(), multiplication3.getDefinedDomain()[0], multiplication3.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication3.getDefinedDomain()[0], multiplication3.getDefinedDomain()[1]));
                } else {
                    int n = multiplication3.getDomain()[0];
                    int n4 = multiplication3.getDomain()[1];
                    arithmeticAtomExpression2 = new ArithmeticAtomExpression(this.createAuxVariable(n, n4));
                }
                this.addToSubExpressions(multiplication3, arithmeticAtomExpression2);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression2.toString(), multiplication3);
                }
            }
            productConstraint.setResult(arithmeticAtomExpression2);
            this.constraintBuffer.add(productConstraint);
            return this.flattenToBinaryMultiplication(arrayList, arithmeticAtomExpression2);
        }
        Expression expression8 = null;
        expression8 = expression == null ? arrayList.remove(0) : expression;
        Expression expression9 = arrayList.remove(0);
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(280)) {
            expression8.willBeFlattenedToVariable(true);
            expression9.willBeFlattenedToVariable(true);
        }
        expression8 = this.flattenExpression(expression8);
        expression9 = this.flattenExpression(expression9);
        if (arrayList.size() == 0) {
            return new Multiplication(new Expression[]{expression8, expression9});
        }
        ProductConstraint productConstraint = new ProductConstraint(new Expression[]{expression8, expression9});
        Multiplication multiplication = new Multiplication(new Expression[]{expression8, expression9});
        if (this.hasCommonSubExpression(multiplication)) {
            arithmeticAtomExpression = this.getCommonSubExpression(multiplication);
        } else {
            if (this.settings.isClassLevelTransformation()) {
                arithmeticAtomExpression = multiplication.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getQuantifyingVariables(), multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(multiplication.getDefinedDomain()[0], multiplication.getDefinedDomain()[1]));
            } else {
                int n = multiplication.getDomain()[0];
                int n5 = multiplication.getDomain()[1];
                arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(n, n5));
            }
            this.addToSubExpressions(multiplication, arithmeticAtomExpression);
            if (this.settings.getAuxVarDetails()) {
                this.addToAuxVarList(arithmeticAtomExpression.toString(), multiplication);
            }
        }
        productConstraint.setResult(arithmeticAtomExpression);
        this.constraintBuffer.add(productConstraint);
        return this.flattenToBinaryMultiplication(arrayList, arithmeticAtomExpression);
    }

    private ProductConstraint flattenToPartWiseProductConstraint(Multiplication multiplication) throws TailorException, Exception {
        ArrayList<Expression> arrayList = multiplication.getArguments();
        if (this.targetSolver.supportsConstraint(290)) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(290)) {
                    arrayList.get(i).willBeFlattenedToVariable(true);
                }
                arrayList.add(i, this.flattenExpression(arrayList.remove(i)));
            }
            return new ProductConstraint(arrayList);
        }
        Multiplication multiplication2 = this.flattenToBinaryMultiplication(multiplication.getArguments(), null);
        return new ProductConstraint(new Expression[]{multiplication2.getArguments().remove(0), multiplication2.getArguments().remove(0)});
    }

    private Expression flattenSum(Sum sum) throws TailorException, Exception {
        if (sum.getCategory() <= 2) {
            if (sum.willBeConvertedToASumConstraint()) {
                return new SumConstraint(new Expression[]{sum}, new Expression[0]);
            }
            return sum;
        }
        sum = this.flattenQuantifiedSumArguments(sum);
        sum.reduceExpressionTree();
        Expression expression = sum.evaluate();
        if (expression.getType() == 3) {
            return expression;
        }
        if (sum.willBeConvertedToASumConstraint()) {
            return this.flattenSumPartToSumConstraint(sum);
        }
        if (!sum.isGonnaBeFlattenedToVariable()) {
            int n;
            if (sum.getPositiveArguments() != null) {
                for (n = 0; n < sum.getPositiveArguments().size(); ++n) {
                    sum.getPositiveArguments().add(n, this.flattenExpression(sum.getPositiveArguments().remove(n)));
                }
            }
            if (sum.getPositiveArguments() != null) {
                for (n = 0; n < sum.getNegativeArguments().size(); ++n) {
                    sum.getNegativeArguments().add(n, this.flattenExpression(sum.getNegativeArguments().remove(n)));
                }
            }
            return sum;
        }
        if (this.hasCommonSubExpression(sum)) {
            return this.getCommonSubExpression(sum);
        }
        SumConstraint sumConstraint = this.flattenSumPartToSumConstraint((Sum)sum.copy());
        if (sumConstraint.hasResult()) {
            throw new TailorException("Internal error: expect half empty sum constraint instead of:" + sumConstraint);
        }
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        if (this.settings.isClassLevelTransformation()) {
            arithmeticAtomExpression = sum.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(sum.getQuantifyingVariables(), sum.getDefinedDomain()[0], sum.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(sum.getDefinedDomain()[0], sum.getDefinedDomain()[1]));
        } else {
            int n = sum.getDomain()[0];
            int n2 = sum.getDomain()[1];
            arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(n, n2));
        }
        sumConstraint.setResult(arithmeticAtomExpression, 101, true);
        this.constraintBuffer.add(sumConstraint);
        this.addToSubExpressions(sum, arithmeticAtomExpression);
        if (this.settings.getAuxVarDetails()) {
            this.addToAuxVarList(arithmeticAtomExpression.toString(), sum);
        }
        return arithmeticAtomExpression;
    }

    private Sum flattenQuantifiedSumArguments(Sum sum) throws TailorException, Exception {
        Expression expression;
        int n;
        for (n = 0; n < sum.getNegativeArguments().size(); ++n) {
            if (!(sum.getNegativeArguments().get(n) instanceof QuantifiedSum)) continue;
            expression = sum.getNegativeArguments().remove(n);
            expression = this.flattenQuantifiedSum((QuantifiedSum)expression);
            sum.getNegativeArguments().add(n, expression);
        }
        for (n = 0; n < sum.getPositiveArguments().size(); ++n) {
            if (!(sum.getPositiveArguments().get(n) instanceof QuantifiedSum)) continue;
            expression = sum.getPositiveArguments().remove(n);
            expression = this.flattenQuantifiedSum((QuantifiedSum)expression);
            sum.getPositiveArguments().add(n, expression);
        }
        return sum;
    }

    private SumConstraint flattenSumPartToSumConstraint(Sum sum) throws TailorException, Exception {
        if (this.targetSolver.supportsConstraint(251)) {
            Multiplication multiplication;
            Expression expression;
            int n;
            Expression[] expressionArray = new Expression[sum.getPositiveArguments().size()];
            Expression[] expressionArray2 = new Expression[sum.getNegativeArguments().size()];
            boolean bl = !this.targetSolver.supportsConstraintsNestedAsArgumentOf(251);
            for (n = 0; n <= sum.getPositiveArguments().size() - 1; ++n) {
                expression = sum.getPositiveArguments().get(n);
                if (expression instanceof Multiplication && expression.getCategory() == 3) {
                    multiplication = (Multiplication)expression;
                    if (multiplication.isNonLinearMultiplication()) {
                        expression.willBeFlattenedToVariable(bl);
                    }
                    expressionArray[n] = this.flattenExpression(expression);
                    continue;
                }
                if (expression.getCategory() == 3) {
                    expression.willBeFlattenedToVariable(bl);
                    expressionArray[n] = this.flattenExpression(expression);
                    continue;
                }
                expressionArray[n] = expression;
            }
            for (n = 0; n <= sum.getNegativeArguments().size() - 1; ++n) {
                expression = sum.getNegativeArguments().get(n);
                if (expression instanceof Multiplication && expression.getCategory() == 3) {
                    multiplication = (Multiplication)expression;
                    if (multiplication.isNonLinearMultiplication()) {
                        expression.willBeFlattenedToVariable(bl);
                    }
                    expressionArray2[n] = this.flattenExpression(expression);
                    continue;
                }
                if (expression.getCategory() == 3) {
                    expression.willBeFlattenedToVariable(bl);
                    expressionArray2[n] = this.flattenExpression(expression);
                    continue;
                }
                expressionArray2[n] = expression;
            }
            return new SumConstraint(expressionArray, expressionArray2);
        }
        return this.flattenToBinarySumConstraint(sum);
    }

    private SumConstraint flattenToBinarySumConstraint(Sum sum) throws TailorException {
        Expression expression;
        Expression expression2;
        ArrayList<Expression> arrayList = sum.getPositiveArguments();
        ArrayList<Expression> arrayList2 = sum.getPositiveArguments();
        SumConstraint sumConstraint = null;
        if (arrayList.size() <= 0) {
            if (arrayList2.get(0) instanceof UnaryMinus) {
                arrayList2.add(0, ((UnaryMinus)arrayList2.remove(0)).getArgument());
            } else {
                arrayList2.add(0, new UnaryMinus(arrayList2.remove(0)));
            }
            return this.flattenSumToPartWiseBinarySumConstraint(arrayList2, null, false);
        }
        sumConstraint = this.flattenSumToPartWiseBinarySumConstraint(arrayList, null, true);
        if (arrayList2.size() == 0) {
            return sumConstraint;
        }
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        if (this.settings.isClassLevelTransformation()) {
            expression2 = sumConstraint.getSumDefinedDomain()[0];
            expression = sumConstraint.getSumDefinedDomain()[1];
            arithmeticAtomExpression = sumConstraint.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(sumConstraint.getQuantifyingVariables(), expression2, expression)) : new ArithmeticAtomExpression(this.createAuxVariable(expression2, expression));
        } else {
            int n = sumConstraint.getSumDomain()[0];
            int n2 = sumConstraint.getSumDomain()[1];
            arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(n, n2));
        }
        sumConstraint.setResult(arithmeticAtomExpression, 101, true);
        this.constraintBuffer.add(sumConstraint);
        expression2 = null;
        expression = this.flattenSumToPartWiseBinarySumConstraint(arrayList2, arithmeticAtomExpression, false);
        if (this.settings.isClassLevelTransformation()) {
            Expression expression3 = ((SumConstraint)expression).getSumDefinedDomain()[0];
            Expression expression4 = ((SumConstraint)expression).getSumDefinedDomain()[1];
            expression2 = ((SumConstraint)expression).isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(((SumConstraint)expression).getQuantifyingVariables(), expression3, expression4)) : new ArithmeticAtomExpression(this.createAuxVariable(expression3, expression4));
        } else {
            int n = ((SumConstraint)expression).getSumDomain()[0];
            int n3 = ((SumConstraint)expression).getSumDomain()[1];
            expression2 = new ArithmeticAtomExpression(this.createAuxVariable(n, n3));
        }
        sumConstraint.setResult(expression2, 101, true);
        this.constraintBuffer.add(expression);
        return new SumConstraint(new Expression[]{arithmeticAtomExpression}, new Expression[]{expression2});
    }

    private SumConstraint flattenSumToPartWiseBinarySumConstraint(ArrayList<Expression> arrayList, Expression expression, boolean bl) throws TailorException {
        Expression expression2;
        if (arrayList.size() == 2 && expression == null) {
            return bl ? new SumConstraint(new Expression[]{arrayList.remove(0), arrayList.remove(0)}, new Expression[0]) : new SumConstraint(new Expression[]{arrayList.remove(0)}, new Expression[]{arrayList.remove(0)});
        }
        if (arrayList.size() < 2 && expression == null) {
            throw new TailorException("Internal error: Cannot flatten sum to binary sum with less than 2 arguments:" + arrayList.toString());
        }
        Expression expression3 = null;
        expression3 = expression == null ? arrayList.remove(0) : expression;
        Sum sum = new Sum(new Expression[]{expression3, expression2 = arrayList.remove(0)}, new Expression[0]);
        if (this.hasCommonSubExpression(sum)) {
            ArithmeticAtomExpression arithmeticAtomExpression = this.getCommonSubExpression(sum);
            return this.flattenSumToPartWiseBinarySumConstraint(arrayList, arithmeticAtomExpression, bl);
        }
        SumConstraint sumConstraint = new SumConstraint(new Expression[]{expression3, expression2}, new Expression[0]);
        if (arrayList.size() == 0) {
            return sumConstraint;
        }
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        if (this.settings.isClassLevelTransformation()) {
            Expression expression4 = new Sum(new Expression[]{expression3.getDefinedDomain()[0], expression2.getDefinedDomain()[0]}, new Expression[0]);
            Expression expression5 = new Sum(new Expression[]{expression3.getDefinedDomain()[1], expression2.getDefinedDomain()[1]}, new Expression[0]);
            expression4 = expression4.evaluate();
            expression5 = expression5.evaluate();
            arithmeticAtomExpression = expression3.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(expression3.getQuantifyingVariables(), expression4, expression5)) : new ArithmeticAtomExpression(this.createAuxVariable(expression4, expression5));
        } else {
            int n = expression3.getDomain()[0] + expression2.getDomain()[0];
            int n2 = expression3.getDomain()[1] + expression2.getDomain()[1];
            arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(n, n2));
        }
        sumConstraint.setResult(arithmeticAtomExpression, 101, true);
        this.addToSubExpressions(arithmeticAtomExpression, sum);
        if (this.settings.getAuxVarDetails()) {
            this.addToAuxVarList(arithmeticAtomExpression.toString(), sum);
        }
        this.constraintBuffer.add(sumConstraint);
        return this.flattenSumToPartWiseBinarySumConstraint(arrayList, arithmeticAtomExpression, bl);
    }

    protected Expression flattenObjective() throws TailorException, Exception {
        Expression expression = this.normalisedModel.getObjectiveExpression();
        if (expression == null) {
            return expression;
        }
        if (this.targetSolver.supportsFeature(400)) {
            if (this.targetSolver.supportsFeature(401)) {
                return this.flattenExpression(expression);
            }
            expression.willBeFlattenedToVariable(true);
            return this.flattenExpression(expression);
        }
        throw new TailorException("Cannot tailor objective since target solver does not support it.");
    }

    private Expression flattenUnaryArithmeticExpression(UnaryArithmeticExpression unaryArithmeticExpression) throws TailorException, Exception {
        Expression expression = unaryArithmeticExpression.getArgument();
        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(unaryArithmeticExpression.getType())) {
            expression.willBeFlattenedToVariable(true);
        }
        expression = this.flattenExpression(expression);
        expression = expression.evaluate();
        if (unaryArithmeticExpression instanceof UnaryMinus) {
            if (unaryArithmeticExpression.isGonnaBeFlattenedToVariable() && unaryArithmeticExpression.getCategory() == 3) {
                ArithmeticAtomExpression arithmeticAtomExpression;
                UnaryMinus unaryMinus = new UnaryMinus(expression);
                if (this.hasCommonSubExpression(unaryMinus)) {
                    arithmeticAtomExpression = this.getCommonSubExpression(unaryMinus);
                } else {
                    arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (unaryMinus.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(unaryMinus.getQuantifyingVariables(), unaryMinus.getDefinedDomain()[0], unaryMinus.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(unaryMinus.getDefinedDomain()[0], unaryMinus.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(unaryMinus.getDomain()[0], unaryMinus.getDomain()[1]));
                    this.addToSubExpressions(unaryMinus, arithmeticAtomExpression);
                    if (this.settings.getAuxVarDetails()) {
                        this.addToAuxVarList(arithmeticAtomExpression.toString(), unaryMinus);
                    }
                }
                this.constraintBuffer.add(new CommutativeBinaryRelationalExpression(arithmeticAtomExpression, 101, unaryMinus));
                return arithmeticAtomExpression;
            }
            return new UnaryMinus(expression);
        }
        if (unaryArithmeticExpression instanceof AbsoluteValue) {
            if (unaryArithmeticExpression.isGonnaBeFlattenedToVariable()) {
                if (this.hasCommonSubExpression(unaryArithmeticExpression)) {
                    return this.getCommonSubExpression(unaryArithmeticExpression);
                }
                ArithmeticAtomExpression arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (unaryArithmeticExpression.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(unaryArithmeticExpression.getQuantifyingVariables(), unaryArithmeticExpression.getDefinedDomain()[0], unaryArithmeticExpression.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(unaryArithmeticExpression.getDefinedDomain()[0], unaryArithmeticExpression.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(unaryArithmeticExpression.getDomain()[0], unaryArithmeticExpression.getDomain()[1]));
                this.addToSubExpressions(unaryArithmeticExpression, arithmeticAtomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression.toString(), unaryArithmeticExpression);
                }
                this.constraintBuffer.add(new AbsoluteConstraint(expression, arithmeticAtomExpression));
                return arithmeticAtomExpression;
            }
            return new AbsoluteValue(expression);
        }
        if (unaryArithmeticExpression instanceof Minimum) {
            Minimum minimum = (Minimum)unaryArithmeticExpression;
            if (unaryArithmeticExpression.isGonnaBeFlattenedToVariable()) {
                if (this.hasCommonSubExpression(unaryArithmeticExpression)) {
                    return this.getCommonSubExpression(unaryArithmeticExpression);
                }
                ArithmeticAtomExpression arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (unaryArithmeticExpression.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(unaryArithmeticExpression.getQuantifyingVariables(), unaryArithmeticExpression.getDefinedDomain()[0], unaryArithmeticExpression.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(unaryArithmeticExpression.getDefinedDomain()[0], unaryArithmeticExpression.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(unaryArithmeticExpression.getDomain()[0], unaryArithmeticExpression.getDomain()[1]));
                this.addToSubExpressions(unaryArithmeticExpression, arithmeticAtomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression.toString(), unaryArithmeticExpression);
                }
                if (!(expression instanceof Array)) {
                    throw new TailorException("Internal error. Flattened array to " + expression + " that is not of type array but:" + expression.getClass().getName());
                }
                this.constraintBuffer.add(new MinimumConstraint((Array)expression, arithmeticAtomExpression, minimum.isMaximum()));
                return arithmeticAtomExpression;
            }
            return new Minimum(expression, minimum.isMaximum());
        }
        throw new TailorException("Unknown unary arithmetic constraint:" + unaryArithmeticExpression);
    }

    private Expression returnConstantArrayElement(ConstantArray constantArray, int[] nArray, Expression expression) throws NormaliserException, Exception {
        if (nArray.length == 1) {
            if (constantArray instanceof ConstantVector) {
                ConstantVector constantVector = (ConstantVector)constantArray;
                int n = this.normalisedModel.getOffsetFromZeroAt(constantVector.getArrayName(), 0);
                return new ArithmeticAtomExpression(constantVector.getElementAt(nArray[0] - n));
            }
            throw new TailorException("Illegal index dimensions of constant array element '" + expression + "' that dereferences the array '" + constantArray + "'.\nPlease make sure you have an index for every dimension of the array.");
        }
        if (nArray.length == 2) {
            if (constantArray instanceof ConstantMatrix) {
                ConstantMatrix constantMatrix = (ConstantMatrix)constantArray;
                int n = this.normalisedModel.getOffsetFromZeroAt(constantMatrix.getArrayName(), 0);
                int n2 = this.normalisedModel.getOffsetFromZeroAt(constantMatrix.getArrayName(), 1);
                return new ArithmeticAtomExpression(constantMatrix.getElementAt(nArray[0] - n, nArray[1] - n2));
            }
            throw new TailorException("Illegal index dimensions of constant array element '" + expression + "' that dereferences the array '" + constantArray + "'.\nPlease make sure you have an index for every dimension of the array.");
        }
        throw new TailorException("Cannot tailor constant elements with more than 2 dimensions yet, sorry:" + expression);
    }

    private Expression flattenAtomExpression(AtomExpression atomExpression) throws TailorException, Exception {
        if (this.applyStrongCopyPropagation && this.hasCommonSubExpression(atomExpression)) {
            return this.getCommonSubExpression(atomExpression);
        }
        if (atomExpression.getCategory() <= 2) {
            return atomExpression;
        }
        if (atomExpression instanceof SimpleArrayVariable || atomExpression instanceof SimpleVariable) {
            throw new TailorException("Unknown identifier: " + atomExpression);
        }
        if (atomExpression.getVariable().getType() == 14) {
            int n;
            ArrayVariable arrayVariable = (ArrayVariable)atomExpression.getVariable();
            Expression[] expressionArray = arrayVariable.getExpressionIndices();
            if (this.normalisedModel.constantArrays.containsKey(arrayVariable.getArrayNameOnly())) {
                ConstantArray constantArray = this.normalisedModel.constantArrays.get(arrayVariable.getArrayNameOnly());
                int[] nArray = null;
                if (expressionArray != null) {
                    nArray = new int[expressionArray.length];
                    boolean bl = true;
                    for (int i = 0; i < expressionArray.length; ++i) {
                        Expression expression = this.flattenExpression(expressionArray[i]).evaluate();
                        if (expression.getType() != 3) {
                            bl = false;
                            break;
                        }
                        nArray[i] = ((ArithmeticAtomExpression)expression).getConstant();
                    }
                    if (!bl) {
                        throw new TailorException("Could not tailor indexed constant array '" + atomExpression + "' to a constant, because not all indices could be derived to a constant value:" + expressionArray);
                    }
                } else {
                    nArray = arrayVariable.getIntegerIndices();
                }
                return this.returnConstantArrayElement(constantArray, nArray, atomExpression);
            }
            if (expressionArray == null) {
                return atomExpression;
            }
            int[] nArray = new int[expressionArray.length];
            boolean bl = true;
            boolean bl2 = true;
            for (n = 0; n < expressionArray.length; ++n) {
                expressionArray[n] = this.flattenExpression(expressionArray[n]).evaluate();
                if (expressionArray[n].getType() == 3) {
                    nArray[n] = ((ArithmeticAtomExpression)expressionArray[n]).getConstant();
                } else {
                    bl = false;
                }
                if (expressionArray[n].getCategory() != 3) continue;
                bl2 = false;
            }
            if (bl) {
                arrayVariable.setIntIndices(nArray);
                atomExpression.setVariable(arrayVariable);
                return atomExpression;
            }
            if (bl2) {
                arrayVariable.setExpressionIndices(expressionArray);
                atomExpression.setVariable(arrayVariable);
                return atomExpression;
            }
            if (this.targetSolver.supportsVariableArrayIndexing() && this.targetSolver.supportsFeature(55)) {
                for (n = 0; n < expressionArray.length; ++n) {
                    if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(300)) {
                        expressionArray[n].willBeFlattenedToVariable(true);
                    }
                    expressionArray[n] = this.flattenExpression(expressionArray[n]);
                }
                arrayVariable.setExpressionIndices(expressionArray);
                atomExpression.setVariable(arrayVariable);
                return atomExpression;
            }
            arrayVariable.setExpressionIndices(expressionArray);
            if (expressionArray.length == 1) {
                int n2;
                BasicDomain[] basicDomainArray;
                Domain[] domainArray;
                Expression expression = expressionArray[0];
                Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                if (!(domain instanceof ArrayDomain || domain instanceof ConstantArrayDomain || this.settings.isClassLevelTransformation())) {
                    throw new TailorException("Indexed variable '" + arrayVariable.getArrayNameOnly() + "' is not an array:" + atomExpression);
                }
                if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                    expression.willBeFlattenedToVariable(true);
                }
                expression = this.flattenExpression(expression);
                AtomExpression atomExpression2 = null;
                if (this.hasCommonSubExpression(atomExpression)) {
                    atomExpression2 = this.getCommonSubExpression(atomExpression);
                } else {
                    if (!(domain instanceof ConstantArrayDomain) && this.settings.isClassLevelTransformation()) {
                        domainArray = arrayVariable.getDefinedDomain()[0];
                        basicDomainArray = arrayVariable.getDefinedDomain()[1];
                        atomExpression2 = expression.isQuantified() ? (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), (Expression)domainArray, (Expression)basicDomainArray)) : new ArithmeticAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), (Expression)domainArray, (Expression)basicDomainArray))) : (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable((Expression)domainArray, (Expression)basicDomainArray)) : new ArithmeticAtomExpression(this.createAuxVariable((Expression)domainArray, (Expression)basicDomainArray)));
                    } else {
                        domainArray = ((ConstantArrayDomain)domain).getBaseDomain();
                        int n3 = domainArray.getRange()[0];
                        n2 = domainArray.getRange()[1];
                        atomExpression2 = expression.isQuantified() ? (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), new ArithmeticAtomExpression(n3), new ArithmeticAtomExpression(n2))) : new ArithmeticAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), new ArithmeticAtomExpression(n3), new ArithmeticAtomExpression(n2)))) : (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable(n3, n2)) : new ArithmeticAtomExpression(this.createAuxVariable(n3, n2)));
                    }
                    this.addToSubExpressions(atomExpression, atomExpression2);
                    if (this.settings.getAuxVarDetails()) {
                        this.addToAuxVarList(atomExpression2.toString(), atomExpression.copy());
                    }
                }
                domainArray = null;
                if (domain instanceof ArrayDomain) {
                    domainArray = ((ArrayDomain)domain).getIndexDomains();
                } else if (domain instanceof ConstantArrayDomain) {
                    domainArray = ((ConstantArrayDomain)domain).getIndexDomains();
                }
                basicDomainArray = new BasicDomain[domainArray.length];
                for (n2 = 0; n2 < domainArray.length; ++n2) {
                    if (!(domainArray[n2] instanceof BasicDomain)) {
                        throw new TailorException("Expected Basic Domain instead of :" + domainArray[n2]);
                    }
                    basicDomainArray[n2] = (BasicDomain)domainArray[n2];
                }
                SimpleArray simpleArray = new SimpleArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((MatrixDomain)domain).getBaseDomain());
                if (atomExpression.isGonnaBeFlattenedToVariable()) {
                    this.constraintBuffer.add(new ElementConstraint(simpleArray, expression, atomExpression2));
                    return atomExpression2;
                }
                return new ElementConstraint(simpleArray, expression, atomExpression2);
            }
            if (expressionArray.length == 2) {
                Expression expression = expressionArray[0].evaluate();
                Expression expression2 = expressionArray[1].evaluate();
                if (expression.getType() == 3) {
                    int n4 = ((ArithmeticAtomExpression)expression).getConstant();
                    Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    if ((domain = domain.evaluate()) instanceof MatrixDomain) {
                        BasicDomain[] basicDomainArray = new BasicDomain[]{new SingleIntRange(n4), (BasicDomain)((MatrixDomain)domain).getIndexDomains()[1]};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((MatrixDomain)domain).getBaseDomain());
                        AtomExpression atomExpression3 = null;
                        if (this.hasCommonSubExpression(atomExpression)) {
                            atomExpression3 = this.getCommonSubExpression(atomExpression);
                        } else {
                            if (!(domain instanceof ConstantArrayDomain)) {
                                if (!this.settings.isClassLevelTransformation()) {
                                    throw new TailorException("Cannot index array element '" + atomExpression + "' because the indexed variable's domain '" + domain + "' is not a constant array domain.");
                                }
                                Expression expression3 = arrayVariable.getDefinedDomain()[0];
                                Expression expression4 = arrayVariable.getDefinedDomain()[1];
                                atomExpression3 = expression2.isQuantified() ? (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable(expression2.getQuantifyingVariables(), expression3, expression4)) : new ArithmeticAtomExpression(this.createAuxVariable(expression2.getQuantifyingVariables(), expression3, expression4))) : (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable(expression3, expression4)) : new ArithmeticAtomExpression(this.createAuxVariable(expression3, expression4)));
                            } else {
                                ConstantDomain constantDomain = ((ConstantArrayDomain)domain).getBaseDomain();
                                int n5 = constantDomain.getRange()[0];
                                int n6 = constantDomain.getRange()[1];
                                atomExpression3 = expression2.isQuantified() ? (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable(expression2.getQuantifyingVariables(), new ArithmeticAtomExpression(n5), new ArithmeticAtomExpression(n6))) : new ArithmeticAtomExpression(this.createAuxVariable(expression2.getQuantifyingVariables(), new ArithmeticAtomExpression(n5), new ArithmeticAtomExpression(n6)))) : (atomExpression instanceof RelationalAtomExpression ? new RelationalAtomExpression(this.createAuxVariable(n5, n6)) : new ArithmeticAtomExpression(this.createAuxVariable(n5, n6)));
                            }
                            this.addToSubExpressions(atomExpression, atomExpression3);
                            if (this.settings.getAuxVarDetails()) {
                                this.addToAuxVarList(atomExpression3.toString(), atomExpression.copy());
                            }
                        }
                        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression2.willBeFlattenedToVariable(true);
                        }
                        expression2 = this.flattenExpression(expression2);
                        if (atomExpression.isGonnaBeFlattenedToVariable()) {
                            this.constraintBuffer.add(new ElementConstraint(indexedArray, expression2, atomExpression3));
                            return atomExpression3;
                        }
                        return new ElementConstraint(indexedArray, expression2, atomExpression3);
                    }
                    throw new TailorException("Cannot flatten expression '" + atomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not an array domain.");
                }
                if (expression2.getType() == 3) {
                    int n7 = ((ArithmeticAtomExpression)expression2).getConstant();
                    Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    if ((domain = domain.evaluate()) instanceof MatrixDomain) {
                        BasicDomain[] basicDomainArray = new BasicDomain[]{(BasicDomain)((MatrixDomain)domain).getIndexDomains()[0], new SingleIntRange(n7)};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((MatrixDomain)domain).getBaseDomain());
                        if (!(expression instanceof AtomExpression) && !this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression.willBeFlattenedToVariable(true);
                        }
                        expression = this.flattenExpression(expression);
                        ArithmeticAtomExpression arithmeticAtomExpression = null;
                        if (this.hasCommonSubExpression(atomExpression)) {
                            arithmeticAtomExpression = this.getCommonSubExpression(atomExpression);
                        } else {
                            if (!(domain instanceof ConstantArrayDomain)) {
                                if (!this.settings.isClassLevelTransformation()) {
                                    throw new TailorException("Cannot index array element '" + atomExpression + "' because the indexed variable's domain '" + domain + "' is not a constant array domain.");
                                }
                                Expression expression5 = arrayVariable.getDefinedDomain()[0];
                                Expression expression6 = arrayVariable.getDefinedDomain()[1];
                                arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(expression5, expression6));
                            } else {
                                ConstantDomain constantDomain = ((ConstantArrayDomain)domain).getBaseDomain();
                                int n8 = constantDomain.getRange()[0];
                                int n9 = constantDomain.getRange()[1];
                                arithmeticAtomExpression = new ArithmeticAtomExpression(this.createAuxVariable(n8, n9));
                            }
                            this.addToSubExpressions(atomExpression, arithmeticAtomExpression);
                            if (this.settings.getAuxVarDetails()) {
                                this.addToAuxVarList(arithmeticAtomExpression.toString(), atomExpression.copy());
                            }
                        }
                        if (atomExpression.isGonnaBeFlattenedToVariable()) {
                            this.constraintBuffer.add(new ElementConstraint(indexedArray, expression, arithmeticAtomExpression));
                            return arithmeticAtomExpression;
                        }
                        return new ElementConstraint(indexedArray, expression, arithmeticAtomExpression);
                    }
                    throw new TailorException("Cannot flatten expression '" + atomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not constant.");
                }
            } else {
                throw new TailorException("Cannot tailor 3-dimensional array " + arrayVariable + " with non-constant indices yet, sorry.");
            }
        }
        return atomExpression;
    }

    private ElementConstraint flattenToPartwiseElementConstraint(Expression expression) throws TailorException, Exception {
        if (expression instanceof AtomExpression) {
            AtomExpression atomExpression = (AtomExpression)expression;
            ArrayVariable arrayVariable = (ArrayVariable)atomExpression.getVariable();
            Expression[] expressionArray = arrayVariable.getExpressionIndices();
            if (this.normalisedModel.constantArrays.containsKey(arrayVariable.getArrayNameOnly())) {
                throw new TailorException("Cannot tailor constant elements that are indexed by decision variables :" + atomExpression);
            }
            if (expressionArray.length == 1) {
                Expression expression2 = expressionArray[0];
                if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                    expression2.willBeFlattenedToVariable(true);
                }
                expression2 = this.flattenExpression(expression2);
                Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                if (!(domain instanceof ArrayDomain) && !(domain instanceof ConstantArrayDomain)) {
                    throw new TailorException("Indexed variable '" + arrayVariable.getArrayNameOnly() + "' is not an array:" + atomExpression);
                }
                Domain[] domainArray = domain instanceof ArrayDomain ? ((ArrayDomain)domain).getIndexDomains() : ((ConstantArrayDomain)domain).getIndexDomains();
                BasicDomain[] basicDomainArray = new BasicDomain[domainArray.length];
                for (int i = 0; i < domainArray.length; ++i) {
                    if (!(domainArray[i] instanceof BasicDomain)) {
                        throw new TailorException("");
                    }
                    basicDomainArray[i] = (BasicDomain)domainArray[i];
                }
                SimpleArray simpleArray = null;
                simpleArray = domain instanceof ConstantArrayDomain ? new SimpleArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ConstantArrayDomain)domain).getBaseDomain()) : new SimpleArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ArrayDomain)domain).getBaseDomain());
                return new ElementConstraint(simpleArray, expression2);
            }
            if (expressionArray.length == 2) {
                Expression expression3 = expressionArray[0].evaluate();
                Expression expression4 = expressionArray[1].evaluate();
                if (expression3.getType() == 3 || expression3.getCategory() == 2 && this.settings.isClassLevelTransformation()) {
                    Expression expression5 = null;
                    int n = 0;
                    if (expression3.getType() != 3) {
                        expression5 = expression3;
                    } else {
                        n = ((ArithmeticAtomExpression)expression3).getConstant();
                    }
                    Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    domain = domain.evaluate();
                    if (domain instanceof ConstantArrayDomain) {
                        int n2 = this.normalisedModel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), 0);
                        if (expression5 == null) {
                            n -= n2;
                        } else {
                            expression5 = new Sum(new Expression[]{expression5.copy()}, new Expression[]{new ArithmeticAtomExpression(n2)});
                        }
                        BasicDomain[] basicDomainArray = new BasicDomain[]{expression5 == null ? new SingleIntRange(n) : new SingleExpressionRange(expression5), ((ConstantArrayDomain)domain).getIndexDomains()[1]};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ConstantArrayDomain)domain).getBaseDomain());
                        expression4 = new Sum(new Expression[]{expression4}, new Expression[]{new ArithmeticAtomExpression(n2)});
                        expression4 = expression4.evaluate();
                        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression4.willBeFlattenedToVariable(true);
                        }
                        expression4 = this.flattenExpression(expression4);
                        return new ElementConstraint(indexedArray, expression4);
                    }
                    if (domain instanceof ArrayDomain) {
                        int n3 = this.normalisedModel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), 0);
                        if (expression5 == null) {
                            n -= n3;
                        } else {
                            expression5 = new Sum(new Expression[]{expression5.copy()}, new Expression[]{new ArithmeticAtomExpression(n3)});
                        }
                        BasicDomain[] basicDomainArray = new BasicDomain[]{expression5 == null ? new SingleIntRange(n) : new SingleExpressionRange(expression5), (BasicDomain)((ArrayDomain)domain).getIndexDomains()[1]};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ArrayDomain)domain).getBaseDomain());
                        expression4 = new Sum(new Expression[]{expression4}, new Expression[]{new ArithmeticAtomExpression(n3)});
                        expression4 = expression4.evaluate();
                        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression4.willBeFlattenedToVariable(true);
                        }
                        expression4 = this.flattenExpression(expression4);
                        return new ElementConstraint(indexedArray, expression4);
                    }
                    throw new TailorException("Cannot flatten expression '" + atomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not constant.");
                }
                if (expression4.getType() == 3 || expression4.getCategory() == 2 && this.settings.isClassLevelTransformation()) {
                    int n = 0;
                    Expression expression6 = null;
                    if (expression4.getType() == 3) {
                        n = ((ArithmeticAtomExpression)expression4).getConstant();
                    } else {
                        expression6 = expression4;
                    }
                    Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    domain = domain.evaluate();
                    if (domain instanceof ConstantArrayDomain) {
                        int n4 = this.normalisedModel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), 1);
                        BasicDomain[] basicDomainArray = new BasicDomain[]{((ConstantArrayDomain)domain).getIndexDomains()[0], new SingleIntRange(n -= n4)};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ConstantArrayDomain)domain).getBaseDomain());
                        expression3 = new Sum(new Expression[]{expression3}, new Expression[]{new ArithmeticAtomExpression(n4)});
                        if (!((expression3 = expression3.evaluate()) instanceof AtomExpression) && !this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression3.willBeFlattenedToVariable(true);
                        }
                        expression3 = this.flattenExpression(expression3);
                        return new ElementConstraint(indexedArray, expression3);
                    }
                    if (domain instanceof ArrayDomain) {
                        int n5 = this.normalisedModel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), 1);
                        if (expression6 == null) {
                            n -= n5;
                        } else {
                            expression6 = new Sum(new Expression[]{expression6.copy()}, new Expression[]{new ArithmeticAtomExpression(n5)});
                        }
                        BasicDomain[] basicDomainArray = new BasicDomain[]{(BasicDomain)((ArrayDomain)domain).getIndexDomains()[0], expression6 == null ? new SingleIntRange(n) : new SingleExpressionRange(expression6)};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ArrayDomain)domain).getBaseDomain());
                        expression3 = new Sum(new Expression[]{expression3}, new Expression[]{new ArithmeticAtomExpression(n5)});
                        expression3 = expression3.evaluate();
                        if (!(expression3 instanceof AtomExpression) && !this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression3.willBeFlattenedToVariable(true);
                        }
                        expression3 = this.flattenExpression(expression3);
                        return new ElementConstraint(indexedArray, expression3);
                    }
                    throw new TailorException("Cannot flatten expression '" + atomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not constant.");
                }
                Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                if ((domain = domain.evaluate()) instanceof ConstantArrayDomain) {
                    if (domain instanceof ConstantArrayDomain) {
                        SimpleArray simpleArray = new SimpleArray(arrayVariable.getArrayNameOnly(), ((ConstantArrayDomain)domain).getIndexDomains(), ((ConstantArrayDomain)domain).getBaseDomain());
                        int n = ((ConstantArrayDomain)domain).getIndexDomains()[1].getRange()[1] - ((ConstantArrayDomain)domain).getIndexDomains()[1].getRange()[0] + 1;
                        Sum sum = new Sum(new Expression[]{new Multiplication(new Expression[]{new ArithmeticAtomExpression(n), expression3}), expression4}, new Expression[0]);
                        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            sum.willBeFlattenedToVariable(true);
                        }
                        Expression expression7 = this.flattenExpression(sum);
                        simpleArray.setWillBeFlattenedToVector(true);
                        return new ElementConstraint(simpleArray, expression7);
                    }
                    throw new TailorException("Cannot flatten expression '" + atomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not constant.");
                }
                throw new TailorException("Cannot flatten expression '" + atomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not constant.");
            }
            if (expressionArray.length == 3) {
                throw new TailorException("Sorry, cannot translate dynamic array indexing for 3-dimensional arrays yet:" + atomExpression);
            }
        } else if (expression instanceof RelationalAtomExpression) {
            RelationalAtomExpression relationalAtomExpression = (RelationalAtomExpression)expression;
            ArrayVariable arrayVariable = (ArrayVariable)relationalAtomExpression.getVariable();
            Expression[] expressionArray = arrayVariable.getExpressionIndices();
            if (this.normalisedModel.constantArrays.containsKey(arrayVariable.getArrayNameOnly())) {
                throw new TailorException("Cannot tailor constant elements that are indexed by decision variables :" + relationalAtomExpression);
            }
            if (expressionArray.length == 1) {
                Domain domain;
                Expression expression8 = expressionArray[0];
                if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                    expression8.willBeFlattenedToVariable(true);
                }
                if (!((domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly())) instanceof ArrayDomain) && !(domain instanceof ConstantArrayDomain)) {
                    throw new TailorException("Indexed variable '" + arrayVariable.getArrayNameOnly() + "' is not an array:" + relationalAtomExpression);
                }
                Domain[] domainArray = ((ArrayDomain)domain).getIndexDomains();
                BasicDomain[] basicDomainArray = new BasicDomain[domainArray.length];
                for (int i = 0; i < domainArray.length; ++i) {
                    if (!(domainArray[i] instanceof BasicDomain)) {
                        throw new TailorException("");
                    }
                    basicDomainArray[i] = (BasicDomain)domainArray[i];
                }
                SimpleArray simpleArray = new SimpleArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ConstantArrayDomain)domain).getBaseDomain());
                return new ElementConstraint(simpleArray, expression8);
            }
            if (expressionArray.length == 2) {
                Expression expression9 = expressionArray[0].evaluate();
                Expression expression10 = expressionArray[1].evaluate();
                if (expression9.getType() == 3) {
                    int n = ((ArithmeticAtomExpression)expression9).getConstant();
                    Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    if ((domain = domain.evaluate()) instanceof ConstantArrayDomain) {
                        int n6 = this.normalisedModel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), 0);
                        BasicDomain[] basicDomainArray = new BasicDomain[]{new SingleIntRange(n -= n6), ((ConstantArrayDomain)domain).getIndexDomains()[1]};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ConstantArrayDomain)domain).getBaseDomain());
                        expression10 = new Sum(new Expression[]{expression10}, new Expression[]{new ArithmeticAtomExpression(n6)});
                        expression10 = expression10.evaluate();
                        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression10.willBeFlattenedToVariable(true);
                        }
                        expression10 = this.flattenExpression(expression10);
                        return new ElementConstraint(indexedArray, expression10);
                    }
                    throw new TailorException("Cannot flatten expression '" + relationalAtomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not constant.");
                }
                if (expression10.getType() == 3) {
                    int n = ((ArithmeticAtomExpression)expression10).getConstant();
                    Domain domain = this.normalisedModel.getDomainOfVariable(arrayVariable.getArrayNameOnly());
                    if ((domain = domain.evaluate()) instanceof ConstantArrayDomain) {
                        int n7 = this.normalisedModel.getVariableOffsetAt(arrayVariable.getArrayNameOnly(), 1);
                        BasicDomain[] basicDomainArray = new BasicDomain[]{((ConstantArrayDomain)domain).getIndexDomains()[0], new SingleIntRange(n -= n7)};
                        IndexedArray indexedArray = new IndexedArray(arrayVariable.getArrayNameOnly(), basicDomainArray, ((ConstantArrayDomain)domain).getBaseDomain());
                        expression9 = new Sum(new Expression[]{expression9}, new Expression[]{new ArithmeticAtomExpression(n7)});
                        expression9 = expression9.evaluate();
                        if (!this.targetSolver.supportsConstraintsNestedAsArgumentOf(222)) {
                            expression9.willBeFlattenedToVariable(true);
                        }
                        expression9 = this.flattenExpression(expression9);
                        return new ElementConstraint(indexedArray, expression9);
                    }
                    throw new TailorException("Cannot flatten expression '" + relationalAtomExpression + "' to element constraint: " + "the domain of variable " + arrayVariable + " is not constant.");
                }
            }
        }
        throw new TailorException("Interal error: cannot tailor expression '" + expression + "' to a partwise element-constraint.");
    }

    private Expression flattenDirectBinaryMinimum(Expression expression, BinaryMinimum binaryMinimum, Expression expression2) throws TailorException, Exception {
        expression = this.flattenExpression(expression);
        Expression expression3 = binaryMinimum.getLeftArgument();
        Expression expression4 = binaryMinimum.getRightArgument();
        expression3.willBeFlattenedToVariable(true);
        expression4.willBeFlattenedToVariable(true);
        expression3 = this.flattenExpression(expression3);
        expression4 = this.flattenExpression(expression4);
        if (!(expression3 instanceof AtomExpression)) {
            throw new TailorException("Flattening error: expected atom expression instead of: " + expression3 + " in " + expression2);
        }
        if (!(expression4 instanceof AtomExpression)) {
            throw new TailorException("Flattening error: expected atom expression instead of: " + expression4 + " in " + expression2);
        }
        VariableArray variableArray = new VariableArray(new AtomExpression[]{(AtomExpression)expression3, (AtomExpression)expression4});
        return new MinimumConstraint(variableArray, expression, binaryMinimum.isMaximum());
    }

    private Expression flattenBinaryMinimum(BinaryMinimum binaryMinimum) throws TailorException, Exception {
        if (this.hasCommonSubExpression(binaryMinimum)) {
            return this.getCommonSubExpression(binaryMinimum);
        }
        Expression expression = binaryMinimum.getLeftArgument();
        Expression expression2 = binaryMinimum.getRightArgument();
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (expression.isQuantified() || expression2.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(binaryMinimum.getQuantifyingVariables(), binaryMinimum.getDefinedDomain()[0], binaryMinimum.getDefinedDomain()[1])) : new ArithmeticAtomExpression(this.createAuxVariable(binaryMinimum.getDefinedDomain()[0], binaryMinimum.getDefinedDomain()[1]))) : new ArithmeticAtomExpression(this.createAuxVariable(binaryMinimum.getDomain()[0], binaryMinimum.getDomain()[1]));
        this.addToSubExpressions(binaryMinimum, arithmeticAtomExpression);
        if (this.settings.getAuxVarDetails()) {
            this.addToAuxVarList(((Object)arithmeticAtomExpression).toString(), binaryMinimum);
        }
        expression.willBeFlattenedToVariable(true);
        expression2.willBeFlattenedToVariable(true);
        expression = this.flattenExpression(expression);
        expression2 = this.flattenExpression(expression2);
        if (!(expression instanceof AtomExpression)) {
            throw new TailorException("Flattening error: expected atom expression instead of: " + expression + " in " + binaryMinimum);
        }
        if (!(expression2 instanceof AtomExpression)) {
            throw new TailorException("Flattening error: expected atom expression instead of: " + expression2 + " in " + binaryMinimum);
        }
        VariableArray variableArray = new VariableArray(new AtomExpression[]{(AtomExpression)expression, (AtomExpression)expression2});
        MinimumConstraint minimumConstraint = new MinimumConstraint(variableArray, arithmeticAtomExpression, binaryMinimum.isMaximum());
        this.constraintBuffer.add(minimumConstraint);
        return arithmeticAtomExpression;
    }

    private Expression insertConstantArraysInExpression(Expression expression) throws TailorException, Exception {
        if (expression instanceof UnaryRelationalExpression) {
            Expression expression2 = this.insertConstantArraysInExpression(((UnaryRelationalExpression)expression).getArgument());
            expression2 = expression2.evaluate();
            if (expression instanceof AllDifferent) {
                return new AllDifferent((Array)expression2);
            }
            if (expression instanceof Negation) {
                Negation negation = (Negation)expression;
                negation.setArgument(expression2);
                return negation.evaluate();
            }
            if (expression instanceof UnaryMinus) {
                return new UnaryMinus(expression2);
            }
            return expression;
        }
        if (expression instanceof NonCommutativeRelationalBinaryExpression) {
            NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression = (NonCommutativeRelationalBinaryExpression)expression;
            Expression expression3 = this.insertConstantArraysInExpression(nonCommutativeRelationalBinaryExpression.getLeftArgument());
            if (nonCommutativeRelationalBinaryExpression.getOperator() == 116 && (expression3 = expression3.evaluate()).getType() == 0) {
                return ((RelationalAtomExpression)expression3).getBool() ? this.insertConstantArraysInExpression(nonCommutativeRelationalBinaryExpression.getRightArgument()) : new RelationalAtomExpression(true);
            }
            Expression expression4 = this.insertConstantArraysInExpression(nonCommutativeRelationalBinaryExpression.getRightArgument());
            return new NonCommutativeRelationalBinaryExpression(expression3, nonCommutativeRelationalBinaryExpression.getOperator(), expression4);
        }
        if (expression instanceof NonCommutativeArithmeticBinaryExpression) {
            NonCommutativeArithmeticBinaryExpression nonCommutativeArithmeticBinaryExpression = (NonCommutativeArithmeticBinaryExpression)expression;
            Expression expression5 = this.insertConstantArraysInExpression(nonCommutativeArithmeticBinaryExpression.getLeftArgument());
            Expression expression6 = this.insertConstantArraysInExpression(nonCommutativeArithmeticBinaryExpression.getRightArgument());
            return new NonCommutativeArithmeticBinaryExpression(expression5, nonCommutativeArithmeticBinaryExpression.getOperator(), expression6);
        }
        if (expression instanceof QuantifiedExpression) {
            return expression;
        }
        if (expression instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)expression;
            ArrayList<Expression> arrayList = conjunction.getArguments();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.add(i, this.insertConstantArraysInExpression(arrayList.remove(i)).evaluate());
                if (arrayList.get(i).getType() != 0 || ((RelationalAtomExpression)arrayList.get(i)).getBool()) continue;
                return new RelationalAtomExpression(false);
            }
            return new Conjunction(arrayList);
        }
        if (expression instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)expression;
            ArrayList<Expression> arrayList = disjunction.getArguments();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.add(i, this.insertConstantArraysInExpression(arrayList.remove(i)));
                if (arrayList.get(i).getType() != 0 || !((RelationalAtomExpression)arrayList.get(i)).getBool()) continue;
                return new RelationalAtomExpression(true);
            }
            return new Disjunction(arrayList);
        }
        if (expression instanceof ElementConstraint) {
            ElementConstraint elementConstraint = (ElementConstraint)expression;
            Expression[] expressionArray = elementConstraint.getArguments();
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i] = this.insertConstantArraysInExpression(expressionArray[i]);
            }
            return new ElementConstraint(expressionArray[0], expressionArray[1], expressionArray[2]);
        }
        if (expression instanceof QuantifiedSum) {
            return expression;
        }
        if (expression instanceof CommutativeBinaryRelationalExpression) {
            CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression = (CommutativeBinaryRelationalExpression)expression;
            Expression expression7 = this.insertConstantArraysInExpression(commutativeBinaryRelationalExpression.getLeftArgument());
            Expression expression8 = this.insertConstantArraysInExpression(commutativeBinaryRelationalExpression.getRightArgument());
            return new CommutativeBinaryRelationalExpression(expression7, commutativeBinaryRelationalExpression.getOperator(), expression8);
        }
        if (expression instanceof QuantifiedSum) {
            return expression;
        }
        if (expression instanceof UnaryArithmeticExpression) {
            if (expression instanceof UnaryMinus) {
                return new UnaryMinus(this.insertConstantArraysInExpression(((UnaryArithmeticExpression)expression).getArgument()));
            }
            if (expression instanceof AbsoluteValue) {
                return new AbsoluteValue(this.insertConstantArraysInExpression(((UnaryArithmeticExpression)expression).getArgument()));
            }
            return expression;
        }
        if (expression instanceof Sum) {
            Sum sum = (Sum)expression;
            ArrayList<Expression> arrayList = sum.getPositiveArguments();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.add(i, this.insertConstantArraysInExpression(arrayList.remove(i)));
            }
            ArrayList<Expression> arrayList2 = sum.getNegativeArguments();
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList2.add(i, this.insertConstantArraysInExpression(arrayList2.remove(i)));
            }
            return new Sum(arrayList, arrayList2);
        }
        if (expression instanceof Multiplication) {
            Multiplication multiplication = (Multiplication)expression;
            ArrayList<Expression> arrayList = multiplication.getArguments();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.add(i, this.insertConstantArraysInExpression(arrayList.remove(i)));
            }
            return new Multiplication(arrayList);
        }
        if (expression instanceof ArithmeticAtomExpression) {
            ArithmeticAtomExpression arithmeticAtomExpression = (ArithmeticAtomExpression)expression;
            if (arithmeticAtomExpression.getType() == 22) {
                Variable variable = arithmeticAtomExpression.getVariable();
                if (variable.getType() == 14) {
                    int n;
                    int[] nArray;
                    ArrayVariable arrayVariable = (ArrayVariable)variable;
                    Expression[] expressionArray = arrayVariable.getExpressionIndices();
                    if (expressionArray != null) {
                        boolean bl = false;
                        nArray = new int[expressionArray.length];
                        boolean bl2 = true;
                        for (n = 0; n < expressionArray.length; ++n) {
                            Expression expression9 = this.insertConstantArraysInExpression(expressionArray[n]);
                            if (!((Object)expression9).toString().equals(((Object)expressionArray[n]).toString())) {
                                bl = true;
                                expressionArray[n] = expression9;
                            }
                            if (expression9.getType() == 3) {
                                nArray[n] = ((ArithmeticAtomExpression)expression9).getConstant();
                                continue;
                            }
                            bl2 = false;
                        }
                        if (!bl && !bl2) {
                            return expression;
                        }
                        if (bl2) {
                            variable = new ArrayVariable(arrayVariable.getArrayNameOnly(), nArray, arrayVariable.getBaseDomain());
                            arithmeticAtomExpression = new ArithmeticAtomExpression(variable);
                            expressionArray = null;
                        } else {
                            ArrayVariable arrayVariable2 = new ArrayVariable(arrayVariable.getArrayNameOnly(), expressionArray, arrayVariable.getBaseDomain());
                            return this.insertConstantArraysInExpression(new ArithmeticAtomExpression(new ArrayVariable(arrayVariable.getArrayNameOnly(), expressionArray, arrayVariable.getBaseDomain())));
                        }
                    }
                    if (this.normalisedModel.constantArrays.containsKey(((ArrayVariable)variable).getArrayNameOnly())) {
                        ConstantArray constantArray = this.normalisedModel.constantArrays.get(((ArrayVariable)variable).getArrayNameOnly());
                        if (expressionArray != null) {
                            throw new TailorException("Sorry, cannot tailor constant arrays that are indexed by decision variables yet.");
                        }
                        nArray = ((ArrayVariable)variable).getIntegerIndices();
                        if (nArray.length == 1) {
                            if (constantArray instanceof ConstantVector) {
                                ConstantVector constantVector = (ConstantVector)constantArray;
                                n = this.normalisedModel.getOffsetFromZeroAt(constantVector.getArrayName(), 0);
                                return new ArithmeticAtomExpression(constantVector.getElementAt(nArray[0] - n));
                            }
                            throw new TailorException("Illegal index dimensions of constant array element '" + arithmeticAtomExpression + "' that dereferences the array '" + constantArray + "'.\nPlease make sure you have an index for every dimension of the array.");
                        }
                        if (nArray.length == 2) {
                            if (constantArray instanceof ConstantMatrix) {
                                ConstantMatrix constantMatrix = (ConstantMatrix)constantArray;
                                n = this.normalisedModel.getOffsetFromZeroAt(constantMatrix.getArrayName(), 0);
                                int n2 = this.normalisedModel.getOffsetFromZeroAt(constantMatrix.getArrayName(), 1);
                                return new ArithmeticAtomExpression(constantMatrix.getElementAt(nArray[0] - n, nArray[1] - n2));
                            }
                            throw new TailorException("Illegal index dimensions of constant array element '" + arithmeticAtomExpression + "' that dereferences the array '" + constantArray + "'.\nPlease make sure you have an index for every dimension of the array.");
                        }
                        throw new TailorException("Cannot tailor constant elements with more than 2 dimensions yet, sorry:" + arithmeticAtomExpression);
                    }
                } else if (variable.getType() == 15) {
                    SimpleArrayVariable simpleArrayVariable = (SimpleArrayVariable)expression;
                    return this.insertConstantDomainIntoSimpleArrayVariable(simpleArrayVariable);
                }
            }
        } else if (expression instanceof RelationalAtomExpression) {
            RelationalAtomExpression relationalAtomExpression = (RelationalAtomExpression)expression;
            if (relationalAtomExpression.getType() == 6) {
                Variable variable = relationalAtomExpression.getVariable();
                if (variable.getType() == 14) {
                    ArrayVariable arrayVariable = (ArrayVariable)variable;
                    Expression[] expressionArray = arrayVariable.getExpressionIndices();
                    if (expressionArray != null) {
                        for (int i = 0; i < expressionArray.length; ++i) {
                            expressionArray[i] = this.insertConstantArraysInExpression(expressionArray[i]);
                        }
                        variable = new ArrayVariable(arrayVariable.getArrayNameOnly(), expressionArray, arrayVariable.getBaseDomain());
                        expression = new RelationalAtomExpression(variable);
                    }
                    if (this.normalisedModel.constantArrays.containsKey(((ArrayVariable)variable).getArrayNameOnly())) {
                        ConstantArray constantArray = this.normalisedModel.constantArrays.get(((ArrayVariable)variable).getArrayNameOnly());
                        if (expressionArray != null) {
                            throw new TailorException("Sorry, cannot tailor constant arrays that are indexed by decision variables yet.");
                        }
                        int[] nArray = ((ArrayVariable)variable).getIntegerIndices();
                        if (nArray.length == 1) {
                            if (constantArray instanceof ConstantVector) {
                                ConstantVector constantVector = (ConstantVector)constantArray;
                                int n = this.normalisedModel.getOffsetFromZeroAt(constantVector.getArrayName(), 0);
                                return new RelationalAtomExpression(constantVector.getElementAt(nArray[0] - n) > 0);
                            }
                            throw new TailorException("Illegal index dimensions of constant array element '" + relationalAtomExpression + "' that dereferences the array '" + constantArray + "'.\nPlease make sure you have an index for every dimension of the array.");
                        }
                        if (nArray.length == 2) {
                            if (constantArray instanceof ConstantMatrix) {
                                int n;
                                ConstantMatrix constantMatrix = (ConstantMatrix)constantArray;
                                int n3 = this.normalisedModel.getOffsetFromZeroAt(constantMatrix.getArrayName(), 0);
                                return new RelationalAtomExpression(constantMatrix.getElementAt(nArray[0] - n3, nArray[1] - (n = this.normalisedModel.getOffsetFromZeroAt(constantMatrix.getArrayName(), 1))) > 0);
                            }
                            throw new TailorException("Illegal index dimensions of constant array element '" + relationalAtomExpression + "' that dereferences the array '" + constantArray + "'.\nPlease make sure you have an index for every dimension of the array.");
                        }
                        throw new TailorException("Cannot tailor constant elements with more than 2 dimensions yet, sorry:" + relationalAtomExpression);
                    }
                } else if (variable.getType() == 15) {
                    SimpleArrayVariable simpleArrayVariable = (SimpleArrayVariable)expression;
                    return this.insertConstantDomainIntoSimpleArrayVariable(simpleArrayVariable);
                }
            }
        } else {
            if (expression instanceof SimpleArrayVariable) {
                SimpleArrayVariable simpleArrayVariable = (SimpleArrayVariable)expression;
                Expression expression10 = this.insertConstantDomainIntoSimpleArrayVariable(simpleArrayVariable);
                return expression10;
            }
            if (expression instanceof Atmost) {
                Expression expression11;
                int n;
                int[] nArray;
                boolean bl;
                Atmost atmost = (Atmost)expression;
                ArrayList<Expression> arrayList = atmost.getOccurrenceExpressions();
                ArrayList<Expression> arrayList3 = atmost.getValueExpressions();
                if (arrayList != null && arrayList.size() > 0) {
                    bl = true;
                    nArray = new int[arrayList.size()];
                    for (n = 0; n < arrayList.size(); ++n) {
                        expression11 = this.insertConstantArraysInExpression(arrayList.get(n));
                        if ((expression11 = expression11.evaluate()).getType() == 3) {
                            nArray[n] = ((ArithmeticAtomExpression)expression11).getConstant();
                            continue;
                        }
                        bl = false;
                    }
                    if (bl) {
                        atmost.setOccurrences(nArray);
                    }
                }
                if (arrayList3 != null && arrayList3.size() > 0) {
                    bl = true;
                    nArray = new int[arrayList3.size()];
                    for (n = 0; n < arrayList3.size(); ++n) {
                        expression11 = this.insertConstantArraysInExpression(arrayList3.get(n));
                        if (expression11.getType() == 3) {
                            nArray[n] = ((ArithmeticAtomExpression)expression11).getConstant();
                            continue;
                        }
                        bl = false;
                    }
                    if (bl) {
                        atmost.setValues(nArray);
                    }
                }
                return atmost;
            }
        }
        return expression;
    }

    private Expression insertConstantDomainIntoSimpleArrayVariable(SimpleArrayVariable simpleArrayVariable) throws TailorException, Exception {
        ArrayList<Domain> arrayList = simpleArrayVariable.getIndices();
        String string = simpleArrayVariable.getVariableName();
        if (this.normalisedModel.constantArrays.containsKey(simpleArrayVariable.getVariableName())) {
            int n;
            Object object;
            ConstantArray constantArray = this.normalisedModel.constantArrays.get(simpleArrayVariable.getVariableName());
            if (constantArray.getDimension() != arrayList.size()) {
                throw new Exception("I cannot match a constant value from constant array " + string + " to variable " + simpleArrayVariable + ",\n because the dimensions don't match: " + simpleArrayVariable + " is " + arrayList.size() + "-dimensionial and " + simpleArrayVariable + " is " + constantArray.getDimension() + "-dimensionial.");
            }
            boolean bl = true;
            boolean bl2 = true;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                object = arrayList.get(i);
                object = arrayList.remove(i).evaluate();
                if (!(object instanceof SingleIntRange)) {
                    bl = false;
                }
                if (!(object instanceof SingleRange)) {
                    bl2 = false;
                }
                if (!(object instanceof BasicDomain)) {
                    throw new Exception("Cannot translate array element '" + simpleArrayVariable + "' that is indexed by :" + object + ". Expected an integer, expression, or range.");
                }
                arrayList.add(i, (Domain)object);
            }
            if (bl) {
                int[] nArray = new int[arrayList.size()];
                for (int i = nArray.length - 1; i >= 0; --i) {
                    nArray[i] = ((SingleIntRange)arrayList.remove(i)).getSingleRange();
                }
                if (constantArray.getArrayDomain() != null && !(constantArray.getArrayDomain() instanceof MatrixDomain)) {
                    throw new Exception("Infeasible domain for constant array " + string + ": " + constantArray.getArrayDomain() + ".\nExpected an array domain.");
                }
                object = new int[constantArray.getDimension()];
                for (n = 0; n < ((Object)object).length; ++n) {
                    object[n] = this.normalisedModel.getOffsetFromZeroAt(constantArray.getArrayName(), n);
                }
                if (((Object)object).length > 0) {
                    if (((Object)object).length != nArray.length) {
                        throw new Exception("Domains of constant array element " + simpleArrayVariable + " and constant array " + string + " don't match.\n" + simpleArrayVariable + " is " + nArray.length + "-dimensional and " + string + " is defined as " + ((Object)object).length + "-dimensional.");
                    }
                    for (n = 0; n < ((Object)object).length; ++n) {
                        nArray[n] = nArray[n] - object[n];
                    }
                }
                if (constantArray instanceof ConstantVector) {
                    return new ArithmeticAtomExpression(((ConstantVector)constantArray).getElementAt(nArray[0]));
                }
                if (constantArray instanceof ConstantMatrix) {
                    return new ArithmeticAtomExpression(((ConstantMatrix)constantArray).getElementAt(nArray[0], nArray[1]));
                }
            }
            if (bl2) {
                Expression[] expressionArray = new Expression[arrayList.size()];
                boolean bl3 = true;
                for (n = expressionArray.length - 1; n >= 0; --n) {
                    expressionArray[n] = ((SingleRange)arrayList.remove(n)).getSingleExpressionRange();
                    expressionArray[n] = this.insertConstantArraysInExpression(expressionArray[n]);
                    if (expressionArray[n].getType() == 3) continue;
                    bl3 = false;
                }
                if (bl3) {
                    int n2;
                    int[] nArray = new int[expressionArray.length];
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        nArray[i] = ((ArithmeticAtomExpression)expressionArray[i]).getConstant();
                    }
                    if (constantArray.getArrayDomain() != null && !(constantArray.getArrayDomain() instanceof MatrixDomain)) {
                        throw new Exception("Infeasible domain for constant array " + string + ": " + constantArray.getArrayDomain() + ".\nExpected an array domain.");
                    }
                    int[] nArray2 = new int[constantArray.getDimension()];
                    for (n2 = 0; n2 < nArray2.length; ++n2) {
                        nArray2[n2] = this.normalisedModel.getOffsetFromZeroAt(constantArray.getArrayName(), n2);
                    }
                    if (nArray2.length > 0) {
                        if (nArray2.length != nArray.length) {
                            throw new Exception("Domains of constant array element " + simpleArrayVariable + " and constant array " + string + " don't match.\n" + simpleArrayVariable + " is " + nArray.length + "-dimensional and " + string + " is defined as " + nArray2.length + "-dimensional.");
                        }
                        for (n2 = 0; n2 < nArray2.length; ++n2) {
                            nArray[n2] = nArray[n2] - nArray2[n2];
                        }
                    }
                    if (constantArray instanceof ConstantVector) {
                        return new ArithmeticAtomExpression(((ConstantVector)constantArray).getElementAt(nArray[0]));
                    }
                    if (constantArray instanceof ConstantMatrix) {
                        return new ArithmeticAtomExpression(((ConstantMatrix)constantArray).getElementAt(nArray[0], nArray[1]));
                    }
                }
                ArithmeticAtomExpression arithmeticAtomExpression = new ArithmeticAtomExpression(new ArrayVariable(string, expressionArray, (Domain)new InfiniteDomain()));
                return arithmeticAtomExpression;
            }
            throw new TailorException("Cannot translate indexing constant arrays with integer ranges, as in " + simpleArrayVariable + " yet, sorry.");
        }
        return simpleArrayVariable;
    }

    private void addToDirectlyEqualAtoms(Expression expression, Expression expression2) throws TailorException {
        if (!this.settings.applyDirectVariableReusage()) {
            return;
        }
        if (expression2 instanceof ArithmeticAtomExpression) {
            this.equalAtomsMap.put(((Object)expression).toString(), (ArithmeticAtomExpression)expression2);
        } else if (expression2 instanceof RelationalAtomExpression) {
            this.equalAtomsMap.put(((Object)expression).toString(), ((RelationalAtomExpression)expression2).toArithmeticExpression());
        } else {
            throw new TailorException("Internal error: cannot add expression that is not at atom to equal atom hashmap:" + expression2);
        }
        if (expression instanceof ArithmeticAtomExpression) {
            this.replaceableVariables.add((ArithmeticAtomExpression)expression);
        } else if (expression instanceof RelationalAtomExpression) {
            this.replaceableVariables.add(((RelationalAtomExpression)expression).toArithmeticExpression());
        } else {
            throw new TailorException("Internal error: cannot add expression that is not at atom to replaceable variables list:" + expression);
        }
    }

    private void addToSubExpressions(Expression expression, Expression expression2) {
        if (!this.useCommonSubExpressions) {
            return;
        }
        if (expression2 instanceof ArithmeticAtomExpression) {
            this.subExpressions.put(((Object)expression).toString(), (ArithmeticAtomExpression)expression2);
        } else if (expression2 instanceof RelationalAtomExpression) {
            this.subExpressions.put(((Object)expression).toString(), ((RelationalAtomExpression)expression2).toArithmeticExpression());
        }
    }

    private void addToEqualExpressions(Expression expression, Expression expression2) {
        if (!this.useEqualSubExpressions) {
            return;
        }
        if (expression2 instanceof ArithmeticAtomExpression) {
            this.equalSubExpressions.put(((Object)expression).toString(), (ArithmeticAtomExpression)expression2);
        } else if (expression2 instanceof RelationalAtomExpression) {
            this.equalSubExpressions.put(((Object)expression).toString(), ((RelationalAtomExpression)expression2).toArithmeticExpression());
        }
    }

    private ArithmeticAtomExpression getCommonSubExpression(Expression expression) {
        Object object;
        Object object2;
        Multiplication multiplication = null;
        if (!expression.isQuantified()) {
            ++this.usedCommonSubExpressions;
        } else {
            object2 = this.removeDuplicates(expression.getQuantifyingVariables());
            object = new Expression[((ArrayList)object2).size()];
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                Expression expression2 = (Expression)((ArrayList)object2).get(i);
                object[i] = new Sum(new Expression[]{expression2.getDefinedDomain()[1].copy(), new ArithmeticAtomExpression(1)}, new Expression[]{expression2.getDefinedDomain()[0].copy()});
                object[i] = object[i].reduceExpressionTree();
                object[i] = object[i].evaluate();
            }
            multiplication = new Multiplication((Expression[])object);
            this.usedQuantifiedCommonSubExpressions = new Sum(new Expression[]{this.usedQuantifiedCommonSubExpressions.reduceExpressionTree().evaluate().copy(), multiplication.evaluate()}, new Expression[0]);
        }
        object2 = ((Object)expression).toString();
        if (this.settings.getCseDetails() || this.settings.useCSEVarOrdering()) {
            if (!expression.isQuantified()) {
                if (this.subExpressionCount.containsKey(object2)) {
                    object = this.subExpressionCount.get(object2);
                    object = (Integer)object + 1;
                    this.subExpressionCount.put((String)object2, (Integer)object);
                } else {
                    this.subexpressionList.add((String)object2);
                    this.subExpressionCount.put((String)object2, new Integer(1));
                }
            } else if (this.subExpressionCountPC.containsKey(object2)) {
                object = this.subExpressionCountPC.get(object2);
                object = new Sum(new Expression[]{object.copy(), multiplication}, new Expression[0]);
                object = object.reduceExpressionTree().evaluate();
                this.subExpressionCountPC.put((String)object2, (Expression)object);
            } else {
                this.subexpressionList.add((String)object2);
                this.subExpressionCountPC.put((String)object2, multiplication);
            }
        }
        return this.subExpressions.get(object2);
    }

    private ArithmeticAtomExpression getEqualSubExpression(Expression expression) {
        ++this.usedEqualSubExpressions;
        return this.equalSubExpressions.get(((Object)expression).toString());
    }

    private boolean hasCommonSubExpression(Expression expression) {
        if (!this.useCommonSubExpressions) {
            return false;
        }
        if (this.subExpressions.containsKey(((Object)expression).toString())) {
            return true;
        }
        if (this.settings.isClassLevelTransformation() && expression.isQuantified()) {
            ArrayList<Expression> arrayList = this.removeDuplicates(expression.getQuantifyingVariables());
            for (int i = 0; i < arrayList.size(); ++i) {
                Expression expression2 = arrayList.get(i);
                Domain domain = this.quantifiedVarNamesMap.get(((Object)expression2).toString());
                ArrayList<String> arrayList2 = this.quantifiedDomainsMap.get(((Object)domain).toString());
                if (arrayList2.size() > 1) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        String string = arrayList2.get(j);
                        if (string.equals(((Object)expression2).toString())) continue;
                        try {
                            Expression expression3 = expression.copy().replaceVariableWithExpression(new String(((Object)expression2).toString()), new ArithmeticAtomExpression(new SimpleVariable(string)));
                            if (!this.subExpressions.containsKey(((Object)expression3).toString())) continue;
                            this.addToSubExpressions(expression, this.subExpressions.get(((Object)expression3).toString()));
                            return true;
                        }
                        catch (Exception exception) {
                            System.out.println("Unexpected exception thrown:" + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                    continue;
                }
                return false;
            }
        }
        return false;
    }

    private boolean hasEqualSubExpression(Expression expression) {
        if (!this.useEqualSubExpressions) {
            return false;
        }
        return this.equalSubExpressions.containsKey(((Object)expression).toString());
    }

    private RelationalAtomExpression reifyConstraint(Expression expression) throws TailorException {
        if (expression instanceof RelationalAtomExpression) {
            return (RelationalAtomExpression)expression;
        }
        if (!this.targetSolver.supportsReificationOf(expression.getType())) {
            throw new TailorException("Cannot reify constraint because its reification is not supported by the target solver:" + expression);
        }
        ArithmeticAtomExpression arithmeticAtomExpression = null;
        if (this.hasCommonSubExpression(expression)) {
            return this.getCommonSubExpression(expression).toRelationalAtomExpression();
        }
        if (this.hasEqualSubExpression(expression)) {
            arithmeticAtomExpression = this.getEqualSubExpression(expression);
            this.addToSubExpressions(expression, arithmeticAtomExpression);
            this.constraintBuffer.add(new Reification(expression, arithmeticAtomExpression.toRelationalAtomExpression()));
        } else {
            if (this.settings.useNegatedCSEs() && expression instanceof BinaryRelationalExpression && ((BinaryRelationalExpression)expression).isEasyNegatable()) {
                Expression expression2 = new Negation(expression);
                if (this.hasCommonSubExpression(expression2 = expression2.evaluate())) {
                    RelationalAtomExpression relationalAtomExpression = this.getCommonSubExpression(expression2).toRelationalAtomExpression();
                    RelationalAtomExpression relationalAtomExpression2 = (RelationalAtomExpression)relationalAtomExpression.copy();
                    relationalAtomExpression2.setIsNegated(true);
                    ++this.noUsedNegatedCSEs;
                    ++this.noNegatedCSEs;
                    return relationalAtomExpression2;
                }
                expression = new Negation(expression2).evaluate();
                arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (expression.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1))) : new ArithmeticAtomExpression(this.createAuxVariable(new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)))) : new ArithmeticAtomExpression(this.createAuxVariable(0, 1));
                this.addToSubExpressions(expression, arithmeticAtomExpression);
                if (this.settings.getAuxVarDetails()) {
                    this.addToAuxVarList(arithmeticAtomExpression.toString(), expression);
                }
                this.constraintBuffer.add(new Reification(expression, arithmeticAtomExpression.toRelationalAtomExpression()));
                return arithmeticAtomExpression.toRelationalAtomExpression();
            }
            arithmeticAtomExpression = this.settings.isClassLevelTransformation() ? (expression.isQuantified() ? new ArithmeticAtomExpression(this.createAuxVariable(expression.getQuantifyingVariables(), new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1))) : new ArithmeticAtomExpression(this.createAuxVariable(new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)))) : new ArithmeticAtomExpression(this.createAuxVariable(0, 1));
            this.addToSubExpressions(expression, arithmeticAtomExpression);
            if (this.settings.getAuxVarDetails()) {
                this.addToAuxVarList(arithmeticAtomExpression.toString(), expression);
            }
            this.constraintBuffer.add(new Reification(expression, arithmeticAtomExpression.toRelationalAtomExpression()));
        }
        return arithmeticAtomExpression.toRelationalAtomExpression();
    }

    private Variable createAuxVariable(int n, int n2) {
        SingleVariable singleVariable = null;
        singleVariable = n == 0 && n2 == 1 ? new SingleVariable(this.AUXVARIABLE_NAME + this.noAuxVariables++, new BoolDomain()) : new SingleVariable(this.AUXVARIABLE_NAME + this.noAuxVariables++, new BoundedIntRange(n, n2));
        if (!this.targetSolver.willSearchOverAuxiliaryVariables()) {
            singleVariable.setIsSearchVariable(false);
        }
        this.normalisedModel.addAuxiliaryVariable(singleVariable);
        return singleVariable;
    }

    private Variable createAuxVariable(ArrayList<Expression> arrayList, Expression expression, Expression expression2) throws TailorException {
        Object object;
        Object object2;
        AtomExpression atomExpression;
        arrayList = this.removeDuplicates(arrayList);
        Expression[] expressionArray = new Expression[arrayList.size()];
        Domain[] domainArray = new ExpressionRange[arrayList.size()];
        Expression[] expressionArray2 = new Expression[expressionArray.length];
        Expression[][] expressionArray3 = new Expression[arrayList.size()][2];
        for (int i = 0; i < expressionArray.length; ++i) {
            atomExpression = (AtomExpression)arrayList.get(i).copy();
            expressionArray[i] = atomExpression;
            object2 = new BoundedExpressionRange(atomExpression.getDefinedDomain()[0].copy(), atomExpression.getDefinedDomain()[1].copy());
            domainArray[i] = object2;
            expressionArray2[i] = new Sum(new Expression[]{atomExpression.getDefinedDomain()[1].copy(), new ArithmeticAtomExpression(1)}, new Expression[]{atomExpression.getDefinedDomain()[0].copy()});
            expressionArray3[i] = atomExpression.getDefinedDomain();
        }
        Expression expression3 = null;
        atomExpression = new ArithmeticAtomExpression(0);
        object2 = null;
        if (expressionArray.length == 2) {
            expression3 = new Sum(new Expression[]{new Sum(new Expression[]{expressionArray[0]}, new Expression[]{expressionArray3[0][0].copy()}), new Multiplication(new Expression[]{expressionArray2[0].copy(), new Sum(new Expression[]{expressionArray[1]}, new Expression[]{expressionArray3[0][0].copy()})})}, new Expression[0]);
            expression3 = expression3.reduceExpressionTree();
            expression3 = expression3.evaluate();
            object2 = new Sum(new Expression[]{new Multiplication(expressionArray2)}, new Expression[]{new ArithmeticAtomExpression(1)});
            object2 = object2.reduceExpressionTree();
            object2 = object2.evaluate();
        } else if (expressionArray.length == 3) {
            expression3 = new Sum(new Expression[]{new Sum(new Expression[]{expressionArray[0]}, new Expression[]{expressionArray3[0][0].copy()}), new Multiplication(new Expression[]{expressionArray2[0].copy(), new Sum(new Expression[]{expressionArray[1]}, new Expression[]{expressionArray3[1][0].copy()})}), new Multiplication(new Expression[]{expressionArray2[1].copy(), new Sum(new Expression[]{expressionArray[2]}, new Expression[]{expressionArray3[2][0].copy()}), expressionArray2[0].copy()})}, new Expression[0]);
            expression3 = expression3.reduceExpressionTree();
            expression3 = expression3.evaluate();
            object2 = new Sum(new Expression[]{new Multiplication(expressionArray2)}, new Expression[]{new ArithmeticAtomExpression(1)});
            object2 = object2.reduceExpressionTree();
            object2 = object2.evaluate();
        } else if (expressionArray.length == 4) {
            expression3 = new Sum(new Expression[]{new Sum(new Expression[]{expressionArray[0]}, new Expression[]{expressionArray3[0][0].copy()}), new Multiplication(new Expression[]{expressionArray2[0].copy(), new Sum(new Expression[]{expressionArray[1]}, new Expression[]{expressionArray3[1][0].copy()})}), new Multiplication(new Expression[]{expressionArray2[1].copy(), new Sum(new Expression[]{expressionArray[2]}, new Expression[]{expressionArray3[2][0].copy()}), expressionArray2[0].copy()}), new Multiplication(new Expression[]{expressionArray2[1].copy(), expressionArray2[2].copy(), new Sum(new Expression[]{expressionArray[3]}, new Expression[]{expressionArray3[3][0].copy()}), expressionArray2[0].copy()})}, new Expression[0]);
            expression3 = expression3.reduceExpressionTree();
            expression3 = expression3.evaluate();
            object2 = new Sum(new Expression[]{new Multiplication(expressionArray2)}, new Expression[]{new ArithmeticAtomExpression(1)});
            object2 = object2.reduceExpressionTree();
            object2 = object2.evaluate();
        } else if (expressionArray.length > 4) {
            throw new TailorException("Sorry, cannot tailor auxiliary variables that are quantified by more than 4 variables.");
        }
        String string = this.AUXVARIABLE_ARRAY_NAME + this.noAuxArrayVariables++;
        ArrayDomain arrayDomain = null;
        BasicDomain basicDomain = null;
        basicDomain = ((Object)expression).toString().equals("0") && ((Object)expression2).toString().equals("1") ? new BoolDomain() : new BoundedExpressionRange(expression, expression2);
        if (expression3 == null) {
            object = (BoundedExpressionRange)domainArray[0];
            Expression expression4 = ((BoundedExpressionRange)object).getLowerBound().copy();
            if (!((Object)expression4).toString().equals("0")) {
                int n = this.settings.getTargetSolver().getArrayIndexingStartValue();
                Expression expression5 = new Sum(new Expression[]{((BoundedExpressionRange)object).getUpperBound().copy()}, new Expression[]{expression4.copy()});
                expression5 = expression5.reduceExpressionTree().evaluate();
                ArithmeticAtomExpression arithmeticAtomExpression = new ArithmeticAtomExpression(n);
                ((BoundedExpressionRange)object).setLowerBound(arithmeticAtomExpression);
                ((BoundedExpressionRange)object).setUpperBound(expression5);
                domainArray[0] = object;
                expressionArray[0] = new Sum(new Expression[]{expressionArray[0].copy(), new ArithmeticAtomExpression(n)}, new Expression[]{expression4});
                expressionArray[0] = expressionArray[0].reduceExpressionTree().evaluate();
            }
            arrayDomain = new ArrayDomain((Domain)basicDomain, domainArray);
        } else {
            arrayDomain = new ArrayDomain((Domain)basicDomain, new BasicDomain[]{new BoundedExpressionRange(atomExpression, (Expression)object2)});
        }
        object = null;
        object = expression3 == null ? new ArrayVariable(string, expressionArray, (Domain)arrayDomain) : new ArrayVariable(string, new Expression[]{expression3}, (Domain)arrayDomain);
        this.normalisedModel.addAuxiliaryVariable((Variable)object);
        this.auxArrayDomainsMap.put(string, arrayDomain);
        this.auxArrayNames.add(string);
        return object;
    }

    private ArrayList<Expression> removeDuplicates(ArrayList<Expression> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Expression expression = arrayList.get(i);
            for (int j = arrayList.size() - 1; j >= 1 && j != i; --j) {
                if (!((Object)expression).toString().equals(((Object)arrayList.get(j)).toString())) continue;
                arrayList.remove(j);
            }
        }
        return arrayList;
    }

    private Variable createAuxVariable(Expression expression, Expression expression2) {
        SingleVariable singleVariable = null;
        if (expression.getType() == 3 && expression2.getType() == 3) {
            int n = ((ArithmeticAtomExpression)expression).getConstant();
            int n2 = ((ArithmeticAtomExpression)expression2).getConstant();
            return this.createAuxVariable(n, n2);
        }
        singleVariable = new SingleVariable(this.AUXVARIABLE_NAME + this.noAuxVariables++, new BoundedExpressionRange(expression, expression2));
        if (!this.targetSolver.willSearchOverAuxiliaryVariables()) {
            singleVariable.setIsSearchVariable(false);
        }
        this.normalisedModel.addAuxiliaryVariable(singleVariable);
        return singleVariable;
    }

    private void addToAuxVarList(String string, Expression expression) {
        if (this.settings.getAuxVarDetails() || this.settings.useCSEVarOrdering()) {
            this.auxVarExpressions.put(string, expression);
        }
    }

    public String getCseInfo() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.settings.getCseDetails()) {
            return stringBuffer.toString();
        }
        ArrayList<String> arrayList = this.normalisedModel.getSubexpressionList();
        if (arrayList.size() == 0) {
            stringBuffer.append("No common subexpression eliminated\n");
            return stringBuffer.toString();
        }
        if (this.usedQuantifiedCommonSubExpressions != null) {
            stringBuffer.append("#Common Subexpressions Eliminated (problem class level): " + this.usedQuantifiedCommonSubExpressions + "\n");
        }
        stringBuffer.append("#Common Subexpressions Eliminated (single):" + this.usedCommonSubExpressions + "\n");
        stringBuffer.append("#Common Subexpressions: " + arrayList.size() + "\n\n");
        HashMap<String, Integer> hashMap = this.normalisedModel.getSubexpressionCount();
        stringBuffer.append("<#Occurrences>\t<Common Subexpression>\n\n");
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (hashMap.containsKey(object)) {
                stringBuffer.append("<" + hashMap.get(object) + ">" + "\t<" + (String)object + ">\n");
                continue;
            }
            stringBuffer.append("<" + this.subExpressionCountPC.get(object) + ">" + "\t\t<" + (String)object + ">\n");
        }
        n = 0;
        object = new ArithmeticAtomExpression(0);
        for (int i = 0; i < this.subexpressionList.size(); ++i) {
            String string = this.subexpressionList.get(i);
            if (this.subExpressionCount.containsKey(string)) {
                n += this.subExpressionCount.get(string).intValue();
                continue;
            }
            object = new Sum(new Expression[]{object.copy(), this.subExpressionCountPC.get(string)}, new Expression[0]);
            object = object.reduceExpressionTree().evaluate();
        }
        stringBuffer.append("\nSUM (single): " + n + "\n");
        stringBuffer.append("\nSUM (problem level):" + object + "\n");
        stringBuffer.append("\nEND\n");
        return stringBuffer.toString();
    }
}

