/*
 * Decompiled with CFR 0.152.
 */
package translator.tailor;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.AbsoluteConstraint;
import translator.expression.AllDifferent;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArithmeticExpression;
import translator.expression.AtomExpression;
import translator.expression.BinaryNonLinearConstraint;
import translator.expression.BinaryRelationalExpression;
import translator.expression.BoolDomain;
import translator.expression.BoundedIntRange;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.ElementConstraint;
import translator.expression.Expression;
import translator.expression.LexConstraint;
import translator.expression.Multiplication;
import translator.expression.NaryRelationalExpression;
import translator.expression.ProductConstraint;
import translator.expression.Reification;
import translator.expression.RelationalExpression;
import translator.expression.SumConstraint;
import translator.expression.Variable;
import translator.normaliser.NormalisedModel;

public class FlatZincTailor {
    private TranslationSettings settings;
    private NormalisedModel essencePmodel;

    public StringBuffer toFlatZincString(NormalisedModel normalisedModel, TranslationSettings translationSettings) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.essencePmodel = normalisedModel;
        this.settings = translationSettings;
        stringBuffer.append(this.printHeader());
        stringBuffer.append(this.printVariableDeclaration());
        stringBuffer.append(this.printConstraints());
        if (this.essencePmodel.getObjectiveExpression() == null) {
            stringBuffer.append("\n\nsolve satisfy;\n");
        } else if (this.essencePmodel.isObjectiveMaximising()) {
            stringBuffer.append("\nsolve maximize " + ((Object)this.essencePmodel.getObjectiveExpression()).toString() + ";\n");
        } else {
            stringBuffer.append("\nsolve minimize " + ((Object)this.essencePmodel.getObjectiveExpression()).toString() + ";\n");
        }
        return stringBuffer;
    }

    private StringBuffer printConstraints() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("\n% constraints\n");
        ArrayList<Expression> arrayList = this.essencePmodel.getConstraints();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append("constraint ");
            stringBuffer.append(this.printExpression(arrayList.get(i)));
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    private StringBuffer printExpression(Expression expression) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (expression instanceof BinaryRelationalExpression) {
            return this.binaryRelExpression2Flatzinc((BinaryRelationalExpression)expression);
        }
        if (expression instanceof ProductConstraint) {
            ProductConstraint productConstraint = (ProductConstraint)expression;
            if (productConstraint.getArguments().length > 2) {
                throw new Exception("n-ary multiplication not flattened to binary multiplication: " + productConstraint);
            }
            if (!(productConstraint.getArguments()[0] instanceof AtomExpression && productConstraint.getArguments()[1] instanceof AtomExpression && productConstraint.getResult() instanceof AtomExpression)) {
                throw new Exception("Not flattened properly for FlatZinc, expected atoms as arguments in:" + expression);
            }
            AtomExpression atomExpression = (AtomExpression)productConstraint.getArguments()[0];
            AtomExpression atomExpression2 = (AtomExpression)productConstraint.getArguments()[1];
            AtomExpression atomExpression3 = (AtomExpression)productConstraint.getResult();
            if (atomExpression3 instanceof ArithmeticExpression) {
                stringBuffer.append("int_times(");
            } else {
                stringBuffer.append("bool_and(");
            }
            stringBuffer.append(atomExpression.toString());
            stringBuffer.append(", " + atomExpression2.toString());
            stringBuffer.append(", " + atomExpression3.toString());
            stringBuffer.append(");");
            return stringBuffer;
        }
        if (expression instanceof SumConstraint) {
            return this.sumConstraint2FlatZinc((SumConstraint)expression);
        }
        if (expression instanceof AllDifferent) {
            return this.alldiff2Flatzinc((AllDifferent)expression);
        }
        if (expression instanceof LexConstraint) {
            return new StringBuffer(this.lex2FlatZinc((LexConstraint)expression));
        }
        if (expression instanceof ElementConstraint) {
            return this.element2FlatZinc((ElementConstraint)expression);
        }
        if (expression instanceof BinaryNonLinearConstraint) {
            return new StringBuffer(this.nonLinearConstraint2FlatZinc((BinaryNonLinearConstraint)expression));
        }
        if (expression instanceof NaryRelationalExpression) {
            return this.naryRelation2Flatzinc((NaryRelationalExpression)expression, null);
        }
        if (expression instanceof Reification) {
            return this.reification2Flatzinc((Reification)expression);
        }
        if (expression instanceof AbsoluteConstraint) {
            AbsoluteConstraint absoluteConstraint = (AbsoluteConstraint)expression;
            stringBuffer.append("int_abs(" + absoluteConstraint.getArgument() + ", " + absoluteConstraint.getResult() + ");");
            return stringBuffer;
        }
        throw new Exception("Cannot tailor expression " + expression + " to Flatzinc yet, sorry.");
    }

    private StringBuffer reification2Flatzinc(Reification reification) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Expression expression = reification.getReifiedConstraint();
        if (expression instanceof NaryRelationalExpression) {
            return this.naryRelation2Flatzinc((NaryRelationalExpression)expression, reification.getReifiedVariable());
        }
        if (expression instanceof BinaryRelationalExpression) {
            BinaryRelationalExpression binaryRelationalExpression = (BinaryRelationalExpression)expression;
            if (!(binaryRelationalExpression.getLeftArgument() instanceof AtomExpression) || !(binaryRelationalExpression.getRightArgument() instanceof AtomExpression)) {
                throw new Exception("Not flattened properly for FlatZinc, expected atoms as arguments: " + binaryRelationalExpression);
            }
            AtomExpression atomExpression = (AtomExpression)binaryRelationalExpression.getLeftArgument();
            AtomExpression atomExpression2 = (AtomExpression)binaryRelationalExpression.getRightArgument();
            if (atomExpression instanceof ArithmeticExpression) {
                stringBuffer.append("int_");
            } else {
                stringBuffer.append("bool_");
            }
            stringBuffer.append(this.operatorToString(binaryRelationalExpression.getOperator()) + "_reif");
            stringBuffer.append("(" + atomExpression.toString() + ", " + atomExpression2.toString() + ", " + reification.getReifiedVariable().toString() + ");");
            return stringBuffer;
        }
        throw new Exception("Cannot tailor reification " + reification + " of type " + expression.getClass().getSimpleName() + " to FlatZinc yet, sorry.");
    }

    private StringBuffer naryRelation2Flatzinc(NaryRelationalExpression naryRelationalExpression, Expression expression) throws Exception {
        ArrayList<Expression> arrayList = naryRelationalExpression.getArguments();
        if (arrayList.size() == 2) {
            if (naryRelationalExpression.getType() == 118) {
                return new StringBuffer("bool_and(" + ((Object)arrayList.get(0)).toString() + ", " + arrayList.get(1) + ", " + (expression == null ? "true" : ((Object)expression).toString()) + ");");
            }
            return new StringBuffer("bool_or(" + ((Object)arrayList.get(0)).toString() + ", " + arrayList.get(1) + ", " + (expression == null ? "true" : ((Object)expression).toString()) + ");");
        }
        StringBuffer stringBuffer = new StringBuffer("array_bool_");
        if (naryRelationalExpression.getType() == 118) {
            stringBuffer.append("and([" + arrayList.get(0));
        } else {
            stringBuffer.append("or([" + arrayList.get(0));
        }
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuffer.append(" ," + ((Object)arrayList.get(i)).toString());
        }
        stringBuffer.append("], " + (expression == null ? "true" : ((Object)expression).toString()) + ");");
        return stringBuffer;
    }

    private String nonLinearConstraint2FlatZinc(BinaryNonLinearConstraint binaryNonLinearConstraint) throws Exception {
        String string = ((Object)binaryNonLinearConstraint.getLeftArgument()).toString();
        String string2 = ((Object)binaryNonLinearConstraint.getRightArgument()).toString();
        String string3 = ((Object)binaryNonLinearConstraint.getResult()).toString();
        switch (binaryNonLinearConstraint.getType()) {
            case 122: {
                return "int_mod(" + string + ", " + string2 + ", " + string3 + ");";
            }
            case 112: {
                return "int_div(" + string + ", " + string2 + ", " + string3 + ");";
            }
        }
        throw new Exception("Unknown or unsupported non-linear constraint " + binaryNonLinearConstraint + ", sorry");
    }

    private StringBuffer element2FlatZinc(ElementConstraint elementConstraint) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("");
        Expression expression = elementConstraint.getArray();
        if (expression instanceof RelationalExpression) {
            stringBuffer.append("array_var_bool_element(");
        } else {
            stringBuffer.append("array_var_int_element(");
        }
        stringBuffer.append(((Object)expression).toString() + ", ");
        stringBuffer.append(elementConstraint.getIndexExpression() + ",");
        stringBuffer.append(elementConstraint.getValueExpression() + ");");
        return stringBuffer;
    }

    private String lex2FlatZinc(LexConstraint lexConstraint) throws Exception {
        String string = ((Object)lexConstraint.getLeftArray()).toString();
        String string2 = ((Object)lexConstraint.getRightArray()).toString();
        switch (lexConstraint.getType()) {
            case 105: {
                return "lex_lesseq_int(" + string + ", " + string2 + ");";
            }
            case 103: {
                return "lex_less_int(" + string + ", " + string2 + ");";
            }
            case 109: {
                return "lex_lesseq_int(" + string2 + ", " + string + ");";
            }
            case 107: {
                return "lex_less_int(" + string2 + ", " + string + ");";
            }
        }
        throw new Exception("Unknown lex-constraint type " + lexConstraint.getType() + " of constraint " + lexConstraint);
    }

    private StringBuffer alldiff2Flatzinc(AllDifferent allDifferent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("all_different_int(" + ((Object)allDifferent.getArgument()).toString() + ");");
        return stringBuffer;
    }

    private StringBuffer binaryRelExpression2Flatzinc(BinaryRelationalExpression binaryRelationalExpression) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (!(binaryRelationalExpression.getLeftArgument() instanceof AtomExpression) || !(binaryRelationalExpression.getRightArgument() instanceof AtomExpression)) {
            throw new Exception("Not flattened properly for FlatZinc, expected atoms as arguments: " + binaryRelationalExpression);
        }
        AtomExpression atomExpression = (AtomExpression)binaryRelationalExpression.getLeftArgument();
        AtomExpression atomExpression2 = (AtomExpression)binaryRelationalExpression.getRightArgument();
        if (atomExpression instanceof ArithmeticExpression) {
            stringBuffer.append("int_");
        } else {
            stringBuffer.append("bool_");
        }
        stringBuffer.append(this.operatorToString(binaryRelationalExpression.getOperator()));
        stringBuffer.append("(" + atomExpression.toString() + ", " + atomExpression2.toString() + ");");
        return stringBuffer;
    }

    private StringBuffer sumConstraint2FlatZinc(SumConstraint sumConstraint) throws Exception {
        int n;
        Multiplication multiplication;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Expression[] expressionArray = sumConstraint.getPositiveArguments();
        Expression[] expressionArray2 = sumConstraint.getNegativeArguments();
        ArrayList<AtomExpression> arrayList = new ArrayList<AtomExpression>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n2 = 0; n2 < expressionArray.length + expressionArray2.length; ++n2) {
            arrayList2.add(1);
        }
        for (n2 = 0; n2 < expressionArray.length; ++n2) {
            if (expressionArray[n2] instanceof AtomExpression) {
                arrayList.add((AtomExpression)expressionArray[n2]);
                continue;
            }
            if (expressionArray[n2] instanceof Multiplication) {
                multiplication = (Multiplication)expressionArray[n2];
                if (multiplication.getArguments().size() != 2) {
                    throw new Exception("n-ary multiplication not flattened to binary multiplication in : " + sumConstraint);
                }
                if (multiplication.getArguments().get(0).getType() != 3) {
                    throw new Exception("Expected constant in multiplication" + multiplication + " in expression " + sumConstraint);
                }
                arrayList2.remove(n2);
                arrayList2.add(n2, ((ArithmeticAtomExpression)multiplication.getArguments().get(0)).getConstant());
                if (multiplication.getArguments().get(1) instanceof AtomExpression) {
                    arrayList.add((AtomExpression)multiplication.getArguments().remove(1));
                    continue;
                }
                throw new Exception("Expected atoms as arguments of " + multiplication + " in:" + sumConstraint);
            }
            throw new Exception("Not flattened properly for FlatZinc, expected atoms as arguments in:" + sumConstraint);
        }
        for (n2 = 0; n2 < expressionArray2.length; ++n2) {
            if (expressionArray2[n2] instanceof AtomExpression) {
                arrayList.add((AtomExpression)expressionArray2[n2]);
                arrayList2.remove(n2 + expressionArray.length);
                arrayList2.add(n2 + expressionArray.length, -1);
                continue;
            }
            if (expressionArray2[n2] instanceof Multiplication) {
                multiplication = (Multiplication)expressionArray2[n2];
                if (multiplication.getArguments().size() != 2) {
                    throw new Exception("n-ary multiplication not flattened to binary multiplication in : " + sumConstraint);
                }
                if (multiplication.getArguments().get(0).getType() != 3) {
                    throw new Exception("Expected constant in multiplication" + multiplication + " in expression " + sumConstraint);
                }
                arrayList2.remove(n2 + expressionArray.length);
                arrayList2.add(n2 + expressionArray.length, -((ArithmeticAtomExpression)multiplication.getArguments().get(0)).getConstant());
                if (multiplication.getArguments().get(1) instanceof AtomExpression) {
                    arrayList.add((AtomExpression)multiplication.getArguments().remove(1));
                    continue;
                }
                throw new Exception("Expected atoms as arguments of " + multiplication + " in:" + sumConstraint);
            }
            throw new Exception("Not flattened properly for FlatZinc, expected atoms as arguments in:" + sumConstraint);
        }
        if (!(sumConstraint.getResult() instanceof AtomExpression)) {
            throw new Exception("Expected atom as arguments instead of " + sumConstraint.getResult() + " in:" + sumConstraint);
        }
        AtomExpression atomExpression = (AtomExpression)sumConstraint.getResult();
        if (atomExpression.getCategory() == 3) {
            arrayList2.add(-1);
            arrayList.add((AtomExpression)atomExpression.copy());
            atomExpression = new ArithmeticAtomExpression(0);
        }
        if (arrayList.get(0) instanceof ArithmeticExpression) {
            stringBuffer.append("int_lin_");
        } else {
            stringBuffer.append("bool_lin_");
        }
        stringBuffer.append(this.operatorToString(sumConstraint.getRelationalOperator()));
        stringBuffer.append("([" + arrayList2.get(0));
        for (n = 1; n < arrayList2.size(); ++n) {
            stringBuffer.append(", " + arrayList2.get(n));
        }
        stringBuffer.append("], [" + arrayList.get(0));
        for (n = 1; n < arrayList.size(); ++n) {
            stringBuffer.append(", " + arrayList.get(n));
        }
        stringBuffer.append("], " + atomExpression.toString() + ");");
        return stringBuffer;
    }

    private String operatorToString(int n) throws Exception {
        switch (n) {
            case 101: {
                return "eq";
            }
            case 100: {
                return "ne";
            }
            case 104: {
                return "le";
            }
            case 108: {
                return "ge";
            }
            case 106: {
                return "gt";
            }
            case 102: {
                return "lt";
            }
            case 113: {
                return "times";
            }
        }
        throw new Exception("Unkown operator in Flatzinc tailor:" + n);
    }

    private String printHeader() {
        StringBuffer stringBuffer = new StringBuffer("% ");
        stringBuffer.append(this.settings.OUTPUTFILE_HEADER + "\n% " + this.settings.OUTPUTFILE_HEADER_BUGS + "\n");
        if (this.essencePmodel.getAmountOfCommonSubExpressionsUsed() > 0) {
            stringBuffer.append("%\n% eliminated " + this.essencePmodel.getAmountOfCommonSubExpressionsUsed() + " common subexpressions\n\n");
        }
        return stringBuffer.toString();
    }

    private StringBuffer printVariableDeclaration() throws Exception {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("\n% decision variable declaration\n");
        ArrayList<String> arrayList = this.essencePmodel.getDecisionVariablesNames();
        HashMap<String, Domain> hashMap = this.essencePmodel.getDecisionVariables();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            object2 = hashMap.get(string);
            if (object2 instanceof BoolDomain) {
                stringBuffer.append("var bool :" + string + "::output_var;\n");
                continue;
            }
            if (object2 instanceof BoundedIntRange) {
                object = ((BoundedIntRange)object2).getRange();
                stringBuffer.append("var " + object[0] + ".." + object[1] + ": " + string + "::output_var;\n");
                continue;
            }
            if (object2 instanceof ConstantArrayDomain) {
                object = ((ConstantArrayDomain)object2).getBaseDomain();
                ConstantDomain[] constantDomainArray = ((ConstantArrayDomain)object2).getIndexDomains();
                if (constantDomainArray.length > 1) {
                    throw new Exception("Sorry, cannot translate to FlatZinc since it does not support multi-dimensional arrays, like " + string);
                }
                int[] nArray = constantDomainArray[0].getRange();
                stringBuffer.append("array[" + nArray[0] + ".." + nArray[1] + "] of ");
                if (object instanceof BoolDomain) {
                    stringBuffer.append("var bool :" + string + "  ::output_array([" + nArray[0] + ".." + nArray[1] + "]);\n");
                    continue;
                }
                if (object instanceof BoundedIntRange) {
                    int[] nArray2 = ((BoundedIntRange)object).getRange();
                    stringBuffer.append("var " + nArray2[0] + ".." + nArray2[1] + " :" + string + " ::output_array([" + nArray[0] + ".." + nArray[1] + "]);\n");
                    continue;
                }
                throw new Exception("Cannot tailor to FlatZinc (yet) because FlatZinc does not support " + (!(object instanceof ConstantDomain) ? " problem classes, and domain " + object + " of variable " + string + " is not entirely constant." : "domains of type:" + object.getClass().getSimpleName() + " like " + object + " of variable " + string));
            }
            throw new Exception("Cannot tailor to FlatZinc (yet) because FlatZinc does not support " + (!(object2 instanceof ConstantDomain) ? " problem classes, and domain " + object2 + " of variable " + string + " is not entirely constant." : "domains of type:" + object2.getClass().getSimpleName() + " like " + object2 + " of variable " + string));
        }
        ArrayList<Variable> arrayList2 = this.essencePmodel.getAuxVariables();
        if (arrayList2.size() > 0) {
            stringBuffer.append("\n% auxiliary variables\n\n");
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            object2 = arrayList2.get(i);
            object = object2.getDomain();
            if (object == null || ((int[])object).length == 0) {
                throw new Exception("FlatZinc does not support problem classes and auxiliary variable " + object2 + " ranges over a non-constant domain");
            }
            if (object[0] == 0 && object[1] == 1) {
                stringBuffer.append("var bool: " + object2.getVariableName() + ";\n");
                continue;
            }
            stringBuffer.append("var " + object[0] + ".." + object[1] + ": " + object2.getVariableName() + ";\n");
        }
        return stringBuffer;
    }

    public String getEssenceSolution(String string) {
        return string;
    }

    private String readVariableSolution(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        while (stringBuffer.charAt(0) != '=' && stringBuffer.length() != 0) {
            stringBuffer2.append(stringBuffer.charAt(0));
            stringBuffer.deleteCharAt(0);
        }
        stringBuffer.deleteCharAt(0);
        stringBuffer2.append("is ");
        while (stringBuffer.charAt(0) != ';' && stringBuffer.length() != 0) {
            stringBuffer2.append(stringBuffer.deleteCharAt(0));
        }
        stringBuffer.deleteCharAt(0);
        stringBuffer.deleteCharAt(0);
        return stringBuffer2.toString();
    }
}

