/*
 * Decompiled with CFR 0.152.
 */
package translator.solver;

import java.util.HashMap;
import translator.TranslationSettings;
import translator.solver.TargetSolver;

public abstract class GeneralTargetSolver
implements TargetSolver {
    protected HashMap<Integer, Boolean> featureMap;
    protected String solverName;
    protected String inputFileExtension;
    protected String version;
    protected String[] varBranchingStrategies;
    protected String[] valBranchingStrategies;
    protected String[] searchStrategies;
    protected String varBranchingStrategy;
    protected String valBranchingStrategy;
    protected String searchStrategy;
    protected int arrayIndexStart;
    TranslationSettings settings;

    public GeneralTargetSolver(TranslationSettings translationSettings) {
        this.settings = translationSettings;
    }

    public String getSolverName() {
        return this.solverName;
    }

    public String getSolverInputExtension() {
        return this.inputFileExtension;
    }

    public String getVersion() {
        return this.version;
    }

    public void setFeature(char c, boolean bl) {
        if (this.featureMap.containsKey(Character.valueOf(c))) {
            this.featureMap.put(new Integer(c), new Boolean(bl));
        }
    }

    public boolean supportsNestedExpressions() {
        return this.featureMap.get(new Integer(69));
    }

    public String getVarBranchingStrategy() {
        return this.varBranchingStrategy;
    }

    public String getValBranchingStrategy() {
        return this.valBranchingStrategy;
    }

    public String getSearchStrategy() {
        return this.searchStrategy;
    }

    public void setVarBranchingStrategy(String string) {
        if (this.supportsVarBranchingStrategy(string)) {
            this.varBranchingStrategy = string;
        }
    }

    public void setValBranchingStrategy(String string) {
        if (this.supportsValBranchingStrategy(string)) {
            this.valBranchingStrategy = string;
        }
    }

    public void setSearchStrategy(String string) {
        if (this.supportsSearchStrategy(string)) {
            this.searchStrategy = string;
        }
    }

    public boolean supportsVarBranchingStrategy(String string) {
        for (int i = 0; i < this.varBranchingStrategies.length; ++i) {
            if (this.varBranchingStrategies[i] != string) continue;
            return true;
        }
        return false;
    }

    public boolean supportsValBranchingStrategy(String string) {
        for (int i = 0; i < this.valBranchingStrategies.length; ++i) {
            if (this.valBranchingStrategies[i] != string) continue;
            return true;
        }
        return false;
    }

    public boolean supportsSearchStrategy(String string) {
        for (int i = 0; i < this.searchStrategies.length; ++i) {
            if (this.searchStrategies[i] != string) continue;
            return true;
        }
        return false;
    }

    public String[] getVarBranchingStrategies() {
        return this.varBranchingStrategies;
    }

    public String[] getValBranchingStrategies() {
        return this.varBranchingStrategies;
    }

    public String[] getSearchStrategies() {
        return this.searchStrategies;
    }

    public void setSearchOverAuxiliaryVariables(boolean bl) {
        this.featureMap.put(new Integer(200), bl);
    }

    public boolean willSearchOverAuxiliaryVariables() {
        return this.featureMap.get(new Integer(200));
    }

    public boolean supportsConstraint(int n) {
        switch (n) {
            case 201: {
                return this.featureMap.get(new Integer(300));
            }
            case 202: {
                return this.featureMap.get(new Integer(301));
            }
            case 203: {
                return this.featureMap.get(new Integer(302));
            }
            case 290: {
                return this.featureMap.get(new Integer(76));
            }
            case 251: {
                return this.featureMap.get(new Integer(75));
            }
            case 252: {
                return this.featureMap.get(new Integer(84));
            }
            case 254: {
                return this.featureMap.get(new Integer(82));
            }
            case 257: {
                return this.featureMap.get(new Integer(80));
            }
            case 255: {
                return this.featureMap.get(new Integer(86));
            }
            case 253: {
                return this.featureMap.get(new Integer(88));
            }
            case 280: {
                return this.featureMap.get(new Integer(77));
            }
            case 270: {
                return this.featureMap.get(new Integer(78));
            }
            case 271: {
                return this.featureMap.get(new Integer(83));
            }
            case 275: {
                return this.featureMap.get(new Integer(81));
            }
            case 273: {
                return this.featureMap.get(new Integer(79));
            }
            case 274: {
                return this.featureMap.get(new Integer(85));
            }
            case 272: {
                return this.featureMap.get(new Integer(87));
            }
            case 292: {
                return this.featureMap.get(new Integer(70));
            }
            case 291: {
                return this.featureMap.get(new Integer(70));
            }
            case 224: {
                return this.featureMap.get(501);
            }
            case 223: {
                return this.featureMap.get(500);
            }
            case 225: {
                return this.featureMap.get(502);
            }
            case 221: {
                return this.featureMap.get(504);
            }
            case 120: {
                return this.featureMap.get(89);
            }
            case 121: {
                return this.featureMap.get(89);
            }
        }
        System.out.println("Could not match the constraint type: " + n + " so I don;t know if the target solver supports it");
        return false;
    }

    public boolean supportsReificationOf(int n) {
        switch (n) {
            case 220: {
                return this.featureMap.get(new Integer(287));
            }
            case 116: {
                return this.featureMap.get(new Integer(277));
            }
            case 115: {
                return this.featureMap.get(new Integer(265));
            }
            case 104: {
                return this.featureMap.get(new Integer(278));
            }
            case 108: {
                return this.featureMap.get(new Integer(279));
            }
            case 102: {
                return this.featureMap.get(new Integer(280));
            }
            case 106: {
                return this.featureMap.get(new Integer(281));
            }
            case 105: {
                return this.featureMap.get(new Integer(282));
            }
            case 109: {
                return this.featureMap.get(new Integer(283));
            }
            case 222: {
                return this.featureMap.get(new Integer(284));
            }
            case 290: {
                return this.featureMap.get(new Integer(286));
            }
            case 251: {
                return this.featureMap.get(new Integer(285));
            }
            case 252: {
                return this.featureMap.get(new Integer(294));
            }
            case 254: {
                return this.featureMap.get(new Integer(290));
            }
            case 257: {
                return this.featureMap.get(new Integer(292));
            }
            case 255: {
                return this.featureMap.get(new Integer(296));
            }
            case 253: {
                return this.featureMap.get(new Integer(298));
            }
            case 280: {
                return this.featureMap.get(new Integer(289));
            }
            case 270: {
                return this.featureMap.get(new Integer(288));
            }
            case 271: {
                return this.featureMap.get(new Integer(295));
            }
            case 273: {
                return this.featureMap.get(new Integer(293));
            }
            case 275: {
                return this.featureMap.get(new Integer(291));
            }
            case 274: {
                return this.featureMap.get(new Integer(297));
            }
            case 272: {
                return this.featureMap.get(new Integer(299));
            }
            case 42: {
                return this.featureMap.get(new Integer(251));
            }
            case 40: {
                return this.featureMap.get(new Integer(250));
            }
            case 292: {
                return this.featureMap.get(new Integer(252));
            }
            case 118: {
                return this.featureMap.get(new Integer(252));
            }
            case 117: {
                return this.featureMap.get(new Integer(253));
            }
            case 291: {
                return this.featureMap.get(new Integer(253));
            }
            case 101: {
                return this.featureMap.get(new Integer(257));
            }
            case 100: {
                return this.featureMap.get(new Integer(258));
            }
            case 224: {
                return this.featureMap.get(260);
            }
            case 223: {
                return this.featureMap.get(259);
            }
            case 225: {
                return this.featureMap.get(261);
            }
            case 221: {
                return this.featureMap.get(262);
            }
            case 41: {
                return this.featureMap.get(256);
            }
            case 120: {
                return this.featureMap.get(263);
            }
            case 121: {
                return this.featureMap.get(264);
            }
            case 122: {
                return this.featureMap.get(266);
            }
            case 777: {
                return this.featureMap.get(269);
            }
        }
        return false;
    }

    public boolean supportsConstraintsNestedAsArgumentOf(int n) {
        switch (n) {
            case 41: {
                return this.featureMap.get(new Integer(100));
            }
            case 116: {
                return this.featureMap.get(new Integer(102));
            }
            case 115: {
                return this.featureMap.get(new Integer(109));
            }
            case 104: {
                return this.featureMap.get(new Integer(103));
            }
            case 108: {
                return this.featureMap.get(new Integer(104));
            }
            case 102: {
                return this.featureMap.get(new Integer(105));
            }
            case 106: {
                return this.featureMap.get(new Integer(106));
            }
            case 101: {
                return this.featureMap.get(new Integer(107));
            }
            case 100: {
                return this.featureMap.get(new Integer(108));
            }
            case 222: {
                return this.featureMap.get(new Integer(111));
            }
            case 201: {
                return this.featureMap.get(new Integer(112));
            }
            case 200: {
                return this.featureMap.get(new Integer(113));
            }
            case 290: {
                return this.featureMap.get(new Integer(115));
            }
            case 251: {
                return this.featureMap.get(new Integer(114));
            }
            case 252: {
                return this.featureMap.get(new Integer(121));
            }
            case 254: {
                return this.featureMap.get(new Integer(114));
            }
            case 257: {
                return this.featureMap.get(new Integer(119));
            }
            case 255: {
                return this.featureMap.get(new Integer(125));
            }
            case 253: {
                return this.featureMap.get(new Integer(123));
            }
            case 280: {
                return this.featureMap.get(new Integer(116));
            }
            case 270: {
                return this.featureMap.get(new Integer(117));
            }
            case 271: {
                return this.featureMap.get(new Integer(122));
            }
            case 275: {
                return this.featureMap.get(new Integer(120));
            }
            case 273: {
                return this.featureMap.get(new Integer(118));
            }
            case 274: {
                return this.featureMap.get(new Integer(126));
            }
            case 272: {
                return this.featureMap.get(new Integer(124));
            }
            case 42: {
                return this.featureMap.get(new Integer(128));
            }
            case 40: {
                return this.featureMap.get(new Integer(127));
            }
            case 117: {
                return this.featureMap.get(new Integer(110));
            }
            case 118: {
                return this.featureMap.get(new Integer(101));
            }
            case 120: {
                return this.featureMap.get(new Integer(130));
            }
            case 121: {
                return this.featureMap.get(new Integer(131));
            }
        }
        return false;
    }

    public boolean supportsSparseVariables() {
        return this.featureMap.get(new Integer(50));
    }

    public boolean supportsDiscreteBoundVariables() {
        return this.featureMap.get(new Integer(51));
    }

    public boolean supportsVariableArrayIndexing() {
        return this.featureMap.get(new Integer(52));
    }

    public int getArrayIndexingStartValue() {
        if (this.settings.getGenerateFlatzincOutput()) {
            return this.settings.getFlatZincArrayIndexStart();
        }
        return this.arrayIndexStart;
    }

    public void setFeature(int n, boolean bl) {
        this.featureMap.put(new Integer(n), new Boolean(bl));
    }

    public boolean supportsFeature(int n) {
        if (this.featureMap.containsKey(n)) {
            return this.featureMap.get(n);
        }
        return false;
    }

    public String toString() {
        return this.solverName;
    }
}

