/*
 * Decompiled with CFR 0.152.
 */
package translator.normaliser;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.AtomExpression;
import translator.expression.BinaryRelationalExpression;
import translator.expression.BoolDomain;
import translator.expression.BoundedExpressionRange;
import translator.expression.BoundedIntRange;
import translator.expression.Conjunction;
import translator.expression.ConstantArray;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.ConstantRestriction;
import translator.expression.Definition;
import translator.expression.Disjunction;
import translator.expression.Domain;
import translator.expression.DomainDefinition;
import translator.expression.EssencePrimeModel;
import translator.expression.Expression;
import translator.expression.ExpressionDefinition;
import translator.expression.ExpressionRange;
import translator.expression.GeneralDeclaration;
import translator.expression.InfiniteDomain;
import translator.expression.IntRange;
import translator.expression.MatrixDomain;
import translator.expression.Objective;
import translator.expression.ParameterDeclaration;
import translator.expression.QuantifiedExpression;
import translator.expression.QuantifiedSum;
import translator.expression.RelationalAtomExpression;
import translator.expression.SingleVariable;
import translator.expression.SparseExpressionRange;
import translator.expression.SparseIntRange;
import translator.expression.Sum;
import translator.expression.UnaryRelationalExpression;
import translator.expression.Variable;
import translator.expression.VariableDeclaration;
import translator.normaliser.NormalisedModel;
import translator.normaliser.NormaliserException;
import translator.normaliser.NormaliserSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Normaliser
implements NormaliserSpecification {
    HashMap<String, Domain> decisionVariables;
    ArrayList<String> decisionVariablesNames;
    HashMap<String, Expression[]> decisionVarIndexOffsets;
    HashMap<String, Domain> parameters;
    ArrayList<String> parameterNames;
    HashMap<String, ConstantArray> constantArrays;
    ArrayList<String> constantArrayNames;
    HashMap<String, int[]> constantArrayOffsets;
    HashMap<String, Domain> constantArrayDomains;
    HashMap<String, int[]> variableArrayOffsets;
    HashMap<String, Domain> parameterDomains;
    TranslationSettings settings;
    ArrayList<String> undefinedParameters;
    HashMap<String, Domain> quantifiedVarNamesMap = new HashMap();
    HashMap<String, ArrayList<String>> quantifiedDomainsMap = new HashMap();

    public Normaliser(TranslationSettings translationSettings) {
        this.decisionVariables = new HashMap();
        this.decisionVariablesNames = new ArrayList();
        this.decisionVarIndexOffsets = new HashMap();
        this.parameters = new HashMap();
        this.parameterNames = new ArrayList();
        this.constantArrays = new HashMap();
        this.constantArrayNames = new ArrayList();
        this.constantArrayDomains = new HashMap();
        this.constantArrayOffsets = new HashMap();
        this.variableArrayOffsets = new HashMap();
        this.parameterDomains = new HashMap();
        this.settings = translationSettings;
        this.undefinedParameters = new ArrayList();
    }

    @Override
    public NormalisedModel normalise(EssencePrimeModel essencePrimeModel, EssencePrimeModel essencePrimeModel2) throws NormaliserException, Exception {
        ArrayList<GeneralDeclaration> arrayList = this.readDeclarations(essencePrimeModel.getDeclarations());
        ArrayList<GeneralDeclaration> arrayList2 = essencePrimeModel2.getDeclarations();
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            arrayList.add(0, arrayList2.remove(i));
        }
        ArrayList<Expression> arrayList3 = essencePrimeModel.getConstraints();
        arrayList3.add(0, essencePrimeModel.getObjective());
        arrayList3 = this.insertParameters(arrayList, arrayList3);
        this.computeConstantArrayOffsets();
        this.adaptDecisionVariablesDomains();
        arrayList3 = this.updateExpressionTypes(arrayList3);
        arrayList3 = this.adaptIndicesToSolversInExpressions(arrayList3);
        arrayList3 = this.orderConstraints(arrayList3);
        arrayList3 = this.evaluateConstraints(arrayList3);
        arrayList3 = this.reduceExpressions(arrayList3);
        arrayList3 = this.restructureExpressions(arrayList3);
        arrayList3 = this.orderConstraints(arrayList3);
        if (this.settings.isClassLevelTransformation() || this.settings.flattenProblemClassOnly()) {
            arrayList3 = this.normaliseQuantifiersPC(arrayList3);
        }
        Objective objective = (Objective)arrayList3.remove(0);
        NormalisedModel normalisedModel = this.constantArrayNames.size() == 0 ? new NormalisedModel(this.settings, this.decisionVariables, this.decisionVariablesNames, arrayList3, objective, this.undefinedParameters, this.quantifiedVarNamesMap, this.quantifiedDomainsMap) : new NormalisedModel(this.settings, this.decisionVariables, this.decisionVariablesNames, arrayList3, this.constantArrays, this.constantArrayOffsets, objective, this.undefinedParameters, this.quantifiedVarNamesMap, this.quantifiedDomainsMap);
        normalisedModel.evaluateDomains();
        return normalisedModel;
    }

    private ArrayList<Expression> adaptIndicesToSolversInExpressions(ArrayList<Expression> arrayList) {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            String string = this.decisionVariablesNames.get(i);
            Domain domain = this.decisionVariables.get(string);
            if (!(domain instanceof MatrixDomain)) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList.get(j).adaptIndicesForSolver(string, this.decisionVarIndexOffsets.get(string));
            }
        }
        return arrayList;
    }

    private void adaptDecisionVariablesDomains() {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            int n;
            Object[] objectArray;
            int n2;
            Domain[] domainArray;
            MatrixDomain matrixDomain;
            String string = this.decisionVariablesNames.get(i);
            Domain domain = this.decisionVariables.get(string);
            if (domain instanceof ConstantArrayDomain) {
                matrixDomain = (ConstantArrayDomain)domain;
                domainArray = ((ConstantArrayDomain)matrixDomain).getIndexDomains();
                int n3 = this.settings.getTargetSolver().getArrayIndexingStartValue();
                Expression[] expressionArray = new Expression[domainArray.length];
                for (n2 = 0; n2 < domainArray.length; ++n2) {
                    if (n3 != domainArray[n2].getRange()[0]) {
                        IntRange intRange;
                        int n4 = domainArray[n2].getRange()[0] - n3;
                        expressionArray[n2] = new ArithmeticAtomExpression(n4);
                        if (domainArray[n2] instanceof BoundedIntRange) {
                            intRange = (BoundedIntRange)domainArray[n2];
                            ((BoundedIntRange)intRange).setLowerBound(n3);
                            ((BoundedIntRange)intRange).setUpperBound(((BoundedIntRange)intRange).getRange()[1] - n4);
                            domainArray[n2] = intRange;
                            continue;
                        }
                        if (!(domainArray[n2] instanceof SparseIntRange)) continue;
                        intRange = (SparseIntRange)domainArray[n2];
                        objectArray = ((SparseIntRange)intRange).getFullDomain();
                        for (n = 0; n < objectArray.length; ++n) {
                            objectArray[n] = objectArray[n] - n4;
                        }
                        ((SparseIntRange)intRange).setIntRange((int[])objectArray);
                        domainArray[n2] = intRange;
                        continue;
                    }
                    expressionArray[n2] = new ArithmeticAtomExpression(0);
                }
                ((ConstantArrayDomain)matrixDomain).setIndexDomains((ConstantDomain[])domainArray);
                this.decisionVariables.put(string, matrixDomain);
                this.decisionVarIndexOffsets.put(string, expressionArray);
                continue;
            }
            if (!(domain instanceof ArrayDomain)) continue;
            matrixDomain = (ArrayDomain)domain;
            domainArray = ((ArrayDomain)matrixDomain).getIndexDomains();
            Expression[] expressionArray = new Expression[domainArray.length];
            int n5 = this.settings.getTargetSolver().getArrayIndexingStartValue();
            for (n2 = 0; n2 < domainArray.length; ++n2) {
                ExpressionRange expressionRange;
                if (domainArray[n2] instanceof BoundedExpressionRange) {
                    expressionRange = (BoundedExpressionRange)domainArray[n2];
                    if (!((Object)((BoundedExpressionRange)expressionRange).getLowerBound()).toString().equals(n5 + "")) {
                        Expression expression = new Sum(new Expression[]{((BoundedExpressionRange)expressionRange).getLowerBound()}, new Expression[]{new ArithmeticAtomExpression(n5)});
                        expression = expression.reduceExpressionTree();
                        expression.orderExpression();
                        expressionArray[n2] = expression = expression.evaluate();
                        ((BoundedExpressionRange)expressionRange).setLowerBound(new ArithmeticAtomExpression(n5));
                        ((BoundedExpressionRange)expressionRange).setUpperBound(new Sum(new Expression[]{((BoundedExpressionRange)expressionRange).getUpperBound().copy()}, new Expression[]{expression}).reduceExpressionTree().evaluate());
                        domainArray[n2] = expressionRange;
                        continue;
                    }
                    expressionArray[n2] = new ArithmeticAtomExpression(0);
                    continue;
                }
                if (domainArray[n2] instanceof BoundedIntRange) {
                    expressionRange = (BoundedIntRange)domainArray[n2];
                    int n6 = ((BoundedIntRange)expressionRange).getRange()[0] - n5;
                    expressionArray[n2] = new ArithmeticAtomExpression(n6);
                    ((BoundedIntRange)expressionRange).setLowerBound(n5);
                    ((BoundedIntRange)expressionRange).setUpperBound(((BoundedIntRange)expressionRange).getRange()[1] - n6);
                    domainArray[n2] = expressionRange;
                    continue;
                }
                if (domainArray[n2] instanceof SparseIntRange) {
                    expressionRange = (SparseIntRange)domainArray[n2];
                    int n7 = ((SparseIntRange)expressionRange).getRange()[0] - n5;
                    expressionArray[n2] = new ArithmeticAtomExpression(n7);
                    objectArray = ((SparseIntRange)expressionRange).getFullDomain();
                    for (n = 0; n < objectArray.length; ++n) {
                        objectArray[n] = objectArray[n] - n7;
                    }
                    ((SparseIntRange)expressionRange).setIntRange((int[])objectArray);
                    domainArray[n2] = expressionRange;
                    continue;
                }
                if (!(domainArray[n2] instanceof SparseExpressionRange)) continue;
                expressionRange = (SparseExpressionRange)domainArray[n2];
                Expression expression = new Sum(new Expression[]{((SparseExpressionRange)expressionRange).getLowerAndUpperBound()[0]}, new Expression[]{new ArithmeticAtomExpression(n5)});
                expression = expression.reduceExpressionTree();
                expression.orderExpression();
                expressionArray[n2] = expression = expression.evaluate();
                objectArray = ((SparseExpressionRange)expressionRange).getExpressionRange();
                if (!((Object)expression).toString().equals(n5 + "")) {
                    for (n = 0; n < objectArray.length; ++n) {
                        objectArray[n] = (int)new Sum(new Expression[]{objectArray[n].copy()}, new Expression[]{expression}).reduceExpressionTree().evaluate();
                    }
                }
                ((SparseExpressionRange)expressionRange).setExpressionRange((Expression[])objectArray);
                domainArray[n2] = expressionRange;
            }
            ((ArrayDomain)matrixDomain).setIndexDomains(domainArray);
            this.decisionVariables.put(string, matrixDomain);
            this.decisionVarIndexOffsets.put(string, expressionArray);
        }
    }

    @Override
    public NormalisedModel normalise(EssencePrimeModel essencePrimeModel, EssencePrimeModel essencePrimeModel2, char c) throws NormaliserException, Exception {
        return this.normalise(essencePrimeModel, essencePrimeModel2);
    }

    private ArrayList<Expression> normaliseQuantifiersPC(ArrayList<Expression> arrayList) throws Exception {
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList.add(n, this.insertQuantifierDomainsInExpression(arrayList.remove(n)));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList.add(n, this.normaliseQuantifiedVariables(arrayList.remove(n)));
        }
        return arrayList;
    }

    public String printModel(EssencePrimeModel essencePrimeModel) {
        return essencePrimeModel.toString();
    }

    private ArrayList<GeneralDeclaration> readDeclarations(ArrayList<GeneralDeclaration> arrayList) throws NormaliserException {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            int n;
            ArrayList<String> arrayList2;
            GeneralDeclaration generalDeclaration;
            if (arrayList.get(i) instanceof VariableDeclaration) {
                generalDeclaration = (VariableDeclaration)arrayList.remove(i);
                arrayList2 = ((VariableDeclaration)generalDeclaration).getNames();
                for (n = arrayList2.size() - 1; n >= 0; --n) {
                    this.decisionVariables.put(arrayList2.get(n), ((VariableDeclaration)generalDeclaration).getDomain());
                    this.decisionVariablesNames.add(0, arrayList2.remove(n));
                }
                continue;
            }
            if (arrayList.get(i) instanceof ParameterDeclaration) {
                generalDeclaration = (ParameterDeclaration)arrayList.remove(i);
                arrayList2 = ((ParameterDeclaration)generalDeclaration).getNames();
                for (n = arrayList2.size() - 1; n >= 0; --n) {
                    this.parameters.put(arrayList2.get(n), ((ParameterDeclaration)generalDeclaration).getDomain());
                    this.parameterNames.add(0, arrayList2.get(n));
                }
                if (((ParameterDeclaration)generalDeclaration).getDomain() == null) continue;
                Domain domain = ((ParameterDeclaration)generalDeclaration).getDomain();
                for (int j = arrayList2.size() - 1; j >= 0; --j) {
                    this.parameterDomains.put(arrayList2.remove(j), domain);
                }
                continue;
            }
            if (!(arrayList.get(i) instanceof ExpressionDefinition) || !(((ExpressionDefinition)(generalDeclaration = (ExpressionDefinition)arrayList.get(i))).getExpression() instanceof ConstantArray) || ((ExpressionDefinition)generalDeclaration).getDomain() == null) continue;
            this.constantArrayDomains.put(((ExpressionDefinition)generalDeclaration).getName(), ((ExpressionDefinition)generalDeclaration).getDomain());
        }
        return arrayList;
    }

    private ArrayList<Expression> insertParameters(ArrayList<GeneralDeclaration> arrayList, ArrayList<Expression> arrayList2) throws NormaliserException, Exception {
        Object object;
        int n;
        Object object2;
        int n2;
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        HashMap<String, Domain> hashMap2 = new HashMap<String, Domain>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<Expression> arrayList5 = new ArrayList();
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            arrayList2.add(n2, arrayList2.remove(n2).reduceExpressionTree());
        }
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            if (arrayList.get(n2) instanceof ExpressionDefinition) {
                object2 = (ExpressionDefinition)arrayList.get(n2);
                hashMap.put(((ExpressionDefinition)object2).getName(), ((ExpressionDefinition)object2).getExpression());
                arrayList3.add(((ExpressionDefinition)object2).getName());
                continue;
            }
            if (arrayList.get(n2) instanceof DomainDefinition) {
                object2 = (DomainDefinition)arrayList.get(n2);
                hashMap2.put(((DomainDefinition)object2).getName(), ((DomainDefinition)object2).getDomain());
                arrayList4.add(((DomainDefinition)object2).getName());
                continue;
            }
            if (arrayList.get(n2) instanceof ConstantRestriction) {
                object2 = ((ConstantRestriction)arrayList.remove(n2)).getExpression();
                if (arrayList5.size() == 0) {
                    arrayList5 = object2;
                    continue;
                }
                if (((ArrayList)object2).size() > arrayList5.size()) {
                    for (n = arrayList5.size() - 1; n >= 0; --n) {
                        ((ArrayList)object2).add(arrayList5.remove(n));
                    }
                    arrayList5 = object2;
                    continue;
                }
                for (n = ((ArrayList)object2).size() - 1; n >= 0; --n) {
                    arrayList5.add((Expression)((ArrayList)object2).remove(n));
                }
                continue;
            }
            throw new NormaliserException("Internal error. Unknow definition/declaration type: " + arrayList.get(n2));
        }
        if (this.settings.isClassLevelTransformation()) {
            for (n2 = 0; n2 < this.parameterNames.size(); ++n2) {
                int n3;
                object2 = this.parameterNames.get(n2);
                n = 0;
                for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                    object = (String)arrayList4.get(n3);
                    if (!((String)object2).equals(object)) continue;
                    n = 1;
                }
                for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                    object = (String)arrayList3.get(n3);
                    if (!((String)object2).equals(object)) continue;
                    n = 1;
                }
                if (n != 0) continue;
                this.undefinedParameters.add((String)object2);
            }
            if (this.settings.isClassLevelTransformation() && this.undefinedParameters.size() > 0) {
                for (n2 = 0; n2 < this.undefinedParameters.size(); ++n2) {
                    String string;
                    int n4;
                    Expression expression;
                    object2 = this.undefinedParameters.get(n2);
                    Domain domain = this.parameters.get(object2);
                    if (domain == null) {
                        throw new NormaliserException("Unknown/Undefined variable: " + (String)object2);
                    }
                    if (domain instanceof ArrayDomain) continue;
                    if (domain instanceof InfiniteDomain) {
                        expression = null;
                        object = null;
                        if (domain.getType() == 21) {
                            expression = ((InfiniteDomain)domain).getUpperBound();
                        } else if (domain.getType() == 20) {
                            object = ((InfiniteDomain)domain).getLowerBound();
                        }
                        if (expression == null) {
                            expression = new ArithmeticAtomExpression(this.settings.getMaxUpperBound());
                        }
                        if (object == null) {
                            object = new ArithmeticAtomExpression(this.settings.getMaxLowerBound());
                        }
                        domain = new BoundedExpressionRange((Expression)object, expression);
                    }
                    expression = new SingleVariable((String)object2, domain);
                    object = null;
                    object = domain instanceof BoolDomain ? new RelationalAtomExpression((Variable)expression) : new ArithmeticAtomExpression((Variable)expression);
                    object.setIsParameter(true);
                    for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                        arrayList2.add(n4, arrayList2.remove(n4).replaceVariableWithExpression((String)object2, (Expression)object));
                    }
                    for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                        string = arrayList3.get(n4);
                        hashMap.put(string, hashMap.get(string).replaceVariableWithExpression((String)object2, (Expression)object));
                    }
                    for (n4 = 0; n4 < arrayList4.size(); ++n4) {
                        string = arrayList4.get(n4);
                        hashMap2.put(string, hashMap2.get(string).replaceVariableWithExpression((String)object2, (Expression)object));
                    }
                    for (n4 = 0; n4 < this.parameterNames.size(); ++n4) {
                        string = this.parameterNames.get(n4);
                        this.parameterDomains.put(string, this.parameterDomains.get(string).replaceVariableWithExpression((String)object2, (Expression)object));
                    }
                    for (n4 = 0; n4 < arrayList5.size(); ++n4) {
                        arrayList5.add(n4, arrayList5.remove(n4).replaceVariableWithExpression((String)object2, (Expression)object));
                    }
                }
            }
        }
        n2 = arrayList.size();
        int n5 = 0;
        for (int i = 0; i < n2 && n5 < arrayList.size() && n5 >= 0; ++i) {
            if (!(arrayList.get(n5) instanceof ExpressionDefinition)) continue;
            Definition definition = (ExpressionDefinition)arrayList.remove(n5);
            object = ((ExpressionDefinition)definition).getName();
            if (this.decisionVariables.containsKey(object)) {
                throw new NormaliserException("Parameter " + (String)object + " has the same name as decision variable.");
            }
            Object object3 = (Expression)hashMap.get(object);
            if ((object3 = object3.evaluate()) instanceof ArithmeticAtomExpression) {
                int n6 = ((ArithmeticAtomExpression)object3).getConstant();
                arrayList2 = this.insertValueForVariable(n6, (String)object, arrayList2);
                this.insertValueForVariableInDomains(n6, (String)object);
                hashMap = this.insertValueForVariableInParameterExpression(n6, (String)object, hashMap, arrayList3);
                hashMap2 = this.insertValueForVariableInParameterDomain(n6, (String)object, hashMap2, arrayList4);
                this.parameterDomains = this.insertValueForVariableInParameterDomain(n6, (String)object, this.parameterDomains, this.parameterNames);
                arrayList5 = this.insertValueForVariable(n6, (String)object, arrayList5);
                continue;
            }
            if (object3 instanceof RelationalAtomExpression) {
                boolean bl = ((RelationalAtomExpression)object3).getBool();
                arrayList2 = this.insertValueForVariable(bl, (String)object, arrayList2);
                this.insertValueForVariableInDomains(bl, (String)object);
                hashMap = this.insertValueForVariableInParameterExpression(bl, (String)object, hashMap, arrayList3);
                hashMap2 = this.insertValueForVariableInParameterDomain(bl, (String)object, hashMap2, arrayList4);
                this.parameterDomains = this.insertValueForVariableInParameterDomain(bl, (String)object, this.parameterDomains, this.parameterNames);
                arrayList5 = this.insertValueForVariable(bl, (String)object, arrayList5);
                continue;
            }
            if (!(object3 instanceof ConstantArray)) continue;
            ConstantArray constantArray = (ConstantArray)object3;
            arrayList2 = this.insertExpressionForVariable(constantArray, (String)object, arrayList2);
            this.constantArrays.put((String)object, constantArray);
            this.constantArrayNames.add((String)object);
            if (((ExpressionDefinition)definition).getDomain() == null) continue;
            this.constantArrayDomains.put(((ExpressionDefinition)definition).getName(), ((ExpressionDefinition)definition).getDomain());
        }
        for (int i = 0; i < arrayList5.size(); ++i) {
            object = (Expression)arrayList5.get(i);
            Expression expression = object.copy().evaluate();
            if (expression.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)expression).getBool();
                if (bl) continue;
                throw new NormaliserException("Your problem model/problem instance does not hold with the constant restriction:" + object);
            }
            throw new NormaliserException("Could not evaluate the constant restriction '" + object + "' to true or false." + "Please make sure that all constants/parameters have been declared and defined in the right order.");
        }
        return arrayList2;
    }

    private void computeConstantArrayOffsets() throws NormaliserException {
        int n;
        ArrayList arrayList = (ArrayList)this.constantArrayNames.clone();
        for (n = 0; n < this.parameterNames.size(); ++n) {
            arrayList.add(this.parameterNames.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int[] nArray;
            ConstantDomain constantDomain;
            int n2;
            int[] nArray2;
            ConstantArrayDomain constantArrayDomain;
            Object object;
            String string = (String)arrayList.get(n);
            if (!this.constantArrays.containsKey(string)) continue;
            ConstantArray constantArray = this.constantArrays.get(string);
            if (constantArray.getArrayDomain() != null) {
                object = constantArray.getArrayDomain();
                if (!((object = object.evaluate()) instanceof ConstantArrayDomain)) {
                    throw new NormaliserException("Infeasible domain for constant array '" + string + "'. " + object + " is " + (object instanceof ArrayDomain ? "not constant.\nPlease declare all parameters and constants before using them." : "not an array domain.") + "");
                }
                constantArrayDomain = (ConstantArrayDomain)object;
                nArray2 = new int[constantArrayDomain.getIndexDomains().length];
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    constantDomain = constantArrayDomain.getIndexDomains()[n2];
                    nArray2[n2] = constantDomain.getRange()[0];
                }
                this.constantArrayOffsets.put(string, nArray2);
                continue;
            }
            if (this.parameterDomains.containsKey(string)) {
                object = this.parameterDomains.get(string).evaluate();
                if (!(object instanceof ConstantArrayDomain)) {
                    throw new NormaliserException("Cannot compute offsets of indices of constant array \n" + string + " when its domain '" + object + "' is not constant.\nPlease declare all parameters and constants before using them.");
                }
                constantArrayDomain = (ConstantArrayDomain)object;
                nArray2 = new int[constantArrayDomain.getIndexDomains().length];
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    constantDomain = constantArrayDomain.getIndexDomains()[n2];
                    nArray2[n2] = constantDomain.getRange()[0];
                }
                this.constantArrayOffsets.put(string, nArray2);
                continue;
            }
            if (constantArray.getDimension() == 1) {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = 1;
                nArray = nArray4;
                nArray4[1] = 1;
            }
            object = nArray;
            this.constantArrayOffsets.put(string, (int[])object);
        }
    }

    private ArrayList<Expression> insertExpressionForVariable(Expression expression, String string, ArrayList<Expression> arrayList) throws Exception {
        for (int i = 0; i < arrayList.size(); ++i) {
            Expression expression2 = arrayList.remove(i);
            expression2 = expression2.replaceVariableWithExpression(string, expression);
            arrayList.add(i, expression2);
        }
        return arrayList;
    }

    private ArrayList<Expression> insertDomainForVariable(Domain domain, String string, ArrayList<Expression> arrayList) throws NormaliserException, Exception {
        for (int i = 0; i < arrayList.size(); ++i) {
            Expression expression = arrayList.remove(i);
            expression = expression.insertDomainForVariable(domain.copy(), string);
            expression = expression.evaluate();
            arrayList.add(i, expression);
        }
        return arrayList;
    }

    private HashMap<String, Expression> insertValueForVariableInParameterExpression(int n, String string, HashMap<String, Expression> hashMap, ArrayList<String> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            Expression expression = hashMap.get(string2);
            expression = expression.insertValueForVariable(n, string);
            hashMap.put(string2, expression);
        }
        return hashMap;
    }

    private HashMap<String, Domain> insertValueForVariableInParameterDomain(int n, String string, HashMap<String, Domain> hashMap, ArrayList<String> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            Domain domain = hashMap.get(string2);
            if (domain == null) continue;
            domain = domain.insertValueForVariable(n, string);
            hashMap.put(string2, domain);
        }
        return hashMap;
    }

    private HashMap<String, Domain> insertValueForVariableInParameterDomain(boolean bl, String string, HashMap<String, Domain> hashMap, ArrayList<String> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            Domain domain = hashMap.get(string2);
            domain = domain.insertValueForVariable(bl, string);
            hashMap.put(string2, domain);
        }
        return hashMap;
    }

    private HashMap<String, Expression> insertValueForVariableInParameterExpression(boolean bl, String string, HashMap<String, Expression> hashMap, ArrayList<String> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            Expression expression = hashMap.get(string2);
            expression = expression.insertValueForVariable(bl, string);
            hashMap.put(string2, expression);
        }
        return hashMap;
    }

    private void insertValueForVariableInDomains(int n, String string) throws NormaliserException {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            String string2 = this.decisionVariablesNames.get(i);
            Domain domain = this.decisionVariables.get(string2);
            if (domain == null) {
                throw new NormaliserException("Internal error. Cannot find decision variable '" + string2 + " in Domain-HashMap.");
            }
            domain = domain.insertValueForVariable(n, string);
            this.decisionVariables.put(string2, domain);
        }
    }

    private void insertValueForVariableInDomains(Domain domain, String string) throws NormaliserException {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            String string2 = this.decisionVariablesNames.get(i);
            Domain domain2 = this.decisionVariables.get(string2);
            if (domain2 == null) {
                throw new NormaliserException("Internal error. Cannot find decision variable '" + string2 + " in Domain-HashMap.");
            }
            domain2 = domain2.replaceVariableWithDomain(string, domain);
            this.decisionVariables.put(string2, domain2);
        }
    }

    private HashMap<String, Domain> insertValueForVariableInDomains(Domain domain, String string, HashMap<String, Domain> hashMap, ArrayList<String> arrayList) throws NormaliserException {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            Domain domain2 = hashMap.get(string2);
            if (domain2 == null) continue;
            domain2 = domain2.replaceVariableWithDomain(string, domain);
            hashMap.put(string2, domain2);
        }
        return hashMap;
    }

    private void insertValueForVariableInDomains(boolean bl, String string) throws NormaliserException {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            String string2 = this.decisionVariablesNames.get(i);
            Domain domain = this.decisionVariables.get(string2);
            if (domain == null) {
                throw new NormaliserException("Internal error. Cannot find decision variable '" + string2 + " in Domain-HashMap.");
            }
            domain = domain.insertValueForVariable(bl, string);
            this.decisionVariables.put(string2, domain);
        }
    }

    private ArrayList<Expression> insertValueForVariable(int n, String string, ArrayList<Expression> arrayList) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Expression expression = arrayList.remove(i);
            expression = expression.insertValueForVariable(n, string);
            expression = expression.evaluate();
            arrayList.add(i, expression);
        }
        return arrayList;
    }

    private ArrayList<Expression> insertValueForVariable(boolean bl, String string, ArrayList<Expression> arrayList) {
        for (int i = arrayList.size() - 1; i >= 0; ++i) {
            Expression expression = arrayList.remove(i);
            expression = expression.insertValueForVariable(bl, string);
            arrayList.add(i, expression);
        }
        return arrayList;
    }

    private ArrayList<Expression> updateExpressionTypes(ArrayList<Expression> arrayList) throws NormaliserException, Exception {
        return arrayList;
    }

    private ArrayList<Expression> orderConstraints(ArrayList<Expression> arrayList) throws NormaliserException {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).orderExpression();
        }
        return arrayList;
    }

    private ArrayList<Expression> reduceExpressions(ArrayList<Expression> arrayList) throws NormaliserException {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.add(i, arrayList.remove(i).reduceExpressionTree());
        }
        return arrayList;
    }

    private ArrayList<Expression> restructureExpressions(ArrayList<Expression> arrayList) throws NormaliserException {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.add(i, arrayList.remove(i).restructure());
        }
        return arrayList;
    }

    private ArrayList<Expression> evaluateConstraints(ArrayList<Expression> arrayList) throws NormaliserException {
        this.reduceExpressions(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.add(i, arrayList.remove(i).evaluate());
        }
        return this.reduceExpressions(arrayList);
    }

    private Expression normaliseQuantifiedVariables(Expression expression) throws Exception {
        ArrayList<Expression> arrayList = this.removeDuplicates(expression.getQuantifyingVariables());
        if (arrayList == null || arrayList.size() == 0) {
            return expression;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            int n;
            Object object2;
            if (!(arrayList.get(i) instanceof AtomExpression)) {
                throw new Exception("Internal error. Expected atom expression as quantified var instead of " + arrayList.get(i) + "" + " of type:" + arrayList.get(i).getClass().getSimpleName());
            }
            AtomExpression atomExpression = (AtomExpression)arrayList.get(i);
            if (!(atomExpression.getVariable() instanceof SingleVariable)) {
                throw new Exception("Internal error. Expected single variable as quantified var instead of " + atomExpression + "" + " of type:" + atomExpression.getVariable().getClass().getSimpleName());
            }
            SingleVariable singleVariable = (SingleVariable)atomExpression.getVariable();
            Domain domain = singleVariable.getExplicitDomain().evaluate();
            if (this.quantifiedDomainsMap.containsKey(((Object)domain).toString())) {
                int n2;
                boolean bl;
                object2 = this.quantifiedDomainsMap.get(((Object)domain).toString());
                boolean bl2 = false;
                for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                    String string = (String)((ArrayList)object2).get(n);
                    if (!singleVariable.getVariableName().equals(string.toString())) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                if (this.quantifiedVarNamesMap.containsKey(singleVariable.getVariableName())) {
                    String string;
                    CharSequence charSequence = null;
                    for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                        object = (String)((ArrayList)object2).get(j);
                        bl = false;
                        for (n2 = 0; n2 < arrayList.size(); ++n2) {
                            if (n2 == i || !((Object)arrayList.get(n2)).toString().equals(object)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        charSequence = object;
                    }
                    if (charSequence != null) {
                        string = new String(singleVariable.getVariableName());
                        singleVariable.setVariableName((String)charSequence);
                        atomExpression.setVariable(singleVariable);
                        expression.replaceVariableWithExpression(string, atomExpression);
                        continue;
                    }
                    string = new String(singleVariable.getVariableName());
                    object = new StringBuffer(singleVariable.getVariableName());
                    bl = false;
                    n2 = 0;
                    do {
                        ((StringBuffer)object).append(string);
                        n2 = this.quantifiedVarNamesMap.containsKey(((StringBuffer)object).toString()) ? 1 : 0;
                        bl = false;
                        for (int j = 0; j < arrayList.size(); ++j) {
                            if (j == i || !((StringBuffer)object).toString().equals(((Object)arrayList.get(j)).toString())) continue;
                            bl = true;
                        }
                    } while (bl || n2 != 0);
                    singleVariable.setVariableName(((StringBuffer)object).toString());
                    atomExpression.setVariable(singleVariable);
                    expression.replaceVariableWithExpression(string, atomExpression);
                    ((ArrayList)object2).add(singleVariable.getVariableName());
                    this.quantifiedDomainsMap.put(((Object)domain).toString(), (ArrayList<String>)object2);
                    this.quantifiedVarNamesMap.put(singleVariable.getVariableName(), domain);
                    continue;
                }
                CharSequence charSequence = null;
                for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                    object = (String)((ArrayList)object2).get(j);
                    bl = false;
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        if (n2 == i || !((Object)arrayList.get(n2)).toString().equals(object)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    charSequence = object;
                }
                if (charSequence != null) {
                    String string = new String(singleVariable.getVariableName());
                    singleVariable.setVariableName((String)charSequence);
                    atomExpression.setVariable(singleVariable);
                    expression.replaceVariableWithExpression(string, atomExpression);
                    continue;
                }
                ((ArrayList)object2).add(singleVariable.getVariableName());
                this.quantifiedDomainsMap.put(((Object)domain).toString(), (ArrayList<String>)object2);
                this.quantifiedVarNamesMap.put(singleVariable.getVariableName(), domain);
                continue;
            }
            if (this.quantifiedVarNamesMap.containsKey(singleVariable.getVariableName())) {
                object2 = new String(singleVariable.getVariableName());
                StringBuffer stringBuffer = new StringBuffer(singleVariable.getVariableName());
                n = 0;
                boolean bl = false;
                do {
                    stringBuffer.append((String)object2);
                    bl = this.quantifiedVarNamesMap.containsKey(stringBuffer.toString());
                    n = 0;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (j == i || !stringBuffer.toString().equals(((Object)arrayList.get(j)).toString())) continue;
                        n = 1;
                    }
                } while (n != 0 || bl);
                singleVariable.setVariableName(stringBuffer.toString());
                atomExpression.setVariable(singleVariable);
                expression.replaceVariableWithExpression((String)object2, atomExpression);
                object = new ArrayList();
                ((ArrayList)object).add(singleVariable.getVariableName());
                this.quantifiedDomainsMap.put(((Object)domain).toString(), (ArrayList<String>)object);
                this.quantifiedVarNamesMap.put(singleVariable.getVariableName(), domain);
                continue;
            }
            object2 = new ArrayList();
            ((ArrayList)object2).add((String)singleVariable.getVariableName());
            this.quantifiedDomainsMap.put(((Object)domain).toString(), (ArrayList<String>)object2);
            this.quantifiedVarNamesMap.put(singleVariable.getVariableName(), domain);
        }
        return expression;
    }

    private Expression insertQuantifierDomainsInExpression(Expression expression) throws Exception {
        if (expression instanceof QuantifiedExpression) {
            QuantifiedExpression quantifiedExpression = (QuantifiedExpression)expression;
            Expression expression2 = quantifiedExpression.getQuantifiedExpression();
            expression2 = this.insertQuantifierDomainsInExpression(expression2);
            String[] stringArray = quantifiedExpression.getQuantifiedVariables();
            Domain domain = quantifiedExpression.getQuantifiedDomain();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                ArithmeticAtomExpression arithmeticAtomExpression = new ArithmeticAtomExpression(new SingleVariable(string, domain));
                arithmeticAtomExpression.setIsQuantifiedVariable(true);
                expression2 = expression2.replaceVariableWithExpression(string, arithmeticAtomExpression);
            }
            quantifiedExpression.setQuantifiedExpression(expression2);
            return quantifiedExpression;
        }
        if (expression instanceof QuantifiedSum) {
            QuantifiedSum quantifiedSum = (QuantifiedSum)expression;
            Expression expression3 = quantifiedSum.getQuantifiedExpression();
            expression3 = this.insertQuantifierDomainsInExpression(expression3);
            String[] stringArray = quantifiedSum.getQuantifiedVariables();
            Domain domain = quantifiedSum.getQuantifiedDomain();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                ArithmeticAtomExpression arithmeticAtomExpression = new ArithmeticAtomExpression(new SingleVariable(string, domain));
                arithmeticAtomExpression.setIsQuantifiedVariable(true);
                expression3 = expression3.replaceVariableWithExpression(string, arithmeticAtomExpression);
            }
            quantifiedSum.setQuantifiedExpression(expression3);
            return quantifiedSum;
        }
        if (expression instanceof BinaryRelationalExpression) {
            BinaryRelationalExpression binaryRelationalExpression = (BinaryRelationalExpression)expression;
            Expression expression4 = this.insertQuantifierDomainsInExpression(binaryRelationalExpression.getLeftArgument());
            Expression expression5 = this.insertQuantifierDomainsInExpression(binaryRelationalExpression.getRightArgument());
            binaryRelationalExpression.setLeftExpression(expression4);
            binaryRelationalExpression.setRightExpression(expression5);
            return binaryRelationalExpression;
        }
        if (expression instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)expression;
            ArrayList<Expression> arrayList = conjunction.getArguments();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.add(i, this.insertQuantifierDomainsInExpression(arrayList.remove(i)));
            }
            conjunction.setArguments(arrayList);
            return conjunction;
        }
        if (expression instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)expression;
            ArrayList<Expression> arrayList = disjunction.getArguments();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.add(i, this.insertQuantifierDomainsInExpression(arrayList.remove(i)));
            }
            disjunction.setArguments(arrayList);
            return disjunction;
        }
        if (expression instanceof UnaryRelationalExpression) {
            Expression expression6 = ((UnaryRelationalExpression)expression).getArgument();
            expression6 = this.insertQuantifierDomainsInExpression(expression6);
            ((UnaryRelationalExpression)expression).setArgument(expression6);
            return expression;
        }
        if (expression instanceof Sum) {
            ArrayList<Expression> arrayList = ((Sum)expression).getPositiveArguments();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.add(i, this.insertQuantifierDomainsInExpression(arrayList.remove(i)));
            }
            ArrayList<Expression> arrayList2 = ((Sum)expression).getNegativeArguments();
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList2.add(i, this.insertQuantifierDomainsInExpression(arrayList2.remove(i)));
            }
            ((Sum)expression).setNegativeArguments(arrayList2);
            ((Sum)expression).setPositiveArguments(arrayList);
            return expression;
        }
        return expression;
    }

    private ArrayList<Expression> removeDuplicates(ArrayList<Expression> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Expression expression = arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                if (!((Object)expression).toString().equals(((Object)arrayList.get(j)).toString())) continue;
                arrayList.remove(j);
            }
        }
        return arrayList;
    }
}

