/*
 * Decompiled with CFR 0.152.
 */
package translator.normaliser;

import java.util.ArrayList;
import java.util.HashMap;
import translator.TranslationSettings;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.ArrayVariable;
import translator.expression.BoolDomain;
import translator.expression.BoundedIntRange;
import translator.expression.Conjunction;
import translator.expression.ConstantArray;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.MatrixDomain;
import translator.expression.Objective;
import translator.expression.SingleIntRange;
import translator.expression.SingleVariable;
import translator.expression.Variable;
import translator.normaliser.NormaliserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalisedModel {
    public HashMap<String, ConstantArray> constantArrays;
    HashMap<String, int[]> constantOffsetsFromZero;
    HashMap<String, int[]> variableOffsetsFromZero;
    HashMap<String, Domain> decisionVariables;
    ArrayList<String> decisionVariablesNames;
    ArrayList<String> undefinedParameters;
    ArrayList<Expression> constraintList;
    Objective objective;
    ArrayList<Variable> auxiliaryVariables;
    ArrayList<String> auxArrayNames;
    HashMap<String, MatrixDomain> auxArrayDomainsMap;
    HashMap<String, ArithmeticAtomExpression> subExpressions;
    HashMap<String, Integer> subexpressionCount;
    ArrayList<String> subexpressionList;
    HashMap<String, ArithmeticAtomExpression> equalAtoms;
    ArrayList<ArithmeticAtomExpression> replaceableVariables;
    HashMap<String, Expression> auxVarDetails;
    HashMap<String, Domain> quantifiedVarNamesMap = new HashMap();
    HashMap<String, ArrayList<String>> quantifiedDomainsMap = new HashMap();
    TranslationSettings settings;
    int usedCommonSubExpressions;
    int usedEqualSubExpressions;
    int noSimpleConjunctionCSEs = 0;
    int noSimpleDisjunctionCSEs = 0;
    int noNegatedCSEs = 0;
    Expression usedCommonQuantifiedSE = new ArithmeticAtomExpression(0);

    public NormalisedModel(TranslationSettings translationSettings, HashMap<String, Domain> hashMap, ArrayList<String> arrayList, ArrayList<Expression> arrayList2, Objective objective, ArrayList<String> arrayList3, HashMap<String, Domain> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        this.settings = translationSettings;
        this.decisionVariables = hashMap;
        this.decisionVariablesNames = arrayList;
        this.constraintList = arrayList2;
        this.objective = objective;
        this.auxiliaryVariables = new ArrayList();
        this.usedCommonSubExpressions = 0;
        this.usedEqualSubExpressions = 0;
        this.constantArrays = new HashMap();
        this.constantOffsetsFromZero = new HashMap();
        this.variableOffsetsFromZero = new HashMap();
        this.subExpressions = new HashMap();
        this.subexpressionList = new ArrayList();
        this.subexpressionCount = new HashMap();
        this.equalAtoms = new HashMap();
        this.replaceableVariables = new ArrayList();
        this.auxVarDetails = new HashMap();
        this.computeVariableArrayOffsets();
        this.undefinedParameters = arrayList3;
        this.auxArrayDomainsMap = new HashMap();
        this.auxArrayNames = new ArrayList();
        this.quantifiedDomainsMap = hashMap3;
        this.quantifiedVarNamesMap = hashMap2;
    }

    public NormalisedModel(TranslationSettings translationSettings, HashMap<String, Domain> hashMap, ArrayList<String> arrayList, ArrayList<Expression> arrayList2, HashMap<String, ConstantArray> hashMap2, HashMap<String, int[]> hashMap3, Objective objective, ArrayList<String> arrayList3, HashMap<String, Domain> hashMap4, HashMap<String, ArrayList<String>> hashMap5) {
        this.settings = translationSettings;
        this.decisionVariables = hashMap;
        this.decisionVariablesNames = arrayList;
        this.constraintList = arrayList2;
        this.constantArrays = hashMap2;
        this.constantOffsetsFromZero = hashMap3;
        this.variableOffsetsFromZero = new HashMap();
        this.objective = objective;
        this.auxiliaryVariables = new ArrayList();
        this.usedCommonSubExpressions = 0;
        this.subExpressions = new HashMap();
        this.equalAtoms = new HashMap();
        this.replaceableVariables = new ArrayList();
        this.auxVarDetails = new HashMap();
        this.computeVariableArrayOffsets();
        this.undefinedParameters = arrayList3;
        this.auxArrayDomainsMap = new HashMap();
        this.auxArrayNames = new ArrayList();
        this.quantifiedDomainsMap = hashMap5;
        this.quantifiedVarNamesMap = hashMap4;
    }

    public void evaluateDomains() {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            Domain domain = this.decisionVariables.get(this.decisionVariablesNames.get(i));
            domain = domain.evaluate();
            this.decisionVariables.put(this.decisionVariablesNames.get(i), domain);
        }
    }

    public int getOffsetFromZeroAt(String string, int n) throws NormaliserException {
        int[] nArray = this.constantOffsetsFromZero.get(string);
        if (nArray == null) {
            throw new NormaliserException("Trying to get offset from zero of unknown constant array '" + string + "' at index:" + n);
        }
        if (n < 0 || n >= nArray.length) {
            throw new NormaliserException("Trying to get offset from zero of constant array '" + string + "' at index out of bounds :" + n);
        }
        return nArray[n];
    }

    public void setVariableOffsetsFromZero(HashMap<String, int[]> hashMap) {
        this.variableOffsetsFromZero = hashMap;
    }

    public int getVariableOffsetAt(String string, int n) throws NormaliserException {
        int[] nArray = this.variableOffsetsFromZero.get(string);
        if (nArray == null) {
            throw new NormaliserException("Trying to get offset from unknown decision variable array: " + string);
        }
        if (n > nArray.length || n < 0) {
            throw new NormaliserException("Trying to get offset from zero of constant array '" + string + "' at index out of bounds :" + n);
        }
        return nArray[n];
    }

    public Variable getLastAddedAuxiliaryVariable() {
        if (this.auxiliaryVariables.size() == 0) {
            return null;
        }
        return this.auxiliaryVariables.get(this.auxiliaryVariables.size() - 1);
    }

    public void propagateSingleRangeDecisionVariables() {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            String string = this.decisionVariablesNames.get(i);
            Domain domain = this.decisionVariables.get(string);
            if (!(domain instanceof SingleIntRange)) continue;
            int n = ((SingleIntRange)domain).getSingleRange();
            for (int j = 0; j < this.constraintList.size(); ++j) {
                Expression expression = this.constraintList.remove(j);
                expression = expression.insertValueForVariable(n, string);
                expression.orderExpression();
                expression = expression.evaluate();
                expression = expression.restructure();
                if (expression instanceof Conjunction) {
                    ArrayList<Expression> arrayList = ((Conjunction)expression).getArguments();
                    int n2 = arrayList.size();
                    for (int k = 0; k < n2; ++k) {
                        this.constraintList.add(j, arrayList.remove(0));
                    }
                    j = j + n2 - 1;
                    continue;
                }
                this.constraintList.add(j, expression);
            }
        }
    }

    public int getAmountOfCommonSubExpressionsUsed() {
        return this.usedCommonSubExpressions;
    }

    public Expression getNumberOfQuantifiedCSE() {
        return this.usedCommonQuantifiedSE;
    }

    public int getAmountOfEqualSubExpressionsUsed() {
        return this.usedEqualSubExpressions;
    }

    public ArrayList<ArithmeticAtomExpression> getReplaceableVariables() {
        return this.replaceableVariables;
    }

    public ArithmeticAtomExpression getReplacementFor(String string) {
        return this.equalAtoms.get(string);
    }

    public void setAmountOfCommonSubExpressionsUsed(int n) {
        this.usedCommonSubExpressions = n;
    }

    public void setNumberOfQuantifiedCSE(Expression expression) {
        this.usedCommonQuantifiedSE = expression;
    }

    public void setAmountOfEqualSubExpressionsUsed(int n) {
        this.usedEqualSubExpressions = n;
    }

    public void setObjectiveExpression(Expression expression) {
        if (this.objective.getObjectiveExpression() != null) {
            this.objective.setObjectiveExpression(expression);
        }
    }

    public void setSubExpressions(HashMap<String, ArithmeticAtomExpression> hashMap) {
        this.subExpressions = hashMap;
    }

    public void setEqualAtoms(HashMap<String, ArithmeticAtomExpression> hashMap, ArrayList<ArithmeticAtomExpression> arrayList) {
        this.equalAtoms = hashMap;
        this.replaceableVariables = arrayList;
    }

    public HashMap<String, ArithmeticAtomExpression> getSubExpressions() {
        return this.subExpressions;
    }

    public boolean isDecisionVariable(String string) {
        return this.decisionVariables.get(string) != null;
    }

    public ArrayList<String> getUndefinedParameters() {
        return this.undefinedParameters;
    }

    public Domain getDomainOfVariable(String string) {
        if (this.decisionVariables.containsKey(string)) {
            return this.decisionVariables.get(string);
        }
        return null;
    }

    public Expression getObjectiveExpression() {
        return this.objective.getObjectiveExpression();
    }

    public boolean isObjectiveMaximising() {
        return this.objective.isMaximise();
    }

    public void setFlattenedObjectiveExpression(Expression expression) {
        this.objective.setObjectiveExpression(expression);
    }

    public ArrayList<String> getDecisionVariablesNames() {
        return this.decisionVariablesNames;
    }

    public ArrayList<Expression> getConstraints() {
        return this.constraintList;
    }

    public void replaceConstraintsWith(ArrayList<Expression> arrayList) {
        this.constraintList.clear();
        this.constraintList = arrayList;
    }

    public void addAuxiliaryVariable(Variable variable) {
        this.auxiliaryVariables.add(variable);
    }

    public void deleteLastAuxVariable() {
        this.auxiliaryVariables.remove(this.auxiliaryVariables.size() - 1);
    }

    public ArrayList<Variable> getAuxVariables() {
        return this.auxiliaryVariables;
    }

    public String toString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("$ " + this.settings.OUTPUTFILE_HEADER + "\n$ " + this.settings.OUTPUTFILE_HEADER_BUGS);
        if (this.usedCommonQuantifiedSE.getType() != 3 || ((ArithmeticAtomExpression)this.usedCommonQuantifiedSE).getConstant() != 0) {
            stringBuffer.append("\n$\n$ Eliminated common subexpressions: " + this.usedCommonQuantifiedSE + " (on problem level)");
        }
        if (this.usedCommonSubExpressions > 0) {
            stringBuffer.append("\n$\n$ Eliminated common subexpressions: " + this.usedCommonSubExpressions + " (on instance level)");
        }
        stringBuffer.append("\n$\n$ Normalised ESSENCE' model tailored to solver " + this.settings.getTargetSolver().getSolverName() + " \n\nlanguage ESSENCE' 1.b.a\n\n");
        for (n = 0; n < this.undefinedParameters.size(); ++n) {
            object = this.undefinedParameters.get(n);
            if (this.constantArrays.containsKey(object)) continue;
            stringBuffer.append("given " + this.undefinedParameters.get(n) + " : int\n");
        }
        stringBuffer.append(this.printConstantArrays());
        for (n = 0; n < this.decisionVariablesNames.size(); ++n) {
            object = this.decisionVariablesNames.get(n);
            stringBuffer.append("find " + (String)object + ": " + this.decisionVariables.get(object) + "\n");
        }
        stringBuffer.append("\n\n");
        if (this.auxiliaryVariables.size() > 0) {
            stringBuffer.append("$ auxiliary variables");
        }
        for (n = 0; n < this.auxiliaryVariables.size(); ++n) {
            Object object2;
            object = this.auxiliaryVariables.get(n);
            if (n % 4 == 0) {
                stringBuffer.append("\n");
            }
            if (this.settings.isClassLevelTransformation()) {
                if (object.isQuantified()) {
                    object2 = null;
                    if (object instanceof ArrayVariable) {
                        object2 = ((ArrayVariable)object).getArrayNameOnly();
                    }
                    Domain domain = this.auxArrayDomainsMap.get(object2);
                    stringBuffer.append("find " + (String)object2 + " : " + domain + "\n");
                    continue;
                }
                if (object instanceof SingleVariable) {
                    object2 = (SingleVariable)object;
                    if (((SingleVariable)object2).getExplicitDomain() instanceof BoolDomain) {
                        stringBuffer.append("find " + object + " : bool   ");
                        continue;
                    }
                    stringBuffer.append("find " + object + " : int(" + object.getDefinedDomain()[0] + ".." + object.getDefinedDomain()[1] + ")   ");
                    continue;
                }
                if (((Object)object.getDefinedDomain()[0]).toString().equals("0") && ((Object)object.getDefinedDomain()[1]).toString().equals("1")) {
                    stringBuffer.append("find " + object + " : bool   ");
                    continue;
                }
                stringBuffer.append("find " + object + " : int(" + object.getDomain()[0] + ".." + object.getDomain()[1] + ")   ");
                continue;
            }
            if (object instanceof SingleVariable) {
                object2 = (SingleVariable)object;
                if (((SingleVariable)object2).getExplicitDomain() instanceof BoolDomain) {
                    stringBuffer.append("find " + object + " : bool   ");
                    continue;
                }
                stringBuffer.append("find " + object + " : int(" + object.getDomain()[0] + ".." + object.getDomain()[1] + ")   ");
                continue;
            }
            stringBuffer.append("find " + object + " : int(" + object.getDomain()[0] + ".." + object.getDomain()[1] + ")   ");
        }
        stringBuffer.append("\n" + this.printStatistics() + "\n");
        if (!this.objective.isEmptyObjective()) {
            stringBuffer.append("\n" + this.objective.toString() + "\n\n");
        }
        stringBuffer.append("such that\n");
        if (this.constraintList.size() == 0) {
            return stringBuffer.toString();
        }
        for (n = 0; n < this.constraintList.size() - 1; ++n) {
            stringBuffer.append("\t" + this.constraintList.get(n) + ",\n\n");
        }
        stringBuffer.append("\t" + this.constraintList.get(this.constraintList.size() - 1) + "\n");
        return stringBuffer.toString();
    }

    private String printConstantArrays() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.constantArrays.isEmpty()) {
            return "";
        }
        Object[] objectArray = this.constantArrays.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("letting ");
            stringBuffer.append(this.constantArrays.get(objectArray[i]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String printStatistics() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.usedCommonSubExpressions > 0) {
            stringBuffer.append("$ number of eliminated subexpressions: " + this.usedCommonSubExpressions + "\n");
        }
        if (this.usedEqualSubExpressions > 0) {
            stringBuffer.append("$ number of eliminated nested subexpressions: " + this.usedEqualSubExpressions + "\n");
        }
        return stringBuffer.toString();
    }

    private ArrayList<Expression> removeDuplicates(ArrayList<Expression> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Expression expression = arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                if (!((Object)expression).toString().equals(((Object)arrayList.get(j)).toString())) continue;
                arrayList.remove(j);
            }
        }
        return arrayList;
    }

    public HashMap<String, Domain> getDecisionVariables() {
        return this.decisionVariables;
    }

    private void computeVariableArrayOffsets() {
        for (int i = 0; i < this.decisionVariablesNames.size(); ++i) {
            int n;
            int[] nArray;
            Domain[] domainArray;
            MatrixDomain matrixDomain;
            String string = this.decisionVariablesNames.get(i);
            Domain domain = this.decisionVariables.get(string);
            if ((domain = domain.evaluate()) instanceof ConstantArrayDomain) {
                matrixDomain = (ConstantArrayDomain)domain;
                domainArray = ((ConstantArrayDomain)matrixDomain).getIndexDomains();
                nArray = new int[domainArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    int n2;
                    int n3;
                    nArray[n] = n3 = domainArray[n].getRange()[0];
                    if (nArray[n] > this.settings.getTargetSolver().getArrayIndexingStartValue()) {
                        if (domainArray[n] instanceof SingleIntRange) {
                            n2 = ((SingleIntRange)domainArray[n]).getSingleRange();
                            domainArray[n] = new SingleIntRange(n2 - nArray[n]);
                            continue;
                        }
                        if (!(domainArray[n] instanceof BoundedIntRange)) continue;
                        int[] nArray2 = ((BoundedIntRange)domainArray[n]).getRange();
                        domainArray[n] = new BoundedIntRange(nArray2[0] - nArray[n], nArray2[1] - nArray[n]);
                        continue;
                    }
                    if (nArray[n] >= this.settings.getTargetSolver().getArrayIndexingStartValue()) continue;
                    n2 = this.settings.getTargetSolver().getArrayIndexingStartValue();
                    if (domainArray[n] instanceof SingleIntRange) {
                        int n4 = ((SingleIntRange)domainArray[n]).getSingleRange();
                        domainArray[n] = new SingleIntRange(n4 + n2);
                        continue;
                    }
                    if (!(domainArray[n] instanceof BoundedIntRange)) continue;
                    int[] nArray3 = ((BoundedIntRange)domainArray[n]).getRange();
                    domainArray[n] = new BoundedIntRange(nArray3[0] + n2, nArray3[1] + n2);
                }
                ((ConstantArrayDomain)matrixDomain).setIndexDomains((ConstantDomain[])domainArray);
                this.variableOffsetsFromZero.put(string, nArray);
                this.decisionVariables.put(string, matrixDomain);
                continue;
            }
            if (!(domain instanceof ArrayDomain)) continue;
            matrixDomain = (ArrayDomain)domain;
            domainArray = ((ArrayDomain)matrixDomain).getIndexDomains();
            nArray = new int[domainArray.length];
            for (n = 0; n < nArray.length; ++n) {
                if (domainArray[n] instanceof ConstantDomain) {
                    nArray[n] = ((ConstantDomain)domainArray[n]).getRange()[0];
                    continue;
                }
                if (!(domainArray[n] instanceof ExpressionRange)) continue;
                Expression expression = ((ExpressionRange)domainArray[n]).getLowerAndUpperBound()[0];
                nArray[n] = expression.getType() == 3 ? ((ArithmeticAtomExpression)expression).getConstant() : 0;
            }
            this.variableOffsetsFromZero.put(string, nArray);
            this.decisionVariables.put(string, matrixDomain);
        }
    }

    public void setSubexpressionCount(HashMap<String, Integer> hashMap) {
        this.subexpressionCount = hashMap;
    }

    public void setSubexpressionList(ArrayList<String> arrayList) {
        this.subexpressionList = arrayList;
    }

    public HashMap<String, Integer> getSubexpressionCount() {
        return this.subexpressionCount;
    }

    public ArrayList<String> getSubexpressionList() {
        return this.subexpressionList;
    }

    public HashMap<String, Expression> getAuxVarDetailsHashMap() {
        return this.auxVarDetails;
    }

    public void setAuxVarDetailsHashMap(HashMap<String, Expression> hashMap) {
        this.auxVarDetails = hashMap;
    }

    public void addAuxVarDetail(String string, Expression expression) {
        this.auxVarDetails.put(string, expression);
    }

    public void setAuxArrayDomainMap(HashMap<String, MatrixDomain> hashMap) {
        this.auxArrayDomainsMap = hashMap;
    }

    public HashMap<String, MatrixDomain> getAuxArrayDomainMap() {
        return this.auxArrayDomainsMap;
    }

    public void setAuxArrayNames(ArrayList<String> arrayList) {
        this.auxArrayNames = arrayList;
    }

    public ArrayList<String> getAuxArrayNames() {
        return this.auxArrayNames;
    }

    public void setNoSimpleConjunctionCSES(int n) {
        this.noSimpleConjunctionCSEs = n;
    }

    public int getNoSimpleConjunctionCSEs() {
        return this.noSimpleConjunctionCSEs;
    }

    public void setNoSimpleDisjunctionCSES(int n) {
        this.noSimpleDisjunctionCSEs = n;
    }

    public int getNoSimpleDisjunctionCSEs() {
        return this.noSimpleDisjunctionCSEs;
    }

    public void setNoNegatedCSEs(int n) {
        this.noNegatedCSEs = n;
    }

    public int getNoNegatedCSEs() {
        return this.noNegatedCSEs;
    }

    public HashMap<String, Domain> getQuantifierNamesMap() {
        return this.quantifiedVarNamesMap;
    }

    public HashMap<String, ArrayList<String>> getQuantifierDomainsMap() {
        return this.quantifiedDomainsMap;
    }

    public void updateDecisionVariableDomain(String string, Domain domain) {
        if (this.decisionVariables.containsKey(string)) {
            this.decisionVariables.put(string, domain);
        }
    }
}

