/*
 * Decompiled with CFR 0.152.
 */
package translator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Element;
import translator.TranslationSettings;
import translator.Translator;
import translator.solver.Gecode;
import translator.solver.Minion;
import translator.solver.TargetSolver;

public class TailorGUI
extends JFrame {
    public final char MINION_ID = '\u0001';
    public final char GECODE_ID = (char)2;
    static final long serialVersionUID = 11L;
    StringBuffer problemText = new StringBuffer();
    StringBuffer parameterText = new StringBuffer();
    StringBuffer normalisedText = new StringBuffer();
    StringBuffer flatText = new StringBuffer();
    StringBuffer solverText = new StringBuffer();
    StringBuffer solutionText = new StringBuffer();
    String openedProblemFile = new String();
    String openedParameterFile = new String();
    ArrayList<String> essenceBoldKeywords = new ArrayList();
    ArrayList<String> essenceColourKeywords = new ArrayList();
    String HTMLFONT = "<font size = \"3\" face=\"DialogInput, Bookman Old Style, Book Antiqua, Garamond\">";
    final String SAVE_PROBLEM = "save_problem";
    final String SAVE_PARAMETER = "save_parameter";
    final String SAVE_OUTPUT = "save_output";
    final String LOAD_PROBLEM = "load_problem";
    final String LOAD_PARAMETER = "load_parameter";
    final String CLEAR_PROBLEM = "clear problem";
    final String CLEAR_PARAMETER = "clear parameter";
    final String CLEAR_SOLVER_OUTPUT = "clear solver output";
    final String CLEAR_NORM_OUTPUT = "clear normalised output";
    final String CLEAR_FLAT_OUTPUT = "clear flat output";
    final String CLEAR_SOLUTION_OUTPUT = "clear solution output";
    final String EDIT_OUTPUT = "edit output";
    final String PARSE = "parse";
    final String INSERT_PARAMETERS = "insert parameters";
    final String EVALUATE = "evaluate";
    final String ORDER = "order";
    final String NORMALISE = "full";
    final String FLATTEN = "flatten";
    final String MINION = "to_minion";
    final String GECODE = "to gecode";
    final String DEBUG = "debug";
    TranslationSettings settings = new TranslationSettings();
    Translator translator;
    char skinType;
    TargetSolver solver;
    public final int NORMALISE_TAB_NR = 0;
    public final int FLAT_TAB_NR = 1;
    public final int SOLVER_INPUT_TAB_NR = 2;
    public final int SOLUTION_TAB_NR = 3;
    final String ESSENCE_PRIME_HEADER = "language ESSENCE' 1.b.a";
    final String TAILOR_VERSION = "TAILOR v" + this.settings.getTailorVersion();
    final String SYSTEM_START_MSG = "Welcome to " + this.TAILOR_VERSION + "\nbug reports: andrea@cs.st-and.ac.uk\n";
    final char CLASSIC_SKIN = (char)99;
    final char GIRLIE_SKIN = (char)103;
    final char ARMY_SKIN = (char)97;
    final char WATERFALL_SKIN = (char)115;
    final char NIGHTOWL_SKIN = (char)110;
    final char COLORBLIND_SKIN = (char)98;
    final char PIRATE_SKIN = (char)112;
    JButton parseButton;
    JComboBox normaliseComboBox;
    JButton normaliseButton;
    JButton flattenButton;
    JComboBox targetSolverSelection;
    JComboBox outputSelection;
    JComboBox actionSelection;
    JButton solverButton;
    JPanel outPanel;
    JPanel solverPanel;
    JPanel actionPanel;
    JPanel goButtonPanel;
    JPanel normalisePanel;
    JPanel debugPanel;
    JButton debugModeButton;
    JCheckBox debugMode;
    JFileChooser fileChooser;
    JTextArea normaliseOutput;
    JTextArea flatOutput;
    JTextArea solverOutput;
    JTextArea solutionOutput;
    JTabbedPane outputTabbedPanel;
    private JButton clearOutputButton;
    private JButton clearParameterButton;
    private JButton clearProblemButton;
    private JLabel colLineLabelParameter;
    private JLabel colLineLabelProblem;
    private JPanel inputPanel;
    private JSplitPane inputSplitPane;
    private JMenu settingsMenu;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JPanel jPanel1;
    private JPanel middlePanel;
    private JScrollPane jScrollPane1;
    private JButton loadParameterButton;
    private JButton loadProblemButton;
    private JTextArea messageOutput;
    private JPanel messagesPanel;
    private JPanel outputButtonPanel;
    private JPanel outputPanel;
    private JScrollPane outputScrollPane;
    private JSplitPane outputSplitPane;
    private JPanel parameterButtonPanel;
    private JTextPane parameterInput;
    private JPanel parameterInputPanel;
    private JScrollPane parameterInputScrollPane;
    private JPanel problemButtonPanel;
    private JTextPane problemInput;
    private JPanel problemInputPanel;
    private JScrollPane problemInputScrollPane;
    private JButton runSolverButton;
    private JButton saveOutputButton;
    private JButton saveParameterButton;
    private JButton saveProblemButton;
    private JPanel solverButtonPanel;
    private Color inputBgColor;
    private Color outputBgColor;
    private Color bgColor;
    private Color textAreaColor;
    private Color textAreaFontColor;
    private Font inputFont;
    private Font outputFont;
    private Color buttonColor;
    private Color buttonFontColor;
    private Color buttonPressedColor;

    public TailorGUI() {
        this.translator = new Translator(this.settings);
        this.skinType = (char)this.CLASSIC_SKIN;
        this.setColors();
        this.initComponents();
        this.updateColors();
        this.solver = this.settings.getTargetSolver();
    }

    public TailorGUI(TranslationSettings translationSettings) {
        this.settings = translationSettings;
        this.translator = new Translator(translationSettings);
        this.skinType = (char)this.CLASSIC_SKIN;
        this.setColors();
        this.initComponents();
        this.updateColors();
        this.solver = translationSettings.getTargetSolver();
    }

    private String getSkinName(char c) {
        if (c == this.GIRLIE_SKIN) {
            return "Girlie Skin";
        }
        if (c == this.NIGHTOWL_SKIN) {
            return "NightOwl Skin";
        }
        if (c == this.COLORBLIND_SKIN) {
            return "Colorblind Skin";
        }
        if (c == this.WATERFALL_SKIN) {
            return "Waterfall Skin";
        }
        if (c == this.PIRATE_SKIN) {
            return "Cheeky Pirate Skin";
        }
        if (c == this.ARMY_SKIN) {
            return "Boring Army Skin";
        }
        return "Classic Skin";
    }

    private void setColors() {
        Color color = new Color(177, 210, 240);
        Color color2 = new Color(215, 24, 141);
        Color color3 = new Color(254, 222, 241);
        Color color4 = new Color(73, 1, 45);
        Color color5 = new Color(147, 23, 99);
        Color color6 = new Color(74, 149, 205);
        Color color7 = new Color(3, 60, 99);
        Color color8 = new Color(89, 130, 74);
        Color color9 = new Color(237, 240, 208);
        Color color10 = new Color(13, 40, 10);
        Color color11 = new Color(198, 190, 152);
        if (this.skinType == this.CLASSIC_SKIN) {
            this.bgColor = color;
            this.inputBgColor = color;
            this.outputBgColor = color;
            this.textAreaColor = new Color(240, 240, 240);
            this.textAreaFontColor = Color.black;
            this.inputFont = new Font("DialogInput", 0, 12);
            this.outputFont = new Font("DialogInput", 0, 12);
            this.buttonColor = new JButton().getBackground();
        } else if (this.skinType == this.NIGHTOWL_SKIN) {
            this.textAreaColor = Color.black;
            this.textAreaFontColor = Color.white;
            this.bgColor = color;
            this.inputBgColor = new JPanel().getBackground();
            this.outputBgColor = new JPanel().getBackground();
            this.inputFont = new Font("DialogInput", 0, 12);
            this.outputFont = new Font("DialogInput", 0, 12);
            this.buttonColor = new JButton().getBackground();
        } else if (this.skinType == this.GIRLIE_SKIN) {
            this.bgColor = color2;
            this.inputBgColor = color2;
            this.outputBgColor = color2;
            this.textAreaColor = color3;
            this.textAreaFontColor = color4;
            this.buttonColor = color5;
            this.inputFont = new Font("Dialog", 0, 12);
            this.outputFont = new Font("Dialog", 0, 12);
        } else if (this.skinType == this.COLORBLIND_SKIN) {
            this.bgColor = Color.pink;
            this.inputBgColor = new Color(211, 245, 177);
            this.outputBgColor = new Color(211, 177, 245);
            this.textAreaColor = Color.yellow;
            this.textAreaFontColor = Color.black;
            this.inputFont = new Font("DialogInput", 0, 12);
            this.outputFont = new Font("DialogInput", 0, 12);
            this.buttonColor = Color.LIGHT_GRAY;
        } else if (this.skinType == this.WATERFALL_SKIN) {
            this.bgColor = color6;
            this.inputBgColor = color6;
            this.outputBgColor = color6;
            this.textAreaColor = color;
            this.textAreaFontColor = color7;
            this.inputFont = new Font("DialogInput", 0, 12);
            this.outputFont = new Font("DialogInput", 0, 12);
            this.buttonColor = new JButton().getBackground();
        } else if (this.skinType == this.ARMY_SKIN) {
            this.bgColor = color8;
            this.inputBgColor = color8;
            this.outputBgColor = color8;
            this.textAreaColor = color9;
            this.textAreaFontColor = color10;
            this.inputFont = new Font("DialogInput", 0, 12);
            this.outputFont = new Font("DialogInput", 0, 12);
            this.buttonColor = color11;
        }
    }

    private void initComponents() {
        String string = "tailorLogo3.png";
        URL uRL = this.getClass().getResource(string);
        this.setIconImage(new ImageIcon(uRL).getImage());
        this.initialiseEssenceKeywords();
        this.initialiseColourKeywords();
        this.setBackground(this.bgColor);
        this.setTitle(this.TAILOR_VERSION + " - " + this.getSkinName(this.skinType));
        this.inputPanel = new JPanel();
        this.inputSplitPane = new JSplitPane();
        this.problemInputPanel = new JPanel();
        this.problemInputScrollPane = new JScrollPane();
        this.problemInput = new JTextPane();
        this.problemButtonPanel = new JPanel();
        this.saveProblemButton = new JButton();
        this.loadProblemButton = new JButton();
        this.clearProblemButton = new JButton();
        this.colLineLabelProblem = new JLabel();
        this.parameterInputPanel = new JPanel();
        this.parameterInputScrollPane = new JScrollPane();
        this.parameterInput = new JTextPane();
        this.parameterButtonPanel = new JPanel();
        this.saveParameterButton = new JButton();
        this.loadParameterButton = new JButton();
        this.clearParameterButton = new JButton();
        this.colLineLabelParameter = new JLabel();
        this.middlePanel = new JPanel();
        this.outputPanel = new JPanel();
        this.outputSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.solverButtonPanel = new JPanel();
        this.outputScrollPane = new JScrollPane();
        this.outputButtonPanel = new JPanel();
        this.saveOutputButton = new JButton();
        this.clearOutputButton = new JButton();
        this.runSolverButton = new JButton();
        this.messagesPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.messageOutput = new JTextArea();
        this.menuBar = new JMenuBar();
        this.settingsMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(2);
        this.setDefaultCloseOperation(3);
        this.setCursor(new Cursor(0));
        this.setFocusCycleRoot(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TailorGUI.this.formComponentResized(componentEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(this.bgColor);
        this.inputPanel.setMinimumSize(new Dimension(200, 400));
        this.inputPanel.setName("modellingPanel");
        this.inputPanel.setPreferredSize(new Dimension(480, 670));
        this.inputPanel.setLayout(new GridBagLayout());
        this.inputPanel.setBackground(this.inputBgColor);
        this.inputSplitPane.setDividerSize(15);
        this.inputSplitPane.setOrientation(0);
        this.inputSplitPane.setResizeWeight(0.7);
        this.inputSplitPane.setLastDividerLocation(this.inputSplitPane.getSize().height / 2);
        this.inputSplitPane.setMinimumSize(new Dimension(180, 380));
        this.inputSplitPane.setName("inputSplitPane");
        this.inputSplitPane.setOneTouchExpandable(true);
        this.inputSplitPane.setPreferredSize(new Dimension(390, 590));
        this.problemInputPanel.setLayout(new GridBagLayout());
        this.problemInputScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "Essence' Problem Model"));
        this.problemInputScrollPane.setMinimumSize(new Dimension(190, 200));
        this.problemInputScrollPane.setPreferredSize(new Dimension(390, 450));
        this.problemInput.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.problemInput.setContentType("text/plain");
        this.problemInput.setFont(this.inputFont);
        this.problemInput.setBackground(this.textAreaColor);
        this.problemInput.setForeground(this.textAreaFontColor);
        this.problemInput.setMinimumSize(new Dimension(190, 200));
        this.problemInput.setPreferredSize(new Dimension(390, 400));
        this.problemText = new StringBuffer(this.ESSENCE_PRIME_HEADER + "\n");
        this.problemInput.setText(this.problemText.toString());
        this.problemInput.setCaretPosition(this.problemText.length());
        this.problemInput.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                int n = 0;
                int n2 = TailorGUI.this.problemInput.getCaretPosition();
                Element element = TailorGUI.this.problemInput.getDocument().getDefaultRootElement();
                int n3 = element.getElementIndex(n2);
                int n4 = element.getElement(n3).getStartOffset();
                n = n2 - n4 + 1;
                int n5 = element.getElementIndex(n2) + 1;
                TailorGUI.this.updateLineColPositions(n5, n);
            }
        });
        this.problemInputScrollPane.setViewportView(this.problemInput);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.problemInputPanel.add((Component)this.problemInputScrollPane, gridBagConstraints);
        this.problemButtonPanel.setLayout(new GridLayout(1, 0, 30, 0));
        Dimension dimension = new JButton().getPreferredSize();
        this.saveProblemButton.setText("Save File");
        this.saveProblemButton.setActionCommand("save_problem");
        this.saveProblemButton.setBackground(this.buttonColor);
        this.saveProblemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.save(actionEvent.getActionCommand());
            }
        });
        this.saveProblemButton.setMnemonic(83);
        this.problemButtonPanel.add(this.saveProblemButton);
        this.loadProblemButton.setText("Open File");
        this.loadProblemButton.setActionCommand("load_problem");
        this.loadProblemButton.setBackground(this.buttonColor);
        this.loadProblemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.load(actionEvent.getActionCommand());
            }
        });
        this.loadProblemButton.setMnemonic(79);
        this.problemButtonPanel.add(this.loadProblemButton);
        this.clearProblemButton.setText("Clear");
        this.clearProblemButton.setActionCommand(this.CLEAR_PROBLEM);
        this.clearProblemButton.setBackground(this.buttonColor);
        this.clearProblemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.clearInputField(actionEvent.getActionCommand());
            }
        });
        this.problemButtonPanel.add(this.clearProblemButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.problemInputPanel.add((Component)this.problemButtonPanel, gridBagConstraints);
        this.colLineLabelProblem.setText("Line:0   Column:0");
        this.colLineLabelProblem.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.problemInputPanel.add((Component)this.colLineLabelProblem, gridBagConstraints);
        this.inputSplitPane.setLeftComponent(this.problemInputPanel);
        this.parameterInputPanel.setLayout(new GridBagLayout());
        this.parameterInputScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "Essence' Parameter Specification"));
        this.parameterInputScrollPane.setAutoscrolls(true);
        this.parameterInputScrollPane.setMinimumSize(new Dimension(190, 150));
        this.parameterInputScrollPane.setPreferredSize(new Dimension(390, 200));
        this.parameterInput.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.parameterInput.setFont(this.inputFont);
        this.parameterInput.setBackground(this.textAreaColor);
        this.parameterInput.setForeground(this.textAreaFontColor);
        this.parameterInput.setMinimumSize(new Dimension(190, 150));
        this.parameterInput.setPreferredSize(new Dimension(390, 200));
        this.parameterInput.setText(this.ESSENCE_PRIME_HEADER + "\n");
        this.problemInput.setCaretPosition((this.ESSENCE_PRIME_HEADER + "\n").length());
        this.parameterInput.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                int n = 0;
                int n2 = TailorGUI.this.parameterInput.getCaretPosition();
                Element element = TailorGUI.this.parameterInput.getDocument().getDefaultRootElement();
                int n3 = element.getElementIndex(n2);
                int n4 = element.getElement(n3).getStartOffset();
                n = n2 - n4 + 1;
                int n5 = element.getElementIndex(n2) + 1;
                TailorGUI.this.updateParameterLineColPositions(n5, n);
            }
        });
        this.parameterInputScrollPane.setViewportView(this.parameterInput);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.parameterInputPanel.add((Component)this.parameterInputScrollPane, gridBagConstraints);
        this.parameterButtonPanel.setLayout(new GridLayout(1, 0, 30, 0));
        this.saveParameterButton.setText("Save File");
        this.saveParameterButton.setActionCommand("save_parameter");
        this.saveParameterButton.setBackground(this.buttonColor);
        this.saveParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.save(actionEvent.getActionCommand());
            }
        });
        this.saveParameterButton.setMnemonic(65);
        this.parameterButtonPanel.add(this.saveParameterButton);
        this.loadParameterButton.setText("Open File");
        this.loadParameterButton.setActionCommand("load_parameter");
        this.loadParameterButton.setBackground(this.buttonColor);
        this.loadParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.load(actionEvent.getActionCommand());
            }
        });
        this.loadParameterButton.setMnemonic(80);
        this.parameterButtonPanel.add(this.loadParameterButton);
        this.clearParameterButton.setText("Clear");
        this.clearParameterButton.setActionCommand(this.CLEAR_PARAMETER);
        this.clearParameterButton.setBackground(this.buttonColor);
        this.clearParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.clearInputField(actionEvent.getActionCommand());
            }
        });
        this.parameterButtonPanel.add(this.clearParameterButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.parameterInputPanel.add((Component)this.parameterButtonPanel, gridBagConstraints);
        this.colLineLabelParameter.setText("Line:0   Column:0");
        this.colLineLabelParameter.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.parameterInputPanel.add((Component)this.colLineLabelParameter, gridBagConstraints);
        this.inputSplitPane.setRightComponent(this.parameterInputPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.inputPanel.add((Component)this.inputSplitPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        this.getContentPane().add((Component)this.inputPanel, gridBagConstraints);
        this.middlePanel.setMaximumSize(new Dimension(180, Short.MAX_VALUE));
        this.middlePanel.setMinimumSize(new Dimension(100, 400));
        this.middlePanel.setPreferredSize(new Dimension(150, 600));
        this.middlePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.middlePanel, gridBagConstraints);
        this.solverButtonPanel.setLayout(new GridLayout(4, 1, 20, 20));
        Dimension dimension2 = new Dimension(130, 40);
        Dimension dimension3 = new Dimension(130, 20);
        this.actionPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.actionPanel.setPreferredSize(dimension2);
        JLabel jLabel = new JLabel("  ");
        String[] stringArray = new String[]{"solve", "tailor"};
        this.actionSelection = new JComboBox<String>(stringArray);
        this.actionSelection.setSelectedIndex(0);
        this.actionSelection.setPreferredSize(dimension3);
        this.actionSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TailorGUI.this.actionSelection.getSelectedIndex() == 0) {
                    TailorGUI.this.outPanel.setVisible(false);
                } else if (TailorGUI.this.actionSelection.getSelectedIndex() == 1) {
                    TailorGUI.this.outPanel.setVisible(true);
                }
            }
        });
        this.actionPanel.add(jLabel);
        this.actionPanel.add(this.actionSelection);
        this.actionPanel.setBackground(this.bgColor);
        this.solverButtonPanel.add(this.actionPanel);
        this.outPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.outPanel.setPreferredSize(dimension2);
        JLabel jLabel2 = new JLabel("to format");
        this.solverButtonPanel.add(jLabel2);
        String[] stringArray2 = new String[]{"Solver language", "Essence'", "FlatZinc"};
        this.outputSelection = new JComboBox<String>(stringArray2);
        this.outputSelection.setSelectedIndex(0);
        this.outputSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TailorGUI.this.outputSelection.getSelectedIndex() == 0) {
                    TailorGUI.this.settings.setGenerateFlatzincOutput(false);
                    TailorGUI.this.settings.setFlattenProblemClassOnly(false);
                } else if (TailorGUI.this.outputSelection.getSelectedIndex() == 1) {
                    TailorGUI.this.settings.setGenerateFlatzincOutput(false);
                    TailorGUI.this.settings.setFlattenProblemClassOnly(true);
                } else {
                    TailorGUI.this.settings.setGenerateFlatzincOutput(true);
                    TailorGUI.this.settings.setFlattenProblemClassOnly(false);
                }
            }
        });
        this.outPanel.add(jLabel2);
        this.outPanel.add(this.outputSelection);
        this.outPanel.setBackground(this.bgColor);
        this.outPanel.setVisible(this.actionSelection.getSelectedIndex() == 1);
        this.solverButtonPanel.add(this.outPanel);
        this.solverPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        JLabel jLabel3 = new JLabel("with solver");
        this.solverButtonPanel.add(jLabel3);
        String[] stringArray3 = new String[]{"Minion", "Gecode"};
        this.targetSolverSelection = new JComboBox<String>(stringArray3);
        this.targetSolverSelection.setSelectedIndex(0);
        this.targetSolverSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TailorGUI.this.targetSolverSelection.getSelectedIndex() == 0) {
                    TailorGUI.this.settings.setTargetSolver(new Minion(TailorGUI.this.settings));
                } else if (TailorGUI.this.targetSolverSelection.getSelectedIndex() == 1) {
                    TailorGUI.this.settings.setTargetSolver(new Gecode(TailorGUI.this.settings));
                }
                TailorGUI.this.runSolverButton.setText("Run " + TailorGUI.this.settings.getTargetSolver().getSolverName());
            }
        });
        this.solverPanel.add(jLabel3);
        this.solverPanel.add(this.targetSolverSelection);
        this.solverPanel.setBackground(this.bgColor);
        this.solverButtonPanel.add(this.solverPanel);
        this.goButtonPanel = new JPanel(new GridLayout(2, 1, 10, 10));
        JLabel jLabel4 = new JLabel("  ");
        this.goButtonPanel.add(jLabel4);
        this.solverButton = new JButton("> go >");
        this.solverButton.setPreferredSize(new Dimension(100, 30));
        this.goButtonPanel.setBackground(this.bgColor);
        this.solverButton.setBackground(new JButton().getBackground());
        this.solverButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TailorGUI.this.settings.getTargetSolver() instanceof Minion) {
                    if (TailorGUI.this.actionSelection.getSelectedIndex() == 0) {
                        TailorGUI.this.settings.setGenerateFlatzincOutput(false);
                    }
                    if (TailorGUI.this.translate("to_minion") && TailorGUI.this.actionSelection.getSelectedIndex() == 0) {
                        TailorGUI.this.runMinion();
                    }
                } else if (TailorGUI.this.settings.getTargetSolver() instanceof Gecode) {
                    if (TailorGUI.this.actionSelection.getSelectedIndex() == 0) {
                        TailorGUI.this.settings.setGenerateFlatzincOutput(true);
                    }
                    if (TailorGUI.this.translate("to gecode") && TailorGUI.this.actionSelection.getSelectedIndex() == 0) {
                        TailorGUI.this.runFlatZincGecode();
                    }
                }
            }
        });
        this.solverButton.setMnemonic(71);
        this.goButtonPanel.add(this.solverButton);
        this.solverButtonPanel.add(this.goButtonPanel);
        this.solverButtonPanel.setBackground(this.bgColor);
        this.middlePanel.add(this.solverButtonPanel);
        this.middlePanel.setBackground(this.bgColor);
        this.outputPanel.setMinimumSize(new Dimension(200, 400));
        this.outputPanel.setPreferredSize(new Dimension(420, 600));
        this.outputPanel.setLayout(new GridBagLayout());
        this.outputPanel.setBackground(this.outputBgColor);
        this.outputSplitPane.setOrientation(0);
        this.outputSplitPane.setResizeWeight(0.7);
        this.jPanel1.setLayout(new GridBagLayout());
        this.outputScrollPane.setMinimumSize(new Dimension(190, 200));
        this.outputScrollPane.setPreferredSize(new Dimension(400, 450));
        this.initOutput(390, 450);
        this.outputScrollPane.setViewportView(this.outputTabbedPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.jPanel1.add((Component)this.outputScrollPane, gridBagConstraints);
        this.outputButtonPanel.setLayout(new GridLayout(1, 0, 30, 0));
        this.saveOutputButton.setText("Save Tab");
        this.saveOutputButton.setActionCommand(this.SAVE_OUTPUT);
        this.saveOutputButton.setBackground(this.buttonColor);
        this.saveOutputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.save(actionEvent.getActionCommand());
            }
        });
        this.saveOutputButton.setMnemonic(84);
        this.outputButtonPanel.add(this.saveOutputButton);
        this.clearOutputButton.setText("Clear Tab");
        this.clearOutputButton.setBackground(this.buttonColor);
        this.clearOutputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TailorGUI.this.outputTabbedPanel.getSelectedIndex() == 0) {
                    TailorGUI.this.clearInputField("clear normalised output");
                } else if (TailorGUI.this.outputTabbedPanel.getSelectedIndex() == 1) {
                    TailorGUI.this.clearInputField("clear flat output");
                } else if (TailorGUI.this.outputTabbedPanel.getSelectedIndex() == 2) {
                    TailorGUI.this.clearInputField("clear solver output");
                } else if (TailorGUI.this.outputTabbedPanel.getSelectedIndex() == 3) {
                    TailorGUI.this.clearInputField("clear solution output");
                }
            }
        });
        this.outputButtonPanel.add(this.clearOutputButton);
        this.runSolverButton.setText("Run Solver");
        this.runSolverButton.setBackground(this.buttonColor);
        this.runSolverButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TailorGUI.this.settings.getTargetSolver() instanceof Minion) {
                    TailorGUI.this.runMinion();
                } else if (TailorGUI.this.settings.getTargetSolver() instanceof Gecode) {
                    TailorGUI.this.runFlatZincGecode();
                }
            }
        });
        this.runSolverButton.setEnabled(false);
        this.runSolverButton.setMnemonic(82);
        this.outputButtonPanel.add(this.runSolverButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.jPanel1.add((Component)this.outputButtonPanel, gridBagConstraints);
        this.outputSplitPane.setLeftComponent(this.jPanel1);
        this.messagesPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "System Messages"));
        this.jScrollPane1.setMinimumSize(new Dimension(190, 50));
        this.jScrollPane1.setPreferredSize(new Dimension(390, 150));
        this.messageOutput.setColumns(20);
        this.messageOutput.setRows(5);
        this.messageOutput.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.messageOutput.setText(this.SYSTEM_START_MSG);
        this.messageOutput.setBackground(this.textAreaColor);
        this.messageOutput.setForeground(this.textAreaFontColor);
        this.jScrollPane1.setViewportView(this.messageOutput);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.messagesPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.outputSplitPane.setRightComponent(this.messagesPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.outputPanel.add((Component)this.outputSplitPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        this.getContentPane().add((Component)this.outputPanel, gridBagConstraints);
        this.initMenuBar();
        this.pack();
    }

    private void initMenuBar() {
        this.settingsMenu.setText("Settings");
        this.menuBar.add(this.settingsMenu);
        JMenuItem jMenuItem = new JMenuItem("Set Path to Minion ...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changePath('\u0001');
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Set Path to Gecode ...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changePath('\u0002');
            }
        });
        this.settingsMenu.add(jMenuItem);
        this.settingsMenu.add(jMenuItem2);
        JMenu jMenu = new JMenu("Translation");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show information about auxiliary variables");
        jCheckBoxMenuItem.setSelected(this.settings.getAuxVarDetails());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setAuxVarDetails(jCheckBoxMenuItem.isSelected());
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Only Flatten Problem Class");
        jCheckBoxMenuItem2.setSelected(this.settings.flattenProblemClassOnly());
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setFlattenProblemClassOnly(jCheckBoxMenuItem.isSelected());
            }
        });
        JMenu jMenu2 = new JMenu("Common Subexpression Elimination");
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Common Subexpression Elimination during Flattening");
        JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Elimination of Compound Common Subexpressions");
        JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("Directly Reuse Equivalent Variables");
        JCheckBoxMenuItem jCheckBoxMenuItem6 = new JCheckBoxMenuItem("Propagate equalities with integer values");
        JCheckBoxMenuItem jCheckBoxMenuItem7 = new JCheckBoxMenuItem("Search for common subexpressions in disjunctions");
        JCheckBoxMenuItem jCheckBoxMenuItem8 = new JCheckBoxMenuItem("Search for common subexpressions in conjunctions");
        JCheckBoxMenuItem jCheckBoxMenuItem9 = new JCheckBoxMenuItem("Detect negated common subexpressions");
        jCheckBoxMenuItem3.setSelected(this.settings.useCommonSubExpressions());
        jCheckBoxMenuItem4.setSelected(this.settings.useEqualCommonSubExpressions());
        jCheckBoxMenuItem5.setSelected(this.settings.applyDirectVariableReusage());
        jCheckBoxMenuItem6.setSelected(this.settings.applyStrictCopyPropagation());
        jCheckBoxMenuItem9.setSelected(this.settings.useNegatedCSEs());
        jCheckBoxMenuItem7.setSelected(this.settings.getUseSimpleDisjunctionCSE());
        jCheckBoxMenuItem8.setSelected(this.settings.getUseSimpleConjunctionCSE());
        jCheckBoxMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseCommonSubExpressions(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseExplicitCommonSubExpressions(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setApplyDirectVariableReusage(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setApplyStrictCopyPropagation(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseSimpleConjunctionCSE(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseSimpleDisjunctionCSE(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseNegatedCSEs(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu2.add(jCheckBoxMenuItem3);
        jMenu2.add(jCheckBoxMenuItem4);
        jMenu2.add(jCheckBoxMenuItem5);
        jMenu2.add(jCheckBoxMenuItem6);
        jMenu2.add(jCheckBoxMenuItem8);
        jMenu2.add(jCheckBoxMenuItem7);
        jMenu2.add(jCheckBoxMenuItem9);
        JMenu jMenu3 = new JMenu("Minion");
        JCheckBoxMenuItem jCheckBoxMenuItem10 = new JCheckBoxMenuItem("Express conjunction by minimum (instead of sum)");
        JCheckBoxMenuItem jCheckBoxMenuItem11 = new JCheckBoxMenuItem("Express disjunction by maximum (instead of sum)");
        JCheckBoxMenuItem jCheckBoxMenuItem12 = new JCheckBoxMenuItem("Use reifyimply");
        jCheckBoxMenuItem10.setSelected(this.settings.useMinionMinimumForConjunction());
        jCheckBoxMenuItem11.setSelected(this.settings.useMinionMaximumForDisjunction());
        jCheckBoxMenuItem12.setSelected(this.settings.getUseMinionReifyImply());
        jCheckBoxMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseMinionMinimumForConjunction(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseMinionMaximumForDisjunction(jCheckBoxMenuItem.isSelected());
            }
        });
        jCheckBoxMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                TailorGUI.this.settings.setUseMinionReifyImply(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu3.add(jCheckBoxMenuItem10);
        jMenu3.add(jCheckBoxMenuItem11);
        jMenu3.add(jCheckBoxMenuItem12);
        JMenu jMenu4 = new JMenu("Gecode");
        JCheckBoxMenuItem jCheckBoxMenuItem13 = new JCheckBoxMenuItem("Use linear constraint (instead of post)");
        jCheckBoxMenuItem13.setSelected(!this.settings.getUseGecodeLinearMinimodelPostConstraints());
        jCheckBoxMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.isSelected()) {
                    TailorGUI.this.settings.setUseGecodeLinearMinimodelPostConstraints(false);
                } else {
                    TailorGUI.this.settings.setUseGecodeLinearMinimodelPostConstraints(true);
                }
            }
        });
        jMenu4.add(jCheckBoxMenuItem13);
        jMenu.add(jCheckBoxMenuItem);
        jMenu.add(jCheckBoxMenuItem2);
        jMenu.add(jMenu2);
        jMenu.add(jMenu3);
        jMenu.add(jMenu4);
        this.menuBar.add(jMenu);
        JMenu jMenu5 = new JMenu("Solving");
        JCheckBoxMenuItem jCheckBoxMenuItem14 = new JCheckBoxMenuItem("Find all solutions");
        jCheckBoxMenuItem14.setSelected(this.settings.getNoOfSolutions() == this.settings.FIND_ALL_SOLUTIONS);
        jCheckBoxMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.isSelected()) {
                    TailorGUI.this.settings.setNoOfSolutions(TailorGUI.this.settings.FIND_ALL_SOLUTIONS);
                } else {
                    TranslationSettings translationSettings = TailorGUI.this.settings;
                    TailorGUI.this.settings.getClass();
                    translationSettings.setNoOfSolutions(1);
                }
            }
        });
        jMenu5.add(jCheckBoxMenuItem14);
        this.menuBar.add(jMenu5);
        JMenu jMenu6 = new JMenu("Skin Selection");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.getSkinName(this.CLASSIC_SKIN));
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(this.getSkinName(this.GIRLIE_SKIN));
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(this.getSkinName(this.NIGHTOWL_SKIN));
        JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(this.getSkinName(this.COLORBLIND_SKIN));
        JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem(this.getSkinName(this.WATERFALL_SKIN));
        JRadioButtonMenuItem jRadioButtonMenuItem6 = new JRadioButtonMenuItem(this.getSkinName(this.ARMY_SKIN));
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem3);
        buttonGroup.add(jRadioButtonMenuItem4);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem5);
        buttonGroup.add(jRadioButtonMenuItem6);
        jRadioButtonMenuItem.setSelected(this.skinType == this.CLASSIC_SKIN);
        jRadioButtonMenuItem2.setSelected(this.skinType == this.GIRLIE_SKIN);
        jRadioButtonMenuItem3.setSelected(this.skinType == this.NIGHTOWL_SKIN);
        jRadioButtonMenuItem4.setSelected(this.skinType == this.COLORBLIND_SKIN);
        jRadioButtonMenuItem5.setSelected(this.skinType == this.WATERFALL_SKIN);
        jRadioButtonMenuItem6.setSelected(this.skinType == this.ARMY_SKIN);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changeSkin('c');
            }
        });
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changeSkin('g');
            }
        });
        jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changeSkin('n');
            }
        });
        jRadioButtonMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changeSkin('b');
            }
        });
        jRadioButtonMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changeSkin('s');
            }
        });
        jRadioButtonMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailorGUI.this.changeSkin('a');
            }
        });
        jMenu6.add(jRadioButtonMenuItem);
        jMenu6.add(jRadioButtonMenuItem2);
        jMenu6.add(jRadioButtonMenuItem3);
        jMenu6.add(jRadioButtonMenuItem4);
        jMenu6.add(jRadioButtonMenuItem5);
        jMenu6.add(jRadioButtonMenuItem6);
        this.settingsMenu.add(jMenu6);
        this.helpMenu.setText("Help");
        this.menuBar.add(this.helpMenu);
        JMenuItem jMenuItem3 = new JMenuItem("Bug Reports");
        JMenuItem jMenuItem4 = new JMenuItem("About");
        this.helpMenu.add(jMenuItem3);
        this.helpMenu.add(jMenuItem4);
        this.setJMenuBar(this.menuBar);
    }

    private void initOutput(int n, int n2) {
        this.normaliseOutput = new JTextArea("", n, n2);
        this.normaliseOutput.setEditable(false);
        this.normaliseOutput.setBackground(this.textAreaColor);
        this.normaliseOutput.setForeground(this.textAreaFontColor);
        JScrollPane jScrollPane = new JScrollPane(this.normaliseOutput);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(n, n2));
        this.flatOutput = new JTextArea("", n, n2);
        this.flatOutput.setEditable(false);
        this.flatOutput.setBackground(this.textAreaColor);
        this.flatOutput.setForeground(this.textAreaFontColor);
        JScrollPane jScrollPane2 = new JScrollPane(this.flatOutput);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setPreferredSize(new Dimension(n, n2));
        this.solverOutput = new JTextArea("", n, n2);
        JScrollPane jScrollPane3 = new JScrollPane(this.solverOutput);
        this.solverOutput.setEditable(true);
        this.solverOutput.setBackground(this.textAreaColor);
        this.solverOutput.setForeground(this.textAreaFontColor);
        this.solverOutput.setFont(this.outputFont);
        jScrollPane3.setVerticalScrollBarPolicy(22);
        jScrollPane3.setPreferredSize(new Dimension(n, n2));
        JLabel jLabel = new JLabel("Minion format");
        jLabel.setLabelFor(this.solverOutput);
        this.solutionOutput = new JTextArea("", n, n2);
        JScrollPane jScrollPane4 = new JScrollPane(this.solutionOutput);
        this.solutionOutput.setEditable(false);
        this.solutionOutput.setBackground(this.textAreaColor);
        this.solutionOutput.setForeground(this.textAreaFontColor);
        jScrollPane4.setVerticalScrollBarPolicy(22);
        jScrollPane4.setPreferredSize(new Dimension(n, n2));
        JLabel jLabel2 = new JLabel("Solutions in Essence'");
        jLabel2.setLabelFor(this.solutionOutput);
        this.outputTabbedPanel = new JTabbedPane();
        this.outputTabbedPanel.add("Normalised E'", jScrollPane);
        this.outputTabbedPanel.add("Flat E'", jScrollPane2);
        this.outputTabbedPanel.add("Solver Input", jScrollPane3);
        this.outputTabbedPanel.add("Essence' solution", jScrollPane4);
        this.outputTabbedPanel.setPreferredSize(new Dimension(n, n2));
        this.outputTabbedPanel.setEnabledAt(this.NORMALISE_TAB_NR, false);
        this.getClass();
        this.outputTabbedPanel.setEnabledAt(1, false);
        this.outputTabbedPanel.setEnabledAt(this.SOLUTION_TAB_NR, false);
        this.getClass();
        this.outputTabbedPanel.setSelectedIndex(2);
    }

    private void changeSkin(char c) {
        this.skinType = c;
        this.setColors();
        this.updateColors();
        this.setTitle(this.TAILOR_VERSION + "  " + this.getSkinName(this.skinType));
    }

    private void updateColors() {
        this.setBackground(this.bgColor);
        this.getContentPane().setBackground(this.bgColor);
        this.inputPanel.setBackground(this.inputBgColor);
        this.inputSplitPane.setBackground(this.inputBgColor);
        this.problemButtonPanel.setBackground(this.inputBgColor);
        this.parameterButtonPanel.setBackground(this.inputBgColor);
        this.problemInputPanel.setBackground(this.inputBgColor);
        this.parameterInputPanel.setBackground(this.inputBgColor);
        this.problemInputScrollPane.setBackground(this.inputBgColor);
        this.parameterInputScrollPane.setBackground(this.inputBgColor);
        this.outputPanel.setBackground(this.outputBgColor);
        this.outputSplitPane.setBackground(this.outputBgColor);
        this.outputButtonPanel.setBackground(this.outputBgColor);
        this.outputScrollPane.setBackground(this.outputBgColor);
        this.outputSplitPane.setBackground(this.outputBgColor);
        this.outputTabbedPanel.setBackground(this.outputBgColor);
        this.messagesPanel.setBackground(this.outputBgColor);
        this.middlePanel.setBackground(this.bgColor);
        this.problemInput.setBackground(this.textAreaColor);
        this.problemInput.setForeground(this.textAreaFontColor);
        this.parameterInput.setForeground(this.textAreaFontColor);
        this.parameterInput.setBackground(this.textAreaColor);
        this.messageOutput.setBackground(this.textAreaColor);
        this.messageOutput.setForeground(this.textAreaFontColor);
        this.normaliseOutput.setBackground(this.textAreaColor);
        this.normaliseOutput.setForeground(this.textAreaFontColor);
        this.flatOutput.setBackground(this.textAreaColor);
        this.flatOutput.setForeground(this.textAreaFontColor);
        this.solverOutput.setBackground(this.textAreaColor);
        this.solverOutput.setForeground(this.textAreaFontColor);
        this.solutionOutput.setBackground(this.textAreaColor);
        this.solutionOutput.setForeground(this.textAreaFontColor);
        this.saveProblemButton.setBackground(this.buttonColor);
        this.saveProblemButton.setFocusPainted(true);
        this.saveParameterButton.setBackground(this.buttonColor);
        this.saveOutputButton.setBackground(this.buttonColor);
        this.loadProblemButton.setBackground(this.buttonColor);
        this.loadParameterButton.setBackground(this.buttonColor);
        this.clearProblemButton.setBackground(this.buttonColor);
        this.clearParameterButton.setBackground(this.buttonColor);
        this.clearOutputButton.setBackground(this.buttonColor);
        this.solverButton.setBackground(this.buttonColor);
        this.solverButtonPanel.setBackground(this.bgColor);
        this.outPanel.setBackground(this.bgColor);
        this.solverPanel.setBackground(this.bgColor);
        this.actionPanel.setBackground(this.bgColor);
        this.runSolverButton.setBackground(this.buttonColor);
    }

    private void changePath(char c) {
        this.fileChooser.setDialogTitle("Change path to " + (c == '\u0001' ? "Minion" : "Gecode"));
        int n = this.fileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                String string = file.getAbsolutePath();
                if (c == '\u0001') {
                    this.settings.setPathToMinion(string);
                    this.writeOnMessageOutput("Changed Minion path to " + string);
                } else if (c == '\u0002') {
                    this.settings.setPathToGecode(string);
                    this.writeOnMessageOutput("Changed Gecode path to " + string);
                }
            }
            catch (Exception exception) {
                System.out.println("Could not change path to Minion:\n" + exception.getMessage() + "\n");
                return;
            }
        }
    }

    protected void load(String string) {
        String string2 = "";
        if (string.endsWith("load_problem")) {
            string2 = "problem";
        } else if (string.equalsIgnoreCase("load_parameter")) {
            string2 = "parameter";
        }
        this.fileChooser.setDialogTitle("Load " + string2 + " File");
        int n = this.fileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            String string3 = file.getPath();
            this.fileChooser.setCurrentDirectory(file);
            if (string.endsWith("load_problem")) {
                this.writeOnMessageOutput("Loading problem file:\n " + string3 + "\n");
                this.openedProblemFile = file.getName();
            } else if (string.endsWith("load_parameter")) {
                this.writeOnMessageOutput("Loading parameter file:\n " + string3 + "\n");
                this.openedParameterFile = file.getName();
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                StringBuffer stringBuffer = new StringBuffer("");
                String string4 = bufferedReader.readLine();
                while (string4 != null && !string4.equalsIgnoreCase("null")) {
                    stringBuffer.append(string4 + "\n");
                    string4 = bufferedReader.readLine();
                }
                if (string.equalsIgnoreCase("load_problem")) {
                    this.writeOnProblemInput(stringBuffer.toString());
                } else if (string.equalsIgnoreCase("load_parameter")) {
                    this.writeOnParameterInput(stringBuffer.toString());
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.writeOnMessageOutput(exception.getMessage());
                return;
            }
        } else {
            this.writeOnMessageOutput("Choosing file cancelled by user.\n");
        }
    }

    protected void save(String string) {
        String string2 = "";
        if (string.endsWith("save_problem")) {
            string2 = "problem";
        } else if (string.equalsIgnoreCase("save_parameter")) {
            string2 = "parameter";
        } else if (string.equalsIgnoreCase("save_output")) {
            string2 = this.solver.getSolverName() + " input";
        }
        this.fileChooser.setDialogTitle("Save " + string2 + " file");
        int n = this.fileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                if (file.createNewFile()) {
                    // empty if block
                }
                FileWriter fileWriter = new FileWriter(file);
                if (!file.canRead()) {
                    this.writeOnMessageOutput("Cannot read file:\n " + file.toString() + "\n");
                } else if (!file.canWrite()) {
                    this.writeOnMessageOutput("Cannot write file:\n " + file.toString() + "\n");
                }
                if (string == "save_problem") {
                    fileWriter.write(this.problemInput.getText());
                    this.writeOnMessageOutput("Saving Essence' problem in:\n " + file.getName() + "." + "\n");
                } else if (string == "save_parameter") {
                    fileWriter.write(this.parameterInput.getText());
                    this.writeOnMessageOutput("Saving Essence' parameter in:\n " + file.getName() + "." + "\n");
                } else if (string == "save_output") {
                    String string3 = "";
                    int n2 = this.outputTabbedPanel.getSelectedIndex();
                    this.getClass();
                    if (n2 == 2) {
                        string3 = this.solverOutput.getText();
                    } else {
                        this.getClass();
                        string3 = n2 == 1 ? this.flatOutput.getText() : (n2 == this.SOLUTION_TAB_NR ? this.solutionOutput.getText() : (n2 == this.NORMALISE_TAB_NR ? this.normaliseOutput.getText() : this.solverOutput.getText()));
                    }
                    fileWriter.write(string3);
                    this.writeOnMessageOutput("Saving " + this.solver.getSolverName() + " input in:\n " + file.getName() + "." + "\n");
                }
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                this.writeOnMessageOutput(exception.getMessage() + "\n");
                return;
            }
        } else {
            this.writeOnMessageOutput("Save command cancelled by user.\n");
        }
    }

    protected void clearInputField(String string) {
        if (string.equals(this.CLEAR_PROBLEM)) {
            this.problemInput.setText(this.ESSENCE_PRIME_HEADER);
            this.writeOnMessageOutput("Cleared problem input.\n");
        } else if (string.equals(this.CLEAR_PARAMETER)) {
            this.parameterInput.setText(this.ESSENCE_PRIME_HEADER);
            this.writeOnMessageOutput("Cleared parameter input.\n");
        } else if (string.equals(this.CLEAR_NORM_OUTPUT)) {
            this.writeOnOutput(this.NORMALISE_TAB_NR, "");
            this.writeOnMessageOutput("Cleared normalised-Essence'-tab.\n");
        } else if (string.equals(this.CLEAR_FLAT_OUTPUT)) {
            this.getClass();
            this.writeOnOutput(1, "");
            this.writeOnMessageOutput("Cleared flat-Essence'-tab.\n");
        } else if (string.equals(this.CLEAR_SOLVER_OUTPUT)) {
            this.getClass();
            this.writeOnOutput(2, "");
            this.writeOnMessageOutput("Cleared solver-output-tab.\n");
        } else if (string.equals(this.CLEAR_SOLUTION_OUTPUT)) {
            this.writeOnOutput(this.SOLUTION_TAB_NR, "");
            this.writeOnMessageOutput("Cleared solution-output-tab.\n");
        }
    }

    protected boolean translate(String string) {
        if (string == "parse") {
            return true;
        }
        if (string == "insert parameters") {
            return true;
        }
        if (string == "evaluate") {
            return true;
        }
        if (string == "order") {
            return true;
        }
        if (string == "full") {
            return true;
        }
        if (string == "flatten") {
            return true;
        }
        if (string == "to_minion") {
            return this.toMinion();
        }
        if (string == "to gecode") {
            return this.toGecode();
        }
        return true;
    }

    protected boolean toMinion() {
        this.solver = new Minion(this.settings);
        this.settings.setTargetSolver(this.solver);
        if (!this.flatten()) {
            return false;
        }
        boolean bl = this.translator.tailorTo(this.solver);
        if (bl) {
            if (this.settings.flattenProblemClassOnly()) {
                this.getClass();
                this.writeOnOutput(1, this.translator.getFlattenedEssencePrimeModel());
                this.writeOnMessageOutput("Flattened model for target solver " + this.solver.getSolverName() + "\n");
                this.getClass();
                this.setCaretPositionOnOutput(1, 1);
            } else {
                this.getClass();
                this.writeOnOutput(2, this.translator.getTargetSolverInstance());
                this.writeOnMessageOutput("Tailored model to target solver " + this.solver.getSolverName() + "\n");
                this.getClass();
                this.setCaretPositionOnOutput(2, 1);
                this.runSolverButton.setEnabled(true);
                this.runSolverButton.setText("Run Minion");
            }
        } else {
            this.writeOnMessageOutput("===================== ERROR ======================\nTailoring to target solver " + this.solver.getSolverName() + " failed.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            return false;
        }
        return true;
    }

    protected boolean toGecode() {
        this.solver = new Gecode(this.settings);
        this.settings.setTargetSolver(this.solver);
        if (!this.flatten()) {
            return false;
        }
        boolean bl = this.translator.tailorTo(this.solver);
        if (bl) {
            if (this.settings.flattenProblemClassOnly()) {
                this.getClass();
                this.writeOnOutput(1, this.translator.getFlattenedEssencePrimeModel());
                this.writeOnMessageOutput("Flattened model for target solver " + this.solver.getSolverName() + "\n");
                this.getClass();
                this.setCaretPositionOnOutput(1, 1);
            } else {
                this.getClass();
                this.writeOnOutput(2, this.translator.getTargetSolverInstance());
                this.writeOnMessageOutput("Tailored model to target solver " + this.solver.getSolverName() + "\n");
                this.getClass();
                this.setCaretPositionOnOutput(2, 1);
                if (this.settings.getGenerateFlatzincOutput()) {
                    this.runSolverButton.setEnabled(true);
                    this.runSolverButton.setText("Run Gecode");
                } else {
                    this.runSolverButton.setEnabled(false);
                }
            }
        } else {
            this.writeOnMessageOutput("===================== ERROR ======================\nTailoring to target solver " + this.solver.getSolverName() + " failed.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            return false;
        }
        return true;
    }

    protected boolean flatten() {
        if (!this.normalise()) {
            return false;
        }
        boolean bl = this.translator.flatten(this.solver);
        if (!bl) {
            this.writeOnMessageOutput("================== ERROR ======================\nFlattening for target solver " + this.solver.getSolverName() + " failed.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            return false;
        }
        this.getClass();
        this.writeOnOutput(1, this.translator.printAdvancedModel());
        this.writeOnMessageOutput("Flattened constraints for target solver " + this.solver.getSolverName() + "\n");
        return true;
    }

    protected boolean normalise() {
        if (!this.parse()) {
            return false;
        }
        if (!this.translator.normalise('\u0004')) {
            this.writeOnMessageOutput("================== ERROR ======================\nFull Normalisation (ordering, evaluation, restructuring) failed.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            return false;
        }
        this.writeOnOutput(this.NORMALISE_TAB_NR, this.translator.printAdvancedModel());
        this.writeOnMessageOutput("Full Normalisation (ordering, evaluation, restructuring) successful.\n");
        return true;
    }

    protected boolean order() {
        if (!this.parse()) {
            return false;
        }
        if (!this.translator.normalise('\u0002')) {
            this.writeOnMessageOutput("================== ERROR ======================\nBasic Normalisation with Ordering failed.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            return false;
        }
        this.writeOnOutput(0, this.translator.printAdvancedModel());
        this.writeOnMessageOutput("Basic Normalisation with Ordering successful.\n");
        return true;
    }

    protected boolean evaluate() {
        if (!this.parse()) {
            return false;
        }
        if (!this.translator.normalise('\u0001')) {
            this.writeOnMessageOutput("================== ERROR ======================\nBasic Normalisation with Evaluation failed.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            return false;
        }
        this.writeOnOutput(this.NORMALISE_TAB_NR, this.translator.printAdvancedModel());
        this.writeOnMessageOutput("Basic Normalisation with Evaluation successful.\n");
        return true;
    }

    protected boolean insertParameters() {
        if (!this.parse()) {
            return false;
        }
        if (!this.translator.normalise('\u0000')) {
            this.writeOnMessageOutput("================== ERROR ======================\nBasic Normalisation failed.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            return false;
        }
        this.writeOnOutput(this.NORMALISE_TAB_NR, this.translator.printAdvancedModel());
        this.writeOnMessageOutput("Basic Normalisation successful.\n");
        return true;
    }

    protected boolean parse() {
        String string = this.problemInput.getText();
        String string2 = this.parameterInput.getText();
        boolean bl = false;
        bl = string2.equalsIgnoreCase("") ? this.translator.parse(string) : this.translator.parse(string, string2);
        if (!bl) {
            this.writeOnMessageOutput("===================== ERROR ======================\nParse Error.\n" + this.translator.getErrorMessage() + "\n" + "===============================================\n");
            System.err.println(this.translator.getErrorMessage());
            return false;
        }
        this.writeOnOutput(this.NORMALISE_TAB_NR, this.translator.printInitialProblemSpecification());
        this.writeOnMessageOutput("Parsing OK.\n");
        return true;
    }

    protected void runMinion() {
        try {
            String string;
            String string2 = this.settings.getSolverInputFileName();
            if (string2 == null) {
                string2 = "out." + this.settings.getTargetSolver().getSolverInputExtension();
            }
            this.writeOnMessageOutput("Creating Minion file: " + string2 + "\n");
            File file = new File(string2);
            if (file.createNewFile()) {
                // empty if block
            }
            FileWriter fileWriter = new FileWriter(file);
            if (!file.canRead()) {
                this.writeOnMessageOutput("Cannot read file: \n " + file.toString() + "\nPlease change reading permissions.");
            } else if (!file.canWrite()) {
                this.writeOnMessageOutput("Cannot write file: \n " + file.toString() + "\nPlease change writing permissions.");
            }
            fileWriter.write(this.solverOutput.getText());
            StringBuffer stringBuffer = new StringBuffer("Saved Minion input in file: " + file.getName() + "." + "\n");
            fileWriter.flush();
            fileWriter.close();
            String string3 = this.settings.getPathToMinion();
            int n = this.settings.getNoOfSolutions();
            String[] stringArray = n == 1 ? new String[]{string3, string2} : (n == this.settings.FIND_ALL_SOLUTIONS ? new String[]{string3, "-findallsols", string2} : new String[]{string3, "-sollimit " + n, string2});
            stringBuffer.append("Executing Minion with command:\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(" " + stringArray[i] + " ");
            }
            this.writeOnMessageOutput(stringBuffer + "\n");
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            String string4 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string4 = string4 + string + "\n";
            }
            string = "";
            StringBuffer stringBuffer2 = new StringBuffer("");
            while ((string = bufferedReader2.readLine()) != null) {
                stringBuffer2.append(string + "\n");
            }
            process.waitFor();
            int n2 = process.exitValue();
            if (n2 == 0) {
                this.writeOnOutput(this.SOLUTION_TAB_NR, this.translator.getEssenceSolution(string4));
                bufferedReader.close();
            } else {
                this.writeOnOutput(this.SOLUTION_TAB_NR, "$ Error in executing Minion.\n$ See system messages below for details.\n");
                if (string4.length() > 1) {
                    this.writeOnMessageOutput("Minion returned the following error message:\n" + string4);
                }
                bufferedReader.close();
                this.writeOnMessageOutput("Minion returned the following error message:\n" + stringBuffer2);
                bufferedReader2.close();
            }
        }
        catch (Exception exception) {
            this.writeOnMessageOutput("Could not run Minion:\n" + exception.getMessage() + "\n" + "You can change the path to your Minion executable in 'Settings'.\n");
            return;
        }
    }

    protected void runFlatZincGecode() {
        try {
            String string;
            String string2 = this.settings.getSolverInputFileName();
            if (string2 == null) {
                string2 = "out.fz";
            }
            this.writeOnMessageOutput("Creating FlatZinc file: " + string2 + "\n");
            File file = new File(string2);
            if (file.createNewFile()) {
                // empty if block
            }
            FileWriter fileWriter = new FileWriter(file);
            if (!file.canRead()) {
                this.writeOnMessageOutput("Cannot read file: \n " + file.toString() + "\nPlease change reading permissions.");
            } else if (!file.canWrite()) {
                this.writeOnMessageOutput("Cannot write file: \n " + file.toString() + "\nPlease change writing permissions.");
            }
            fileWriter.write(this.solverOutput.getText());
            StringBuffer stringBuffer = new StringBuffer("Saved FlatZinc input in file: " + file.getName() + "." + "\n");
            fileWriter.flush();
            fileWriter.close();
            String string3 = this.settings.getPathToFz();
            int n = this.settings.getNoOfSolutions();
            String[] stringArray = n == 1 ? new String[]{string3, "-mode", "stat", string2} : (n == this.settings.FIND_ALL_SOLUTIONS ? new String[]{string3, "-mode", "stat", " --all-solutions ", string2} : new String[]{string3, "-mode", "stat", " -solutions " + n, string2});
            stringBuffer.append("Executing Gecode-Flatzinc with command:\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(" " + stringArray[i] + " ");
            }
            this.writeOnMessageOutput(stringBuffer + "\n");
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            String string4 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string4 = string4 + string + "\n";
            }
            string = "";
            StringBuffer stringBuffer2 = new StringBuffer("");
            while ((string = bufferedReader2.readLine()) != null) {
                stringBuffer2.append(string + "\n");
            }
            process.waitFor();
            int n2 = process.exitValue();
            if (n2 == 0) {
                if (stringBuffer2.length() > 1) {
                    this.writeOnMessageOutput(stringBuffer + "\n\nGecode-FlatZinc returned the following error message:\n" + stringBuffer2);
                    bufferedReader2.close();
                    this.writeOnOutput(this.SOLUTION_TAB_NR, "$ Error in executing Gecode-FlatZinc.\n$ See system messages below for details.\n");
                    bufferedReader.close();
                } else {
                    this.writeOnOutput(this.SOLUTION_TAB_NR, this.translator.getEssenceSolution(string4));
                    bufferedReader.close();
                }
            } else {
                this.writeOnOutput(this.SOLUTION_TAB_NR, "$ Error in executing Gecode-FlatZinc.\n$ See system messages below for details.\n");
                if (string4.length() > 1) {
                    this.writeOnMessageOutput(stringBuffer + "\nGecode-FlatZinc returned the following error message:\n" + string4);
                }
                bufferedReader.close();
                this.writeOnMessageOutput(stringBuffer + "\nGecode-FlatZinc returned the following error message:\n" + stringBuffer2);
                bufferedReader2.close();
            }
        }
        catch (Exception exception) {
            this.writeOnMessageOutput("Could not run Gecode-FlatZinc:\n" + exception.getMessage() + "\n" + "Don't forget to add the Gecode-FlatZinc executable 'fz' to your PATH or the same directory as tailor.jar.\n");
            return;
        }
    }

    protected void runGecode() {
        try {
            String string;
            String string2 = "out." + this.settings.getTargetSolver().getSolverInputExtension();
            String string3 = this.settings.getPathToGecode() + "examples/";
            this.writeOnMessageOutput("Creating Gecode file: " + string2 + "\n");
            File file = new File(string3 + string2);
            if (file.createNewFile()) {
                // empty if block
            }
            FileWriter fileWriter = new FileWriter(file);
            if (!file.canRead()) {
                this.writeOnMessageOutput("Cannot read file: \n " + file.toString() + "\nPlease change reading permissions.");
            } else if (!file.canWrite()) {
                this.writeOnMessageOutput("Cannot write file: \n " + file.toString() + "\nPlease change writing permissions.");
            }
            fileWriter.write(this.solverOutput.getText());
            String string4 = "Saved Gecode input in file: \n " + file.getName() + "." + "\n";
            this.writeOnMessageOutput(string4);
            fileWriter.flush();
            fileWriter.close();
            String[] stringArray = new String[]{"make", "examples/" + string2};
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            String string5 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string5 = string5 + string + "\n";
            }
            string = "";
            StringBuffer stringBuffer = new StringBuffer("");
            while ((string = bufferedReader2.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            process.waitFor();
            int n = process.exitValue();
            if (n != 0) {
                this.writeOnOutput(this.SOLUTION_TAB_NR, "$ Error in compiling.\n$ See system messages below for details.\n");
                if (string5.length() > 1) {
                    this.writeOnMessageOutput("Your C++ compiler returned the following error message:\n" + string5);
                }
                bufferedReader.close();
                this.writeOnMessageOutput("Your C++ compiler returned the following error message:\n" + stringBuffer);
                bufferedReader2.close();
                return;
            }
            this.writeOnOutput(this.SOLUTION_TAB_NR, this.translator.getEssenceSolution(string5));
            bufferedReader.close();
            string3 = string3 + "out";
            int n2 = this.settings.getNoOfSolutions();
            this.writeOnMessageOutput(string4 + "\n\nSearch for " + (n2 == this.settings.FIND_ALL_SOLUTIONS ? "all" : Integer.valueOf(n2)) + " solution(s)" + ". This might take a while.");
            String[] stringArray2 = n2 == 1 ? new String[]{string3, "-solutions 1"} : (n2 == this.settings.FIND_ALL_SOLUTIONS ? new String[]{string3, "-solutions 0"} : new String[]{string3, "-solutions " + n2});
            process = Runtime.getRuntime().exec(stringArray2);
            inputStream = process.getInputStream();
            inputStream2 = process.getErrorStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            String string6 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string6 = string6 + string + "\n";
            }
            string = "";
            StringBuffer stringBuffer2 = new StringBuffer("");
            while ((string = bufferedReader2.readLine()) != null) {
                stringBuffer2.append(string + "\n");
            }
            process.waitFor();
            n = process.exitValue();
            if (n == 0) {
                this.writeOnOutput(this.SOLUTION_TAB_NR, this.translator.getEssenceSolution(string6));
                bufferedReader.close();
            } else {
                this.writeOnOutput(this.SOLUTION_TAB_NR, "$ Error in executing Minion.\n$ See system messages below for details.\n");
                if (string6.length() > 1) {
                    this.writeOnMessageOutput("Minion returned the following error message:\n" + string6);
                }
                bufferedReader.close();
                this.writeOnMessageOutput("Minion returned the following error message:\n" + stringBuffer2);
                bufferedReader2.close();
            }
        }
        catch (Exception exception) {
            this.writeOnMessageOutput("Could not run Minion:\n" + exception.getMessage() + "\n" + "You can change the path to your Minion executable in 'Settings'.\n");
            return;
        }
    }

    public void writeOnOutput(int n, String string) {
        if (n == this.NORMALISE_TAB_NR) {
            this.normaliseOutput.setText(string);
            this.outputTabbedPanel.setEnabledAt(this.NORMALISE_TAB_NR, true);
            this.outputTabbedPanel.setSelectedIndex(this.NORMALISE_TAB_NR);
        } else {
            this.getClass();
            if (n == 1) {
                this.flatOutput.setText(string);
                this.getClass();
                this.outputTabbedPanel.setEnabledAt(1, true);
                this.getClass();
                this.outputTabbedPanel.setSelectedIndex(1);
            } else {
                this.getClass();
                if (n == 2) {
                    this.solverOutput.setText(string);
                    if (this.settings.getGenerateFlatzincOutput()) {
                        this.getClass();
                        this.outputTabbedPanel.setTitleAt(2, "FlatZinc");
                    } else {
                        this.getClass();
                        this.outputTabbedPanel.setTitleAt(2, this.settings.getTargetSolver().getSolverName() + " Input");
                    }
                    this.getClass();
                    this.outputTabbedPanel.setEnabledAt(2, true);
                    this.getClass();
                    this.outputTabbedPanel.setSelectedIndex(2);
                } else if (n == this.SOLUTION_TAB_NR) {
                    this.solutionOutput.setText(string);
                    this.outputTabbedPanel.setEnabledAt(this.SOLUTION_TAB_NR, true);
                    this.outputTabbedPanel.setSelectedIndex(this.SOLUTION_TAB_NR);
                }
            }
        }
    }

    public void setCaretPositionOnOutput(int n, int n2) {
        if (n == this.NORMALISE_TAB_NR) {
            this.normaliseOutput.setCaretPosition(n2);
            this.outputTabbedPanel.setEnabledAt(this.NORMALISE_TAB_NR, true);
            this.outputTabbedPanel.setSelectedIndex(this.NORMALISE_TAB_NR);
        } else {
            this.getClass();
            if (n == 1) {
                this.flatOutput.setCaretPosition(n2);
                this.getClass();
                this.outputTabbedPanel.setEnabledAt(1, true);
                this.getClass();
                this.outputTabbedPanel.setSelectedIndex(1);
            } else {
                this.getClass();
                if (n == 2) {
                    this.solverOutput.setCaretPosition(n2);
                    this.getClass();
                    this.outputTabbedPanel.setEnabledAt(2, true);
                    this.getClass();
                    this.outputTabbedPanel.setSelectedIndex(2);
                } else if (n == this.SOLUTION_TAB_NR) {
                    this.solutionOutput.setCaretPosition(n2);
                    this.outputTabbedPanel.setEnabledAt(this.SOLUTION_TAB_NR, true);
                    this.outputTabbedPanel.setSelectedIndex(this.SOLUTION_TAB_NR);
                }
            }
        }
    }

    private void writeOnMessageOutput(String string) {
        this.messageOutput.setText(string);
    }

    private void writeOnProblemInput(String string) {
        this.problemInput.setText(string);
    }

    private void writeOnParameterInput(String string) {
        this.parameterInput.setText(string);
    }

    private String createHTMLfromEssence(String string) {
        String string2;
        int n;
        string = this.HTMLFONT + string;
        string = string.replaceAll("\n", "<br>\n");
        for (n = 0; n < this.essenceBoldKeywords.size(); ++n) {
            string2 = this.essenceBoldKeywords.get(n);
            string = string.replaceAll(string2, "<b>" + string2 + "</b>");
        }
        for (n = 0; n < this.essenceColourKeywords.size(); ++n) {
            string2 = this.essenceColourKeywords.get(n);
            string = string.replaceAll(string2, "<font color=\"#bf1906\">" + string2 + "</font>");
        }
        return string;
    }

    protected void updateLineColPositions(int n, int n2) {
        if (this.openedProblemFile.length() == 0) {
            this.colLineLabelProblem.setText("Line: " + n + "  Column: " + n2);
        } else {
            this.colLineLabelProblem.setText("Line: " + n + "  Column: " + n2 + "   File: " + this.openedProblemFile);
        }
    }

    protected void updateParameterLineColPositions(int n, int n2) {
        if (this.openedParameterFile.length() == 0) {
            this.colLineLabelParameter.setText("Line: " + n + "  Column: " + n2);
        } else {
            this.colLineLabelParameter.setText("Line: " + n + "  Column: " + n2 + "  File: " + this.openedParameterFile);
        }
    }

    private void initialiseEssenceKeywords() {
        this.essenceBoldKeywords.add("alldifferent");
        this.essenceBoldKeywords.add("alldiff");
        this.essenceBoldKeywords.add("atmost");
        this.essenceBoldKeywords.add("atleast");
        this.essenceBoldKeywords.add("be domain");
        this.essenceBoldKeywords.add(" be ");
        this.essenceBoldKeywords.add(" bool ");
        this.essenceBoldKeywords.add("element");
        this.essenceBoldKeywords.add("exists");
        this.essenceBoldKeywords.add("false");
        this.essenceBoldKeywords.add("find");
        this.essenceBoldKeywords.add("forall");
        this.essenceBoldKeywords.add("gcc");
        this.essenceBoldKeywords.add("given");
        this.essenceBoldKeywords.add("int");
        this.essenceBoldKeywords.add("is domain");
        this.essenceBoldKeywords.add("letting");
        this.essenceBoldKeywords.add("matrix indexed by");
        this.essenceBoldKeywords.add("maximising");
        this.essenceBoldKeywords.add("max");
        this.essenceBoldKeywords.add("minimising");
        this.essenceBoldKeywords.add("min");
        this.essenceBoldKeywords.add("mod");
        this.essenceBoldKeywords.add("parameter");
        this.essenceBoldKeywords.add("param");
        this.essenceBoldKeywords.add("occurrence");
        this.essenceBoldKeywords.add(" of ");
        this.essenceBoldKeywords.add("such that");
        this.essenceBoldKeywords.add("sum");
        this.essenceBoldKeywords.add("table");
        this.essenceBoldKeywords.add("true");
        this.essenceBoldKeywords.add("where");
        this.essenceBoldKeywords.add("ESSENCE");
    }

    private void initialiseColourKeywords() {
    }

    private void formComponentResized(ComponentEvent componentEvent) {
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TailorGUI().setVisible(true);
            }
        });
    }
}

