/*
 * Decompiled with CFR 0.152.
 */
package translator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import translator.gui.MouseFocusListener;

public class LWTextComponent
extends Component
implements KeyListener,
FocusListener {
    private transient boolean haveFocus;
    private String name;
    private StringBuffer committedText = new StringBuffer();
    private transient TextLayout textLayout = null;
    private transient boolean validTextLayout = false;
    private static final int LINE_OFFSET = 8;
    private int textOriginX;
    private int nameOriginY;
    private int textOriginY;

    public LWTextComponent(String string, boolean bl) {
        this.name = string;
        this.setSize(300, 80);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setFontSize(12);
        this.setVisible(true);
        this.setEnabled(true);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(new MouseFocusListener(this));
        this.enableInputMethods(bl);
    }

    public void setFontSize(int n) {
        this.setFont(new Font("Dialog", 0, n));
        this.nameOriginY = 8 + n;
        this.textOriginX = 10;
        this.textOriginY = 2 * (8 + n);
    }

    public synchronized void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Dimension dimension = this.getSize();
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        if (this.haveFocus) {
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        }
        graphics.setColor(this.getForeground());
        graphics.drawString(this.name, this.textOriginX, this.nameOriginY);
        TextLayout textLayout = this.getTextLayout();
        if (textLayout != null) {
            textLayout.draw((Graphics2D)graphics, this.textOriginX, this.textOriginY);
        }
        Rectangle rectangle = this.getCaretRectangle();
        if (this.haveFocus && rectangle != null) {
            graphics.setXORMode(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, 1, rectangle.height);
            graphics.setPaintMode();
        }
    }

    public AttributedCharacterIterator getCommittedText() {
        AttributedString attributedString = new AttributedString(this.committedText.toString());
        return attributedString.getIterator();
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2) {
        AttributedString attributedString = new AttributedString(this.committedText.toString());
        return attributedString.getIterator(null, n, n2);
    }

    public int getCommittedTextLength() {
        return this.committedText.length();
    }

    public AttributedCharacterIterator getDisplayText() {
        AttributedString attributedString = new AttributedString(this.committedText.toString());
        if (this.committedText.length() > 0) {
            attributedString.addAttribute(TextAttribute.FONT, this.getFont());
        }
        return attributedString.getIterator();
    }

    public synchronized TextLayout getTextLayout() {
        if (!this.validTextLayout) {
            this.textLayout = null;
            AttributedCharacterIterator attributedCharacterIterator = this.getDisplayText();
            if (attributedCharacterIterator.getEndIndex() > attributedCharacterIterator.getBeginIndex()) {
                FontRenderContext fontRenderContext = ((Graphics2D)this.getGraphics()).getFontRenderContext();
                this.textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            }
        }
        this.validTextLayout = true;
        return this.textLayout;
    }

    public synchronized void invalidateTextLayout() {
        this.validTextLayout = false;
    }

    public Point getTextOrigin() {
        return new Point(this.textOriginX, this.textOriginY);
    }

    public Rectangle getCaretRectangle() {
        TextHitInfo textHitInfo = this.getCaret();
        if (textHitInfo == null) {
            return null;
        }
        return this.getCaretRectangle(textHitInfo);
    }

    public Rectangle getCaretRectangle(TextHitInfo textHitInfo) {
        TextLayout textLayout = this.getTextLayout();
        int n = textLayout != null ? Math.round(textLayout.getCaretInfo(textHitInfo)[0]) : 0;
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        return new Rectangle(this.textOriginX + n, this.textOriginY - fontMetrics.getAscent(), 0, fontMetrics.getAscent() + fontMetrics.getDescent());
    }

    public TextHitInfo getCaret() {
        return TextHitInfo.trailing(this.committedText.length() - 1);
    }

    public void insertCharacter(char c) {
        this.committedText.append(c);
        this.invalidateTextLayout();
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\b') {
            int n = this.committedText.length();
            if (n > 0) {
                this.committedText.setLength(n - 1);
                this.invalidateTextLayout();
            }
        } else {
            this.insertCharacter(c);
        }
        keyEvent.consume();
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.haveFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.haveFocus = false;
        this.repaint();
    }
}

