/*
 * Decompiled with CFR 0.152.
 */
package translator.gui;

import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class CompositeIterator
implements AttributedCharacterIterator {
    AttributedCharacterIterator iterator1;
    AttributedCharacterIterator iterator2;
    int begin1;
    int end1;
    int begin2;
    int end2;
    int endIndex;
    int currentIndex;
    AttributedCharacterIterator currentIterator;
    int currentIteratorDelta;

    CompositeIterator(AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator attributedCharacterIterator2) {
        this.iterator1 = attributedCharacterIterator;
        this.iterator2 = attributedCharacterIterator2;
        this.begin1 = attributedCharacterIterator.getBeginIndex();
        this.end1 = attributedCharacterIterator.getEndIndex();
        this.begin2 = attributedCharacterIterator2.getBeginIndex();
        this.end2 = attributedCharacterIterator2.getEndIndex();
        this.endIndex = this.end1 - this.begin1 + (this.end2 - this.begin2);
        this.internalSetIndex(0);
    }

    public char first() {
        return this.internalSetIndex(0);
    }

    public char last() {
        if (this.endIndex == 0) {
            return this.internalSetIndex(this.endIndex);
        }
        return this.internalSetIndex(this.endIndex - 1);
    }

    public char next() {
        if (this.currentIndex < this.endIndex) {
            return this.internalSetIndex(this.currentIndex + 1);
        }
        return '\uffff';
    }

    public char previous() {
        if (this.currentIndex > 0) {
            return this.internalSetIndex(this.currentIndex - 1);
        }
        return '\uffff';
    }

    public char current() {
        return this.currentIterator.setIndex(this.currentIndex + this.currentIteratorDelta);
    }

    public char setIndex(int n) {
        if (n < 0 || n > this.endIndex) {
            throw new IllegalArgumentException("invalid index");
        }
        return this.internalSetIndex(n);
    }

    private char internalSetIndex(int n) {
        this.currentIndex = n;
        if (this.currentIndex < this.end1 - this.begin1) {
            this.currentIterator = this.iterator1;
            this.currentIteratorDelta = this.begin1;
        } else {
            this.currentIterator = this.iterator2;
            this.currentIteratorDelta = this.begin2 - (this.end1 - this.begin1);
        }
        return this.currentIterator.setIndex(this.currentIndex + this.currentIteratorDelta);
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public int getRunStart() {
        return this.currentIterator.getRunStart() - this.currentIteratorDelta;
    }

    public int getRunLimit() {
        return this.currentIterator.getRunLimit() - this.currentIteratorDelta;
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        return this.currentIterator.getRunStart(attribute) - this.currentIteratorDelta;
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        return this.currentIterator.getRunLimit(attribute) - this.currentIteratorDelta;
    }

    public int getRunStart(Set set) {
        return this.currentIterator.getRunStart(set) - this.currentIteratorDelta;
    }

    public int getRunLimit(Set set) {
        return this.currentIterator.getRunLimit(set) - this.currentIteratorDelta;
    }

    public Map getAttributes() {
        return this.currentIterator.getAttributes();
    }

    public Set getAllAttributeKeys() {
        HashSet<AttributedCharacterIterator.Attribute> hashSet = new HashSet<AttributedCharacterIterator.Attribute>(this.iterator1.getAllAttributeKeys());
        hashSet.addAll(this.iterator2.getAllAttributeKeys());
        return hashSet;
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.currentIterator.getAttribute(attribute);
    }

    public Object clone() {
        try {
            CompositeIterator compositeIterator = (CompositeIterator)super.clone();
            return compositeIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

