/*
 * Decompiled with CFR 0.152.
 */
package translator.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import translator.gui.CompositeIterator;
import translator.gui.LWTextComponent;

public class ActiveClient
extends LWTextComponent
implements InputMethodListener,
InputMethodRequests {
    private AttributedString composedTextString = null;
    private AttributedCharacterIterator composedText = null;
    private TextHitInfo caret = null;
    private static final AttributedCharacterIterator.Attribute[] IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};
    private static final AttributedCharacterIterator EMPTY_TEXT = new AttributedString("").getIterator();

    public ActiveClient(String string) {
        super(string, true);
        this.enableInputMethods(true);
        this.addInputMethodListener(this);
    }

    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    public void setFontSize(int n) {
        super.setFontSize(n);
        if (this.composedTextString != null) {
            this.composedTextString.addAttribute(TextAttribute.FONT, this.getFont());
        }
    }

    public AttributedCharacterIterator getDisplayText() {
        if (this.composedText == null) {
            return super.getDisplayText();
        }
        return new CompositeIterator(super.getDisplayText(), this.composedText);
    }

    public TextHitInfo getCaret() {
        if (this.composedText == null) {
            return super.getCaret();
        }
        if (this.caret == null) {
            return null;
        }
        return this.caret.getOffsetHit(this.getCommittedTextLength());
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        int n = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        this.composedText = null;
        if (attributedCharacterIterator != null) {
            int n2 = n;
            char c = attributedCharacterIterator.first();
            while (n2-- > 0) {
                this.insertCharacter(c);
                c = attributedCharacterIterator.next();
            }
            if (attributedCharacterIterator.getEndIndex() - (attributedCharacterIterator.getBeginIndex() + n) > 0) {
                this.composedTextString = new AttributedString(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex() + n, attributedCharacterIterator.getEndIndex(), IM_ATTRIBUTES);
                this.composedTextString.addAttribute(TextAttribute.FONT, this.getFont());
                this.composedText = this.composedTextString.getIterator();
            }
        }
        inputMethodEvent.consume();
        this.invalidateTextLayout();
        this.caret = inputMethodEvent.getCaret();
        this.repaint();
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this.caret = inputMethodEvent.getCaret();
        inputMethodEvent.consume();
        this.repaint();
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Object object;
        Rectangle rectangle;
        if (textHitInfo == null) {
            rectangle = this.getCaretRectangle();
        } else {
            object = textHitInfo.getOffsetHit(this.getCommittedTextLength());
            rectangle = this.getCaretRectangle((TextHitInfo)object);
        }
        object = this.getLocationOnScreen();
        rectangle.translate(((Point)object).x, ((Point)object).y);
        return rectangle;
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        Point point = this.getLocationOnScreen();
        Point point2 = this.getTextOrigin();
        TextLayout textLayout = this.getTextLayout();
        if (textLayout != null && textLayout.getBounds().contains(n -= point.x + point2.x, n2 -= point.y + point2.y)) {
            return textLayout.hitTestChar(n, n2).getOffsetHit(-this.getCommittedTextLength());
        }
        return null;
    }

    public int getInsertPositionOffset() {
        return this.getCommittedTextLength();
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getCommittedText(n, n2);
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return EMPTY_TEXT;
    }
}

