/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.BoundedIntRange;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.SingleArray;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableArray
implements SingleArray {
    AtomExpression[] variables;
    String name;

    public VariableArray(AtomExpression[] atomExpressionArray) {
        this.variables = atomExpressionArray;
        this.name = "variableArray";
    }

    public VariableArray(AtomExpression[] atomExpressionArray, String string) {
        this.variables = atomExpressionArray;
        this.name = string;
    }

    public VariableArray(ArrayList<AtomExpression> arrayList) {
        this.variables = new AtomExpression[arrayList.size()];
        for (int i = this.variables.length - 1; i >= 0; --i) {
            this.variables[i] = arrayList.remove(i);
        }
        this.name = "variableArray";
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.variables.length; ++i) {
            if (!this.variables[i].isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < this.variables.length; ++i) {
            ArrayList<Expression> arrayList2 = this.variables[i].getQuantifyingVariables();
            for (int j = 0; j < arrayList2.size(); ++j) {
                arrayList.add(arrayList2.remove(0));
            }
        }
        return arrayList;
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public String getArrayName() {
        return this.name;
    }

    @Override
    public Domain getBaseDomain() {
        return new BoundedIntRange(-100000, 100000);
    }

    @Override
    public Expression copy() {
        AtomExpression[] atomExpressionArray = new AtomExpression[this.variables.length];
        for (int i = 0; i < atomExpressionArray.length; ++i) {
            atomExpressionArray[i] = (AtomExpression)this.variables[i].copy();
        }
        return new VariableArray(atomExpressionArray, new String(this.name));
    }

    @Override
    public Expression evaluate() {
        return this;
    }

    @Override
    public int[] getDomain() {
        if (this.variables.length > 0) {
            int n = this.variables[0].getDomain()[0];
            int n2 = this.variables[0].getDomain()[1];
            for (int i = 1; i < this.variables.length; ++i) {
                int n3 = this.variables[i].getDomain()[0];
                int n4 = this.variables[i].getDomain()[1];
                if (n > n3) {
                    n = n3;
                }
                if (n2 >= n4) continue;
                n2 = n4;
            }
            return new int[]{n, n2};
        }
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        int[] nArray = this.getDomain();
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(nArray[0]), new ArithmeticAtomExpression(nArray[1])};
    }

    @Override
    public int getType() {
        return 29;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.variables.length; ++i) {
            if (n >= this.variables[i].getCategory()) continue;
            n = this.variables[i].getCategory();
        }
        return n;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = (AtomExpression)this.variables[i].insertDomainForVariable(domain, string);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = (AtomExpression)this.variables[i].insertValueForVariable(n, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        for (int i = 0; i < this.variables.length; ++i) {
            Expression expression2 = this.variables[i].replaceVariableWithExpression(string, expression);
            if (expression2 instanceof AtomExpression) {
                this.variables[i] = (AtomExpression)expression2;
                continue;
            }
            try {
                throw new Exception("Replacing variable '" + string + "' with infeasible expression '" + expression + "' that modifies variable-array into:" + expression2 + ". Expected atom expression type.");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = (AtomExpression)this.variables[i].insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return true;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        VariableArray variableArray = (VariableArray)expression;
        if (variableArray.variables.length < this.variables.length) {
            return 'g';
        }
        if (variableArray.variables.length > this.variables.length) {
            return 's';
        }
        for (int i = 0; i < this.variables.length; ++i) {
            if (variableArray.variables[i].getType() == this.variables[i].getType()) {
                char c = this.variables[i].isSmallerThanSameType(variableArray.variables[i]);
                if (c == 'e') continue;
                return c;
            }
            return variableArray.variables[i].getType() > this.variables[i].getType() ? (char)'s' : 'g';
        }
        return 'e';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = (AtomExpression)this.variables[i].replaceVariableWith(variable, variable2);
        }
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.variables.length > 0) {
            stringBuffer.append(this.variables[0]);
        }
        for (int i = 1; i < this.variables.length; ++i) {
            stringBuffer.append(", " + this.variables[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean isLinearExpression() {
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i].adaptIndicesForSolver(string, expressionArray);
        }
    }

    public AtomExpression[] getVariables() {
        return this.variables;
    }

    public void setVariables(AtomExpression[] atomExpressionArray) {
        this.variables = atomExpressionArray;
    }
}

