/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.UnaryArithmeticExpression;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryMinus
implements UnaryArithmeticExpression {
    private Expression argument;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public UnaryMinus(Expression expression) {
        this.argument = expression;
    }

    @Override
    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public Expression copy() {
        UnaryMinus unaryMinus = new UnaryMinus(this.argument.copy());
        unaryMinus.willBeFlattenedToVariable(this.willBeReified);
        return unaryMinus;
    }

    @Override
    public boolean isQuantified() {
        return this.argument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return this.argument.getQuantifyingVariables();
    }

    @Override
    public int[] getDomain() {
        int[] nArray;
        int n;
        int[] nArray2 = this.argument.getDomain();
        int n2 = nArray2[0] < 0 ? nArray2[0] + 2 * nArray2[0] : nArray2[0] - 2 * nArray2[0];
        int n3 = n = nArray2[nArray2.length - 1] < 0 ? nArray2[nArray2.length - 1] + 2 * nArray2[nArray2.length - 1] : nArray2[nArray2.length - 1] - 2 * nArray2[nArray2.length - 1];
        if (n2 < n) {
            int[] nArray3 = new int[2];
            nArray3[0] = n2;
            nArray = nArray3;
            nArray3[1] = n;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = n;
            nArray = nArray4;
            nArray4[1] = n2;
        }
        return nArray;
    }

    @Override
    public Expression[] getDefinedDomain() {
        Expression[] expressionArray = this.argument.getDefinedDomain();
        if (expressionArray[0].getType() == 3 && expressionArray[1].getType() == 3) {
            int n = ((ArithmeticAtomExpression)expressionArray[0]).getConstant();
            int n2 = ((ArithmeticAtomExpression)expressionArray[1]).getConstant();
            n = n < 0 ? n + 2 * n : n - 2 * n;
            n2 = n2 < 0 ? n2 + 2 * n2 : n2 - 2 * n2;
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(n), new ArithmeticAtomExpression(n2)};
        }
        return new Expression[]{new UnaryMinus(expressionArray[0]).evaluate(), new UnaryMinus(expressionArray[1]).evaluate()};
    }

    @Override
    public int getType() {
        return 40;
    }

    @Override
    public int getCategory() {
        return this.argument.getCategory();
    }

    @Override
    public void orderExpression() {
        this.argument.orderExpression();
    }

    @Override
    public String toString() {
        if (this.argument instanceof AtomExpression) {
            return "-" + ((Object)this.argument).toString();
        }
        return "-(" + ((Object)this.argument).toString() + ")";
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        UnaryMinus unaryMinus = (UnaryMinus)expression;
        if (this.argument.getType() == unaryMinus.argument.getType()) {
            return this.argument.isSmallerThanSameType(unaryMinus.argument);
        }
        return this.argument.getType() < unaryMinus.argument.getType() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        this.argument = this.argument.evaluate();
        if (this.argument.getType() == 3) {
            int n = ((ArithmeticAtomExpression)this.argument).getConstant();
            return n < 0 ? new ArithmeticAtomExpression(n + 2 * n) : new ArithmeticAtomExpression(n - 2 * n);
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        this.argument = this.argument.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.argument = this.argument.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.argument = this.argument.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.argument = this.argument.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        this.argument = this.argument.restructure();
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.argument = this.argument.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.argument = this.argument.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return this.argument.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            return "-(" + this.argument.toSolverExpression(targetSolver) + ")";
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.argument.adaptIndicesForSolver(string, expressionArray);
    }
}

