/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.ConstantMatrix;
import translator.expression.ConstantTuple;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.RelationalExpression;
import translator.expression.Variable;
import translator.expression.VariableArray;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableConstraintNew
implements RelationalExpression {
    private Expression variableArray;
    private Expression valueMatrix;
    private boolean isNested;
    private boolean willBeReified = false;
    private boolean isConflictingTable = false;

    public TableConstraintNew(Expression expression, Expression expression2) {
        this.variableArray = expression;
        this.valueMatrix = expression2;
    }

    @Override
    public boolean isQuantified() {
        if (this.variableArray.isQuantified()) {
            return true;
        }
        return this.valueMatrix.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return null;
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public Expression copy() {
        return new TableConstraintNew(this.variableArray.copy(), this.valueMatrix.copy());
    }

    @Override
    public Expression evaluate() {
        this.valueMatrix = this.valueMatrix.evaluate();
        this.variableArray = this.variableArray.evaluate();
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return 221;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.valueMatrix = this.valueMatrix.insertDomainForVariable(domain, string);
        this.variableArray = this.variableArray.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.valueMatrix = this.valueMatrix.insertValueForVariable(n, string);
        this.variableArray = this.variableArray.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.valueMatrix = this.valueMatrix.insertValueForVariable(bl, string);
        this.variableArray = this.variableArray.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return 'e';
    }

    @Override
    public void orderExpression() {
        this.valueMatrix.orderExpression();
        this.variableArray.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        this.variableArray = this.variableArray.reduceExpressionTree();
        this.valueMatrix = this.valueMatrix.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.variableArray = this.variableArray.replaceVariableWith(variable, variable2);
        this.valueMatrix = this.valueMatrix.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.variableArray = this.variableArray.replaceVariableWithExpression(string, expression);
        this.valueMatrix = this.valueMatrix.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public Expression restructure() {
        this.valueMatrix = this.valueMatrix.restructure();
        this.variableArray = this.variableArray.restructure();
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("There is no solver representation of " + this + " for solver " + targetSolver);
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public String toString() {
        int n;
        AtomExpression[] atomExpressionArray = null;
        ConstantMatrix constantMatrix = null;
        if (this.variableArray instanceof VariableArray) {
            atomExpressionArray = ((VariableArray)this.variableArray).getVariables();
        }
        if (!(this.valueMatrix instanceof ConstantMatrix)) {
            return new String("TABLE");
        }
        constantMatrix = (ConstantMatrix)this.valueMatrix;
        int[][] nArray = constantMatrix.getElements();
        String string = this.isConflictingTable ? "Conflict" : "";
        StringBuffer stringBuffer = new StringBuffer("table" + string + "( [");
        if (atomExpressionArray.length >= 1) {
            stringBuffer.append(atomExpressionArray[0].toString());
        }
        for (n = 1; n < atomExpressionArray.length; ++n) {
            stringBuffer.append("," + atomExpressionArray[n].toString());
        }
        stringBuffer.append("], [");
        if (nArray.length >= 1) {
            stringBuffer.append("[" + nArray[0][0]);
        }
        for (n = 1; n < nArray.length; ++n) {
            for (int i = 0; i < nArray[0].length; ++i) {
                stringBuffer.append(", " + nArray[n][i]);
                if (i != nArray.length - 1) continue;
                stringBuffer.append("], ");
            }
        }
        return stringBuffer + "] )";
    }

    public AtomExpression[] getVariables() {
        if (this.variableArray instanceof VariableArray) {
            return ((VariableArray)this.variableArray).variables;
        }
        return null;
    }

    public ConstantTuple[] getTupleList() {
        if (this.valueMatrix instanceof ConstantMatrix) {
            int[][] nArray = ((ConstantMatrix)this.valueMatrix).getElements();
            ConstantTuple[] constantTupleArray = new ConstantTuple[nArray.length];
            for (int i = 0; i < constantTupleArray.length; ++i) {
                constantTupleArray[i] = new ConstantTuple(nArray[i]);
            }
            return constantTupleArray;
        }
        return null;
    }

    public boolean isConflictingTableConstraint() {
        return this.isConflictingTable;
    }

    public void setVariables(VariableArray variableArray) {
        this.variableArray = variableArray;
    }

    public VariableArray getVariableArray() {
        if (this.variableArray instanceof VariableArray) {
            return (VariableArray)this.variableArray;
        }
        return null;
    }

    public void setVariables(AtomExpression[] atomExpressionArray) {
        if (this.variableArray instanceof VariableArray) {
            ((VariableArray)this.variableArray).setVariables(atomExpressionArray);
        } else {
            this.variableArray = new VariableArray(atomExpressionArray);
        }
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.valueMatrix != null) {
            this.valueMatrix.adaptIndicesForSolver(string, expressionArray);
        }
        if (this.variableArray != null) {
            this.variableArray.adaptIndicesForSolver(string, expressionArray);
        }
    }
}

