/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Conjunction;
import translator.expression.ConstantTuple;
import translator.expression.Disjunction;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.RelationalAtomExpression;
import translator.expression.RelationalExpression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableConstraint
implements RelationalExpression {
    private Variable[] variableList;
    private ConstantTuple[] tupleList;
    private boolean isNested;
    private boolean willBeReified = false;
    private boolean isConflictingTable = false;

    public TableConstraint(Variable[] variableArray, ConstantTuple[] constantTupleArray) {
        this.variableList = variableArray;
        this.tupleList = constantTupleArray;
        this.isNested = true;
    }

    @Override
    public boolean isQuantified() {
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return null;
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    public TableConstraint(ArrayList<Variable> arrayList, ArrayList<ConstantTuple> arrayList2) {
        int n;
        this.variableList = new Variable[arrayList.size()];
        for (n = arrayList.size() - 1; n >= 0; --n) {
            this.variableList[n] = arrayList.remove(n);
        }
        this.tupleList = new ConstantTuple[arrayList2.size()];
        for (n = arrayList2.size() - 1; n >= 0; --n) {
            this.tupleList[n] = arrayList2.remove(n);
        }
    }

    @Override
    public Expression copy() {
        Variable[] variableArray = new Variable[this.variableList.length];
        for (int i = 0; i < this.variableList.length; ++i) {
            variableArray[i] = (Variable)this.variableList[i].copy();
        }
        ConstantTuple[] constantTupleArray = new ConstantTuple[this.tupleList.length];
        for (int i = 0; i < this.tupleList.length; ++i) {
            constantTupleArray[i] = this.tupleList[i].copy();
        }
        TableConstraint tableConstraint = new TableConstraint(variableArray, constantTupleArray);
        tableConstraint.setToConflictingTableConstraint(this.isConflictingTable);
        return tableConstraint;
    }

    @Override
    public Expression evaluate() {
        for (int i = 0; i < this.variableList.length; ++i) {
            this.variableList[i] = (Variable)this.variableList[i].evaluate();
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return 221;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.variableList.length; ++i) {
            Expression expression = this.variableList[i].insertValueForVariable(n, string);
            if (expression instanceof Variable) {
                this.variableList[i] = (Variable)expression;
                continue;
            }
            if (expression.getType() != 3 || this.isConflictingTable) continue;
            int n2 = ((ArithmeticAtomExpression)expression).getConstant();
            for (int j = 0; j < this.tupleList.length; ++j) {
                ConstantTuple constantTuple = this.tupleList[j];
                if (constantTuple.tupleElements[i] != n2) continue;
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                for (int k = 0; k < this.variableList.length; ++k) {
                    if (k == i) continue;
                    if (!this.isConflictingTable) {
                        arrayList.add(new CommutativeBinaryRelationalExpression(new ArithmeticAtomExpression(this.variableList[k]), 101, new ArithmeticAtomExpression(constantTuple.tupleElements[k])));
                        continue;
                    }
                    arrayList.add(new CommutativeBinaryRelationalExpression(new ArithmeticAtomExpression(this.variableList[k]), 100, new ArithmeticAtomExpression(constantTuple.tupleElements[k])));
                }
                if (this.isConflictingTable) {
                    return new Disjunction(arrayList);
                }
                return new Conjunction(arrayList);
            }
            if (!this.isConflictingTable) {
                return new RelationalAtomExpression(false);
            }
            return new RelationalAtomExpression(true);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        for (int i = 0; i < this.variableList.length; ++i) {
            this.variableList[i] = (Variable)this.variableList[i].insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        for (int i = 0; i < this.variableList.length; ++i) {
            Expression expression2 = this.variableList[i].replaceVariableWithExpression(string, expression);
            if (expression2 instanceof Variable) {
                this.variableList[i] = (Variable)expression2;
                continue;
            }
            try {
                throw new Exception("Replacing variable '" + string + "' with infeasible expression '" + expression + "' that modifies table-constraint-array into:" + expression2 + ". Expected variable type.");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        TableConstraint tableConstraint = (TableConstraint)expression;
        if (this.variableList.length == tableConstraint.variableList.length) {
            if (this.tupleList.length == tableConstraint.tupleList.length) {
                for (int i = 0; i < this.variableList.length; ++i) {
                    if (this.variableList[i].getType() == tableConstraint.variableList[i].getType()) {
                        if (this.variableList[i].getVariableName().compareTo(tableConstraint.variableList[i].getVariableName()) == 0) continue;
                        return this.variableList[i].getVariableName().compareTo(tableConstraint.variableList[i].getVariableName()) < 0 ? (char)'s' : 'g';
                    }
                    return this.variableList[i].getType() < tableConstraint.variableList[i].getType() ? (char)'s' : 'g';
                }
                return 'e';
            }
            return this.tupleList.length < tableConstraint.tupleList.length ? (char)'s' : 'g';
        }
        return this.variableList.length < tableConstraint.variableList.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public String toString() {
        int n;
        String string = this.isConflictingTable ? "Conflict" : "";
        StringBuffer stringBuffer = new StringBuffer("table" + string + "( [");
        if (this.variableList.length >= 1) {
            stringBuffer.append(this.variableList[0].toString());
        }
        for (n = 1; n < this.variableList.length; ++n) {
            stringBuffer.append("," + this.variableList[n].toString());
        }
        stringBuffer.append("], [");
        if (this.tupleList.length >= 1) {
            stringBuffer.append(this.tupleList[0].toString());
        }
        for (n = 1; n < this.tupleList.length; ++n) {
            stringBuffer.append(", " + this.tupleList[n]);
        }
        return stringBuffer + "] )";
    }

    public StringBuffer toStringBuffer() {
        int n;
        String string = this.isConflictingTable ? "Conflict" : "";
        StringBuffer stringBuffer = new StringBuffer("table" + string + "( [");
        if (this.variableList.length >= 1) {
            stringBuffer.append(this.variableList[0].toString());
        }
        for (n = 1; n < this.variableList.length; ++n) {
            stringBuffer.append("," + this.variableList[n].toString());
        }
        stringBuffer.append("], [");
        if (this.tupleList.length >= 1) {
            stringBuffer.append(this.tupleList[0].toString());
        }
        for (n = 1; n < this.tupleList.length; ++n) {
            stringBuffer.append(", " + this.tupleList[n]);
        }
        stringBuffer.append("] )");
        return stringBuffer;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        for (int i = 0; i < this.variableList.length; ++i) {
            this.variableList[i] = (Variable)this.variableList[i].replaceVariableWith(variable, variable2);
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        for (int i = 0; i < this.variableList.length; ++i) {
            this.variableList[i].adaptIndicesForSolver(string, expressionArray);
        }
    }

    public Variable[] getVariables() {
        return this.variableList;
    }

    public ConstantTuple[] getTupleList() {
        return this.tupleList;
    }

    public boolean isConflictingTableConstraint() {
        return this.isConflictingTable;
    }

    public void setToConflictingTableConstraint(boolean bl) {
        this.isConflictingTable = bl;
    }
}

