/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArithmeticExpression;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.GlobalConstraint;
import translator.expression.Sum;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumConstraint
implements GlobalConstraint {
    private Expression[] positiveArguments;
    private Expression[] negativeArguments;
    private Expression result;
    private int relationalOperator;
    private boolean isNested = true;
    private boolean willBeReified = false;
    private boolean hasToBeBinary = false;

    public SumConstraint(Expression[] expressionArray, Expression[] expressionArray2, int n, Expression expression, boolean bl) {
        this.positiveArguments = expressionArray;
        this.negativeArguments = expressionArray2;
        this.relationalOperator = bl ? this.switchOperator(n) : n;
        this.result = expression;
        if (this.positiveArguments == null) {
            this.positiveArguments = new Expression[0];
        }
        if (this.negativeArguments == null) {
            this.negativeArguments = new Expression[0];
        }
    }

    public SumConstraint(Expression[] expressionArray, Expression[] expressionArray2) {
        this.positiveArguments = expressionArray;
        this.negativeArguments = expressionArray2;
        if (this.positiveArguments == null) {
            this.positiveArguments = new Expression[0];
        }
        if (this.negativeArguments == null) {
            this.negativeArguments = new Expression[0];
        }
    }

    public SumConstraint(ArrayList<Expression> arrayList, ArrayList<Expression> arrayList2, int n, Expression expression) {
        int n2;
        this.positiveArguments = new Expression[arrayList.size()];
        this.negativeArguments = new Expression[arrayList2.size()];
        for (n2 = this.positiveArguments.length - 1; n2 >= 0; --n2) {
            this.positiveArguments[n2] = arrayList.remove(n2);
        }
        for (n2 = this.negativeArguments.length - 1; n2 >= 0; --n2) {
            this.negativeArguments[n2] = arrayList2.remove(n2);
        }
        this.relationalOperator = n;
        this.result = expression;
    }

    public int getOperator() {
        return this.relationalOperator;
    }

    public void setResult(Expression expression, int n, boolean bl) {
        this.relationalOperator = bl ? this.switchOperator(n) : n;
        this.result = expression;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    private int switchOperator(int n) {
        switch (n) {
            case 104: {
                return 108;
            }
            case 108: {
                return 104;
            }
            case 106: {
                return 102;
            }
            case 102: {
                return 106;
            }
        }
        return n;
    }

    @Override
    public boolean isQuantified() {
        int n;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            if (!this.positiveArguments[n].isQuantified()) continue;
            return true;
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            if (!this.negativeArguments[n].isQuantified()) continue;
            return true;
        }
        return this.result != null && this.result.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        int n;
        int n2;
        ArrayList<Expression> arrayList;
        int n3;
        ArrayList<Expression> arrayList2 = null;
        arrayList2 = this.result != null ? this.result.getQuantifyingVariables() : new ArrayList();
        for (n3 = 0; n3 < this.positiveArguments.length; ++n3) {
            arrayList = this.positiveArguments[n3].getQuantifyingVariables();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                arrayList2.add(arrayList.remove(0));
            }
        }
        for (n3 = 0; n3 < this.negativeArguments.length; ++n3) {
            arrayList = this.negativeArguments[n3].getQuantifyingVariables();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                arrayList2.add(arrayList.remove(0));
            }
        }
        return arrayList2;
    }

    @Override
    public Expression[] getArguments() {
        int n;
        Expression[] expressionArray = new Expression[this.positiveArguments.length + this.negativeArguments.length];
        for (n = 0; n < this.positiveArguments.length; ++n) {
            expressionArray[n] = this.positiveArguments[n];
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            expressionArray[this.positiveArguments.length + n] = this.negativeArguments[n];
        }
        return expressionArray;
    }

    @Override
    public Expression copy() {
        Expression[] expressionArray = new Expression[this.positiveArguments.length];
        for (int i = 0; i < this.positiveArguments.length; ++i) {
            expressionArray[i] = this.positiveArguments[i].copy();
        }
        Expression[] expressionArray2 = new Expression[this.negativeArguments.length];
        for (int i = 0; i < this.negativeArguments.length; ++i) {
            expressionArray2[i] = this.negativeArguments[i].copy();
        }
        return new SumConstraint(expressionArray, expressionArray2, this.relationalOperator, this.result.copy(), false);
    }

    @Override
    public Expression evaluate() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.positiveArguments.length; ++n3) {
            this.positiveArguments[n3] = this.positiveArguments[n3].evaluate();
            if (this.positiveArguments[n3].getType() != 3 || ((ArithmeticAtomExpression)this.positiveArguments[n3]).getConstant() != 0) continue;
            ++n4;
        }
        if (n4 > 0) {
            Expression[] expressionArray = new Expression[this.positiveArguments.length - n4];
            n2 = 0;
            for (n = 0; n < this.positiveArguments.length; ++n) {
                if (this.positiveArguments[n].getType() == 3) {
                    if (((ArithmeticAtomExpression)this.positiveArguments[n]).getConstant() == 0) continue;
                    expressionArray[n2] = this.positiveArguments[n];
                    ++n2;
                    continue;
                }
                expressionArray[n2] = this.positiveArguments[n];
                ++n2;
            }
            this.positiveArguments = expressionArray;
        }
        n4 = 0;
        for (n3 = 0; n3 < this.negativeArguments.length; ++n3) {
            this.negativeArguments[n3] = this.negativeArguments[n3].evaluate();
            if (this.negativeArguments[n3].getType() != 3 || ((ArithmeticAtomExpression)this.negativeArguments[n3]).getConstant() != 0) continue;
            ++n4;
        }
        if (n4 > 0) {
            Expression[] expressionArray = new Expression[this.negativeArguments.length - n4];
            n2 = 0;
            for (n = 0; n < this.negativeArguments.length; ++n) {
                if (this.negativeArguments[n].getType() == 3) {
                    if (((ArithmeticAtomExpression)this.negativeArguments[n]).getConstant() == 0) continue;
                    expressionArray[n2] = this.negativeArguments[n];
                    ++n2;
                    continue;
                }
                expressionArray[n2] = this.negativeArguments[n];
                ++n2;
            }
            this.negativeArguments = expressionArray;
        }
        this.result = this.result.evaluate();
        if (this.positiveArguments.length == 0 && this.negativeArguments.length == 0) {
            return new CommutativeBinaryRelationalExpression(new ArithmeticAtomExpression(0), 101, this.result);
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        switch (this.relationalOperator) {
            case 101: {
                return this.positiveArguments.length + this.negativeArguments.length == 2 ? 270 : 251;
            }
            case 104: {
                return this.positiveArguments.length + this.negativeArguments.length == 2 ? 273 : 254;
            }
            case 108: {
                return this.positiveArguments.length + this.negativeArguments.length == 2 ? 275 : 257;
            }
            case 102: {
                return this.positiveArguments.length + this.negativeArguments.length == 2 ? 272 : 253;
            }
            case 106: {
                return this.positiveArguments.length + this.negativeArguments.length == 2 ? 274 : 255;
            }
            case 100: {
                return this.positiveArguments.length + this.negativeArguments.length == 2 ? 271 : 252;
            }
        }
        return 0;
    }

    @Override
    public int getCategory() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            if (n2 >= this.positiveArguments[n].getCategory()) continue;
            n2 = this.positiveArguments[n].getCategory();
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            if (n2 >= this.negativeArguments[n].getCategory()) continue;
            n2 = this.negativeArguments[n].getCategory();
        }
        return this.result.getCategory() > n2 ? this.result.getCategory() : n2;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        int n2;
        for (n2 = 0; n2 < this.positiveArguments.length; ++n2) {
            this.positiveArguments[n2] = this.positiveArguments[n2].insertValueForVariable(n, string);
        }
        for (n2 = 0; n2 < this.negativeArguments.length; ++n2) {
            this.negativeArguments[n2] = this.negativeArguments[n2].insertValueForVariable(n, string);
        }
        this.result = this.result.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        int n;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            this.positiveArguments[n] = this.positiveArguments[n].insertValueForVariable(bl, string);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            this.negativeArguments[n] = this.negativeArguments[n].insertValueForVariable(bl, string);
        }
        this.result = this.result.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        int n;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            this.positiveArguments[n] = this.positiveArguments[n].replaceVariableWithExpression(string, expression);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            this.negativeArguments[n] = this.negativeArguments[n].replaceVariableWithExpression(string, expression);
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        SumConstraint sumConstraint = (SumConstraint)expression;
        int n = this.positiveArguments.length + this.negativeArguments.length;
        int n2 = sumConstraint.positiveArguments.length + sumConstraint.positiveArguments.length;
        if (n < n2) {
            return 's';
        }
        if (n == n2) {
            if (this.positiveArguments.length > 0) {
                if (this.positiveArguments.length == sumConstraint.positiveArguments.length) {
                    for (int i = 0; i < this.positiveArguments.length; ++i) {
                        Expression expression2 = this.positiveArguments[i];
                        Expression expression3 = sumConstraint.positiveArguments[i];
                        if (expression2.getType() == expression3.getType()) {
                            char c = expression2.isSmallerThanSameType(expression3);
                            if (c == 'e') continue;
                            return c;
                        }
                        return expression2.getType() < expression3.getType() ? (char)'s' : 'g';
                    }
                    return 'e';
                }
                return this.positiveArguments.length > sumConstraint.positiveArguments.length ? (char)'s' : 'g';
            }
            if (sumConstraint.positiveArguments.length > 0) {
                return 'g';
            }
            for (int i = 0; i < this.negativeArguments.length; ++i) {
                Expression expression4 = this.negativeArguments[i];
                Expression expression5 = sumConstraint.negativeArguments[i];
                if (expression4.getType() == expression5.getType()) {
                    char c = expression4.isSmallerThanSameType(expression5);
                    if (c == 'e') continue;
                    return c;
                }
                return expression4.getType() < expression5.getType() ? (char)'s' : 'g';
            }
            if (this.result.getType() == sumConstraint.result.getType()) {
                return this.result.isSmallerThanSameType(sumConstraint.result);
            }
            return this.result.getType() < sumConstraint.result.getType() ? (char)'s' : 'g';
        }
        return 'g';
    }

    @Override
    public void orderExpression() {
        int n;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            this.positiveArguments[n].orderExpression();
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            this.negativeArguments[n].orderExpression();
        }
        this.result.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        int n;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            this.positiveArguments[n] = this.positiveArguments[n].reduceExpressionTree();
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            this.negativeArguments[n] = this.negativeArguments[n].reduceExpressionTree();
        }
        this.result = this.result.reduceExpressionTree();
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public String toString() {
        int n;
        String string = "";
        switch (this.relationalOperator) {
            case 116: {
                string = "=>";
                break;
            }
            case 102: {
                string = "<";
                break;
            }
            case 104: {
                string = "<=";
                break;
            }
            case 108: {
                string = ">=";
                break;
            }
            case 106: {
                string = ">";
                break;
            }
            case 101: {
                string = "=";
                break;
            }
            case 100: {
                string = "!=";
            }
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.positiveArguments.length > 0) {
            stringBuffer.append("" + this.positiveArguments[0]);
        }
        for (n = 1; n < this.positiveArguments.length; ++n) {
            stringBuffer.append(" + " + this.positiveArguments[n]);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            stringBuffer.append(" - " + this.negativeArguments[n]);
        }
        String string2 = this.result == null ? "" : ((Object)this.result).toString();
        return stringBuffer + string + string2;
    }

    public Expression[] getPositiveArguments() {
        return this.positiveArguments;
    }

    public Expression[] getNegativeArguments() {
        return this.negativeArguments;
    }

    public Expression getResult() {
        return this.result;
    }

    public boolean hasToBeBinary() {
        return this.hasToBeBinary;
    }

    public void setHasToBeBinary(boolean bl) {
        this.hasToBeBinary = bl;
    }

    public int getRelationalOperator() {
        return this.relationalOperator;
    }

    public int[] getSumDomain() {
        int[] nArray;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            nArray = this.positiveArguments[n].getDomain();
            n2 += nArray[0];
            n3 += nArray[nArray.length - 1];
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            nArray = this.negativeArguments[n].getDomain();
            n2 -= nArray[nArray.length - 1];
            n3 -= nArray[0];
        }
        return new int[]{n2, n3};
    }

    public Expression[] getSumDefinedDomain() {
        Expression[] expressionArray;
        int n;
        ArithmeticExpression arithmeticExpression = new ArithmeticAtomExpression(0);
        ArithmeticExpression arithmeticExpression2 = new ArithmeticAtomExpression(0);
        for (n = 0; n < this.positiveArguments.length; ++n) {
            expressionArray = this.positiveArguments[n].getDefinedDomain();
            arithmeticExpression = new Sum(new Expression[]{arithmeticExpression, expressionArray[0]}, new Expression[0]);
            arithmeticExpression2 = new Sum(new Expression[]{arithmeticExpression2, expressionArray[1]}, new Expression[0]);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            expressionArray = this.negativeArguments[n].getDefinedDomain();
            arithmeticExpression = new Sum(new Expression[]{arithmeticExpression}, new Expression[]{expressionArray[1]});
            arithmeticExpression2 = new Sum(new Expression[]{arithmeticExpression2}, new Expression[]{expressionArray[0]});
        }
        return new Expression[]{arithmeticExpression.evaluate(), arithmeticExpression2.evaluate()};
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        int n;
        for (n = 0; n < this.positiveArguments.length; ++n) {
            this.positiveArguments[n] = this.positiveArguments[n].insertDomainForVariable(domain, string);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            this.negativeArguments[n] = this.negativeArguments[n].insertDomainForVariable(domain, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        int n;
        this.result = this.result.replaceVariableWith(variable, variable2);
        for (n = 0; n < this.positiveArguments.length; ++n) {
            this.positiveArguments[n] = this.positiveArguments[n].replaceVariableWith(variable, variable2);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            this.negativeArguments[n] = this.negativeArguments[n].replaceVariableWith(variable, variable2);
        }
        return this;
    }

    public String toGecodeString() {
        int n;
        String string = "";
        switch (this.relationalOperator) {
            case 116: {
                string = "=>";
                break;
            }
            case 102: {
                string = "<";
                break;
            }
            case 104: {
                string = "<=";
                break;
            }
            case 108: {
                string = ">=";
                break;
            }
            case 106: {
                string = ">";
                break;
            }
            case 101: {
                string = "==";
                break;
            }
            case 100: {
                string = "!=";
            }
        }
        String string2 = "";
        if (this.positiveArguments.length > 0) {
            string2 = "" + this.positiveArguments[0];
        }
        for (n = 1; n < this.positiveArguments.length; ++n) {
            string2 = string2.concat(" + " + this.positiveArguments[n]);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            string2 = string2.concat(" - " + this.negativeArguments[n]);
        }
        String string3 = ((Object)this.result).toString();
        return string2 + " " + string + " " + string3;
    }

    @Override
    public boolean isLinearExpression() {
        return new Sum(this.positiveArguments, this.negativeArguments).isLinearExpression() && this.result.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode && this.isLinearExpression()) {
            return this.toGecodeString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public void setOperator(int n) {
        this.relationalOperator = n;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        int n;
        this.result.adaptIndicesForSolver(string, expressionArray);
        for (n = 0; n < this.positiveArguments.length; ++n) {
            this.positiveArguments[n].adaptIndicesForSolver(string, expressionArray);
        }
        for (n = 0; n < this.negativeArguments.length; ++n) {
            this.negativeArguments[n].adaptIndicesForSolver(string, expressionArray);
        }
    }
}

