/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArithmeticExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.Multiplication;
import translator.expression.NaryArithmeticExpression;
import translator.expression.RelationalAtomExpression;
import translator.expression.UnaryMinus;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sum
extends NaryArithmeticExpression {
    private ArrayList<Expression> positiveArguments;
    private ArrayList<Expression> negativeArguments;
    private boolean convertToSumConstraint = false;

    public Sum(ArrayList<Expression> arrayList, ArrayList<Expression> arrayList2) {
        this.positiveArguments = arrayList;
        this.negativeArguments = arrayList2;
        if (this.positiveArguments == null) {
            this.positiveArguments = new ArrayList();
        }
        if (this.negativeArguments == null) {
            this.negativeArguments = new ArrayList();
        }
    }

    public Sum(Expression[] expressionArray, Expression[] expressionArray2) {
        int n;
        this.positiveArguments = new ArrayList();
        this.negativeArguments = new ArrayList();
        for (n = 0; n < expressionArray.length; ++n) {
            this.positiveArguments.add(expressionArray[n]);
        }
        for (n = 0; n < expressionArray2.length; ++n) {
            this.negativeArguments.add(expressionArray2[n]);
        }
    }

    public boolean willBeConvertedToASumConstraint() {
        return this.convertToSumConstraint;
    }

    public void setWillBeConvertedToSumConstraint(boolean bl) {
        this.convertToSumConstraint = bl;
    }

    @Override
    public boolean isQuantified() {
        int n;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            if (!this.positiveArguments.get(n).isQuantified()) continue;
            return true;
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            if (!this.negativeArguments.get(n).isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        int n;
        int n2;
        ArrayList<Expression> arrayList;
        int n3;
        ArrayList<Expression> arrayList2 = new ArrayList();
        if (this.positiveArguments.size() > 0) {
            arrayList2 = this.positiveArguments.get(0).getQuantifyingVariables();
        }
        for (n3 = 1; n3 < this.positiveArguments.size(); ++n3) {
            arrayList = this.positiveArguments.get(n3).getQuantifyingVariables();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                arrayList2.add(arrayList.remove(0));
            }
        }
        for (n3 = 0; n3 < this.negativeArguments.size(); ++n3) {
            arrayList = this.negativeArguments.get(n3).getQuantifyingVariables();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                arrayList2.add(arrayList.remove(0));
            }
        }
        return arrayList2;
    }

    public ArrayList<Expression> getPositiveArguments() {
        return this.positiveArguments;
    }

    public ArrayList<Expression> getNegativeArguments() {
        return this.negativeArguments;
    }

    @Override
    public int[] getDomain() {
        int[] nArray;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            nArray = this.positiveArguments.get(n).getDomain();
            n2 += nArray[0];
            n3 += nArray[nArray.length - 1];
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            nArray = this.negativeArguments.get(n).getDomain();
            n2 -= nArray[nArray.length - 1];
            n3 -= nArray[0];
        }
        return new int[]{n2, n3};
    }

    @Override
    public Expression[] getDefinedDomain() {
        Expression[] expressionArray;
        int n;
        ArithmeticExpression arithmeticExpression = new ArithmeticAtomExpression(0);
        ArithmeticExpression arithmeticExpression2 = new ArithmeticAtomExpression(0);
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            expressionArray = this.positiveArguments.get(n).getDefinedDomain();
            arithmeticExpression = new Sum(new Expression[]{arithmeticExpression, expressionArray[0]}, new Expression[0]);
            arithmeticExpression2 = new Sum(new Expression[]{arithmeticExpression2, expressionArray[1]}, new Expression[0]);
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            expressionArray = this.negativeArguments.get(n).getDefinedDomain();
            arithmeticExpression = new Sum(new Expression[]{arithmeticExpression}, new Expression[]{expressionArray[1]});
            arithmeticExpression2 = new Sum(new Expression[]{arithmeticExpression2}, new Expression[]{expressionArray[0]});
        }
        return new Expression[]{arithmeticExpression.evaluate(), arithmeticExpression2.evaluate()};
    }

    @Override
    public Expression copy() {
        int n;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            arrayList.add(this.positiveArguments.get(n).copy());
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            arrayList2.add(this.negativeArguments.get(n).copy());
        }
        return new Sum(arrayList, arrayList2);
    }

    @Override
    public int getType() {
        return 200;
    }

    @Override
    public int getCategory() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            if (n2 >= this.positiveArguments.get(n).getCategory()) continue;
            n2 = this.positiveArguments.get(n).getCategory();
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            if (n2 >= this.negativeArguments.get(n).getCategory()) continue;
            n2 = this.negativeArguments.get(n).getCategory();
        }
        return n2;
    }

    @Override
    public void orderExpression() {
        this.positiveArguments = this.orderExpressionList(this.positiveArguments);
        this.negativeArguments = this.orderExpressionList(this.negativeArguments);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.positiveArguments.size() > 0) {
            stringBuffer.append(((Object)this.positiveArguments.get(0)).toString());
        }
        for (n = 1; n < this.positiveArguments.size(); ++n) {
            stringBuffer.append(" + " + this.positiveArguments.get(n));
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            stringBuffer.append("-" + this.negativeArguments.get(n));
        }
        return stringBuffer.toString();
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        int n;
        Sum sum = (Sum)expression;
        int n2 = this.positiveArguments.size() + this.negativeArguments.size();
        if (n2 < (n = sum.positiveArguments.size() + sum.positiveArguments.size())) {
            return 's';
        }
        if (n2 == n) {
            if (this.positiveArguments.size() > 0) {
                if (this.positiveArguments.size() == sum.positiveArguments.size()) {
                    for (int i = 0; i < this.positiveArguments.size(); ++i) {
                        Expression expression2 = this.positiveArguments.get(i);
                        Expression expression3 = sum.positiveArguments.get(i);
                        if (expression2.getType() == expression3.getType()) {
                            char c = expression2.isSmallerThanSameType(expression3);
                            if (c == 'e') continue;
                            return c;
                        }
                        return expression2.getType() < expression3.getType() ? (char)'s' : 'g';
                    }
                    return 'e';
                }
                return this.positiveArguments.size() > sum.positiveArguments.size() ? (char)'s' : 'g';
            }
            if (sum.positiveArguments.size() > 0) {
                return 'g';
            }
            for (int i = 0; i < this.negativeArguments.size(); ++i) {
                Expression expression4 = this.negativeArguments.get(i);
                Expression expression5 = sum.negativeArguments.get(i);
                if (expression4.getType() == expression5.getType()) {
                    char c = expression4.isSmallerThanSameType(expression5);
                    if (c == 'e') continue;
                    return c;
                }
                return expression4.getType() < expression5.getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return 'g';
    }

    @Override
    public Expression evaluate() {
        Expression expression;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = this.positiveArguments.size() - 1; n >= 0; --n) {
            expression = this.positiveArguments.remove(n).evaluate();
            if (expression.getType() == 3) {
                if (((ArithmeticAtomExpression)expression).getConstant() == 0) continue;
                n2 += ((ArithmeticAtomExpression)expression).getConstant();
                continue;
            }
            if (expression.getType() == 0) {
                if (!((RelationalAtomExpression)expression).getBool()) continue;
                ++n2;
                continue;
            }
            this.positiveArguments.add(n, expression);
        }
        for (n = this.negativeArguments.size() - 1; n >= 0; --n) {
            expression = this.negativeArguments.remove(n).evaluate();
            if (expression.getType() == 3) {
                if (((ArithmeticAtomExpression)expression).getConstant() == 0) continue;
                n3 += ((ArithmeticAtomExpression)expression).getConstant();
                continue;
            }
            if (expression.getType() == 0) {
                if (!((RelationalAtomExpression)expression).getBool()) continue;
                ++n3;
                continue;
            }
            this.negativeArguments.add(n, expression);
        }
        n = n2 - n3;
        if (this.positiveArguments.size() == 0 && this.negativeArguments.size() == 0) {
            return new ArithmeticAtomExpression(n);
        }
        if (this.positiveArguments.size() == 0 && this.negativeArguments.size() == 1 && n == 0) {
            return new UnaryMinus(this.negativeArguments.remove(0));
        }
        if (this.positiveArguments.size() == 1 && this.negativeArguments.size() == 0 && n == 0) {
            return this.positiveArguments.remove(0);
        }
        if (n == 0) {
            for (int i = 0; i < this.positiveArguments.size(); ++i) {
                Expression expression2 = this.positiveArguments.get(i);
                int n4 = 1;
                for (int j = i + 1; j < this.positiveArguments.size(); ++j) {
                    if (((Object)this.positiveArguments.get(j)).toString().equals(((Object)expression2).toString())) {
                        this.positiveArguments.remove(j);
                        ++n4;
                        --j;
                        continue;
                    }
                    if (!(this.positiveArguments.get(j) instanceof Multiplication)) continue;
                    Multiplication multiplication = (Multiplication)this.positiveArguments.get(j);
                    ArrayList<Expression> arrayList = multiplication.getArguments();
                    if (arrayList.size() == 2) {
                        if (arrayList.get(0).getType() != 3 || !((Object)arrayList.get(1)).toString().equals(((Object)expression2).toString())) continue;
                        n4 += ((ArithmeticAtomExpression)arrayList.get(0)).getConstant();
                        this.positiveArguments.remove(j);
                        --j;
                        continue;
                    }
                    if (arrayList.size() != 3 || arrayList.get(0).getType() != 3) continue;
                    Multiplication multiplication2 = (Multiplication)multiplication.copy();
                    multiplication2.getArguments().remove(0);
                    if (!multiplication2.toString().equals(((Object)expression2).toString())) continue;
                    n4 += ((ArithmeticAtomExpression)arrayList.get(0)).getConstant();
                    this.positiveArguments.remove(j);
                    --j;
                }
                if (n4 <= true) continue;
                this.positiveArguments.add(i, new Multiplication(new Expression[]{new ArithmeticAtomExpression(n4), this.positiveArguments.remove(i)}));
            }
            if (this.positiveArguments.size() == 1 && this.negativeArguments.size() == 0) {
                return this.positiveArguments.remove(0);
            }
            return this;
        }
        if (n > 0) {
            this.positiveArguments.add(0, new ArithmeticAtomExpression(n));
            for (int i = 0; i < this.positiveArguments.size(); ++i) {
                Expression expression3 = this.positiveArguments.get(i);
                int n5 = 1;
                for (int j = i + 1; j < this.positiveArguments.size(); ++j) {
                    Multiplication multiplication;
                    ArrayList<Expression> arrayList;
                    if (((Object)this.positiveArguments.get(j)).toString().equals(((Object)expression3).toString())) {
                        this.positiveArguments.remove(j);
                        ++n5;
                        --j;
                        continue;
                    }
                    if (!(this.positiveArguments.get(j) instanceof Multiplication) || (arrayList = (multiplication = (Multiplication)this.positiveArguments.get(j)).getArguments()).size() != 2 || arrayList.get(0).getType() != 3 || !((Object)arrayList.get(1)).toString().equals(((Object)expression3).toString())) continue;
                    n5 += ((ArithmeticAtomExpression)arrayList.get(0)).getConstant();
                    this.positiveArguments.remove(j);
                    --j;
                }
                if (n5 <= true) continue;
                this.positiveArguments.add(i, new Multiplication(new Expression[]{new ArithmeticAtomExpression(n5), this.positiveArguments.remove(i)}));
            }
            return this;
        }
        this.negativeArguments.add(0, new ArithmeticAtomExpression(n - 2 * n));
        for (int i = 0; i < this.positiveArguments.size(); ++i) {
            Expression expression4 = this.positiveArguments.get(i);
            int n6 = 1;
            for (int j = i + 1; j < this.positiveArguments.size(); ++j) {
                if (!((Object)this.positiveArguments.get(j)).toString().equals(((Object)expression4).toString())) continue;
                this.positiveArguments.remove(j);
                ++n6;
                --j;
            }
            if (n6 <= true) continue;
            this.positiveArguments.add(i, new Multiplication(new Expression[]{new ArithmeticAtomExpression(n6), this.positiveArguments.remove(i)}));
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        int n;
        ArithmeticExpression arithmeticExpression;
        int n2;
        for (n2 = this.positiveArguments.size() - 1; n2 >= 0; --n2) {
            this.positiveArguments.add(n2, this.positiveArguments.remove(n2).reduceExpressionTree());
            if (this.positiveArguments.get(n2) instanceof UnaryMinus) {
                arithmeticExpression = (UnaryMinus)this.positiveArguments.remove(n2);
                this.negativeArguments.add(arithmeticExpression.getArgument());
                continue;
            }
            if (this.positiveArguments.get(n2).getType() == 200) {
                arithmeticExpression = (Sum)this.positiveArguments.remove(n2);
                for (n = ((Sum)arithmeticExpression).positiveArguments.size() - 1; n >= 0; --n) {
                    this.positiveArguments.add(((Sum)arithmeticExpression).positiveArguments.remove(n));
                }
                for (n = ((Sum)arithmeticExpression).negativeArguments.size() - 1; n >= 0; --n) {
                    this.negativeArguments.add(((Sum)arithmeticExpression).negativeArguments.remove(n));
                }
                continue;
            }
            if (this.positiveArguments.get(n2).getType() != 40) continue;
            this.negativeArguments.add(((UnaryMinus)this.positiveArguments.remove(n2)).getArgument());
        }
        for (n2 = this.negativeArguments.size() - 1; n2 >= 0; --n2) {
            this.negativeArguments.add(n2, this.negativeArguments.remove(n2).reduceExpressionTree());
            if (this.negativeArguments.get(n2).getType() == 200) {
                arithmeticExpression = (Sum)this.negativeArguments.remove(n2);
                for (n = ((Sum)arithmeticExpression).positiveArguments.size() - 1; n >= 0; --n) {
                    this.negativeArguments.add(((Sum)arithmeticExpression).positiveArguments.remove(n));
                }
                for (n = ((Sum)arithmeticExpression).negativeArguments.size() - 1; n >= 0; --n) {
                    this.positiveArguments.add(((Sum)arithmeticExpression).negativeArguments.remove(n));
                }
                continue;
            }
            if (this.negativeArguments.get(n2).getType() != 40) continue;
            this.positiveArguments.add(((UnaryMinus)this.negativeArguments.remove(n2)).getArgument());
        }
        if (this.positiveArguments.size() == 1 && this.negativeArguments.size() == 0) {
            return this.positiveArguments.remove(0);
        }
        if (this.positiveArguments.size() == 0 && this.negativeArguments.size() == 1) {
            return new UnaryMinus(this.negativeArguments.remove(0));
        }
        return this;
    }

    @Override
    protected void print_debug(String string) {
        System.out.println("[ DEBUG sum ] " + string);
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        int n2;
        for (n2 = 0; n2 < this.positiveArguments.size(); ++n2) {
            this.positiveArguments.add(n2, this.positiveArguments.remove(n2).insertValueForVariable(n, string));
        }
        for (n2 = 0; n2 < this.negativeArguments.size(); ++n2) {
            this.negativeArguments.add(n2, this.negativeArguments.remove(n2).insertValueForVariable(n, string));
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        int n;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            this.positiveArguments.add(n, this.positiveArguments.remove(n).insertValueForVariable(bl, string));
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            this.negativeArguments.add(n, this.negativeArguments.remove(n).insertValueForVariable(bl, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        int n;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            this.positiveArguments.add(n, this.positiveArguments.remove(n).replaceVariableWithExpression(string, expression));
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            this.negativeArguments.add(n, this.negativeArguments.remove(n).replaceVariableWithExpression(string, expression));
        }
        return this;
    }

    @Override
    public Expression restructure() {
        if (this.positiveArguments.size() == 0 || this.negativeArguments.size() == 0) {
            return this;
        }
        block0: for (int i = this.positiveArguments.size() - 1; i >= 0; --i) {
            Expression expression = this.positiveArguments.get(i);
            for (int j = this.negativeArguments.size() - 1; j >= 0; --j) {
                Expression expression2 = this.negativeArguments.get(j);
                if (expression2.getType() != expression.getType() || !((Object)expression2).toString().equals(((Object)expression).toString())) continue;
                this.positiveArguments.remove(i);
                this.negativeArguments.remove(j);
                continue block0;
            }
        }
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        int n;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            this.positiveArguments.add(n, this.positiveArguments.remove(n).insertDomainForVariable(domain, string));
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            this.negativeArguments.add(n, this.negativeArguments.remove(n).insertDomainForVariable(domain, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        int n;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            this.positiveArguments.add(n, this.positiveArguments.remove(n).replaceVariableWith(variable, variable2));
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            this.negativeArguments.add(n, this.negativeArguments.remove(n).replaceVariableWith(variable, variable2));
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        int n;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            if (this.positiveArguments.get(n).isLinearExpression()) continue;
            return false;
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            if (this.negativeArguments.get(n).isLinearExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            return this.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public void setPositiveArguments(ArrayList<Expression> arrayList) {
        this.positiveArguments = arrayList;
    }

    public void setNegativeArguments(ArrayList<Expression> arrayList) {
        this.negativeArguments = arrayList;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        int n;
        for (n = 0; n < this.positiveArguments.size(); ++n) {
            this.positiveArguments.get(n).adaptIndicesForSolver(string, expressionArray);
        }
        for (n = 0; n < this.negativeArguments.size(); ++n) {
            this.negativeArguments.get(n).adaptIndicesForSolver(string, expressionArray);
        }
    }
}

