/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.BasicDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IntRange;
import translator.expression.SparseExpressionRange;

public class SparseIntRange
implements IntRange {
    private int[] sparseElements;

    public SparseIntRange(int[] nArray) {
        this.sparseElements = nArray;
    }

    public int[] getFullDomain() {
        return this.sparseElements;
    }

    public int[] getRange() {
        if (this.sparseElements.length > 1) {
            return new int[]{this.sparseElements[0], this.sparseElements[this.sparseElements.length - 1]};
        }
        return new int[]{this.sparseElements[0], this.sparseElements[0]};
    }

    public Domain copy() {
        int[] nArray = new int[this.sparseElements.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.sparseElements[i];
        }
        return new SparseIntRange(nArray);
    }

    public Expression[] getLowerAndUpperBound() {
        return new Expression[]{new ArithmeticAtomExpression(this.sparseElements[0]), new ArithmeticAtomExpression(this.sparseElements[this.sparseElements.length - 1])};
    }

    public Domain evaluate() {
        return this;
    }

    public int getType() {
        return 3;
    }

    public int getCategory() {
        return 0;
    }

    public String toString() {
        String string = "int(";
        if (this.sparseElements.length > 0) {
            string = string.concat("" + this.sparseElements[0]);
        }
        for (int i = 1; i < this.sparseElements.length; ++i) {
            string = string.concat(", " + this.sparseElements[i]);
        }
        return string + ")";
    }

    public boolean isConstantDomain() {
        return true;
    }

    public ExpressionRange toExpressionRange() {
        Expression[] expressionArray = new Expression[this.sparseElements.length];
        for (int i = 0; i < this.sparseElements.length; ++i) {
            expressionArray[i] = new ArithmeticAtomExpression(this.sparseElements[i]);
        }
        return new SparseExpressionRange(expressionArray);
    }

    public Domain insertValueForVariable(int n, String string) {
        return this;
    }

    public Domain insertValueForVariable(boolean bl, String string) {
        return this;
    }

    public Domain replaceVariableWithDomain(String string, Domain domain) {
        return this;
    }

    public Domain replaceVariableWithExpression(String string, Expression expression) {
        return this;
    }

    public char isSmallerThanSameType(BasicDomain basicDomain) {
        SparseIntRange sparseIntRange = (SparseIntRange)basicDomain;
        if (this.sparseElements.length == sparseIntRange.sparseElements.length) {
            for (int i = 0; i < this.sparseElements.length; ++i) {
                if (this.sparseElements[i] == sparseIntRange.sparseElements[i]) continue;
                return this.sparseElements[i] < sparseIntRange.sparseElements[i] ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.sparseElements.length < sparseIntRange.sparseElements.length ? (char)'s' : 'g';
    }

    public void setIntRange(int[] nArray) {
        this.sparseElements = nArray;
    }
}

