/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.BasicDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.SparseIntRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseExpressionRange
implements ExpressionRange {
    Expression[] sparseElements;

    public SparseExpressionRange(Expression[] expressionArray) {
        this.sparseElements = expressionArray;
    }

    public SparseExpressionRange(ArrayList<Expression> arrayList) {
        this.sparseElements = new Expression[arrayList.size()];
        for (int i = this.sparseElements.length - 1; i >= 0; --i) {
            this.sparseElements[i] = arrayList.remove(i);
        }
    }

    @Override
    public Domain copy() {
        Expression[] expressionArray = new Expression[this.sparseElements.length];
        for (int i = 0; i < this.sparseElements.length; ++i) {
            expressionArray[i] = this.sparseElements[i].copy();
        }
        return new SparseExpressionRange(expressionArray);
    }

    @Override
    public Domain evaluate() {
        boolean bl = true;
        for (int i = 0; i < this.sparseElements.length; ++i) {
            this.sparseElements[i] = this.sparseElements[i].evaluate();
            if (this.sparseElements[i].getType() == 3) continue;
            bl = false;
        }
        if (bl) {
            int[] nArray = new int[this.sparseElements.length];
            for (int i = 0; i < this.sparseElements.length; ++i) {
                nArray[i] = ((ArithmeticAtomExpression)this.sparseElements[i]).getConstant();
            }
            return new SparseIntRange(nArray);
        }
        return this;
    }

    @Override
    public Expression[] getLowerAndUpperBound() {
        return new Expression[]{this.sparseElements[0], this.sparseElements[this.sparseElements.length - 1]};
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.sparseElements.length; ++i) {
            if (n >= this.sparseElements[i].getCategory()) continue;
            n = this.sparseElements[i].getCategory();
        }
        return n;
    }

    @Override
    public String toString() {
        String string = "(";
        if (this.sparseElements.length > 0) {
            string = "" + ((Object)this.sparseElements[0]).toString();
        }
        for (int i = 1; i < this.sparseElements.length; ++i) {
            string = string.concat(", " + ((Object)this.sparseElements[i]).toString());
        }
        return string + ")";
    }

    @Override
    public boolean isConstantDomain() {
        return false;
    }

    @Override
    public Domain insertValueForVariable(int n, String string) {
        boolean bl = true;
        for (int i = 0; i < this.sparseElements.length; ++i) {
            this.sparseElements[i] = this.sparseElements[i].insertValueForVariable(n, string);
            if (this.sparseElements[i].getType() == 3) continue;
            bl = false;
        }
        if (bl) {
            int[] nArray = new int[this.sparseElements.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((ArithmeticAtomExpression)this.sparseElements[i]).getConstant();
            }
            return new SparseIntRange(nArray);
        }
        return this;
    }

    @Override
    public Domain insertValueForVariable(boolean bl, String string) {
        boolean bl2 = true;
        for (int i = 0; i < this.sparseElements.length; ++i) {
            this.sparseElements[i] = this.sparseElements[i].insertValueForVariable(bl, string);
            if (this.sparseElements[i].getType() == 3) continue;
            bl2 = false;
        }
        if (bl2) {
            int[] nArray = new int[this.sparseElements.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((ArithmeticAtomExpression)this.sparseElements[i]).getConstant();
            }
            return new SparseIntRange(nArray);
        }
        return this;
    }

    @Override
    public Domain replaceVariableWithDomain(String string, Domain domain) {
        for (int i = 0; i < this.sparseElements.length; ++i) {
        }
        return this;
    }

    @Override
    public Domain replaceVariableWithExpression(String string, Expression expression) throws Exception {
        for (int i = 0; i < this.sparseElements.length; ++i) {
            this.sparseElements[i] = this.sparseElements[i].replaceVariableWithExpression(string, expression);
        }
        return this;
    }

    @Override
    public char isSmallerThanSameType(BasicDomain basicDomain) {
        SparseExpressionRange sparseExpressionRange = (SparseExpressionRange)basicDomain;
        if (this.sparseElements.length == sparseExpressionRange.sparseElements.length) {
            for (int i = 0; i < this.sparseElements.length; ++i) {
                if (this.sparseElements[i].getType() == sparseExpressionRange.sparseElements[i].getType()) {
                    char c = this.sparseElements[i].isSmallerThanSameType(sparseExpressionRange.sparseElements[i]);
                    if (c == 'e') continue;
                    return c;
                }
                return this.sparseElements[i].getType() < sparseExpressionRange.sparseElements[i].getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.sparseElements.length < sparseExpressionRange.sparseElements.length ? (char)'s' : 'g';
    }

    public Expression[] getExpressionRange() {
        return this.sparseElements;
    }

    public void setExpressionRange(Expression[] expressionArray) {
        this.sparseElements = expressionArray;
    }
}

