/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.RelationalAtomExpression;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleVariable
implements Variable {
    private String variableName;
    private Domain domain;
    private boolean isSearchVariable;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public SingleVariable(String string, Domain domain) {
        this.variableName = string;
        this.domain = domain.evaluate();
        this.isSearchVariable = true;
    }

    @Override
    public boolean isQuantified() {
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return new ArrayList<Expression>();
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public boolean isSearchVariable() {
        return this.isSearchVariable;
    }

    @Override
    public void setIsSearchVariable(boolean bl) {
        this.isSearchVariable = bl;
    }

    @Override
    public Expression copy() {
        String string = new String(this.variableName);
        return new SingleVariable(string, this.domain.copy());
    }

    @Override
    public int[] getDomain() {
        if (this.domain instanceof ConstantDomain) {
            return ((ConstantDomain)this.domain).getRange();
        }
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.domain instanceof ConstantDomain) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[0]), new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[1])};
        }
        if (this.domain instanceof ExpressionRange) {
            return ((ExpressionRange)this.domain).getLowerAndUpperBound();
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public String toString() {
        return this.variableName;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        SingleVariable singleVariable = (SingleVariable)expression;
        if (this.variableName.length() == singleVariable.variableName.length()) {
            int n = this.variableName.compareTo(singleVariable.variableName);
            if (n == 0) {
                return 'e';
            }
            return n < 0 ? (char)'s' : 'g';
        }
        return this.variableName.length() < singleVariable.variableName.length() ? (char)'s' : 'g';
    }

    @Override
    public Variable evaluate() {
        if (this.domain != null) {
            this.domain = this.domain.evaluate();
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.variableName.equals(string)) {
            return new ArithmeticAtomExpression(n);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.variableName.equals(string)) {
            return new RelationalAtomExpression(bl);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.variableName.equals(string)) {
            return expression;
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        return this;
    }

    public boolean isBooleanVariable() {
        return this.domain.getType() == 0;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.variableName.equals(variable.getVariableName())) {
            return variable2;
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            return this.toSolverExpression(targetSolver);
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
    }

    public Domain getExplicitDomain() {
        return this.domain;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }
}

