/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.BasicDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.SingleExpressionRange;
import translator.expression.SingleRange;

public class SingleIntRange
implements ConstantDomain,
SingleRange {
    private int value;

    public SingleIntRange(int n) {
        this.value = n;
    }

    public int[] getFullDomain() {
        return new int[]{this.value};
    }

    public int[] getRange() {
        return new int[]{this.value, this.value};
    }

    public Expression[] getLowerAndUpperBound() {
        return new Expression[]{new ArithmeticAtomExpression(this.value), new ArithmeticAtomExpression(this.value)};
    }

    public Expression getSingleExpressionRange() {
        return new ArithmeticAtomExpression(this.value);
    }

    public char isSmallerThanSameType(BasicDomain basicDomain) {
        SingleIntRange singleIntRange = (SingleIntRange)basicDomain;
        if (this.value == singleIntRange.value) {
            return 'e';
        }
        return this.value == singleIntRange.value ? (char)'s' : 'g';
    }

    public Domain copy() {
        return new SingleIntRange(this.value);
    }

    public Domain evaluate() {
        return this;
    }

    public int getType() {
        return 1;
    }

    public int getCategory() {
        return 0;
    }

    public Domain insertValueForVariable(int n, String string) {
        return this;
    }

    public Domain insertValueForVariable(boolean bl, String string) {
        return this;
    }

    public Domain replaceVariableWithDomain(String string, Domain domain) {
        return this;
    }

    public Domain replaceVariableWithExpression(String string, Expression expression) {
        return this;
    }

    public boolean isConstantDomain() {
        return true;
    }

    public String toString() {
        return this.value + "";
    }

    public SingleRange setSingleExpressionRange(Expression expression) {
        if (expression.getType() == 3) {
            this.value = ((ArithmeticAtomExpression)expression).getConstant();
            return this;
        }
        return new SingleExpressionRange(expression);
    }

    public int getSingleRange() {
        return this.value;
    }
}

