/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.AtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BoolDomain;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.RelationalAtomExpression;
import translator.expression.SimpleArray;
import translator.expression.SingleVariable;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVariable
implements Variable,
AtomExpression {
    private String variableName;
    private boolean isSearchVariable;
    private int lb;
    private int ub;

    public SimpleVariable(String string) {
        this.variableName = string;
        this.lb = -100000;
        this.ub = 100000;
    }

    @Override
    public boolean isQuantified() {
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return new ArrayList<Expression>();
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public boolean isSearchVariable() {
        return this.isSearchVariable;
    }

    @Override
    public void setIsSearchVariable(boolean bl) {
        this.isSearchVariable = bl;
    }

    @Override
    public Expression copy() {
        return new SimpleVariable(new String(this.variableName));
    }

    @Override
    public Expression evaluate() {
        return this;
    }

    @Override
    public Variable getVariable() {
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{this.lb, this.ub};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(this.lb), new ArithmeticAtomExpression(this.ub)};
    }

    public void setDomain(int n, int n2) {
        this.lb = n;
        this.ub = n2;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        if (this.variableName.equals(string)) {
            if (domain instanceof BoolDomain) {
                return new RelationalAtomExpression(new SingleVariable(this.variableName, domain));
            }
            if (domain instanceof ArrayDomain) {
                ArrayDomain arrayDomain = (ArrayDomain)domain;
                Domain[] domainArray = arrayDomain.getIndexDomains();
                BasicDomain[] basicDomainArray = new BasicDomain[arrayDomain.getIndexDomains().length];
                for (int i = 0; i < basicDomainArray.length; ++i) {
                    try {
                        if (!(domainArray[i] instanceof BasicDomain)) {
                            throw new Exception("Infeasible array domain: " + domain + ". Cannot use domain '" + domainArray[i] + "' as an index domain. Expected a range or identifier.");
                        }
                        basicDomainArray[i] = (BasicDomain)domainArray[i];
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                        System.exit(1);
                    }
                }
                return new SimpleArray(this.variableName, basicDomainArray, arrayDomain.getBaseDomain());
            }
            if (domain instanceof ConstantArrayDomain) {
                ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)domain;
                ConstantDomain[] constantDomainArray = constantArrayDomain.getIndexDomains();
                BasicDomain[] basicDomainArray = new BasicDomain[constantArrayDomain.getIndexDomains().length];
                for (int i = 0; i < basicDomainArray.length; ++i) {
                    try {
                        if (!(constantDomainArray[i] instanceof BasicDomain)) {
                            throw new Exception("Infeasible array domain: " + domain + ". Cannot use domain '" + constantDomainArray[i] + "' as an index domain. Expected a range or identifier.");
                        }
                        basicDomainArray[i] = constantDomainArray[i];
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                        System.exit(1);
                    }
                }
                return new SimpleArray(this.variableName, basicDomainArray, constantArrayDomain.getBaseDomain());
            }
            return new ArithmeticAtomExpression(new SingleVariable(this.variableName, domain));
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.variableName.equals(string)) {
            return new ArithmeticAtomExpression(n);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.variableName.equals(string)) {
            return expression;
        }
        return this;
    }

    public Expression replaceVariableName(String string, String string2) {
        if (this.variableName.equals(string)) {
            this.variableName = string2;
        }
        return this;
    }

    public SingleVariable convertToSingleVariable(Domain domain) {
        return new SingleVariable(this.variableName, domain);
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.variableName.equals(string)) {
            return new RelationalAtomExpression(bl);
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return true;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public void setIsParameter(boolean bl) {
    }

    @Override
    public boolean isQuantifiedVariable() {
        return false;
    }

    @Override
    public void setIsQuantifiedVariable(boolean bl) {
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        SimpleVariable simpleVariable = (SimpleVariable)expression;
        int n = simpleVariable.getVariableName().compareTo(this.variableName);
        if (n < 0) {
            return 'g';
        }
        if (n > 0) {
            return 's';
        }
        return 'e';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.variableName.equals(variable.getVariableName())) {
            return variable2;
        }
        return this;
    }

    @Override
    public String toString() {
        return this.variableName;
    }

    @Override
    public boolean isLinearExpression() {
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            return this.toSolverExpression(targetSolver);
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void setVariable(Variable variable) {
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public void setIsNegated(boolean bl) {
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
    }
}

