/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayVariable;
import translator.expression.AtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BoolDomain;
import translator.expression.BoundedExpressionRange;
import translator.expression.BoundedIntRange;
import translator.expression.ConstantArray;
import translator.expression.ConstantMatrix;
import translator.expression.ConstantVector;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IndexedArray;
import translator.expression.InfiniteDomain;
import translator.expression.MatrixDomain;
import translator.expression.RelationalAtomExpression;
import translator.expression.SingleExpressionRange;
import translator.expression.SingleIntRange;
import translator.expression.SingleRange;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleArrayVariable
implements Variable,
AtomExpression {
    private String arrayName;
    private ArrayList<Domain> indices;
    private boolean isSearchVariable = false;
    private boolean willBeFlattened = true;
    private boolean isNested = true;

    public SimpleArrayVariable(String string, ArrayList<Domain> arrayList) {
        this.arrayName = string;
        this.indices = arrayList;
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.indices.size(); ++i) {
            ExpressionRange expressionRange;
            if (!(this.indices.get(i) instanceof ExpressionRange) || !(expressionRange = (ExpressionRange)this.indices.get(i)).getLowerAndUpperBound()[0].isQuantified() && !expressionRange.getLowerAndUpperBound()[1].isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return new ArrayList<Expression>();
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public String getVariableName() {
        return this.arrayName;
    }

    @Override
    public boolean isSearchVariable() {
        return this.isSearchVariable;
    }

    @Override
    public void setIsSearchVariable(boolean bl) {
        this.isSearchVariable = bl;
    }

    @Override
    public Expression copy() {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (int i = 0; i < this.indices.size(); ++i) {
            arrayList.add(i, this.indices.get(i).copy());
        }
        return new SimpleArrayVariable(new String(this.arrayName), arrayList);
    }

    @Override
    public Expression evaluate() {
        for (int i = 0; i < this.indices.size(); ++i) {
            this.indices.add(i, this.indices.remove(i).evaluate());
        }
        return this;
    }

    @Override
    public Variable getVariable() {
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        for (int i = 0; i < this.indices.size(); ++i) {
            if (!(this.indices.get(i) instanceof SingleExpressionRange)) continue;
            Expression expression = ((SingleExpressionRange)this.indices.remove(i)).getSingleExpressionRange();
            expression = expression.insertDomainForVariable(domain, string);
            this.indices.add(i, new SingleExpressionRange(expression));
        }
        if (this.arrayName.equals(string)) {
            if (!(domain instanceof MatrixDomain)) {
                throw new Exception("Infeasible variable indexing: " + this + ". The variable has not been declared of type matrix domain, but:" + domain);
            }
            MatrixDomain matrixDomain = (MatrixDomain)domain;
            if (this.indices.size() != matrixDomain.getIndexDomains().length) {
                throw new Exception("Infeasible variable indexing: " + this + ". Only " + this.indices.size() + " indices have been defined while " + matrixDomain.getIndexDomains().length + " have been declared in domain " + matrixDomain + ". Please specify an index (range) for every defined index.");
            }
            boolean bl = true;
            boolean bl2 = true;
            for (int i = this.indices.size() - 1; i >= 0; --i) {
                Domain domain2 = this.indices.get(i);
                domain2 = this.indices.remove(i).evaluate();
                if (!(domain2 instanceof SingleIntRange)) {
                    bl = false;
                }
                if (!(domain2 instanceof SingleRange)) {
                    bl2 = false;
                }
                if (!(domain2 instanceof BasicDomain)) {
                    throw new Exception("Cannot translate array element '" + this + "' that is indexed by :" + domain2 + ". Expected an integer, expression, or range.");
                }
                this.indices.add(i, domain2);
            }
            if (bl) {
                int[] nArray = new int[this.indices.size()];
                for (int i = nArray.length - 1; i >= 0; --i) {
                    nArray[i] = ((SingleIntRange)this.indices.remove(i)).getSingleRange();
                }
                if (matrixDomain.getBaseDomain() instanceof BoolDomain) {
                    return new RelationalAtomExpression(new ArrayVariable(this.arrayName, nArray, domain));
                }
                return new ArithmeticAtomExpression(new ArrayVariable(this.arrayName, nArray, domain));
            }
            if (bl2) {
                Expression[] expressionArray = new Expression[this.indices.size()];
                for (int i = expressionArray.length - 1; i >= 0; --i) {
                    expressionArray[i] = ((SingleRange)this.indices.remove(i)).getSingleExpressionRange();
                }
                if (matrixDomain.getBaseDomain() instanceof BoolDomain) {
                    return new RelationalAtomExpression(new ArrayVariable(this.arrayName, expressionArray, domain));
                }
                return new ArithmeticAtomExpression(new ArrayVariable(this.arrayName, expressionArray, domain));
            }
            BasicDomain[] basicDomainArray = new BasicDomain[this.indices.size()];
            for (int i = basicDomainArray.length - 1; i >= 0; --i) {
                BasicDomain basicDomain = (BasicDomain)this.indices.remove(i);
                if (basicDomain instanceof InfiniteDomain) {
                    Expression expression;
                    Expression expression2;
                    InfiniteDomain infiniteDomain = (InfiniteDomain)basicDomain;
                    if (infiniteDomain.getType() == 22) {
                        basicDomainArray[i] = (BasicDomain)matrixDomain.getIndexDomains()[i];
                        continue;
                    }
                    if (!(matrixDomain.getIndexDomains()[i] instanceof ExpressionRange)) {
                        throw new Exception("Infeasible index domain " + matrixDomain.getIndexDomains()[i] + " declared for:" + this);
                    }
                    ExpressionRange expressionRange = (ExpressionRange)matrixDomain.getIndexDomains()[i];
                    if (infiniteDomain.getType() == 20) {
                        expression2 = infiniteDomain.getUpperBound();
                        expression = expressionRange.getLowerAndUpperBound()[0];
                    } else {
                        expression = infiniteDomain.getLowerBound();
                        expression2 = expressionRange.getLowerAndUpperBound()[1];
                    }
                    if (expression.getType() == 3 && expression2.getType() == 3) {
                        basicDomainArray[i] = new BoundedIntRange(((ArithmeticAtomExpression)expression).getConstant(), ((ArithmeticAtomExpression)expression2).getConstant());
                        continue;
                    }
                    basicDomainArray[i] = new BoundedExpressionRange(expression, expression2);
                    continue;
                }
                basicDomainArray[i] = basicDomain;
            }
            return new IndexedArray(this.arrayName, basicDomainArray, domain);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.indices.size(); ++i) {
            this.indices.add(i, this.indices.remove(i).insertValueForVariable(n, string));
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.arrayName.equals(string)) {
            Object object;
            if (!(expression instanceof ConstantArray)) {
                return expression;
            }
            ConstantArray constantArray = (ConstantArray)expression;
            if (constantArray.getDimension() != this.indices.size()) {
                throw new Exception("I cannot match a constant value from constant array " + string + " to variable " + this + ",\n because the dimensions don't match: " + this + " is " + this.indices.size() + "-dimensionial and " + expression + " is " + constantArray.getDimension() + "-dimensionial.");
            }
            boolean bl = true;
            boolean bl2 = true;
            for (int i = this.indices.size() - 1; i >= 0; --i) {
                object = this.indices.get(i);
                object = this.indices.remove(i).evaluate();
                if (!(object instanceof SingleIntRange)) {
                    bl = false;
                }
                if (!(object instanceof SingleRange)) {
                    bl2 = false;
                }
                if (!(object instanceof BasicDomain)) {
                    throw new Exception("Cannot translate array element '" + this + "' that is indexed by :" + object + ". Expected an integer, expression, or range.");
                }
                this.indices.add(i, (Domain)object);
            }
            if (bl) {
                int[] nArray = new int[this.indices.size()];
                for (int i = nArray.length - 1; i >= 0; --i) {
                    nArray[i] = ((SingleIntRange)this.indices.remove(i)).getSingleRange();
                }
                if (constantArray.getArrayDomain() != null && !(constantArray.getArrayDomain() instanceof MatrixDomain)) {
                    throw new Exception("Infeasible domain for constant array " + string + ": " + constantArray.getArrayDomain() + ".\nExpected an array domain.");
                }
                object = constantArray.getIndexOffsets();
                if (((Object)object).length > 0) {
                    if (((Object)object).length != nArray.length) {
                        throw new Exception("Domains of constant array element " + this + " and constant array " + string + " don't match.\n" + this + " is " + nArray.length + "-dimensional and " + string + " is defined as " + ((Object)object).length + "-dimensional.");
                    }
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        nArray[i] = nArray[i] - object[i];
                    }
                }
                if (constantArray instanceof ConstantVector) {
                    return new ArithmeticAtomExpression(((ConstantVector)constantArray).getElementAt(nArray[0]));
                }
                if (constantArray instanceof ConstantMatrix) {
                    return new ArithmeticAtomExpression(((ConstantMatrix)constantArray).getElementAt(nArray[0], nArray[1]));
                }
            }
            if (bl2) {
                Expression[] expressionArray = new Expression[this.indices.size()];
                for (int i = expressionArray.length - 1; i >= 0; --i) {
                    expressionArray[i] = ((SingleRange)this.indices.remove(i)).getSingleExpressionRange();
                }
                return new ArithmeticAtomExpression(new ArrayVariable(this.arrayName, expressionArray, constantArray.getArrayDomain()));
            }
            throw new Exception("Cannot translate indexing constant arrays with integer ranges, as in " + expression + " yet, sorry.");
        }
        for (int i = 0; i < this.indices.size(); ++i) {
            this.indices.add(i, this.indices.remove(i).replaceVariableWithExpression(string, expression));
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattened;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public void setIsParameter(boolean bl) {
    }

    @Override
    public boolean isQuantifiedVariable() {
        return false;
    }

    @Override
    public void setIsQuantifiedVariable(boolean bl) {
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return '\u0000';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattened = bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.arrayName + "[");
        if (this.indices.size() > 0) {
            for (int i = 0; i < this.indices.size() - 1; ++i) {
                stringBuffer.append(this.indices.get(i) + ",");
            }
            stringBuffer.append(this.indices.get(this.indices.size() - 1));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean isLinearExpression() {
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            for (int i = 0; i < this.indices.size(); ++i) {
                if (this.indices.get(i).getType() == 3 && this.indices.get(i).getType() == 0) continue;
                throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
            }
            return this.toSolverExpression(targetSolver);
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
    }

    public ArrayList<Domain> getIndices() {
        return this.indices;
    }

    @Override
    public void setVariable(Variable variable) {
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public void setIsNegated(boolean bl) {
    }
}

