/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.BasicDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IdentifierDomain;
import translator.expression.SingleArray;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleArray
implements SingleArray {
    private String arrayName;
    private Domain baseDomain;
    private BasicDomain[] indexDomains;
    private boolean willBeFlattenedToVariable = false;
    private boolean isNested = true;
    private boolean willBeFlattenedToVector = false;

    public SimpleArray(String string, BasicDomain[] basicDomainArray, Domain domain) {
        this.arrayName = string;
        this.baseDomain = domain;
        this.indexDomains = basicDomainArray;
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.indexDomains.length; ++i) {
            ExpressionRange expressionRange;
            if (!(this.indexDomains[i] instanceof ExpressionRange) || !(expressionRange = (ExpressionRange)this.indexDomains[i]).getLowerAndUpperBound()[0].isQuantified() && !expressionRange.getLowerAndUpperBound()[1].isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return new ArrayList<Expression>();
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public String getArrayName() {
        return this.arrayName;
    }

    @Override
    public Domain getBaseDomain() {
        return this.baseDomain;
    }

    public BasicDomain[] getIndexDomains() {
        return this.indexDomains;
    }

    @Override
    public Expression copy() {
        BasicDomain[] basicDomainArray = new BasicDomain[this.indexDomains.length];
        for (int i = 0; i < basicDomainArray.length; ++i) {
            basicDomainArray[i] = (BasicDomain)this.indexDomains[i].copy();
        }
        return new SimpleArray(new String(this.arrayName), basicDomainArray, this.baseDomain.copy());
    }

    @Override
    public Expression evaluate() {
        this.baseDomain = this.baseDomain.evaluate();
        for (int i = 0; i < this.indexDomains.length; ++i) {
            this.indexDomains[i] = (BasicDomain)this.indexDomains[i].evaluate();
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        if (this.baseDomain instanceof ConstantDomain) {
            return ((ConstantDomain)this.baseDomain).getRange();
        }
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.baseDomain instanceof ConstantDomain) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(((ConstantDomain)this.baseDomain).getRange()[0]), new ArithmeticAtomExpression(((ConstantDomain)this.baseDomain).getRange()[1])};
        }
        if (this.baseDomain instanceof ExpressionRange) {
            return ((ExpressionRange)this.baseDomain).getLowerAndUpperBound();
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 26;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.indexDomains.length; ++i) {
            if (n >= this.indexDomains[i].getCategory()) continue;
            n = this.indexDomains[i].getCategory();
        }
        if (this.baseDomain.getCategory() > n) {
            return this.baseDomain.getCategory();
        }
        return n;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.baseDomain = this.baseDomain.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.arrayName.equals(string)) {
            return expression;
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        SimpleArray simpleArray = (SimpleArray)expression;
        int n = this.arrayName.compareTo(simpleArray.arrayName);
        if (n == 0) {
            return 'e';
        }
        return n < 0 ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        String string2;
        if (this.baseDomain instanceof IdentifierDomain && (string2 = ((IdentifierDomain)this.baseDomain).getDomainName()).equals(string)) {
            this.baseDomain = domain;
        }
        for (int i = 0; i < this.indexDomains.length; ++i) {
            String string3;
            if (!(this.indexDomains[i] instanceof IdentifierDomain) || !(string3 = ((IdentifierDomain)this.indexDomains[i]).getDomainName()).equals(string) || !(domain instanceof BasicDomain)) continue;
            this.indexDomains[i] = (BasicDomain)domain;
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public String toString() {
        return this.arrayName;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
    }

    public boolean willBeFlattenedToVector() {
        return this.willBeFlattenedToVector;
    }

    public void setWillBeFlattenedToVector(boolean bl) {
        this.willBeFlattenedToVector = bl;
    }
}

