/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayVariable;
import translator.expression.AtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.RelationalExpression;
import translator.expression.SingleVariable;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalAtomExpression
implements RelationalExpression,
AtomExpression {
    private boolean bool;
    private Variable variable;
    private boolean isParameter = false;
    private boolean isQuantifiedVariable = false;
    private boolean isNested = true;
    private boolean willBeReified = false;
    private boolean isNegated = false;

    public RelationalAtomExpression(boolean bl) {
        this.bool = bl;
        this.variable = null;
        this.isParameter = false;
    }

    public RelationalAtomExpression(Variable variable) {
        this.variable = variable;
        this.isParameter = false;
    }

    public RelationalAtomExpression(Variable variable, boolean bl) {
        this.variable = variable;
        this.isParameter = bl;
    }

    @Override
    public boolean isQuantified() {
        if (this.variable == null) {
            return false;
        }
        return this.variable.isQuantified() || this.isQuantifiedVariable;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        if (this.variable == null) {
            return new ArrayList<Expression>();
        }
        if (this.isQuantifiedVariable) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(this);
            return arrayList;
        }
        return this.variable.getQuantifyingVariables();
    }

    public ArithmeticAtomExpression toArithmeticExpression() {
        ArithmeticAtomExpression arithmeticAtomExpression = this.variable == null ? (this.bool ? new ArithmeticAtomExpression(1) : new ArithmeticAtomExpression(0)) : new ArithmeticAtomExpression(this.variable);
        arithmeticAtomExpression.setIsQuantifiedVariable(this.isQuantifiedVariable);
        arithmeticAtomExpression.setIsParameter(this.isParameter);
        arithmeticAtomExpression.setIsNegated(this.isNegated);
        return arithmeticAtomExpression;
    }

    @Override
    public Expression copy() {
        RelationalAtomExpression relationalAtomExpression = this.variable == null ? new RelationalAtomExpression(this.bool) : new RelationalAtomExpression((Variable)this.variable.copy());
        relationalAtomExpression.setIsParameter(this.isParameter);
        relationalAtomExpression.setIsQuantifiedVariable(this.isQuantifiedVariable);
        return relationalAtomExpression;
    }

    @Override
    public int[] getDomain() {
        if (this.variable == null) {
            int[] nArray;
            if (this.bool) {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = 1;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = 0;
                nArray = nArray3;
                nArray3[1] = 0;
            }
            return nArray;
        }
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.variable == null) {
            Expression[] expressionArray;
            if (this.bool) {
                Expression[] expressionArray2 = new ArithmeticAtomExpression[2];
                expressionArray2[0] = new ArithmeticAtomExpression(1);
                expressionArray = expressionArray2;
                expressionArray2[1] = new ArithmeticAtomExpression(1);
            } else {
                ArithmeticAtomExpression[] arithmeticAtomExpressionArray = new ArithmeticAtomExpression[2];
                arithmeticAtomExpressionArray[0] = new ArithmeticAtomExpression(0);
                expressionArray = arithmeticAtomExpressionArray;
                arithmeticAtomExpressionArray[1] = new ArithmeticAtomExpression(0);
            }
            return expressionArray;
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        if (this.variable == null) {
            return 0;
        }
        return this.variable.getType() == 14 ? 6 : 5;
    }

    @Override
    public int getCategory() {
        if (this.variable == null) {
            return 0;
        }
        if (this.isParameter) {
            return 1;
        }
        if (this.isQuantifiedVariable) {
            return 2;
        }
        return this.variable.getCategory();
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public String toString() {
        if (this.variable == null) {
            return this.bool ? "true" : "false";
        }
        return (this.isNegated ? "!" : "") + this.variable.toString();
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        RelationalAtomExpression relationalAtomExpression = (RelationalAtomExpression)expression;
        if (this.variable == null) {
            if (this.bool == relationalAtomExpression.bool) {
                return 'e';
            }
            return !this.bool & relationalAtomExpression.bool ? (char)'s' : 'g';
        }
        if (this.variable.getType() == relationalAtomExpression.variable.getType()) {
            return this.variable.isSmallerThanSameType(relationalAtomExpression.variable);
        }
        return this.variable.getType() < relationalAtomExpression.variable.getType() ? (char)'s' : 'g';
    }

    @Override
    public RelationalAtomExpression evaluate() {
        if (this.variable != null) {
            this.variable = (Variable)this.variable.evaluate();
        }
        return this;
    }

    @Override
    public RelationalAtomExpression reduceExpressionTree() {
        return this;
    }

    public boolean getBool() {
        return this.bool;
    }

    @Override
    public Variable getVariable() {
        return this.variable;
    }

    @Override
    public boolean isParameter() {
        return this.isParameter;
    }

    @Override
    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    @Override
    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVariable;
    }

    @Override
    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVariable = bl;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.variable != null) {
            this.variable = (Variable)this.variable.insertValueForVariable(n, string);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.variable != null) {
            if (this.variable instanceof SingleVariable) {
                Expression expression = this.variable.insertValueForVariable(bl, string);
                if (expression.getType() == 0) {
                    return (RelationalAtomExpression)expression;
                }
                return this;
            }
            this.variable = (Variable)this.variable.insertValueForVariable(bl, string);
            this.variable.evaluate();
            return this;
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.variable != null) {
            Expression expression2 = this.variable.replaceVariableWithExpression(string, expression);
            if (!(expression2 instanceof Variable)) {
                return expression2;
            }
            this.variable = (Variable)expression2;
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.variable != null && this.variable.getVariableName().equals(variable.getVariableName())) {
            this.variable = variable2;
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            if (this.variable instanceof ArrayVariable && ((ArrayVariable)this.variable).isIndexedBySomethingNotConstant()) {
                throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
            }
            return this.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void setIsNegated(boolean bl) {
        this.isNegated = bl;
    }

    @Override
    public boolean isNegated() {
        return this.isNegated;
    }

    @Override
    public void setVariable(Variable variable) {
        if (this.variable != null) {
            this.variable = variable;
        }
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.variable != null) {
            this.variable.adaptIndicesForSolver(string, expressionArray);
        }
    }
}

