/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.NonCommutativeRelationalBinaryExpression;
import translator.expression.RelationalAtomExpression;
import translator.expression.RelationalExpression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reification
implements RelationalExpression {
    private Expression reifiedExpression;
    private RelationalAtomExpression reifiedVariable;
    private boolean isReifyImply = false;
    boolean isNested = true;
    boolean willBeReified = false;

    public Reification(Expression expression, RelationalAtomExpression relationalAtomExpression) {
        this.reifiedVariable = relationalAtomExpression;
        this.reifiedExpression = expression;
    }

    @Override
    public boolean isQuantified() {
        return this.reifiedExpression.isQuantified() || this.reifiedVariable.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.reifiedExpression.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.reifiedVariable.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    public void setIsReifyImplied(boolean bl) {
        this.isReifyImply = bl;
    }

    public boolean getIsReifyImplied() {
        return this.isReifyImply;
    }

    @Override
    public Expression copy() {
        Reification reification = new Reification(this.reifiedExpression.copy(), (RelationalAtomExpression)this.reifiedVariable.copy());
        reification.setIsReifyImplied(this.isReifyImply);
        return reification;
    }

    @Override
    public Expression evaluate() {
        this.reifiedExpression = this.reifiedExpression.evaluate();
        if (this.reifiedVariable.getType() == 0) {
            if (this.reifiedVariable.getBool()) {
                return this.reifiedExpression;
            }
            if (this.reifiedExpression instanceof CommutativeBinaryRelationalExpression) {
                return ((CommutativeBinaryRelationalExpression)this.reifiedExpression).invertExpression();
            }
            if (this.reifiedExpression instanceof NonCommutativeRelationalBinaryExpression) {
                return ((NonCommutativeRelationalBinaryExpression)this.reifiedExpression).invertExpression();
            }
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        if (this.isReifyImply) {
            return 777;
        }
        return 250;
    }

    @Override
    public int getCategory() {
        return Math.max(this.reifiedExpression.getCategory(), this.reifiedVariable.getCategory());
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.reifiedExpression = this.reifiedExpression.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.reifiedExpression = this.reifiedExpression.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.reifiedExpression = this.reifiedExpression.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        Reification reification = (Reification)expression;
        if (this.reifiedExpression.getType() == reification.reifiedExpression.getType()) {
            char c = this.reifiedExpression.isSmallerThanSameType(reification.reifiedExpression);
            if (c == 'e') {
                if (this.reifiedVariable.getType() == reification.reifiedVariable.getType()) {
                    return this.reifiedVariable.isSmallerThanSameType(reification.reifiedVariable);
                }
                return this.reifiedVariable.getType() < reification.reifiedVariable.getType() ? (char)'s' : 'g';
            }
            return c;
        }
        return this.reifiedExpression.getType() < reification.reifiedExpression.getType() ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
        this.reifiedExpression.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        this.reifiedExpression = this.reifiedExpression.reduceExpressionTree();
        if (this.reifiedVariable.getType() == 0 && this.reifiedVariable.getBool()) {
            return this.reifiedExpression;
        }
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.reifiedVariable.toString());
        stringBuffer.append(this.isReifyImply ? " => " : " <=> ");
        stringBuffer.append("(" + ((Object)this.reifiedExpression).toString() + ")");
        return stringBuffer.toString();
    }

    @Override
    public Expression restructure() {
        this.reifiedExpression = this.reifiedExpression.restructure();
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.reifiedExpression = this.reifiedExpression.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.reifiedExpression = this.reifiedExpression.replaceVariableWith(variable, variable2);
        if (this.reifiedVariable.getVariable().getVariableName().equals(variable.getVariableName())) {
            this.reifiedVariable = new RelationalAtomExpression(variable2);
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.reifiedExpression.adaptIndicesForSolver(string, expressionArray);
    }

    public Expression getReifiedConstraint() {
        return this.reifiedExpression;
    }

    public RelationalAtomExpression getReifiedVariable() {
        return this.reifiedVariable;
    }

    public void setReifiedVariable(RelationalAtomExpression relationalAtomExpression) {
        this.reifiedVariable = relationalAtomExpression;
    }
}

